//###############################################
//#####-------------------------------------#####
//#####----------FILTER & SORT -------------#####
//#####-------------------------------------#####
//###############################################
function setBackgroundColor (item, color) {
  // item.style.backgroundColor = "";
  item.style.backgroundColor = "";
}

function createSortHook (tableReference, cellReference, cellPosition,
                         spectool2Element, viewName, tableStatus) {
  // hookTable4Sort (bodyName, tableStatusName, dataSourceName, viewName, sortPos)
  cellReference.setAttribute ("onclick", "hookTable4Sort (\""
      + tableReference.id + "\", \"" + tableStatus.id + "\", \""
      + spectool2Element.jsName + "\", \"" + viewName + "\", "
      + cellPosition.toString () + ")");
  cellReference.setAttribute ("onmouseover", "this.style.backgroundColor = \"LightGoldenRodYellow\";");
  cellReference.setAttribute ("onmouseout", "this.style.backgroundColor = \"\";");
}

function createSortableHeader (tableReference, headerCellNames, spectool2Element, viewName, tableStatus) {
  // console.log ("spectool2Element.jsName="+spectool2Element.jsName);
  var body = tableReference;
  var row = document.createElement ("tr");
  for (pos in headerCellNames) {
    var cell = document.createElement ("th");
    cell.className = tableStatus.sortClassNames [pos];
    cell.innerHTML = headerCellNames [pos];
    if (tableStatus.sortEnabled [pos] === true) {
      // hookTable4Sort (bodyName, tableStatusName, dataSourceName, viewName, sortPos)
      cell.setAttribute ("onclick", "hookTable4Sort (\"" + body.id + "\", \""
          + tableStatus.id + "\", \""
          + spectool2Element.jsName + "\", \"" + viewName + "\", "
          + pos.toString () + ")");
      cell.setAttribute ("onmouseover", "this.style.backgroundColor = \"LightGoldenRodYellow\";");
      cell.setAttribute ("onmouseout", "this.style.backgroundColor = \"\";");
    }
    row.appendChild (cell);
  }
  body.appendChild (row);
}

function createFilterInput (tableReference, dataSource, viewName, tableStatus) {
  var input;
  var row = document.createElement ("tr");
  row.id = "filterRow" + Math.ceil (Math.random () * 1000).toString ();
  //console.log ("viewName="+viewName);
  //console.log ("dataSource="+dataSource);
  tableStatus.filterRowId = row.id;
  // console.log ("row.id="+row.id);
  //console.log ("tableReference="+tableReference+" dataSourceName="+dataSource.jsName+" viewName="+viewName+" tableStatus="+tableStatus);
  for (pos in tableStatus.filterEnabled) {
    var cell = document.createElement ("td");
    cell.className = tableStatus.filterClassNames [pos];
    if (tableStatus.filterEnabled [pos] === true) {
      input = document.createElement ("input");
      input.type = "text";
      input.display = "block";
      // hookTable4Filter (bodyName, tableStatusName, dataSourceName, viewName, filterPos)
      //input.setAttribute ("onkeyup", "hookTable4Filter (\"" + tableReference.id + "\", \"" // ==> onkeyup fires on the fly
      input.setAttribute ("onchange", "hookTable4Filter (\"" + tableReference.id + "\", \"" // ==> onchange requires "enter"
          + tableStatus.id + "\", \"" + dataSource.jsName + "\", \"" + viewName + "\", "
          + pos.toString () + ", this)");
      cell.appendChild (input);
    }
    row.appendChild (cell);
  }
  tableReference.appendChild (row);
}

/*
 * function refreshFilterInput (tableReference, filterRow, fieldsTableStatus) {
 * var row = filterRow; for (var i=0; i<row.cells.length; i++) { if
 * (row.cells[i].childNodes[0]!==undefined) { row.cells[i].childNodes[0].id =
 * ""; } } globalFocusOnElement =
 * "focusThisElement"+Math.ceil(Math.random()*1000).toString();
 * row.cells[fieldsTableStatus.currentFilterPos].childNodes[0].id =
 * globalFocusOnElement; window.setTimeout(function () {focusOnInput
 * (globalFocusOnElement);}, 30); tableReference.appendChild(row); }
 */
function refreshFilterInput2 (tableReference, tableStatus) {
  if (tableStatus.filterEnabled[tableStatus.currentFilterPos] === false) {
    for (var i = 0; i < tableStatus.filterEnabled.length; ++i) {
      if (tableStatus.filterEnabled[i] === true) {
        tableStatus.currentFilterPos = i;
        break;
      }
    }
  }

  var row = tableStatus.filterRow;
  for (var i = 0; i < row.cells.length; i++) {
    if (row.cells [i].childNodes [0] !== undefined) {
      row.cells [i].childNodes [0].id = "";
    }
  }
  var globalFocusOnElement = "focusThisElement"+Math.ceil(Math.random()*1000).toString();
  row.cells [tableStatus.currentFilterPos].childNodes [0].id = globalFocusOnElement;
  window.setTimeout (function () {
    focusOnInput2 (globalFocusOnElement, tableStatus.filterInputCopy);
  }, 30);
  tableReference.appendChild (row);
}

function hookTable4Sort (bodyName, tableStatusName, dataSourceName,
                         viewName, sortPos) {
  var body = document.getElementById (bodyName);
  var tableStatus = window [tableStatusName];
  var f = window [tableStatus.hookFunctionName];
  var dataSource = window [dataSourceName];

  // console.log ("sort:functionName="+functionName);
  // console.log ("filterRowId="+tStatus.filterRowId);
  if (tableStatus.filterRowId!=="") {
    tableStatus.filterRow = document.getElementById (tableStatus.filterRowId).cloneNode (true);
  }

  body.innerHTML = "";

  tableStatus.currentSortPos = sortPos;
  if (tableStatus.currentSortDir == "down") {
    tableStatus.currentSortDir = "up";
  } else {
    tableStatus.currentSortDir = "down";
  }
  // console.log ("sort:dataSourceName="+dataSourceName);
  // console.log ("sort:f (body="+body+", dataSource="+dataSource+",
  // viewName="+viewName+", tStatus="+tStatus+", row=??"+",inputCopy=???)");

  f (body, dataSource, viewName, tableStatus);
}

function hookTable4Filter (bodyName, tableStatusName, dataSourceName,
                           viewName, filterPos, inputReference) {
  var body = document.getElementById (bodyName);
  var tableStatus = window [tableStatusName];
  var f = window [tableStatus.hookFunctionName];
  var dataSource = window [dataSourceName];

  tableStatus.filterRow = document.getElementById (tableStatus.filterRowId).cloneNode (true);

  // console.log ("filter:functionName="+functionName);

  tableStatus.filterInputCopy = inputReference.cloneNode (true);
  tableStatus.filterInputCopy.selectionStart = inputReference.selectionStart;
  tableStatus.filterInputCopy.selectionEnd = inputReference.selectionEnd;

  body.innerHTML = "";

  tableStatus.currentFilterPos = filterPos;
  if (inputReference.value.length === 0) {
    if (tableStatus.filterTypes [filterPos] == "string") {
      tableStatus.filterSet [filterPos] = ".*";
    } else {
      tableStatus.filterSet [filterPos] = ">=0";
    }
  } else {
    tableStatus.filterSet [filterPos] = inputReference.value;
  }
  // tStatus.print();

  // console.log ("filter:dataSourceName="+dataSourceName);
  // console.log ("filter:f (body="+body+", dataSource="+dataSourceName+", viewName="+viewName+", tStatus="+tableStatus);
  f (body, dataSource, viewName, tableStatus);
}

function isInFilter (value, filter, type) {
  //console.log ("isInFilter: value='"+value+"' filter='"+filter, "' type="+type);
  if (type == "string") {
    var m = new RegExp (filter, "i");
    var found = value.match (m);
    // console.log("String: value="+value+" filter="+filter);
    if (found !== null) {
      return (true);
    } else {
      return (false);
    }
  } else { // number
    // [15:13:20.409] r = RegExp("[a-zA-Z]+","ig")
    // [15:13:22.222] filter.match(r)
    // [15:13:41.019] filter.split("x")
    // [15:14:24.143] f.join ("15")
    var rd = RegExp ("\\d+", "i");
    var matchd = filter.match (rd);
    if (matchd === null) {
      return (true);
    }
    // var r = RegExp("[a-z]+","i"); ==> IS NOT WORKING AS TO 'x' IS ALSO USED
    // FOR HEX NUMBERS
    var r = RegExp ("[g-wy]+", "ig");
    filter = filter.replace (r, "z");
    r = RegExp ("z", "i");
    var match = filter.match (r);
    var evalString;
    if (match !== null) {
      evalString = filter.split (match [0]).join (toUint32 (vlogb2int (value)));
    } else {
      evalString = toUint32 (vlogb2int (value)).toString () + filter;
    }

    var status;
    try {
      status = eval (evalString);
    }
    catch (err) {
      status = true;
    }
    return (status);
  }
}

/*
 * function focusOnInput(id) { var element = document.getElementById(id);
 * element.focus();
 * element.setSelectionRange(element.value.length,element.value.length); }
 */

function focusOnInput2 (id, inputCopy) {
  if (inputCopy===null) return;
  var element = document.getElementById (id);
  element.focus ();
  element.setSelectionRange (inputCopy.selectionStart, inputCopy.selectionEnd);
}

function sortComparator (a_, b_) {
  var pos = globalCurrentTableStatus.currentSortPos; // filterPos must be a
  // global variable due to
  // the limited arguemnts
  var a, b;
  if (globalCurrentTableStatus.sortTypes [pos] == "number") {
    a = toUint32 (vlogb2int (a_ [pos]));
    b = toUint32 (vlogb2int (b_ [pos]));
  } else {
    a = a_ [pos];
    b = b_ [pos];
  }
  if (globalCurrentTableStatus.currentSortDir == "down") {
    if (a > b)
      return -1;
    if (a < b)
      return 1;
  } else {
    if (a < b)
      return -1;
    if (a > b)
      return 1;
  }
  return 0;
}

function sortArray (tableStatus) {
  globalCurrentTableStatus = tableStatus;
  tableStatus.tableArray.sort (sortComparator);
}

function filterArray (tableStatus) {
  var filterEnabled = tableStatus.filterEnabled;
  var tableArray = tableStatus.tableArray;
  var filteredTableArray = new Array ();
  var row;
  var column;
  for (row = 0; row < tableArray.length; row++) {
    var add = true;
    //console.log ("ROW=="+row);
    for (column = 0; column < filterEnabled.length; column++) {
      if (filterEnabled [column] === true) {
        //console.log ("COLUMN=="+column);
        if (isInFilter (tableArray [row] [column],
            tableStatus.filterSet [column], tableStatus.filterTypes [column]) === false) {
          add = false;
          column = filterEnabled.length;
        }
      }
    }
    if (add === true)
      filteredTableArray.push (tableArray [row]);
  }
  tableStatus.tableArray = filteredTableArray;
}

function addHcellCombineInfo (tableStatus, viewName) {
  var combineCell = tableStatus.combineCell;
  var tableArray = tableStatus.tableArray;
  if (tableArray.length===0) return;

  var element = tableArray [tableArray.length-1] [tableArray [tableArray.length-1].length - 1];
  var nextElement;
  var extView = viewName;
  if (extView===undefined) viewName = element.jsName;

  var space;
  var columnPos;
  var rowPos;
  var rowPosNext;
  var spanMatrix = new Array (tableArray.length);
  for (rowPos = tableArray.length-1; rowPos >= 0; rowPos--) {
    spanMatrix[rowPos] = new Array (combineCell.length);
    for (columnPos = 0; columnPos < combineCell.length; columnPos++) {
      spanMatrix[rowPos][columnPos] = 1;
    }
  }
  for (columnPos = 0; columnPos < combineCell.length; columnPos++) {
    // Continue if column should not be combined!
    if (combineCell[columnPos] == false) continue;
    // Loop over rows, start at the end
    var rowSpanCounter = 0;
    for (rowPos = tableArray.length-1; rowPos >= 0; rowPos--) {
      element = tableArray [rowPos] [tableArray [rowPos].length - 1];
      if (extView===undefined) viewName = element.jsName;
      rowPosNext = rowPos-1;
      if (rowPosNext>=0) {
          nextElement = tableArray [rowPosNext] [tableArray [rowPosNext].length - 1];
      } else {
    	  nextElement = null;
      }
       if (element.type === "register" && element.reserved != undefined) {
        var spaceFactor = Math.ceil (vlogb2int (window [viewName].dataWidth [viewName])/vlogb2int (window [viewName].addrBase));
        //space = Math.ceil (vlogb2int(element.addrSpace [viewName])/vlogb2int(element.addrSpace [element.jsName]) / spaceFactor);
        space = Math.ceil (vlogb2int(element.addrSpace [viewName])/ spaceFactor);
      } else  {
        space = 1;
      }
      rowSpanCounter += space;
      if (nextElement==null || (tableArray[rowPos][columnPos]!=tableArray[rowPosNext][columnPos]) || space>2
    		  || (element.type==="register" && element.reserved===true)
    		  || (nextElement.type==="register" && nextElement.reserved===true)) {
        spanMatrix[rowPos][columnPos] = rowSpanCounter;
        rowSpanCounter = 0;
      } else {
        spanMatrix[rowPos][columnPos] = null;
      }
    }
  }
  for (rowPos = tableArray.length-1; rowPos >= 0; rowPos--) {
    tableArray [rowPos].push (spanMatrix[rowPos].slice ());
  }
  addHcellInterleaveInfo (tableStatus);
}

function addHcellInterleaveInfo (tableStatus) {
  var combineCell = tableStatus.combineCell;
  var tableArray = tableStatus.tableArray;
  var lastInterleaved = new Array ();
  var className = new Array ();
  var row;
  var column;

  for (var i = 0; i < combineCell.length; i++) {
    lastInterleaved [i] = false;
  }

  for (row = 0; row < tableArray.length; row++) {
    var rowSpans = tableArray [row] [tableArray [row].length - 1];
    for (column = 0; column < combineCell.length; column++) {
      if (rowSpans [column]!==null) {
        if (lastInterleaved [column] == false) {
          className [column] = "interleave";
        } else {
          className [column] = "null";
        }
        lastInterleaved [column] = !lastInterleaved [column];
      }
    }
    //tableArray [row].push (className.slice ());
    var length = tableArray [row].length;
    tableArray [row].splice (length-1, 0, className.slice ());
  }
}
