/**
 *
 */

// INITIAL
function initial () {

  showCompatibilityIssues ();

  createTitle (system);
  createDescription (system);
  genInfo (system, null);
  createAttributesTable (system, null);
  createModuleTable (system.modules, null);
  createViewTable (system.allViews, null);
  createDebugMsgTable (system, null);
  createFooter (system);

  initChapter ("description", 1);
  initChapter ("info", 0);
  initChapter ("attributes", 0);
  initChapter ("submodules", 1);
  initChapter ("views", 1);
  initChapter ("debugmsg", 1);

  scaleObjects ();
  window.onresize = scaleObjects;
}

function createModuleTable (modulesArray, viewName) {
  if (modulesArray == undefined || modulesArray.length === 0) {
    hideBundle ("submodulesBody", undefined);
    return;
  }

  var refName = "submodules" + Math.ceil (Math.random () * 1000).toString ();
  modulesArray.jsName = refName;
  window [refName] = modulesArray;
  createModulesTable1Init (modulesArray, "submodules");
}
function createViewTable (portsArray, viewName) {
  if (portsArray == undefined || portsArray.length === 0) {
    hideBundle ("viewsBody", undefined);
    return;
  }
  var refName = "views" + Math.ceil (Math.random () * 1000).toString ();
  portsArray.jsName = refName;
  window [refName] = portsArray;
  createViewsTable1Init (portsArray, "views");
}

function genInfo (module, viewName) {
  var head = document.getElementById ("infoHead");

  head.innerHTML += createToggleImage ("info");

  genInfo0 (module, viewName);
}

function genInfo0 (module, viewName) {
  // Description
  var body = document.getElementById ("infoBody0");
  var row;
  var cell;
  var link;

  // Table Headers
  var headerCells = [ "Parameter", "Value" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Module";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = module.aliasName;
  cell.innerHTML += " (" + module.baseName + ")";
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Module Parent
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Module Parent";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (module.parent.length > 0) {
    cell.innerHTML = window [module.parent].aliasName;
    cell.innerHTML += " (" + window [module.parent].baseName + ")";
  } else {
    cell.innerHTML = "-";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Modules
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Sub-Modules";
  row.appendChild (cell);
  cell = createNrTableCell (module.modules.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Ports
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Ports";
  row.appendChild (cell);
  cell = createNrTableCell (module.ports.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Buses
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Buses";
  row.appendChild (cell);
  cell = createNrTableCell (module.buses.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Has Mutations ...
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Mutations By Attributes";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (module.hasMutationsByAttributes == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  //Row: References
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "References";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateReference(cell, module, module.jsName);
  row.appendChild (cell);
  body.appendChild (row);
}
