/**
 *
 * @param vlogBinString
 *          (example: 32'b10101010101010...)
 * @returns Array of 2: Pos 0 ... Width (example: 32) Pos 0 ... Bitstring
 *          (example: 10101010101010...)
 */
function vlogSplit (vlogBinString) {
  if (vlogBinString===undefined) {
    console.log ("Error: vlogSplit(...) argument is undefined!");
    return ("ERROR-vlogSplit-argUndefined");
  } else if (typeof (vlogBinString)!=="string") {
    console.log ("Error: argument NOT typeof string");
  } else {
    return (vlogBinString.split ("'b"));
  }
}

(function () {
  convert2Stage = function (bitString) {
    bitString = bitString.replace (/X/g, "0");
    bitString = bitString.replace (/Z/g, "1");
    return (bitString);
  };
  var convertBase = function (num) {
    this.from = function (baseFrom) {
      this.to = function (baseTo) {
        return parseInt (num, baseFrom).toString (baseTo);
      };
      return this;
    };
    return this;
  };
  // binary to decimal
  this.bin2dec = function (num) {
    num = convert2Stage (num);
    return convertBase (num).from (2).to (10);
  };
  // binary to hexadecimal
  this.bin2hex = function (num, use2stage) {
    if (use2stage === true) {
      num = convert2Stage (num);
    }
    var hexString = "";
    var newSize = Math.ceil (num.length / 4);
    var s = padString (num, "0", newSize * 4);
    for (var i = 0; i < newSize; ++i) {
      var substr = s.substr (i * 4, 4);
      var containsX = (substr.search ('X') != -1);
      var containsZ = (substr.search ('Z') != -1);
      if (containsX === true) {
        hexString += 'X';
      } else if (containsZ === true) {
        hexString += 'Z';
      } else {
        hexString += parseInt (substr, 2).toString (16);
      }
    }
    return (hexString.toUpperCase ());
    // return convertBase(num).from(2).to(16);
  };
  // decimal to binary
  this.dec2bin = function (num) {
    return convertBase (num).from (10).to (2);
  };
  // decimal to hexadecimal
  this.dec2hex = function (num) {
    return convertBase (num).from (10).to (16).toUpperCase ();
  };
  // hexadecimal to binary
  this.hex2bin = function (num, use2stage) {
    if (use2stage === true) {
      num = convert2Stage (num);
    }
    var bitString = "";
    var s = num;
    for (var i = 0; i < s.length; ++i) {
      if (s [i] == 'X' || s [i] == 'Z') {
        bitString += new Array (4 + 1).join (s [i]);
      } else {
        v = parseInt (s [i], 16);
        bitString += padString (v.toString (2), "0", 4);
      }
    }
    return (bitString);
    // return convertBase(num).from(16).to(2);
  };
  // hexadecimal to decimal
  this.hex2dec = function (num) {
    num = convert2Stage (num);
    return convertBase (num).from (16).to (10);
  };
  // integer to decimal
  this.int2dec = function (num) {
    return (num.toString (10));
  };
  // integer to binary
  this.int2bin = function (num) {
    return (num.toString (2));
  };
  // integer to hexadecimal
  this.int2hex = function (num) {
    return (num.toString (16).toUpperCase ());
  };

  this.vlogb2int = function (vlogBinString) {
    if (vlogBinString.indexOf ("'b")==-1) return (0);
    else return (parseInt (vlogSplit (vlogBinString) [1], 2));
  };

  this.vlogb2bin = function (vlogBinString, use2stage) {
    if (vlogBinString.indexOf ("'b")==-1) return (vlogBinString);
    if (use2stage === true) {
      return (convert2Stage (vlogSplit (vlogBinString) [1]));
    } else {
      return (vlogSplit (vlogBinString) [1]);
    }
  };

  this.vlogb2hex = function (vlogBinString, use2stage) {
    if (vlogBinString.indexOf ("'b")==-1) return (vlogBinString);
    else return (bin2hex (vlogSplit (vlogBinString) [1], use2stage));
  };

  this.vlogb2dec = function (vlogBinString) {
    if (vlogBinString.indexOf ("'b")==-1) return (vlogBinString);
    else return (bin2dec (vlogSplit (vlogBinString) [1]));
  };

  this.vlogb2binM = function (vlogBinString, use2stage) {
    if (vlogBinString.indexOf ("'b")==-1) return (vlogBinString);
    var M = document.createElement ("sub");
    M.innerHTML = "B";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode ( vlogb2bin (vlogBinString, use2stage)));
    result.appendChild (M);
    return (result.innerHTML);
  };

  this.vlogb2hexM = function (vlogBinString, use2stage) {
    if (vlogBinString.indexOf ("'b")==-1) return (vlogBinString);
    else return (bin2hexM (vlogSplit (vlogBinString) [1], length, use2stage));
  };

  this.vlogb2decM = function (vlogBinString, length) {
    if (vlogBinString.indexOf ("'b")==-1) return (vlogBinString);
    else return (bin2decM (vlogSplit (vlogBinString) [1], length));
  };

  // this.bin2dec = this.toUpperCase(this);
  // this.bin2hex = this.toUpperCase(this);
  // this.dec2bin = this.toUpperCase(this);
  // this.dec2hex = this.toUpperCase(this);
  // this.hex2bin = this.toUpperCase(this);
  // this.hex2dec = this.toUpperCase(this);
  // this.int2bin = this.toUpperCase(this);
  // this.int2dec = this.toUpperCase(this);
  // this.int2hex = this.toUpperCase(this);

  this.bin2decM = function (num, length) {
    num = bin2dec (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "D";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.bin2hexM = function (num, length, use2stage) {
    num = bin2hex (num, use2stage);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "H";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.dec2binM = function (num, length) {
    num = dec2bin (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "B";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.dec2hexM = function (num, length) {
    num = dec2hex (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "H";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.hex2binM = function (num, length, use2stage) {
    num = hex2bin (num, use2stage);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "B";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.hex2decM = function (num, length) {
    num = hex2dec (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "D";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.int2binM = function (num, length) {
    num = int2bin (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "B";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.int2decM = function (num, length) {
    num = int2dec (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "D";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };
  this.int2hexM = function (num, length) {
    num = int2hex (num);
    if (length > 0) {
      num = padString (num, "0", length);
    }
    var M = document.createElement ("sub");
    M.innerHTML = "H";
    var result = document.createElement ("span");
    result.appendChild (document.createTextNode (num));
    result.appendChild (M);
    return (result.innerHTML);
  };

  return this;
}) ();

// Convert x to a signed 32-bit integer
function toInt32 (x) {
  return x >> 0;
}

// Convert x to an unsigned 32-bit integer
function toUint32 (x) {
  return x >>> 0;
}
