% Automated controlled TX5G 1dBcp measurements
% Written by Denis 04.10.2011, modified 04.03.2015

clear all; close all;

Init_GPIB;
% startupBBS;
% fprintf('\n RFIC is initializing, please wait...');
% Initialize_LB_gain;
% fprintf('\n RFIC init complete');

savethedata=1;
filename='WRX524_TX5G_Device3_1dBcp.mat';
Poutcorr=2.8; % attenuation before SA,dB at 5.4GHz (pcb+cables+SM)

rfic_api('rfic_config_txgain',0,0,0);
rfic_api('rfic_set_txgain',15,0,0);

Pout(1,1:11,1:4,1:21)=0;

% RF initialization

% for temp = 1:3
%     fprintf('\n Temperature is setting up, please wait... ');
%     if temp == 1
%       temperature = 60;
%     elseif temp == 2
%       temperature = -10;
%     else 
%       temperature = 100;
%     end;
%     
%     fprintf(TS,'TEMP1 %d',temperature);
%     pause(1);
%     fprintf(TS,'GOTEMP1');
%     pause(200); 
%     
%     fprintf('\n Temperature is set to %d degree \n', temperature);

temp=1;

    for f = 1:11
        
    if (f==1)
        disp('Init 4.9GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',4900);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 4899 MHz');
        pause (0.2);
        Poutcorr=2.6;
        rfic_api('rfic_set_txband',15,0);
    elseif (f==2)    
        disp('Init 5.0GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5000);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 4999 MHz');
        pause (0.2);
        Poutcorr=2.6;
        rfic_api('rfic_set_txband',15,1);
    elseif (f==3)
        disp('Init 5.1GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5100);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5099 MHz');
        pause (0.2);
        Poutcorr=2.7;
        rfic_api('rfic_set_txband',15,1);
    elseif (f==4) 
        disp('Init 5.2GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5200);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5199 MHz');
        pause (0.2);
        Poutcorr=2.7;
        rfic_api('rfic_set_txband',15,2);
    elseif (f==5)   
        disp('Init 5.3GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5300);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5299 MHz');
        pause (0.2);
        Poutcorr=2.8;
        rfic_api('rfic_set_txband',15,2);
    elseif (f==6)    
        disp('Init 5.4GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5400);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5399 MHz');
        pause (0.2);
        Poutcorr=2.8;
        rfic_api('rfic_set_txband',15,2);
    elseif (f==7) 
        disp('Init 5.5GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5500);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5499 MHz');
        pause (0.2);
        Poutcorr=2.8;
        rfic_api('rfic_set_txband',15,3);
    elseif (f==8)
        disp('Init 5.6GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5600);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5599 MHz');
        pause (0.2);
        Poutcorr=2.9;
        rfic_api('rfic_set_txband',15,3);
    elseif (f==9) 
        disp('Init 5.7GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5700);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5699 MHz');
        pause (0.2);
        Poutcorr=2.9;
        rfic_api('rfic_set_txband',15,4);
    elseif (f==10) 
        disp('Init 5.8GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5800);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5799 MHz');
        pause (0.2);
        Poutcorr=3;
        rfic_api('rfic_set_txband',15,4);
    else   
        disp('Init 5.9GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5900);
        rfic_api('rfic_release_pllreset');
        fprintf(PXA, ':FREQ:CENT 5899 MHz');
        pause (0.2);
        Poutcorr=3;
        rfic_api('rfic_set_txband',15,5);
    end;
        
        figure(f);
        clf;
        hold on;
        grid on;
        zoom on;
        
            for ant= 1:4 %Antenna loop
            fprintf(SM, sm_off);
            pause(1);
            if ant == 1
                fprintf(SM, sm_ch1);
            elseif ant == 2
                fprintf(SM, sm_ch2);
            elseif ant == 3
                fprintf(SM, sm_ch3);
            else 
                fprintf(SM, sm_ch4);
            end
            pause(1);            
                    
                for att=21:-1:1 %MXG loop
   
                fprintf (MXG,'RAD:ARB:IQ:MOD:ATT %g', att+0.1); % programming input signal
                pause(0.2);
                
                % Readout output power

                fprintf(PXA, 'CALC:MARK:MAXimum');
                pause(0.2);
                Pout(temp,f,ant,att) = str2num(query(PXA,':CALC:MARK1:Y?'))+Poutcorr;
                pause(0.2);

                if ant==1
                    plot(att,Pout(temp,f,ant,att),'bd','MarkerFaceColor','b');
                elseif ant==2
                    plot(att,Pout(temp,f,ant,att),'bd','MarkerFaceColor','r');
                elseif ant==3
                    plot(att,Pout(temp,f,ant,att),'bd','MarkerFaceColor','g');
                else
                    plot(att,Pout(temp,f,ant,att),'bd','MarkerFaceColor','m');
                end;
                end;
                
                fprintf (MXG,'RAD:ARB:IQ:MOD:ATT %g', 30.1);
            end;
    end;
%     end;
    if savethedata==1
        save(filename,'Pout');
    end;


% fprintf(TS,'TEMP1 25');
% pause(1);
% fprintf(TS,'GOTEMP1');
% pause(1); 

Close_GPIB;


