% Automated controlled TX5G gain measurements
% Written by Denis 04.10.2011, modified 04.03.2015

clear all; close all;

Init_GPIB;
% startupBBS;
% fprintf('\n RFIC is initializing, please wait...');
% Initialize_LB_gain;
% fprintf('\n RFIC init complete');

savethedata=1;
filename='WRX524_TX5G_Device3_Gain.mat';
Poutcorr=2.8; % attenuation before SA,dB at 5.4GHz (pcb+cables+SM)

main_tone(1,1:11,1:4,1:12)=0;
carrier(1,1:11,1:4,1:12)=0;
ssb_tone(1,1:11,1:4,1:12)=0;

% RF initialization

% for temp = 1:3
%     fprintf('\n Temperature is setting up, please wait... ');
%     if temp == 1
%       temperature = 60;
%     elseif temp == 2
%       temperature = -10;
%     else 
%       temperature = 100;
%     end;
%     
%     fprintf(TS,'TEMP1 %d',temperature);
%     pause(1);
%     fprintf(TS,'GOTEMP1');
%     pause(200); 
%     
%     fprintf('\n Temperature is set to %d degree \n', temperature);

temp=1;

    for f = 1:11
        
        f_main_tone = (4900+((f-1)*100)-1)*1e6;
        f_carrier = (4900+(f-1)*100)*1e6;
        f_ssb_tone = (4900+((f-1)*100)+1)*1e6;
        
        if f==1
        disp('Init 4.9GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',4900);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.6;
        rfic_api('rfic_set_txband',15,0);
        elseif f==2
        disp('Init 5.0GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5000);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.6;
        rfic_api('rfic_set_txband',15,1);
        elseif f==3
        disp('Init 5.1GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5100);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.7;
        rfic_api('rfic_set_txband',15,1);
        elseif f==4
        disp('Init 5.2GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5200);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.7;
        rfic_api('rfic_set_txband',15,2);
        elseif f==5
        disp('Init 5.3GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5300);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.8;
        rfic_api('rfic_set_txband',15,2);
        elseif f==6
        disp('Init 5.4GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5400);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.8;
        rfic_api('rfic_set_txband',15,2);
        elseif f==7
        disp('Init 5.5GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5500);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.8;
        rfic_api('rfic_set_txband',15,3);
        elseif f==8
        disp('Init 5.6GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5600);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.9;
        rfic_api('rfic_set_txband',15,3);
        elseif f==9
        disp('Init 5.7GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5700);
        rfic_api('rfic_release_pllreset');
        Poutcorr=2.9;
        rfic_api('rfic_set_txband',15,4);
        elseif f==10
        disp('Init 5.8GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5800);
        rfic_api('rfic_release_pllreset');
        Poutcorr=3;
        rfic_api('rfic_set_txband',15,4);
        else
        disp('Init 5.9GHz...');
        rfic_api('rfic_set_pllreset');
        rfic_api('rfic_set_lo_frequency',5900);
        rfic_api('rfic_release_pllreset');
        Poutcorr=3;
        rfic_api('rfic_set_txband',15,5);
        end;
        
        figure(f);
        clf;
        hold on;
        grid on;
        zoom on;
        
            for ant= 1:4 %Antenna loop
            fprintf(SM, sm_off);
            pause(1);
            if ant == 1
                fprintf(SM, sm_ch1);
            elseif ant == 2
                fprintf(SM, sm_ch2);
            elseif ant == 3
                fprintf(SM, sm_ch3);
            else 
                fprintf(SM, sm_ch4);
            end
            pause(1);            
                    
                for pgc=1:12 %Gain loop
   
                rfic_api('rfic_config_txgain',-8+(pgc-1)*2,0,0);
                pause(1);
                
                % Readout output power
                
                fprintf(PXA, ':FREQ:CENT %d GHz', f_main_tone/1e9);
                pause(0.2);
                fprintf(PXA, 'CALC:MARK:MAXimum');
                pause(0.2);
                main_tone(temp,f,ant,pgc) = str2num(query(PXA,':CALC:MARK1:Y?'))+Poutcorr;
                pause(0.2);

                fprintf(PXA, ':FREQ:CENT %d GHz', f_carrier/1e9);
                pause(0.2);
                fprintf(PXA, 'CALC:MARK:MAXimum');
                pause(0.2);
                carrier(temp,f,ant,pgc) = str2num(query(PXA,':CALC:MARK1:Y?'))+Poutcorr;
                pause(0.2);
                
                fprintf(PXA, ':FREQ:CENT %d GHz', f_ssb_tone/1e9);
                pause(0.2);
                fprintf(PXA, 'CALC:MARK:MAXimum');
                pause(0.2);
                ssb_tone(temp,f,ant,pgc) = str2num(query(PXA,':CALC:MARK1:Y?'))+Poutcorr;
                pause(0.2);


                if ant==1
                    plot(pgc,main_tone(temp,f,ant,pgc),'bd','MarkerFaceColor','b');
                    plot(pgc,carrier(temp,f,ant,pgc),'bd','MarkerFaceColor','r');
                    plot(pgc,ssb_tone(temp,f,ant,pgc),'bd','MarkerFaceColor','m');
                elseif ant==2
                    plot(pgc,main_tone(temp,f,ant,pgc),'o','MarkerFaceColor','b');
                    plot(pgc,carrier(temp,f,ant,pgc),'o','MarkerFaceColor','r');
                    plot(pgc,ssb_tone(temp,f,ant,pgc),'o','MarkerFaceColor','m');
                elseif ant==3
                    plot(pgc,main_tone(temp,f,ant,pgc),'s','MarkerFaceColor','b');
                    plot(pgc,carrier(temp,f,ant,pgc),'s','MarkerFaceColor','r');
                    plot(pgc,ssb_tone(temp,f,ant,pgc),'s','MarkerFaceColor','m');
                else
                    plot(pgc,main_tone(temp,f,ant,pgc),'d','MarkerFaceColor','b');
                    plot(pgc,carrier(temp,f,ant,pgc),'d','MarkerFaceColor','r');
                    plot(pgc,ssb_tone(temp,f,ant,pgc),'d','MarkerFaceColor','m');
                end;
                end;
            end;
    end;
%     end;
    if savethedata==1
        save(filename,'main_tone','carrier', 'ssb_tone');
    end;


% fprintf(TS,'TEMP1 25');
% pause(1);
% fprintf(TS,'GOTEMP1');
% pause(1); 

Close_GPIB;


