/**
 *
 */
// INITIAL
function initial () {
  var locationSearch = window.location.search;
  var keys = locationSearch.split ('?', 4);
  var regName = keys [1];
  var viewName = keys [2];
  var segment = parseInt(keys [3],10);
  var register = window [regName];

  if (keys [3]===undefined) segment = 0;

  createTitle (register);
  createDescription (register);
  createViewsTable (register, viewName);
  createHierarchy (register, viewName);
  genInfo (register, viewName);
  createAttributesTable (register, viewName);
  createFieldsSchemeAndTable (register, viewName, segment);
  createDebugMsgTable (register, viewName);
  createFooter (register);

  initChapter ("description", 0);
  initChapter ("views", 0);
  initChapter ("hierarchy", 1);
  initChapter ("info", 0);
  initChapter ("attributes", 0);
  initChapter ("fields", 1);
  initChapter ("debugmsg", 1);

  scaleObjects ();
  window.onresize = scaleObjects;
}

function createFieldsSchemeAndTable (register, viewName, segment) {
  var head = document.getElementById ("fieldsHead");
  var body0 = document.getElementById ("fieldsBody0");
  var body1 = document.getElementById ("fieldsBody1");

  head.innerHTML += createToggleImage ("fields");

  var tableStatus = new TableStatus (11);
  // TABLE: | Bits {START & END} | Name | Long Name | Reset | Type
  //        | Hidden | Read | Write '1' | Write '0' | Description |
  // init sort
  tableStatus.id = "globalFieldsTable";
  tableStatus.sortEnabled [1] = false;
  tableStatus.sortEnabled [6] = false;
  tableStatus.sortTypes [0] = "number";
  tableStatus.sortTypes [4] = "number";
  tableStatus.sortClassNames [1] = "hiddenCell";
  tableStatus.sortClassNames [6] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "down";
  // init filter
  tableStatus.filterEnabled [0] = false;
  tableStatus.filterEnabled [1] = false;
  tableStatus.filterEnabled [6] = false;
  tableStatus.filterTypes [0] = "number";
  tableStatus.filterTypes [4] = "number";
  tableStatus.filterSet [0] = ">=0";
  tableStatus.filterSet [4] = ">=0";
  tableStatus.filterClassNames [1] = "hiddenCell";
  tableStatus.filterClassNames [6] = "hiddenCell";
  // combine
  //tableStatus.combineCell [X] = true;

  tableStatus.hookFunctionName = "hookFieldTable";

  window [tableStatus.id] = tableStatus;

  createRegisterSchemeVALID (body0, register, viewName, undefined, undefined, segment);
  hookFieldTable (body1, register, viewName, globalFieldsTable);
}

function hookFieldTable (tableReference, register, viewName, tableStatus) {
  // generate data array
  buildFieldTableArray (register, viewName, globalFieldsTable);
  // generate table
  createFieldTable (tableReference, register, viewName, tableStatus);
}

function buildFieldTableArray (register, viewName, tableStatus) {
  // TABLE: | Bits {START & END} | Name | Long Name | Reset | Type
  //        | Hidden | Read | Write '1' | Write '0' | Description |
  var bodyArray = new Array;
  // build bodyArray
  var fields = register.fields;
  for (var idx = fields.length - 1; idx >= 0; idx--) {
    bodyArray [idx] = new Array;
    var field = window [fields [idx]];
    // Bits (START)
    var pos = 0;
    bodyArray [idx] [pos] = field.addrStart;
    // Bits (END)
    pos++;
    if (vlogb2int (field.dataWidth) > 1) {
      bodyArray [idx] [pos] = field.addrEnd;
    } else {
      bodyArray [idx] [pos] = "";
    }
    // Name
    pos++;
    bodyArray [idx] [pos] = field.aliasName;
    // Long Name
    pos++;
    bodyArray [idx] [pos] = field.longName;
    // Reset
    pos++;
    bodyArray [idx] [pos] = field.resetVal;
    // Type
    var access = field.accessProperties [viewName].split (",");
    pos++;
    bodyArray [idx] [pos] = access [0];
    // Type Description
    pos++;
    bodyArray [idx] [pos] = access [4];
    // RD
    pos++;
    bodyArray [idx] [pos] = access [1];
    // WR1
    pos++;
    bodyArray [idx] [pos] = access [2];
    // WR0
    pos++;
    bodyArray [idx] [pos] = access [3];
    // Description
    pos++;
    bodyArray [idx] [pos] = field.description;
    // Field
    pos++;
    bodyArray [idx] [pos] = field;
  }

  tableStatus.tableArray = bodyArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  addHcellCombineInfo (tableStatus)
  return (bodyArray);
}
function createFieldTable (tableReference, register, viewName, tableStatus) {
  // TABLE: | Bits {START & END} | Name | Long Name | Reset | Type
  //        | Hidden | Read | Write '1' | Write '0' | Description |
  var body = tableReference;
  var bodyCells = tableStatus.tableArray;
  var headerCells = [ "Bit(s)", "hiddenCell", "Name", "Long Name", "Reset", "Type",
                      "hiddenCell", "Read", "Write '0'", "Write '1'", "Description" ];
  var row;
  var cell;
  var link;
  // create header
  createSortableHeader (body, headerCells, register, viewName, tableStatus);

  // create filter inputs
  if (tableStatus.filterRow === null && bodyCells.length > 1) {
    createFilterInput (body, register, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }

  // create body
  for (var line = 0; line < bodyCells.length; line++) {
    var field = bodyCells [line] [bodyCells [line].length - 3];
    var classNames = bodyCells [line] [bodyCells [line].length - 2];
    var rowSpans = bodyCells [line] [bodyCells [line].length - 1];

    row = document.createElement ("tr");
    if (line % 2 === 0) {
      row.className = "interleave";
    }

    // Bits
    var pos = 0;
    var bitsStart = bodyCells [line] [pos];
    var bitsEnd = bodyCells [line] [pos + 1];
    cell = document.createElement ("td");
    if (bitsEnd.length > 1) {
      if (tableStatus.currentSortPos == 0 && tableStatus.currentSortDir == "up") {
        cell.innerHTML = vlogb2dec (bitsStart) + ":" + vlogb2dec (bitsEnd);
      } else {
        cell.innerHTML = vlogb2dec (bitsEnd) + ":" + vlogb2dec (bitsStart);
      }
    } else {
      cell.innerHTML = vlogb2dec (bitsStart);
    }
    cell.className = bodyCells [line] [pos];
    row.appendChild (cell);
    // HIDDEN CELL
    pos++;
    cell = document.createElement ("td");
    cell.className = "hiddenCell";
    row.appendChild (cell);
    // Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.id = bodyCells [line] [pos];
    row.appendChild (cell);
    // Long Name
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    row.appendChild (cell);
    // Reset
    pos++;
    var reset = bodyCells [line] [pos];
    cell = createNrTableCellDuo (vlogb2bin (reset), 0, "bin");
    row.appendChild (cell);
    // Type
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.title = bodyCells [line] [pos + 1];
    row.appendChild (cell);
    // HIDDEN CELL
    pos++;
    cell = document.createElement ("td");
    cell.className = "hiddenCell";
    row.appendChild (cell);
    // RD
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.title = "TBD";
    row.appendChild (cell);
    // WR1
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.title = "TBD";
    row.appendChild (cell);
    // WR0
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [line] [pos];
    cell.title = "TBD";
    row.appendChild (cell);
    // Description
    pos++;
    cell = document.createElement ("td");
    cell.style.textAlign = "left";
    cell.innerHTML = bodyCells [line] [pos];
    cell.appendChild (document.createElement ("br"));
    generateReference (cell, field, viewName);
    generateFieldEnumerations (cell, field, field.resetVal, viewName);
    row.appendChild (cell);
    // Append ROW
    body.appendChild (row);
  }
}

function generateFieldEnumerations (cellReference, fieldReference, resetVal, viewName) {
  var field = fieldReference;

  if (field.attributes.enumeration !== undefined) {
    for (var i=0; i<field.attributes.enumeration.length; i++) {
      var div = document.createElement ("div");
      div.style.paddingTop = "25px";
      var enums = field.attributes.enumeration [i];
      var bold = document.createElement ("b");
      var description = document.createTextele
      // Heading
      if (enums.longName.length===0) {
        bold.appendChild (document.createTextNode ("Enumerations:"));
      } else {
        bold.appendChild (document.createTextNode (enums.longName+":"));
      }
      div.appendChild (bold);
      // Description
      if (enums.description.length>0) {
        div.appendChild (document.createElement ("br"));
        div.appendChild (document.createTextNode (enums.description));
      }
      // References
      div.appendChild (document.createElement ("br"));
      generateReference (div, enums, viewName);

      // Table
      var table = document.createElement ("table");
      for (var j = 0; j < enums.length; j++) {
        var row = document.createElement ("tr");
        var cell = createNrTableCell (vlogb2bin (enums [j] [1]), 0, "bin");
        row.appendChild (cell);
        cell = document.createElement ("td");
        cell.innerHTML = enums [j] [0];
        if (resetVal===enums [j] [1]) {
          cell.innerHTML += " (reset)";
        }
        row.appendChild (cell);
        cell = document.createElement ("td");
        cell.innerHTML = enums [j] [2];
        row.appendChild (cell);

        table.appendChild (row);
      }
      div.appendChild (table);
      // Final connect
      cellReference.appendChild (div);
    }
  }
}

function genInfo (register, viewName) {
  var head = document.getElementById ("infoHead");

  head.innerHTML += createToggleImage ("info");

  genInfo0 (register, viewName);
  genInfo1 (register, viewName);
  genInfo2 (register, viewName);
}

function genInfo0 (register, viewName) {
  // Description
  var body = document.getElementById ("infoBody0");
  var view = window [viewName];
  // Table Caption
  // <caption><sup>M</sup>Module <sup>P</sup>Port <sup>B</sup>Bus
  // <sup>R</sup>Register</caption>
  var caption = document.createElement ("caption");
  var one = document.createElement ("sup");
  one.innerHTML = "1";
  caption.appendChild (one);
  caption.appendChild (document.createTextNode ("According to the current view's addressing scheme (Addr.base="
      + int2dec (vlogb2int (view.addrBase)) + " / Data width="
      + int2dec (vlogb2int (view.dataWidth [viewName]))));
  body.appendChild (caption);

  var row;
  var cell;
  var link;

  // Table Headers
  var headerCells = [ "Parameter", "Value" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Module";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = window [window [register.parent].parent].aliasName;
  cell.innerHTML += " (" + window [window [register.parent].parent].baseName
      + ")";
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Port
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Port";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = window [register.parent].aliasName;
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Base
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Interface Address Base";
  cell.title = "Smallest amount of data bits addressible by address lines";
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (register.addrBase), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Base
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Interface Data Width";
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (register.addrBase), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: View Offset
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("View Offset"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (getViewAddrStart (register, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Local Offset
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Local Offset"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (getAddrStart (register, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Local Offset (native)
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Local Offset";
  row.appendChild (cell);
  cell = createNrTableCell (getAddrStart (register, register.jsName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Space
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Occupied Address Space"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (getAddrSpace (register, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Space (native)
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Occupied Address Space";
  row.appendChild (cell);
  cell = createNrTableCell (getAddrSpace (register, register.jsName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Reset Value
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Reset Value (4-states)";
  row.appendChild (cell);
  cell = createNrTableCell (vlogSplit (register.resetVal) [1], 0, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Reset Value (2-stage)
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Reset Value (2-states)";
  row.appendChild (cell);
  cell = createNrTableCell (convert2Stage (vlogSplit (register.resetVal) [1]),
      0, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Bits used
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Used Bitfields";
  row.appendChild (cell);
  cell = createNrTableCell (vlogSplit (register.usedBits) [1], 0, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Bits used
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Undefined Bitfields";
  row.appendChild (cell);
  cell = createNrTableCell (vlogSplit (register.undefBits) [1], 0, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Fields
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Register Fields";
  row.appendChild (cell);
  cell = createNrTableCell (register.fields.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  //Row: References
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "References";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateReference(cell, register, register.jsName, false);
  row.appendChild (cell);
  body.appendChild (row);
  //Enabled and Disabled Exporters
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  var title1 = "Enabled";
  var title2 = "Disabled";
  cell.innerHTML = title1.fontcolor("green");
  cell.innerHTML += " /" + title2.fontcolor("red");
  cell.innerHTML += " Exporters";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateEnDisTypes (cell, register);
  row.appendChild (cell);
  body.appendChild (row);
  //Row: Source File
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Source file";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = register.sourceFile;
  row.appendChild (cell);
  body.appendChild (row);
  //Aliases
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Aliases";
  row.appendChild (cell);
  cell = document.createElement ("td");
  generateAliases (cell, register);
  row.appendChild (cell);
  body.appendChild (row);
}

function genInfo1 (register, viewName) {
  // Description
  var body = document.getElementById ("infoBody1");

  var row;
  var cell;

  // Table Headers
  var headerCells = [ "Behaviours", "Meaning" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module
  var bodyCells = [ [ "SETx", "Sets the value 0 at a certian access" ],
      [ "TOGGLE", "Toggles the value at a certian access" ],
      [ "DEFAULT", "Normal behavior: write sets and read returns value" ],
      [ "NOTHING", "No action" ] ];
  for (var i = 0; i < bodyCells.length; i++) {
    row = document.createElement ("tr");
    if (i % 2 === 0) {
      row.className = "interleave";
    }
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [i] [0];
    row.appendChild (cell);
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [i] [1];
    row.appendChild (cell);
    body.appendChild (row);
  }
}

function genInfo2 (register, viewName) {
  // Description
  var body = document.getElementById ("infoBody2");

  var row;
  var cell;

  // Table Headers
  var headerCells = [ "Behaviours", "Meaning" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module

  var bodyCells = accProp.typeDescription;

  for (var i = 0; i < bodyCells.length; i++) {
    row = document.createElement ("tr");
    if (i % 2 === 0) {
      row.className = "interleave";
    }
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [i] [0];
    row.appendChild (cell);
    cell = document.createElement ("td");
    cell.innerHTML = bodyCells [i] [1];
    row.appendChild (cell);
    body.appendChild (row);
  }
}

// Function to include other JavaScript files
function include () {
  if (arguments.length === 0) {
    return;
  }
  var arguments = Array.prototype.slice.call (arguments), callback = null, callback_trigger = 'file', files;
  if (arguments.length == 1) {
    files = arguments [0];
  } else {
    if (typeof arguments [arguments.length - 1] == 'function') {
      callback = arguments.pop ();
      callback_trigger = 'files';
    }
    files = arguments.length == 1 ? (typeof arguments [0] == 'object' ? arguments [0]
        : arguments)
        : arguments;
  }
  if (typeof files !== 'object') {
    files = [ files ];
  }
  if (callback_trigger == 'file') {
    var perfile = false;
    while (files.length > 0) {
      var file = files.shift ();
      if (typeof file == 'object') {
        callback = file [1];
        file = file [0];
        perfile = true;
      } else if (perfile) {
        perfile = false;
        callback = null;
      }
      _inject (file, callback);
    }
  } else if (callback_trigger == 'files') {
    function _include (file, callback) {
      _inject (file, function () {
        if (callback) {
          if (files.length > 0) {
            _include (files.shift (), callback);
          } else {
            callback ();
          }
        }
      });
    }
    _include (files.shift (), callback);
  }
  function _inject (file, callback) {
    var s = document.createElement ('script');
    s.type = 'text/javascript';
    s.src = file + '?' + Math.random ().toString ().substring (2);
    if (callback) {
      var loaded = false;
      s.onload = s.onreadystatechange = function () {
        if (!loaded
            && (!this.readyState || this.readyState == 'loaded' || this.readyState == 'complete')) {
          loaded = true;
          callback ();
        }
      };
    }
    document.getElementsByTagName ('head') [0].appendChild (s);
  }
}