#ifndef _LIB_RF_4x4_API_H
#define _LIB_RF_4x4_API_H

/* macro definitions */

void rfic_init_1 (void);
void rfic_init_2 (void);
void rfic_init_3 (void);
void rfic_init_4 (void);

void rfic_rxon (uint8_t AntMsk);
void rfic_rxoff (uint8_t AntMsk);
void rfic_txon (uint8_t AntMsk);
void rfic_txoff (uint8_t AntMsk);

void rfic_disable_fsys2 (void);
void rfic_enable_fsys2 (void);

void rfic_start_dc_clock (void);
void rfic_stop_dc_clock (void);

void rfic_start_dcramp0 (void);
void rfic_stop_dcramp0 (void);
void rfic_start_dcramp2 (void);
void rfic_stop_dcramp2 (void);

void rfic_enable_dac0_man (void);
void rfic_disable_dac0_man (void);
void rfic_enable_dac2_man (void);
void rfic_disable_dac2_man (void);

void rfic_set_dcintegrator(uint16_t IntBW0, uint16_t IntBW2);

void rfic_start_dccancel0 (void);
void rfic_stop_dccancel0 (void);
void rfic_start_dccancel2 (void);
void rfic_stop_dccancel2 (void);

void rfic_enable_filter_dccal (void);
void rfic_disable_filter_dccal (void);

void rfic_set_pllreset (void);
void rfic_release_pllreset (void);

void rfic_enable_lotree (void);
void rfic_disable_lotree (void);

void rfic_enable_filtercal_12_30 (void);
void rfic_disable_filtercal_12_30 (void);

void rfic_enable_filtercal_03_21 (void);
void rfic_disable_filtercal_03_21 (void);

void rfic_enable_iqbbcal_0_2 (void);
void rfic_disable_iqbbcal_0_2 (void);
void rfic_enable_iqbbcal_1_3 (void);
void rfic_disable_iqbbcal_1_3 (void);

void rfic_enable_tioloop_0 (void);
void rfic_disable_tioloop_0 (void);
void rfic_enable_tioloop_1 (void);
void rfic_disable_tioloop_1 (void);
void rfic_enable_toloop (void);
void rfic_disable_toloop (void);

void rfic_enable_ssbcal (uint8_t AntMsk);
void rfic_disable_ssbcal (uint8_t AntMsk);

void rfic_enable_bbio_0_1 (void);
void rfic_disable_bbio_0_1 (void);

void rfic_enable_bbio_1_0 (void);
void rfic_disable_bbio_1_0 (void);

void rfic_enable_bbio_2_0 (void);
void rfic_disable_bbio_2_0 (void);

void rfic_enable_bbio_3_0 (void);
void rfic_disable_bbio_3_0 (void);

void rfic_enable_bbio_x_y (uint8_t Antx, uint8_t Anty);
void rfic_disable_bbio_x_y (void);


void rfic_enable_bbo_0_0 (void);
void rfic_enable_bbo_1_0 (void);
void rfic_enable_bbo_2_0 (void);
void rfic_enable_bbo_3_0 (void);

void rfic_set_lo_frequency (uint16_t LoFreq);
void rfic_set_lo_frequencies (uint16_t LoFreq0,uint16_t LoFreq1,uint16_t LoFreq2,uint16_t LoFreq3,uint16_t LoFreq4,uint16_t LoFreq5);
void rfic_set_lo_frequency_40M (uint16_t LoFreq);

void rfic_trim_dcxo (uint8_t CapTrimX1,uint8_t CapTrimX2);

void rfic_start_tempsensor_clock (void);
void rfic_stop_tempsensor_clock (void);
void rfic_enable_tempsensor (void);
void rfic_disable_tempsensor (void);
void rfic_start_tempsensor_cal (void);
void rfic_stop_tempsensor_cal (void);
void rfic_start_tempsensor (void);

void rfic_antenna_off (uint8_t AntMsk);

void rfic_set_anamux2vddmon (void);
void rfic_set_anamux2ssi (void);

void rfic_enable_vddmon_cal (void);
void rfic_enable_vddmon_1V2rxldo (void);
void rfic_enable_vddmon_1V2txldo (void);
void rfic_enable_vddmon_1V2bbldo (void);
void rfic_enable_vddmon_1V2bbfilterldo (void);
void rfic_enable_vddmon_2V5ldo (void);
void rfic_enable_vddmon_1V5ldoin (void);
void rfic_enable_vddmon_3V3ldoin (void);
void rfic_disable_vddmon (void);
void rfic_toggle_vddmon_1 (void);
void rfic_toggle_vddmon_0 (void);

void rfic_enable_vddmon_central (void);
void rfic_disable_vddmon_central (void);
void rfic_enable_vddmon_bbioldo (void);
void rfic_disable_vddmon_bbioldo (void);
void rfic_enable_vddmon_lotreeldo0 (void);
void rfic_disable_vddmon_lotreeldo0 (void);
void rfic_enable_vddmon_lotreeldo1 (void);
void rfic_disable_vddmon_lotreeldo1 (void);
void rfic_enable_vddmon_lotreeldo2 (void);
void rfic_disable_vddmon_lotreeldo2 (void);
void rfic_enable_vddmon_lotreeldo3 (void);
void rfic_disable_vddmon_lotreeldo3 (void);
void rfic_enable_vddmon_fcsildo (void);
void rfic_disable_vddmon_fcsildo (void);
void rfic_enable_vddmon_fsysldo (void);
void rfic_disable_vddmon_fsysldo (void);

void rfic_config_txgain (uint8_t AntMsk, int gain0dB, int gain1dB, int gain2dB);
void rfic_config_lnagain (uint8_t AntMsk, int gain0idx, int gain1idx, int gain2idx, int gain3idx, int gain4idx, int gain5idx);
void rfic_config_s2dgain (uint8_t AntMsk, uint8_t gain0, uint8_t gain1, uint8_t gain2, uint8_t gain3, uint8_t gain4, uint8_t gain5);
void rfic_config_fectl (uint8_t AntMsk, uint8_t fectl0, uint8_t fectl1, uint8_t fectl2, uint8_t fectl3, uint8_t fectl4, uint8_t fectl5);
void rfic_config_rssi_high(uint8_t AntMsk, int gaindB, uint8_t offsetidx);
void rfic_config_rssi_low(uint8_t AntMsk, int gaindB, uint8_t offsetidx);

void rfic_set_rxgain (uint8_t AntMsk, uint8_t lnagainidx, int pgc1gaindB, int pgc2gaindB);
void rfic_set_txgain(uint8_t AntMsk, int pgc2gainidx, int prdattdB);
void rfic_set_tssi_gain_offset (uint8_t AntMsk, int gaindB, uint8_t offsetidx);
void rfic_set_tssi_rdiv (uint8_t rdiv);
void rfic_set_ssb_gain (uint8_t AntMsk, int gain1dB, int gain2dB);
void rfic_set_txband(uint8_t AntMsk, uint8_t bandsel);
void rfic_set_rxband(uint8_t AntMsk, uint8_t bandsel);
void rfic_set_lnaMidGain(uint8_t AntMsk, uint8_t lnaMidGAin);

void rfic_set_rfbandwidth(uint8_t AntMsk, uint8_t rf_bw);

void rfic_enable_lnanoise(uint8_t AntMsk);
void rfic_disable_lnanoise(uint8_t AntMsk);

void rfic_read_address(uint16_t address, uint16_t *p_data);
void rfic_read_efuse_values(uint16_t sections, uint16_t *softfuse_data);
uint16_t rfic_read_efuse_handlertemp(uint16_t *softfuse_data);
uint16_t rfic_read_efuse_tempsensorresult(uint16_t *softfuse_data);

void rfic_set_lotree_ldo(uint8_t AntMsk, int step);

#endif
