#include "mex.h"
#include <math.h>
#include "lib_rf_4x4_api.c"
#include "lib_rf_4x4_api.h"
// The gateway function

void check_parameter(int parameter1, int parameter2)
{
    if (parameter1 < parameter2+1)      //1- api_sting, 2-parameter1, 3-...
            mexErrMsgTxt("Wrong amount of parameters detected.");
}


void mexFunction( int nlhs, mxArray *plhs[],
        int nrhs, const mxArray *prhs[])
{
    double *lhparam0;
    char *input_buf;
    int frequency;
    int IntBW0, IntBW2;
    int frequencies[10];
    int i,k,step;
    int mask;
    int AntMsk, Antx, Anty;
    int gain0dB, gain1dB, gain2dB , gain3dB, gain4dB, gain5dB;
    int gain0, gain1, gain2, gain3, gain4, gain5;
    uint16_t read_data[4];
    uint16_t *softfuse_data;
    uint16_t int16_data[16];
    double double_data[16];
    double rdiv;
    int fectl0, fectl1, fectl2, fectl3, fectl4, fectl5;
    int gaindB, offsetidx, lnagainidx, pgc1gaindB, pgc2gaindB, pgc2gainidx, prdattdB;
    int captrimx1, captrimx2, address, sections, bandsel, rf_bw;
    int tempsensorresult, handlertemp, lnaMidGain;
    size_t buflen;
    buflen = (mxGetM(prhs[0]) * mxGetN(prhs[0])) + 1;
    input_buf = mxArrayToString(prhs[0]);
    
    
    mexPrintf("Input Function: %s\n", input_buf );
    
    if (0 == strcmp(input_buf,"rfic_init_1"))// the strings are equal
    {
        mexPrintf("rfic_init_1 \n");
        rfic_init_1();
    }
    else if (0 == strcmp(input_buf,"rfic_init_2"))// the strings are equal
    {
        mexPrintf("rfic_init_2 \n");
        rfic_init_2();
    }
    else if (0 == strcmp(input_buf,"rfic_init_3"))// the strings are equal
    {
        mexPrintf("rfic_init_3\n");
        rfic_init_3();
    }
    else if (0 == strcmp(input_buf,"rfic_init_4"))// the strings are equal
    {
        mexPrintf("rfic_init_4\n");
        rfic_init_4();
    }
    //*****************************************************************
     else if (0 == strcmp(input_buf,"rfic_rxon"))// the strings are equal
    {   mexPrintf("rfic_rxon\n");
        check_parameter(nrhs,1);
        mask = (int) mxGetScalar(prhs[1]);
        rfic_rxon(mask);
    }
    else if (0 == strcmp(input_buf,"rfic_rxoff"))// the strings are equal
    {    mexPrintf("rfic_rxoff\n");
         check_parameter(nrhs,1);
         mask = (int) mxGetScalar(prhs[1]);
         rfic_rxoff(mask);
    }
    else if (0 == strcmp(input_buf,"rfic_txon"))// the strings are equal
    {    mexPrintf("rfic_txon\n");
         check_parameter(nrhs,1);
         mask = (int) mxGetScalar(prhs[1]);
         rfic_txon(mask);
    }
    else if (0 == strcmp(input_buf,"rfic_txoff"))// the strings are equal
    {     mexPrintf("rfic_txoff\n");
          check_parameter(nrhs,1);
          mask = (int) mxGetScalar(prhs[1]);
          //mexPrintf("mask: %d\n", mask );
          rfic_txoff(mask);
    }
    //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_disable_fsys2"))// the strings are equal
    {
        mexPrintf("rfic_disable_fsys2\n");
        rfic_disable_fsys2();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_fsys2"))// the strings are equal
    {    mexPrintf("rfic_enable_fsys2\n");
         rfic_enable_fsys2();
    }
    //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_start_dc_clock"))// the strings are equal
    {    mexPrintf("rfic_start_dc_clock\n");
         rfic_start_dc_clock();
    }
    else if (0 == strcmp(input_buf,"rfic_stop_dc_clock"))// the strings are equal
    {    mexPrintf("rfic_stop_dc_clock\n");
         rfic_stop_dc_clock();
    }
    //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_start_dcramp0"))// the strings are equal
    {      mexPrintf("rfic_start_dcramp0\n");
           rfic_start_dcramp0();
    }
    else if (0 == strcmp(input_buf,"rfic_stop_dcramp0"))// the strings are equal
    {      mexPrintf("rfic_stop_dcramp0\n");
           rfic_stop_dcramp0();
    }
    else if (0 == strcmp(input_buf,"rfic_start_dcramp2"))// the strings are equal
    {      mexPrintf("rfic_start_dcramp2\n");
           rfic_start_dcramp2();
    }
    else if (0 == strcmp(input_buf,"rfic_stop_dcramp2"))// the strings are equal
    {      mexPrintf("rfic_stop_dcramp2\n");
           rfic_stop_dcramp2();
    }
    
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_dac0_man"))// the strings are equal
    {      mexPrintf("rfic_enable_dac0_man\n");
           rfic_enable_dac0_man();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_dac0_man"))// the strings are equal
    {      mexPrintf("rfic_disable_dac0_man\n");
           rfic_disable_dac0_man();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_dac2_man"))// the strings are equal
    {      mexPrintf("rfic_enable_dac2_man\n");
           rfic_enable_dac2_man();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_dac2_man"))// the strings are equal
    {      mexPrintf("rfic_disable_dac2_man\n");
           rfic_disable_dac2_man();
    }
    
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_set_dcintegrator"))// the strings are equal
    {      mexPrintf("rfic_set_dcintegrator\n");
           check_parameter(nrhs,2);
           IntBW0 = (int) mxGetScalar(prhs[1]);
           IntBW2 = (int) mxGetScalar(prhs[2]);
           mexPrintf("IntBW0: %d, IntBW2: %d\n", IntBW0, IntBW2 );
           rfic_set_dcintegrator(IntBW0,IntBW2);
    }
    
    else if (0 == strcmp(input_buf,"rfic_start_dccancel0"))// the strings are equal
    {      mexPrintf("rfic_start_dccancel0\n");
           rfic_start_dccancel0();
    }
  
    else if (0 == strcmp(input_buf,"rfic_stop_dccancel0"))// the strings are equal
    {      mexPrintf("rfic_stop_dccancel0\n");
           rfic_stop_dccancel0();
    }

    else if (0 == strcmp(input_buf,"rfic_start_dccancel2"))// the strings are equal
    {      mexPrintf("rfic_start_dccancel2\n");
           rfic_start_dccancel2();
    }
    
    else if (0 == strcmp(input_buf,"rfic_stop_dccancel2"))// the strings are equal
    {      mexPrintf("rfic_stop_dccancel2\n");
           rfic_stop_dccancel2();
    }

    else if (0 == strcmp(input_buf,"rfic_enable_filter_dccal"))// the strings are equal
    {      mexPrintf("rfic_enable_filter_dccal\n");
           rfic_enable_filter_dccal();
    }

    else if (0 == strcmp(input_buf,"rfic_disable_filter_dccal"))// the strings are equal
    {      mexPrintf("rfic_disable_filter_dccal\n");
           rfic_disable_filter_dccal();
    }

    
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_set_pllreset"))// the strings are equal
    {      mexPrintf("rfic_set_pllreset\n");
           rfic_set_pllreset();
    }
    else if (0 == strcmp(input_buf,"rfic_release_pllreset"))// the strings are equal
    {      mexPrintf("rfic_release_pllreset\n");
           rfic_release_pllreset();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_lotree"))// the strings are equal
    {     mexPrintf("rfic_enable_lotree\n");
          rfic_enable_lotree();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_lotree"))// the strings are equal
    {     mexPrintf("rfic_disable_lotree\n");
          rfic_disable_lotree();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_filtercal_12_30"))// the strings are equal
    {      mexPrintf("rfic_enable_filtercal_12_30\n");
           rfic_enable_filtercal_12_30();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_filtercal_12_30"))// the strings are equal
    {     mexPrintf("rfic_disable_filtercal_12_30\n");
          rfic_disable_filtercal_12_30();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_filtercal_03_21"))// the strings are equal
    {     mexPrintf("rfic_enable_filtercal_03_21\n");
          rfic_enable_filtercal_03_21();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_filtercal_03_21"))// the strings are equal
    {     mexPrintf("rfic_disable_filtercal_03_21\n");
          rfic_disable_filtercal_03_21();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_iqbbcal_0_2"))// the strings are equal
    {      mexPrintf("rfic_enable_iqbbcal_0_2\n");
           rfic_enable_iqbbcal_0_2();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_iqbbcal_0_2"))// the strings are equal
    {      mexPrintf("rfic_disable_iqbbcal_0_2\n");
           rfic_disable_iqbbcal_0_2();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_iqbbcal_1_3"))// the strings are equal
    {      mexPrintf("rfic_enable_iqbbcal_1_3\n");
           rfic_enable_iqbbcal_1_3();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_iqbbcal_1_3"))// the strings are equal
    {      mexPrintf("rfic_disable_iqbbcal_1_3\n");
           rfic_disable_iqbbcal_1_3();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_tioloop_0"))// the strings are equal
    {     mexPrintf("rfic_enable_tioloop_0\n");
          rfic_enable_tioloop_0();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_tioloop_0"))// the strings are equal
    {     mexPrintf("rfic_disable_tioloop_0\n");
          rfic_disable_tioloop_0();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_tioloop_1"))// the strings are equal
    {     mexPrintf("rfic_enable_tioloop_1\n");
          rfic_enable_tioloop_1();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_tioloop_1"))// the strings are equal
    {      mexPrintf("rfic_disable_tioloop_1\n");
           rfic_disable_tioloop_1();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_toloop"))// the strings are equal
    {     mexPrintf("rfic_enable_toloop\n");
          rfic_enable_toloop();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_toloop"))// the strings are equal
    {     mexPrintf("rfic_disable_toloop\n");
          rfic_disable_toloop();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_ssbcal"))// the strings are equal
    {     mexPrintf("rfic_enable_ssbcal\n");
          check_parameter(nrhs,1);
          AntMsk = (int) mxGetScalar(prhs[1]);
          mexPrintf("AntMsk: %d\n", AntMsk );
          rfic_enable_ssbcal(AntMsk);
    }
    else if (0 == strcmp(input_buf,"rfic_disable_ssbcal"))// the strings are equal
    {     mexPrintf("rfic_disable_ssbcal\n");
          check_parameter(nrhs,1);
          AntMsk = (int) mxGetScalar(prhs[1]);
          mexPrintf("AntMsk: %d\n", AntMsk );
          rfic_disable_ssbcal(AntMsk);
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_bbio_0_1"))// the strings are equal
    {      mexPrintf("rfic_enable_bbio_0_1\n");
           rfic_enable_bbio_0_1();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_bbio_0_1"))// the strings are equal
    {     mexPrintf("rfic_disable_bbio_0_1\n");
          rfic_disable_bbio_0_1();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_bbio_1_0"))// the strings are equal
    {      mexPrintf("rfic_enable_bbio_1_0\n");
           rfic_enable_bbio_1_0();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_bbio_1_0"))// the strings are equal
    {     mexPrintf("rfic_disable_bbio_1_0\n");
          rfic_disable_bbio_1_0();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_bbio_2_0"))// the strings are equal
    {      mexPrintf("rfic_enable_bbio_2_0\n");
           rfic_enable_bbio_2_0();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_bbio_2_0"))// the strings are equal
    {     mexPrintf("rfic_disable_bbio_2_0\n");
          rfic_disable_bbio_2_0();
    }
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_bbio_3_0"))// the strings are equal
    {      mexPrintf("rfic_enable_bbio_3_0\n");
           rfic_enable_bbio_3_0();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_bbio_3_0"))// the strings are equal
    {     mexPrintf("rfic_disable_bbio_3_0\n");
          rfic_disable_bbio_3_0();
    }
    
    else if (0 == strcmp(input_buf,"rfic_enable_bbio_x_y"))// the strings are equal
    {      mexPrintf("rfic_enable_bbio_x_y\n");
           check_parameter(nrhs,2);
           Antx = (int) mxGetScalar(prhs[1]);
           Anty = (int) mxGetScalar(prhs[2]);
           mexPrintf("Antenna x: %d, Antenna y: %d\n", Antx, Anty );
           rfic_enable_bbio_x_y(Antx,Anty);
    }
    else if (0 == strcmp(input_buf,"rfic_disable_bbio_x_y"))// the strings are equal
    {     mexPrintf("rfic_disable_bbio_x_y\n");
          rfic_disable_bbio_x_y();
    }
    
    else if (0 == strcmp(input_buf,"rfic_enable_bbo_0_0"))// the strings are equal
    {     mexPrintf("rfic_enable_bbo_0_0\n");
          rfic_enable_bbo_0_0();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_bbo_1_0"))// the strings are equal
    {     mexPrintf("rfic_enable_bbo_1_0\n");
          rfic_enable_bbo_1_0();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_bbo_2_0"))// the strings are equal
    {     mexPrintf("rfic_enable_bbo_2_0\n");
          rfic_enable_bbo_2_0();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_bbo_3_0"))// the strings are equal
    {     mexPrintf("rfic_enable_bbo_3_0\n");
          rfic_enable_bbo_3_0();
    }
   
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_set_lo_frequency"))// the strings are equal
    {      mexPrintf("rfic_set_lo_frequency\n");
           check_parameter(nrhs,1);
           frequency = (int) mxGetScalar(prhs[1]);
           mexPrintf("fr: %d\n", frequency );
           rfic_set_lo_frequency(frequency);
    }
    else if (0 == strcmp(input_buf,"rfic_set_lo_frequencies"))// the strings are equal
    {     mexPrintf("rfic_set_lo_frequencies\n");
          for ( i = 1; i<nrhs; i++){
              frequencies[i-1] = (int) mxGetScalar(prhs[i]);
              mexPrintf("fr: %d\n", frequencies[i-1] );
          }
          rfic_set_lo_frequencies(frequencies[0],frequencies[1],frequencies[2],frequencies[3],frequencies[4],frequencies[5] );
          //4900-5950 step 5
    }
    else if (0 == strcmp(input_buf,"rfic_set_lo_frequency_40M"))// the strings are equal
    {      mexPrintf("rfic_set_lo_frequency_40M\n");
           check_parameter(nrhs,1);
           frequency = (int) mxGetScalar(prhs[1]);
           mexPrintf("fr: %d\n", frequency );
           rfic_set_lo_frequency_40M(frequency);
    }
    else if (0 == strcmp(input_buf,"rfic_trim_dcxo"))// the strings are equal
    {      mexPrintf("rfic_trim_dcxo\n");
           check_parameter(nrhs,2);
           captrimx1 = (int) mxGetScalar(prhs[1]);
           captrimx2 = (int) mxGetScalar(prhs[2]);
           mexPrintf("Cap_Trim_X1: %d, Cap_Trim_X2: %d\n", captrimx1, captrimx2 );
           rfic_trim_dcxo(captrimx1,captrimx2);
    }
    
    
     //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_start_tempsensor_clock"))// the strings are equal
    {     mexPrintf("rfic_start_tempsensor_clock\n");
          rfic_start_tempsensor_clock();
    }
    else if (0 == strcmp(input_buf,"rfic_stop_tempsensor_clock"))// the strings are equal
    {     mexPrintf("rfic_stop_tempsensor_clock\n");
          rfic_stop_tempsensor_clock();
    }
    
    else if (0 == strcmp(input_buf,"rfic_enable_tempsensor"))// the strings are equal
    {      mexPrintf("rfic_enable_tempsensor\n");
           rfic_enable_tempsensor();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_tempsensor"))// the strings are equal
    {      mexPrintf("rfic_disable_tempsensor\n");
           rfic_disable_tempsensor();
    }
    else if (0 == strcmp(input_buf,"rfic_start_tempsensor_cal"))// the strings are equal
    {      mexPrintf("rfic_start_tempsensor_cal\n");
           rfic_start_tempsensor_cal();
    }
    else if (0 == strcmp(input_buf,"rfic_stop_tempsensor_cal"))// the strings are equal
    {      mexPrintf("rfic_stop_tempsensor_cal\n");
           rfic_stop_tempsensor_cal();
    }
    
    else if (0 == strcmp(input_buf,"rfic_start_tempsensor"))// the strings are equal
    {      mexPrintf("rfic_start_tempsensor\n");
           rfic_start_tempsensor();
    }
     //*****************************************************************
       else if (0 == strcmp(input_buf,"rfic_antenna_off"))// the strings are equal
    {   mexPrintf("rfic_antenna_off\n");
        AntMsk = (int) mxGetScalar(prhs[1]);
        rfic_antenna_off(AntMsk);
    }
    //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_set_anamux2vddmon"))// the strings are equal
    {      mexPrintf("rfic_set_anamux2vddmon\n");
           rfic_set_anamux2vddmon();
    }
    else if (0 == strcmp(input_buf,"rfic_set_anamux2ssi"))// the strings are equal
    {      mexPrintf("rfic_set_anamux2ssi\n");
           rfic_set_anamux2ssi();
    }
    //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_cal"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_cal\n");
           rfic_enable_vddmon_cal ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_1V2rxldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_1V2rxldo\n");
           rfic_enable_vddmon_1V2rxldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_1V2txldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_1V2txldo\n");
           rfic_enable_vddmon_1V2txldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_1V2bbldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_1V2bbldo\n");
           rfic_enable_vddmon_1V2bbldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_1V2bbfilterldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_1V2bbfilterldo\n");
           rfic_enable_vddmon_1V2bbfilterldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_2V5ldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_2V5ldo\n");
           rfic_enable_vddmon_2V5ldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_1V5ldoin"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_1V5ldoin\n");
           rfic_enable_vddmon_1V5ldoin ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_3V3ldoin"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_3V3ldoin\n");
           rfic_enable_vddmon_3V3ldoin ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon\n");
           rfic_disable_vddmon ();
    }
    else if (0 == strcmp(input_buf,"rfic_toggle_vddmon_1"))// the strings are equal
    {      mexPrintf("rfic_toggle_vddmon_1\n");
           rfic_toggle_vddmon_1 ();
    }
    else if (0 == strcmp(input_buf,"rfic_toggle_vddmon_0"))// the strings are equal
    {      mexPrintf("rfic_toggle_vddmon_0\n");
           rfic_toggle_vddmon_0 ();
    }
    //*****************************************************************
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_central"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_central\n");
           rfic_enable_vddmon_central ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_central"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_central\n");
           rfic_disable_vddmon_central ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_bbioldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_bbioldo\n");
           rfic_enable_vddmon_bbioldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_bbioldo"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_bbioldo\n");
           rfic_disable_vddmon_bbioldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_lotreeldo0"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_lotreeldo0\n");
           rfic_enable_vddmon_lotreeldo0 ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_lotreeldo0"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_lotreeldo0\n");
           rfic_disable_vddmon_lotreeldo0 ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_lotreeldo1"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_lotreeldo1\n");
           rfic_enable_vddmon_lotreeldo1 ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_lotreeldo1"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_lotreeldo1\n");
           rfic_disable_vddmon_lotreeldo1 ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_lotreeldo2"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_lotreeldo2\n");
           rfic_enable_vddmon_lotreeldo2 ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_lotreeldo2"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_lotreeldo2\n");
           rfic_disable_vddmon_lotreeldo2 ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_lotreeldo3"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_lotreeldo3\n");
           rfic_enable_vddmon_lotreeldo3 ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_lotreeldo3"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_lotreeldo3\n");
           rfic_disable_vddmon_lotreeldo3 ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_fcsildo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_fcsildo\n");
           rfic_enable_vddmon_fcsildo ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_fcsildo"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_fcsildo\n");
           rfic_disable_vddmon_fcsildo ();
    }
    else if (0 == strcmp(input_buf,"rfic_enable_vddmon_fsysldo"))// the strings are equal
    {      mexPrintf("rfic_enable_vddmon_fsysldo\n");
           rfic_enable_vddmon_fsysldo ();
    }
    else if (0 == strcmp(input_buf,"rfic_disable_vddmon_fsysldo"))// the strings are equal
    {      mexPrintf("rfic_disable_vddmon_fsysldo\n");
           rfic_disable_vddmon_fsysldo ();
    }
     //*****************************************************************
        else if (0 == strcmp(input_buf,"rfic_config_txgain"))// the strings are equal
    {      mexPrintf("rfic_config_txgain\n");
           check_parameter(nrhs,4);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gain0dB = (int) mxGetScalar(prhs[2]);
           gain1dB = (int) mxGetScalar(prhs[3]);
           gain2dB = (int) mxGetScalar(prhs[4]);
           mexPrintf("AntMsk: %d gain0dB: %d gain1dB: %d gain2dB: %d\n", AntMsk, gain0dB, gain1dB, gain2dB );
           rfic_config_txgain(AntMsk, gain0dB, gain1dB, gain2dB);
    }
    
        else if (0 == strcmp(input_buf,"rfic_config_lnagain"))// the strings are equal
    {      mexPrintf("rfic_config_lnagain\n");
           check_parameter(nrhs,7);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gain0dB = (int) mxGetScalar(prhs[2]);
           gain1dB = (int) mxGetScalar(prhs[3]);
           gain2dB = (int) mxGetScalar(prhs[4]);
           gain3dB = (int) mxGetScalar(prhs[5]);
           gain4dB = (int) mxGetScalar(prhs[6]);
           gain5dB = (int) mxGetScalar(prhs[7]);
           mexPrintf("AntMsk: %d, gain0dB: %d gain1dB: %d gain2dB: %d gain3dB: %d gain4dB: %d gain5dB: %d\n", AntMsk, gain0dB, gain1dB, gain2dB, gain3dB, gain4dB, gain5dB );
           rfic_config_lnagain(AntMsk, gain0dB, gain1dB, gain2dB, gain3dB, gain4dB, gain5dB);
    }
     else if (0 == strcmp(input_buf,"rfic_config_s2dgain"))// the strings are equal
    {      mexPrintf("rfic_config_s2dgain\n");
           check_parameter(nrhs,7);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gain0 = (int) mxGetScalar(prhs[2]);
           gain1 = (int) mxGetScalar(prhs[3]);
           gain2 = (int) mxGetScalar(prhs[4]);
           gain3 = (int) mxGetScalar(prhs[5]);
           gain4 = (int) mxGetScalar(prhs[6]);
           gain5 = (int) mxGetScalar(prhs[7]);
           mexPrintf("AntMsk: %d gain0: %d gain1: %d gain2: %d gain3: %d gain4: %d gain5: %d\n", AntMsk, gain0, gain1, gain2, gain3, gain4, gain5 );
           rfic_config_s2dgain(AntMsk, gain0, gain1, gain2, gain3, gain4, gain5);
    }
         else if (0 == strcmp(input_buf,"rfic_config_fectl"))// the strings are equal
    {      mexPrintf("rfic_config_fectl\n");
           check_parameter(nrhs,7);
           AntMsk = (int) mxGetScalar(prhs[1]);
           fectl0 = (int) mxGetScalar(prhs[2]);
           fectl1 = (int) mxGetScalar(prhs[3]);
           fectl2 = (int) mxGetScalar(prhs[4]);
           fectl3 = (int) mxGetScalar(prhs[5]);
           fectl4 = (int) mxGetScalar(prhs[6]);
           fectl5 = (int) mxGetScalar(prhs[7]);
           mexPrintf("AntMsk: %d fectl0: %d fectl1: %d fectl2: %d fectl3: %d fectl4: %d fectl5: %d\n", AntMsk, fectl0, fectl1, fectl2, fectl3, fectl4, fectl5 );
           rfic_config_fectl(AntMsk, fectl0, fectl1, fectl2, fectl3, fectl4, fectl5);
    }
    
    else if (0 == strcmp(input_buf,"rfic_config_rssi_high"))// the strings are equal
    {      mexPrintf("rfic_config_rssi_high\n");
           check_parameter(nrhs,3);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gaindB = (int) mxGetScalar(prhs[2]);
           offsetidx = (int) mxGetScalar(prhs[3]);
           mexPrintf("AntMsk: %d gaindB: %d offsetidx: %d\n", AntMsk, gaindB, offsetidx );
           rfic_config_rssi_high(AntMsk, gaindB, offsetidx);
    }

    else if (0 == strcmp(input_buf,"rfic_config_rssi_low"))// the strings are equal
    {      mexPrintf("rfic_config_rssi_low\n");
           check_parameter(nrhs,3);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gaindB = (int) mxGetScalar(prhs[2]);
           offsetidx = (int) mxGetScalar(prhs[3]);
           mexPrintf("AntMsk: %d gaindB: %d offsetidx: %d\n", AntMsk, gaindB, offsetidx );
           rfic_config_rssi_low(AntMsk, gaindB, offsetidx);
    }

    else if (0 == strcmp(input_buf,"rfic_set_rxgain"))// the strings are equal
    {      mexPrintf("rfic_set_rxgain\n");
           check_parameter(nrhs,4);
           AntMsk = (int) mxGetScalar(prhs[1]);
           lnagainidx = (int) mxGetScalar(prhs[2]);
           pgc1gaindB = (int) mxGetScalar(prhs[3]);
           pgc2gaindB = (int) mxGetScalar(prhs[4]);
           mexPrintf("AntMsk: %d lnagainidx: %d pgc1gaindB: %d pgc2gaindB: %d\n", AntMsk, lnagainidx, pgc1gaindB, pgc2gaindB );
           rfic_set_rxgain(AntMsk, lnagainidx, pgc1gaindB, pgc2gaindB);
    }
    
    else if (0 == strcmp(input_buf,"rfic_set_txgain"))// the strings are equal
    {      mexPrintf("rfic_set_txgain\n");
           check_parameter(nrhs,3);
           AntMsk = (int) mxGetScalar(prhs[1]);
           pgc2gainidx = (int) mxGetScalar(prhs[2]);
           prdattdB = (int) mxGetScalar(prhs[3]);
           mexPrintf("AntMsk: %d pgc2gainidx: %d prdattdB: %d\n", AntMsk, pgc2gainidx, prdattdB);
           rfic_set_txgain(AntMsk, pgc2gainidx, prdattdB);
    }
        
    else if (0 == strcmp(input_buf,"rfic_set_tssi_gain_offset"))// the strings are equal
    {      mexPrintf("rfic_set_tssi_gain_offset\n");
           check_parameter(nrhs,3);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gaindB = (int) mxGetScalar(prhs[2]);
           offsetidx = (int) mxGetScalar(prhs[3]);
           mexPrintf("AntMsk: %d gaindB: %d offsetidx: %d\n", AntMsk, gaindB, offsetidx );
           rfic_set_tssi_gain_offset(AntMsk, gaindB, offsetidx);
    }

    else if (0 == strcmp(input_buf,"rfic_set_tssi_rdiv"))// the strings are equal
    {      mexPrintf("rfic_set_tssi_rdiv\n");
           check_parameter(nrhs,1);
           rdiv = (double) mxGetScalar(prhs[1]);
           mexPrintf("Resistive Divider %3.1f, CTL_TSSI_RANGE %d\n", rdiv, (int) (fabs(rdiv-0.9) < 1.0e-10) );
           rfic_set_tssi_rdiv(rdiv);
    }

    else if (0 == strcmp(input_buf,"rfic_set_ssb_gain"))// the strings are equal
    {      mexPrintf("rfic_set_ssb_gain\n");
           check_parameter(nrhs,3);
           AntMsk = (int) mxGetScalar(prhs[1]);
           gain1dB = (int) mxGetScalar(prhs[2]);
           gain2dB = (int) mxGetScalar(prhs[3]);
           mexPrintf("AntMsk: %d gain1dB: %d gain2dB: %d\n",AntMsk, gain1dB, gain2dB);
           rfic_set_ssb_gain(AntMsk, gain1dB, gain2dB);
    }

    else if (0 == strcmp(input_buf,"rfic_set_txband"))// the strings are equal
    {      mexPrintf("rfic_set_txband\n");
           check_parameter(nrhs,2);
           AntMsk = (int) mxGetScalar(prhs[1]);
           bandsel = (int) mxGetScalar(prhs[2]);
           mexPrintf("AntMsk: %d TX Band selection index: %d\n",AntMsk, bandsel);
           rfic_set_txband(AntMsk, bandsel);
    }

    else if (0 == strcmp(input_buf,"rfic_set_rxband"))// the strings are equal
    {      mexPrintf("rfic_set_rxband\n");
           check_parameter(nrhs,2);
           AntMsk = (int) mxGetScalar(prhs[1]);
           bandsel = (int) mxGetScalar(prhs[2]);
           mexPrintf("AntMsk: %d RX Band selection index: %d\n",AntMsk, bandsel);
           rfic_set_rxband(AntMsk, bandsel);
    }

    else if (0 == strcmp(input_buf,"rfic_set_lnaMidGain"))// the strings are equal
    {      mexPrintf("rfic_set_lnaMidGain\n");
           check_parameter(nrhs,2);
           AntMsk = (int) mxGetScalar(prhs[1]);
           lnaMidGain = (int) mxGetScalar(prhs[2]);
           mexPrintf("AntMsk: %d LNA Mid Gain Tuning value: %d\n",AntMsk, lnaMidGain);
           rfic_set_lnaMidGain(AntMsk, lnaMidGain);
    }
    
    else if (0 == strcmp(input_buf,"rfic_set_rfbandwidth"))// the strings are equal
    {      mexPrintf("rfic_set_rfbandwidth\n");
           check_parameter(nrhs,2);
           AntMsk = (int) mxGetScalar(prhs[1]);
           rf_bw = (int) mxGetScalar(prhs[2]);
           mexPrintf("AntMsk: %d RF Bandwidth (MHz or Code): %d\n",AntMsk, rf_bw);
           rfic_set_rfbandwidth(AntMsk, rf_bw);
    }

    else if (0 == strcmp(input_buf,"rfic_enable_lnanoise"))// the strings are equal
    {      mexPrintf("rfic_enable_lnanoise\n");
           check_parameter(nrhs,1);
           AntMsk = (int) mxGetScalar(prhs[1]);
           mexPrintf("AntMsk: %d \n",AntMsk);
           rfic_enable_lnanoise(AntMsk);
    }

    else if (0 == strcmp(input_buf,"rfic_disable_lnanoise"))// the strings are equal
    {      mexPrintf("rfic_disable_lnanoise\n");
           check_parameter(nrhs,1);
           AntMsk = (int) mxGetScalar(prhs[1]);
           mexPrintf("AntMsk: %d \n",AntMsk);
           rfic_disable_lnanoise(AntMsk);
    }

    else if (0 == strcmp(input_buf,"rfic_read_address"))// the strings are equal
    {      mexPrintf("rfic_read_address\n");
           check_parameter(nrhs,1);
           address = (int) mxGetScalar(prhs[1]);
           read_data[0] = 0;
           read_data[1] = 0;
           read_data[2] = 0;
           read_data[3] = 0;
           rfic_read_address(address, &read_data[0]);
           mexPrintf("Address: 0x%04x --> Ant0: 0x%04x, Ant1: 0x%04x, Ant2: 0x%04x, Ant3: 0x%04x\n", address, read_data[0], read_data[1], read_data[2], read_data[3]);
           plhs[0] = mxCreateDoubleMatrix(1,4, mxREAL);
           lhparam0 = mxGetPr(plhs[0]);
           lhparam0[0]= (double) read_data[0];
           lhparam0[1]= (double) read_data[1];
           lhparam0[2]= (double) read_data[2];
           lhparam0[3]= (double) read_data[3];

    }

    else if (0 == strcmp(input_buf,"rfic_read_efuse_values"))// the strings are equal
    {      mexPrintf("rfic_read_efuse_values\n");
           sections = (int) mxGetScalar(prhs[1]);
           if (nrhs == 1)
               int16_data[15] = 0;
           else
           {
               check_parameter(nrhs,2);
               k = mxGetN(prhs[2]);     // number of rows
               mexPrintf(" array with %d elements detected\n", k);
               if (k<16)  mexErrMsgTxt("array size must be at least 16 parameters");
               
               memcpy(double_data, mxGetPr(prhs[2]), 16*sizeof(double));
               for(k=0;k<16;k++)
               {
                    int16_data[k] = (uint16_t) double_data[k];
               }
           }
           softfuse_data = &int16_data[0];
           rfic_read_efuse_values(sections, &softfuse_data[0]);
           mexPrintf("Sections: %d %d %d\n", sections, int16_data[0], double_data[0]);
    }
    
    else if (0 == strcmp(input_buf,"rfic_read_efuse_handlertemp"))// the strings are equal
    {      mexPrintf("rfic_read_efuse_handlertemp\n");
           if (nrhs == 1)
               int16_data[15] = 0;
           else
           {
               check_parameter(nrhs,1);
               k = mxGetN(prhs[1]);     // number of rows
               mexPrintf(" array with %d elements detected\n", k);
               if (k<16)  mexErrMsgTxt("array size must be at least 16 parameters");
               
               memcpy(double_data, mxGetPr(prhs[1]), 16*sizeof(double));
               for(k=0;k<16;k++)
               {
                    int16_data[k] = (uint16_t) double_data[k];
               }
           }
           softfuse_data = &int16_data[0];
           handlertemp = rfic_read_efuse_handlertemp(&softfuse_data[0]);
           mexPrintf("Handler Temperature: %d\n", handlertemp);
    }
    
    else if (0 == strcmp(input_buf,"rfic_read_efuse_tempsensorresult"))// the strings are equal
    {      mexPrintf("rfic_read_efuse_tempsensorresult\n");
           if (nrhs == 1)
               int16_data[15] = 0;
           else
           {
               check_parameter(nrhs,1);
               k = mxGetN(prhs[1]);     // number of rows
               mexPrintf(" array with %d elements detected\n", k);
               if (k<16)  mexErrMsgTxt("array size must be at least 16 parameters");
               
               memcpy(double_data, mxGetPr(prhs[1]), 16*sizeof(double));
               for(k=0;k<16;k++)
               {
                    int16_data[k] = (uint16_t) double_data[k];
               }
           }
           softfuse_data = &int16_data[0];
           tempsensorresult = rfic_read_efuse_tempsensorresult(&softfuse_data[0]);
           mexPrintf("Tempsensor Result: %d\n", tempsensorresult);
    }
    
    
    else if (0 == strcmp(input_buf,"rfic_set_lotree_ldo"))// the strings are equal
    {      mexPrintf("rfic_set_lotree_ldo\n");
           check_parameter(nrhs,2);
           AntMsk = (int) mxGetScalar(prhs[1]);
           step = (int) mxGetScalar(prhs[2]);
           mexPrintf("AntMsk: %d LO Tree LDO Programming Step: %d\n",AntMsk, step);
           rfic_set_lotree_ldo(AntMsk, step);
    }
    
    else
    {
           mexErrMsgTxt("API function not found.");
    }

    mxFree(input_buf);
    return;
}



void RFIC_FCSI_Write_mex(uint16_t AntMsk, uint16_t address, uint16_t value)
{
    mxArray  *input_array[3];
    
    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0,NULL, 3 ,&input_array[0],"BBS_RFIC_FCSI_WRITE");
}
void RFIC_FCSI_RMW_mex(uint16_t AntMsk,uint16_t  address,uint16_t mask, uint16_t value)

{
    mxArray  *input_array[4];
    
    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    input_array[2]=mxCreateDoubleScalar((double)mask);
    input_array[3]=mxCreateDoubleScalar((double)value);
    
    mexCallMATLAB( 0,NULL, 4 ,&input_array[0],"BBS_RFIC_FCSI_RMW");
    
}

uint16_t RFIC_FCSI_Read_mex(uint16_t AntMsk, uint16_t address, uint16_t *rdata)

{
    mxArray  *input_array[2];
    mxArray  *output_array[1];
    double_t *read_par;
    int k;
    
    input_array[0]=mxCreateDoubleScalar((double)AntMsk);
    input_array[1]=mxCreateDoubleScalar((double)address);
    
    mexCallMATLAB( 1,output_array, 2 ,input_array,"BBS_RFIC_FCSI_READ");
    
    k = mxGetM(output_array[0]);     // number of colums
    if (k<4)  mexErrMsgTxt("array size must be at least 4 parameters");
    
    read_par = mxGetPr(output_array[0]);
    
    rdata[0]     = (uint16_t) read_par[0];
    rdata[1]     = (uint16_t) read_par[1];
    rdata[2]     = (uint16_t) read_par[2];
    rdata[3]     = (uint16_t) read_par[3];
    
    return 0;
}
