/**
 *
 */
// INITIAL
function initial () {
  var locationSearch = window.location.search;
  var keys = locationSearch.split ('?', 3);
  var busName = keys [1];
  var viewName = keys [2];
  var bus = window [busName];

  createTitle (bus);
  createDescription (bus);
  createViewsTable (bus, viewName);
  createHierarchy (bus, viewName);
  genInfo (bus, viewName);
  createAttributesTable (bus, viewName);
  createMasterPortTable (bus, viewName);
  createSlavePortTable (bus, viewName);
  createTopography (bus, viewName);
  createDebugMsgTable (bus, viewName);
  createFooter (bus);

  initChapter ("description", 0);
  initChapter ("views", 0);
  initChapter ("hierarchy", 1);
  initChapter ("info", 0);
  initChapter ("attributes", 0);
  initChapter ("masterPorts", 0);
  initChapter ("slavePorts", 0);
  initChapter ("topography", 1);
  initChapter ("debugmsg", 1);

  scaleObjects ();
  window.onresize = scaleObjects;
}

function createMasterPortTable (bus, viewName) {
  var masterBus = bus;

  if (masterBus == undefined) {
    hideBundle ("masterPortsBody", undefined);
    return;
  }

  var refName = "masterPorts" + Math.ceil (Math.random () * 1000).toString ();
  masterBus.masterPorts.jsName = refName;
  window [refName] = masterBus.masterPorts;
  createPortsTable0Init (masterBus.masterPorts, viewName, "masterPorts");
}
function createSlavePortTable (bus, viewName) {
  var slaveBus = bus;

  if (slaveBus == undefined) {
    hideBundle ("slavePortsBody", undefined);
    return;
  }
  var refName = "slavePorts" + Math.ceil (Math.random () * 1000).toString ();
  slaveBus.slavePorts.jsName = refName;
  window [refName] = slaveBus.slavePorts;
  createPortsTable0Init (slaveBus.slavePorts, viewName, "slavePorts");
}

function genInfo (bus, viewName) {
  var head = document.getElementById ("infoHead");

  head.innerHTML += createToggleImage ("info");

  genInfo0 (bus, viewName);
}

function genInfo0 (bus, viewName) {
  // Description
  var body = document.getElementById ("infoBody0");
  var view = window [viewName];
  // Table Caption
  // <caption><sup>M</sup>Module <sup>P</sup>Port <sup>B</sup>Bus
  // <sup>R</sup>Register</caption>
  var caption = document.createElement ("caption");
  var one = document.createElement ("sup");
  one.innerHTML = "1";
  var text = document.createTextNode ("According to the current view's addressing scheme (Addr.base="
      + int2dec (vlogb2int (view.addrBase)) + " / Data width="
      + int2dec (vlogb2int (view.dataWidth [viewName])));
  caption.appendChild (one);
  caption.appendChild (text);
  body.appendChild (caption);

  var row;
  var cell;
  var link;

  // Table Headers
  var headerCells = [ "Parameter", "Value" ];
  row = document.createElement ("tr");
  for (idx in headerCells) {
    cell = document.createElement ("th");
    cell.innerHTML = headerCells [idx];
    row.appendChild (cell);
  }
  body.appendChild (row);

  // Table Body
  // Row: Module
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Module";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = window [bus.parent].aliasName;
  cell.innerHTML += " (" + window [bus.parent].baseName + ")";
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Base
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Bus Address Base";
  cell.title = "Smallest amount of data bits addressible by address lines";
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (bus.addrBase), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Data Width
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Bus Data Width";
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (bus.dataWidth [bus.jsName]), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Data Width
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Bus Data Width"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (vlogb2int (bus.dataWidth [viewName]), 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: View Offset
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("View Offset"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (getViewAddrStart (bus, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Local Offset
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Local Offset"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (getAddrStart (bus, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Local Offset (native)
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Local Offset";
  row.appendChild (cell);
  cell = createNrTableCell (getAddrStart (bus, bus.jsName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Space
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.appendChild (document.createTextNode ("Occupied Address Space"));
  cell.appendChild (one);
  row.appendChild (cell);
  cell = createNrTableCell (getAddrSpace (bus, viewName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Address Space (native)
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Occupied Address Space";
  row.appendChild (cell);
  cell = createNrTableCell (getAddrSpace (bus, bus.jsName), 32, "hex");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Access
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "View Access";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = bus.access [viewName];
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Access (native)
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Local Access";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = bus.access [bus.jsName];
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Master Ports connected via bus
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Master Ports Connected";
  row.appendChild (cell);
  cell = createNrTableCell (bus.masterPorts.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Number of Slave Ports connected via bus
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Number of Slave Ports Connected";
  row.appendChild (cell);
  cell = createNrTableCell (bus.slavePorts.length, 32, "dec");
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Protocol
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Bus Protocol";
  row.appendChild (cell);
  cell = document.createElement ("td");
  cell.innerHTML = bus.busProtocol;
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Default Slave
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Default Slave";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (bus.defaultSlave.length > 0) {
    var slave = window [bus.defaultSlave];
    link = document.createElement ("a");
    link.href = "port.html?" + bus.defaultSlave + "?" + viewName;
    link.innerHTML = getAliasContextName (slave, false);
    cell.appendChild (link);
  } else {
    cell.innerHTML = "-";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Has Mutations ...
  row = document.createElement ("tr");
  row.className = "interleave";
  cell = document.createElement ("td");
  cell.innerHTML = "Mutations By Attributes";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (bus.hasMutationsByAttributes == "true") {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Allow Address Overlap
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Allow Address Overlap";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (bus.allowAddrOverlap === true) {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
  // Row: Lossless Connection
  row = document.createElement ("tr");
  cell = document.createElement ("td");
  cell.innerHTML = "Lossless Connection";
  row.appendChild (cell);
  cell = document.createElement ("td");
  if (bus.isLossless === true) {
    cell.innerHTML = "YES";
  } else {
    cell.innerHTML = "NO";
  }
  row.appendChild (cell);
  body.appendChild (row);
}

function createTopography (bus, viewName) {
  var head = document.getElementById ("topographyHead");
  var body = document.getElementById ("topographyBody0");

  head.innerHTML += createToggleImage ("topography");

  // Table Caption
  // <caption><sup>M</sup>Module <sup>P</sup>Port <sup>B</sup>Bus
  // <sup>R</sup>Register</caption>
  var caption = document.createElement ("caption");
  var M = document.createElement ("sup");
  var P = document.createElement ("sup");
  var B = document.createElement ("sup");
  var R = document.createElement ("sup");
  M.innerHTML = "M";
  P.innerHTML = "P";
  B.innerHTML = "B";
  R.innerHTML = "R";
  caption.appendChild (M);
  caption.appendChild (document.createTextNode ("Module "));
  caption.appendChild (P);
  caption.appendChild (document.createTextNode ("Port "));
  caption.appendChild (B);
  caption.appendChild (document.createTextNode ("Bus "));
  caption.appendChild (R);
  caption.appendChild (document.createTextNode ("Register"));
  body.appendChild (caption);

  // Topography
  var masterNo = bus.masterPorts.length;
  var slaveNo = bus.slavePorts.length;
  var columns;
  if (masterNo > slaveNo) {
    columns = masterNo * 2 - 1;
  } else {
    columns = slaveNo * 2 - 1;
  }
  var middle = Math.ceil ( (columns) / 2);
  var masterStartNo = middle - masterNo;
  var slaveStartNo = middle - slaveNo;
  var columnCounter;
  var cell;
  var row;
  var link;
  var idx;
  var moduleName;

  // ///////////////////////////////////////////////
  // // 1. ROW: Master Port Module
  row = document.createElement ("tr");
  columnCounter = 0;
  // starting hidden cells
  while (columnCounter < masterStartNo) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  // modules
  for (idx = 0; idx < masterNo; idx++) {
    moduleName = window [bus.masterPorts [idx]].parent;
    cell = document.createElement ("td");
    link = document.createElement ("a");
    if (window [bus.masterPorts [idx]].isView == "true") {
      cell.className = "viewmod";
    } else {
      cell.className = "mod";
    }
    link.href = "module.html?" + moduleName;
    link.innerHTML = window [moduleName].aliasName;
    cell.appendChild (link);
    cell.appendChild (M.cloneNode (true));
    row.appendChild (cell);
    columnCounter++;
    if ( (idx + 1) < masterNo) {
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      columnCounter++;
    }
  }
  // ending hidden cells
  while (columnCounter < columns) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  body.appendChild (row);

  // ///////////////////////////////////////////////
  // // 2. ROW: Master Port
  row = document.createElement ("tr");
  columnCounter = 0;
  // starting hidden cells
  while (columnCounter < masterStartNo) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  // modules
  for (idx = 0; idx < masterNo; idx++) {
    cell = document.createElement ("td");
    link = document.createElement ("a");
    if (window [bus.masterPorts [idx]].isView == "true") {
      cell.className = "viewport";
    } else {
      cell.className = "port";
    }
    link.href = "port.html?" + bus.masterPorts [idx] + "?" + viewName;
    link.innerHTML = window [bus.masterPorts [idx]].aliasName;
    cell.appendChild (link);
    cell.appendChild (P.cloneNode (true));
    row.appendChild (cell);
    columnCounter++;
    if ( (idx + 1) < masterNo) {
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      columnCounter++;
    }
  }
  // ending hidden cells
  while (columnCounter < columns) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  body.appendChild (row);

  // ///////////////////////////////////////////////
  // // 3. ROW: Master Port Arrows
  row = document.createElement ("tr");
  columnCounter = 0;
  // starting hidden cells
  while (columnCounter < masterStartNo) {
    cell = document.createElement ("td");
    cell.className = "busdown";
    row.appendChild (cell);
    columnCounter++;
  }
  // modules
  for (idx = 0; idx < masterNo; idx++) {
    cell = document.createElement ("td");
    cell.className = "busdown";
    cell.innerHTML = "&darr;";
    row.appendChild (cell);
    columnCounter++;
    if ( (idx + 1) < masterNo) {
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      columnCounter++;
    }
  }
  // ending hidden cells
  while (columnCounter < columns) {
    cell = document.createElement ("td");
    cell.className = "busdown";
    row.appendChild (cell);
    columnCounter++;
  }
  body.appendChild (row);

  // ///////////////////////////////////////////////
  // // 4. ROW: Slave Port Arrows
  row = document.createElement ("tr");
  columnCounter = 0;
  // starting hidden cells
  while (columnCounter < slaveStartNo) {
    cell = document.createElement ("td");
    cell.className = "busup";
    row.appendChild (cell);
    columnCounter++;
  }
  // modules
  for (idx = 0; idx < slaveNo; idx++) {
    cell = document.createElement ("td");
    cell.className = "busup";
    cell.innerHTML = "&darr;";
    row.appendChild (cell);
    columnCounter++;
    if ( (idx + 1) < slaveNo) {
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      columnCounter++;
    }
  }
  // ending hidden cells
  while (columnCounter < columns) {
    cell = document.createElement ("td");
    cell.className = "busup";
    row.appendChild (cell);
    columnCounter++;
  }
  body.appendChild (row);

  // ///////////////////////////////////////////////
  // // 5. ROW: Slave Port
  row = document.createElement ("tr");
  columnCounter = 0;
  // starting hidden cells
  while (columnCounter < slaveStartNo) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  // modules
  for (idx = 0; idx < slaveNo; idx++) {
    cell = document.createElement ("td");
    link = document.createElement ("a");
    if (window [bus.slavePorts [idx]].isView == "true") {
      cell.className = "viewport";
    } else {
      cell.className = "port";
    }
    link.href = "port.html?" + bus.slavePorts [idx] + "?" + viewName;
    link.innerHTML = window [bus.slavePorts [idx]].aliasName;
    cell.appendChild (link);
    cell.appendChild (P.cloneNode (true));
    row.appendChild (cell);
    columnCounter++;
    if ( (idx + 1) < slaveNo) {
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      columnCounter++;
    }
  }
  // ending hidden cells
  while (columnCounter < columns) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  body.appendChild (row);
  // ///////////////////////////////////////////////
  // // 6. ROW: Slave Port Module
  row = document.createElement ("tr");
  columnCounter = 0;
  // starting hidden cells
  while (columnCounter < slaveStartNo) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  // modules
  for (idx = 0; idx < slaveNo; idx++) {
    moduleName = window [bus.slavePorts [idx]].parent;
    cell = document.createElement ("td");
    link = document.createElement ("a");
    if (window [bus.slavePorts [idx]].isView == "true") {
      cell.className = "viewmod";
    } else {
      cell.className = "mod";
    }
    link.href = "module.html?" + moduleName;
    link.innerHTML = window [moduleName].aliasName;
    cell.appendChild (link);
    cell.appendChild (M.cloneNode (true));
    row.appendChild (cell);
    columnCounter++;
    if ( (idx + 1) < slaveNo) {
      cell = document.createElement ("td");
      cell.className = "hide";
      row.appendChild (cell);
      columnCounter++;
    }
  }
  // ending hidden cells
  while (columnCounter < columns) {
    cell = document.createElement ("td");
    cell.className = "hide";
    row.appendChild (cell);
    columnCounter++;
  }
  body.appendChild (row);

}
