// Function to include other JavaScript files
function include () {
  if (arguments.length === 0) {
    return;
  }
  var arguments = Array.prototype.slice.call (arguments), callback = null, callback_trigger = 'file', files;
  if (arguments.length === 1) {
    files = arguments [0];
  } else {
    if (typeof arguments [arguments.length - 1] == 'function') {
      callback = arguments.pop ();
      callback_trigger = 'files';
    }
    files = arguments.length === 1 ? (typeof arguments [0] == 'object' ? arguments [0]
        : arguments)
        : arguments;
  }
  if (typeof files !== 'object') {
    files = [ files ];
  }
  if (callback_trigger == 'file') {
    var perfile = false;
    while (files.length > 0) {
      var file = files.shift ();
      if (typeof file == 'object') {
        callback = file [1];
        file = file [0];
        perfile = true;
      } else if (perfile) {
        perfile = false;
        callback = null;
      }
      _inject (file, callback);
    }
  } else if (callback_trigger == 'files') {
    function _include (file, callback) {
      _inject (file, function () {
        if (callback) {
          if (files.length > 0) {
            _include (files.shift (), callback);
          } else {
            callback ();
          }
        }
      });
    }
    _include (files.shift (), callback);
  }
  function _inject (file, callback) {
    var s = document.createElement ('script');
    s.type = 'text/javascript';
    s.src = file + '?' + Math.random ().toString ().substring (2);
    if (callback) {
      var loaded = false;
      s.onload = s.onreadystatechange = function () {
        if (!loaded
            && (!this.readyState || this.readyState == 'loaded' || this.readyState == 'complete')) {
          loaded = true;
          callback ();
        }
      };
    }
    document.getElementsByTagName ('head') [0].appendChild (s);
  }
}

// ###############################################
// #####-------Spectool2.js-Functions--------#####
// ###############################################

function Status (init) {
  this.value = init;
  this.type = "-";
}

function showCompatibilityIssues () {
  var browser = BrowserDetect.browser,
  version = BrowserDetect.version;
  // VERSION
  var correctVersion = (browser == "Firefox" && version >= "4") ||
                       (browser == "Chrome" && version >= "19") ||
                       (browser == "Explorer" && version >= "8");
  if (browser!=="Firefox" && browser!=="Chrome" && browser!=="Mozilla" && browser!=="Explorer") {
    var table = document.createElement ("table");
    table.width = "100%";
    var row = document.createElement ("tr");
    table.appendChild (row);
    var cell = document.createElement ("td");
    row.appendChild (cell);
    row.style.backgroundColor = "orange";
    row.style.fontColor = "black";
    row.style.textAlign = "center";
    cell.innerHTML = "PLEASE USE A NEWER VERSION OF FIREFOX, CHROME OR MSIE (this is '"+browser+"'!";
    var div = document.getElementById ("header");
    div.insertBefore (table, div.childNodes[0]);
  }
  if(!correctVersion){
    var table = document.createElement ("table");
    table.width = "100%";
    var row = document.createElement ("tr");
    table.appendChild (row);
    var cell = document.createElement ("td");
    row.appendChild (cell);
    row.style.backgroundColor = "red";
    row.style.fontColor = "black";
    row.style.textAlign = "center";
    if (browser==="Firefox") {
      cell.innerHTML = "PLEASE USE A NEWER VERSION OF FIREFOX!";
    } else if (browser==="Chrome") {
      cell.innerHTML = "PLEASE USE A NEWER VERSION OF GOOGLE CHROME!";
    } else if (browser==="IE") {
      cell.innerHTML = "PLEASE USE A NEWER VERSION OF MICROSOFT INTERNET EXPLORER!";
    }

    var div = document.getElementById ("header");
    div.insertBefore (table, div.childNodes[0]);
  }
  return;
  /*if(browser == "Firefox" && version >= "14"){
      //firefox greater then or equal to 14, on windows
      $("#header").text(browser +' '+ version);
  }else if(browser == "Explorer" && version == "9"){
      //ie9 on windows
      $("#header").text(browser +' - '+ version);
  }else if(browser == "Chrome" && version > "19"){
      //chrome greater than 19 on a mac
      $("#header").text(browser +' - '+ version);
  }*/
}

// ###############################################
// #####-------------------------------------#####
// #####-----------Toggle-Function-----------#####
// #####-------------------------------------#####
// ###############################################

function createToggleImage (name) {
  // EXAMPLE: " <img id='descriptionImage'
  // onclick=\"javascript:toggleBundle(descriptionVariable, 'descriptionBody',
  // this)\" src='' alt='ARROW' />"
  var string;
  string = " <img id='";
  string += name + "Image' onclick=\"javascript:toggleBundle(" + name
      + "Variable, '" + name + "Body', this)\" src='' alt='ARROW' />";
  return (string);
}

// / Toggle Function
function toggle (status, item, img) {
  var d = document.getElementById (item);
  if (d !== null) {
    if (status.type == "-") {
      status.type = d.style.display;
    }
    // Switch image src
    toggleImage (status.value, img);
    // Perform action
    if (status.value === 0) {
      status.value = 1;
      d.style.display = "none";
    } else {
      status.value = 0;
      d.style.display = "table";
    }
  } else {
    document.write ("ERROR: toggle didn't find any item to toggle --> " + item);
  }

}
function toggleBundle (status, item, img) {
  var d, i = 0;
  var newdisp;
  // Switch image src
  toggleImage (status.value, img);
  d = document.getElementById (item + i);
  if (d !== null) {
    if (status.type == "-") {
      status.type = d.style.display;
    }
    if (status.value === 0) {
      status.value = 1;
      status.type = d.style.display;
      newdisp = "none";
    } else {
      status.value = 0;
      newdisp = status.type;
    }
    do {
      // Perform action
      d.style.display = newdisp;
      i++;
      d = document.getElementById (item + i);
    } while (d !== null);
  } else {
    document.write ("ERROR: toggleBundle didn't find any item to toggle --> "
        + item + i);
    console.log ("ERROR: toggleBundle didn't find any item to toggle --> "
        + item + i);
  }
}
function hideBundle (item, img) {
  var d, i = 0;
  var newdisp;
  // Switch image src
  if (img != undefined) {
    toggleImage (status.value, img);
  }
  d = document.getElementById (item + i);
  if (d !== null) {
    do {
      // Perform action
      d.style.display = "none";
      i++;
      d = document.getElementById (item + i);
    } while (d !== null);
  } else {
    document.write ("ERROR: toggleBundle didn't find any item to toggle --> "
        + item + i);
    console.log ("ERROR: toggleBundle didn't find any item to toggle --> "
        + item + i);
  }
}

// / Toggle Image Function
function toggleImage (status, img) {
  var prefix = "";
  if (status === 0) {
    img.src = prefix.concat ("Pictures/red_arrows_right.png");
  } else {
    img.src = prefix.concat ("Pictures/red_arrows_down.png");
  }
}

// ###############################################
// #####-------------------------------------#####
// #####---------- OBJECTS & PICTURES -------#####
// #####-------------------------------------#####
// ###############################################

function scaleObjects () {
  var i = 0;
  var object = document.getElementById ("object" + i.toString ());
  while (object !== null) {
    scaleObject2Window (object);
    i++;
    object = document.getElementById ("object" + i.toString ());
  }
}

function scaleObject2Window (object) {
  var w = window.innerWidth * 0.9;
  var h = window.innerHeight * 0.9;
  object.width = w;
  object.height = h;
}

function openObject (object) {
  window.open (object.data);
}

function scaleImgage2Window (image) {
  var w = window.innerWidth * 0.9;
  var h = window.innerHeight * 0.9;
  var ratio = image.width / image.height;
  if (ratio > 1) {
    image.width = w;
    image.height = w / ratio;
  } else {
    image.height = h;
    image.width = h * ratio;
  }
}

// ###############################################
// #####-------------------------------------#####
// #####----------TITLES & DESCRIPTION ------#####
// #####-------------------------------------#####
// ###############################################

function initChapter (name, init) {
  window [name + "Variable"] = new Status (init);
  var item = document.getElementById (name + 'Image');
  if (item !== null) {
    toggleBundle (window [name + "Variable"], name + 'Body', item);
  }
}

function createTitle (spectool2Element) {

  var titleText = "";
  if (spectool2Element !== undefined) {
    switch (spectool2Element.type) {
    case "register":
      titleText += title4Register (spectool2Element);
      break;
    case "port":
      titleText += title4Port (spectool2Element);
      break;
    case "bus":
      titleText += title4Bus (spectool2Element);
      break;
    case "module":
      titleText += title4Module (spectool2Element);
      break;
    case "system":
      titleText += title4System (spectool2Element);
      break;
    case "map":
      titleText = "[Flat Address Map] ";
      break;
    default:
      titleText = "";
      break;
    }
  } else {
    titleText = "";
  }

  // Title panel
  // <img src="Pictures/home_button_0.png" alt="HOME" />
  var homeImage = document.createElement ("img");
  homeImage.id = "homeImage";
  homeImage.src = "Pictures/home_button_0.png";
  homeImage.alt = "HOME";
  // homeImage.setAttribute ("style", "vertical-align:middle");
  document.title = titleText;
  // document.getElementById("indexReferenceImg").align = center;
  document.getElementById ("indexReferenceTxt").innerHTML = "";
  document.getElementById ("indexReferenceTxt").appendChild (homeImage);
  document.getElementById ("indexReferenceTxt").appendChild (document.createTextNode (" [SYSTEM] "
      + window [spectool2.currentSystem].aliasName + " - "
      + window [spectool2.currentSystem].longName));
  document.getElementById ("spectool2Revision").innerHTML = spectool2.revisionTag+"/"+spectool2.revisionNo;
  document.getElementById ("searchInput").value = "";
  // Header/description section
  var title = document.getElementById ("title");
  title.innerHTML = titleText;
}

function createDescription (spectool2Element) {
  // Description
  var head = document.getElementById ("descriptionHead");
  var body = document.getElementById ("descriptionBody0");
  var hasDescription = spectool2Element.description.length > 0;
  var hasPictures = Object.keys (spectool2Element.pictures).length > 0;
  var hasLinks = Object.keys (spectool2Element.links).length > 0;
  var hasReferences = Object.keys (spectool2Element.references).length > 0;
  if (hasDescription || hasPictures || hasLinks || hasReferences || body) {
    // Make description table switchable
    head.innerHTML += createToggleImage ("description");
  }

  if (hasDescription) {
    // Add description
    var cell = document.createElement ("td");
    cell.innerHTML = spectool2Element.description;
    var row = document.createElement ("tr");
    row.appendChild (cell);
    body.appendChild (row);
  }
  // Pictures
  if (hasPictures) {
    var picture;
    var i = 0;
    for (picture in spectool2Element.pictures) {
      /**
       * GENERATE THE FOLLOWING
       * <td class="picture">
       * <dl>
       * for SVG ==>
       * <dt><object id="object0" data="Pictures/gphyafe_SYSTEM.svg"
       * type="image/svg+xml">Generated SVG</object></dt>
       * for others ==>
       * <dt><img src="Pictures/GPON_MODEM_Bus_architecture.gif" title="GPON
       * Overview"/></dt>
       * <dd>Generated SVG <a target="_blank"
       * href="Pictures/gphyafe_SYSTEM.svg">[ENLARGE]</a></dd>
       * </dl>
       *
       * </td>
       */
      var dt = document.createElement ("dt");
      if (picture.match (".+\.svg$") !== null) {
        var object = document.createElement ("object");
        object.id = "object" + i.toString ();
        object.data = "Pictures/" + picture;
        object.type = "image/svg+xml";
        object.innerHTML = spectool2Element ["pictures"] [picture];
        dt.appendChild (object);
      } else {
        var image = document.createElement ("img");
        image.src = "Pictures/" + picture;
        image.title = spectool2Element.pictures [picture];
        dt.appendChild (image);
      }
      var link = document.createElement ("a");
      link.target = "_blank";
      if (object===undefined) {
        link.href = image.src;
      } else {
        link.href = object.data;
      }
      link.innerHTML = "[ENLARGE]";
      var dd = document.createElement ("dd");
      dd.appendChild (link);
      var dl = document.createElement ("dl");
      dl.appendChild (dt);
      dl.appendChild (dd);
      cell = document.createElement ("td");
      cell.className = "picture";
      cell.appendChild (dl);
      row = document.createElement ("tr");
      row.appendChild (cell);
      body.appendChild (row);
    }
  }
  // Links
  if (hasLinks) {
    link;
    i = 0;
    cell = document.createElement ("td");
    cell.className = "picture";
    for (link in spectool2Element.links) {
      /**
       * GENERATE THE FOLLOWING
       * <tr>
       * <td class="picture">
       * <ul>
       * <li><a
       * href="file://///mucsdn52.lantiq.com/lqatproject1/GPON_MODEM">GPON_MODEM
       * Project Drive (Windows)</a></li>
       * <li><a
       * href="file://///mucsdn52.lantiq.com/lqatproject1/GPON_MODEM/03_Documentation/1_Developement_Documentation/02_Specification/01_Unit_Architecture_Specification/pdf/GPON_MODEM_20100916.pdf">GPON
       * PDF Dokumentation (Windows)</a></li>
       * </ul>
       * </td>
       * </tr>
       */
      var a = document.createElement ("a");
      // link.target = "_blank";
      a.href = link;
      a.innerHTML = spectool2Element.links [link];
      var li = document.createElement ("li");
      li.appendChild (a);
      cell.appendChild (li);
    }
    row = document.createElement ("tr");
    row.appendChild (cell);
    body.appendChild (row);
  }

  // TODO: References!!!
  if (hasReferences) {

  }
}

function title4Register (register) {
  var port = window [register.parent];
  var module = window [port.parent];
  var title = "[REGISTER] " + module.instName;
  title = title.concat ("::" + port.instName);
  title = title.concat ("::" + register.instName + " - " + register.longName);
  return title;
}

function title4Port (port) {
  var module = window [port.parent];
  var title = "[PORT] " + module.instName;
  title = title.concat ("::" + port.instName + " - " + port.longName);
  return title;
}

function title4Bus (bus) {
  var module = window [bus.parent];
  var title = "[BUS] " + module.instName;
  title = title.concat ("::" + bus.instName + " - " + bus.longName);
  return title;
}

function title4Module (module) {
  var title = "[MODULE] ";
  title = title.concat (module.instName + " - " + module.longName);
  return title;
}

function title4System (system) {
  var title = "[SYSTEM] ";
  title = title.concat (system.instName + " - " + system.longName);
  return title;
}

function generateLink (spectool2Element, view) {
  var link;
  var element = spectool2Element;
  if (element.type==="system") {
    link = "index.html";
  } else if (element.type==="module") {
    link = element.type + ".html?" + element.jsName;
  } else if (element.type==="rfield") {
    element = window [element.parent];
    if (element.views.indexOf (view)==-1) {
      view = element.views [0];
    }
    link = element.type + ".html?" + element.jsName + "?" + view + "#" + spectool2Element.instName;
  } else if (element.type==="attribute") {
    link = generateLink (window [element.parent], view);
  } else {
    if (element.views.indexOf (view)==-1) {
      view = element.views [0];
    }
    link = element.type + ".html?" + element.jsName + "?" + view;
  }
  return (link);
}


// ###############################################
// #####-------------------------------------#####
// #####---------- OTHERS -------------------#####
// #####-------------------------------------#####
// ###############################################
function deepCopy (p, c) {
  var c = c || {};
  for ( var i in p) {
    if (typeof p [i] === 'object') {
      c [i] = (p [i].constructor === Array) ? [] : {};
      deepCopy (p [i], c [i]);
    } else
      c [i] = p [i];
  }
  return c;
}
