//###############################################
//#####-------------------------------------#####
//#####------ ATTRIBUTES TABLE -------------#####
//#####-------------------------------------#####
//###############################################
function createAttributesTable (spectool2Element, viewName) {
  var head = document.getElementById ("attributesHead");
  var body0 = document.getElementById ("attributesBody0");

  if (hasAttributes (spectool2Element) === false) {
    hideBundle ("attributesBody", undefined);
    return;
  }
  head.innerHTML += createToggleImage ("attributes");

  var table;
  if (spectool2Element.attributes.constant !== undefined) {
    table = document.createElement ("table");
    table.className = "attr_elem";
    table.id = body0.id+"_constant";
    body0.appendChild (table);
    spectool2Element.attributes.constant.jsName = spectool2Element.jsName+"_CONSTANT_ATTRIBUTES";
    window [spectool2Element.attributes.constant.jsName] = spectool2Element.attributes.constant;
    __createAttributesTable (spectool2Element.attributes.constant, viewName, "constant", table);
  }
  if (spectool2Element.attributes.generic !== undefined) {
    table = document.createElement ("table");
    table.className = "attr_elem";
    table.id = body0.id+"_generic";
    body0.appendChild (table);
    spectool2Element.attributes.generic.jsName = spectool2Element.jsName+"_GENERIC_ATTRIBUTES";
    window [spectool2Element.attributes.generic.jsName] = spectool2Element.attributes.generic;
    __createAttributesTable (spectool2Element.attributes.generic, viewName, "generic", table);
  }
  if (spectool2Element.attributes.enumeration !== undefined) {
    table = document.createElement ("table");
    table.className = "attr_elem";
    table.id = body0.id+"_enumeration";
    body0.appendChild (table);
    spectool2Element.attributes.enumeration.jsName = spectool2Element.jsName+"_ENUMERATION_ATTRIBUTES";
    window [spectool2Element.attributes.enumeration.jsName] = spectool2Element.attributes.enumeration;
    __createAttributesTable (spectool2Element.attributes.enumeration, viewName, "enumeration", table);
  }
  if (spectool2Element.attributes.limitation !== undefined) {
    table = document.createElement ("table");
    table.className = "attr_elem";
    table.id = body0.id+"_limitation";
    body0.appendChild (table);
    spectool2Element.attributes.limitation.jsName = spectool2Element.jsName+"_LIMITATION_ATTRIBUTES";
    window [spectool2Element.attributes.limitation.jsName] = spectool2Element.attributes.limitation;
    __createAttributesTable (spectool2Element.attributes.limitation, viewName, "limitation", table);
  }
}

function __createAttributesTable (spectool2Element, viewName, identifier, body0) {
  var tableStatus = new TableStatus (4);
  // TABLE: | Name | Value (BIN | HEX) | Description |
  // init sort
  tableStatus.id = "globalAttributesTable_"+identifier;
  tableStatus.sortEnabled [2] = false;
  tableStatus.sortTypes [1] = "number";
  tableStatus.sortTypes [2] = "number";
  // tableStatus.sortClassNames [X] = "hiddenCell";
  tableStatus.currentSortPos = 0;
  tableStatus.currentSortDir = "up";
  // init filter
  tableStatus.filterEnabled [2] = false;
  tableStatus.filterTypes [1] = "number";
  tableStatus.filterTypes [2] = "number";
  tableStatus.filterSet [1] = ">=0";
  tableStatus.filterSet [2] = ">=0";
  // tableStatus.filterClassNames [X] = "hiddenCell";
  // combine
  // tableStatus.combineCell [X] = true;
  
  tableStatus.hookFunctionName = "hookAttributesTable";

  tableStatus.enableModuleColumn = false;

  window [tableStatus.id] = tableStatus;

  hookAttributesTable (body0, spectool2Element, viewName, tableStatus);
}
// f (body, dataSource, viewName, tStatus, row);
function hookAttributesTable (body, spectool2Element, viewName, tableStatus) {
  // clear body
  body.innerHTML = "";

  // create header
  // var headerCells0 = ["Name", "Value", "Description"];
  // var headerCells1 = ["BIN", "HEX"];
  var row;
  var cell;
  var link;
  var tableArray;
  
  typeName = tableStatus.id.split("_")[1];
  row = document.createElement ("tr");
  body.appendChild (row);
  cell = document.createElement ("th");
  row.appendChild (cell);
  cell.colSpan = 4;
  cell.innerHTML = typeName.toUpperCase();
  
  // create header
  row = document.createElement ("tr");
  // Name
  var pos = 0;
  cell = document.createElement ("th");
  cell.innerHTML = "Name";
  cell.rowSpan = 2;
  if (tableStatus.sortEnabled [pos] === true) {
    // hookTable4Sort (bodyName, tableStatusName, functionName, infoSourceName,
    // viewName, sortPos)
    createSortHook (body, cell, pos, spectool2Element, viewName, tableStatus);
  }
  row.appendChild (cell);
  // Value
  cell = document.createElement ("th");
  cell.innerHTML = "Value";
  cell.colSpan = 2;
  row.appendChild (cell);
  // Description
  pos = 2;
  cell = document.createElement ("th");
  cell.innerHTML = "Description";
  cell.rowSpan = 2;
  if (tableStatus.sortEnabled [pos] === true) {
    // hookTable4Sort (bodyName, tableStatusName, functionName, infoSourceName,
    // viewName, sortPos)
    createSortHook (body, cell, pos, spectool2Element, viewName, tableStatus);
  }
  row.appendChild (cell);
  body.appendChild (row);
  row = document.createElement ("tr");
  // BIN
  pos = 1;
  cell = document.createElement ("th");
  cell.innerHTML = "BIN";
  if (tableStatus.sortEnabled [pos] === true) {
    // hookTable4Sort (bodyName, tableStatusName, functionName, infoSourceName,
    // viewName, sortPos)
    createSortHook (body, cell, pos, spectool2Element, viewName, tableStatus);
  }
  row.appendChild (cell);
  // HEX
  pos = 1;
  cell = document.createElement ("th");
  cell.innerHTML = "HEX";
  if (tableStatus.sortEnabled [pos] === true) {
    createSortHook (body, cell, pos, spectool2Element, viewName, tableStatus);
  }
  row.appendChild (cell);
  body.appendChild (row);

  // //////////////////////////////////////////

  // create body rows
  // build table array
  var attributes = spectool2Element;
  if (attributes === undefined) {
    tableArray = new Array ();
  } else {
    tableArray = buildAttributesTableArray (attributes, tableStatus);
  }

  // create filter inputs
  if (tableStatus.filterRow === null && tableArray.length>2) {
    createFilterInput (body, spectool2Element, viewName, tableStatus);
  } else if (tableStatus.filterRow !== null) {
    refreshFilterInput2 (body, tableStatus);
  }

  for (var idx = 0; idx < tableArray.length; idx++) {
    
    row = document.createElement ("tr");
    if (idx % 2 === 0) {
      row.className = "interleave";
    }
    // Name
    pos = 0;
    cell = document.createElement ("td");
    cell.innerHTML = tableArray [idx] [pos];
    row.appendChild (cell);
    // BIN
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = vlogb2binM (tableArray [idx] [pos]);
    row.appendChild (cell);
    // HEX
    pos++;
    cell = document.createElement ("td");
    cell.innerHTML = vlogb2hexM (tableArray [idx] [pos]);
    row.appendChild (cell);
    // Description
    pos = 0;
    cell = document.createElement ("td");
    cell.innerHTML = tableArray [idx] [pos];
    row.appendChild (cell);

    body.appendChild (row);
  }
}

function buildAttributesTableArray (attributes, tableStatus) {
  var tableArray = new Array ();
  var index = 0;
  for (var i = 0; i < attributes.length; i++) {
    for (var j = 0; j < attributes [i].length; j++) {
      tableArray [index] = new Array ();
      var a = attributes [i] [j];
      // Name
      var pos = 0;
      tableArray [index] [pos] = a [pos];
      // Value
      pos++;
      tableArray [index] [pos] = a [pos];
      tableArray [index] [pos + 1] = a [pos];
      // Description
      pos++;
      tableArray [index] [pos + 1] = a [pos];
      index++;
    }
  }

  tableStatus.tableArray = tableArray;
  sortArray (tableStatus);
  filterArray (tableStatus);
  //addHcellCombineInfo (tableStatus)
  return (tableArray);
}
