#include "HwMemoryMap.h" 
#ifndef FAST_MEM_PSD2MIPS_H_FILE 
#define FAST_MEM_PSD2MIPS_H_FILE 
//All addressed should be multiply by 4 and add hB44000
// total size is 2048 (max 0x7ff)

#define 	FMEM_ENABLE_RIFS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x0	 //RiscAdd 0
#define 	BF_CALIBRATION_RECORD_CH_START	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x4	 //RiscAdd 1
#define 	STOP_RISC_EN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8	 //RiscAdd 2//	hB44008	
#define 	ENABLE_FW_LOGS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xC	 //RiscAdd 3//	hB4400C	
#define 	MESSAGE_VALID_FLAG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x10	 //RiscAdd 4
#define 	FMEM_PREV_CCA_TIMER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x14	 //RiscAdd 5
#define 	ANT0_BB_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x18	 //RiscAdd 6
#define 	ANT0_RF_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1C	 //RiscAdd 7
#define 	ANT0_BB_OFFSET_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x20	 //RiscAdd 8
#define 	ANT1_BB_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x24	 //RiscAdd 9
#define 	ANT1_RF_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x28	 //RiscAdd a
#define 	ANT1_BB_OFFSET_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2C	 //RiscAdd b
#define 	ANT2_BB_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x30	 //RiscAdd c
#define 	ANT2_RF_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x34	 //RiscAdd d
#define 	ANT2_BB_OFFSET_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x38	 //RiscAdd e
#define 	ANT3_BB_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3C	 //RiscAdd f
#define 	ANT3_RF_GAIN_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x40	 //RiscAdd 10
#define 	ANT3_BB_OFFSET_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x44	 //RiscAdd 11

#define 	AGC_IS_TWO_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x48	 //RiscAdd 12//	shared	with	FMEM_GF_ANGLE	-	not	at	same	time	
#define 	ANTX_BB_GAIN1_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x4C	 //RiscAdd 13//	First	step	BB	gain	-	common	to	all	antennas	(Not	include	DC	word)	
#define 	ANT1_OLD_SYS_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x50	 //RiscAdd 14
#define 	ANT2_OLD_SYS_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x54	 //RiscAdd 15
#define 	ANT3_OLD_SYS_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x58	 //RiscAdd 16
#define 	ANT4_OLD_SYS_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5C	 //RiscAdd 17
// 802.11h
#define 	RADAR_TOA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x60	 //RiscAdd 18
#define 	RADAR_TOA_TSF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x64	 //RiscAdd 19
#define 	AGC_EVENT_TIMESTAMP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x68	 //RiscAdd 1a
#define 	SUB_BAND_MASK_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x6C	 //RiscAdd 1b//	
#define 	RADAR_DETECT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x70	 //RiscAdd 1c
#define 	RADAR_PW	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x74	 //RiscAdd 1d
#define 	RADAR_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x78	 //RiscAdd 1e



#define 	FMEM_BER_METER_CRC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x84	 //RiscAdd 21
//#define  AGC_EVENT_TIMESTAMP_L  0x22
#define 	AGC_EVENT_RADAR_TSF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8C	 //RiscAdd 23
//#define  ANT2_BB_RSSI			0x24	
//#define  ANT3_BB_RSSI			0x25
//#define  ANT4_BB_RSSI			0x26
#define 	AGC_ANTX_DEFAULT_SYS_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9C	 //RiscAdd 27
#define 	AGC_ANTX_DEFAULT_LNA_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA0	 //RiscAdd 28
#define 	EXT_LNA_GAIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA4	 //RiscAdd 29

#define 	RF_POWER_AT_EVENT_ANT_0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA8	 //RiscAdd 2a
#define 	RF_POWER_AT_EVENT_ANT_1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAC	 //RiscAdd 2b
#define 	RF_POWER_AT_EVENT_ANT_2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB0	 //RiscAdd 2c
#define 	RF_POWER_AT_EVENT_ANT_3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB4	 //RiscAdd 2d
#define 	MESSAGE_PARAM_6	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB8	 //RiscAdd 2e
#define 	MESSAGE_PARAM_7	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBC	 //RiscAdd 2f
#define 	BB_POWER_AT_EVENT_ANT_0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xC0	 //RiscAdd 30
#define 	BB_POWER_AT_EVENT_ANT_1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xC4	 //RiscAdd 31
#define 	BB_POWER_AT_EVENT_ANT_2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xC8	 //RiscAdd 32
#define 	BB_POWER_AT_EVENT_ANT_3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xCC	 //RiscAdd 33
#define 	MEM_DEC_ERROR_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD0	 //RiscAdd 34
#define 	MEM_RESET_ON_ERROR_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD4	 //RiscAdd 35
#define 	MESSAGE_PARAM_11	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD8	 //RiscAdd 36
#define 	MESSAGE_PARAM_12	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDC	 //RiscAdd 37
#define 	MEM_LAST_TIMER_HIGH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE0	 //RiscAdd 38
#define 	MEM_RESET_ON_ERROR_COUNT_11B	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE4	 //RiscAdd 39
#define 	MESSAGE_PARAM_16	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE8	 //RiscAdd 3a
#define 	MESSAGE_PARAM_17	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xEC	 //RiscAdd 3b
#define 	MEM_DEC_DIV_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xF0	 //RiscAdd 3c
#define 	AGC_IS_BB_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xF4	 //RiscAdd 3d
#define 	MEM_SIGNAL1_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xF8	 //RiscAdd 3e
#define 	MEM_MIN_NOISE_LOG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xFC	 //RiscAdd 3f
#define 	MEM_NUMBER_OF_ANTENNA_USED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x100	 //RiscAdd 40
#define 	MEM_BEST_ANTENNA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x104	 //RiscAdd 41
#define 	MEM_RANK_INFORMATION	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x108	 //RiscAdd 42
#define 	ANT_SEL_2MSB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x10C	 //RiscAdd 43
#define 	ANT_SEL_4LSB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x110	 //RiscAdd 44
//AMIR	
#define 	RF_SAT_BB_NOT_SAT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x114	 //RiscAdd 45
#define 	MAX_DIGITAL_GAIN_INDEX	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x118	 //RiscAdd 46

#define 	MEM_DETECTION_MASK1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x11C	 //RiscAdd 47//do	not	move	this	address,	writen	by	csim	
#define 	MEM_DETECTION_MASK2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x120	 //RiscAdd 48
#define 	MEM_DETECTION_MASK3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x124	 //RiscAdd 49
#define 	MEM_DETECTION_MASK4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x128	 //RiscAdd 4a
#define 	MEM_DETECTION_MASK5	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x12C	 //RiscAdd 4b
#define 	MEM_DETECTION_MASK6	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x130	 //RiscAdd 4c
#define 	MEM_DETECTION_MASK7	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x134	 //RiscAdd 4d
#define 	MEM_DETECTION_MASK8	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x138	 //RiscAdd 4e
#define 	MEM_DETECTION_MASK9	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x13C	 //RiscAdd 4f
#define 	MEM_DETECTION_MASK10	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x140	 //RiscAdd 50
#define 	MEM_DETECTION_MASK11	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x144	 //RiscAdd 51
#define 	MEM_DETECTION_MASK12	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x148	 //RiscAdd 52
#define 	MEM_DETECTION_MASK13	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x14C	 //RiscAdd 53
#define 	MEM_DETECTION_MASK14	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x150	 //RiscAdd 54
#define 	MEM_DETECTION_MASK15	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x154	 //RiscAdd 55
#define 	CCA_RADAR_20_USB_SEC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x158	 //RiscAdd 56
#define 	CCA_RADAR_20_USB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x15C	 //RiscAdd 57
#define 	NDP_PACKET_FLAG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x160	 //RiscAdd 58

#define 	FLAT_CORRECTION_ALL_CHAIN_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x164	 //RiscAdd 59
#define 	FLAT_CORRECTION_ALL_CHAIN_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x168	 //RiscAdd 5a
#define 	FLAT_CORRECTION_ALL_CHAIN_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x16C	 //RiscAdd 5b
#define 	FLAT_CORRECTION_ALL_CHAIN_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x170	 //RiscAdd 5c
#define 	SYS_GAIN_WITH_OUT_NOISE_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x174	 //RiscAdd 5d
#define 	SYS_GAIN_WITH_OUT_NOISE_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x178	 //RiscAdd 5e
#define 	SYS_GAIN_WITH_OUT_NOISE_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x17C	 //RiscAdd 5f
#define 	SYS_GAIN_WITH_OUT_NOISE_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x180	 //RiscAdd 60
#define 	DIFFRENTIAL_SYS_GAIN_FOR_CAL_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x184	 //RiscAdd 61
#define 	DIFFRENTIAL_SYS_GAIN_FOR_CAL_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x188	 //RiscAdd 62
#define 	DIFFRENTIAL_SYS_GAIN_FOR_CAL_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x18C	 //RiscAdd 63
#define 	DIFFRENTIAL_SYS_GAIN_FOR_CAL_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x190	 //RiscAdd 64
#define 	NOISE_GAIN_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x194	 //RiscAdd 65
#define 	NOISE_GAIN_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x198	 //RiscAdd 66
#define 	NOISE_GAIN_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x19C	 //RiscAdd 67
#define 	NOISE_GAIN_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1A0	 //RiscAdd 68

#define 	HT_PACKET	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1A4	 //RiscAdd 69
//#define  LDPC_TX      					    0x6A
//#define  LDPC_NCW			   				0x6B
#define 	TD_RESET_VAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1B0	 //RiscAdd 6c


#define 	TX_IS_11B	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1B4	 //RiscAdd 6d

#define 	STOP_AGC_SYNCED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1B8	 //RiscAdd 6e//	fixed	address	hB441b8	(used	from	BB	studio)	
#define 	ENABLE_START_OF_PACKET_RECORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1BC	 //RiscAdd 6f//	fixed	address	hb441bc	(used	from	BB	studio)	
#define 	START_OF_PACKET_RECORD_PERIOD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1C0	 //RiscAdd 70//	fixed	address	hb441c0	(used	from	BB	studio)	
#define 	VERIFY_BE_REGS_STATUS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1C4	 //RiscAdd 71
// #define  SLICER_3BIT_DEFAULT_IN_LSB				0x72		// the default value of : llr_sum, enable linear, enable sphere at the right order as in the progmodel
#define 	SLICER_SPHERE_ENABLE_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1C8	 //RiscAdd 72
#define 	LLTF_TE_BYPASS_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1CC	 //RiscAdd 73
#define 	HTLTF_TE_BYPASS_W_SMOOTHING_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1D0	 //RiscAdd 74
#define 	HTLTF_TE_BYPASS_NO_SMOOTHING_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1D4	 //RiscAdd 75

#define 	MEM_CDB_NUM_ANTENNAS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1D8	 //RiscAdd 76//	hold	the	number	of	CDB	antennas	(0	or	4	-	no	CDB	mode,	else	1	or	2	or	3)	
#define 	SLICER_LINEAR_ENABLE_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1DC	 //RiscAdd 77

#define 	MAX_POWER_AT_ENERGY_INCREASE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1E0	 //RiscAdd 78
// Band 0/1, configured from FW after progmodel load, used by risc for fixes on CDB1
#define 	CDB_BAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1E4	 //RiscAdd 79//	hb441e4	
#define 	MAX_SNR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1E8	 //RiscAdd 7a
#define 	INBAND_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1EC	 //RiscAdd 7b
#define 	PACKET_DROP_ON_LOW_SNR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1F0	 //RiscAdd 7c
// free 0x7A-0x83

#define 	PHY_AIR_TIME	 	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x204	 //RiscAdd 80 ===== this line is temporary until phy team provides new fast_mem file	
#define 	RX_AIR_TIME_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x204	 //RiscAdd 80 ===== replacement for PHY_AIR_TIME
//#define  BW_MODE                   0x84
#define 	HT_FULL_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x210	 //RiscAdd 84
#define 	HB_MODE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x214	 //RiscAdd 85

#define 	MEM_SUM_LLR_RESET_VAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x218	 //RiscAdd 86

// 23 addresses Look Up Table for power loading
#define 	POWER_LOAD_LUT_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x21C	 //RiscAdd 87
#define 	POWER_LOAD_LUT_END	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x278	 //RiscAdd 9e

#define 	MEM_MIN_NOISE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x27C	 //RiscAdd 9f

#define 	MEM_ORIGINAL_HB_MODE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x280	 //RiscAdd a0
#define 	MEM_BW_CHANGE_TIMESTAMP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x284	 //RiscAdd a1
#define 	MEM_BW_CHANGED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x288	 //RiscAdd a2
#define 	MEM_SECONDARY_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x28C	 //RiscAdd a3

#define 	RF_FCSI_S0_BACKUP0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x290	 //RiscAdd a4//hb44290	//RFIC	Short0	backup	
#define 	RF_FCSI_S0_BACKUP1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x294	 //RiscAdd a5//hb44294	//RFIC	Short0	backup	
#define 	RF_FCSI_S0_BACKUP2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x298	 //RiscAdd a6//hb44298	//RFIC	Short0	backup	
#define 	RF_FCSI_S0_BACKUP3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x29C	 //RiscAdd a7//hb4429C	//RFIC	Short0	backup	
#define 	RF_FCSI_S2_BACKUP0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2A0	 //RiscAdd a8//hb442A0	//RFIC	Short2	backup	
#define 	RF_FCSI_S2_BACKUP1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2A4	 //RiscAdd a9//hb442A4	//RFIC	Short2	backup	
#define 	RF_FCSI_S2_BACKUP2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2A8	 //RiscAdd aa//hb442A8	//RFIC	Short2	backup	
#define 	RF_FCSI_S2_BACKUP3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2AC	 //RiscAdd ab//hb442AC	//RFIC	Short2	backup	
#define 	TX_BB_GAIN_AND_TUNE_BACKUP_0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2B0	 //RiscAdd ac//hb442B0	//TX	GAIN	backup	for	short3	
#define 	TX_POWER_ERROR_WINDOW	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2B4	 //RiscAdd ad//hb442B4	//	
#define 	TX_POWER_INCREASE_STEP_LIMIT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2B8	 //RiscAdd ae//hb442B8	//	
#define 	TX_POWER_DECREASE_STEP_LIMIT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2BC	 //RiscAdd af//hb442BC	//	
#define 	TX0_ON_BACKUP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2C0	 //RiscAdd b0//hb442C0	//	
					
#define 	TX1_ON_BACKUP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2C4	 //RiscAdd b1//hb442C4	//	
#define 	TX2_ON_BACKUP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2C8	 //RiscAdd b2//hb442C8	//	
#define 	TX3_ON_BACKUP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2CC	 //RiscAdd b3//hb442CC	//	

#define 	IQ_TD0_20M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2D0	 //RiscAdd b4//hB442D0	//	
#define 	IQ_TD0_20M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2D4	 //RiscAdd b5//hB442D4	//	
#define 	IQ_TD0_40M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2D8	 //RiscAdd b6//hB442D8	//	
#define 	IQ_TD0_40M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2DC	 //RiscAdd b7//hB442DC	//	
#define 	SET_BW_CH_DC_20M	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2E0	 //RiscAdd b8//hB442E0	//	
#define 	SET_BW_CH_DC_40M	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2E4	 //RiscAdd b9//hB442E4	//	
#define 	SET_BW_CH_DC_80M	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2E8	 //RiscAdd ba//hB442E8	//	
#define 	IQ_TD1_20M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2EC	 //RiscAdd bb//hB442EC	//	
#define 	IQ_TD1_20M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2F0	 //RiscAdd bc//hB442F0	//	
#define 	IQ_TD1_40M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2F4	 //RiscAdd bd//hB442F4	//	
#define 	IQ_TD1_40M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2F8	 //RiscAdd be//hB442F8	//	
#define 	IQ_TD2_20M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x2FC	 //RiscAdd bf//hB442FC	//	
#define 	IQ_TD2_20M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x300	 //RiscAdd c0//hB44300	//	
#define 	IQ_TD2_40M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x304	 //RiscAdd c1//hB44304	//	
#define 	IQ_TD2_40M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x308	 //RiscAdd c2//hB44308	//	
#define 	IQ_TD3_20M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x30C	 //RiscAdd c3//hB4430C	//	
#define 	IQ_TD3_20M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x310	 //RiscAdd c4//hB44310	//	
#define 	IQ_TD3_40M_F1_F2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x314	 //RiscAdd c5//hB44314	//	
#define 	IQ_TD3_40M_F3_F4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x318	 //RiscAdd c6//hB44318	//	

//tssi backup registers
#define 	TSSI0_backup	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x31C	 //RiscAdd c7//hB4431C	//	TSSI	read	from	Current	Packet	(after	avg)	
#define 	TSSI1_backup	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x320	 //RiscAdd c8//hB44320	//	TSSI	read	from	Current	Packet	(after	avg)	
#define 	TSSI2_backup	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x324	 //RiscAdd c9//hB44324	//	TSSI	read	from	Current	Packet	(after	avg)	
#define 	TSSI3_backup	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x328	 //RiscAdd ca//hB44328	//	TSSI	read	from	Current	Packet	(after	avg)	
#define 	TSSI0_power	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x32C	 //RiscAdd cb//hB4432C	//	TX	power	calc	from	TSSI	
#define 	TSSI1_power	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x330	 //RiscAdd cc//hB44330	//	TX	power	calc	from	TSSI	
#define 	TSSI2_power	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x334	 //RiscAdd cd//hB44334	//	TX	power	calc	from	TSSI	
#define 	TSSI3_power	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x338	 //RiscAdd ce//hB44338	//	TX	power	calc	from	TSSI	
//#define 	S2D_RSSI_manual_RANGE_ant0	   0xCB		 //hB4432C		//s2d pair in short 2 order
//#define 	S2D_RSSI_manual_RANGE_ant1	   0xCC		 //hB44330		//s2d pair in short 2 order
//#define 	S2D_RSSI_manual_RANGE_ant2	   0xCD		 //hB44334		//s2d pair in short 2 order
//#define 	S2D_RSSI_manual_RANGE_ant3	   0xCE		 //hB44338		//s2d pair in short 2 order
#define 	S2D_RSSI0_ant0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x33C	 //RiscAdd cf//hB4433C	//RSSI0	s2d	pair	with	manual	mose	bir	set	to	1	
#define 	S2D_RSSI0_ant1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x340	 //RiscAdd d0//hB44340	//RSSI0	s2d	pair	with	manual	mose	bir	set	to	1	
#define 	S2D_RSSI0_ant2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x344	 //RiscAdd d1//hB44344	//RSSI0	s2d	pair	with	manual	mose	bir	set	to	1	
#define 	S2D_RSSI0_ant3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x348	 //RiscAdd d2//hB44348	//RSSI0	s2d	pair	with	manual	mose	bir	set	to	1	
#define 	RSSI_GAMMA_REG0_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x34C	 //RiscAdd d3//hB4434C	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG0_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x350	 //RiscAdd d4//hB44350	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG0_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x354	 //RiscAdd d5//hB44354	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG0_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x358	 //RiscAdd d6//hB44358	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG1_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x35C	 //RiscAdd d7//hB4435C	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG1_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x360	 //RiscAdd d8//hB44360	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG1_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x364	 //RiscAdd d9//hB44364	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG1_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x368	 //RiscAdd da//hB44368	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG2_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x36C	 //RiscAdd db//hB4436C	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG2_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x370	 //RiscAdd dc//hB44370	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG2_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x374	 //RiscAdd dd//hB44374	//DC	offset	of	the	range	measured	by	FW	
#define 	RSSI_GAMMA_REG2_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x378	 //RiscAdd de//hB44378	//DC	offset	of	the	range	measured	by	FW	
#define 	S2D_RSSI_manual_RANGE_low_ant0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x37C	 //RiscAdd df//hB4437C	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_low_ant1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x380	 //RiscAdd e0//hB44380	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_low_ant2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x384	 //RiscAdd e1//hB44384	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_low_ant3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x388	 //RiscAdd e2//hB44388	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_high_ant0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x38C	 //RiscAdd e3//hB4438C	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_high_ant1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x390	 //RiscAdd e4//hB44390	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_high_ant2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x394	 //RiscAdd e5//hB44394	//s2d	pair	in	short	2	order	
#define 	S2D_RSSI_manual_RANGE_high_ant3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x398	 //RiscAdd e6//hB44398	//s2d	pair	in	short	2	order	

#define 	NOISE_EST_PER_BIN_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x39C	 //RiscAdd e7
#define 	NOISE_EST_PER_BIN_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3A0	 //RiscAdd e8
#define 	NOISE_EST_PER_BIN_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3A4	 //RiscAdd e9
#define 	NOISE_EST_PER_BIN_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3A8	 //RiscAdd ea

#define 	LOG2SNR_EST_PER_BIN_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3AC	 //RiscAdd eb
#define 	LOG2SNR_EST_PER_BIN_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3B0	 //RiscAdd ec
#define 	LOG2SNR_EST_PER_BIN_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3B4	 //RiscAdd ed
#define 	LOG2SNR_EST_PER_BIN_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3B8	 //RiscAdd ee

#define 	GAIN_FFT_IN_LLTF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3BC	 //RiscAdd ef
#define 	GAIN_FFT_IN_HTSTF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3C0	 //RiscAdd f0

#define 	FINE_AGC_CHANGED_DB_ANT0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3C4	 //RiscAdd f1
#define 	FINE_AGC_CHANGED_DB_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3C8	 //RiscAdd f2
#define 	FINE_AGC_CHANGED_DB_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3CC	 //RiscAdd f3
#define 	FINE_AGC_CHANGED_DB_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3D0	 //RiscAdd f4
#define 	TIC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3D4	 //RiscAdd f5
#define 	TOC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3D8	 //RiscAdd f6
#define 	SMOOTH_BYPASS_L_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3DC	 //RiscAdd f7
#define 	SMOOTH_BYPASS_HT_DEFAULT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3E0	 //RiscAdd f8
#define 	PHY_RX_FD_IF_CT_DATA_MU_INIT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3E4	 //RiscAdd f9//	this	location	is	for	storing	default	value	of	the	register	for	genrisc.	The	register	is	loaded	as	0,	and	genrisc	combines	all	
															//		fields in initilize
#define 	PHY_RX_FD_PHY_RXFD_REGCC_REG_INIT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3E8	 //RiscAdd fa//	value	for	init	of	this	register,	contains	9	fields.	
#define 	TRIGGER_BASE_EXPECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3EC	 //RiscAdd fb//	Trigger	based	packet	expected.	

#define 	TX_ANTENNA_MASK	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3F0	 //RiscAdd fc//hb443f0	//	TX_ANTENNA_EN	saved	for	fast	access	to	antennas	mask	when	write/read	all	antennas	
#define 	ANTENNA_MASK	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3F4	 //RiscAdd fd//hb443f4	//	HOST_ANTENNA_EN	saved	for	fast	access	to	antennas	mask	when	write/read	all	antennas	

#define 	ENABLE_802_11_H	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3F8	 //RiscAdd fe//hb443f8	//	Support	802.11h	Radar	detection	at	5GHZ	only	
#define 	ENABLE_11_B	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x3FC	 //RiscAdd ff//hb443fc	//	Support	802.11B	at	2.4GHZ	only	

// ===================================================================================
// 802.11h Cyclic buffer memory to MAC handshake for Radar. 
// ====================================================================================

#define 	MEM_RADAR_BUF_START	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x400	 //RiscAdd 100//	total	64	words	//hb44400	
#ifdef SUB_BAND_DFS
#define 	MEM_RADAR_BUF_END	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x504	 //RiscAdd 141
#else
#define 	MEM_RADAR_BUF_END	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x500	 //RiscAdd 140//0x0160	//h30020500	
#endif
// Free 0x141...0x1ff
#define 	SMOOTHING_USE_TD_SNR_CFG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x504	 //RiscAdd 141
#define 	MEM_HE_DETECTED_CNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x508	 //RiscAdd 142
#define 	MEM_HE_TRIG_DETECTED_CNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x50C	 //RiscAdd 143
#define 	TRIGGERED_MODE_CFG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x510	 //RiscAdd 144
// #define  TRIGGERED_TEST_MODE			0x0145
#define 	SUM_LLR_CFG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x514	 //RiscAdd 145//	sum_llr:	-1	-->	auto	mode	(mcs	threshold).	0	-	disable	sum;	1	-	force	sum.	
#define 	EVM_BUF_START	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x518	 //RiscAdd 146
#define 	EVM_BUF_LAST	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5A4	 //RiscAdd 169
#define 	TX_TIME_FROM_INT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5B8	 //RiscAdd 16e//	hb445b8	

// Free 0x16a...0x1ff
#define 	DFS_SIFS_END	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5A0	 //RiscAdd 168
#define 	DFS_SIFS_START	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5A8	 //RiscAdd 16a
#define 	DFS_AGC_INCREASE_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5AC	 //RiscAdd 16b
#define 	MODEM_RESET_END_FOR_DFS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5B0	 //RiscAdd 16c//hb445BB	
#define 	SKIP_DFS_RESET	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5B4	 //RiscAdd 16d//hb445BA	
//do not use   0x016E
#define 	MODEM_RESET_START_FOR_DFS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5BC	 //RiscAdd 16f//	hb445BC	
#define 	MAX_BB_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5C0	 //RiscAdd 170//	hb445C0	
#define 	MAX_BB_POWER_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5C4	 //RiscAdd 171//	hb445C4	
#define 	MAX_BB_POWER_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5C8	 //RiscAdd 172//hB445C8	
#define 	MAX_BB_POWER_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5CC	 //RiscAdd 173//hB445CC	

#define 	MAX_IB_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5D0	 //RiscAdd 174//hB445D0	
#define 	MAX_IB_POWER_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5D4	 //RiscAdd 175//hb445D4	
#define 	MAX_IB_POWER_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5D8	 //RiscAdd 176//hB445D8	
#define 	MAX_IB_POWER_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5DC	 //RiscAdd 177//hB445DC	

#define 	MAX_ACIDET_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5E0	 //RiscAdd 178//hB445E0	
#define 	MAX_ACIDET_POWER_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5E4	 //RiscAdd 179//hb445E4	
#define 	MAX_ACIDET_POWER_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5E8	 //RiscAdd 17a//hB445E8	
#define 	MAX_ACIDET_POWER_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x5EC	 //RiscAdd 17b//hB445EC	


#define 	LAST_MAX_BB_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x600	 //RiscAdd 180//hb44600	
#define 	LAST_MAX_BB_POWER_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x604	 //RiscAdd 181//hb44604	
#define 	LAST_MAX_BB_POWER_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x608	 //RiscAdd 182//hB44608	
#define 	LAST_MAX_BB_POWER_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x60C	 //RiscAdd 183//hB4460C	

#define 	LAST_MAX_IB_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x610	 //RiscAdd 184//hB44610	
#define 	LAST_MAX_IB_POWER_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x614	 //RiscAdd 185//hb44614	
#define 	LAST_MAX_IB_POWER_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x618	 //RiscAdd 186//hB44618	
#define 	LAST_MAX_IB_POWER_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x61C	 //RiscAdd 187//hB4461C	

#define 	LAST_MAX_ACIDET_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x620	 //RiscAdd 188//hB44620	
#define 	LAST_MAX_ACIDET_POWER_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x624	 //RiscAdd 189//hb44624	
#define 	LAST_MAX_ACIDET_POWER_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x628	 //RiscAdd 18a//hB44628	
#define 	LAST_MAX_ACIDET_POWER_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x62C	 //RiscAdd 18b//hB4462C	

#define 	OCCUR_MASK_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x630	 //RiscAdd 18c//hB44630	
#define 	OCCUR_MASK_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x634	 //RiscAdd 18d//hB44634	
#define 	OCCUR_MASK_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x638	 //RiscAdd 18e//hB44638	
#define 	OCCUR_MASK_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x63C	 //RiscAdd 18f//hB4463C	

#define 	NOT_DETECTED_MASK_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x640	 //RiscAdd 190//hB44640	
#define 	NOT_DETECTED_MASK_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x644	 //RiscAdd 191//hB44644	
#define 	NOT_DETECTED_MASK_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x648	 //RiscAdd 192//hB44648	
#define 	NOT_DETECTED_MASK_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x64C	 //RiscAdd 193//hB4464C	

#define 	COMPLETED_MASK_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x650	 //RiscAdd 194//hB44650	
#define 	COMPLETED_MASK_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x654	 //RiscAdd 195//hB44654	
#define 	COMPLETED_MASK_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x658	 //RiscAdd 196//hB44658	
#define 	COMPLETED_MASK_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x65C	 //RiscAdd 197//hB4465C	


#define 	LAST_OCCUR_MASK_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x660	 //RiscAdd 198//hB44660	
#define 	LAST_OCCUR_MASK_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x664	 //RiscAdd 199//hB44664	
#define 	LAST_OCCUR_MASK_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x668	 //RiscAdd 19a//hB44668	
#define 	LAST_OCCUR_MASK_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x66C	 //RiscAdd 19b//hB4466C	

#define 	LAST_NOT_DETECTED_MASK_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x670	 //RiscAdd 19c//hB44670	
#define 	LAST_NOT_DETECTED_MASK_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x674	 //RiscAdd 19d//hB44674	
#define 	LAST_NOT_DETECTED_MASK_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x678	 //RiscAdd 19e//hB44678	
#define 	LAST_NOT_DETECTED_MASK_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x67C	 //RiscAdd 19f//hB4467C	

#define 	LAST_COMPLETED_MASK_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x680	 //RiscAdd 1a0//hB44680	
#define 	LAST_COMPLETED_MASK_AT_AGC_STEP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x684	 //RiscAdd 1a1//hB44684	
#define 	LAST_COMPLETED_MASK_AT_EVENT_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x688	 //RiscAdd 1a2//hB44688	
#define 	LAST_COMPLETED_MASK_AT_EVENT_35U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x68C	 //RiscAdd 1a3//hB4468C	


#define 	RADAR_FA_COUNTER_DISABLED_MAC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x690	 //RiscAdd 1a4//hB44690	
#define 	RADAR_FA_COUNTER_LOW_POWER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x694	 //RiscAdd 1a5//hB44694	
#define 	RADAR_FA_COUNTER_WEAK_POWER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x698	 //RiscAdd 1a6//hB44698	
#define 	RADAR_FA_COUNTER_MAX_PW	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x69C	 //RiscAdd 1a7//hB4469C	
#define 	RADAR_FA_COUNTER_OOB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x6A0	 //RiscAdd 1a8//hB446A0	
#define 	WEAK_RADAR_SUSPECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x6A4	 //RiscAdd 1a9//hB446A4	

#define 	RADAR_FA_TYPE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x6C0	 //RiscAdd 1b0//hB446C0	
#define 	RADAR_FA_LOW_POWER_AT_EVENT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x6C8	 //RiscAdd 1b2//hB446C4	
#define 	RADAR_FA_WEAK_POWER_AT_AGC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x6CC	 //RiscAdd 1b3//hB446C8	

#define 	PACKET_LOCATION_CCA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x79C	 //RiscAdd 1e7
#define 	SAVE_35US_ENEGRY_ONCE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7A0	 //RiscAdd 1e8

#define 	RADAR_TRIGGER_TYPE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7D4	 //RiscAdd 1f5//hB447D4	
#define 	RADAR_TYPE_MEM	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7D8	 //RiscAdd 1f6//hB447D8	
#define 	RADAR_COUNTER_0_2U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7DC	 //RiscAdd 1f7//hB447DC	
#define 	RADAR_COUNTER_2_6U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7E0	 //RiscAdd 1f8//hB447E0	
#define 	RADAR_COUNTER_6_7U	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7E4	 //RiscAdd 1f9//hB447E4	
#define 	RADAR_COUNTER_LONG	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7E8	 //RiscAdd 1fa//hB447E8	

#define 	LAST_SUB_BAND_MASK_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7EC	 //RiscAdd 1fb//hB447EC	

#define 	DFS_PAST_PULSE_TSF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x7F0	 //RiscAdd 1fc//hB447F0	

// From here is the addresses that were at ram_mem.h file now they are all fast_mem.
//All addressed should be multiply by 4 and add hB44000

// ===================================================================================
// 802.11h Cyclic buffer memory to MAC handshake for BT. 
// ====================================================================================
#define 	MEM_BT_BUF_START	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x800	 //RiscAdd 200//	total	32	words	//hb44800	
#define 	MEM_BT_BUF_END	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x880	 //RiscAdd 220//hb44880	
// address changes must be coordinated with MAC!!! 
#define 	MEM_RADAR_WR_POINTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x884	 //RiscAdd 221//	Local	Pointer	for	writing	the	Radar	Fifo	//	hb44884	
#define 	MEM_RADAR_RE_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x888	 //RiscAdd 222//	Counter	of	RADAR	messages	from	MAC	//	hb44888	
#define 	MEM_RADAR_WR_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x88C	 //RiscAdd 223//	Counter	of	RADAR	messages	for	MAC	//	hb4488C	
#define 	MEM_BT_WR_POINTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x890	 //RiscAdd 224//	Local	Pointer	for	writing	the	BT	Fifo	//	hb44890	
#define 	MEM_BT_WR_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x894	 //RiscAdd 225//	Counter	of	BT	messages	for	MAC	//	hb44894	
#define 	MEM_BT_RE_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x898	 //RiscAdd 226//	Counter	of	BT	messages	from	MAC	//	hb44898	

// 802.11H configuration from MAC
#define 	MEM_RADAR_THRESHOLD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x89C	 //RiscAdd 227//hb4489C	
#define 	MEM_RADAR_ENABLE_MAC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8A0	 //RiscAdd 228//hb448A0	
#define 	MEM_RADAR_ENABLE_RF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8A4	 //RiscAdd 229//hb448A4	
// BT Min RSSI calculation (for interference threshold)
#define 	BT_CURRENT_MIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8A8	 //RiscAdd 22a//hb448A8	//	address	changes	must	be	coordinated	with	MAC!!!	(MAC	has	WE)	Changed	from	AR10	
#define 	BT_MIN_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8AC	 //RiscAdd 22b//hb448AC	
#define 	BT_BB_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8B0	 //RiscAdd 22c//hb448B0	
#define 	BT_MEASURE_ENABLE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8B4	 //RiscAdd 22d

// ======================================================
// A G C   
// ======================================================
#define 	hold_max_gain_LNA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8B8	 //RiscAdd 22e
#define 	hold_max_gain_PGC1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8BC	 //RiscAdd 22f
#define 	hold_max_gain_BB_Digital	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8C0	 //RiscAdd 230
#define 	hold_max_gain_IB_Digital	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8C4	 //RiscAdd 231

#define 	REG_TEMP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8C8	 //RiscAdd 232

//#define ACTIVE_ANTTENA_ACC_OUT_MEM_ADD	0x0233		// for detection test

#define 	PROPOSED_BW_FOR_CTS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8D0	 //RiscAdd 234
#define 	TSF_RX_DETECTION	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8D4	 //RiscAdd 235
#define 	TSF_TX_EOP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8D8	 //RiscAdd 236
#define 	TX_WAS_RTS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8DC	 //RiscAdd 237
#define 	DET_BW_FOR_CCA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8E0	 //RiscAdd 238
#define 	AGC_RESET_TS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8E4	 //RiscAdd 239//hB448E4	
#define 	MAX_BB_POWER_AT_BB_INCREASE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8E8	 //RiscAdd 23a
//#define  SOUNDING_COUNTER               0x023b  // (242 -> 0x300208EC at the studio)

// Band select gains table- do not change address - used by csim!!!
#define 	BS_GAIN_0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8F0	 //RiscAdd 23c
#define 	BS_GAIN_3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8F4	 //RiscAdd 23d
#define 	BS_GAIN_6	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8F8	 //RiscAdd 23e
#define 	BS_GAIN_9	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x8FC	 //RiscAdd 23f
#define 	BS_GAIN_12	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x900	 //RiscAdd 240

// tpc:
#define 	TX_BB_GAIN_AND_TUNE_BACKUP_1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x904	 //RiscAdd 241

#define 	ANT_SELECTION_CTR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x908	 //RiscAdd 242//	{	ENABLE	[15]	,	Default	Antenna	select	[7:0]	}	(242	->	0x30020908	at	the	studio)	

#define 	CCA_INCREASE_AT_RX_PACKET	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x90C	 //RiscAdd 243
#define 	STM_HALT_STATE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x910	 //RiscAdd 244
#define 	STM_HALT_STATE_TIME	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x914	 //RiscAdd 245
          
// Free 0x0245..0x0248

// ======================================================
// General Use Memory	( 24X )
//=======================================================
#define 	GENERAL_USE_0_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x924	 //RiscAdd 249
#define 	GENERAL_USE_1_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x928	 //RiscAdd 24a
#define 	GENERAL_USE_2_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x92C	 //RiscAdd 24b
#define 	GENERAL_USE_3_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x930	 //RiscAdd 24c
#define 	GENERAL_USE_4_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x934	 //RiscAdd 24d
#define 	GENERAL_USE_5_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x938	 //RiscAdd 24e
#define 	GENERAL_USE_6_ADD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x93C	 //RiscAdd 24f




// ======================================================
// R X   P A C K E T (250 -> 0x30020940 at the studio)
// ======================================================
//free 0x250-0x251
#define 	PACKET_DROPPED_IND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x948	 //RiscAdd 252
#define 	MEM_PACKETS_TX_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x94C	 //RiscAdd 253
#define 	MEM_PACKETS_TX_ERR_LAST_MASK	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x950	 //RiscAdd 254
#define 	MEM_PACKETS_BAD_RISC_CODE_AREA_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x954	 //RiscAdd 255
//#define  BAND_SELECT_VALUE_INDEX					0x253        // Band select index for studio
#define 	MEM_PACKETS_AIRTIME_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x958	 //RiscAdd 256//	Num	of	AirTime	errors.	
#define 	MEM_GENRISCRESETS_COUNT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x95C	 //RiscAdd 257//	Num	of	Resets.	
#define 	MEM_PACKETS_INT_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x960	 //RiscAdd 258//	Num	of	TD	errors.	
#define 	MEM_PACKETS_SIGNAL_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x964	 //RiscAdd 259//	Number	of	signal/unsupported	errors.	
#define 	MEM_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x968	 //RiscAdd 25a//	Number	of	packets	transmitted.	
#define 	MEM_PACKETS_TIMEOUT_SIGNAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x96C	 //RiscAdd 25b//	number	of	signal	expired	
#define 	MEM_PACKETS_TIMEOUT_NOISE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x970	 //RiscAdd 25c//	number	of	noise	expired	
#define 	MEM_PACKETS_COMPLETED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x974	 //RiscAdd 25d//	number	of	packets	completed	
#define 	MEM_PACKETS_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x978	 //RiscAdd 25e//	Number	of	detections	
#define 	MEM_HT_GF_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x97C	 //RiscAdd 25f//	number	of	GF	packets	detected	
#define 	MEM_HT_MM_LEGACY_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x980	 //RiscAdd 260//	number	of	Legacy	packets	detected	
#define 	MEM_HT_MM_MIXED_MODE_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x984	 //RiscAdd 261//	number	of	Mixed	Mode	packets	detected	
#define 	MEM_COARSE_ANTENNA_DELETION	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x988	 //RiscAdd 262//	number	of	Coarse	antenna	deletion	
#define 	MEM_FINE_ANTENNA_DELETION	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x98C	 //RiscAdd 263//	number	of	Fine	antenna	deletion	
#define 	MEM_SOUNDING_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x990	 //RiscAdd 264//	Number	of	detections	msb	
#define 	MEM_ANT3_BB_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x994	 //RiscAdd 265
#define 	MEM_PACKETS_DROP_ENERGY_CHANGE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x998	 //RiscAdd 266
#define 	MEM_INTERFERER_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x99C	 //RiscAdd 267
#define 	MEM_BE_ERR_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9A0	 //RiscAdd 268
#define 	MEM_PACKETS_11B_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9A4	 //RiscAdd 269
#define 	MEM_ANT0_BB_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9A8	 //RiscAdd 26a
#define 	MEM_ANT1_BB_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9AC	 //RiscAdd 26b
#define 	MEM_ANT2_BB_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9B0	 //RiscAdd 26c
#define 	MEM_VHT_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9B4	 //RiscAdd 26d//	(hB449B4	at	the	studio)	
#define 	MEM_MODEM_B_ERROR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9B8	 //RiscAdd 26e
#define 	MEM_ANT0_RF_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9BC	 //RiscAdd 26f//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT1_RF_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9C0	 //RiscAdd 270//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT2_RF_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9C4	 //RiscAdd 271//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT3_RF_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9C8	 //RiscAdd 272//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT0_S0_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9CC	 //RiscAdd 273//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT1_S0_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9D0	 //RiscAdd 274//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT2_S0_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9D4	 //RiscAdd 275//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_ANT3_S0_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9D8	 //RiscAdd 276//	fixed	address	-	used	in	BF	calibration	
#define 	VERIFY_BFCAL_AGC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9DC	 //RiscAdd 277
#define 	MEM_BF_TX_RX_MODE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9E0	 //RiscAdd 278//	fixed	address	-	used	in	BF	calibration	
#define 	MEM_SECOND_LTF_DETECTION	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9E4	 //RiscAdd 279//	number	of	non	ofdm	detected	by	second	ltf	detection	
#define 	MEM_PACKET_DROPPED_UNSUPPORTED_MCS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9E8	 //RiscAdd 27a//	count	number	of	packets	dropped	due	to	unsupported	MCS	hB449E8	
#define 	MEM_PACKET_DROPPED_MAC_ABORT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9EC	 //RiscAdd 27b//	count	number	of	packets	dropped	due	to	MAC	abort	
#define 	MEM_PACKET_DROPPED_CHECK_TIMEOUT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9F0	 //RiscAdd 27c//	count	number	of	packets	dropped	due	to	check	time	out	
#define 	MEM_PACKET_DROPPED_ALL_ANTENNAS_DELETED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9F4	 //RiscAdd 27d//	count	number	of	packets	dropped	due	to	all	antennas	deleted	
#define 	MEM_PACKETS_TIMEOUT_OFDM_EOP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9F8	 //RiscAdd 27e//	count	number	of	packets	dropped	due	to	all	antennas	deleted	
#define 	MEM_TX_DURING_RX1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x9FC	 //RiscAdd 27f
#define 	MEM_TX_DURING_RX2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA00	 //RiscAdd 280
#define 	MEM_TX_DURING_RX3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA04	 //RiscAdd 281
#define 	MEM_TX_DURING_RX4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA08	 //RiscAdd 282
#define 	MEM_MODEM_HALTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA0C	 //RiscAdd 283
#define 	MEM_PACKET_DROPPED_11B_AFTER_ERROR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA10	 //RiscAdd 284
#define 	MEM_PACKETS_TIMEOUT_11B_EOP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA14	 //RiscAdd 285
#define 	MEM_PACKET_DROP_SIG_PARSE_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA18	 //RiscAdd 286
#define 	MEM_FD_TIMING	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA1C	 //RiscAdd 287//	hB44A1C	
#define 	MEM_DETECTOR_BW	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA20	 //RiscAdd 288//	hB44A20	
#define 	MEM_COUNT_FD_TIMING_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA24	 //RiscAdd 289//	hB44A24	
#define 	MEM_TX_WITH_WRONG_BW	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA28	 //RiscAdd 28a
#define 	MEM_CHANGE_BW_RTS_CTS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA2C	 //RiscAdd 28b//	hB44A2C	
#define 	MEM_RETURN_BW_RTS_CTS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA30	 //RiscAdd 28c//	hB44A30	
#define 	MEM_DET_IMD_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA34	 //RiscAdd 28d//	hB44A34	
#define 	OFDM_PACKET_COUNT_5G_NOT_TO_MY_AP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA38	 //RiscAdd 28e//	hB44A38	
#define 	MEM_PACKETS_LONG_HT_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA3C	 //RiscAdd 28f//	hB44A3c	

// check for VGA LIMITATION (18/0)
#define 	MEM_ANT0_VGA_MIN_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA40	 //RiscAdd 290
#define 	MEM_ANT0_VGA_MAX_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA44	 //RiscAdd 291
#define 	MEM_ANT1_VGA_MIN_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA48	 //RiscAdd 292
#define 	MEM_ANT1_VGA_MAX_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA4C	 //RiscAdd 293
#define 	MEM_ANT2_VGA_MIN_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA50	 //RiscAdd 294
#define 	MEM_ANT2_VGA_MAX_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA54	 //RiscAdd 295
#define 	MEM_ANT3_VGA_MIN_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA58	 //RiscAdd 296
#define 	MEM_ANT3_VGA_MAX_FINAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA5C	 //RiscAdd 297

#define 	MEM_RIFS_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA60	 //RiscAdd 298
#define 	MEM_PACKET_LENGTH_MISMATCH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA64	 //RiscAdd 299
#define 	MEM_RESET_ON_ERR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA68	 //RiscAdd 29a
#define 	MEM_GLOBAL_TIMEOUT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA6C	 //RiscAdd 29b

//free 0x29C-0x29D
#define 	MEM_HE_MU_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA78	 //RiscAdd 29e//	Number	of	HE	packets	transmitted.	

// flag from MAC to shutdown PHY after Tx
#define 	MEM_MAC_HALT_PHY	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA7C	 //RiscAdd 29f//	MAC	address	hB44A7C	
 
#define 	MEM_MAC_MODE_20SSB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA80	 //RiscAdd 2a0//	hB44A80	-	Flag	from	MAC	that	it	is	working	only	20Mhz	SSB	-	drop	CB	packets	and	block	Aux	channel	
#define 	MEM_NUM_ANTENNAS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA84	 //RiscAdd 2a1//	valid	after	first	min	noise	

// Flag from MAC to stay at Tx (For production purpose of sending continues CW)
#define 	MEM_STAY_AT_TX	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA88	 //RiscAdd 2a2//	MAC	address	hB44A88	

#define 	MEM_LEGACY_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA8C	 //RiscAdd 2a3//	Number	of	legacy	packets	transmitted.	
#define 	MEM_HT_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA90	 //RiscAdd 2a4//	Number	of	HT	packets	transmitted.	
#define 	MEM_VHT_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA94	 //RiscAdd 2a5//	Number	of	VHT	packets	transmitted.	
#define 	MEM_HE_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA98	 //RiscAdd 2a6//	Number	of	HE	packets	transmitted.	
#define 	MEM_11b_PACKETS_TRANSMITTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xA9C	 //RiscAdd 2a7//	Number	of	11b	packets	transmitted.	

#define 	MEM_DETECT_ERROR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAA0	 //RiscAdd 2a8//	hB44AA0	
#define 	MEM_CO_CHANNEL_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAA4	 //RiscAdd 2a9//	hB44AA4	
#define 	MEM_BF_EN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAA8	 //RiscAdd 2aa
#define 	MEM_FD_CO_CHANNEL_DETECTED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAAC	 //RiscAdd 2ab
#define 	LNA_LOOKUP	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAB0	 //RiscAdd 2ac//	for	mac	(written	by	progmodel	for	dc	calibration)	

//tpc
#define 	TX_BB_GAIN_AND_TUNE_BACKUP_2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAB4	 //RiscAdd 2ad

#define 	BF_CALIBRATION_RECORD_CH_CMD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAB8	 //RiscAdd 2ae//	Mac	(hB44Ab8)	ask	to	record	the	channel	for	BF	implicit	calibrations	

//#define  MEM_SET_RX_BF_IMPLICIT_SOUNDING 0x2af  // Studio (hB44Abc) - for MAC_Emu set for Implicit sounding metric (only at non transmitting side otherwise the TX change it from the TCR)

// Debug for ATE RF power output (only if two step is active)
#define 	MEM_RF_RSSI_POWER_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAC0	 //RiscAdd 2b0//	MAC/Studio	address	hB44AC0	
#define 	MEM_RF_RSSI_POWER_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAC4	 //RiscAdd 2b1//	MAC/Studio	address	hB44AC4	
#define 	MEM_RF_RSSI_POWER_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAC8	 //RiscAdd 2b2//	MAC/Studio	address	hB44AC8	
#define 	MEM_RF_RSSI_POWER_ANT4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xACC	 //RiscAdd 2b3//	MAC/Studio	address	hB44ACC	

#define 	DROP_PACKETS_ON_ENERGY_CHANGE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAD0	 //RiscAdd 2b4
#define 	DROP_PACKETS_ON_ENERGY_CHANGE_11B	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAD4	 //RiscAdd 2b5

#define 	CREATE_BE_ERROR_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAD8	 //RiscAdd 2b6
#define 	CREATE_BE_ERROR_ENABLE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xADC	 //RiscAdd 2b7

// new registers for "throw detections below TH" new mechanism, based on duty cycle time
#define 	FAR_STATION_THRESHOLD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAE4	 //RiscAdd 2b9//	hB44AE4	must	not	change	address	-	set	from	progmodel,	and	from	FW	
#define 	DET_TH_TIMER_ON	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAE8	 //RiscAdd 2ba//	hB44AE8	must	not	change	address	-	set	from	FW	
#define 	DET_TH_TIMER_OFF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAEC	 //RiscAdd 2bb//	hB44AEC	must	not	change	address	-	set	from	FW	
#define 	DETECTOR_EN_THRESH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAF0	 //RiscAdd 2bc//	hB44AF0	//	do	not	change	address	init	from	CSim	
//#define	 BAND_SELECT_VALUE_INDEX_MEM	0x02bd
#define 	DETECTOR_EN_THRESH_MEM	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAF8	 //RiscAdd 2be
#define 	DETECTOR_THRESHOLD_11B_MEM	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xAFC	 //RiscAdd 2bf
#define 	LSB_CTRL_CHANNEL_IND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB00	 //RiscAdd 2c0
#define 	DET_TH_DUTY_MODE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB04	 //RiscAdd 2c1//	hB44B04	
#define 	DET_TH_LAST_CHANGE_TIME	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB08	 //RiscAdd 2c2
#define 	DET_11b_LAST_ERROR_TIME	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB0C	 //RiscAdd 2c3
#define 	MU_HOST_MASKS_1SS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB10	 //RiscAdd 2c4
#define 	MINIMAL_STA_RSSI_FROM_MAC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB14	 //RiscAdd 2c5//	hB44B14	do	not	change	address,	written	from	MAC	,	init	from	csim	
#define 	DETECTOR_11B_CURR_TH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB18	 //RiscAdd 2c6//	do	not	change	address	init	from	CSim	
#define 	LSB40_CTRL_CHANNEL_IND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB1C	 //RiscAdd 2c7
#define 	SIGB_HANDLED	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB20	 //RiscAdd 2c8
#define 	START_LOOP_TIME	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB24	 //RiscAdd 2c9
#define 	SAVE_DETECTOR_TH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB28	 //RiscAdd 2ca

// Free 0x02cb..0x02ce

// ====================
//		DEBUG
// ====================
#define 	DROP_DETECTION_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB3C	 //RiscAdd 2cf//	change	in	address	should	be	followed	by	a	change	in	BB	(Genrisc_Indications)	
#define 	MEM_FD_TIMING_ABS_PHASOR_AN0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB40	 //RiscAdd 2d0
#define 	MEM_FD_TIMING_ABS_PHASOR_AN1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB44	 //RiscAdd 2d1
#define 	MEM_FD_TIMING_ABS_PHASOR_AN2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB48	 //RiscAdd 2d2
#define 	MEM_FD_TIMING_ABS_PHASOR_AN3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB4C	 //RiscAdd 2d3

#define 	CONVERT_MINUS_9dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB50	 //RiscAdd 2d4//-9dB	
#define 	CONVERT_MINUS_8dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB54	 //RiscAdd 2d5//-8dB	
#define 	CONVERT_MINUS_7dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB58	 //RiscAdd 2d6//-7dB	
#define 	CONVERT_MINUS_6dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB5C	 //RiscAdd 2d7//-6dB	
#define 	CONVERT_MINUS_5dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB60	 //RiscAdd 2d8//-5dB	
#define 	CONVERT_MINUS_4dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB64	 //RiscAdd 2d9//-4dB	
#define 	CONVERT_MINUS_3dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB68	 //RiscAdd 2da//-3dB	
#define 	CONVERT_MINUS_2dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB6C	 //RiscAdd 2db//-2dB	
#define 	CONVERT_MINUS_1dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB70	 //RiscAdd 2dc//-1dB	
#define 	CONVERT_0dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB74	 //RiscAdd 2dd//0dB	
#define 	CONVERT_1dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB78	 //RiscAdd 2de//1dB	
#define 	CONVERT_2dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB7C	 //RiscAdd 2df//2dB	
#define 	CONVERT_3dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB80	 //RiscAdd 2e0//3dB	
#define 	CONVERT_4dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB84	 //RiscAdd 2e1//4dB	
#define 	CONVERT_5dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB88	 //RiscAdd 2e2//5dB	
#define 	CONVERT_6dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB8C	 //RiscAdd 2e3//6dB	
#define 	CONVERT_7dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB90	 //RiscAdd 2e4//7dB	
#define 	CONVERT_8dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB94	 //RiscAdd 2e5//8dB	
#define 	CONVERT_9dB_TO_LINEAR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB98	 //RiscAdd 2e6//9dB	
#define 	ANT1_GAIN0_WORD	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xB9C	 //RiscAdd 2e7//hB44B9C	
#define 	ANT1_BB_POWER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBA0	 //RiscAdd 2e8//hB44BA0	
#define 	ANT1_RF_POWER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBA4	 //RiscAdd 2e9//hB44BA4	
#define 	ANT1_BB_RSSI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBA8	 //RiscAdd 2ea//hB44BA8	
#define 	ANT1_digital_gain	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBAC	 //RiscAdd 2eb//hB44BAC	
//#define MEM_EFFECTIVE_SNR_MCS	    	0x02fb
//#define MEM_EFFECTIVE_SNR_METRIC		0x02fc  
#define 	MEM_FD_TIMING_SHIFT_AN0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBB0	 //RiscAdd 2ec
#define 	MEM_FD_TIMING_SHIFT_AN1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBB4	 //RiscAdd 2ed
#define 	MEM_FD_TIMING_SHIFT_AN2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBB8	 //RiscAdd 2ee
#define 	MEM_FD_TIMING_SHIFT_AN3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBBC	 //RiscAdd 2ef

#define 	MEM_TRANSMIT_ONE_PACKET	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBEC	 //RiscAdd 2fb
#define 	CSIM_HASH_LO	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBF0	 //RiscAdd 2fc//(Do	not	move	location)	
#define 	CSIM_HASH_HI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBF4	 //RiscAdd 2fd//(Do	not	move	location)	
#define 	SVN_CSIM_REVISION_LO	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBF8	 //RiscAdd 2fe//(Do	not	move	location)	Lower	16	bits	of	revision	number	
#define 	SVN_CSIM_REVISION_HI	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xBFC	 //RiscAdd 2ff//(Do	not	move	location)	Upper	8	bits	of	revision	number	+	7	bits	branch	ID	+	1	bit	modified	flag	
#define 	BF_FLAT_GAIN_CAL_TABLE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xC00	 //RiscAdd 300//(Do	not	move	location)	76	adresses	-	calcualtion:	38=max(31gen4,38gen5)	gains	total,4	antennas,	2	cal	values	per	16bit	ram	->	total	memory	size	38*4/2=76	addresses	
#define 	BF_FLAT_GAIN_CAL_TABLE_END	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD2C	 //RiscAdd 34b
#define 	TX_INT_COUNTER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD30	 //RiscAdd 34c
#define 	OFFLINE_BFCAL_DATABASE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD34	 //RiscAdd 34d
#define 	VERIFY_BFCAL_TPC	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD38	 //RiscAdd 34e
#define 	FIRST_2SS_EVM	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD3C	 //RiscAdd 34f
#define 	SECOND_2SS_EVM	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD40	 //RiscAdd 350
// Free 0x0351..0x0353

// Params for AirLoopBack verification and for BB form (ALB needs IsHt,Length)
#define 	LAST_PACKET_DATA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD50	 //RiscAdd 354
#define 	LAST_PACKET_LENGTH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD54	 //RiscAdd 355
#define 	LAST_PACKET_IS_HT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD58	 //RiscAdd 356
#define 	LAST_PACKET_MCS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD5C	 //RiscAdd 357

// Free 0x0358-0x035D
#define 	GENRISC_FINISHED_LOADING	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD78	 //RiscAdd 35e//	MAC/Studio	address	hB44D78	//	Don't	change	address!!!	FW	ReadWrite	from	here	
#define 	GENRISC_DETECT_CAUSE_UNS_ERROR	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD7C	 //RiscAdd 35f//	use	for	verify	causes	of	unsupprted	errors	that	not	detected(supported0	in	hw	and	genrisc	need	to	detect	
#define 	DFS_IB_ENERGY_INTERFERENCE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xD80	 //RiscAdd 360
// Free 0x0360-0x368
#define 	START_TRAINING	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDA4	 //RiscAdd 369
#define 	AFE_RX_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDBC	 //RiscAdd 36f//(Do	not	move	location)	

//RF section 0x370 - 0x3ff from PSD do not move location without FW and PSD changes
#define 	RF_SEC_START	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDC0	 //RiscAdd 370
#define 	RF_TX0_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDC0	 //RiscAdd 370//hB44DC0	//full	TX	mode	with	PA	on,	TRSW	in	TX	mode	
#define 	RF_TX1_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDC4	 //RiscAdd 371//hB44DC4	//full	TX	mode	with	PA	on,	TRSW	in	TX	mode	
#define 	RF_TX2_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDC8	 //RiscAdd 372//hB44DC8	//full	TX	mode	with	PA	on,	TRSW	in	TX	mode	
#define 	RF_TX3_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDCC	 //RiscAdd 373//hB44DCC	//full	TX	mode	with	PA	on,	TRSW	in	TX	mode	
#define 	RF_RX0_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDD0	 //RiscAdd 374//hB44DD0	//LNA	on	and	TRSW	in	RX	mode	
#define 	RF_RX1_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDD4	 //RiscAdd 375//hB44DD4	//LNA	on	and	TRSW	in	RX	mode	
#define 	RF_RX2_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDD8	 //RiscAdd 376//hB44DD8	//LNA	on	and	TRSW	in	RX	mode	
#define 	RF_RX3_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDDC	 //RiscAdd 377//hB44DDC	//LNA	on	and	TRSW	in	RX	mode	
#define 	RF_trist0_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDE0	 //RiscAdd 378//hB44DE0	//RX	mode	with	PA	off,	LNA	bypass,	TRSW	in	TX	mode	
#define 	RF_trist1_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDE4	 //RiscAdd 379//hB44DE4	//RX	mode	with	PA	off,	LNA	bypass,	TRSW	in	TX	mode	
#define 	RF_trist2_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDE8	 //RiscAdd 37a//hB44DE8	//RX	mode	with	PA	off,	LNA	bypass,	TRSW	in	TX	mode	
#define 	RF_trist3_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDEC	 //RiscAdd 37b//hB44DEC	//RX	mode	with	PA	off,	LNA	bypass,	TRSW	in	TX	mode	
#define 	RF_PA0_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDF0	 //RiscAdd 37c//hB44DF0	//TX	mode	with	PA	on,	TRSW	in	RX	mode	
#define 	RF_PA1_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDF4	 //RiscAdd 37d//hB44DF4	//TX	mode	with	PA	on,	TRSW	in	RX	mode	
#define 	RF_PA2_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDF8	 //RiscAdd 37e//hB44DF8	//TX	mode	with	PA	on,	TRSW	in	RX	mode	
#define 	RF_PA3_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xDFC	 //RiscAdd 37f//hB44DFC	//TX	mode	with	PA	on,	TRSW	in	RX	mode	
#define 	RF_ELNA_BYPASS0_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE00	 //RiscAdd 380//hB44E00	//RX	mode	with	LNA	in	bypass	
#define 	RF_ELNA_BYPASS1_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE04	 //RiscAdd 381//hB44E04	//RX	mode	with	LNA	in	bypass	
#define 	RF_ELNA_BYPASS2_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE08	 //RiscAdd 382//hB44E08	//RX	mode	with	LNA	in	bypass	
#define 	RF_ELNA_BYPASS3_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE0C	 //RiscAdd 383//hB44E0C	//RX	mode	with	LNA	in	bypass	
#define 	EXTERNAL_LNA_MODE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE10	 //RiscAdd 384//hB44E10	//Is	external	LNA	exist	
#define 	EXT_LNA_GAIN_HIGH	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE14	 //RiscAdd 385//hB44E14	//external	LNA	gain	[dB]	
#define 	EXT_LNA_GAIN_BYPASS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE18	 //RiscAdd 386//hB44E18	//External	LNA	gain	in	bypass	mode,	[dB]	
#define 	NUMBER_OF_LNA_GAINS	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE1C	 //RiscAdd 387//hB44E1C	//attenuation	of	TR-SW	when	flipping	to	Tx	during	Rx,	or	to	Rx	during	Tx	
#define 	IS_EXTERNAL_PA	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE20	 //RiscAdd 388//hB44E20	//External	PA	exists	
#define 	EXTERNAL_TXGAIN_DB_BF	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE24	 //RiscAdd 389//hB44E24	//External	PA	gain	[dB]	
#define 	TSSI_MIN_LIMIT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE28	 //RiscAdd 38a//hB44E28	//Limit	for	minimum	TSSI	
#define 	TSSI_MAX_LIMIT	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE2C	 //RiscAdd 38b//hB44E2C	//Limit	for	Max	TSSI	
#define 	RFIC_VER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE30	 //RiscAdd 38c//hB44E30	//RFIC	version	
#define 	TOTAL_EXT_GAIN_DB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE34	 //RiscAdd 38d//hB44E34	//External	LNA	gain+External	PA	gain	in	DB	(RF	gain	above	normal	internal	RF)	
#define 	TOTAL_EXT_GAIN_LIN	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE38	 //RiscAdd 38e//hB44E38	//External	LNA	gain+External	PA	gain	in	linear	scale	
#define 	EXT_LNA_ATTEN_DB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE3C	 //RiscAdd 38f//hB44E3C	//attenuation	of	Rx	path	when	switching	the	external	LNA	to	bypass	mode	
#define 	USE_TR_SW_IN_BF_CAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE40	 //RiscAdd 390//hB44E40	//In	BF	Calibration	which	attenuation	to	use:	Tr-Sw	or	external	LNA	
#define 	RF_TX_TR_RX_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE44	 //RiscAdd 391//hB44E44	//TX	RF	word	with	TR-SW	at	RX	mode	
#define 	RF_RX_TR_TX_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE48	 //RiscAdd 392//hB44E48	//RX	RF	word	with	TR-SW	at	TX	mode	
#define 	BOARD_INDEX	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE4C	 //RiscAdd 393//hB44E4C	//Board	column	index	in	PSD	table	
#define 	CALIBRATION_TRIGGER_MASK	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE50	 //RiscAdd 394//hB44E50	//Board	column	index	in	PSD	table	
#define 	RF_IS_BB	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE54	 //RiscAdd 395//hB44E54	//	RF	is	bb=1	if	no	RF	RSSI	calibration	
#define 	COEX_Wifi_Tx_Control	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE58	 //RiscAdd 396//hB44E58	//Coex	wifi	tx	control	-	0	regular,	1	stop	tx.	
#define 	temp2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE5C	 //RiscAdd 397//hB44E5C	//temp	address	for	SW	RFFW	routin	
#define 	RF_RXIQ0_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE60	 //RiscAdd 398//hB44E60	//RFFE	state	in	RXIQ	calibration	
#define 	RF_RXIQ1_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE64	 //RiscAdd 399//hB44E64	//RFFE	state	in	RXIQ	calibration	
#define 	RF_RXIQ2_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE68	 //RiscAdd 39a//hB44E68	//RFFE	state	in	RXIQ	calibration	
#define 	RF_RXIQ3_COMMAND	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE6C	 //RiscAdd 39b//hB44E6C	//RFFE	state	in	RXIQ	calibration	
#define 	RSSI_DC_CAL	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE70	 //RiscAdd 39c//hB44E70	//	RSSI_DC_CAL=1	do	rssi	dc	cal	tssi-gamma	to	offset1	
// Reserved for PSD (PHY/RF/MIPS common regs ) 0x39d..0x3ff                                     
#define 	BB_RSSI_for_log_ant0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE74	 //RiscAdd 39d
#define 	BB_RSSI_for_log_ant1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE78	 //RiscAdd 39e
#define 	BB_RSSI_for_log_ant2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE7C	 //RiscAdd 39f
#define 	BB_RSSI_for_log_ant3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE80	 //RiscAdd 3a0
#define 	bb_digital_for_log_ant0	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE84	 //RiscAdd 3a1
#define 	bb_digital_for_log_ant1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE88	 //RiscAdd 3a2
#define 	bb_digital_for_log_ant2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE8C	 //RiscAdd 3a3
#define 	bb_digital_for_log_ant3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE90	 //RiscAdd 3a4
#define 	MEM_DIGITAL_IB_BOF_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE94	 //RiscAdd 3a5//h30020E94	
#define 	MEM_DIGITAL_IB_BOF_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE98	 //RiscAdd 3a6//h30020E98	
#define 	MEM_DIGITAL_IB_BOF_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xE9C	 //RiscAdd 3a7//h30020E9C	
#define 	MEM_DIGITAL_IB_BOF_ANT4	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xEA0	 //RiscAdd 3a8//h30020EA0	
#define 	MEM_DIGITAL_BB_BOF_ANT1	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xEA4	 //RiscAdd 3a9//h30020EA4	
#define 	MEM_DIGITAL_BB_BOF_ANT2	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xEA8	 //RiscAdd 3aa//h30020EA8	
#define 	MEM_DIGITAL_BB_BOF_ANT3	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0xEAC	 //RiscAdd 3ab//h30020EAC	
#define 	TX_WIN_BANDEDGE_FIX_TABLE	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1080	 //RiscAdd 420//hB45080	//	TXWINDOWING	for	BANDEDGE	160;80;40;20	
#define 	TX_WIN_BANDEDGE_FIX_ENABLER	 B0_PHY_RX_TD_BASE_ADDR+0x4000+0x1084	 //RiscAdd 421//hB45084	//	TXWINDOWING	ENABLE	
#endif 
