/************************************************************************************
*		
*	File:			RxHandler_InitApi.h
*	
*	Description:	This is the main file for the Tx Sender GenRisc Module. 
*					All other files that are part of the Module will be included
*					to this file, and compiled as part of it.
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef RX_HANDLER_INIT_API_H
#define RX_HANDLER_INIT_API_H


/* number of MSDU descriptors */
#define MSDU_DESC_NUMBER_OF_ENTRIES											(0x80)

/* Number of Reserved Words in Rx Frame Prefix on Rx Cyclic Buffer (configured to RxC) */
#define FRAME_PREFIX_RESERVED_LENGTH_IN_WORDS								(0x0)


#define RX_HANDLER_INIT_FIELD_CHI_MAGIC_READY_VALUE_H						(0xCAFEu)
#define RX_HANDLER_INIT_FIELD_CHI_MAGIC_READY_VALUE_L						(0xCAFEu)

/*
	When FW writes init vector, chi magic is 0x0
	After Rx Handler finish parsing init vector, 
	FW expects it to override chi magic with 0xCAFECAFE
*/


//Sniffer templates parameters
#define SNIFFER_HDR_TEMPLATE_SIZE_IN_BYTES									(64)
#define SNIFFER_TEMPLATE_RING_NUM_OF_ENTRIES								(88)

#define RX_HANDLER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_H					(0xFFFF)					
#define RX_HANDLER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_L					(0xFFFF)


#endif //RX_HANDLER_INIT_API_H

