/************************************************************************************
*		
*	File:			RxHandler_MailboxApi.h
*	
*	Description:	This is the main file for the Rx Handler GenRisc Module. 
*					All other files that are part of the Module will be included
*					to this file, and compiled as part of it.
*
*	COPYRIGHT: 
*		(C) Intel Israel
*		All rights are strictly reserved. Reproduction or divulgence in any   
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Intel Israel
*
**************************************************************************************/
#ifndef RX_HANDLER_MAILBOX_API_H
#define RX_HANDLER_MAILBOX_API_H
	
#ifdef CPU_ARC
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#endif //CPU_ARC
	
	/*Mailbox mapping - must be one mailbox per mips*/
				
#define RX_HANDLER_2_LOWER_MAC_INTERRUPTS_ERROR_START_BIT									(0x0)
#define RX_HANDLER_2_LOWER_MAC_INTERRUPTS_MAILBOX_FIFO_OUT_NOT_EMPTY_START_BIT				(0x1)
#define RX_HANDLER_2_LOWER_MAC_INTERRUPTS_SNIFFER_TRIGGER_FRAME_START_BIT					(0x2)
	
#define RX_HANDLER_2_LOWER_MAC_INTERRUPTS_ERROR_MASK										(0x1 << RX_HANDLER_2_LOWER_MAC_INTERRUPTS_ERROR_START_BIT)
#define RX_HANDLER_2_LOWER_MAC_INTERRUPTS_MAILBOX_FIFO_OUT_NOT_EMPTY_MASK					(0x1 << RX_HANDLER_2_LOWER_MAC_INTERRUPTS_MAILBOX_FIFO_OUT_NOT_EMPTY_START_BIT)
#define RX_HANDLER_2_LOWER_MAC_INTERRUPTS_SNIFFER_TRIGGER_FRAME_MASK						(0x1 << RX_HANDLER_2_LOWER_MAC_INTERRUPTS_SNIFFER_TRIGGER_FRAME_START_BIT)
	
	//----------------------------------------- Mailbox FIFO IN --------------------------------------------//
	
	
	
#ifdef CPU_ARC
	
	typedef struct _FwRxHandlerMailboxFifoInMessage_t
	{	
		uint32 messageId : 16;
		uint32 messageValue : 16;
	} FwRxHandlerMailboxFifoInMessage_t;
	
	
	typedef struct _FwRxHandlerMailboxFifoInParams_t
	{	
		uint32 readCounter;
		uint32 writeCounter;
		FwRxHandlerMailboxFifoInMessage_t messageArray[];
	} FwRxHandlerMailboxFifoInParams_t;
	
#endif /* CPU_ARC*/
	
	//-------- MAILBOX FIFO IN ENTRY STRUCTURE FIELDS ------------
	
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_ID_WORD_OFFSET						0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_ID_START_BIT						0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_ID_NUMBER_OF_BITS					0x10
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_ID_MASK_H							0x0000
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_ID_MASK_L							0xFFFF
						  
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_VALUE_WORD_OFFSET					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_VALUE_START_BIT					0x10
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_VALUE_NUMBER_OF_BITS				0x10
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_VALUE_MASK_H						0xFFFF
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_WORD_0_FIELD_MESSAGE_VALUE_MASK_L						0x0000
	
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_ENTRY_SIZE													(0x1 << 0x2) //1 WORDS
	
	
										/*Message ID enums*/
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_MESSAGE_ID_GET_CPU_LOAD_TIMERS								(0x0)
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_MESSAGE_ID_CHANGE_LOGGER_STREAM								(0x1)
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_MESSAGE_ID_MAGIC_PACKET_MODE_CHANGED							(0x2)
	
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_NUM_OF_VALID_MESSAGES											(0x3)
				
										/*Message value enums */
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_MESSAGE_VALUE_MAGIC_PACKET_MODE_DISABLED						(0x0)
#define FW_RX_HANDLER_MAILBOX_FIFO_IN_MESSAGE_VALUE_MAGIC_PACKET_MODE_ENABLED						(0x1)
	
	//---------------------------------------------------------------------------------------------------------//
	
	
	
	
	
	//----------------------------------------- Mailbox FIFO OUT --------------------------------------------//
	
	
#ifdef CPU_ARC
	
	typedef struct _FwRxHandlerMailboxFifoOutMessage_t
	{	
		uint32 messageId : 16;
		uint32 reserved_0 : 16;
	
		uint32 messageData0;
	
		uint32 messageData1;
	
		uint32 messageData2;
	
		uint32 messageData3;
	} FwRxHandlerMailboxFifoOutMessage_t;
	
	
	typedef struct _FwRxHandlerMailboxFifoOutParams_t
	{	
		uint32 readCounter;
		uint32 writeCounter;
		FwRxHandlerMailboxFifoOutMessage_t messageArray[];
	} FwRxHandlerMailboxFifoOutParams_t;
	
#endif /* CPU_ARC*/
	
	//-------- MAILBOX FIFO OUT ENTRY STRUCTURE FIELDS ------------
	
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_MESSAGE_ID_WORD_OFFSET					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_MESSAGE_ID_START_BIT						0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_MESSAGE_ID_NUMBER_OF_BITS					0x10
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_MESSAGE_ID_MASK_H							0x0000
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_MESSAGE_ID_MASK_L							0xFFFF
						 
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_RESERVED_0_WORD_OFFSET					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_RESERVED_0_START_BIT						0x10
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_RESERVED_0_NUMBER_OF_BITS					0x10
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_RESERVED_0_MASK_H							0xFFFF
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_0_FIELD_RESERVED_0_MASK_L							0x0000
	
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_1_FIELD_MESSAGE_DATA_0_WORD_OFFSET				0x1
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_1_FIELD_MESSAGE_DATA_0_START_BIT					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_1_FIELD_MESSAGE_DATA_0_NUMBER_OF_BITS				0x20
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_1_FIELD_MESSAGE_DATA_0_MASK_H						0xFFFF
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_1_FIELD_MESSAGE_DATA_0_MASK_L						0xFFFF
	
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_2_FIELD_MESSAGE_DATA_1_WORD_OFFSET				0x2
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_2_FIELD_MESSAGE_DATA_1_START_BIT					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_2_FIELD_MESSAGE_DATA_1_NUMBER_OF_BITS				0x20
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_2_FIELD_MESSAGE_DATA_1_MASK_H						0xFFFF
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_2_FIELD_MESSAGE_DATA_1_MASK_L						0xFFFF
	
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_3_FIELD_MESSAGE_DATA_2_WORD_OFFSET				0x3
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_3_FIELD_MESSAGE_DATA_2_START_BIT					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_3_FIELD_MESSAGE_DATA_2_NUMBER_OF_BITS				0x20
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_3_FIELD_MESSAGE_DATA_2_MASK_H						0xFFFF
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_3_FIELD_MESSAGE_DATA_2_MASK_L						0xFFFF
	
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_4_FIELD_MESSAGE_DATA_3_WORD_OFFSET				0x4
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_4_FIELD_MESSAGE_DATA_3_START_BIT					0x0
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_4_FIELD_MESSAGE_DATA_3_NUMBER_OF_BITS				0x20
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_4_FIELD_MESSAGE_DATA_3_MASK_H						0xFFFF
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_WORD_4_FIELD_MESSAGE_DATA_3_MASK_L						0xFFFF
	
					 
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_ENTRY_SIZE													(0x5 << 0x2) //1 WORDS
	
	
												/*Message ID enums*/
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_MESSAGE_ID_CPU_LOAD_TIMERS									(0x0)
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_MESSAGE_ID_CONFIRM											(0x1)
	
	
#define FW_RX_HANDLER_MAILBOX_FIFO_OUT_NUM_OF_VALID_MESSAGES										(0x2)
	
	//---------------------------------------------------------------------------------------------------------//
	
	
	/*---- Mailbox FIFO offsets in struct ----*/
#define FW_RX_HANDLER_MAILBOX_FIFO_READ_COUNTER			(0x00 << 0x2)
#define FW_RX_HANDLER_MAILBOX_FIFO_WRITE_COUNTER		(0x01 << 0x2)
#define FW_RX_HANDLER_MAILBOX_FIFO_START				(0x02 << 0x2)
	
	/*---- Dummy message value ----*/
#define FW_RX_HANDLER_MAILBOX_MESSAGE_DUMMY_VALUE_H		(0xDEAD)
#define FW_RX_HANDLER_MAILBOX_MESSAGE_DUMMY_VALUE_L		(0xDEAD)
	
	
	
#endif //RX_HANDLER_MAILBOX_API_H


