/************************************************************************************
*
*	File:			TxSender_AtfApi.h
*
*	Description:	This is Sender-FW ATF API shared file.

*
*	COPYRIGHT:
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef TX_SENDER_ATF_API_H
#define TX_SENDER_ATF_API_H


#define ATF_NUM_OF_ENTRIES									(256)
#define ATF_STRUCTURE_FIELD_PER_STA_AC_2_MASK               (0x00FF)
#define ATF_STRUCTURE_FIELD_PER_STA_AC_MASK_L               (0xFF00)
#define ATF_SET_ALL_TO_HIGH                                 (0xFFFF)
#define ATF_DYNAMIC_DIST_NUM_OF_BYTES_GRANT_PER_AC          (8)

#define ATF_DYNAMIC_DIST_NUM_OF_BITS_GRANT_PER_AC           (8)
#define ATF_DYNAMIC_DIST_NUM_OF_BYTES_ALL_GRANTS			(4)

#define ATF_DYNAMIC_DIST_RES_DECREASE_BITS_GRANT            (7)
															 	
#define ATF_DIST_TYPE_DISABLED                              (0)
#define ATF_DIST_TYPE_DYNAMIC                               (1)
#define ATF_DIST_TYPE_STATIC                                (2)

#if defined (CPU_MIPS) || defined (CPU_ARC)
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ieee80211.h"
#include "ConfigurationManager_api.h"

#if (ATF_NUM_OF_ENTRIES != HW_NUM_OF_STATIONS)
#error "Sender definitions are not equal to platform definitions"
#endif

typedef struct AtfShramDb_s
{
	uint8   maxGrant[HW_NUM_OF_STATIONS][ACCESS_CATEGORY_NUM]; 
	uint8   currGrant[HW_NUM_OF_STATIONS][ACCESS_CATEGORY_NUM];
	uint32  atfDistType[NUM_OF_CONFIGURATION_MANAGER_BANDS]; // Air Time fairness disable = 0 / dynamic = 1 / static = 2
} AtfShramDb_t; // General allocation

typedef struct AtfShramDbDynamic_s
{
	uint8   maxGrant[HW_NUM_OF_STATIONS][ACCESS_CATEGORY_NUM];  // us >> 7 (32 ms is maximum value in txop time dynamic mode so represantion is 255)
	uint8   currGrant[HW_NUM_OF_STATIONS][ACCESS_CATEGORY_NUM]; // us >> 7
	uint32  atfDistType[NUM_OF_CONFIGURATION_MANAGER_BANDS]; // Air Time fairness disable = 0 / dynamic = 1 / static = 2
} AtfShramDbDynamic_t; // Dynamic use

typedef struct AtfShramDbStatic_s
{
	uint32   maxGrant[HW_NUM_OF_STATIONS];  // us  (no maximum txop limit)
	uint32   currGrant[HW_NUM_OF_STATIONS]; // us  (no maximum txop limit)
	uint32   atfDistType[NUM_OF_CONFIGURATION_MANAGER_BANDS]; // Air Time fairness disable = 0 / dynamic = 1 / static = 2
} AtfShramDbStatic_t; // static use


#endif /* CPU_MIPS*/


/*ATF per STA structure*/
#define ATF_STRUCTURE_FIELD_MAX_GRANT_WORD_OFFSET_START                     (0x0)

#define ATF_STRUCTURE_FIELD_MAX_GRANT_NUM_OF_ENTRIES                        (ATF_NUM_OF_ENTRIES)

#define ATF_STRUCTURE_FIELD_CURRENT_GRANT_WORD_OFFSET_START                 (ATF_STRUCTURE_FIELD_MAX_GRANT_WORD_OFFSET_START + ATF_STRUCTURE_FIELD_MAX_GRANT_NUM_OF_ENTRIES)

#define ATF_STRUCTURE_FIELD_CURRENT_GRANT_NUM_OF_ENTRIES                    (ATF_NUM_OF_ENTRIES)


#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_WORD_OFFSET_BAND_0            (ATF_STRUCTURE_FIELD_CURRENT_GRANT_WORD_OFFSET_START + ATF_STRUCTURE_FIELD_CURRENT_GRANT_NUM_OF_ENTRIES)
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_WORD_OFFSET_BAND_1            (ATF_STRUCTURE_FIELD_CURRENT_GRANT_WORD_OFFSET_START + ATF_STRUCTURE_FIELD_CURRENT_GRANT_NUM_OF_ENTRIES + 0x1)
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_START_BIT                     0x0
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_NUMBER_OF_BITS                0x20
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_MASK_H                        0xFFFF
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_MASK_L                        0xFFFF
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_VALUE_DISABLE					0x0
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_VALUE_DYNAMIC                 0x1
#define ATF_STRUCTURE_FIELD_DISTRIBUTION_TYPE_VALUE_STATIC                  0x2


#endif //TX_SENDER_ATF_API_H
