/************************************************************************************
*		
*	File:			TxSender_InitApi.h
*	
*	Description:	This is Sender-FW Init API shared file. 
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef TX_SENDER_INIT_API_H
#define TX_SENDER_INIT_API_H


#define TX_SENDER_INIT_FIELD_CHI_MAGIC_READY_VALUE_H		(0xCAFEu)
#define TX_SENDER_INIT_FIELD_CHI_MAGIC_READY_VALUE_L		(0xCAFEu)

/*
	When FW writes init vector, chi magic is 0x0
	After Tx Sender finish parsing init vector, 
	FW expects it to override chi magic with 0xCAFECAFE
*/

#define TX_SENDER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_H		(0xFFFF)
#define TX_SENDER_INIT_NOT_VALID_INPUT_EXPECTED_VALUE_L		(0xFFFF)


/*TCR Templates ID*/
#define TCR_TEMPLATE_ID_NOT_SOUNDING_COMMON					(0x0) //for RTS, CTS2Self, CF-END, NDPA, BAR, BF Report Poll (both 2.4G and 5G)
#define TCR_TEMPLATE_ID_MAC_HT_NDP_ANNOUNCEMENT				(0x1)
#define TCR_TEMPLATE_ID_HT_PHY_NDP							(0x2)
#define TCR_TEMPLATE_ID_VHT_PHY_NDP							(0x3)
#define TCR_TEMPLATE_ID_HE_PHY_NDP							(0x4)


#endif //TX_SENDER_INIT_API_H
