/************************************************************************************
*		
*	File:			RxHandler_ScratchPadApi.h
*	
*	Description:	This is RxHandler-FW SCRATCHPAD API shared file. 
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef RX_HANDLER_SCRATCHPAD_API_H
#define RX_HANDLER_SCRATCHPAD_API_H


#ifdef CPU_ARC
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RxMsduDesc_Descriptors.h"


/* define RxMsduDescCommon_t size in words - the genrisc uses get this value from the autogenerated file RxMsduDesc_Descriptors.h */
#define RX_MSDU_DESC_SECTION_COMMON_SIZE_IN_WORDS		CONVERT_BYTES_TO_WORDS(sizeof(RxMsduDescCommon_t))
#endif /* CPU_ARC */

//--------------------------------------
// The Following is the RTD structure
//--------------------------------------

#define SCPAD_BASE_ADDRESS																	(0x0)
#define SCPAD_TOTAL_SIZE																	(0x400)

#define SCPAD_ADDRESS_RXH_RING_BASE_ADDRESS													(SCPAD_BASE_ADDRESS)

// SCPAD_ADDRESS_LOCAL_SCPAD_START, SCPAD_ADDRESS_RX_HANDLER_API_STRUCT_START & SCPAD_ADDRESS_RX_HANDLER_API_STRUCT_START are the same address
#define SCPAD_ADDRESS_LOCAL_SCPAD_START														(SCPAD_ADDRESS_RXH_RING_BASE_ADDRESS + (MSDU_DESC_NUMBER_OF_ENTRIES * RX_MSDU_DESC_SECTION_COMMON_SIZE_IN_WORDS))

#define SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START								(SCPAD_ADDRESS_LOCAL_SCPAD_START)

#define SCPAD_ADDRESS_RX_HANDLER_API_STRUCT_START											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START)
//---------------------------------------------------
// The Following are Rxh's API structure fields
//---------------------------------------------------
#define SCPAD_ADDRESS_RX_HANDLER_STATE														(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x00)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_PARSED_MSDU										(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x01)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_MPDU_POST_PPDU							(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x02)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_DATA_PACKET								(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x03)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_MNGMT_TO_HOST_PACKET						(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x04)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_MNGMT_TO_FW_PACKET						(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x05)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_ACTION_FRAME								(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x06)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_DROP_PACKET								(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x07)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_HANDLED_NDP_PACKET								(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x08)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_PACKETS_WITH_VALID_METRICS						(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x09)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_PACKETS_WITH_ERROR								(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x0A)
#define SCPAD_ADDRESS_RX_HANDLER_NUMBER_OF_A_MSDU_PACKETS									(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x0B)
#define SCPAD_ADDRESS_RX_HANDLER_ERROR_LAST_FILE_ID											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x0C)
#define SCPAD_ADDRESS_RX_HANDLER_ERROR_LAST_LINE											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x0D)
#define SCPAD_ADDRESS_RX_HANDLER_ERROR_IS_ABORT_BEFORE_ASSERT								(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x0E)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R0											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x0F)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R1											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x10)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R2											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x11)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R3											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x12)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R4											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x13)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R5											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x14)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R6											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x15)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R7											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x16)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R8											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x17)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_R9											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x18)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_RA											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x19)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_RB											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x1A)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_RC											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x1B)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_RD											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x1C)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_RE											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x1D)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_STRUCT_RF											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x1E)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_0												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x1F)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_1												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x20)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_2												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x21)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_3												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x22)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_4												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x23)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_5												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x24)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_6												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x25)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_7												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x26)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_8												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x27)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_9												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x28)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_A												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x29)
#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_AAA_B												(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x2A)
#define SCPAD_ADDRESS_RX_HANDLER_MAX_DRV_DATA_RD_NUM										(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x2B)
#define SCPAD_ADDRESS_RX_HANDLER_MAX_DRV_MGMT_RD_NUM										(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x2C)
#define SCPAD_ADDRESS_RX_HANDLER_MAX_FW_MGMT_RD_NUM											(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x2D)
#define SCPAD_ADDRESS_RX_HANDLER_MINIMUM_RDS_IN_HOST_DATA_FREE_LIST							(SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCTURE_START + 0x2E)


#define SCPAD_ADDRESS_RX_HANDLER_DEBUG_API_STRUCT_SIZE										(0x2F)

/* save 12 consecutive words for Sniffer template (48 bytes) */ 
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TEMPLATE											(SCPAD_ADDRESS_RX_HANDLER_API_STRUCT_START + SCPAD_ADDRESS_RX_HANDLER_DEBUG_API_STRUCT_SIZE)
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TEMPLATE_SIZE										(48 >> 0x2)

#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_START										(SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TEMPLATE + SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TEMPLATE_SIZE)

#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_QUEUE_ID											(SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_START + 0x00)
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_IP_HEADER_IDENTIFICATION							(SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_START + 0x01)
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PRE_CALCULATED_CHECKSUM							(SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_START + 0x02)
#ifdef SNIFFER_MU_ENABLED
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TRIGGER_FRAME_SHRAM_PTR							(SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_START + 0x03)
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_SIZE										(0x4)

#else
#define SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_SIZE										(0x3)
#endif

/* save 64 consecutive words for secondary vap id mapping to station id (256 stations)*/ 
#define SCPAD_ADDRESS_RX_HANDLER_SECONDARY_VAP_ID_PER_STATION_TABLE							(SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_START + SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_SIZE)
#define SCPAD_ADDRESS_RX_HANDLER_SECONDARY_VAP_ID_PER_STATION_TABLE_SIZE					(256 >> 0x2)


#define SCPAD_ADDRESS_RX_HANDLER_SCRATCHPAD_API_STRUCT_SIZE									(SCPAD_ADDRESS_RX_HANDLER_DEBUG_API_STRUCT_SIZE + SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TEMPLATE_SIZE + SCPAD_ADDRESS_RX_HANDLER_SNIFFER_PARAMS_SIZE + SCPAD_ADDRESS_RX_HANDLER_SECONDARY_VAP_ID_PER_STATION_TABLE_SIZE)


#ifdef CPU_ARC

typedef struct _RxHandler_ScratchPadApiParams_t
{    
	uint32 state;
	uint32 number_of_parsed_msdu_descriptors;
	uint32 number_of_handled_mpdu_post_ppdu;
	uint32 number_of_handled_data_packet;
	uint32 number_of_handled_mngmt_to_host_packet;
	uint32 number_of_handled_mngmt_to_fw_packet;
	uint32 number_of_handled_action_frame;	
	uint32 number_of_handled_drop_packet;
	uint32 number_of_handled_ndp_packet;	
	uint32 number_of_packets_with_valid_metrics;
	uint32 number_of_packets_with_error;
	uint32 number_of_a_msdu_packets;
	uint32 error_last_file_id;
	uint32 error_last_line;
	uint32 error_is_abort_before_assert;
	uint32 debug_struct_r0;
	uint32 debug_struct_r1;
	uint32 debug_struct_r2;
	uint32 debug_struct_r3;
	uint32 debug_struct_r4;
	uint32 debug_struct_r5;
	uint32 debug_struct_r6;
	uint32 debug_struct_r7;
	uint32 debug_struct_r8;
	uint32 debug_struct_r9;
	uint32 debug_struct_ra;
	uint32 debug_struct_rb;
	uint32 debug_struct_rc;
	uint32 debug_struct_rd;
	uint32 debug_struct_re;
	uint32 debug_struct_rf;
	uint32 debug_aaa_0;
	uint32 debug_aaa_1;
	uint32 debug_aaa_2;
	uint32 debug_aaa_3;
	uint32 debug_aaa_4;
	uint32 debug_aaa_5;
	uint32 debug_aaa_6;
	uint32 debug_aaa_7;
	uint32 debug_aaa_8;
	uint32 debug_aaa_9;
	uint32 debug_aaa_a;
	uint32 debug_aaa_b;
	uint32 maxDriverDataRdNum;
	uint32 maxDriverMgmtRdNum;
	uint32 maxFwMgmtRdNum;
	uint32 minimumRdsInHostDataFreeList;
} RxHandler_ScratchPadApiParams_t;

typedef struct _RxHandler_ScratchPadSnifferApiParams_t
{
	uint32	snifferTemplate[SCPAD_ADDRESS_RX_HANDLER_SNIFFER_TEMPLATE_SIZE];
	uint32	snifferQueueId;
	uint32  snifferIpIdentification;
	uint32  snifferPreCalculatedChecksum;
#ifdef SNIFFER_MU_ENABLED	
	uint32  snifferTriggerFrameSharedPtr;
#endif
} RxHandler_ScratchPadSnifferApiParams_t;


typedef struct _RxHandler_ScratchPadSecondaryVapPerStationMapping_t
{
	uint32	stationSeconderyVap[SCPAD_ADDRESS_RX_HANDLER_SECONDARY_VAP_ID_PER_STATION_TABLE_SIZE];
} RxHandler_ScratchPadSecondaryVapPerStationMapping_t;

#endif /* CPU_ARC */

#endif //RX_HANDLER_SCRATCHPAD_API_H

