/************************************************************************************
*		
*	File:			RxHandler_SnifferApi.h
*	
*	Description:	This file contains the defines required for the sniffer code. 
*
*	COPYRIGHT: 
*		(C) Intel Israel.
*		All rights are strictly reserved. Reproduction or divulgence in any   
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Intel Israel
*
**************************************************************************************/
#ifndef RX_HANDLER_SNIFFER_API_H
#define RX_HANDLER_SNIFFER_API_H

#ifdef CPU_ARC
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "mhi_umi.h"
#endif //CPU_ARC


//-------- SNIFFER STRUCTURE FIELDS ------------

//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_0_FIELD_SW_PRE_CALC_CHECKSUM_WORD_OFFSET			0x0
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_0_FIELD_SW_PRE_CALC_CHECKSUM_START_BIT			0x0
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_0_FIELD_SW_PRE_CALC_CHECKSUM_NUMBER_OF_BITS		0x20
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_0_FIELD_SW_PRE_CALC_CHECKSUM_MASK_H				0xFFFF
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_0_FIELD_SW_PRE_CALC_CHECKSUM_MASK_L				0xFFFF
//
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_1_FIELD_IP_ID_WORD_OFFSET							0x1
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_1_FIELD_IP_ID_START_BIT							0x0
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_1_FIELD_IP_ID_NUMBER_OF_BITS						0x20
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_1_FIELD_IP_ID_MASK_H								0xFFFF
//#define FW_RX_HANDLER_SNIFFER_PARAMS_WORD_1_FIELD_IP_ID_MASK_L								0xFFFF
					
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_0_WORD_OFFSET				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_0_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_0_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_0_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_0_MASK_L					0xFFFF


#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_1_WORD_OFFSET				0x1
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_1_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_1_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_1_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_1_MASK_L					0xFFFF


#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_2_WORD_OFFSET				0x2
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_2_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_2_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_2_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_2_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_3_WORD_OFFSET				0x3
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_3_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_3_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_3_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_3_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_4_WORD_OFFSET				0x4
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_4_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_4_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_4_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_4_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_5_WORD_OFFSET				0x5
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_5_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_5_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_5_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_5_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_6_WORD_OFFSET				0x6
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_6_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_6_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_6_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_6_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_7_WORD_OFFSET				0x7
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_7_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_7_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_7_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_7_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_8_WORD_OFFSET				0x8
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_8_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_8_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_8_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_8_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_9_WORD_OFFSET				0x9
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_9_START_BIT				0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_9_NUMBER_OF_BITS			0x20
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_9_MASK_H					0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_9_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_UDP_CHECKSUM_WORD_OFFSET				0xA
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_UDP_CHECKSUM_START_BIT					0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_UDP_CHECKSUM_NUMBER_OF_BITS			0x10
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_UDP_CHECKSUM_MASK_H					0x0000
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_109_UDP_CHECKSUM_MASK_L					0xFFFF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_WATERMARK_WORD_OFFSET					0xA
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_WATERMARK_START_BIT					0x10
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_WATERMARK_NUMBER_OF_BITS				0x10
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_WATERMARK_MASK_H						0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_10_WATERMARK_MASK_L						0x0000

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RCB_BYTE_OFFSET_ALIGNMENT_WORD_OFFSET	   0xB
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RCB_BYTE_OFFSET_ALIGNMENT_START_BIT	   0x0
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RCB_BYTE_OFFSET_ALIGNMENT_NUMBER_OF_BITS  0x8
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RCB_BYTE_OFFSET_ALIGNMENT_MASK_H		   0x0000
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RCB_BYTE_OFFSET_ALIGNMENT_MASK_L		   0x00FF

#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RESERVED_WORD_OFFSET	  					0xB
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RESERVED_START_BIT	  	  					0x8
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RESERVED_NUMBER_OF_BITS   					0x18
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RESERVED_MASK_H		    				0xFFFF
#define FW_RX_HANDLER_SNIFFER_UDP_HEADER_WORD_11_RESERVED_MASK_L		    				0xFF00


#define FW_RX_HANDLER_SNIFFER_PARAMS_STRUCTURE_SIZE											(0xE << 0x2) //WORDS


//---------------------------------------------------------------------------------------------------------//


#endif //RX_HANDLER_SNIFFER_API_H

