/************************************************************************************
*		
*	File:			TxSender_TxSender_ScratchPadApi.h
*	
*	Description:	This is Sender-FW SCRATCHPAD API shared file. 
*
*	COPYRIGHT: 
*		(C) Lantiq Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any   
*		form whatsoever is not permitted without written authority from the 
*		copyright owner. Issued by Lantiq Israel Ltd
*
**************************************************************************************/
#ifndef TX_SENDER_SCRATCHPAD_API_H
#define TX_SENDER_SCRATCHPAD_API_H


#if defined (CPU_MIPS) || defined (CPU_ARC)
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"

typedef struct _TxSender_ScratchPadApiParams_t
{    
	uint32 state;
	uint32 error_last_file_id;
	uint32 error_last_line;
	uint32 error_is_abort_before_assert;
	uint32 number_of_zero_interrupts;
	uint32 debug_struct_r0;
	uint32 debug_struct_r1;
	uint32 debug_struct_r2;
	uint32 debug_struct_r3;
	uint32 debug_struct_r4;
	uint32 debug_struct_r5;
	uint32 debug_struct_r6;
	uint32 debug_struct_r7;
	uint32 debug_struct_r8;
	uint32 debug_struct_r9;
	uint32 debug_struct_ra;
	uint32 debug_struct_rb;
	uint32 debug_struct_rc;
	uint32 debug_struct_rd;
	uint32 debug_struct_re;
	uint32 debug_struct_rf;
	uint32 debug_aaa_0;
	uint32 debug_aaa_1;
	uint32 debug_aaa_2;
	uint32 debug_aaa_3;
	uint32 debug_aaa_4;
	uint32 debug_aaa_5;
	uint32 debug_aaa_6;
	uint32 debug_aaa_7;
	uint32 debug_aaa_8;
	uint32 debug_aaa_9;
	uint32 debug_aaa_a;
	uint32 debug_aaa_b;
	uint32 minimumMpduCountForTxop;
	uint32 numOfBeaconsTransmitted;
	uint32 maxDeltaBetweenMuSoundingSequences;
	uint32 forceMuSoundingSequencesPerGroup;
	uint32 muNumberOfActiveUspsPerGroup;
	uint32 deliaStatusError;
	uint32 enableTcrRcrLogs;
	uint32 numOfAllocatedAntennas;
	uint32 unSpecifiedDurationInHeSuUlBasicTriggerFrame;
} TxSender_ScratchPadApiParams_t;

#endif /* CPU_MIPS || CPU ARC*/


#define STD_ADDRESS_START																	(0x0)

#define SCPAD_BASE_ADDRESS																	(0x0)
#define SCPAD_TOTAL_SIZE																	(0x400)

#define SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START								(SCPAD_BASE_ADDRESS)

//---------------------------------------------------
// The Following are sender's API structure fields
//---------------------------------------------------
#define SCPAD_ADDRESS_TX_SENDER_STATE														(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x00)
#define SCPAD_ADDRESS_TX_SENDER_ERROR_LAST_FILE_ID											(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x01)
#define SCPAD_ADDRESS_TX_SENDER_ERROR_LAST_LINE												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x02)
#define SCPAD_ADDRESS_TX_SENDER_ERROR_IS_ABORT_BEFORE_ASSERT								(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x03)
#define SCPAD_ADDRESS_TX_SENDER_NUMBER_OF_ZERO_INTERRUPTS									(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x04)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R0												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x05)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R1												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x06)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R2												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x07)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R3												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x08)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R4												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x09)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R5												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x0A)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R6												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x0B)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R7												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x0C)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R8												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x0D)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_R9												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x0E)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_RA												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x0F)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_RB												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x10)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_RC												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x11)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_RD												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x12)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_RE												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x13)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_STRUCT_RF												(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x14)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_0													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x15)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_1													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x16)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_2													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x17)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_3													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x18)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_4													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x19)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_5													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x1A)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_6													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x1B)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_7													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x1C)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_8													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x1D)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_9													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x1E)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_A													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x1F)
#define SCPAD_ADDRESS_TX_SENDER_DEBUG_AAA_B													(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x20)
#define SCPAD_ADDRESS_TX_SENDER_MINIMUM_MPDU_COUNT_FOR_TXOP									(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x21)
#define SCPAD_ADDRESS_TX_SENDER_NUM_OF_BEACONS_TRANSMITTED									(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x22)
#define SCPAD_ADDRESS_TX_SENDER_MAX_DELTA_BETWEEN_MU_SOUNDING_SEQUENCES						(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x23)
#define SCPAD_ADDRESS_TX_SENDER_FORCE_MU_SOUNDING_SEQUENCES_PER_GROUP						(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x24)
#define SCPAD_ADDRESS_TX_SENDER_MU_NUMBER_OF_ACTIVE_USPS_PER_GROUP							(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x25)
#define SCPAD_ADDRESS_TX_SENDER_DELIA_TX_END_STATUS											(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x26)
#define SCPAD_ADDRESS_TX_SENDER_ENABLE_TCR_RCR_LOGS											(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x27)
#define SCPAD_ADDRESS_TX_SENDER_BAND1_NUM_OF_ALLOCATED_ANTENNAS								(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x28)
#define SCPAD_ADDRESS_TX_SENDER_UNSPECIFIED_DURATION_IN_HE_SU_UL_BASIC_TRIGGER_FRAME		(SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCTURE_START + 0x29)


#define SCPAD_ADDRESS_TX_SENDER_SCRATCHPAD_API_STRUCT_SIZE									(0x2A)


#define TX_HC_DONE_REPORT_ENTRIES															(0x80) //allocated space for 128 entries


#endif //TX_SENDER_SCRATCHPAD_API_H

