
/***********************************************************************************
File:				PhyTxtdAnt2Regs.h
Module:				phyTxtdAnt2
SOC Revision:		
Purpose:
Description:		This File was auto generated using SOC Online

************************************************************************************/
#ifndef _PHY_TXTD_ANT2_REGS_H_
#define _PHY_TXTD_ANT2_REGS_H_

/*---------------------------------------------------------------------------------
/						Registers Addresses													 
/----------------------------------------------------------------------------------*/
#include "HwMemoryMap.h"

#define PHY_TXTD_ANT2_BASE_ADDRESS                             MEMORY_MAP_UNIT_92_BASE_ADDRESS
#define	REG_PHY_TXTD_ANT2_TX_MODE_11B_EN                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x0)
#define	REG_PHY_TXTD_ANT2_TX_DPD                        (PHY_TXTD_ANT2_BASE_ADDRESS + 0x4)
#define	REG_PHY_TXTD_ANT2_TX_DC_OFFSET_0                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x8)
#define	REG_PHY_TXTD_ANT2_TX_DC_OFFSET_1                (PHY_TXTD_ANT2_BASE_ADDRESS + 0xC)
#define	REG_PHY_TXTD_ANT2_TX_DC_OFFSET_2                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x10)
#define	REG_PHY_TXTD_ANT2_TX_DC_OFFSET_3                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x14)
#define	REG_PHY_TXTD_ANT2_TXTD_TEST_PLUG_MUX_CONTROL    (PHY_TXTD_ANT2_BASE_ADDRESS + 0x18)
#define	REG_PHY_TXTD_ANT2_TX_ANT_RAM_RM                 (PHY_TXTD_ANT2_BASE_ADDRESS + 0x1C)
#define	REG_PHY_TXTD_ANT2_TXTD_ANT_SPARE                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x20)
#define	REG_PHY_TXTD_ANT2_TXTD_ANT_BYPASS_REG           (PHY_TXTD_ANT2_BASE_ADDRESS + 0x24)
#define	REG_PHY_TXTD_ANT2_TXTD_WINDOWING                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x28)
#define	REG_PHY_TXTD_ANT2_TXTD_DUP_SWAP_FLIP            (PHY_TXTD_ANT2_BASE_ADDRESS + 0x2C)
#define	REG_PHY_TXTD_ANT2_TXTD_MIX11B_FREQ_OFFSET       (PHY_TXTD_ANT2_BASE_ADDRESS + 0x30)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_0             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x34)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_1             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x38)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_2             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x3C)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_3             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x40)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_4             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x44)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_5             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x48)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_6             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x4C)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_7             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x50)
#define	REG_PHY_TXTD_ANT2_TXTD_MEM_GLOBAL_RM            (PHY_TXTD_ANT2_BASE_ADDRESS + 0x54)
#define	REG_PHY_TXTD_ANT2_TXTD_MEM_GLOBAL_TEST_MODE     (PHY_TXTD_ANT2_BASE_ADDRESS + 0x58)
#define	REG_PHY_TXTD_ANT2_TXTD_SPARE                    (PHY_TXTD_ANT2_BASE_ADDRESS + 0x5C)
#define	REG_PHY_TXTD_ANT2_TXTD_AFE_IDLE_I_DATA          (PHY_TXTD_ANT2_BASE_ADDRESS + 0x60)
#define	REG_PHY_TXTD_ANT2_TXTD_AFE_IDLE_Q_DATA          (PHY_TXTD_ANT2_BASE_ADDRESS + 0x64)
#define	REG_PHY_TXTD_ANT2_TXTD_BIST                     (PHY_TXTD_ANT2_BASE_ADDRESS + 0x68)
#define	REG_PHY_TXTD_ANT2_TX_IQ_RIPPLE                  (PHY_TXTD_ANT2_BASE_ADDRESS + 0x6C)
#define	REG_PHY_TXTD_ANT2_TXTD_IFFT_IN_OUT_SHIFT        (PHY_TXTD_ANT2_BASE_ADDRESS + 0x70)
#define	REG_PHY_TXTD_ANT2_TXTD_END_ZEROS                (PHY_TXTD_ANT2_BASE_ADDRESS + 0x74)
#define	REG_PHY_TXTD_ANT2_TX_ABB_30                     (PHY_TXTD_ANT2_BASE_ADDRESS + 0x78)
#define	REG_PHY_TXTD_ANT2_TX_ANT_REG_31                 (PHY_TXTD_ANT2_BASE_ADDRESS + 0x7C)
#define	REG_PHY_TXTD_ANT2_TX_BF_CAL_GAIN_INDEX_ANT      (PHY_TXTD_ANT2_BASE_ADDRESS + 0x80)
#define	REG_PHY_TXTD_ANT2_TPC_ANT_RAM                   (PHY_TXTD_ANT2_BASE_ADDRESS + 0x84)
#define	REG_PHY_TXTD_ANT2_TPC_ACCELERATOR               (PHY_TXTD_ANT2_BASE_ADDRESS + 0x88)
#define	REG_PHY_TXTD_ANT2_TPC_TSSI_A_B                  (PHY_TXTD_ANT2_BASE_ADDRESS + 0x8C)
#define	REG_PHY_TXTD_ANT2_TPC_TSSI_C                    (PHY_TXTD_ANT2_BASE_ADDRESS + 0x90)
#define	REG_PHY_TXTD_ANT2_TPC_SHORT                     (PHY_TXTD_ANT2_BASE_ADDRESS + 0x94)
#define	REG_PHY_TXTD_ANT2_RF_POWER                      (PHY_TXTD_ANT2_BASE_ADDRESS + 0x98)
#define	REG_PHY_TXTD_ANT2_TX_DIGITAL_GAIN               (PHY_TXTD_ANT2_BASE_ADDRESS + 0x9C)
#define	REG_PHY_TXTD_ANT2_TX_PGC2_GAIN_SELECT_OUT       (PHY_TXTD_ANT2_BASE_ADDRESS + 0xA0)
#define	REG_PHY_TXTD_ANT2_RF_POWER_OFFSET               (PHY_TXTD_ANT2_BASE_ADDRESS + 0xA4)
#define	REG_PHY_TXTD_ANT2_TXTD_11B_IQ_0                 (PHY_TXTD_ANT2_BASE_ADDRESS + 0xA8)
#define	REG_PHY_TXTD_ANT2_TXTD_11B_IQ_1                 (PHY_TXTD_ANT2_BASE_ADDRESS + 0xAC)
#define	REG_PHY_TXTD_ANT2_STREAMER                      (PHY_TXTD_ANT2_BASE_ADDRESS + 0xB0)
#define	REG_PHY_TXTD_ANT2_TEST_PLUG_LEN                 (PHY_TXTD_ANT2_BASE_ADDRESS + 0xB4)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS_COEFF_0              (PHY_TXTD_ANT2_BASE_ADDRESS + 0xB8)
#define	REG_PHY_TXTD_ANT2_TXTD_UPS_COEFF_2              (PHY_TXTD_ANT2_BASE_ADDRESS + 0xBC)
#define	REG_PHY_TXTD_ANT2_TXTD_UPSRF_COEFF_0            (PHY_TXTD_ANT2_BASE_ADDRESS + 0xC0)
#define	REG_PHY_TXTD_ANT2_PM_ANALOG_LPBK_EN             (PHY_TXTD_ANT2_BASE_ADDRESS + 0xC4)
#define	REG_PHY_TXTD_ANT2_TXTD_GCLK_EN                  (PHY_TXTD_ANT2_BASE_ADDRESS + 0xC8)
#define	REG_PHY_TXTD_ANT2_TONE_GEN_BW                   (PHY_TXTD_ANT2_BASE_ADDRESS + 0xCC)
#define	REG_PHY_TXTD_ANT2_TX_SC2FC_TXON                 (PHY_TXTD_ANT2_BASE_ADDRESS + 0xD0)
#define	REG_PHY_TXTD_ANT2_TXTD_BYPASS_SEL               (PHY_TXTD_ANT2_BASE_ADDRESS + 0xD4)
#define	REG_PHY_TXTD_ANT2_TX_PPM_FREQ_IN_CFG            (PHY_TXTD_ANT2_BASE_ADDRESS + 0xD8)
#define	REG_PHY_TXTD_ANT2_TX_PM_FDL_NCO_UP_LIM_CFG      (PHY_TXTD_ANT2_BASE_ADDRESS + 0xE0)
#define	REG_PHY_TXTD_ANT2_TX_PM_FDL_NCO_INCR_MAX_CFG    (PHY_TXTD_ANT2_BASE_ADDRESS + 0xE4)
#define	REG_PHY_TXTD_ANT2_TX_PM_FDL_NCO_INCR_CFG        (PHY_TXTD_ANT2_BASE_ADDRESS + 0xE8)
#define	REG_PHY_TXTD_ANT2_PM_DPD_CFG_SEL_DPD_PHY_I      (PHY_TXTD_ANT2_BASE_ADDRESS + 0xEC)
#define	REG_PHY_TXTD_ANT2_PM_DPD_STATUS_DBG_RDY_O       (PHY_TXTD_ANT2_BASE_ADDRESS + 0xF0)
#define	REG_PHY_TXTD_ANT2_PM_DPD_DBG_CTL_RUN_I          (PHY_TXTD_ANT2_BASE_ADDRESS + 0xF4)
#define	REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_0            (PHY_TXTD_ANT2_BASE_ADDRESS + 0xF8)
#define	REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_1            (PHY_TXTD_ANT2_BASE_ADDRESS + 0xFC)
#define	REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_2            (PHY_TXTD_ANT2_BASE_ADDRESS + 0x100)
#define	REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_3            (PHY_TXTD_ANT2_BASE_ADDRESS + 0x104)
#define	REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_4            (PHY_TXTD_ANT2_BASE_ADDRESS + 0x108)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_0             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x10C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_1             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x110)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_2             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x114)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_3             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x118)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_4             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x11C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_5             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x120)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_6             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x124)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_7             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x128)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_8             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x12C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_0             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x130)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_1             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x134)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_2             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x138)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_3             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x13C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_4             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x140)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_5             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x144)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_6             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x148)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_7             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x14C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_8             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x150)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_0             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x154)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_1             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x158)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_2             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x15C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_3             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x160)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_4             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x164)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_5             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x168)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_6             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x16C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_7             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x170)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_8             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x174)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_0             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x178)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_1             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x17C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_2             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x180)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_3             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x184)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_4             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x188)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_5             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x18C)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_6             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x190)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_7             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x194)
#define	REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_8             (PHY_TXTD_ANT2_BASE_ADDRESS + 0x198)
/*---------------------------------------------------------------------------------
/						Data Type Definition										
/----------------------------------------------------------------------------------*/
/*REG_PHY_TXTD_ANT2_TX_MODE_11B_EN 0x0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmMode11BEn : 1; //Enable TX 11B Antenna , reset value: 0x1, access type: RW
		uint32 reserved0 : 31;
	} bitFields;
} RegPhyTxtdAnt2TxMode11BEn_u;

/*REG_PHY_TXTD_ANT2_TX_DPD 0x4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdGain : 7; //dpd_gain, reset value: 0x0, access type: RW
		uint32 reserved0 : 1;
		uint32 pmDpdScale : 2; //dpd_scale, reset value: 0x0, access type: RW
		uint32 pmDpdBypass : 1; //pm_dpd_bypass, reset value: 0x1, access type: RW
		uint32 reserved1 : 21;
	} bitFields;
} RegPhyTxtdAnt2TxDpd_u;

/*REG_PHY_TXTD_ANT2_TX_DC_OFFSET_0 0x8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAfeOffsetI0 : 12; //pm_afe_offset_i0, reset value: 0x0, access type: RW
		uint32 reserved0 : 4;
		uint32 pmAfeOffsetQ0 : 12; //pm_afe_offset_q0, reset value: 0x0, access type: RW
		uint32 reserved1 : 4;
	} bitFields;
} RegPhyTxtdAnt2TxDcOffset0_u;

/*REG_PHY_TXTD_ANT2_TX_DC_OFFSET_1 0xC */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAfeOffsetQ1 : 12; //AFE DC Offset Q0, reset value: 0x0, access type: RW
		uint32 reserved0 : 4;
		uint32 pmAfeOffsetI1 : 12; //AFE DC Offset I0, reset value: 0x0, access type: RW
		uint32 reserved1 : 4;
	} bitFields;
} RegPhyTxtdAnt2TxDcOffset1_u;

/*REG_PHY_TXTD_ANT2_TX_DC_OFFSET_2 0x10 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAfeOffsetQ2 : 12; //AFE DC Offset Q1, reset value: 0x0, access type: RW
		uint32 reserved0 : 4;
		uint32 pmAfeOffsetI2 : 12; //AFE DC Offset I1, reset value: 0x0, access type: RW
		uint32 reserved1 : 4;
	} bitFields;
} RegPhyTxtdAnt2TxDcOffset2_u;

/*REG_PHY_TXTD_ANT2_TX_DC_OFFSET_3 0x14 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAfeOffsetQ3 : 12; //AFE DC Offset Q2, reset value: 0x0, access type: RW
		uint32 reserved0 : 4;
		uint32 pmAfeOffsetI3 : 12; //AFE DC Offset I2, reset value: 0x0, access type: RW
		uint32 reserved1 : 4;
	} bitFields;
} RegPhyTxtdAnt2TxDcOffset3_u;

/*REG_PHY_TXTD_ANT2_TXTD_TEST_PLUG_MUX_CONTROL 0x18 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxtdTestPlugMuxControl : 3; //Tx TD Test Plug Mux Control, reset value: 0x0, access type: RW
		uint32 reserved0 : 29;
	} bitFields;
} RegPhyTxtdAnt2TxtdTestPlugMuxControl_u;

/*REG_PHY_TXTD_ANT2_TX_ANT_RAM_RM 0x1C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxwinRamRm : 3; //txwin_ram_rm, reset value: 0x3, access type: RW
		uint32 pmDpdRamRm : 3; //dpd_ram_rm, reset value: 0x3, access type: RW
		uint32 pmRippleRamRm : 3; //ripple_ram_rm, reset value: 0x3, access type: RW
		uint32 pmIqRamRm : 3; //iq_ram_rm, reset value: 0x3, access type: RW
		uint32 reserved0 : 20;
	} bitFields;
} RegPhyTxtdAnt2TxAntRamRm_u;

/*REG_PHY_TXTD_ANT2_TXTD_ANT_SPARE 0x20 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxtdAntSpare : 32; //Spare register, reset value: 0x0, access type: RW
	} bitFields;
} RegPhyTxtdAnt2TxtdAntSpare_u;

/*REG_PHY_TXTD_ANT2_TXTD_ANT_BYPASS_REG 0x24 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUpsBypass : 1; //UPS 640MHz Up Sampler Bypass, reset value: 0x0, access type: RW
		uint32 reserved0 : 1;
		uint32 pmUpsrfBypass : 1; //pm_upsrf_bypass, reset value: 0x0, access type: RW
		uint32 pmNoishBypass : 1; //pm_noish_bypass, reset value: 0x0, access type: RW
		uint32 reserved1 : 28;
	} bitFields;
} RegPhyTxtdAnt2TxtdAntBypassReg_u;

/*REG_PHY_TXTD_ANT2_TXTD_WINDOWING 0x28 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxwinTailDis : 1; //Disable TX window last Roll Off, reset value: 0x0, access type: RW
		uint32 pmTxwinEn : 1; //pm_txwin_en, reset value: 0x1, access type: RW
		uint32 pmCddOffsetEn : 1; //pm_cdd_offset_en, reset value: 0x1, access type: RW
		uint32 pmTxwinCp4 : 3; //pm_txwin_cp_4, reset value: 0x1, access type: RW
		uint32 pmTxwinCp8Ss : 3; //pm_txwin_cp_8_ss, reset value: 0x1, access type: RW
		uint32 pmTxwinCp8Ls : 3; //pm_txwin_cp_8_ls, reset value: 0x1, access type: RW
		uint32 pmTxwinCp16 : 3; //pm_txwin_cp_16, reset value: 0x1, access type: RW
		uint32 pmTxwinCp32 : 3; //pm_txwin_cp_32, reset value: 0x1, access type: RW
		uint32 reserved0 : 14;
	} bitFields;
} RegPhyTxtdAnt2TxtdWindowing_u;

/*REG_PHY_TXTD_ANT2_TXTD_DUP_SWAP_FLIP 0x2C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxDuplicateI : 1; //Enable CDD offset, reset value: 0x0, access type: RW
		uint32 pmTxDuplicateQ : 1; //pm_tx_duplicate_q, reset value: 0x0, access type: RW
		uint32 pmTxFlipI : 1; //pm_tx_flip_i, reset value: 0x0, access type: RW
		uint32 pmTxFlipQ : 1; //pm_tx_flip_q, reset value: 0x0, access type: RW
		uint32 pmTxIqSwap : 1; //pm_tx_iq_swap, reset value: 0x0, access type: RW
		uint32 reserved0 : 27;
	} bitFields;
} RegPhyTxtdAnt2TxtdDupSwapFlip_u;

/*REG_PHY_TXTD_ANT2_TXTD_MIX11B_FREQ_OFFSET 0x30 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmMix11BFreqOffset : 3; //11B Mixer Frequency shift: , 0: 0 , 1: +10MHz , 2: +30MHz , 3: -10MHz , 4: -30MHz, reset value: 0x0, access type: RW
		uint32 reserved0 : 29;
	} bitFields;
} RegPhyTxtdAnt2TxtdMix11BFreqOffset_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_0 0x34 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff0 : 24; //UPS8 coeff 0 of 8 x 24 bit , reset value: 0x34697F, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff0_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_1 0x38 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff1 : 24; //UPS8 coeff 1 of 8 x 24 bit , reset value: 0xB4719D, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff1_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_2 0x3C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff2 : 24; //UPS8 coeff 2 of 8 x 24 bit , reset value: 0x4F66FD, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff2_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_3 0x40 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff3 : 24; //UPS8 coeff 3 of 8 x 24 bit , reset value: 0xC4218D, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff3_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_4 0x44 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff4 : 24; //UPS8 coeff 4 of 8 x 24 bit , reset value: 0x6BE5FB, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff4_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_5 0x48 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff5 : 24; //UPS8 coeff 5 of 8 x 24 bit , reset value: 0xD5E36E, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff5_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_6 0x4C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff6 : 24; //UPS8 coeff 6 of 8 x 24 bit , reset value: 0x886877, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff6_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS8_COEFF_7 0x50 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUps8Coeff7 : 24; //UPS8 coeff 7 of 8 x 24 bit , reset value: 0xE3B943, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdUps8Coeff7_u;

/*REG_PHY_TXTD_ANT2_TXTD_MEM_GLOBAL_RM 0x54 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmMemGlobalRm : 2; //Global RM value for rams, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2TxtdMemGlobalRm_u;

/*REG_PHY_TXTD_ANT2_TXTD_MEM_GLOBAL_TEST_MODE 0x58 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmMemGlobalTestMode : 2; //Global test mode for rams, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2TxtdMemGlobalTestMode_u;

/*REG_PHY_TXTD_ANT2_TXTD_SPARE 0x5C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxtdSpare : 32; //Spare register, reset value: 0x0, access type: RW
	} bitFields;
} RegPhyTxtdAnt2TxtdSpare_u;

/*REG_PHY_TXTD_ANT2_TXTD_AFE_IDLE_I_DATA 0x60 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAfeIdleIData : 24; //AFE idle I data, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdAfeIdleIData_u;

/*REG_PHY_TXTD_ANT2_TXTD_AFE_IDLE_Q_DATA 0x64 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAfeIdleQData : 24; //AFE idle Q data, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2TxtdAfeIdleQData_u;

/*REG_PHY_TXTD_ANT2_TXTD_BIST 0x68 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmSwBistStart : 1; //sw_bist_start, reset value: 0x0, access type: RW
		uint32 pmClearRamMode : 1; //clear_ram_mode, reset value: 0x0, access type: RW
		uint32 pmBistScrBypass : 1; //bist_scr_bypass, reset value: 0x0, access type: RW
		uint32 reserved0 : 29;
	} bitFields;
} RegPhyTxtdAnt2TxtdBist_u;

/*REG_PHY_TXTD_ANT2_TX_IQ_RIPPLE 0x6C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmIqEquBypass : 1; //iq_equ_bypass, reset value: 0x0, access type: RW
		uint32 pmRippleEquBypass : 1; //ripple_equ_bypass, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2TxIqRipple_u;

/*REG_PHY_TXTD_ANT2_TXTD_IFFT_IN_OUT_SHIFT 0x70 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmIfftInShift20 : 2; //ifft shift in for bw 20, reset value: 0x2, access type: RW
		uint32 pmIfftInShift40 : 2; //ifft shift in for bw 40, reset value: 0x1, access type: RW
		uint32 pmIfftInShift80 : 2; //ifft shift in for bw 80, reset value: 0x0, access type: RW
		uint32 pmIfftInShift160 : 2; //ifft shift in for bw 160, reset value: 0x0, access type: RW
		uint32 pmIfftOutShift20 : 3; //ifft shift out for bw 20, reset value: 0x0, access type: RW
		uint32 pmIfftOutShift40 : 3; //ifft shift out for bw 40, reset value: 0x0, access type: RW
		uint32 pmIfftOutShift80 : 3; //ifft shift out for bw 80, reset value: 0x1, access type: RW
		uint32 pmIfftOutShift160 : 3; //ifft shift out for bw 160, reset value: 0x1, access type: RW
		uint32 pmIfftInShiftToneGen : 2; //pm_ifft_in_shift_tone_gen, reset value: 0x2, access type: RW
		uint32 pmIfftOutShiftToneGen : 3; //pm_ifft_out_shift_tone_gen, reset value: 0x6, access type: RW
		uint32 reserved0 : 7;
	} bitFields;
} RegPhyTxtdAnt2TxtdIfftInOutShift_u;

/*REG_PHY_TXTD_ANT2_TXTD_END_ZEROS 0x74 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmEndZeros : 8; //pm_end_zeros �, reset value: 0x96, access type: RW
		uint32 reserved0 : 24;
	} bitFields;
} RegPhyTxtdAnt2TxtdEndZeros_u;

/*REG_PHY_TXTD_ANT2_TX_ABB_30 0x78 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txSc2FcPhaseRegfile : 2; //tx_sc2fc_phase_regfile, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2TxAbb30_u;

/*REG_PHY_TXTD_ANT2_TX_ANT_REG_31 0x7C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txRippleInSsbMode : 1; //tx_ripple_in_ssb_mode, reset value: 0x0, access type: RW
		uint32 reserved0 : 3;
		uint32 txUseSecRippleInHbMode : 1; //tx_use_sec_ripple_in_hb_mode, reset value: 0x0, access type: RW
		uint32 reserved1 : 27;
	} bitFields;
} RegPhyTxtdAnt2TxAntReg31_u;

/*REG_PHY_TXTD_ANT2_TX_BF_CAL_GAIN_INDEX_ANT 0x80 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 bfCalGainIndexAnt : 3; //bf_cal_gain_index_ant, reset value: 0x0, access type: RW
		uint32 reserved0 : 1;
		uint32 bfCalRm : 3; //bf_cal_rm, reset value: 0x3, access type: RW
		uint32 reserved1 : 25;
	} bitFields;
} RegPhyTxtdAnt2TxBfCalGainIndexAnt_u;

/*REG_PHY_TXTD_ANT2_TPC_ANT_RAM 0x84 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 tpcRamRm : 3; //tpc_ram_rm, reset value: 0x3, access type: RW
		uint32 reserved0 : 29;
	} bitFields;
} RegPhyTxtdAnt2TpcAntRam_u;

/*REG_PHY_TXTD_ANT2_TPC_ACCELERATOR 0x88 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 tpcaccenable : 1; //tpcaccenable, reset value: 0x0, access type: RW
		uint32 txTpcAccDone : 1; //tx_tpc_acc_done, reset value: 0x0, access type: RO
		uint32 pmTxPgc2GainSelect : 2; //pm_tx_pgc2_gain_select, reset value: 0x0, access type: RW
		uint32 tpcBoostEnMask : 1; //tpc_boost_en_mask, reset value: 0x0, access type: RW
		uint32 txDigitalGainOut : 9; //tx_digital_gain_out, reset value: 0x0, access type: RO
		uint32 reserved0 : 1;
		uint32 pmTxPgc2GainOverride : 1; //pm_tx_pgc2_gain_override, reset value: 0x0, access type: RW
		uint32 tpcGainIndexAnt : 8; //tpc_gain_index_ant, reset value: 0x0, access type: RO
		uint32 phyTxPowerAntLimit : 7; //phy_tx_power_ant_limit, reset value: 0x0, access type: RO
		uint32 tssiOpenLoopEn : 1; //tssi_open_loop_en, reset value: 0x0, access type: RW
	} bitFields;
} RegPhyTxtdAnt2TpcAccelerator_u;

/*REG_PHY_TXTD_ANT2_TPC_TSSI_A_B 0x8C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txTssiA : 16; //tx_tssi_A, reset value: 0x0, access type: RO
		uint32 txTssiB : 16; //tx_tssi_B, reset value: 0x0, access type: RO
	} bitFields;
} RegPhyTxtdAnt2TpcTssiAB_u;

/*REG_PHY_TXTD_ANT2_TPC_TSSI_C 0x90 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txTssiC : 16; //tx_tssi_C, reset value: 0x0, access type: RO
		uint32 reserved0 : 16;
	} bitFields;
} RegPhyTxtdAnt2TpcTssiC_u;

/*REG_PHY_TXTD_ANT2_TPC_SHORT 0x94 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txPgcGain : 2; //tx_pgc_gain, reset value: 0x0, access type: RO
		uint32 txPaDrv : 4; //tx_pa_drv, reset value: 0x0, access type: RO
		uint32 reserved0 : 1;
		uint32 txS2DIndex : 2; //tx_S2D_index, reset value: 0x0, access type: RO
		uint32 txFectl : 6; //tx_fectl, reset value: 0x0, access type: RW
		uint32 txRfOn : 1; //tx_rf_on, reset value: 0x0, access type: RO
		uint32 reserved1 : 16;
	} bitFields;
} RegPhyTxtdAnt2TpcShort_u;

/*REG_PHY_TXTD_ANT2_RF_POWER 0x98 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 tcrRfPower : 8; //tcr_rf_power, reset value: 0x0, access type: RO
		uint32 tcrPhyPowerBoost : 2; //tcr_phy_power_boost, reset value: 0x0, access type: RO
		uint32 reserved0 : 6;
		uint32 phyTxPowerAntBoost : 9; //tx_power from tcr + boost factor, reset value: 0x0, access type: RO
		uint32 reserved1 : 7;
	} bitFields;
} RegPhyTxtdAnt2RfPower_u;

/*REG_PHY_TXTD_ANT2_TX_DIGITAL_GAIN 0x9C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxDigitalGain : 9; //pm_tx_digital_gain, reset value: 0x143, access type: RW
		uint32 pmTxGainEn : 1; //pm_tx_gain_en, reset value: 0x1, access type: RW
		uint32 reserved0 : 22;
	} bitFields;
} RegPhyTxtdAnt2TxDigitalGain_u;

/*REG_PHY_TXTD_ANT2_TX_PGC2_GAIN_SELECT_OUT 0xA0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txPgc2GainSelectOut : 2; //tx_pgc2_gain_select_out, reset value: 0x0, access type: RO
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2TxPgc2GainSelectOut_u;

/*REG_PHY_TXTD_ANT2_RF_POWER_OFFSET 0xA4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 rfPowerOffset20 : 7; //rf_power_offset_20, reset value: 0x0, access type: RW
		uint32 reserved0 : 1;
		uint32 rfPowerOffset40 : 7; //rf_power_offset_40, reset value: 0x0, access type: RW
		uint32 reserved1 : 1;
		uint32 rfPowerOffset80 : 7; //rf_power_offset_80, reset value: 0x0, access type: RW
		uint32 reserved2 : 1;
		uint32 rfPowerOffset16011B : 7; //rf_power_offset_160_11b, reset value: 0x0, access type: RW
		uint32 reserved3 : 1;
	} bitFields;
} RegPhyTxtdAnt2RfPowerOffset_u;

/*REG_PHY_TXTD_ANT2_TXTD_11B_IQ_0 0xA8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxIqTdF1 : 10; //pm_tx_iq_td_f1, reset value: 0x0, access type: RW
		uint32 pmTxIqTdF2 : 10; //pm_tx_iq_td_f2, reset value: 0x0, access type: RW
		uint32 pmTxIqTdF3 : 10; //pm_tx_iq_td_f3, reset value: 0x0, access type: RW
		uint32 pmTxIqTdEn : 1; //pm_tx_iq_td_en, reset value: 0x0, access type: RW
		uint32 reserved0 : 1;
	} bitFields;
} RegPhyTxtdAnt2Txtd11BIq0_u;

/*REG_PHY_TXTD_ANT2_TXTD_11B_IQ_1 0xAC */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxIqTdF4 : 10; //pm_tx_iq_td_f4, reset value: 0x0, access type: RW
		uint32 reserved0 : 22;
	} bitFields;
} RegPhyTxtdAnt2Txtd11BIq1_u;

/*REG_PHY_TXTD_ANT2_STREAMER 0xB0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 streamerEnable : 1; //streamer_enable, reset value: 0x0, access type: RW
		uint32 streamerRate : 1; //0 = 640MHz , 1 = 320MHz, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2Streamer_u;

/*REG_PHY_TXTD_ANT2_TEST_PLUG_LEN 0xB4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 testPlugLen : 5; //test_plug_len, reset value: 0x0, access type: RW
		uint32 reserved0 : 27;
	} bitFields;
} RegPhyTxtdAnt2TestPlugLen_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS_COEFF_0 0xB8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUpsCoef0 : 7; //UPS 640Msps coeff 0  , reset value: 0x43, access type: RW
		uint32 reserved0 : 9;
		uint32 pmUpsCoef1 : 10; //UPS 640Msps coeff 1  , reset value: 0x151, access type: RW
		uint32 reserved1 : 6;
	} bitFields;
} RegPhyTxtdAnt2TxtdUpsCoeff0_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPS_COEFF_2 0xBC */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUpsCoef2 : 12; //UPS 640Msps coeff 2  , reset value: 0xB5F, access type: RW
		uint32 reserved0 : 4;
		uint32 pmUpsCoef3 : 13; //UPS 640Msps coeff 3  , reset value: 0x138B, access type: RW
		uint32 reserved1 : 3;
	} bitFields;
} RegPhyTxtdAnt2TxtdUpsCoeff2_u;

/*REG_PHY_TXTD_ANT2_TXTD_UPSRF_COEFF_0 0xC0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmUpsrfCoef0 : 2; //UPSRF 1280Msps coeff 0  , reset value: 0x2, access type: RW
		uint32 reserved0 : 14;
		uint32 pmUpsrfCoef1 : 4; //UPSRF 1280Msps coeff 1  , reset value: 0x9, access type: RW
		uint32 reserved1 : 12;
	} bitFields;
} RegPhyTxtdAnt2TxtdUpsrfCoeff0_u;

/*REG_PHY_TXTD_ANT2_PM_ANALOG_LPBK_EN 0xC4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmAnalogLpbkEn : 1; //pm_analog_lpbk_en, reset value: 0x0, access type: RW
		uint32 reserved0 : 31;
	} bitFields;
} RegPhyTxtdAnt2PmAnalogLpbkEn_u;

/*REG_PHY_TXTD_ANT2_TXTD_GCLK_EN 0xC8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txtdPmGclkEn : 4; //txtd_pm_gclk_en, reset value: 0x0, access type: RO
		uint32 reserved0 : 28;
	} bitFields;
} RegPhyTxtdAnt2TxtdGclkEn_u;

/*REG_PHY_TXTD_ANT2_TONE_GEN_BW 0xCC */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmToneGenBw : 2; //pm_tone_gen_bw, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2ToneGenBw_u;

/*REG_PHY_TXTD_ANT2_TX_SC2FC_TXON 0xD0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txSc2FcTxon : 2; //tx_sc2fc_txon, reset value: 0x0, access type: RW
		uint32 reserved0 : 30;
	} bitFields;
} RegPhyTxtdAnt2TxSc2FcTxon_u;

/*REG_PHY_TXTD_ANT2_TXTD_BYPASS_SEL 0xD4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmTxtdBypassSel : 1; //pm_txtd_bypass_sel, reset value: 0x0, access type: RW
		uint32 reserved0 : 31;
	} bitFields;
} RegPhyTxtdAnt2TxtdBypassSel_u;

/*REG_PHY_TXTD_ANT2_TX_PPM_FREQ_IN_CFG 0xD8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txPpmFreqInCfg : 20; //ppm frequency offset calculated in last reception. This value is read by genrisc from RXTD and written here. It used for NCO phase address calculation., reset value: 0x0, access type: RW
		uint32 reserved0 : 12;
	} bitFields;
} RegPhyTxtdAnt2TxPpmFreqInCfg_u;

/*REG_PHY_TXTD_ANT2_TX_PM_FDL_NCO_UP_LIM_CFG 0xE0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txPmFdlNcoUpLimCfg : 30; //nco counter uper limit initial value used when PPM >0, reset value: 0x0, access type: RW
		uint32 reserved0 : 2;
	} bitFields;
} RegPhyTxtdAnt2TxPmFdlNcoUpLimCfg_u;

/*REG_PHY_TXTD_ANT2_TX_PM_FDL_NCO_INCR_MAX_CFG 0xE4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txPmFdlNcoIncrMaxCfg : 32; //fdl nco incr max value. Above it saturation bit is asserted, reset value: 0x0, access type: RW
	} bitFields;
} RegPhyTxtdAnt2TxPmFdlNcoIncrMaxCfg_u;

/*REG_PHY_TXTD_ANT2_TX_PM_FDL_NCO_INCR_CFG 0xE8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 txPmFdlNcoIncrCfg : 32; //fdl nco incr value. Calculated in last reception. Genrisc read this value from Rx and writes it here., reset value: 0x0, access type: RW
	} bitFields;
} RegPhyTxtdAnt2TxPmFdlNcoIncrCfg_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_CFG_SEL_DPD_PHY_I 0xEC */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdCfgSelDpdPhyI : 6; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdCfgSelDpdApiI : 6; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdCfgPhyCtlI : 1; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdCfgGlobalEnI : 1; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdCfgEqEnI : 1; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdCfgEqSelTapI : 1; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdCfgEqSelMemI : 2; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 14;
	} bitFields;
} RegPhyTxtdAnt2PmDpdCfgSelDpdPhyI_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_STATUS_DBG_RDY_O 0xF0 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdStatusDbgRdyO : 1; //no description, reset value: 0x0, access type: RO
		uint32 reserved0 : 31;
	} bitFields;
} RegPhyTxtdAnt2PmDpdStatusDbgRdyO_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_DBG_CTL_RUN_I 0xF4 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdDbgCtlRunI : 1; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdDbgCtlCmdI : 3; //no description, reset value: 0x0, access type: RW
		uint32 pmDpdDbgCtlArgsI : 28; //no description, reset value: 0x0, access type: RW
	} bitFields;
} RegPhyTxtdAnt2PmDpdDbgCtlRunI_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_0 0xF8 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdDbgResO0 : 32; //no description, reset value: 0x0, access type: RO
	} bitFields;
} RegPhyTxtdAnt2PmDpdDbgResO0_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_1 0xFC */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdDbgResO1 : 32; //no description, reset value: 0x0, access type: RO
	} bitFields;
} RegPhyTxtdAnt2PmDpdDbgResO1_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_2 0x100 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdDbgResO2 : 32; //no description, reset value: 0x0, access type: RO
	} bitFields;
} RegPhyTxtdAnt2PmDpdDbgResO2_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_3 0x104 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdDbgResO3 : 32; //no description, reset value: 0x0, access type: RO
	} bitFields;
} RegPhyTxtdAnt2PmDpdDbgResO3_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_DBG_RES_O_4 0x108 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdDbgResO4 : 32; //no description, reset value: 0x0, access type: RO
	} bitFields;
} RegPhyTxtdAnt2PmDpdDbgResO4_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_0 0x10C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq00 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq00_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_1 0x110 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq01 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq01_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_2 0x114 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq02 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq02_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_3 0x118 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq03 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq03_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_4 0x11C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq04 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq04_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_5 0x120 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq05 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq05_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_6 0x124 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq06 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq06_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_7 0x128 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq07 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq07_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_0_8 0x12C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq08 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq08_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_0 0x130 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq10 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq10_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_1 0x134 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq11 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq11_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_2 0x138 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq12 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq12_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_3 0x13C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq13 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq13_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_4 0x140 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq14 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq14_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_5 0x144 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq15 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq15_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_6 0x148 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq16 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq16_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_7 0x14C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq17 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq17_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_1_8 0x150 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq18 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq18_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_0 0x154 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq20 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq20_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_1 0x158 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq21 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq21_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_2 0x15C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq22 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq22_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_3 0x160 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq23 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq23_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_4 0x164 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq24 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq24_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_5 0x168 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq25 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq25_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_6 0x16C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq26 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq26_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_7 0x170 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq27 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq27_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_2_8 0x174 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq28 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq28_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_0 0x178 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq30 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq30_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_1 0x17C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq31 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq31_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_2 0x180 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq32 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq32_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_3 0x184 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq33 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq33_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_4 0x188 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq34 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq34_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_5 0x18C */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq35 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq35_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_6 0x190 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq36 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq36_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_7 0x194 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq37 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq37_u;

/*REG_PHY_TXTD_ANT2_PM_DPD_MEM_EQ_3_8 0x198 */
typedef union
{
	uint32 val;
	struct
	{
		uint32 pmDpdMemEq38 : 24; //no description, reset value: 0x0, access type: RW
		uint32 reserved0 : 8;
	} bitFields;
} RegPhyTxtdAnt2PmDpdMemEq38_u;



#endif // _PHY_TXTD_ANT2_REGS_H_
