/*******************************************************************
*                                                                   
*  Emerald_Env.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 11/08/2013  */

#ifndef Emerald_Env_regs_H_FILE
#define Emerald_Env_regs_H_FILE

/* SYS_IF_GCLK_UART_RX_GCLK */
#define REG_SYS_IF_GCLK_UART_RX_GCLK          0x0000
#define REG_SYS_IF_GCLK_UART_RX_GCLK_MASK     0x00000001
#define REG_SYS_IF_GCLK_UART_RX_GCLK_SHIFT    0
#define REG_SYS_IF_GCLK_UART_RX_GCLK_WIDTH    1

/* SYS_IF_GCLK_UART_RX_FIFO_GCLK */
#define REG_SYS_IF_GCLK_UART_RX_FIFO_GCLK          0x0000
#define REG_SYS_IF_GCLK_UART_RX_FIFO_GCLK_MASK     0x00000002
#define REG_SYS_IF_GCLK_UART_RX_FIFO_GCLK_SHIFT    1
#define REG_SYS_IF_GCLK_UART_RX_FIFO_GCLK_WIDTH    1

/* SYS_IF_GCLK_UART_TX_GCLK */
#define REG_SYS_IF_GCLK_UART_TX_GCLK          0x0000
#define REG_SYS_IF_GCLK_UART_TX_GCLK_MASK     0x00000004
#define REG_SYS_IF_GCLK_UART_TX_GCLK_SHIFT    2
#define REG_SYS_IF_GCLK_UART_TX_GCLK_WIDTH    1

/* SYS_IF_GCLK_UART_TX_FIFO_GCLK */
#define REG_SYS_IF_GCLK_UART_TX_FIFO_GCLK          0x0000
#define REG_SYS_IF_GCLK_UART_TX_FIFO_GCLK_MASK     0x00000008
#define REG_SYS_IF_GCLK_UART_TX_FIFO_GCLK_SHIFT    3
#define REG_SYS_IF_GCLK_UART_TX_FIFO_GCLK_WIDTH    1

/* SYS_IF_GCLK_UART_CDIV_GCLK */
#define REG_SYS_IF_GCLK_UART_CDIV_GCLK          0x0000
#define REG_SYS_IF_GCLK_UART_CDIV_GCLK_MASK     0x00000010
#define REG_SYS_IF_GCLK_UART_CDIV_GCLK_SHIFT    4
#define REG_SYS_IF_GCLK_UART_CDIV_GCLK_WIDTH    1

/* SYS_IF_GCLK_CACHE_CTRS_GCLK */
#define REG_SYS_IF_GCLK_CACHE_CTRS_GCLK          0x0000
#define REG_SYS_IF_GCLK_CACHE_CTRS_GCLK_MASK     0x00000020
#define REG_SYS_IF_GCLK_CACHE_CTRS_GCLK_SHIFT    5
#define REG_SYS_IF_GCLK_CACHE_CTRS_GCLK_WIDTH    1

/* SYS_IF_GCLK_TIMERS_GCLK */
#define REG_SYS_IF_GCLK_TIMERS_GCLK          0x0000
#define REG_SYS_IF_GCLK_TIMERS_GCLK_MASK     0x00000040
#define REG_SYS_IF_GCLK_TIMERS_GCLK_SHIFT    6
#define REG_SYS_IF_GCLK_TIMERS_GCLK_WIDTH    1

/* SYS_IF_GCLK_TEST_BUS_FIFO_GCLK */
#define REG_SYS_IF_GCLK_TEST_BUS_FIFO_GCLK          0x0000
#define REG_SYS_IF_GCLK_TEST_BUS_FIFO_GCLK_MASK     0x00000080
#define REG_SYS_IF_GCLK_TEST_BUS_FIFO_GCLK_SHIFT    7
#define REG_SYS_IF_GCLK_TEST_BUS_FIFO_GCLK_WIDTH    1

/* SYS_IF_SW_RESET_UART_RX_SW_RESET */
#define REG_SYS_IF_SW_RESET_UART_RX_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_UART_RX_SW_RESET_MASK     0x00000001
#define REG_SYS_IF_SW_RESET_UART_RX_SW_RESET_SHIFT    0
#define REG_SYS_IF_SW_RESET_UART_RX_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_UART_RX_FIFO_SW_RESET */
#define REG_SYS_IF_SW_RESET_UART_RX_FIFO_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_UART_RX_FIFO_SW_RESET_MASK     0x00000002
#define REG_SYS_IF_SW_RESET_UART_RX_FIFO_SW_RESET_SHIFT    1
#define REG_SYS_IF_SW_RESET_UART_RX_FIFO_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_UART_TX_SW_RESET */
#define REG_SYS_IF_SW_RESET_UART_TX_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_UART_TX_SW_RESET_MASK     0x00000004
#define REG_SYS_IF_SW_RESET_UART_TX_SW_RESET_SHIFT    2
#define REG_SYS_IF_SW_RESET_UART_TX_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_UART_TX_FIFO_SW_RESET */
#define REG_SYS_IF_SW_RESET_UART_TX_FIFO_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_UART_TX_FIFO_SW_RESET_MASK     0x00000008
#define REG_SYS_IF_SW_RESET_UART_TX_FIFO_SW_RESET_SHIFT    3
#define REG_SYS_IF_SW_RESET_UART_TX_FIFO_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_UART_CDIV_SW_RESET */
#define REG_SYS_IF_SW_RESET_UART_CDIV_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_UART_CDIV_SW_RESET_MASK     0x00000010
#define REG_SYS_IF_SW_RESET_UART_CDIV_SW_RESET_SHIFT    4
#define REG_SYS_IF_SW_RESET_UART_CDIV_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_CACHE_CTRS_SW_RESET */
#define REG_SYS_IF_SW_RESET_CACHE_CTRS_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_CACHE_CTRS_SW_RESET_MASK     0x00000020
#define REG_SYS_IF_SW_RESET_CACHE_CTRS_SW_RESET_SHIFT    5
#define REG_SYS_IF_SW_RESET_CACHE_CTRS_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_TIMERS_GCLK_SW_RESET */
#define REG_SYS_IF_SW_RESET_TIMERS_GCLK_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_TIMERS_GCLK_SW_RESET_MASK     0x00000040
#define REG_SYS_IF_SW_RESET_TIMERS_GCLK_SW_RESET_SHIFT    6
#define REG_SYS_IF_SW_RESET_TIMERS_GCLK_SW_RESET_WIDTH    1

/* SYS_IF_SW_RESET_TEST_BUS_FIFO_SW_RESET */
#define REG_SYS_IF_SW_RESET_TEST_BUS_FIFO_SW_RESET          0x0004
#define REG_SYS_IF_SW_RESET_TEST_BUS_FIFO_SW_RESET_MASK     0x00000080
#define REG_SYS_IF_SW_RESET_TEST_BUS_FIFO_SW_RESET_SHIFT    7
#define REG_SYS_IF_SW_RESET_TEST_BUS_FIFO_SW_RESET_WIDTH    1

/* UART_WR_UART_WRITE_DATA */
#define REG_UART_WR_UART_WRITE_DATA          0x000C
#define REG_UART_WR_UART_WRITE_DATA_MASK     0x000000ff
#define REG_UART_WR_UART_WRITE_DATA_SHIFT    0
#define REG_UART_WR_UART_WRITE_DATA_WIDTH    8

/* UART_RD_UART_READ_DATA */
#define REG_UART_RD_UART_READ_DATA          0x0010
#define REG_UART_RD_UART_READ_DATA_MASK     0x000000ff
#define REG_UART_RD_UART_READ_DATA_SHIFT    0
#define REG_UART_RD_UART_READ_DATA_WIDTH    8

/* UART_RD_UART_READ_PARITY_ERROR_BIT */
#define REG_UART_RD_UART_READ_PARITY_ERROR_BIT          0x0010
#define REG_UART_RD_UART_READ_PARITY_ERROR_BIT_MASK     0x00000100
#define REG_UART_RD_UART_READ_PARITY_ERROR_BIT_SHIFT    8
#define REG_UART_RD_UART_READ_PARITY_ERROR_BIT_WIDTH    1

/* UART_DIVR_UART_CLOCK_DIVISION_RATIO */
#define REG_UART_DIVR_UART_CLOCK_DIVISION_RATIO          0x0014
#define REG_UART_DIVR_UART_CLOCK_DIVISION_RATIO_MASK     0x00003fff
#define REG_UART_DIVR_UART_CLOCK_DIVISION_RATIO_SHIFT    0
#define REG_UART_DIVR_UART_CLOCK_DIVISION_RATIO_WIDTH    14

/* UART_FWL_REG_UART_RX_FIFO_WATER_LEVEL */
#define REG_UART_FWL_REG_UART_RX_FIFO_WATER_LEVEL          0x0018
#define REG_UART_FWL_REG_UART_RX_FIFO_WATER_LEVEL_MASK     0x0000001f
#define REG_UART_FWL_REG_UART_RX_FIFO_WATER_LEVEL_SHIFT    0
#define REG_UART_FWL_REG_UART_RX_FIFO_WATER_LEVEL_WIDTH    5

/* UART_FWL_REG_UART_TX_FIFO_WATER_LEVEL */
#define REG_UART_FWL_REG_UART_TX_FIFO_WATER_LEVEL          0x0018
#define REG_UART_FWL_REG_UART_TX_FIFO_WATER_LEVEL_MASK     0x000003e0
#define REG_UART_FWL_REG_UART_TX_FIFO_WATER_LEVEL_SHIFT    5
#define REG_UART_FWL_REG_UART_TX_FIFO_WATER_LEVEL_WIDTH    5

/* UART_INT_REG_UART_OVERRUN_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_ENABLE_MASK     0x00000001
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_ENABLE_SHIFT    0
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_FRAMING_ERROR_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_ENABLE_MASK     0x00000002
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_ENABLE_SHIFT    1
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_PARITY_ERROR_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_ENABLE_MASK     0x00000004
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_ENABLE_SHIFT    2
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE_MASK     0x00000008
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE_SHIFT    3
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE_MASK     0x00000010
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE_SHIFT    4
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE_MASK     0x00000020
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE_SHIFT    5
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE_MASK     0x00000040
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE_SHIFT    6
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_IDLE_IRQ_ENABLE */
#define REG_UART_INT_REG_UART_IDLE_IRQ_ENABLE          0x001C
#define REG_UART_INT_REG_UART_IDLE_IRQ_ENABLE_MASK     0x00000080
#define REG_UART_INT_REG_UART_IDLE_IRQ_ENABLE_SHIFT    7
#define REG_UART_INT_REG_UART_IDLE_IRQ_ENABLE_WIDTH    1

/* UART_INT_REG_UART_OVERRUN_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_OVERRUN_IRQ          0x001C
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_MASK     0x00000100
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_SHIFT    8
#define REG_UART_INT_REG_UART_OVERRUN_IRQ_WIDTH    1

/* UART_INT_REG_UART_FRAMING_ERROR_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ          0x001C
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_MASK     0x00000200
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_SHIFT    9
#define REG_UART_INT_REG_UART_FRAMING_ERROR_IRQ_WIDTH    1

/* UART_INT_REG_UART_PARITY_ERROR_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ          0x001C
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_MASK     0x00000400
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_SHIFT    10
#define REG_UART_INT_REG_UART_PARITY_ERROR_IRQ_WIDTH    1

/* UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ          0x001C
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_MASK     0x00000800
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_SHIFT    11
#define REG_UART_INT_REG_UART_READ_COLLAPSE_BUFFER_IRQ_WIDTH    1

/* UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ          0x001C
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_MASK     0x00001000
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_SHIFT    12
#define REG_UART_INT_REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_WIDTH    1

/* UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ          0x001C
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_MASK     0x00002000
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_SHIFT    13
#define REG_UART_INT_REG_UART_READ_FIFO_WATER_LEVEL_IRQ_WIDTH    1

/* UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ          0x001C
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_MASK     0x00004000
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_SHIFT    14
#define REG_UART_INT_REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_WIDTH    1

/* UART_INT_REG_UART_IDLE_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_INT_REG_UART_IDLE_IRQ          0x001C
#define REG_UART_INT_REG_UART_IDLE_IRQ_MASK     0x00008000
#define REG_UART_INT_REG_UART_IDLE_IRQ_SHIFT    15
#define REG_UART_INT_REG_UART_IDLE_IRQ_WIDTH    1

/* UART_CONTROL_REG_UART_TX_OUTPUT_ENABLE */
#define REG_UART_CONTROL_REG_UART_TX_OUTPUT_ENABLE          0x0020
#define REG_UART_CONTROL_REG_UART_TX_OUTPUT_ENABLE_MASK     0x00000001
#define REG_UART_CONTROL_REG_UART_TX_OUTPUT_ENABLE_SHIFT    0
#define REG_UART_CONTROL_REG_UART_TX_OUTPUT_ENABLE_WIDTH    1

/* UART_CONTROL_REG_UART_RX_PARITY_MODE */
#define REG_UART_CONTROL_REG_UART_RX_PARITY_MODE          0x0020
#define REG_UART_CONTROL_REG_UART_RX_PARITY_MODE_MASK     0x00000006
#define REG_UART_CONTROL_REG_UART_RX_PARITY_MODE_SHIFT    1
#define REG_UART_CONTROL_REG_UART_RX_PARITY_MODE_WIDTH    2

/* UART_CONTROL_REG_UART_TX_PARITY_MODE */
#define REG_UART_CONTROL_REG_UART_TX_PARITY_MODE          0x0020
#define REG_UART_CONTROL_REG_UART_TX_PARITY_MODE_MASK     0x00000018
#define REG_UART_CONTROL_REG_UART_TX_PARITY_MODE_SHIFT    3
#define REG_UART_CONTROL_REG_UART_TX_PARITY_MODE_WIDTH    2

/* UART_CONTROL_REG_UART_RX_STOP */
#define REG_UART_CONTROL_REG_UART_RX_STOP          0x0020
#define REG_UART_CONTROL_REG_UART_RX_STOP_MASK     0x00000020
#define REG_UART_CONTROL_REG_UART_RX_STOP_SHIFT    5
#define REG_UART_CONTROL_REG_UART_RX_STOP_WIDTH    1

/* UART_CONTROL_REG_UART_TX_STOP */
#define REG_UART_CONTROL_REG_UART_TX_STOP          0x0020
#define REG_UART_CONTROL_REG_UART_TX_STOP_MASK     0x00000040
#define REG_UART_CONTROL_REG_UART_TX_STOP_SHIFT    6
#define REG_UART_CONTROL_REG_UART_TX_STOP_WIDTH    1

/* UART_CONTROL_REG_UART_LOOPBACK_MODE */
#define REG_UART_CONTROL_REG_UART_LOOPBACK_MODE          0x0020
#define REG_UART_CONTROL_REG_UART_LOOPBACK_MODE_MASK     0x00000080
#define REG_UART_CONTROL_REG_UART_LOOPBACK_MODE_SHIFT    7
#define REG_UART_CONTROL_REG_UART_LOOPBACK_MODE_WIDTH    1

/* UART_NOISE_COUNT_UART_NOISE_COUNTER_CLEAR */
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_CLEAR          0x0024
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_CLEAR_MASK     0x00000001
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_CLEAR_SHIFT    0
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_CLEAR_WIDTH    1

/* UART_NOISE_COUNT_UART_NOISE_COUNTER */
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER          0x0024
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_MASK     0x000001fe
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_SHIFT    1
#define REG_UART_NOISE_COUNT_UART_NOISE_COUNTER_WIDTH    8

/* UART_IDLE_CNT_MAX_UART_RX_IDLE_COUNTER */
#define REG_UART_IDLE_CNT_MAX_UART_RX_IDLE_COUNTER          0x0028
#define REG_UART_IDLE_CNT_MAX_UART_RX_IDLE_COUNTER_MASK     0x000000ff
#define REG_UART_IDLE_CNT_MAX_UART_RX_IDLE_COUNTER_SHIFT    0
#define REG_UART_IDLE_CNT_MAX_UART_RX_IDLE_COUNTER_WIDTH    8

/* UART_COUNT_FIF_UART_BYTES_IN_RX_FIFO */
#define REG_UART_COUNT_FIF_UART_BYTES_IN_RX_FIFO          0x002C
#define REG_UART_COUNT_FIF_UART_BYTES_IN_RX_FIFO_MASK     0x0000001f
#define REG_UART_COUNT_FIF_UART_BYTES_IN_RX_FIFO_SHIFT    0
#define REG_UART_COUNT_FIF_UART_BYTES_IN_RX_FIFO_WIDTH    5

/* UART_COUNT_FIF_UART_BYTES_IN_TX_FIFO */
#define REG_UART_COUNT_FIF_UART_BYTES_IN_TX_FIFO          0x002C
#define REG_UART_COUNT_FIF_UART_BYTES_IN_TX_FIFO_MASK     0x000003e0
#define REG_UART_COUNT_FIF_UART_BYTES_IN_TX_FIFO_SHIFT    5
#define REG_UART_COUNT_FIF_UART_BYTES_IN_TX_FIFO_WIDTH    5

/* UART_INT_MODE_UART_TX_INTERRUPT_MODE */
#define REG_UART_INT_MODE_UART_TX_INTERRUPT_MODE          0x0030
#define REG_UART_INT_MODE_UART_TX_INTERRUPT_MODE_MASK     0x00000001
#define REG_UART_INT_MODE_UART_TX_INTERRUPT_MODE_SHIFT    0
#define REG_UART_INT_MODE_UART_TX_INTERRUPT_MODE_WIDTH    1

/* PLL_EN_DIV_MAC_CLK_DIV_D2A */
/* Secure write; 000 = 480MHz; 001 = 240MHz; 010 = 120MHz; 011 = 60MHz; 100 = 640MHz; 101 = 320MHz; 110 = 160MHz; 111 = 80MHz
 111 = 80MHz */
#define REG_PLL_EN_DIV_MAC_CLK_DIV_D2A          0x0040
#define REG_PLL_EN_DIV_MAC_CLK_DIV_D2A_MASK     0x00000007
#define REG_PLL_EN_DIV_MAC_CLK_DIV_D2A_SHIFT    0
#define REG_PLL_EN_DIV_MAC_CLK_DIV_D2A_WIDTH    3

/* PLL_EN_DIV_MAC_CLK_EN_D2A */
/* Secure write */
#define REG_PLL_EN_DIV_MAC_CLK_EN_D2A          0x0040
#define REG_PLL_EN_DIV_MAC_CLK_EN_D2A_MASK     0x00000008
#define REG_PLL_EN_DIV_MAC_CLK_EN_D2A_SHIFT    3
#define REG_PLL_EN_DIV_MAC_CLK_EN_D2A_WIDTH    1

/* PLL_EN_DIV_TBUS_CLK_DIV_D2A */
/* Secure write; 0 = 480MHz; 1 = 240MHz */
#define REG_PLL_EN_DIV_TBUS_CLK_DIV_D2A          0x0040
#define REG_PLL_EN_DIV_TBUS_CLK_DIV_D2A_MASK     0x00000070
#define REG_PLL_EN_DIV_TBUS_CLK_DIV_D2A_SHIFT    4
#define REG_PLL_EN_DIV_TBUS_CLK_DIV_D2A_WIDTH    3

/* PLL_EN_DIV_TBUS_CLK_EN_D2A */
/* Secure write */
#define REG_PLL_EN_DIV_TBUS_CLK_EN_D2A          0x0040
#define REG_PLL_EN_DIV_TBUS_CLK_EN_D2A_MASK     0x00000080
#define REG_PLL_EN_DIV_TBUS_CLK_EN_D2A_SHIFT    7
#define REG_PLL_EN_DIV_TBUS_CLK_EN_D2A_WIDTH    1

/* PLL_EN_DIV_PHY_CLK_DIV_D2A */
/* Secure write; 00 = 240MHz; 01 = 120MHz; 10 = 60MHz; 11 = 30MHz */
#define REG_PLL_EN_DIV_PHY_CLK_DIV_D2A          0x0040
#define REG_PLL_EN_DIV_PHY_CLK_DIV_D2A_MASK     0x00000300
#define REG_PLL_EN_DIV_PHY_CLK_DIV_D2A_SHIFT    8
#define REG_PLL_EN_DIV_PHY_CLK_DIV_D2A_WIDTH    2

/* PLL_EN_DIV_PHY_CLK_EN_D2A */
/* Secure write */
#define REG_PLL_EN_DIV_PHY_CLK_EN_D2A          0x0040
#define REG_PLL_EN_DIV_PHY_CLK_EN_D2A_MASK     0x00000800
#define REG_PLL_EN_DIV_PHY_CLK_EN_D2A_SHIFT    11
#define REG_PLL_EN_DIV_PHY_CLK_EN_D2A_WIDTH    1

/* PLL_EN_DIV_ADC_CLK_DIV_D2A */
/* Secure write; 0 = 480MHz; 1 = 240MHz */
#define REG_PLL_EN_DIV_ADC_CLK_DIV_D2A          0x0040
#define REG_PLL_EN_DIV_ADC_CLK_DIV_D2A_MASK     0x00001000
#define REG_PLL_EN_DIV_ADC_CLK_DIV_D2A_SHIFT    12
#define REG_PLL_EN_DIV_ADC_CLK_DIV_D2A_WIDTH    1

/* PLL_EN_DIV_ADC_CLK_EN_D2A */
/* Secure write */
#define REG_PLL_EN_DIV_ADC_CLK_EN_D2A          0x0040
#define REG_PLL_EN_DIV_ADC_CLK_EN_D2A_MASK     0x00008000
#define REG_PLL_EN_DIV_ADC_CLK_EN_D2A_SHIFT    15
#define REG_PLL_EN_DIV_ADC_CLK_EN_D2A_WIDTH    1

/* PLL_CTL_BBPLL_CONFIG_D2A */
/* Secure write */
#define REG_PLL_CTL_BBPLL_CONFIG_D2A          0x0048
#define REG_PLL_CTL_BBPLL_CONFIG_D2A_MASK     0x000000ff
#define REG_PLL_CTL_BBPLL_CONFIG_D2A_SHIFT    0
#define REG_PLL_CTL_BBPLL_CONFIG_D2A_WIDTH    8

/* PLL_CTL_BBPLL_PUP_D2A */
/* Secure write */
#define REG_PLL_CTL_BBPLL_PUP_D2A          0x0048
#define REG_PLL_CTL_BBPLL_PUP_D2A_MASK     0x00000100
#define REG_PLL_CTL_BBPLL_PUP_D2A_SHIFT    8
#define REG_PLL_CTL_BBPLL_PUP_D2A_WIDTH    1

/* PLL_CTL_BBPLL_LDODIS_D2A */
/* Secure write */
#define REG_PLL_CTL_BBPLL_LDODIS_D2A          0x0048
#define REG_PLL_CTL_BBPLL_LDODIS_D2A_MASK     0x00000200
#define REG_PLL_CTL_BBPLL_LDODIS_D2A_SHIFT    9
#define REG_PLL_CTL_BBPLL_LDODIS_D2A_WIDTH    1

/* PLL_CTL_BBPLL_RSTQ_CNT_D2A */
/* Secure write;  Reset counter for time between power up and reset for digital-part of BBPLL */
#define REG_PLL_CTL_BBPLL_RSTQ_CNT_D2A          0x0048
#define REG_PLL_CTL_BBPLL_RSTQ_CNT_D2A_MASK     0x00001c00
#define REG_PLL_CTL_BBPLL_RSTQ_CNT_D2A_SHIFT    10
#define REG_PLL_CTL_BBPLL_RSTQ_CNT_D2A_WIDTH    3

/* PLL_CTL_FCSI_LDO_PD_D2A */
/* Secure write */
#define REG_PLL_CTL_FCSI_LDO_PD_D2A          0x0048
#define REG_PLL_CTL_FCSI_LDO_PD_D2A_MASK     0x00002000
#define REG_PLL_CTL_FCSI_LDO_PD_D2A_SHIFT    13
#define REG_PLL_CTL_FCSI_LDO_PD_D2A_WIDTH    1

/* SYS_CLR_DIVR_SLOW_CLOCK_DIVR */
/* Secure write */
#define REG_SYS_CLR_DIVR_SLOW_CLOCK_DIVR          0x004C
#define REG_SYS_CLR_DIVR_SLOW_CLOCK_DIVR_MASK     0x0003ffff
#define REG_SYS_CLR_DIVR_SLOW_CLOCK_DIVR_SHIFT    0
#define REG_SYS_CLR_DIVR_SLOW_CLOCK_DIVR_WIDTH    18

/* SYS_CLR_DIVR_FAST_CLOCK_DIVR */
/* Secure write */
#define REG_SYS_CLR_DIVR_FAST_CLOCK_DIVR          0x004C
#define REG_SYS_CLR_DIVR_FAST_CLOCK_DIVR_MASK     0x003c0000
#define REG_SYS_CLR_DIVR_FAST_CLOCK_DIVR_SHIFT    18
#define REG_SYS_CLR_DIVR_FAST_CLOCK_DIVR_WIDTH    4

/* PLL_LOCK_PLL_LOCK */
#define REG_PLL_LOCK_PLL_LOCK          0x0050
#define REG_PLL_LOCK_PLL_LOCK_MASK     0x00000001
#define REG_PLL_LOCK_PLL_LOCK_SHIFT    0
#define REG_PLL_LOCK_PLL_LOCK_WIDTH    1

/* CPU_ENABLE_CPU_ENABLE */
/* Secure write, Once Written - CPUs are dead and unaccessible until HW reset */
#define REG_CPU_ENABLE_CPU_ENABLE          0x0054
#define REG_CPU_ENABLE_CPU_ENABLE_MASK     0x00000001
#define REG_CPU_ENABLE_CPU_ENABLE_SHIFT    0
#define REG_CPU_ENABLE_CPU_ENABLE_WIDTH    1

/* CLOCK_SELECT_CPU_CLOCK_SELECT */
/* Secure write.  */
#define REG_CLOCK_SELECT_CPU_CLOCK_SELECT          0x0058
#define REG_CLOCK_SELECT_CPU_CLOCK_SELECT_MASK     0x00000003
#define REG_CLOCK_SELECT_CPU_CLOCK_SELECT_SHIFT    0
#define REG_CLOCK_SELECT_CPU_CLOCK_SELECT_WIDTH    2

/* LVDS_CTL_LVDS_DIV */
#define REG_LVDS_CTL_LVDS_DIV          0x005C
#define REG_LVDS_CTL_LVDS_DIV_MASK     0x00000007
#define REG_LVDS_CTL_LVDS_DIV_SHIFT    0
#define REG_LVDS_CTL_LVDS_DIV_WIDTH    3

/* LVDS_CTL_LVDS_DIVIDER_ENABLE */
#define REG_LVDS_CTL_LVDS_DIVIDER_ENABLE          0x005C
#define REG_LVDS_CTL_LVDS_DIVIDER_ENABLE_MASK     0x00000008
#define REG_LVDS_CTL_LVDS_DIVIDER_ENABLE_SHIFT    3
#define REG_LVDS_CTL_LVDS_DIVIDER_ENABLE_WIDTH    1

/* LVDS_CTL_LVDS_MODE_ENABLE */
#define REG_LVDS_CTL_LVDS_MODE_ENABLE          0x005C
#define REG_LVDS_CTL_LVDS_MODE_ENABLE_MASK     0x00000010
#define REG_LVDS_CTL_LVDS_MODE_ENABLE_SHIFT    4
#define REG_LVDS_CTL_LVDS_MODE_ENABLE_WIDTH    1

/* LVDS_CTL_TEST_FIFO_EN_LOW */
/* Low channel is muxed with lower CPU chain */
#define REG_LVDS_CTL_TEST_FIFO_EN_LOW          0x005C
#define REG_LVDS_CTL_TEST_FIFO_EN_LOW_MASK     0x00000020
#define REG_LVDS_CTL_TEST_FIFO_EN_LOW_SHIFT    5
#define REG_LVDS_CTL_TEST_FIFO_EN_LOW_WIDTH    1

/* LVDS_CTL_TEST_FIFO_EN_MID */
/* Mid channel is muxed with upper CPU chain */
#define REG_LVDS_CTL_TEST_FIFO_EN_MID          0x005C
#define REG_LVDS_CTL_TEST_FIFO_EN_MID_MASK     0x00000040
#define REG_LVDS_CTL_TEST_FIFO_EN_MID_SHIFT    6
#define REG_LVDS_CTL_TEST_FIFO_EN_MID_WIDTH    1

/* LVDS_CTL_TEST_FIFO_EN_HIGH */
/* This chain is not muxed with CPU */
#define REG_LVDS_CTL_TEST_FIFO_EN_HIGH          0x005C
#define REG_LVDS_CTL_TEST_FIFO_EN_HIGH_MASK     0x00000080
#define REG_LVDS_CTL_TEST_FIFO_EN_HIGH_SHIFT    7
#define REG_LVDS_CTL_TEST_FIFO_EN_HIGH_WIDTH    1

/* LVDS_CTL_LVDS_IF_SELECT */
/* 0x - TCLOGIC owns the lvds i/f\n10 - LOWER CPU owns the lvds i/f\n11 - UPPER CPU owns the lvds i/f\n(setting '0' or '1' will not make any difference) */
#define REG_LVDS_CTL_LVDS_IF_SELECT          0x005C
#define REG_LVDS_CTL_LVDS_IF_SELECT_MASK     0x00000700
#define REG_LVDS_CTL_LVDS_IF_SELECT_SHIFT    8
#define REG_LVDS_CTL_LVDS_IF_SELECT_WIDTH    3

/* LVDS_CTL_LVDS_IF_PATTERN_MODE */
#define REG_LVDS_CTL_LVDS_IF_PATTERN_MODE          0x005C
#define REG_LVDS_CTL_LVDS_IF_PATTERN_MODE_MASK     0x00000800
#define REG_LVDS_CTL_LVDS_IF_PATTERN_MODE_SHIFT    11
#define REG_LVDS_CTL_LVDS_IF_PATTERN_MODE_WIDTH    1

/* LVDS_CTL_LVDS_MAC_CLK_SEL */
#define REG_LVDS_CTL_LVDS_MAC_CLK_SEL          0x005C
#define REG_LVDS_CTL_LVDS_MAC_CLK_SEL_MASK     0x00001000
#define REG_LVDS_CTL_LVDS_MAC_CLK_SEL_SHIFT    12
#define REG_LVDS_CTL_LVDS_MAC_CLK_SEL_WIDTH    1

/* LVDS_CTL_LVDS_SCR_BYPASS */
#define REG_LVDS_CTL_LVDS_SCR_BYPASS          0x005C
#define REG_LVDS_CTL_LVDS_SCR_BYPASS_MASK     0x00002000
#define REG_LVDS_CTL_LVDS_SCR_BYPASS_SHIFT    13
#define REG_LVDS_CTL_LVDS_SCR_BYPASS_WIDTH    1

/* SYSTEM_INFO_CHIP_ID */
#define REG_SYSTEM_INFO_CHIP_ID          0x0060
#define REG_SYSTEM_INFO_CHIP_ID_MASK     0x0000fffC
#define REG_SYSTEM_INFO_CHIP_ID_SHIFT    0
#define REG_SYSTEM_INFO_CHIP_ID_WIDTH    16

/* SYSTEM_INFO_BOOT_MODE */
#define REG_SYSTEM_INFO_BOOT_MODE          0x0060
#define REG_SYSTEM_INFO_BOOT_MODE_MASK     0x00030000
#define REG_SYSTEM_INFO_BOOT_MODE_SHIFT    16
#define REG_SYSTEM_INFO_BOOT_MODE_WIDTH    2

/* SYSTEM_INFO_UPPER_LOWER_CPU */
#define REG_SYSTEM_INFO_UPPER_LOWER_CPU          0x0060
#define REG_SYSTEM_INFO_UPPER_LOWER_CPU_MASK     0x00040000
#define REG_SYSTEM_INFO_UPPER_LOWER_CPU_SHIFT    18
#define REG_SYSTEM_INFO_UPPER_LOWER_CPU_WIDTH    1

/* SYSTEM_CFG_ABORT_COUNTER_ENABLE */
#define REG_SYSTEM_CFG_ABORT_COUNTER_ENABLE          0x0064
#define REG_SYSTEM_CFG_ABORT_COUNTER_ENABLE_MASK     0x00000001
#define REG_SYSTEM_CFG_ABORT_COUNTER_ENABLE_SHIFT    0
#define REG_SYSTEM_CFG_ABORT_COUNTER_ENABLE_WIDTH    1

/* SYSTEM_CFG_CHAINED_DEBUG_MODE */
#define REG_SYSTEM_CFG_CHAINED_DEBUG_MODE          0x0064
#define REG_SYSTEM_CFG_CHAINED_DEBUG_MODE_MASK     0x00000002
#define REG_SYSTEM_CFG_CHAINED_DEBUG_MODE_SHIFT    1
#define REG_SYSTEM_CFG_CHAINED_DEBUG_MODE_WIDTH    1

/* SECURE_WRITE_SECURE_WRITE */
/* Write 0xaaaa, then 0x5555 to this address before writing to secure write registers */
#define REG_SECURE_WRITE_SECURE_WRITE          0x0068
#define REG_SECURE_WRITE_SECURE_WRITE_MASK     0x0000ffff
#define REG_SECURE_WRITE_SECURE_WRITE_SHIFT    0
#define REG_SECURE_WRITE_SECURE_WRITE_WIDTH    16

/* RESET_EXTERNAL_CPU_RESET_EXTERNAL_CPU */
#define REG_RESET_EXTERNAL_CPU_RESET_EXTERNAL_CPU          0x006C
#define REG_RESET_EXTERNAL_CPU_RESET_EXTERNAL_CPU_MASK     0x00000001
#define REG_RESET_EXTERNAL_CPU_RESET_EXTERNAL_CPU_SHIFT    0
#define REG_RESET_EXTERNAL_CPU_RESET_EXTERNAL_CPU_WIDTH    1

/* GPIO_SEL_GPIO_SEL */
/* Selects the clock that goes to GPIO[0] divided by 64 */
#define REG_GPIO_SEL_GPIO_SEL          0x0070
#define REG_GPIO_SEL_GPIO_SEL_MASK     0x00000007
#define REG_GPIO_SEL_GPIO_SEL_SHIFT    0
#define REG_GPIO_SEL_GPIO_SEL_WIDTH    3

/* GPIO_SEL_CLKGEN_CLK_ON_GPIO */
#define REG_GPIO_SEL_CLKGEN_CLK_ON_GPIO          0x0070
#define REG_GPIO_SEL_CLKGEN_CLK_ON_GPIO_MASK     0x00000008
#define REG_GPIO_SEL_CLKGEN_CLK_ON_GPIO_SHIFT    3
#define REG_GPIO_SEL_CLKGEN_CLK_ON_GPIO_WIDTH    1

/* GPIO_SEL_GENRISC_GPO_SELECTED */
#define REG_GPIO_SEL_GENRISC_GPO_SELECTED          0x0070
#define REG_GPIO_SEL_GENRISC_GPO_SELECTED_MASK     0x00000010
#define REG_GPIO_SEL_GENRISC_GPO_SELECTED_SHIFT    4
#define REG_GPIO_SEL_GENRISC_GPO_SELECTED_WIDTH    1

/* GPIO_SEL_SELECT_PHY_SIGNALS */
#define REG_GPIO_SEL_SELECT_PHY_SIGNALS          0x0070
#define REG_GPIO_SEL_SELECT_PHY_SIGNALS_MASK     0x00000020
#define REG_GPIO_SEL_SELECT_PHY_SIGNALS_SHIFT    5
#define REG_GPIO_SEL_SELECT_PHY_SIGNALS_WIDTH    1

/* GPIO_SEL_GPIO_DIV_BYPASS */
#define REG_GPIO_SEL_GPIO_DIV_BYPASS          0x0070
#define REG_GPIO_SEL_GPIO_DIV_BYPASS_MASK     0x00000040
#define REG_GPIO_SEL_GPIO_DIV_BYPASS_SHIFT    6
#define REG_GPIO_SEL_GPIO_DIV_BYPASS_WIDTH    1

/* TOP_MUX_LVDS_XO_SEL */
#define REG_TOP_MUX_LVDS_XO_SEL          0x0078
#define REG_TOP_MUX_LVDS_XO_SEL_MASK     0x00000001
#define REG_TOP_MUX_LVDS_XO_SEL_SHIFT    0
#define REG_TOP_MUX_LVDS_XO_SEL_WIDTH    1

/* TOP_MUX_MODEM_XO_SEL */
#define REG_TOP_MUX_MODEM_XO_SEL          0x0078
#define REG_TOP_MUX_MODEM_XO_SEL_MASK     0x00000002
#define REG_TOP_MUX_MODEM_XO_SEL_SHIFT    1
#define REG_TOP_MUX_MODEM_XO_SEL_WIDTH    1

/* TOP_MUX_MODEM_PRE_DIV */
#define REG_TOP_MUX_MODEM_PRE_DIV          0x0078
#define REG_TOP_MUX_MODEM_PRE_DIV_MASK     0x00000004
#define REG_TOP_MUX_MODEM_PRE_DIV_SHIFT    2
#define REG_TOP_MUX_MODEM_PRE_DIV_WIDTH    1

/* TOP_MUX_CPU_PHY_DIV */
#define REG_TOP_MUX_CPU_PHY_DIV          0x0078
#define REG_TOP_MUX_CPU_PHY_DIV_MASK     0x00000018
#define REG_TOP_MUX_CPU_PHY_DIV_SHIFT    3
#define REG_TOP_MUX_CPU_PHY_DIV_WIDTH    2

/* TOP_MUX_CPU_PHY_DIV_ENABLE */
#define REG_TOP_MUX_CPU_PHY_DIV_ENABLE          0x0078
#define REG_TOP_MUX_CPU_PHY_DIV_ENABLE_MASK     0x00000020
#define REG_TOP_MUX_CPU_PHY_DIV_ENABLE_SHIFT    5
#define REG_TOP_MUX_CPU_PHY_DIV_ENABLE_WIDTH    1

/* TOP_MUX_CPU_DIVIDERS_XO_SEL */
#define REG_TOP_MUX_CPU_DIVIDERS_XO_SEL          0x0078
#define REG_TOP_MUX_CPU_DIVIDERS_XO_SEL_MASK     0x00000040
#define REG_TOP_MUX_CPU_DIVIDERS_XO_SEL_SHIFT    6
#define REG_TOP_MUX_CPU_DIVIDERS_XO_SEL_WIDTH    1

/* BB_OPMODE_STATUS_BB_OPMODE_STATUS */
#define REG_BB_OPMODE_STATUS_BB_OPMODE_STATUS          0x007C
#define REG_BB_OPMODE_STATUS_BB_OPMODE_STATUS_MASK     0x0000ffff
#define REG_BB_OPMODE_STATUS_BB_OPMODE_STATUS_SHIFT    0
#define REG_BB_OPMODE_STATUS_BB_OPMODE_STATUS_WIDTH    16

/* GPIO_OEN_GPIO_OUTPUT_ENABLE */
#define REG_GPIO_OEN_GPIO_OUTPUT_ENABLE          0x0080
#define REG_GPIO_OEN_GPIO_OUTPUT_ENABLE_MASK     0x0001ffff
#define REG_GPIO_OEN_GPIO_OUTPUT_ENABLE_SHIFT    0
#define REG_GPIO_OEN_GPIO_OUTPUT_ENABLE_WIDTH    17

/* GPIO_DAT_GPIO_DATA */
#define REG_GPIO_DAT_GPIO_DATA          0x0084
#define REG_GPIO_DAT_GPIO_DATA_MASK     0x0000ffff
#define REG_GPIO_DAT_GPIO_DATA_SHIFT    0
#define REG_GPIO_DAT_GPIO_DATA_WIDTH    16

/* GPIO_STB_LEN_GPIO_STROBE_LENGTH */
#define REG_GPIO_STB_LEN_GPIO_STROBE_LENGTH          0x0088
#define REG_GPIO_STB_LEN_GPIO_STROBE_LENGTH_MASK     0x0000001f
#define REG_GPIO_STB_LEN_GPIO_STROBE_LENGTH_SHIFT    0
#define REG_GPIO_STB_LEN_GPIO_STROBE_LENGTH_WIDTH    5

/* GPO_REG_GPO_REGISTER */
/* Different usage in upper and lower CPUs */
#define REG_GPO_REG_GPO_REGISTER          0x008C
#define REG_GPO_REG_GPO_REGISTER_MASK     0x0000ffff
#define REG_GPO_REG_GPO_REGISTER_SHIFT    0
#define REG_GPO_REG_GPO_REGISTER_WIDTH    16

/* GPIO_ACTIVE_GPIO_ACTIVE */
/* Set to select this CPU's GPIO out and oen connection to pads */
#define REG_GPIO_ACTIVE_GPIO_ACTIVE          0x0090
#define REG_GPIO_ACTIVE_GPIO_ACTIVE_MASK     0x00000001
#define REG_GPIO_ACTIVE_GPIO_ACTIVE_SHIFT    0
#define REG_GPIO_ACTIVE_GPIO_ACTIVE_WIDTH    1

/* TC_CFG_CH0_LPBK_CLK_SRC */
#define REG_TC_CFG_CH0_LPBK_CLK_SRC          0x0094
#define REG_TC_CFG_CH0_LPBK_CLK_SRC_MASK     0x00000001
#define REG_TC_CFG_CH0_LPBK_CLK_SRC_SHIFT    0
#define REG_TC_CFG_CH0_LPBK_CLK_SRC_WIDTH    1

/* TC_CFG_CH1_LPBK_CLK_SRC */
#define REG_TC_CFG_CH1_LPBK_CLK_SRC          0x0094
#define REG_TC_CFG_CH1_LPBK_CLK_SRC_MASK     0x00000002
#define REG_TC_CFG_CH1_LPBK_CLK_SRC_SHIFT    1
#define REG_TC_CFG_CH1_LPBK_CLK_SRC_WIDTH    1

/* TC_CFG_CH2_LPBK_CLK_SRC */
#define REG_TC_CFG_CH2_LPBK_CLK_SRC          0x0094
#define REG_TC_CFG_CH2_LPBK_CLK_SRC_MASK     0x00000004
#define REG_TC_CFG_CH2_LPBK_CLK_SRC_SHIFT    2
#define REG_TC_CFG_CH2_LPBK_CLK_SRC_WIDTH    1

/* TC_CFG_CH3_LPBK_CLK_SRC */
#define REG_TC_CFG_CH3_LPBK_CLK_SRC          0x0094
#define REG_TC_CFG_CH3_LPBK_CLK_SRC_MASK     0x00000008
#define REG_TC_CFG_CH3_LPBK_CLK_SRC_SHIFT    3
#define REG_TC_CFG_CH3_LPBK_CLK_SRC_WIDTH    1

/* TC_CFG_RX0_LPBK_SELECT */
#define REG_TC_CFG_RX0_LPBK_SELECT          0x0094
#define REG_TC_CFG_RX0_LPBK_SELECT_MASK     0x00000070
#define REG_TC_CFG_RX0_LPBK_SELECT_SHIFT    4
#define REG_TC_CFG_RX0_LPBK_SELECT_WIDTH    3

/* TC_CFG_RX1_LPBK_SELECT */
#define REG_TC_CFG_RX1_LPBK_SELECT          0x0094
#define REG_TC_CFG_RX1_LPBK_SELECT_MASK     0x00000700
#define REG_TC_CFG_RX1_LPBK_SELECT_SHIFT    8
#define REG_TC_CFG_RX1_LPBK_SELECT_WIDTH    3

/* TC_CFG_RX2_LPBK_SELECT */
#define REG_TC_CFG_RX2_LPBK_SELECT          0x0094
#define REG_TC_CFG_RX2_LPBK_SELECT_MASK     0x00007000
#define REG_TC_CFG_RX2_LPBK_SELECT_SHIFT    12
#define REG_TC_CFG_RX2_LPBK_SELECT_WIDTH    3

/* TC_CFG_RX3_LPBK_SELECT */
#define REG_TC_CFG_RX3_LPBK_SELECT          0x0094
#define REG_TC_CFG_RX3_LPBK_SELECT_MASK     0x00070000
#define REG_TC_CFG_RX3_LPBK_SELECT_SHIFT    16
#define REG_TC_CFG_RX3_LPBK_SELECT_WIDTH    3

/* TB_WDATA_TEST_BUS_WRITE_DATA */
#define REG_TB_WDATA_TEST_BUS_WRITE_DATA          0x0098
#define REG_TB_WDATA_TEST_BUS_WRITE_DATA_MASK     0x00ffffff
#define REG_TB_WDATA_TEST_BUS_WRITE_DATA_SHIFT    0
#define REG_TB_WDATA_TEST_BUS_WRITE_DATA_WIDTH    24

/* TB_ENABLE_TEST_BUS_ENABLE */
#define REG_TB_ENABLE_TEST_BUS_ENABLE          0x009C
#define REG_TB_ENABLE_TEST_BUS_ENABLE_MASK     0x00000001
#define REG_TB_ENABLE_TEST_BUS_ENABLE_SHIFT    0
#define REG_TB_ENABLE_TEST_BUS_ENABLE_WIDTH    1

/* TB_ENABLE_TEST_BUS_CLEAR */
#define REG_TB_ENABLE_TEST_BUS_CLEAR          0x009C
#define REG_TB_ENABLE_TEST_BUS_CLEAR_MASK     0x00000002
#define REG_TB_ENABLE_TEST_BUS_CLEAR_SHIFT    1
#define REG_TB_ENABLE_TEST_BUS_CLEAR_WIDTH    1

/* LVDS_SW_RESET_LVDS_SW_RESET */
/* Write "0" to reset, "1" to release */
#define REG_LVDS_SW_RESET_LVDS_SW_RESET          0x00A0
#define REG_LVDS_SW_RESET_LVDS_SW_RESET_MASK     0x00000001
#define REG_LVDS_SW_RESET_LVDS_SW_RESET_SHIFT    0
#define REG_LVDS_SW_RESET_LVDS_SW_RESET_WIDTH    1

/* CPU_EXTRA_BIST_REG_CPU_EXTRA_BIST_RESULT */
#define REG_CPU_EXTRA_BIST_REG_CPU_EXTRA_BIST_RESULT          0x00A4
#define REG_CPU_EXTRA_BIST_REG_CPU_EXTRA_BIST_RESULT_MASK     0x00000003
#define REG_CPU_EXTRA_BIST_REG_CPU_EXTRA_BIST_RESULT_SHIFT    0
#define REG_CPU_EXTRA_BIST_REG_CPU_EXTRA_BIST_RESULT_WIDTH    2

/* MEM_RM_MODIFY_CPU_RM */
#define REG_MEM_RM_MODIFY_CPU_RM          0x00A8
#define REG_MEM_RM_MODIFY_CPU_RM_MASK     0x0000000f
#define REG_MEM_RM_MODIFY_CPU_RM_SHIFT    0
#define REG_MEM_RM_MODIFY_CPU_RM_WIDTH    4

/* MEM_RM_MODIFY_CPU_RME */
#define REG_MEM_RM_MODIFY_CPU_RME          0x00A8
#define REG_MEM_RM_MODIFY_CPU_RME_MASK     0x00000010
#define REG_MEM_RM_MODIFY_CPU_RME_SHIFT    4
#define REG_MEM_RM_MODIFY_CPU_RME_WIDTH    1

/* UCPU_32K_BLOCKS_UCPU_32K_BLOCKS */
/* Secured Write */
#define REG_UCPU_32K_BLOCKS_UCPU_32K_BLOCKS          0x00AC
#define REG_UCPU_32K_BLOCKS_UCPU_32K_BLOCKS_MASK     0x00000007
#define REG_UCPU_32K_BLOCKS_UCPU_32K_BLOCKS_SHIFT    0
#define REG_UCPU_32K_BLOCKS_UCPU_32K_BLOCKS_WIDTH    3

/* CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_BYPASS */
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_BYPASS          0x00B8
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_BYPASS_MASK     0x0000000f
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_BYPASS_SHIFT    0
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_BYPASS_WIDTH    4

/* CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_ENABLE */
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_ENABLE          0x00B8
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_ENABLE_MASK     0x000000f0
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_ENABLE_SHIFT    4
#define REG_CPU_SPARE_GC_CONTROL_CPU_SPARE_GC_ENABLE_WIDTH    4

/* PHY_CLK_SEL_PHY_CLK_SEL */
#define REG_PHY_CLK_SEL_PHY_CLK_SEL          0x00BC
#define REG_PHY_CLK_SEL_PHY_CLK_SEL_MASK     0x00000001
#define REG_PHY_CLK_SEL_PHY_CLK_SEL_SHIFT    0
#define REG_PHY_CLK_SEL_PHY_CLK_SEL_WIDTH    1

/* CPU_GPR_CPU_GPR */
#define REG_CPU_GPR_CPU_GPR          0x00C0
#define REG_CPU_GPR_CPU_GPR_MASK     0xffffffff
#define REG_CPU_GPR_CPU_GPR_SHIFT    0
#define REG_CPU_GPR_CPU_GPR_WIDTH    32

/* CPU_GPO_CPU_GPO */
#define REG_CPU_GPO_CPU_GPO          0x00C4
#define REG_CPU_GPO_CPU_GPO_MASK     0x0000ffff
#define REG_CPU_GPO_CPU_GPO_SHIFT    0
#define REG_CPU_GPO_CPU_GPO_WIDTH    16

/* CPU_GPI1_CPU_GPI1 */
#define REG_CPU_GPI1_CPU_GPI1          0x00C8
#define REG_CPU_GPI1_CPU_GPI1_MASK     0x0000ffff
#define REG_CPU_GPI1_CPU_GPI1_SHIFT    0
#define REG_CPU_GPI1_CPU_GPI1_WIDTH    16

/* CPU_GPI2_CPU_GPI2 */
#define REG_CPU_GPI2_CPU_GPI2          0x00CC
#define REG_CPU_GPI2_CPU_GPI2_MASK     0x0000ffff
#define REG_CPU_GPI2_CPU_GPI2_SHIFT    0
#define REG_CPU_GPI2_CPU_GPI2_WIDTH    16

/* RAM_CTL_ADDR_MEM_GLOBAL_RM */
#define REG_RAM_CTL_ADDR_MEM_GLOBAL_RM          0x00D0
#define REG_RAM_CTL_ADDR_MEM_GLOBAL_RM_MASK     0x0000000c
#define REG_RAM_CTL_ADDR_MEM_GLOBAL_RM_SHIFT    2
#define REG_RAM_CTL_ADDR_MEM_GLOBAL_RM_WIDTH    2

/* M4K_RAMS_RM_M4K_RAMS_RM */
#define REG_M4K_RAMS_RM_M4K_RAMS_RM          0x00D4
#define REG_M4K_RAMS_RM_M4K_RAMS_RM_MASK     0x07777777
#define REG_M4K_RAMS_RM_M4K_RAMS_RM_SHIFT    0
#define REG_M4K_RAMS_RM_M4K_RAMS_RM_WIDTH    21

/* IRAM_RM_IRAM_RM */
#define REG_IRAM_RM_IRAM_RM          0x00D8
#define REG_IRAM_RM_IRAM_RM_MASK     0x77777777
#define REG_IRAM_RM_IRAM_RM_SHIFT    0
#define REG_IRAM_RM_IRAM_RM_WIDTH    24

/* ERAM_RM_ERAM_RM */
#define REG_ERAM_RM_ERAM_RM          0x00DC
#define REG_ERAM_RM_ERAM_RM_MASK     0x00777777
#define REG_ERAM_RM_ERAM_RM_SHIFT    0
#define REG_ERAM_RM_ERAM_RM_WIDTH    18

/* SPARE_CONFIG_MAC_IN_SPARE_CONFIG_MAC_IN */
#define REG_SPARE_CONFIG_MAC_IN_SPARE_CONFIG_MAC_IN          0x00F0
#define REG_SPARE_CONFIG_MAC_IN_SPARE_CONFIG_MAC_IN_MASK     0x0000ffff
#define REG_SPARE_CONFIG_MAC_IN_SPARE_CONFIG_MAC_IN_SHIFT    0
#define REG_SPARE_CONFIG_MAC_IN_SPARE_CONFIG_MAC_IN_WIDTH    16

/* SPARE_CONFIG_MAC_OUT_SPARE_CONFIG_MAC_OUT */
#define REG_SPARE_CONFIG_MAC_OUT_SPARE_CONFIG_MAC_OUT          0x00F4
#define REG_SPARE_CONFIG_MAC_OUT_SPARE_CONFIG_MAC_OUT_MASK     0x0000ffff
#define REG_SPARE_CONFIG_MAC_OUT_SPARE_CONFIG_MAC_OUT_SHIFT    0
#define REG_SPARE_CONFIG_MAC_OUT_SPARE_CONFIG_MAC_OUT_WIDTH    16

/* SWDOG_BOOT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_NMI */
/* Secure write */
#define REG_SWDOG_BOOT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_NMI          0x0100
#define REG_SWDOG_BOOT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_NMI_MASK     0xffffffff
#define REG_SWDOG_BOOT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_NMI_SHIFT    0
#define REG_SWDOG_BOOT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_NMI_WIDTH    32

/* SWDOG_INT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_IRQ */
/* Secure write */
#define REG_SWDOG_INT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_IRQ          0x0104
#define REG_SWDOG_INT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_IRQ_MASK     0xffffffff
#define REG_SWDOG_INT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_IRQ_SHIFT    0
#define REG_SWDOG_INT_CNT_SW_WATCHDOG_COUNT_VALUE_FOR_IRQ_WIDTH    32

/* SWDOG_MASK_SW_WATCHDOG_MASK */
#define REG_SWDOG_MASK_SW_WATCHDOG_MASK          0x0108
#define REG_SWDOG_MASK_SW_WATCHDOG_MASK_MASK     0x00000001
#define REG_SWDOG_MASK_SW_WATCHDOG_MASK_SHIFT    0
#define REG_SWDOG_MASK_SW_WATCHDOG_MASK_WIDTH    1

/* SWDOG_BOOT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_NMI */
#define REG_SWDOG_BOOT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_NMI          0x010C
#define REG_SWDOG_BOOT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_NMI_MASK     0xffffffff
#define REG_SWDOG_BOOT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_NMI_SHIFT    0
#define REG_SWDOG_BOOT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_NMI_WIDTH    32

/* SWDOG_INT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_IRQ */
#define REG_SWDOG_INT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_IRQ          0x0110
#define REG_SWDOG_INT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_IRQ_MASK     0xffffffff
#define REG_SWDOG_INT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_IRQ_SHIFT    0
#define REG_SWDOG_INT_CTR_SW_WATCHDOG_COUNTER_VALUE_FOR_IRQ_WIDTH    32

/*  MAC_TO_PHY_RESET_N_ MAC_TO_PHY_RESET_N */
#define REG_MAC_TO_PHY_RESET_N          0x0114
#define REG_MAC_TO_PHY_RESET_N_MASK     0x00000001
#define REG_MAC_TO_PHY_RESET_N_SHIFT    0
#define REG_MAC_TO_PHY_RESET_N_WIDTH    1

/* IRQ_MASK_IRQ_MASK */
#define REG_IRQ_MASK_IRQ_MASK          0x0140
#define REG_IRQ_MASK_IRQ_MASK_MASK     0xfffffffe
#define REG_IRQ_MASK_IRQ_MASK_SHIFT    1
#define REG_IRQ_MASK_IRQ_MASK_WIDTH    31

/* IRQ_SEC_RF_USE_SECOND_REGISTER_FILE_FOR_IRQS */
#define REG_IRQ_SEC_RF_USE_SECOND_REGISTER_FILE_FOR_IRQS          0x0144
#define REG_IRQ_SEC_RF_USE_SECOND_REGISTER_FILE_FOR_IRQS_MASK     0x7fffffff
#define REG_IRQ_SEC_RF_USE_SECOND_REGISTER_FILE_FOR_IRQS_SHIFT    0
#define REG_IRQ_SEC_RF_USE_SECOND_REGISTER_FILE_FOR_IRQS_WIDTH    31

/* IRQ_MAP_00_IRQ_SOURCE_01_MAPPING */
#define REG_IRQ_MAP_00_IRQ_SOURCE_01_MAPPING          0x0148
#define REG_IRQ_MAP_00_IRQ_SOURCE_01_MAPPING_MASK     0x0000001f
#define REG_IRQ_MAP_00_IRQ_SOURCE_01_MAPPING_SHIFT    0
#define REG_IRQ_MAP_00_IRQ_SOURCE_01_MAPPING_WIDTH    5

/* IRQ_MAP_00_IRQ_SOURCE_02_MAPPING */
#define REG_IRQ_MAP_00_IRQ_SOURCE_02_MAPPING          0x0148
#define REG_IRQ_MAP_00_IRQ_SOURCE_02_MAPPING_MASK     0x000003e0
#define REG_IRQ_MAP_00_IRQ_SOURCE_02_MAPPING_SHIFT    5
#define REG_IRQ_MAP_00_IRQ_SOURCE_02_MAPPING_WIDTH    5

/* IRQ_MAP_00_IRQ_SOURCE_03_MAPPING */
#define REG_IRQ_MAP_00_IRQ_SOURCE_03_MAPPING          0x0148
#define REG_IRQ_MAP_00_IRQ_SOURCE_03_MAPPING_MASK     0x00007c00
#define REG_IRQ_MAP_00_IRQ_SOURCE_03_MAPPING_SHIFT    10
#define REG_IRQ_MAP_00_IRQ_SOURCE_03_MAPPING_WIDTH    5

/* IRQ_MAP_00_IRQ_SOURCE_04_MAPPING */
#define REG_IRQ_MAP_00_IRQ_SOURCE_04_MAPPING          0x0148
#define REG_IRQ_MAP_00_IRQ_SOURCE_04_MAPPING_MASK     0x000f8000
#define REG_IRQ_MAP_00_IRQ_SOURCE_04_MAPPING_SHIFT    15
#define REG_IRQ_MAP_00_IRQ_SOURCE_04_MAPPING_WIDTH    5

/* IRQ_MAP_00_IRQ_SOURCE_05_MAPPING */
#define REG_IRQ_MAP_00_IRQ_SOURCE_05_MAPPING          0x0148
#define REG_IRQ_MAP_00_IRQ_SOURCE_05_MAPPING_MASK     0x01f00000
#define REG_IRQ_MAP_00_IRQ_SOURCE_05_MAPPING_SHIFT    20
#define REG_IRQ_MAP_00_IRQ_SOURCE_05_MAPPING_WIDTH    5

/* IRQ_MAP_00_IRQ_SOURCE_06_MAPPING */
#define REG_IRQ_MAP_00_IRQ_SOURCE_06_MAPPING          0x0148
#define REG_IRQ_MAP_00_IRQ_SOURCE_06_MAPPING_MASK     0x3e000000
#define REG_IRQ_MAP_00_IRQ_SOURCE_06_MAPPING_SHIFT    25
#define REG_IRQ_MAP_00_IRQ_SOURCE_06_MAPPING_WIDTH    5

/* IRQ_MAP_01_IRQ_SOURCE_07_MAPPING */
#define REG_IRQ_MAP_01_IRQ_SOURCE_07_MAPPING          0x014C
#define REG_IRQ_MAP_01_IRQ_SOURCE_07_MAPPING_MASK     0x0000001f
#define REG_IRQ_MAP_01_IRQ_SOURCE_07_MAPPING_SHIFT    0
#define REG_IRQ_MAP_01_IRQ_SOURCE_07_MAPPING_WIDTH    5

/* IRQ_MAP_01_IRQ_SOURCE_08_MAPPING */
#define REG_IRQ_MAP_01_IRQ_SOURCE_08_MAPPING          0x014C
#define REG_IRQ_MAP_01_IRQ_SOURCE_08_MAPPING_MASK     0x000003e0
#define REG_IRQ_MAP_01_IRQ_SOURCE_08_MAPPING_SHIFT    5
#define REG_IRQ_MAP_01_IRQ_SOURCE_08_MAPPING_WIDTH    5

/* IRQ_MAP_01_IRQ_SOURCE_09_MAPPING */
#define REG_IRQ_MAP_01_IRQ_SOURCE_09_MAPPING          0x014C
#define REG_IRQ_MAP_01_IRQ_SOURCE_09_MAPPING_MASK     0x00007c00
#define REG_IRQ_MAP_01_IRQ_SOURCE_09_MAPPING_SHIFT    10
#define REG_IRQ_MAP_01_IRQ_SOURCE_09_MAPPING_WIDTH    5

/* IRQ_MAP_01_IRQ_SOURCE_10_MAPPING */
#define REG_IRQ_MAP_01_IRQ_SOURCE_10_MAPPING          0x014C
#define REG_IRQ_MAP_01_IRQ_SOURCE_10_MAPPING_MASK     0x000f8000
#define REG_IRQ_MAP_01_IRQ_SOURCE_10_MAPPING_SHIFT    15
#define REG_IRQ_MAP_01_IRQ_SOURCE_10_MAPPING_WIDTH    5

/* IRQ_MAP_01_IRQ_SOURCE_11_MAPPING */
#define REG_IRQ_MAP_01_IRQ_SOURCE_11_MAPPING          0x014C
#define REG_IRQ_MAP_01_IRQ_SOURCE_11_MAPPING_MASK     0x01f00000
#define REG_IRQ_MAP_01_IRQ_SOURCE_11_MAPPING_SHIFT    20
#define REG_IRQ_MAP_01_IRQ_SOURCE_11_MAPPING_WIDTH    5

/* IRQ_MAP_01_IRQ_SOURCE_12_MAPPING */
#define REG_IRQ_MAP_01_IRQ_SOURCE_12_MAPPING          0x014C
#define REG_IRQ_MAP_01_IRQ_SOURCE_12_MAPPING_MASK     0x3e000000
#define REG_IRQ_MAP_01_IRQ_SOURCE_12_MAPPING_SHIFT    25
#define REG_IRQ_MAP_01_IRQ_SOURCE_12_MAPPING_WIDTH    5

/* IRQ_MAP_02_IRQ_SOURCE_13_MAPPING */
#define REG_IRQ_MAP_02_IRQ_SOURCE_13_MAPPING          0x0150
#define REG_IRQ_MAP_02_IRQ_SOURCE_13_MAPPING_MASK     0x0000001f
#define REG_IRQ_MAP_02_IRQ_SOURCE_13_MAPPING_SHIFT    0
#define REG_IRQ_MAP_02_IRQ_SOURCE_13_MAPPING_WIDTH    5

/* IRQ_MAP_02_IRQ_SOURCE_14_MAPPING */
#define REG_IRQ_MAP_02_IRQ_SOURCE_14_MAPPING          0x0150
#define REG_IRQ_MAP_02_IRQ_SOURCE_14_MAPPING_MASK     0x000003e0
#define REG_IRQ_MAP_02_IRQ_SOURCE_14_MAPPING_SHIFT    5
#define REG_IRQ_MAP_02_IRQ_SOURCE_14_MAPPING_WIDTH    5

/* IRQ_MAP_02_IRQ_SOURCE_15_MAPPING */
#define REG_IRQ_MAP_02_IRQ_SOURCE_15_MAPPING          0x0150
#define REG_IRQ_MAP_02_IRQ_SOURCE_15_MAPPING_MASK     0x00007c00
#define REG_IRQ_MAP_02_IRQ_SOURCE_15_MAPPING_SHIFT    10
#define REG_IRQ_MAP_02_IRQ_SOURCE_15_MAPPING_WIDTH    5

/* IRQ_MAP_02_IRQ_SOURCE_16_MAPPING */
#define REG_IRQ_MAP_02_IRQ_SOURCE_16_MAPPING          0x0150
#define REG_IRQ_MAP_02_IRQ_SOURCE_16_MAPPING_MASK     0x000f8000
#define REG_IRQ_MAP_02_IRQ_SOURCE_16_MAPPING_SHIFT    15
#define REG_IRQ_MAP_02_IRQ_SOURCE_16_MAPPING_WIDTH    5

/* IRQ_MAP_02_IRQ_SOURCE_17_MAPPING */
#define REG_IRQ_MAP_02_IRQ_SOURCE_17_MAPPING          0x0150
#define REG_IRQ_MAP_02_IRQ_SOURCE_17_MAPPING_MASK     0x01f00000
#define REG_IRQ_MAP_02_IRQ_SOURCE_17_MAPPING_SHIFT    20
#define REG_IRQ_MAP_02_IRQ_SOURCE_17_MAPPING_WIDTH    5

/* IRQ_MAP_02_IRQ_SOURCE_18_MAPPING */
#define REG_IRQ_MAP_02_IRQ_SOURCE_18_MAPPING          0x0150
#define REG_IRQ_MAP_02_IRQ_SOURCE_18_MAPPING_MASK     0x3e000000
#define REG_IRQ_MAP_02_IRQ_SOURCE_18_MAPPING_SHIFT    25
#define REG_IRQ_MAP_02_IRQ_SOURCE_18_MAPPING_WIDTH    5

/* IRQ_MAP_03_IRQ_SOURCE_19_MAPPING */
#define REG_IRQ_MAP_03_IRQ_SOURCE_19_MAPPING          0x0154
#define REG_IRQ_MAP_03_IRQ_SOURCE_19_MAPPING_MASK     0x0000001f
#define REG_IRQ_MAP_03_IRQ_SOURCE_19_MAPPING_SHIFT    0
#define REG_IRQ_MAP_03_IRQ_SOURCE_19_MAPPING_WIDTH    5

/* IRQ_MAP_03_IRQ_SOURCE_20_MAPPING */
#define REG_IRQ_MAP_03_IRQ_SOURCE_20_MAPPING          0x0154
#define REG_IRQ_MAP_03_IRQ_SOURCE_20_MAPPING_MASK     0x000003e0
#define REG_IRQ_MAP_03_IRQ_SOURCE_20_MAPPING_SHIFT    5
#define REG_IRQ_MAP_03_IRQ_SOURCE_20_MAPPING_WIDTH    5

/* IRQ_MAP_03_IRQ_SOURCE_21_MAPPING */
#define REG_IRQ_MAP_03_IRQ_SOURCE_21_MAPPING          0x0154
#define REG_IRQ_MAP_03_IRQ_SOURCE_21_MAPPING_MASK     0x00007c00
#define REG_IRQ_MAP_03_IRQ_SOURCE_21_MAPPING_SHIFT    10
#define REG_IRQ_MAP_03_IRQ_SOURCE_21_MAPPING_WIDTH    5

/* IRQ_MAP_03_IRQ_SOURCE_22_MAPPING */
#define REG_IRQ_MAP_03_IRQ_SOURCE_22_MAPPING          0x0154
#define REG_IRQ_MAP_03_IRQ_SOURCE_22_MAPPING_MASK     0x000f8000
#define REG_IRQ_MAP_03_IRQ_SOURCE_22_MAPPING_SHIFT    15
#define REG_IRQ_MAP_03_IRQ_SOURCE_22_MAPPING_WIDTH    5

/* IRQ_MAP_03_IRQ_SOURCE_23_MAPPING */
#define REG_IRQ_MAP_03_IRQ_SOURCE_23_MAPPING          0x0154
#define REG_IRQ_MAP_03_IRQ_SOURCE_23_MAPPING_MASK     0x01f00000
#define REG_IRQ_MAP_03_IRQ_SOURCE_23_MAPPING_SHIFT    20
#define REG_IRQ_MAP_03_IRQ_SOURCE_23_MAPPING_WIDTH    5

/* IRQ_MAP_03_IRQ_SOURCE_24_MAPPING */
#define REG_IRQ_MAP_03_IRQ_SOURCE_24_MAPPING          0x0154
#define REG_IRQ_MAP_03_IRQ_SOURCE_24_MAPPING_MASK     0x3e000000
#define REG_IRQ_MAP_03_IRQ_SOURCE_24_MAPPING_SHIFT    25
#define REG_IRQ_MAP_03_IRQ_SOURCE_24_MAPPING_WIDTH    5

/* IRQ_MAP_04_IRQ_SOURCE_25_MAPPING */
#define REG_IRQ_MAP_04_IRQ_SOURCE_25_MAPPING          0x0158
#define REG_IRQ_MAP_04_IRQ_SOURCE_25_MAPPING_MASK     0x0000001f
#define REG_IRQ_MAP_04_IRQ_SOURCE_25_MAPPING_SHIFT    0
#define REG_IRQ_MAP_04_IRQ_SOURCE_25_MAPPING_WIDTH    5

/* IRQ_MAP_04_IRQ_SOURCE_26_MAPPING */
#define REG_IRQ_MAP_04_IRQ_SOURCE_26_MAPPING          0x0158
#define REG_IRQ_MAP_04_IRQ_SOURCE_26_MAPPING_MASK     0x000003e0
#define REG_IRQ_MAP_04_IRQ_SOURCE_26_MAPPING_SHIFT    5
#define REG_IRQ_MAP_04_IRQ_SOURCE_26_MAPPING_WIDTH    5

/* IRQ_MAP_04_IRQ_SOURCE_27_MAPPING */
#define REG_IRQ_MAP_04_IRQ_SOURCE_27_MAPPING          0x0158
#define REG_IRQ_MAP_04_IRQ_SOURCE_27_MAPPING_MASK     0x00007c00
#define REG_IRQ_MAP_04_IRQ_SOURCE_27_MAPPING_SHIFT    10
#define REG_IRQ_MAP_04_IRQ_SOURCE_27_MAPPING_WIDTH    5

/* IRQ_MAP_04_IRQ_SOURCE_28_MAPPING */
#define REG_IRQ_MAP_04_IRQ_SOURCE_28_MAPPING          0x0158
#define REG_IRQ_MAP_04_IRQ_SOURCE_28_MAPPING_MASK     0x000f8000
#define REG_IRQ_MAP_04_IRQ_SOURCE_28_MAPPING_SHIFT    15
#define REG_IRQ_MAP_04_IRQ_SOURCE_28_MAPPING_WIDTH    5

/* IRQ_MAP_04_IRQ_SOURCE_29_MAPPING */
#define REG_IRQ_MAP_04_IRQ_SOURCE_29_MAPPING          0x0158
#define REG_IRQ_MAP_04_IRQ_SOURCE_29_MAPPING_MASK     0x01f00000
#define REG_IRQ_MAP_04_IRQ_SOURCE_29_MAPPING_SHIFT    20
#define REG_IRQ_MAP_04_IRQ_SOURCE_29_MAPPING_WIDTH    5

/* IRQ_MAP_04_IRQ_SOURCE_30_MAPPING */
#define REG_IRQ_MAP_04_IRQ_SOURCE_30_MAPPING          0x0158
#define REG_IRQ_MAP_04_IRQ_SOURCE_30_MAPPING_MASK     0x3e000000
#define REG_IRQ_MAP_04_IRQ_SOURCE_30_MAPPING_SHIFT    25
#define REG_IRQ_MAP_04_IRQ_SOURCE_30_MAPPING_WIDTH    5

/* IRQ_MAP_05_IRQ_SOURCE_31_MAPPING */
#define REG_IRQ_MAP_05_IRQ_SOURCE_31_MAPPING          0x015C
#define REG_IRQ_MAP_05_IRQ_SOURCE_31_MAPPING_MASK     0x0000001f
#define REG_IRQ_MAP_05_IRQ_SOURCE_31_MAPPING_SHIFT    0
#define REG_IRQ_MAP_05_IRQ_SOURCE_31_MAPPING_WIDTH    5

/* IRQ_MAPPED_MAPPED_IRQS_FROM_MAPPER */
#define REG_IRQ_MAPPED_MAPPED_IRQS_FROM_MAPPER          0x0160
#define REG_IRQ_MAPPED_MAPPED_IRQS_FROM_MAPPER_MASK     0xffffffff
#define REG_IRQ_MAPPED_MAPPED_IRQS_FROM_MAPPER_SHIFT    0
#define REG_IRQ_MAPPED_MAPPED_IRQS_FROM_MAPPER_WIDTH    32

/* IRQ_UNMAPPED_UNMAPPED_IRQS_TO_MAPPER */
#define REG_IRQ_UNMAPPED_UNMAPPED_IRQS_TO_MAPPER          0x0164
#define REG_IRQ_UNMAPPED_UNMAPPED_IRQS_TO_MAPPER_MASK     0x7fffffff
#define REG_IRQ_UNMAPPED_UNMAPPED_IRQS_TO_MAPPER_SHIFT    0
#define REG_IRQ_UNMAPPED_UNMAPPED_IRQS_TO_MAPPER_WIDTH    31

/* INTER_CPU_IRQ_IRQ_REQUEST_TO_OTHER_CPU */
#define REG_INTER_CPU_IRQ_IRQ_REQUEST_TO_OTHER_CPU          0x0168
#define REG_INTER_CPU_IRQ_IRQ_REQUEST_TO_OTHER_CPU_MASK     0x00000001
#define REG_INTER_CPU_IRQ_IRQ_REQUEST_TO_OTHER_CPU_SHIFT    0
#define REG_INTER_CPU_IRQ_IRQ_REQUEST_TO_OTHER_CPU_WIDTH    1

/* INTER_CPU_IRQ_IRQ_CLEAR_TO_OTHER_CPU */
#define REG_INTER_CPU_IRQ_IRQ_CLEAR_TO_OTHER_CPU          0x0168
#define REG_INTER_CPU_IRQ_IRQ_CLEAR_TO_OTHER_CPU_MASK     0x00000002
#define REG_INTER_CPU_IRQ_IRQ_CLEAR_TO_OTHER_CPU_SHIFT    1
#define REG_INTER_CPU_IRQ_IRQ_CLEAR_TO_OTHER_CPU_WIDTH    1

/* HOST_IRQ_IRQ_TO_EXTERNAL_HOST */
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST          0x016C
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_MASK     0x00000001
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_SHIFT    0
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_WIDTH    1

/* HOST_IRQ_IRQ_TO_EXTERNAL_HOST_OUTPUT_ENABLE */
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_OUTPUT_ENABLE          0x016C
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_OUTPUT_ENABLE_MASK     0x00000002
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_OUTPUT_ENABLE_SHIFT    1
#define REG_HOST_IRQ_IRQ_TO_EXTERNAL_HOST_OUTPUT_ENABLE_WIDTH    1

/* TIMERS_IRQ_EN_TIMER0_IRQ_EN */
#define REG_TIMERS_IRQ_EN_TIMER0_IRQ_EN          0x0174
#define REG_TIMERS_IRQ_EN_TIMER0_IRQ_EN_MASK     0x00000001
#define REG_TIMERS_IRQ_EN_TIMER0_IRQ_EN_SHIFT    0
#define REG_TIMERS_IRQ_EN_TIMER0_IRQ_EN_WIDTH    1

/* TIMERS_IRQ_EN_TIMER1_IRQ_EN */
#define REG_TIMERS_IRQ_EN_TIMER1_IRQ_EN          0x0174
#define REG_TIMERS_IRQ_EN_TIMER1_IRQ_EN_MASK     0x00000002
#define REG_TIMERS_IRQ_EN_TIMER1_IRQ_EN_SHIFT    1
#define REG_TIMERS_IRQ_EN_TIMER1_IRQ_EN_WIDTH    1

/* TIMERS_IRQ_EN_TIMER2_IRQ_EN */
#define REG_TIMERS_IRQ_EN_TIMER2_IRQ_EN          0x0174
#define REG_TIMERS_IRQ_EN_TIMER2_IRQ_EN_MASK     0x00000004
#define REG_TIMERS_IRQ_EN_TIMER2_IRQ_EN_SHIFT    2
#define REG_TIMERS_IRQ_EN_TIMER2_IRQ_EN_WIDTH    1

/* TIMERS_IRQ_EN_TIMER3_IRQ_EN */
#define REG_TIMERS_IRQ_EN_TIMER3_IRQ_EN          0x0174
#define REG_TIMERS_IRQ_EN_TIMER3_IRQ_EN_MASK     0x00000008
#define REG_TIMERS_IRQ_EN_TIMER3_IRQ_EN_SHIFT    3
#define REG_TIMERS_IRQ_EN_TIMER3_IRQ_EN_WIDTH    1

/* TIMER0_PRESCALER_TIMER0_PRESCALER */
#define REG_TIMER0_PRESCALER_TIMER0_PRESCALER          0x0178
#define REG_TIMER0_PRESCALER_TIMER0_PRESCALER_MASK     0x00000fff
#define REG_TIMER0_PRESCALER_TIMER0_PRESCALER_SHIFT    0
#define REG_TIMER0_PRESCALER_TIMER0_PRESCALER_WIDTH    12

/* TIMER0_PRESCALER_RF_T0_PRESCALE_VALUE */
#define REG_TIMER0_PRESCALER_RF_T0_PRESCALE_VALUE          0x0178
#define REG_TIMER0_PRESCALER_RF_T0_PRESCALE_VALUE_MASK     0x0fff0000
#define REG_TIMER0_PRESCALER_RF_T0_PRESCALE_VALUE_SHIFT    16
#define REG_TIMER0_PRESCALER_RF_T0_PRESCALE_VALUE_WIDTH    12

/* TIMER1_PRESCALER_TIMER1_PRESCALER */
#define REG_TIMER1_PRESCALER_TIMER1_PRESCALER          0x017C
#define REG_TIMER1_PRESCALER_TIMER1_PRESCALER_MASK     0x00000fff
#define REG_TIMER1_PRESCALER_TIMER1_PRESCALER_SHIFT    0
#define REG_TIMER1_PRESCALER_TIMER1_PRESCALER_WIDTH    12

/* TIMER1_PRESCALER_RF_T1_PRESCALE_VALUE */
#define REG_TIMER1_PRESCALER_RF_T1_PRESCALE_VALUE          0x017C
#define REG_TIMER1_PRESCALER_RF_T1_PRESCALE_VALUE_MASK     0x0fff0000
#define REG_TIMER1_PRESCALER_RF_T1_PRESCALE_VALUE_SHIFT    16
#define REG_TIMER1_PRESCALER_RF_T1_PRESCALE_VALUE_WIDTH    12

/* TIMER0_MAX_COUNT_TIMER_0_MAX_COUNT */
#define REG_TIMER0_MAX_COUNT_TIMER_0_MAX_COUNT          0x0180
#define REG_TIMER0_MAX_COUNT_TIMER_0_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER0_MAX_COUNT_TIMER_0_MAX_COUNT_SHIFT    0
#define REG_TIMER0_MAX_COUNT_TIMER_0_MAX_COUNT_WIDTH    32

/* TIMER1_MAX_COUNT_TIMER_1_MAX_COUNT */
#define REG_TIMER1_MAX_COUNT_TIMER_1_MAX_COUNT          0x0184
#define REG_TIMER1_MAX_COUNT_TIMER_1_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER1_MAX_COUNT_TIMER_1_MAX_COUNT_SHIFT    0
#define REG_TIMER1_MAX_COUNT_TIMER_1_MAX_COUNT_WIDTH    32

/* TIMER2_MAX_COUNT_TIMER_2_MAX_COUNT */
#define REG_TIMER2_MAX_COUNT_TIMER_2_MAX_COUNT          0x0188
#define REG_TIMER2_MAX_COUNT_TIMER_2_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER2_MAX_COUNT_TIMER_2_MAX_COUNT_SHIFT    0
#define REG_TIMER2_MAX_COUNT_TIMER_2_MAX_COUNT_WIDTH    32

/* TIMER3_MAX_COUNT_TIMER_3_MAX_COUNT */
#define REG_TIMER3_MAX_COUNT_TIMER_3_MAX_COUNT          0x018C
#define REG_TIMER3_MAX_COUNT_TIMER_3_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER3_MAX_COUNT_TIMER_3_MAX_COUNT_SHIFT    0
#define REG_TIMER3_MAX_COUNT_TIMER_3_MAX_COUNT_WIDTH    32

/* TIMER0_CTR_TIMER_0_COUNT_VALUE */
#define REG_TIMER0_CTR_TIMER_0_COUNT_VALUE          0x0190
#define REG_TIMER0_CTR_TIMER_0_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER0_CTR_TIMER_0_COUNT_VALUE_SHIFT    0
#define REG_TIMER0_CTR_TIMER_0_COUNT_VALUE_WIDTH    32

/* TIMER1_CTR_TIMER_1_COUNT_VALUE */
#define REG_TIMER1_CTR_TIMER_1_COUNT_VALUE          0x0194
#define REG_TIMER1_CTR_TIMER_1_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER1_CTR_TIMER_1_COUNT_VALUE_SHIFT    0
#define REG_TIMER1_CTR_TIMER_1_COUNT_VALUE_WIDTH    32

/* TIMER2_CTR_TIMER_2_COUNT_VALUE */
#define REG_TIMER2_CTR_TIMER_2_COUNT_VALUE          0x0198
#define REG_TIMER2_CTR_TIMER_2_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER2_CTR_TIMER_2_COUNT_VALUE_SHIFT    0
#define REG_TIMER2_CTR_TIMER_2_COUNT_VALUE_WIDTH    32

/* TIMER3_CTR_TIMER_3_COUNT_VALUE */
#define REG_TIMER3_CTR_TIMER_3_COUNT_VALUE          0x019C
#define REG_TIMER3_CTR_TIMER_3_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER3_CTR_TIMER_3_COUNT_VALUE_SHIFT    0
#define REG_TIMER3_CTR_TIMER_3_COUNT_VALUE_WIDTH    32

/* TIMERS_STATUS_TIMER0_EXPIRED */
/* Write "1" to this bit to clear the indication */
#define REG_TIMERS_STATUS_TIMER0_EXPIRED          0x01A0
#define REG_TIMERS_STATUS_TIMER0_EXPIRED_MASK     0x00000001
#define REG_TIMERS_STATUS_TIMER0_EXPIRED_SHIFT    0
#define REG_TIMERS_STATUS_TIMER0_EXPIRED_WIDTH    1

/* TIMERS_STATUS_TIMER1_EXPIRED */
/* Write "1" to this bit to clear the indication */
#define REG_TIMERS_STATUS_TIMER1_EXPIRED          0x01A0
#define REG_TIMERS_STATUS_TIMER1_EXPIRED_MASK     0x00000002
#define REG_TIMERS_STATUS_TIMER1_EXPIRED_SHIFT    1
#define REG_TIMERS_STATUS_TIMER1_EXPIRED_WIDTH    1

/* TIMERS_STATUS_TIMER2_EXPIRED */
/* Write "1" to this bit to clear the indication */
#define REG_TIMERS_STATUS_TIMER2_EXPIRED          0x01A0
#define REG_TIMERS_STATUS_TIMER2_EXPIRED_MASK     0x00000004
#define REG_TIMERS_STATUS_TIMER2_EXPIRED_SHIFT    2
#define REG_TIMERS_STATUS_TIMER2_EXPIRED_WIDTH    1

/* TIMERS_STATUS_TIMER3_EXPIRED */
/* Write "1" to this bit to clear the indication */
#define REG_TIMERS_STATUS_TIMER3_EXPIRED          0x01A0
#define REG_TIMERS_STATUS_TIMER3_EXPIRED_MASK     0x00000008
#define REG_TIMERS_STATUS_TIMER3_EXPIRED_SHIFT    3
#define REG_TIMERS_STATUS_TIMER3_EXPIRED_WIDTH    1

/* TIMERS_CONFIG_TIMER_0_ONESHOT_MODE */
#define REG_TIMERS_CONFIG_TIMER_0_ONESHOT_MODE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_0_ONESHOT_MODE_MASK     0x00000001
#define REG_TIMERS_CONFIG_TIMER_0_ONESHOT_MODE_SHIFT    0
#define REG_TIMERS_CONFIG_TIMER_0_ONESHOT_MODE_WIDTH    1

/* TIMERS_CONFIG_TIMER_1_ONESHOT_MODE */
#define REG_TIMERS_CONFIG_TIMER_1_ONESHOT_MODE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_1_ONESHOT_MODE_MASK     0x00000002
#define REG_TIMERS_CONFIG_TIMER_1_ONESHOT_MODE_SHIFT    1
#define REG_TIMERS_CONFIG_TIMER_1_ONESHOT_MODE_WIDTH    1

/* TIMERS_CONFIG_TIMER_2_ONESHOT_MODE */
#define REG_TIMERS_CONFIG_TIMER_2_ONESHOT_MODE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_2_ONESHOT_MODE_MASK     0x00000004
#define REG_TIMERS_CONFIG_TIMER_2_ONESHOT_MODE_SHIFT    2
#define REG_TIMERS_CONFIG_TIMER_2_ONESHOT_MODE_WIDTH    1

/* TIMERS_CONFIG_TIMER_3_ONESHOT_MODE */
#define REG_TIMERS_CONFIG_TIMER_3_ONESHOT_MODE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_3_ONESHOT_MODE_MASK     0x00000008
#define REG_TIMERS_CONFIG_TIMER_3_ONESHOT_MODE_SHIFT    3
#define REG_TIMERS_CONFIG_TIMER_3_ONESHOT_MODE_WIDTH    1

/* TIMERS_CONFIG_TIMER_0_ENABLE */
#define REG_TIMERS_CONFIG_TIMER_0_ENABLE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_0_ENABLE_MASK     0x00000010
#define REG_TIMERS_CONFIG_TIMER_0_ENABLE_SHIFT    4
#define REG_TIMERS_CONFIG_TIMER_0_ENABLE_WIDTH    1

/* TIMERS_CONFIG_TIMER_1_ENABLE */
#define REG_TIMERS_CONFIG_TIMER_1_ENABLE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_1_ENABLE_MASK     0x00000020
#define REG_TIMERS_CONFIG_TIMER_1_ENABLE_SHIFT    5
#define REG_TIMERS_CONFIG_TIMER_1_ENABLE_WIDTH    1

/* TIMERS_CONFIG_TIMER_2_ENABLE */
#define REG_TIMERS_CONFIG_TIMER_2_ENABLE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_2_ENABLE_MASK     0x00000040
#define REG_TIMERS_CONFIG_TIMER_2_ENABLE_SHIFT    6
#define REG_TIMERS_CONFIG_TIMER_2_ENABLE_WIDTH    1

/* TIMERS_CONFIG_TIMER_3_ENABLE */
#define REG_TIMERS_CONFIG_TIMER_3_ENABLE          0x01A4
#define REG_TIMERS_CONFIG_TIMER_3_ENABLE_MASK     0x00000080
#define REG_TIMERS_CONFIG_TIMER_3_ENABLE_SHIFT    7
#define REG_TIMERS_CONFIG_TIMER_3_ENABLE_WIDTH    1

/* TIMER2_PRESCALER_TIMER2_PRESCALER */
#define REG_TIMER2_PRESCALER_TIMER2_PRESCALER          0x01A8
#define REG_TIMER2_PRESCALER_TIMER2_PRESCALER_MASK     0x00000fff
#define REG_TIMER2_PRESCALER_TIMER2_PRESCALER_SHIFT    0
#define REG_TIMER2_PRESCALER_TIMER2_PRESCALER_WIDTH    12

/* TIMER2_PRESCALER_RF_T2_PRESCALE_VALUE */
#define REG_TIMER2_PRESCALER_RF_T2_PRESCALE_VALUE          0x01A8
#define REG_TIMER2_PRESCALER_RF_T2_PRESCALE_VALUE_MASK     0x0fff0000
#define REG_TIMER2_PRESCALER_RF_T2_PRESCALE_VALUE_SHIFT    16
#define REG_TIMER2_PRESCALER_RF_T2_PRESCALE_VALUE_WIDTH    12

/* TIMER3_PRESCALER_TIMER3_PRESCALER */
#define REG_TIMER3_PRESCALER_TIMER3_PRESCALER          0x01AC
#define REG_TIMER3_PRESCALER_TIMER3_PRESCALER_MASK     0x00000fff
#define REG_TIMER3_PRESCALER_TIMER3_PRESCALER_SHIFT    0
#define REG_TIMER3_PRESCALER_TIMER3_PRESCALER_WIDTH    12

/* TIMER3_PRESCALER_RF_T3_PRESCALE_VALUE */
#define REG_TIMER3_PRESCALER_RF_T3_PRESCALE_VALUE          0x01AC
#define REG_TIMER3_PRESCALER_RF_T3_PRESCALE_VALUE_MASK     0x0fff0000
#define REG_TIMER3_PRESCALER_RF_T3_PRESCALE_VALUE_SHIFT    16
#define REG_TIMER3_PRESCALER_RF_T3_PRESCALE_VALUE_WIDTH    12

/* USB_PHY_CLK_EN_USB_PHY_CLK_EN */
#define REG_USB_PHY_CLK_EN_USB_PHY_CLK_EN          0x01B0
#define REG_USB_PHY_CLK_EN_USB_PHY_CLK_EN_MASK     0x00000001
#define REG_USB_PHY_CLK_EN_USB_PHY_CLK_EN_SHIFT    0
#define REG_USB_PHY_CLK_EN_USB_PHY_CLK_EN_WIDTH    1

/* MAC_SLOW_CLK_MODE_MAC_SLOW_CLK_MODE */
#define REG_MAC_SLOW_CLK_MODE_MAC_SLOW_CLK_MODE          0x01B4
#define REG_MAC_SLOW_CLK_MODE_MAC_SLOW_CLK_MODE_MASK     0x00000001
#define REG_MAC_SLOW_CLK_MODE_MAC_SLOW_CLK_MODE_SHIFT    0
#define REG_MAC_SLOW_CLK_MODE_MAC_SLOW_CLK_MODE_WIDTH    1

/* IC_HIT_CNT_INSTRUCTION_CACHE_HIT_COUNT */
#define REG_IC_HIT_CNT_INSTRUCTION_CACHE_HIT_COUNT          0x01C0
#define REG_IC_HIT_CNT_INSTRUCTION_CACHE_HIT_COUNT_MASK     0xffffffff
#define REG_IC_HIT_CNT_INSTRUCTION_CACHE_HIT_COUNT_SHIFT    0
#define REG_IC_HIT_CNT_INSTRUCTION_CACHE_HIT_COUNT_WIDTH    32

/* IC_MISS_CNT_INSTRUCTION_CACHE_MISS_COUNT */
#define REG_IC_MISS_CNT_INSTRUCTION_CACHE_MISS_COUNT          0x01C4
#define REG_IC_MISS_CNT_INSTRUCTION_CACHE_MISS_COUNT_MASK     0xffffffff
#define REG_IC_MISS_CNT_INSTRUCTION_CACHE_MISS_COUNT_SHIFT    0
#define REG_IC_MISS_CNT_INSTRUCTION_CACHE_MISS_COUNT_WIDTH    32

/* DC_HIT_CNT_DATA_CACHE_HIT_COUNT */
#define REG_DC_HIT_CNT_DATA_CACHE_HIT_COUNT          0x01C8
#define REG_DC_HIT_CNT_DATA_CACHE_HIT_COUNT_MASK     0xffffffff
#define REG_DC_HIT_CNT_DATA_CACHE_HIT_COUNT_SHIFT    0
#define REG_DC_HIT_CNT_DATA_CACHE_HIT_COUNT_WIDTH    32

/* DC_MISS_CNT_DATA_CACHE_MISS_COUNT */
#define REG_DC_MISS_CNT_DATA_CACHE_MISS_COUNT          0x01CC
#define REG_DC_MISS_CNT_DATA_CACHE_MISS_COUNT_MASK     0xffffffff
#define REG_DC_MISS_CNT_DATA_CACHE_MISS_COUNT_SHIFT    0
#define REG_DC_MISS_CNT_DATA_CACHE_MISS_COUNT_WIDTH    32

/* MIPS_SI_INT_STATUS_SI_SW_IRQ */
#define REG_MIPS_SI_INT_STATUS_SI_SW_IRQ          0x01D0
#define REG_MIPS_SI_INT_STATUS_SI_SW_IRQ_MASK     0x00000003
#define REG_MIPS_SI_INT_STATUS_SI_SW_IRQ_SHIFT    0
#define REG_MIPS_SI_INT_STATUS_SI_SW_IRQ_WIDTH    2

/* MIPS_SI_INT_STATUS_SI_TIMER_IRQ */
#define REG_MIPS_SI_INT_STATUS_SI_TIMER_IRQ          0x01D0
#define REG_MIPS_SI_INT_STATUS_SI_TIMER_IRQ_MASK     0x00000004
#define REG_MIPS_SI_INT_STATUS_SI_TIMER_IRQ_SHIFT    2
#define REG_MIPS_SI_INT_STATUS_SI_TIMER_IRQ_WIDTH    1

/* MIPS_SI_INT_EN_SI_SW_IRQ_EN */
#define REG_MIPS_SI_INT_EN_SI_SW_IRQ_EN          0x01D4
#define REG_MIPS_SI_INT_EN_SI_SW_IRQ_EN_MASK     0x00000003
#define REG_MIPS_SI_INT_EN_SI_SW_IRQ_EN_SHIFT    0
#define REG_MIPS_SI_INT_EN_SI_SW_IRQ_EN_WIDTH    2

/* MIPS_SI_INT_EN_SI_TIMER_IRQ_EN */
#define REG_MIPS_SI_INT_EN_SI_TIMER_IRQ_EN          0x01D4
#define REG_MIPS_SI_INT_EN_SI_TIMER_IRQ_EN_MASK     0x00000004
#define REG_MIPS_SI_INT_EN_SI_TIMER_IRQ_EN_SHIFT    2
#define REG_MIPS_SI_INT_EN_SI_TIMER_IRQ_EN_WIDTH    1

/* HW_EVENTS_INT_STATUS_HW_EVENTS_INTERRUPTS */
#define REG_HW_EVENTS_INT_STATUS_HW_EVENTS_INTERRUPTS          0x01D8
#define REG_HW_EVENTS_INT_STATUS_HW_EVENTS_INTERRUPTS_MASK     0x00ffffff
#define REG_HW_EVENTS_INT_STATUS_HW_EVENTS_INTERRUPTS_SHIFT    0
#define REG_HW_EVENTS_INT_STATUS_HW_EVENTS_INTERRUPTS_WIDTH    24

/* HW_ERRORS_INT_STATUS_HW_ERRORS_INTERRUPTS */
#define REG_HW_ERRORS_INT_STATUS_HW_ERRORS_INTERRUPTS          0x01DC
#define REG_HW_ERRORS_INT_STATUS_HW_ERRORS_INTERRUPTS_MASK     0x00ffffff
#define REG_HW_ERRORS_INT_STATUS_HW_ERRORS_INTERRUPTS_SHIFT    0
#define REG_HW_ERRORS_INT_STATUS_HW_ERRORS_INTERRUPTS_WIDTH    24

/* HW_EVENTS_INT_EN_HW_EVENTS_INT_EN */
#define REG_HW_EVENTS_INT_EN_HW_EVENTS_INT_EN          0x01E0
#define REG_HW_EVENTS_INT_EN_HW_EVENTS_INT_EN_MASK     0x00ffffff
#define REG_HW_EVENTS_INT_EN_HW_EVENTS_INT_EN_SHIFT    0
#define REG_HW_EVENTS_INT_EN_HW_EVENTS_INT_EN_WIDTH    24

/* HW_ERRORS_INT_EN_HW_ERRORS_INT_EN */
#define REG_HW_ERRORS_INT_EN_HW_ERRORS_INT_EN          0x01E4
#define REG_HW_ERRORS_INT_EN_HW_ERRORS_INT_EN_MASK     0x00ffffff
#define REG_HW_ERRORS_INT_EN_HW_ERRORS_INT_EN_SHIFT    0
#define REG_HW_ERRORS_INT_EN_HW_ERRORS_INT_EN_WIDTH    24

/* HW_EVENTS_INT_MASKED_STATUS_HW_EVENTS_INT_MASKED */
#define REG_HW_EVENTS_INT_MASKED_STATUS_HW_EVENTS_INT_MASKED          0x01E8
#define REG_HW_EVENTS_INT_MASKED_STATUS_HW_EVENTS_INT_MASKED_MASK     0x00ffffff
#define REG_HW_EVENTS_INT_MASKED_STATUS_HW_EVENTS_INT_MASKED_SHIFT    0
#define REG_HW_EVENTS_INT_MASKED_STATUS_HW_EVENTS_INT_MASKED_WIDTH    24

/* HW_ERRORS_INT_MASKED_STATUS_HW_ERRORS_INT_MASKED */
#define REG_HW_ERRORS_INT_MASKED_STATUS_HW_ERRORS_INT_MASKED          0x01EC
#define REG_HW_ERRORS_INT_MASKED_STATUS_HW_ERRORS_INT_MASKED_MASK     0x00ffffff
#define REG_HW_ERRORS_INT_MASKED_STATUS_HW_ERRORS_INT_MASKED_SHIFT    0
#define REG_HW_ERRORS_INT_MASKED_STATUS_HW_ERRORS_INT_MASKED_WIDTH    24
#endif 
