/*******************************************************************
*                                                                   
*  MAC_HT_extensions.h
*   Chip Name: 'Hyperion'                                   
*   Do not modify this file directly                                
*   To update the file, modify registers excel file                 
*   and run the macro 'Create H Files for MIPS SW'              
*   Written by: Avri Golan                                          
*                                                                   
*******************************************************************/

/* Production Date: 11/08/2013  */

#ifndef MAC_HT_extensions_regs_H_FILE
#define MAC_HT_extensions_regs_H_FILE

/* TIMER_BLOCK_GCLK */
#define REG_TIMER_BLOCK_GCLK          0x0000
#define REG_TIMER_BLOCK_GCLK_MASK     0x00000001
#define REG_TIMER_BLOCK_GCLK_SHIFT    0
#define REG_TIMER_BLOCK_GCLK_WIDTH    1

/* STATISTICS_GCLK */
#define REG_STATISTICS_GCLK          0x0000
#define REG_STATISTICS_GCLK_MASK     0x00000002
#define REG_STATISTICS_GCLK_SHIFT    1
#define REG_STATISTICS_GCLK_WIDTH    1

/* SEMAPHORE_GCLK */
#define REG_SEMAPHORE_GCLK          0x0000
#define REG_SEMAPHORE_GCLK_MASK     0x00000004
#define REG_SEMAPHORE_GCLK_SHIFT    2
#define REG_SEMAPHORE_GCLK_WIDTH    1

/* DDR_DMA_GCLK */
#define REG_DDR_DMA_GCLK          0x0000
#define REG_DDR_DMA_GCLK_MASK     0x00000020
#define REG_DDR_DMA_GCLK_SHIFT    5
#define REG_DDR_DMA_GCLK_WIDTH    1

/* MAC_GENRISC_TX_GCLK */
#define REG_MAC_GENRISC_TX_GCLK          0x0000
#define REG_MAC_GENRISC_TX_GCLK_MASK     0x00000040
#define REG_MAC_GENRISC_TX_GCLK_SHIFT    6
#define REG_MAC_GENRISC_TX_GCLK_WIDTH    1

/* DELINEATOR_GCLK */
#define REG_DELINEATOR_GCLK          0x0000
#define REG_DELINEATOR_GCLK_MASK     0x00000080
#define REG_DELINEATOR_GCLK_SHIFT    7
#define REG_DELINEATOR_GCLK_WIDTH    1

/* MAC_BLOCK_ACK_GCLK */
#define REG_MAC_BLOCK_ACK_GCLK          0x0000
#define REG_MAC_BLOCK_ACK_GCLK_MASK     0x00000100
#define REG_MAC_BLOCK_ACK_GCLK_SHIFT    8
#define REG_MAC_BLOCK_ACK_GCLK_WIDTH    1

/* TXC_TEST_FIFO_GCLK */
#define REG_TXC_TEST_FIFO_GCLK          0x0000
#define REG_TXC_TEST_FIFO_GCLK_MASK     0x00000200
#define REG_TXC_TEST_FIFO_GCLK_SHIFT    9
#define REG_TXC_TEST_FIFO_GCLK_WIDTH    1

/* MAC_TRAINER_GCLK */
#define REG_MAC_TRAINER_GCLK          0x0000
#define REG_MAC_TRAINER_GCLK_MASK     0x00000400
#define REG_MAC_TRAINER_GCLK_SHIFT    10
#define REG_MAC_TRAINER_GCLK_WIDTH    1

/* MAC_FRAME_END_SYNC_GCLK */
#define REG_MAC_FRAME_END_SYNC_GCLK          0x0000
#define REG_MAC_FRAME_END_SYNC_GCLK_MASK     0x00000800
#define REG_MAC_FRAME_END_SYNC_GCLK_SHIFT    11
#define REG_MAC_FRAME_END_SYNC_GCLK_WIDTH    1

/* MAC_TX_STREAMER_GCLK */
#define REG_MAC_TX_STREAMER_GCLK          0x0000
#define REG_MAC_TX_STREAMER_GCLK_MASK     0x00001000
#define REG_MAC_TX_STREAMER_GCLK_SHIFT    12
#define REG_MAC_TX_STREAMER_GCLK_WIDTH    1

/* MAC_GENRISC_RX_GCLK */
#define REG_MAC_GENRISC_RX_GCLK          0x0000
#define REG_MAC_GENRISC_RX_GCLK_MASK     0x00002000
#define REG_MAC_GENRISC_RX_GCLK_SHIFT    13
#define REG_MAC_GENRISC_RX_GCLK_WIDTH    1

/* MAC_GENRISC_HOST_GCLK */
#define REG_MAC_GENRISC_HOST_GCLK          0x0000
#define REG_MAC_GENRISC_HOST_GCLK_MASK     0x00004000
#define REG_MAC_GENRISC_HOST_GCLK_SHIFT    14
#define REG_MAC_GENRISC_HOST_GCLK_WIDTH    1

/* TIMER_BLOCK_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_TIMER_BLOCK_SW_RESET          0x0004
#define REG_TIMER_BLOCK_SW_RESET_MASK     0x00000001
#define REG_TIMER_BLOCK_SW_RESET_SHIFT    0
#define REG_TIMER_BLOCK_SW_RESET_WIDTH    1

/* STATISTICS_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_STATISTICS_SW_RESET          0x0004
#define REG_STATISTICS_SW_RESET_MASK     0x00000002
#define REG_STATISTICS_SW_RESET_SHIFT    1
#define REG_STATISTICS_SW_RESET_WIDTH    1

/* SEMAPHORE_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_SEMAPHORE_SW_RESET          0x0004
#define REG_SEMAPHORE_SW_RESET_MASK     0x00000004
#define REG_SEMAPHORE_SW_RESET_SHIFT    2
#define REG_SEMAPHORE_SW_RESET_WIDTH    1

/* DDR_DMA_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_DDR_DMA_SW_RESET          0x0004
#define REG_DDR_DMA_SW_RESET_MASK     0x00000020
#define REG_DDR_DMA_SW_RESET_SHIFT    5
#define REG_DDR_DMA_SW_RESET_WIDTH    1

/* MAC_GENRISC_TX_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_GENRISC_TX_SW_RESET          0x0004
#define REG_MAC_GENRISC_TX_SW_RESET_MASK     0x00000040
#define REG_MAC_GENRISC_TX_SW_RESET_SHIFT    6
#define REG_MAC_GENRISC_TX_SW_RESET_WIDTH    1

/* DELINEATOR_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_DELINEATOR_SW_RESET          0x0004
#define REG_DELINEATOR_SW_RESET_MASK     0x00000080
#define REG_DELINEATOR_SW_RESET_SHIFT    7
#define REG_DELINEATOR_SW_RESET_WIDTH    1

/* MAC_BLOCK_ACK_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_BLOCK_ACK_SW_RESET          0x0004
#define REG_MAC_BLOCK_ACK_SW_RESET_MASK     0x00000100
#define REG_MAC_BLOCK_ACK_SW_RESET_SHIFT    8
#define REG_MAC_BLOCK_ACK_SW_RESET_WIDTH    1

/* TXC_TEST_FIFO_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_TXC_TEST_FIFO_SW_RESET          0x0004
#define REG_TXC_TEST_FIFO_SW_RESET_MASK     0x00000200
#define REG_TXC_TEST_FIFO_SW_RESET_SHIFT    9
#define REG_TXC_TEST_FIFO_SW_RESET_WIDTH    1

/* MAC_TRAINER_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_TRAINER_SW_RESET          0x0004
#define REG_MAC_TRAINER_SW_RESET_MASK     0x00000400
#define REG_MAC_TRAINER_SW_RESET_SHIFT    10
#define REG_MAC_TRAINER_SW_RESET_WIDTH    1

/* MAC_FRAME_END_SYNC_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_FRAME_END_SYNC_SW_RESET          0x0004
#define REG_MAC_FRAME_END_SYNC_SW_RESET_MASK     0x00000800
#define REG_MAC_FRAME_END_SYNC_SW_RESET_SHIFT    11
#define REG_MAC_FRAME_END_SYNC_SW_RESET_WIDTH    1

/* MAC_TX_STREAMER_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_TX_STREAMER_SW_RESET          0x0004
#define REG_MAC_TX_STREAMER_SW_RESET_MASK     0x00001000
#define REG_MAC_TX_STREAMER_SW_RESET_SHIFT    12
#define REG_MAC_TX_STREAMER_SW_RESET_WIDTH    1

/* MAC_GENRISC_RX_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_GENRISC_RX_SW_RESET          0x0004
#define REG_MAC_GENRISC_RX_SW_RESET_MASK     0x00002000
#define REG_MAC_GENRISC_RX_SW_RESET_SHIFT    13
#define REG_MAC_GENRISC_RX_SW_RESET_WIDTH    1

/* MAC_GENRISC_HOST_SW_RESET */
/* Write "1" to SW reset. Block is automatically enabled few clocks afterwards. */
#define REG_MAC_GENRISC_HOST_SW_RESET          0x0004
#define REG_MAC_GENRISC_HOST_SW_RESET_MASK     0x00004000
#define REG_MAC_GENRISC_HOST_SW_RESET_SHIFT    14
#define REG_MAC_GENRISC_HOST_SW_RESET_WIDTH    1

/* DMA_MON_NUM_BYTES_VALID_IRQ */
/* Write "1" to clear the IRQ */
#define REG_DMA_MON_NUM_BYTES_VALID_IRQ          0x000C
#define REG_DMA_MON_NUM_BYTES_VALID_IRQ_MASK     0x00002000
#define REG_DMA_MON_NUM_BYTES_VALID_IRQ_SHIFT    13
#define REG_DMA_MON_NUM_BYTES_VALID_IRQ_WIDTH    1

/* DEL2GENRISC_TX_END_IRQ */
/* Write "1" to clear the IRQ */
#define REG_DEL2GENRISC_TX_END_IRQ          0x000C
#define REG_DEL2GENRISC_TX_END_IRQ_MASK     0x00004000
#define REG_DEL2GENRISC_TX_END_IRQ_SHIFT    14
#define REG_DEL2GENRISC_TX_END_IRQ_WIDTH    1

/* DEL_AUTO_FILL_END_IRQ */
/* Write "1" to clear the IRQ */
#define REG_DEL_AUTO_FILL_END_IRQ          0x000C
#define REG_DEL_AUTO_FILL_END_IRQ_MASK     0x00008000
#define REG_DEL_AUTO_FILL_END_IRQ_SHIFT    15
#define REG_DEL_AUTO_FILL_END_IRQ_WIDTH    1

/* PAS_PAC_TICK_TIMER */
/* Write "1" to clear the IRQ */
#define REG_PAS_PAC_TICK_TIMER          0x000C
#define REG_PAS_PAC_TICK_TIMER_MASK     0x00040000
#define REG_PAS_PAC_TICK_TIMER_SHIFT    18
#define REG_PAS_PAC_TICK_TIMER_WIDTH    1

/* PAS_DELIA_ACCESS_TO_REG_5 */
/* Write "1" to clear the IRQ */
#define REG_PAS_DELIA_ACCESS_TO_REG_5          0x000C
#define REG_PAS_DELIA_ACCESS_TO_REG_5_MASK     0x00080000
#define REG_PAS_DELIA_ACCESS_TO_REG_5_SHIFT    19
#define REG_PAS_DELIA_ACCESS_TO_REG_5_WIDTH    1

/* PAS_PAC_TX_ERROR */
/* Write "1" to clear the IRQ */
#define REG_PAS_PAC_TX_ERROR          0x000C
#define REG_PAS_PAC_TX_ERROR_MASK     0x00100000
#define REG_PAS_PAC_TX_ERROR_SHIFT    20
#define REG_PAS_PAC_TX_ERROR_WIDTH    1

/* RX_AGG_ERROR */
/* Write "1" to clear the IRQ */
#define REG_RX_AGG_ERROR          0x000C
#define REG_RX_AGG_ERROR_MASK     0x00200000
#define REG_RX_AGG_ERROR_SHIFT    21
#define REG_RX_AGG_ERROR_WIDTH    1

/* RX_EOF_ERROR */
/* Write "1" to clear the IRQ */
#define REG_RX_EOF_ERROR          0x000C
#define REG_RX_EOF_ERROR_MASK     0x00400000
#define REG_RX_EOF_ERROR_SHIFT    22
#define REG_RX_EOF_ERROR_WIDTH    1

/* BLOCK_ACK_ERR_IRQ */
/* Write "1" to clear the IRQ */
#define REG_BLOCK_ACK_ERR_IRQ          0x000C
#define REG_BLOCK_ACK_ERR_IRQ_MASK     0x00800000
#define REG_BLOCK_ACK_ERR_IRQ_SHIFT    23
#define REG_BLOCK_ACK_ERR_IRQ_WIDTH    1

/* EXTERNAL_IRQ_REG */
/* Write "1" to clear the IRQ */
#define REG_EXTERNAL_IRQ_REG          0x000C
#define REG_EXTERNAL_IRQ_REG_MASK     0x01000000
#define REG_EXTERNAL_IRQ_REG_SHIFT    24
#define REG_EXTERNAL_IRQ_REG_WIDTH    1

/* DEL_LIMIT_TIMER_EXPIRED_IRQ */
/* Write "1" to clear the IRQ */
#define REG_DEL_LIMIT_TIMER_EXPIRED_IRQ          0x000C
#define REG_DEL_LIMIT_TIMER_EXPIRED_IRQ_MASK     0x02000000
#define REG_DEL_LIMIT_TIMER_EXPIRED_IRQ_SHIFT    25
#define REG_DEL_LIMIT_TIMER_EXPIRED_IRQ_WIDTH    1

/* NPU_ARB_TIMEOUT_IRQ */
/* Write "1" to clear the IRQ */
#define REG_NPU_ARB_TIMEOUT_IRQ          0x000C
#define REG_NPU_ARB_TIMEOUT_IRQ_MASK     0x08000000
#define REG_NPU_ARB_TIMEOUT_IRQ_SHIFT    27
#define REG_NPU_ARB_TIMEOUT_IRQ_WIDTH    1

/* NPU_ARB_BUS_ERR_IRQ */
/* Write "1" to clear the IRQ */
#define REG_NPU_ARB_BUS_ERR_IRQ          0x000C
#define REG_NPU_ARB_BUS_ERR_IRQ_MASK     0x10000000
#define REG_NPU_ARB_BUS_ERR_IRQ_SHIFT    28
#define REG_NPU_ARB_BUS_ERR_IRQ_WIDTH    1

/* REDUCED_FREQ_IRQ */
/* Write "1" to clear the IRQ */
#define REG_REDUCED_FREQ_IRQ          0x000C
#define REG_REDUCED_FREQ_IRQ_MASK     0x20000000
#define REG_REDUCED_FREQ_IRQ_SHIFT    29
#define REG_REDUCED_FREQ_IRQ_WIDTH    1

/* DEL_AUTO_FILL_CTR_LIMIT_IRQ */
/* Write "1" to clear the IRQ */
#define REG_DEL_AUTO_FILL_CTR_LIMIT_IRQ          0x000C
#define REG_DEL_AUTO_FILL_CTR_LIMIT_IRQ_MASK     0x40000000
#define REG_DEL_AUTO_FILL_CTR_LIMIT_IRQ_SHIFT    30
#define REG_DEL_AUTO_FILL_CTR_LIMIT_IRQ_WIDTH    1

/* BF_DBG_CNTRS_IRQ */
/* Write "1" to clear the IRQ */
#define REG_BF_DBG_CNTRS_IRQ          0x000C
#define REG_BF_DBG_CNTRS_IRQ_MASK     0x80000000
#define REG_BF_DBG_CNTRS_IRQ_SHIFT    31
#define REG_BF_DBG_CNTRS_IRQ_WIDTH    1
/* HRC_DMA_COMPLETE_ENABLE */
#define REG_HRC_DMA_COMPLETE_ENABLE          0x10
#define REG_HRC_DMA_COMPLETE_ENABLE_MASK     0x00000001
#define REG_HRC_DMA_COMPLETE_ENABLE_SHIFT    0
#define REG_HRC_DMA_COMPLETE_ENABLE_WIDTH    1
/* PAS_PAC_TICK_TIMER_ENABLE */
#define REG_PAS_PAC_TICK_TIMER_ENABLE          0x0010
#define REG_PAS_PAC_TICK_TIMER_ENABLE_MASK     0x00040000
#define REG_PAS_PAC_TICK_TIMER_ENABLE_SHIFT    18
#define REG_PAS_PAC_TICK_TIMER_ENABLE_WIDTH    1

/* PAS_DELIA_ACCESS_TO_REG_5_IRQ_ENABLE */
#define REG_PAS_DELIA_ACCESS_TO_REG_5_IRQ_ENABLE          0x0010
#define REG_PAS_DELIA_ACCESS_TO_REG_5_IRQ_ENABLE_MASK     0x00080000
#define REG_PAS_DELIA_ACCESS_TO_REG_5_IRQ_ENABLE_SHIFT    19
#define REG_PAS_DELIA_ACCESS_TO_REG_5_IRQ_ENABLE_WIDTH    1

/* PAS_PAC_TX_ERROR_ENABLE */
#define REG_PAS_PAC_TX_ERROR_ENABLE          0x0010
#define REG_PAS_PAC_TX_ERROR_ENABLE_MASK     0x00100000
#define REG_PAS_PAC_TX_ERROR_ENABLE_SHIFT    20
#define REG_PAS_PAC_TX_ERROR_ENABLE_WIDTH    1
/* RX_AGG_ERROR_ENABLE */
#define REG_RX_AGG_ERROR_ENABLE          0x0010
#define REG_RX_AGG_ERROR_ENABLE_MASK     0x00200000
#define REG_RX_AGG_ERROR_ENABLE_SHIFT    21
#define REG_RX_AGG_ERROR_ENABLE_WIDTH    1
/* RX_EOF_ERROR_ENABLE */
#define REG_RX_EOF_ERROR_ENABLE          0x0010
#define REG_RX_EOF_ERROR_ENABLE_MASK     0x00400000
#define REG_RX_EOF_ERROR_ENABLE_SHIFT    22
#define REG_RX_EOF_ERROR_ENABLE_WIDTH    1

/* DELINEATOR_CRC_ERR_CNT */
#define REG_DELINEATOR_CRC_ERR_CNT          0x0020
#define REG_DELINEATOR_CRC_ERR_CNT_MASK     0x0000ffff
#define REG_DELINEATOR_CRC_ERR_CNT_SHIFT    0
#define REG_DELINEATOR_CRC_ERR_CNT_WIDTH    16

/* DELINEATOR_AGG_ERR_CNT */
#define REG_DELINEATOR_AGG_ERR_CNT          0x0024
#define REG_DELINEATOR_AGG_ERR_CNT_MASK     0x0000ffff
#define REG_DELINEATOR_AGG_ERR_CNT_SHIFT    0
#define REG_DELINEATOR_AGG_ERR_CNT_WIDTH    16

/* FC2_UNIQUE_PATTERN */
#define REG_FC2_UNIQUE_PATTERN          0x0028
#define REG_FC2_UNIQUE_PATTERN_MASK     0x000000ff
#define REG_FC2_UNIQUE_PATTERN_SHIFT    0
#define REG_FC2_UNIQUE_PATTERN_WIDTH    8

/* PACKET_LENGTH */
#define REG_PACKET_LENGTH          0x002C
#define REG_PACKET_LENGTH_MASK     0x0000fff0
#define REG_PACKET_LENGTH_SHIFT    4
#define REG_PACKET_LENGTH_WIDTH    12

/* RESERVED_BITS */
#define REG_RESERVED_BITS          0x002C
#define REG_RESERVED_BITS_MASK     0x0000000f
#define REG_RESERVED_BITS_SHIFT    0
#define REG_RESERVED_BITS_WIDTH    4

/* RESERVED_BITS_RESULT */
#define REG_RESERVED_BITS_RESULT          0x0030
#define REG_RESERVED_BITS_RESULT_MASK     0x0000000f
#define REG_RESERVED_BITS_RESULT_SHIFT    0
#define REG_RESERVED_BITS_RESULT_WIDTH    4

/* PACKET_LENGTH_RESULT */
#define REG_PACKET_LENGTH_RESULT          0x0030
#define REG_PACKET_LENGTH_RESULT_MASK     0x0000fff0
#define REG_PACKET_LENGTH_RESULT_SHIFT    4
#define REG_PACKET_LENGTH_RESULT_WIDTH    12

/* DELIMITER_CRC_RESULT */
#define REG_DELIMITER_CRC_RESULT          0x0030
#define REG_DELIMITER_CRC_RESULT_MASK     0x00ff0000
#define REG_DELIMITER_CRC_RESULT_SHIFT    16
#define REG_DELIMITER_CRC_RESULT_WIDTH    8

/* UNIQUE_PATTERN_RESULT */
#define REG_UNIQUE_PATTERN_RESULT          0x0030
#define REG_UNIQUE_PATTERN_RESULT_MASK     0xff000000
#define REG_UNIQUE_PATTERN_RESULT_SHIFT    24
#define REG_UNIQUE_PATTERN_RESULT_WIDTH    8

/* TIMER_0_IRQ */
/* Write "1" to clear the IRQ */
#define REG_TIMER_0_IRQ          0x0034
#define REG_TIMER_0_IRQ_MASK     0x00000001
#define REG_TIMER_0_IRQ_SHIFT    0
#define REG_TIMER_0_IRQ_WIDTH    1
/* TIMERS_PRESCALER */
#define REG_TIMERS_PRESCALER          0x0038
#define REG_TIMERS_PRESCALER_MASK     0x0000ffff
#define REG_TIMERS_PRESCALER_SHIFT    0
#define REG_TIMERS_PRESCALER_WIDTH    16

/* TIMER_0_ENABLE */
#define REG_TIMER_0_ENABLE          0x003C
#define REG_TIMER_0_ENABLE_MASK     0x00000001
#define REG_TIMER_0_ENABLE_SHIFT    0
#define REG_TIMER_0_ENABLE_WIDTH    1
/* TIMER_0_INIT_VALUE */
#define REG_TIMER_0_INIT_VALUE          0x0040
#define REG_TIMER_0_INIT_VALUE_MASK     0x0000ffff
#define REG_TIMER_0_INIT_VALUE_SHIFT    0
#define REG_TIMER_0_INIT_VALUE_WIDTH    16

/* BAR_COMPRESSED */
#define REG_BAR_COMPRESSED          0x00C0
#define REG_BAR_COMPRESSED_MASK     0x00000001
#define REG_BAR_COMPRESSED_SHIFT    0
#define REG_BAR_COMPRESSED_WIDTH    1

/* BAR_ACK_POLICY */
#define REG_BAR_ACK_POLICY          0x00C0
#define REG_BAR_ACK_POLICY_MASK     0x00000002
#define REG_BAR_ACK_POLICY_SHIFT    1
#define REG_BAR_ACK_POLICY_WIDTH    1

/* USE_ACK_POLICY_ON_BAR */
#define REG_USE_ACK_POLICY_ON_BAR          0x00C0
#define REG_USE_ACK_POLICY_ON_BAR_MASK     0x00000004
#define REG_USE_ACK_POLICY_ON_BAR_SHIFT    2
#define REG_USE_ACK_POLICY_ON_BAR_WIDTH    1

/* FLUSH_ON_ERROR_NEGATIVE */
#define REG_FLUSH_ON_ERROR_NEGATIVE          0x00C0
#define REG_FLUSH_ON_ERROR_NEGATIVE_MASK     0x00000008
#define REG_FLUSH_ON_ERROR_NEGATIVE_SHIFT    3
#define REG_FLUSH_ON_ERROR_NEGATIVE_WIDTH    1

/* BACK_LAST_TA_LOW */
#define REG_BACK_LAST_TA_LOW          0x00C4
#define REG_BACK_LAST_TA_LOW_MASK     0xffffffff
#define REG_BACK_LAST_TA_LOW_SHIFT    0
#define REG_BACK_LAST_TA_LOW_WIDTH    32

/* BACK_LAST_TA_HIGH */
#define REG_BACK_LAST_TA_HIGH          0x00C8
#define REG_BACK_LAST_TA_HIGH_MASK     0x0000ffff
#define REG_BACK_LAST_TA_HIGH_SHIFT    0
#define REG_BACK_LAST_TA_HIGH_WIDTH    16

/* BACK_LAST_TID */
#define REG_BACK_LAST_TID          0x00CC
#define REG_BACK_LAST_TID_MASK     0x0000000f
#define REG_BACK_LAST_TID_SHIFT    0
#define REG_BACK_LAST_TID_WIDTH    4

/* BACK_EN_VECTOR */
#define REG_BACK_EN_VECTOR          0x00D0
#define REG_BACK_EN_VECTOR_MASK     0x0000ffff
#define REG_BACK_EN_VECTOR_SHIFT    0
#define REG_BACK_EN_VECTOR_WIDTH    16

/* BACK_ERR_CTR */
/* Cleared by read */
#define REG_BACK_ERR_CTR          0x00D4
#define REG_BACK_ERR_CTR_MASK     0x0000ffff
#define REG_BACK_ERR_CTR_SHIFT    0
#define REG_BACK_ERR_CTR_WIDTH    16

/* TO_FROM_DS_IN_WORK */
#define REG_TO_FROM_DS_IN_WORK          0x00D8
#define REG_TO_FROM_DS_IN_WORK_MASK     0x00000003
#define REG_TO_FROM_DS_IN_WORK_SHIFT    0
#define REG_TO_FROM_DS_IN_WORK_WIDTH    2

/* ACK_POLICY_IN_WORK */
#define REG_ACK_POLICY_IN_WORK          0x00D8
#define REG_ACK_POLICY_IN_WORK_MASK     0x0000000c
#define REG_ACK_POLICY_IN_WORK_SHIFT    2
#define REG_ACK_POLICY_IN_WORK_WIDTH    2

/* SUBTYPE_IN_WORK */
#define REG_SUBTYPE_IN_WORK          0x00D8
#define REG_SUBTYPE_IN_WORK_MASK     0x000000f0
#define REG_SUBTYPE_IN_WORK_SHIFT    4
#define REG_SUBTYPE_IN_WORK_WIDTH    4

/* TYPE_IN_WORK */
#define REG_TYPE_IN_WORK          0x00D8
#define REG_TYPE_IN_WORK_MASK     0x00000300
#define REG_TYPE_IN_WORK_SHIFT    8
#define REG_TYPE_IN_WORK_WIDTH    2

/* BA_MAIN_SM */
#define REG_BA_MAIN_SM          0x00D8
#define REG_BA_MAIN_SM_MASK     0x00003c00
#define REG_BA_MAIN_SM_SHIFT    10
#define REG_BA_MAIN_SM_WIDTH    4

/* LINK_ADAPTATION_SPARE_REGISTER */
#define REG_LINK_ADAPTATION_SPARE_REGISTER          0x00DC
#define REG_LINK_ADAPTATION_SPARE_REGISTER_MASK     0xffffffff
#define REG_LINK_ADAPTATION_SPARE_REGISTER_SHIFT    0
#define REG_LINK_ADAPTATION_SPARE_REGISTER_WIDTH    32

/* BACK_REG_UPDATE_REQ */
#define REG_BACK_REG_UPDATE_REQ          0x00E0
#define REG_BACK_REG_UPDATE_REQ_MASK     0xffffffff
#define REG_BACK_REG_UPDATE_REQ_SHIFT    0
#define REG_BACK_REG_UPDATE_REQ_WIDTH    32

/* NPU_ARB_STM */
#define REG_NPU_ARB_STM          0x00E4
#define REG_NPU_ARB_STM_MASK     0x00000007
#define REG_NPU_ARB_STM_SHIFT    0
#define REG_NPU_ARB_STM_WIDTH    3

/* PHY_ARBITER_GCLK_BYPASS */
#define REG_PHY_ARBITER_GCLK_BYPASS          0x00E8
#define REG_PHY_ARBITER_GCLK_BYPASS_MASK     0x00000001
#define REG_PHY_ARBITER_GCLK_BYPASS_SHIFT    0
#define REG_PHY_ARBITER_GCLK_BYPASS_WIDTH    1

/* REDUCED_FREQ_MODE */
#define REG_REDUCED_FREQ_MODE          0x00EC
#define REG_REDUCED_FREQ_MODE_MASK     0x00000001
#define REG_REDUCED_FREQ_MODE_SHIFT    0
#define REG_REDUCED_FREQ_MODE_WIDTH    1

/* TIMER_0_DISABLE */
#define REG_TIMER_0_DISABLE          0x00F0
#define REG_TIMER_0_DISABLE_MASK     0x00000001
#define REG_TIMER_0_DISABLE_SHIFT    0
#define REG_TIMER_0_DISABLE_WIDTH    1
/* TX_STREAMER_CDIVR */
#define REG_TX_STREAMER_CDIVR          0x00F4
#define REG_TX_STREAMER_CDIVR_MASK     0x000000ff
#define REG_TX_STREAMER_CDIVR_SHIFT    0
#define REG_TX_STREAMER_CDIVR_WIDTH    8

/* TX_STREAMER_MODE_REG */
#define REG_TX_STREAMER_MODE_REG          0x00F4
#define REG_TX_STREAMER_MODE_REG_MASK     0x00000300
#define REG_TX_STREAMER_MODE_REG_SHIFT    8
#define REG_TX_STREAMER_MODE_REG_WIDTH    2

/* TX_STREAMER_CMULTR */
#define REG_TX_STREAMER_CMULTR          0x00F4
#define REG_TX_STREAMER_CMULTR_MASK     0x000ff000
#define REG_TX_STREAMER_CMULTR_SHIFT    12
#define REG_TX_STREAMER_CMULTR_WIDTH    8

/* TX_STREAMER_ACTIVE_INDICATION */
#define REG_TX_STREAMER_ACTIVE_INDICATION          0x00F8
#define REG_TX_STREAMER_ACTIVE_INDICATION_MASK     0x00000001
#define REG_TX_STREAMER_ACTIVE_INDICATION_SHIFT    0
#define REG_TX_STREAMER_ACTIVE_INDICATION_WIDTH    1

/* TX_STREAMER_START_ADDR */
#define REG_TX_STREAMER_START_ADDR          0x00FC
#define REG_TX_STREAMER_START_ADDR_MASK     0x00007fff
#define REG_TX_STREAMER_START_ADDR_SHIFT    0
#define REG_TX_STREAMER_START_ADDR_WIDTH    15

/* TX_STREAMER_END_ADDR */
#define REG_TX_STREAMER_END_ADDR          0x00FC
#define REG_TX_STREAMER_END_ADDR_MASK     0x7fff0000
#define REG_TX_STREAMER_END_ADDR_SHIFT    16
#define REG_TX_STREAMER_END_ADDR_WIDTH    15

/* TX_SYNC_DELAY */
#define REG_TX_SYNC_DELAY          0x0100
#define REG_TX_SYNC_DELAY_MASK     0x0000ffff
#define REG_TX_SYNC_DELAY_SHIFT    0
#define REG_TX_SYNC_DELAY_WIDTH    16

/* RX_SYNC_DELAY */
#define REG_RX_SYNC_DELAY          0x0104
#define REG_RX_SYNC_DELAY_MASK     0x0000ffff
#define REG_RX_SYNC_DELAY_SHIFT    0
#define REG_RX_SYNC_DELAY_WIDTH    16

/* SYNC_PULSE_WIDTH */
#define REG_SYNC_PULSE_WIDTH          0x0108
#define REG_SYNC_PULSE_WIDTH_MASK     0x000000ff
#define REG_SYNC_PULSE_WIDTH_SHIFT    0
#define REG_SYNC_PULSE_WIDTH_WIDTH    8

/* ZLD_CTR */
/* Cleared by read */
#define REG_ZLD_CTR          0x010C
#define REG_ZLD_CTR_MASK     0x0000ffff
#define REG_ZLD_CTR_SHIFT    0
#define REG_ZLD_CTR_WIDTH    16

/* GOOD_DEL_CTR */
/* Cleared by read */
#define REG_GOOD_DEL_CTR          0x0110
#define REG_GOOD_DEL_CTR_MASK     0xffffffff
#define REG_GOOD_DEL_CTR_SHIFT    0
#define REG_GOOD_DEL_CTR_WIDTH    32

/* DEL_LAST_AGG_LENGTH */
#define REG_DEL_LAST_AGG_LENGTH          0x0114
#define REG_DEL_LAST_AGG_LENGTH_MASK     0x0000ffff
#define REG_DEL_LAST_AGG_LENGTH_SHIFT    0
#define REG_DEL_LAST_AGG_LENGTH_WIDTH    16

/* DEL_LAST_SUBFRAME_LENGTH */
#define REG_DEL_LAST_SUBFRAME_LENGTH          0x0114
#define REG_DEL_LAST_SUBFRAME_LENGTH_MASK     0x0fff0000
#define REG_DEL_LAST_SUBFRAME_LENGTH_SHIFT    16
#define REG_DEL_LAST_SUBFRAME_LENGTH_WIDTH    12

/* DEL_CAT_LAST_INDICATION */
#define REG_DEL_CAT_LAST_INDICATION          0x0114
#define REG_DEL_CAT_LAST_INDICATION_MASK     0x10000000
#define REG_DEL_CAT_LAST_INDICATION_SHIFT    28
#define REG_DEL_CAT_LAST_INDICATION_WIDTH    1

/* DEL_MAIN_STM */
#define REG_DEL_MAIN_STM          0x0118
#define REG_DEL_MAIN_STM_MASK     0x0000001f
#define REG_DEL_MAIN_STM_SHIFT    0
#define REG_DEL_MAIN_STM_WIDTH    5

/* DEL_MT_METRICS_CTR */
#define REG_DEL_MT_METRICS_CTR          0x0118
#define REG_DEL_MT_METRICS_CTR_MASK     0x000000e0
#define REG_DEL_MT_METRICS_CTR_SHIFT    5
#define REG_DEL_MT_METRICS_CTR_WIDTH    3

/* DEL_FRAME_LENGTH_IN_WORDS */
#define REG_DEL_FRAME_LENGTH_IN_WORDS          0x0118
#define REG_DEL_FRAME_LENGTH_IN_WORDS_MASK     0x0003ff00
#define REG_DEL_FRAME_LENGTH_IN_WORDS_SHIFT    8
#define REG_DEL_FRAME_LENGTH_IN_WORDS_WIDTH    10

/* DEL_AGG_LENGTH */
#define REG_DEL_AGG_LENGTH          0x0118
#define REG_DEL_AGG_LENGTH_MASK     0xfffc0000
#define REG_DEL_AGG_LENGTH_SHIFT    18
#define REG_DEL_AGG_LENGTH_WIDTH    14

/* LAST_BAD_DELIMITER_LOCATION */
#define REG_LAST_BAD_DELIMITER_LOCATION          0x011C
#define REG_LAST_BAD_DELIMITER_LOCATION_MASK     0x00003fff
#define REG_LAST_BAD_DELIMITER_LOCATION_SHIFT    0
#define REG_LAST_BAD_DELIMITER_LOCATION_WIDTH    14

/* SUBFRAME_COUNT_IN_AGGREGATE */
#define REG_SUBFRAME_COUNT_IN_AGGREGATE          0x011C
#define REG_SUBFRAME_COUNT_IN_AGGREGATE_MASK     0x001fc000
#define REG_SUBFRAME_COUNT_IN_AGGREGATE_SHIFT    14
#define REG_SUBFRAME_COUNT_IN_AGGREGATE_WIDTH    7

/* DEL_DEBUG4 */
#define REG_DEL_DEBUG4          0x0120
#define REG_DEL_DEBUG4_MASK     0xffffffff
#define REG_DEL_DEBUG4_SHIFT    0
#define REG_DEL_DEBUG4_WIDTH    32

/* HYP_MAC_TOP_GPR */
#define REG_HYP_MAC_TOP_GPR          0x0130
#define REG_HYP_MAC_TOP_GPR_MASK     0xffffffff
#define REG_HYP_MAC_TOP_GPR_SHIFT    0
#define REG_HYP_MAC_TOP_GPR_WIDTH    32

/* HYP_MAC_TOP_GPO */
#define REG_HYP_MAC_TOP_GPO          0x0134
#define REG_HYP_MAC_TOP_GPO_MASK     0x0000ffff
#define REG_HYP_MAC_TOP_GPO_SHIFT    0
#define REG_HYP_MAC_TOP_GPO_WIDTH    16

/* HYP_MAC_TOP_GPI */
#define REG_HYP_MAC_TOP_GPI          0x0138
#define REG_HYP_MAC_TOP_GPI_MASK     0x0000ffff
#define REG_HYP_MAC_TOP_GPI_SHIFT    0
#define REG_HYP_MAC_TOP_GPI_WIDTH    16

/* HYP_MAC_TOP_GPI2 */
#define REG_HYP_MAC_TOP_GPI2          0x013C
#define REG_HYP_MAC_TOP_GPI2_MASK     0x0000ffff
#define REG_HYP_MAC_TOP_GPI2_SHIFT    0
#define REG_HYP_MAC_TOP_GPI2_WIDTH    16

/* DEL2GENRISC_TX_END_IRQ */
#define REG_MAC_GENRISC_TX_DEL2GENRISC_TX_END_IRQ          0x0144
#define REG_MAC_GENRISC_TX_DEL2GENRISC_TX_END_IRQ_MASK     0x00000001
#define REG_MAC_GENRISC_TX_DEL2GENRISC_TX_END_IRQ_SHIFT    0
#define REG_MAC_GENRISC_TX_DEL2GENRISC_TX_END_IRQ_WIDTH    1

/* DEL_AUTO_FILL_END_IRQ */
#define REG_MAC_GENRISC_TX_DEL_AUTO_FILL_END_IRQ          0x0144
#define REG_MAC_GENRISC_TX_DEL_AUTO_FILL_END_IRQ_MASK     0x00000002
#define REG_MAC_GENRISC_TX_DEL_AUTO_FILL_END_IRQ_SHIFT    1
#define REG_MAC_GENRISC_TX_DEL_AUTO_FILL_END_IRQ_WIDTH    1

/* PAS_PAC_TX_ERROR */
#define REG_MAC_GENRISC_TX_PAS_PAC_TX_ERROR          0x0144
#define REG_MAC_GENRISC_TX_PAS_PAC_TX_ERROR_MASK     0x00000004
#define REG_MAC_GENRISC_TX_PAS_PAC_TX_ERROR_SHIFT    2
#define REG_MAC_GENRISC_TX_PAS_PAC_TX_ERROR_WIDTH    1

/* DEL2GENRISC_TX_END_ENABLE */
#define REG_DEL2GENRISC_TX_END_ENABLE          0x0148
#define REG_DEL2GENRISC_TX_END_ENABLE_MASK     0x00000001
#define REG_DEL2GENRISC_TX_END_ENABLE_SHIFT    0
#define REG_DEL2GENRISC_TX_END_ENABLE_WIDTH    1

/* DEL_AUTO_FILL_END_ENABLE */
#define REG_DEL_AUTO_FILL_END_ENABLE          0x0148
#define REG_DEL_AUTO_FILL_END_ENABLE_MASK     0x00000002
#define REG_DEL_AUTO_FILL_END_ENABLE_SHIFT    1
#define REG_DEL_AUTO_FILL_END_ENABLE_WIDTH    1

/* PAS_PAC_TX_ENABLE */
#define REG_PAS_PAC_TX_ENABLE          0x0148
#define REG_PAS_PAC_TX_ENABLE_MASK     0x00000004
#define REG_PAS_PAC_TX_ENABLE_SHIFT    2
#define REG_PAS_PAC_TX_ENABLE_WIDTH    1

/* FAST_DPHY_FPGA_MODE */
#define REG_FAST_DPHY_FPGA_MODE          0x015C
#define REG_FAST_DPHY_FPGA_MODE_MASK     0x00000001
#define REG_FAST_DPHY_FPGA_MODE_SHIFT    0
#define REG_FAST_DPHY_FPGA_MODE_WIDTH    1

/* DMA_BBCPU_ARB_CONFIG */
#define REG_DMA_BBCPU_ARB_CONFIG          0x0168
#define REG_DMA_BBCPU_ARB_CONFIG_MASK     0x07ffffff
#define REG_DMA_BBCPU_ARB_CONFIG_SHIFT    0
#define REG_DMA_BBCPU_ARB_CONFIG_WIDTH    27

/* WLAN_SCD_AHB_MASTER_WRITE_SWAP_EN */
#define REG_WLAN_SCD_AHB_MASTER_WRITE_SWAP_EN          0x016C
#define REG_WLAN_SCD_AHB_MASTER_WRITE_SWAP_EN_MASK     0x00000001
#define REG_WLAN_SCD_AHB_MASTER_WRITE_SWAP_EN_SHIFT    0
#define REG_WLAN_SCD_AHB_MASTER_WRITE_SWAP_EN_WIDTH    1

/* WLAN_SCD_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN */
#define REG_WLAN_SCD_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN          0x016C
#define REG_WLAN_SCD_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN_MASK     0x00000002
#define REG_WLAN_SCD_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN_SHIFT    1
#define REG_WLAN_SCD_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN_WIDTH    1

/* WLAN_SCD_AHB_MASTER_READ_SWAP_EN */
#define REG_WLAN_SCD_AHB_MASTER_READ_SWAP_EN          0x016C
#define REG_WLAN_SCD_AHB_MASTER_READ_SWAP_EN_MASK     0x00000004
#define REG_WLAN_SCD_AHB_MASTER_READ_SWAP_EN_SHIFT    2
#define REG_WLAN_SCD_AHB_MASTER_READ_SWAP_EN_WIDTH    1

/* WLAN_SCD_AHB_MASTER_READ_FULL_BYTESWAP_EN */
#define REG_WLAN_SCD_AHB_MASTER_READ_FULL_BYTESWAP_EN          0x016C
#define REG_WLAN_SCD_AHB_MASTER_READ_FULL_BYTESWAP_EN_MASK     0x00000008
#define REG_WLAN_SCD_AHB_MASTER_READ_FULL_BYTESWAP_EN_SHIFT    3
#define REG_WLAN_SCD_AHB_MASTER_READ_FULL_BYTESWAP_EN_WIDTH    1

/* WLAN_DMA_AHB_MASTER_WRITE_SWAP_EN */
#define REG_WLAN_DMA_AHB_MASTER_WRITE_SWAP_EN          0x016C
#define REG_WLAN_DMA_AHB_MASTER_WRITE_SWAP_EN_MASK     0x00000010
#define REG_WLAN_DMA_AHB_MASTER_WRITE_SWAP_EN_SHIFT    4
#define REG_WLAN_DMA_AHB_MASTER_WRITE_SWAP_EN_WIDTH    1

/* WLAN_DMA_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN */
#define REG_WLAN_DMA_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN          0x016C
#define REG_WLAN_DMA_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN_MASK     0x00000020
#define REG_WLAN_DMA_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN_SHIFT    5
#define REG_WLAN_DMA_AHB_MASTER_WRITE_FULL_BYTE_SWAP_EN_WIDTH    1

/* WLAN_DMA_AHB_MASTER_READ_SWAP_EN */
#define REG_WLAN_DMA_AHB_MASTER_READ_SWAP_EN          0x016C
#define REG_WLAN_DMA_AHB_MASTER_READ_SWAP_EN_MASK     0x00000040
#define REG_WLAN_DMA_AHB_MASTER_READ_SWAP_EN_SHIFT    6
#define REG_WLAN_DMA_AHB_MASTER_READ_SWAP_EN_WIDTH    1

/* WLAN_DMA_AHB_MASTER_READ_FULL_BYTESWAP_EN */
#define REG_WLAN_DMA_AHB_MASTER_READ_FULL_BYTESWAP_EN          0x016C
#define REG_WLAN_DMA_AHB_MASTER_READ_FULL_BYTESWAP_EN_MASK     0x00000080
#define REG_WLAN_DMA_AHB_MASTER_READ_FULL_BYTESWAP_EN_SHIFT    7
#define REG_WLAN_DMA_AHB_MASTER_READ_FULL_BYTESWAP_EN_WIDTH    1

/* WLAN_SHRAM_AHB_SLAVE_WRITE_SWAP_EN */
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_SWAP_EN          0x016C
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_SWAP_EN_MASK     0x00000100
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_SWAP_EN_SHIFT    8
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_SWAP_EN_WIDTH    1

/* WLAN_SHRAM_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN */
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN          0x016C
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN_MASK     0x00000200
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN_SHIFT    9
#define REG_WLAN_SHRAM_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN_WIDTH    1

/* WLAN_SHRAM_AHB_SLAVE_READ_SWAP_EN */
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_SWAP_EN          0x016C
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_SWAP_EN_MASK     0x00000400
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_SWAP_EN_SHIFT    10
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_SWAP_EN_WIDTH    1

/* WLAN_SHRAM_AHB_SLAVE_READ_FULL_BYTESWAP_EN */
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_FULL_BYTESWAP_EN          0x016C
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_FULL_BYTESWAP_EN_MASK     0x00000800
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_FULL_BYTESWAP_EN_SHIFT    11
#define REG_WLAN_SHRAM_AHB_SLAVE_READ_FULL_BYTESWAP_EN_WIDTH    1

/* WLAN_PCIH_AHB_SLAVE_WRITE_SWAP_EN */
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_SWAP_EN          0x016C
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_SWAP_EN_MASK     0x00001000
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_SWAP_EN_SHIFT    12
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_SWAP_EN_WIDTH    1

/* WLAN_PCIH_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN */
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN          0x016C
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN_MASK     0x00002000
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN_SHIFT    13
#define REG_WLAN_PCIH_AHB_SLAVE_WRITE_FULL_BYTE_SWAP_EN_WIDTH    1

/* WLAN_PCIH_AHB_SLAVE_READ_SWAP_EN */
#define REG_WLAN_PCIH_AHB_SLAVE_READ_SWAP_EN          0x016C
#define REG_WLAN_PCIH_AHB_SLAVE_READ_SWAP_EN_MASK     0x00004000
#define REG_WLAN_PCIH_AHB_SLAVE_READ_SWAP_EN_SHIFT    14
#define REG_WLAN_PCIH_AHB_SLAVE_READ_SWAP_EN_WIDTH    1

/* WLAN_PCIH_AHB_SLAVE_READ_FULL_BYTESWAP_EN */
#define REG_WLAN_PCIH_AHB_SLAVE_READ_FULL_BYTESWAP_EN          0x016C
#define REG_WLAN_PCIH_AHB_SLAVE_READ_FULL_BYTESWAP_EN_MASK     0x00008000
#define REG_WLAN_PCIH_AHB_SLAVE_READ_FULL_BYTESWAP_EN_SHIFT    15
#define REG_WLAN_PCIH_AHB_SLAVE_READ_FULL_BYTESWAP_EN_WIDTH    1

/* MEM_GLOBAL_RM */
#define REG_MEM_GLOBAL_RM          0x0174
#define REG_MEM_GLOBAL_RM_MASK     0x000000c0
#define REG_MEM_GLOBAL_RM_SHIFT    6
#define REG_MEM_GLOBAL_RM_WIDTH    2

/* TB_ENABLE */
#define REG_TB_ENABLE          0x0180
#define REG_TB_ENABLE_MASK     0x00000001
#define REG_TB_ENABLE_SHIFT    0
#define REG_TB_ENABLE_WIDTH    1

/* TB_CLEAR */
#define REG_TB_CLEAR          0x0180
#define REG_TB_CLEAR_MASK     0x00000002
#define REG_TB_CLEAR_SHIFT    1
#define REG_TB_CLEAR_WIDTH    1

/* TX_SYNC_OUT_ENABLE */
#define REG_TX_SYNC_OUT_ENABLE          0x0184
#define REG_TX_SYNC_OUT_ENABLE_MASK     0x00000001
#define REG_TX_SYNC_OUT_ENABLE_SHIFT    0
#define REG_TX_SYNC_OUT_ENABLE_WIDTH    1

/* RX_SYNC_OUT_ENABLE */
#define REG_RX_SYNC_OUT_ENABLE          0x0184
#define REG_RX_SYNC_OUT_ENABLE_MASK     0x00000002
#define REG_RX_SYNC_OUT_ENABLE_SHIFT    1
#define REG_RX_SYNC_OUT_ENABLE_WIDTH    1

/* SPARE_GC_BYPASS */
#define REG_SPARE_GC_BYPASS          0x0198
#define REG_SPARE_GC_BYPASS_MASK     0x000001ff
#define REG_SPARE_GC_BYPASS_SHIFT    0
#define REG_SPARE_GC_BYPASS_WIDTH    9

/* SPARE_GC_EN */
#define REG_SPARE_GC_EN          0x0198
#define REG_SPARE_GC_EN_MASK     0x0003fe00
#define REG_SPARE_GC_EN_SHIFT    9
#define REG_SPARE_GC_EN_WIDTH    9

/* ACCEPT_ILLEGAL_SUBFRAME_LENGTH */
#define REG_ACCEPT_ILLEGAL_SUBFRAME_LENGTH          0x01A0
#define REG_ACCEPT_ILLEGAL_SUBFRAME_LENGTH_MASK     0x00000001
#define REG_ACCEPT_ILLEGAL_SUBFRAME_LENGTH_SHIFT    0
#define REG_ACCEPT_ILLEGAL_SUBFRAME_LENGTH_WIDTH    1

/* IGNORE_NONZERO_RESERVED_FIELD_IN_DELIMITER */
#define REG_IGNORE_NONZERO_RESERVED_FIELD_IN_DELIMITER          0x01A0
#define REG_IGNORE_NONZERO_RESERVED_FIELD_IN_DELIMITER_MASK     0x00000002
#define REG_IGNORE_NONZERO_RESERVED_FIELD_IN_DELIMITER_SHIFT    1
#define REG_IGNORE_NONZERO_RESERVED_FIELD_IN_DELIMITER_WIDTH    1

/* CHECK_MINIMAL_SUBFRAME_LENGTH_IN_DELIMITER */
#define REG_CHECK_MINIMAL_SUBFRAME_LENGTH_IN_DELIMITER          0x01A0
#define REG_CHECK_MINIMAL_SUBFRAME_LENGTH_IN_DELIMITER_MASK     0x00000004
#define REG_CHECK_MINIMAL_SUBFRAME_LENGTH_IN_DELIMITER_SHIFT    2
#define REG_CHECK_MINIMAL_SUBFRAME_LENGTH_IN_DELIMITER_WIDTH    1

/* CHECK_MAXIMAL_SUBFRAME_LENGTH_IN_DELIMITER */
#define REG_CHECK_MAXIMAL_SUBFRAME_LENGTH_IN_DELIMITER          0x01A0
#define REG_CHECK_MAXIMAL_SUBFRAME_LENGTH_IN_DELIMITER_MASK     0x00000008
#define REG_CHECK_MAXIMAL_SUBFRAME_LENGTH_IN_DELIMITER_SHIFT    3
#define REG_CHECK_MAXIMAL_SUBFRAME_LENGTH_IN_DELIMITER_WIDTH    1

/* DELINIATOR_APPEND_STATUS */
#define REG_DELINIATOR_APPEND_STATUS          0x01A0
#define REG_DELINIATOR_APPEND_STATUS_MASK     0x00000010
#define REG_DELINIATOR_APPEND_STATUS_SHIFT    4
#define REG_DELINIATOR_APPEND_STATUS_WIDTH    1

/* PIF_MODE */
#define REG_PIF_MODE          0x01A4
#define REG_PIF_MODE_MASK     0x00000001
#define REG_PIF_MODE_SHIFT    0
#define REG_PIF_MODE_WIDTH    1

/* EXTEND_DMA */
#define REG_EXTEND_DMA          0x01A8
#define REG_EXTEND_DMA_MASK     0x00000001
#define REG_EXTEND_DMA_SHIFT    0
#define REG_EXTEND_DMA_WIDTH    1

/* EXTEND_BBCPU */
#define REG_EXTEND_BBCPU          0x01A8
#define REG_EXTEND_BBCPU_MASK     0x00000002
#define REG_EXTEND_BBCPU_SHIFT    1
#define REG_EXTEND_BBCPU_WIDTH    1

/* EXTEND_MAC_GENRISC1 */
#define REG_EXTEND_MAC_GENRISC1          0x01A8
#define REG_EXTEND_MAC_GENRISC1_MASK     0x00000004
#define REG_EXTEND_MAC_GENRISC1_SHIFT    2
#define REG_EXTEND_MAC_GENRISC1_WIDTH    1

/* EXTEND_SPI_IF */
#define REG_EXTEND_SPI_IF          0x01A8
#define REG_EXTEND_SPI_IF_MASK     0x00000008
#define REG_EXTEND_SPI_IF_SHIFT    3
#define REG_EXTEND_SPI_IF_WIDTH    1

/* DEL_MIN_SUBFRAME_LENGTH */
#define REG_DEL_MIN_SUBFRAME_LENGTH          0x01B0
#define REG_DEL_MIN_SUBFRAME_LENGTH_MASK     0x00000fff
#define REG_DEL_MIN_SUBFRAME_LENGTH_SHIFT    0
#define REG_DEL_MIN_SUBFRAME_LENGTH_WIDTH    12

/* DEL_MAX_SUBFRAME_LENGTH */
#define REG_DEL_MAX_SUBFRAME_LENGTH          0x01B0
#define REG_DEL_MAX_SUBFRAME_LENGTH_MASK     0x00fff000
#define REG_DEL_MAX_SUBFRAME_LENGTH_SHIFT    12
#define REG_DEL_MAX_SUBFRAME_LENGTH_WIDTH    12

/* TRAINER_MODE */
#define REG_TRAINER_MODE          0x01B8
#define REG_TRAINER_MODE_MASK     0x00000001
#define REG_TRAINER_MODE_SHIFT    0
#define REG_TRAINER_MODE_WIDTH    1

/* BBCPU_PAGE_REG */
#define REG_BBCPU_PAGE_REG          0x01C0
#define REG_BBCPU_PAGE_REG_MASK     0x0000ffff
#define REG_BBCPU_PAGE_REG_SHIFT    0
#define REG_BBCPU_PAGE_REG_WIDTH    16

/* BBCPU_PAGE_MASK */
#define REG_BBCPU_PAGE_MASK          0x01C0
#define REG_BBCPU_PAGE_MASK_MASK     0xffff0000
#define REG_BBCPU_PAGE_MASK_SHIFT    16
#define REG_BBCPU_PAGE_MASK_WIDTH    16

/* SLAVE_SPI_PAGE_REG */
#define REG_SLAVE_SPI_PAGE_REG          0x01C4
#define REG_SLAVE_SPI_PAGE_REG_MASK     0x0000ffff
#define REG_SLAVE_SPI_PAGE_REG_SHIFT    0
#define REG_SLAVE_SPI_PAGE_REG_WIDTH    16

/* SLAVE_SPI_PAGE_MASK */
#define REG_SLAVE_SPI_PAGE_MASK          0x01C4
#define REG_SLAVE_SPI_PAGE_MASK_MASK     0xffff0000
#define REG_SLAVE_SPI_PAGE_MASK_SHIFT    16
#define REG_SLAVE_SPI_PAGE_MASK_WIDTH    16

/* GENRISC_HOST_PAGE_REG */
#define REG_GENRISC_HOST_PAGE_REG          0x01C8
#define REG_GENRISC_HOST_PAGE_REG_MASK     0x0000ffff
#define REG_GENRISC_HOST_PAGE_REG_SHIFT    0
#define REG_GENRISC_HOST_PAGE_REG_WIDTH    16

/* GENRISC_HOST_PAGE_MASK */
#define REG_GENRISC_HOST_PAGE_MASK          0x01C8
#define REG_GENRISC_HOST_PAGE_MASK_MASK     0xffff0000
#define REG_GENRISC_HOST_PAGE_MASK_SHIFT    16
#define REG_GENRISC_HOST_PAGE_MASK_WIDTH    16

/* DMA_PAGE_REG */
#define REG_DMA_PAGE_REG          0x01CC
#define REG_DMA_PAGE_REG_MASK     0x0000ffff
#define REG_DMA_PAGE_REG_SHIFT    0
#define REG_DMA_PAGE_REG_WIDTH    16

/* DMA_PAGE_MASK */
#define REG_DMA_PAGE_MASK          0x01CC
#define REG_DMA_PAGE_MASK_MASK     0xffff0000
#define REG_DMA_PAGE_MASK_SHIFT    16
#define REG_DMA_PAGE_MASK_WIDTH    16

/* RAB_HOST_IRQ */
#define REG_RAB_HOST_IRQ          0x01D0
#define REG_RAB_HOST_IRQ_MASK     0x00000001
#define REG_RAB_HOST_IRQ_SHIFT    0
#define REG_RAB_HOST_IRQ_WIDTH    1

/* RAB_LPI_IRQ */
#define REG_RAB_LPI_IRQ          0x01D0
#define REG_RAB_LPI_IRQ_MASK     0x00000002
#define REG_RAB_LPI_IRQ_SHIFT    1
#define REG_RAB_LPI_IRQ_WIDTH    1

/* HOST_MAC_GENRISC1_IRQ */
#define REG_HOST_MAC_GENRISC1_IRQ          0x01D0
#define REG_HOST_MAC_GENRISC1_IRQ_MASK     0x00000004
#define REG_HOST_MAC_GENRISC1_IRQ_SHIFT    2
#define REG_HOST_MAC_GENRISC1_IRQ_WIDTH    1

/* HOST_HT_TIMERS_IRQ */
#define REG_HOST_HT_TIMERS_IRQ          0x01D0
#define REG_HOST_HT_TIMERS_IRQ_MASK     0x00000008
#define REG_HOST_HT_TIMERS_IRQ_SHIFT    3
#define REG_HOST_HT_TIMERS_IRQ_WIDTH    1

/* HOST_EXTERNAL_IRQ */
#define REG_HOST_EXTERNAL_IRQ          0x01D0
#define REG_HOST_EXTERNAL_IRQ_MASK     0x00000020
#define REG_HOST_EXTERNAL_IRQ_SHIFT    5
#define REG_HOST_EXTERNAL_IRQ_WIDTH    1

/* HOST_PHY_IRQ */
#define REG_HOST_PHY_IRQ          0x01D0
#define REG_HOST_PHY_IRQ_MASK     0x00000040
#define REG_HOST_PHY_IRQ_SHIFT    6
#define REG_HOST_PHY_IRQ_WIDTH    1

/* HOST_DMA_IRQ */
#define REG_HOST_DMA_IRQ          0x01D0
#define REG_HOST_DMA_IRQ_MASK     0x00000080
#define REG_HOST_DMA_IRQ_SHIFT    7
#define REG_HOST_DMA_IRQ_WIDTH    1

/* HOST_IRQ_MASK */
/* "0" = Mask; "1" = enable */
#define REG_HOST_IRQ_MASK          0x01D4
#define REG_HOST_IRQ_MASK_MASK     0x000000ff
#define REG_HOST_IRQ_MASK_SHIFT    0
#define REG_HOST_IRQ_MASK_WIDTH    8

/* SHRAM_RM */
#define REG_SHRAM_RM          0x01F8
#define REG_SHRAM_RM_MASK     0x77777777
#define REG_SHRAM_RM_SHIFT    0
#define REG_SHRAM_RM_WIDTH    24

/* RAMS_RM */
#define REG_RAMS_RM          0x01FC
#define REG_RAMS_RM_MASK     0x77777777
#define REG_RAMS_RM_SHIFT    0
#define REG_RAMS_RM_WIDTH    24

/* DELINEATOR_READY_FIX_ENABLE */
#define REG_DELINEATOR_READY_FIX_ENABLE          0x0204
#define REG_DELINEATOR_READY_FIX_ENABLE_MASK     0x00000001
#define REG_DELINEATOR_READY_FIX_ENABLE_SHIFT    0
#define REG_DELINEATOR_READY_FIX_ENABLE_WIDTH    1

/* RX_TX_RAMS_RM */
#define REG_RX_TX_RAMS_RM          0x0208
#define REG_RX_TX_RAMS_RM_MASK     0x00007777
#define REG_RX_TX_RAMS_RM_SHIFT    0
#define REG_RX_TX_RAMS_RM_WIDTH    12

/* SHRAM_EXT_RM */
#define REG_SHRAM_EXT_RM          0x020C
#define REG_SHRAM_EXT_RM_MASK     0x00007777
#define REG_SHRAM_EXT_RM_SHIFT    0
#define REG_SHRAM_EXT_RM_WIDTH    12

/* RAMS2_RM */
#define REG_RAMS2_RM          0x0210
#define REG_RAMS2_RM_MASK     0x77777777
#define REG_RAMS2_RM_SHIFT    0
#define REG_RAMS2_RM_WIDTH    24

/* RAMS3_RM */
#define REG_RAMS3_RM          0x0214
#define REG_RAMS3_RM_MASK     0x77777777
#define REG_RAMS3_RM_SHIFT    0
#define REG_RAMS3_RM_WIDTH    24
#endif 
