;*********************************************************************
;	mario kart << compress -> decode >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		INCLUDE	../JOIN/label.def
;----------------------------------------------------------------------
		GLB	Decode_M7copy	; mode7 char -> mode7 char
		GLB	Decode_M0_buff	; mode0 char -> buffer
		GLB	Decode_M7_BF	; mode7 ispk char -> buffer(char)
		GLB	Decode_M7_buff	; mode7 ispk char -> buffer
;- - - - - - - - - - - - - - - - - - - - - - 
;== GfB^[p ==
		GLB	Decode_mode7	; mode7 ispk char -> VRAM
		GLB	Decode_M3	; mode3 char -> VRAM
;- - - - - - - - - - - - - - - - - - - - - - 
		EXT	Decode_7F_X
;----------------------------------------------------------------------
		COMN
work		DS	2
counter		DS	2
ATTR		DS	2
input_addr	DS	3
output_addr	DS	3
start_char	DS	2
counter_char	DS	2
counter_limit	DS	2
;----------------------------------------------------------------------
data_char	DS	3
line_counter	DS	2
;----------------------------------------------------------------------
readdata_addr	DS	3	; ǂݍݐ̃f[^AhX ( M0_buff )
;- - - - - - - - - - - - - - - - 
m1_buff		EQU	0C00H		; write buffer
;----------------------------------------------------------------------
;	prog
;		extend
;		mem16	
;		idx16	
	EXTEND
bank84		SECT	REL
		mem16
		idx16
;----------------------------------------------------------------------
read_bank	equ	83H		; dbank_10000
;*********************************************************************
;
;		Buffer copy
;
;*********************************************************************
;		LDX	#DP
;		JSL	Decode_M0_buff
;DP		DL	7FD000H		; read address
;		DL	7F6000H		; write address	
;		DB	1		; character count
;		DB	20H		; character start number
;		DB	0		; end code
;----------------------------------------------------------------------
Decode_M0_buff	SEP	#00100000B
		MEM8
		PHB			;>
		PLA
		STA	<readdata_addr+2	; f[^oNZbg

		PHB			;>
		LDA	!2,X		;B	input bank
;
		PHA			; >
		LDY	!3,X		;W
		STY	<output_addr+0	;W
		LDA	!5,X		;B
		STA	<output_addr+2	;B
		LDY	!0,X		;W	input address
		STY	<input_addr	;W
		LDY	#0		;W	output offset
		PLB			; <	set data bank

		INX
		INX
		INX
		INX
		INX
		INX
		STX	<readdata_addr
;
next_db		LDA	[<readdata_addr]
		BEQ	end_db
		STA	<counter+0		;B character count
		STZ	<counter+1
		INC	<readdata_addr
		LDA	[<readdata_addr]	;B start character
		INC	<readdata_addr
		JSR	Set_db
		BRA	next_db
;
end_db		PLB			;<
		REP	#00100000B
		MEM16
		RTL
;----------------------------------------------------------------------
Set_db		REP	#00100000B
		MEM16
		AND	#00FFH
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ADC	<input_addr
		TAX
loop_db_next	LDA	#8
		STA	<counter_char
loop_db_char	LDA	!0,X			; 10H byte copy
		STA	[<output_addr],Y	; (2 bit 1 char)
		INX
		INX
		INY
		INY
		DEC	<counter_char
		BNE	loop_db_char
		DEC	<counter
		BNE	loop_db_next
		SEP	#00100000B
		MEM8
		RTS
		mem16
		idx16
;#####################################################################
;		mode7 character		ISPK -> VRAM or BUFFER
;#####################################################################
;*********************************************************************
;		mode7 character BUFFER copy
;*********************************************************************
;		LDX	#DP
;		JSL	>Decode_M7copy
;DP		DL	7FD000H			; read address
;		DL	7F6000H			; write address	
;		DB	1			; character count
;		DB	20H			; character number
;		DB	0			; end code
;----------------------------------------------------------------------
Decode_M7copy	SEP	#00100000B
		MEM8
		LDY	!0,X			;W	input address
		STY	<input_addr+0		;W
		LDA	!2,X			;B	input bank
		STA	<input_addr+2		;B
		LDY	!3,X			;W
		STY	<output_addr+0		;W
		LDA	!5,X			;B
		STA	<output_addr+2		;B
		REP	#00100000B
		MEM16
;
next$		LDA	!5,X		; counter read
		AND	#0FF00H
		BEQ	exit$
		LSR	A
		LSR	A
		LSR	A
		PHA			;>>
;
		LDA	!6,X		; start character read
		AND	#0FF00H
		LSR	A
		LSR	A
		TAY
		PLA			;<<
		PHX			;>>
		TAX			; X=counter
		JSR	copy_char
		PLX			;<<
		INX
		INX
		BRA	next$
exit$		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - 
copy_char
loop$		LDA	[<input_addr],Y
		STA	[<output_addr]
		INY
		INY
		INC	<output_addr
		INC	<output_addr
		DEX
		BNE	loop$
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - 

;*********************************************************************
;		mode7 character BUFFER set
;*********************************************************************
;		LDX	#read address	( 7F bank )
;		LDY	#write address	( 7F bank )
;		LDA	#character_count
;		JSL	>Decode_M7_BF
;----------------------------------------------------------------------
;		LDX	#DP
;		JSL	>Decode_M7_buff
;DP		DL	7FD000H			; read address
;		DL	7F6000H			; write address	
;		DB	1			; character count
;		DB	20H			; character number
;		DB	0			; end code
;----------------------------------------------------------------------
;input_addr	DS	3			;
;output_addr	DS	3			;
;ATTR		DS	2			; attribute
;counter	DS	2			; write character counter
;counter_char	DS	2			; 1 character loop counter
;start_char	DS	2			; write start character number
;----------------------------------------------------------------------
Decode_M7_BF	STX	<input_addr+0
		STY	<output_addr+0
		STA	<counter
		PHB
		LDA	#07FH
		STA	<input_addr+2
		STA	<output_addr+2
		STZ	<start_char
		LDY	#0
		SEP	#00100000B
		MEM8
		JSR	Set_1_data
		REP	#00100000B
		MEM16
		PLB
		RTL
;----------------------------------------------------------------------
Decode_M7_buff	SEP	#00100000B
		MEM8
		PHB				;>
		LDY	!0,X			;W	input address
		STY	<input_addr+0		;W
		LDA	!2,X			;B	input bank
		STA	<input_addr+2		;B
		LDY	!3,X			;W
		STY	<output_addr+0		;W
		LDA	!5,X			;B
		STA	<output_addr+2		;B
		STZ	<start_char+1		;B
		LDY	#0			;W	output offset
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
next_data	LDA	!6,X			;B
		BEQ	end_data
		STA	<counter		;B character count
		LDA	!7,X			;B 
		STA	<start_char		;B start character
		JSR	Set_1_data
		INX
		INX
		BRA	next_data
end_data	PLB				;<
		REP	#00100000B
		MEM16
		RTL
;----------------------------------------------------------------------
Set_1_data	PHX				;>>
		PHB				;  >
		LDA	<input_addr+2
		PHA				;   >
		PLB				;   <
		REP	#00100000B
		MEM16
		LDA	<start_char
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A				;CLC
		ADC	<input_addr+0
		TAX				;X = input dara pointer
		SEP	#00100000B
		MEM8
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
count_loop	PHY				;  >>
		LDY	<start_char		;W(B)
		LDA	[<input_addr],Y		;B
		STA	<ATTR			;B
		PLY				;  <<
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	#32			;B 1char 32byte -> 64byte
		STA	<counter_char		;B
char_loop	LDA	!0100H,X		;B 1 character set
		AND	#0FH			;B
		BEQ	nuki_set11
		ORA	<ATTR			;B
nuki_set11	STA	[<output_addr],Y
		INY				;W
		LDA	!0100H,X		;B
		LSR	A
		LSR	A
		LSR	A
		LSR	A				;
		BEQ	nuki_set22
		ORA	<ATTR			;B
nuki_set22	STA	[<output_addr],Y	;B
		INY				;W
		INX				;W buffer +1*32
		DEC	<counter_char		;B
		BNE	char_loop		;
		INC	<start_char		;B character +1
		DEC	<counter		;B counter -1
		BNE	count_loop	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		PLB				;  <	
		PLX				;<<
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;
;
;
;
;
;
;
;
;
;
;
;= = = = =  editer program = = = = = = = = =
;
;
;
		EXTEND
editer		SECT	REL
		mem16
		idx16
;----------------------------------------------------------------------
;Decode_M3	rtl
;Decode_mode7	rtl
;Decode_M7_vram	rtl
;Conv_mode3	rtl
;----------------------------------------------------------------------


	if	1
;*********************************************************************
;		mario kart mode7 set
;*********************************************************************
;cf.
;	7F0000H - 7F20FFH (2100H)
;		compress mode char -> mode7 character -> VRAM
;
;		LDX	#VRAM_address		; VRAM address
;		LDA	#100H			; character count
;		JSL	>Decode_mode7
;----------------------------------------------------------------------
;*********************************************************************
;		mario kart mode7 set
;*********************************************************************
;cf.
;	7F0000H - 7F20FFH (2100H)
;		compress mode char -> mode7 character -> VRAM
;
;		LDX	#VRAM_address		; VRAM address
;		LDA	#100H			; character count
;		JSL	>Decode_mode7
;----------------------------------------------------------------------
Decode_mode7	PHB				;>
		STA	<counter		;W character count
		STZ	<start_char		;W start character
		SEP	#00100000B
		MEM8
		LDY	#m7_buff		;W read address 7F0000H
		STY	<input_addr+0		;W
		LDA	#m7_buff/65536		;B
		STA	<input_addr+2		;B
		LDA	#80H			;B
		STA	!Screen_step		;B
		STX	!Screen_address+0	;W X = VRAM address 
		JSR	write_VRAM
		PLB				;<
		REP	#00100000B
		MEM16
		RTL
;*********************************************************************
;		mode7 character VRAM set
;*********************************************************************
;cf.
;		LDX	#DP
;		JSL	>Decode_M7_vram
;DP		DL	7FD000H			; read address
;		DW	0000H			; write VRAM
;		DB	0C0H			; character count
;		DB	0			; start character
;----------------------------------------------------------------------
;input_addr	DS	3			;
;ATTR		DS	2			; attribute
;counter	DS	2			; write character counter
;start_char	DS	2			; write start character number
;----------------------------------------------------------------------
m7_buff		EQU	7F0000H
;----------------------------------------------------------------------
Decode_M7_vram	PHB				;> push data bank
		mem16
		LDA	!6,X			;W start char
		AND	#00FFH			;W
		STA	<start_char
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A				;(CLC)
		ADC	!0,X			;W input_addr (addr)
		STA	<input_addr+0		;W
		SEP	#00100000B
		MEM8
		LDA	!2,X			;B input_addr (bank)
		STA	<input_addr+2		;B
		LDA	#80H			;B
		STA	!Screen_step		;B
		LDY	!3,X			;W
		STY	!Screen_address+0	;W
		LDA	!5,X			;B
		STA	<counter		;B
;
		JSR	write_VRAM
;
		PLB				;<	pull data bank
		REP	#00100000B
		MEM16
		RTL
;----------------------------------------------------------------------
		mem8
write_VRAM	PHX				;>>
		LDY	#100H
main_loop	PHY				;  >>
		LDY	<start_char		;W
		LDA	[<input_addr],Y		;B
		STA	<ATTR			;B
		PLY				;  <<
;----------------------------------------------------------------------
		LDX	#32			;W 1char 32byte -> 64byte
character_loop	LDA	[<input_addr],Y		;B 1 character set
		AND	#0FH			;B
		BEQ	nuki_set1
		ORA	<ATTR			;B attribute
nuki_set1	STA	!Screen_write+1		;B
		LDA	[<input_addr],Y
		LSR	A
		LSR	A
		LSR	A
		LSR	A				;
		BEQ	nuki_set2
		ORA	<ATTR			;B attribute
nuki_set2	STA	!Screen_write+1		;B
		INY				;W
		DEX				;W
		BNE	character_loop		;
		INC	<start_char		;B
		DEC	<counter
		BNE	main_loop
		PLX				;<<
		RTS
;*********************************************************************
;		convert mode7char(buffer) -> mode3char(VRAM)
;*********************************************************************
;<< exsample >>
;		LDA	# mode7 character data (addr)
;		LDY	# mode7 character data (bank)
;		LDX	# VRAM address
;		JSR	Conv_mode3
;----------------------------------------------------------------------
Conv_mode3	PHP
		REP	#00010000B
		SEP	#00100000B
		MEM8
		IDX16
		STA	<data_char+2		;B read bank
		STY	<data_char+0		;W address 
		LDA	#80H			;B
		STA	!Screen_step		;B
		STX	!Screen_address+0	;W
;
		LDY	#0			;W
;------------------------------------- ; 1 character buffer set ------
next_character
		LDX	#0			;W
char_loopX
		LDA	#8			;B
		STA	<line_counter		;B
line_loop
		LDA	[<data_char],Y		;B
;
		LSR	A			;B
		ROL	!m1_buff+00H,X		;B
		LSR	A			;B
		ROL	!m1_buff+01H,X		;B
		LSR	A			;B
		ROL	!m1_buff+10H,X		;B
		LSR	A			;B
		ROL	!m1_buff+11H,X		;B
		LSR	A			;B
		ROL	!m1_buff+20H,X		;B
		LSR	A			;B
		ROL	!m1_buff+21H,X		;B
		LSR	A			;B
		ROL	!m1_buff+30H,X		;B
		LSR	A			;B
		ROL	!m1_buff+31H,X		;B
;
		INY				;W
		DEC	<line_counter		;B
		BNE	line_loop		
;
		INX				;W
		INX				;W
		CPX	#10H			;W
		BNE	char_loopX
;
		REP	#00100000B
		MEM16
		LDX	#00H			;W
vram_set	LDA	!m1_buff,X		;W
		STA	!Screen_write+0		;W
		INX				;W
		INX				;W
		CPX	#40H			;W(8bit mode)
		BNE	vram_set
		SEP	#00100000B
		MEM8
;--------------------------------------------------------------------
		CPY	#4000H		; 256 char
		BNE	next_character
;--------------------------------------------------------------------
		PLP
		RTS
;*********************************************************************
;		convert mode7 -> mode3
;*********************************************************************
CGX_item	EQU	BG_ITEM	
mode7_ispk_buff	EQU	7F8000H
mode7_char_buff	EQU	7F4000H
;---------------------------------------------------------------------
main_char	DL	mode7_ispk_buff
		DL	mode7_char_buff
		DB	0C0H
		DB	0,0
yaku_char	DL	mode7_ispk_buff+2000H	
		DL	mode7_char_buff+3000H
		DB	040H
		DB	0,0
;----------------------------------------------------------------------
Main_char	DL	mode7_ispk_buff
		DW	0000H			; VRAM 
		DB	0C0H			; count
		DB	0			; start
Yaku_char	DL	mode7_ispk_buff+2000H
		DW	3000H
		DB	040H
		DB	0				
;----------------------------------------------------------------------
		mem16
		idx16
VRAM_TEST	RTL
;-------------------------------------------- ; debug ISPK -----------
		LDY	#MAP00_CHR
		LDA	#MAP00_CHR/65536
		LDX	#mode7_ispk_buff
		JSL	>Decode_7F_X
		LDY	#CGX_item
		LDA	#CGX_item/65536
		LDX	#mode7_ispk_buff+2000H
		JSL	>Decode_7F_X
;---------------------------------------------------------------------
Decode_mode3	PHB
		PHK
		PLB
;
;- - - - - - - - - - - - - - - - - - - - - - 
	;	LDX	#Main_char		; mode7 character 
	;	JSL	>Decode_M7_vram		;  -> VRAM
	;	LDX	#Yaku_char
	;	JSL	>Decode_M7_vram
;
	;	LDX	#main_char		; mode7 character
	;	JSL	>Decode_M7_buff		;  -> buffer
	;	LDX	#yaku_char
	;	JSL	>Decode_M7_buff
;- - - - - - - - - - - - - - - - - - - - - - 
Decode_M3	PHB
		PHK
		PLB
;
		LDY	#mode7_char_buff	; read buffer addr
		LDA	#mode7_char_buff/65536
		LDX	#6000H			; write VRAM addr
		JSR	Conv_mode3
;-------------------------------------------- ; debug screen data ---
		LDA	#80H
		STA	!Screen_step
		LDA	#5000H
		STA	!Screen_address
		LDA	#0
slp		STA	!Screen_write
		INC	A
		CMP	#0100H
		BNE	slp
;--------------------------------------------------------------------
		PLB
		RTL
;======================================================================
	endif
		END
