;******************* Driver-point.asm *************************
;
			extend
;-----------------------------------------------------
			include		../join/rp5c77
			include		../join/buffer.def
			include		../join/rp5a22
			include     ../join/work.def
			include		../join/label.def
			include		../join/object.def
;-----------------------------------------------------
			glb		DP_init,DP_main,DP_nmi
;
			ext		PPU_INT_SET,Set_DMA
			ext		Init_demokart,Set_demokart
			ext		DMA_demokart,KEY_CHECK
			ext		BGM_fade_out,OBJ_ERASE
			ext		X_inx,Y_iny
;---------------------------------------------------
address			equ		60h			;2byte
address1		equ		62h			;2byte
name_address	equ		64h			;2byte
Rank_counter	equ		66h			;2byte
Display_counter	equ		68h			;2byte
button_TG       equ     6ah         ;4byte
Move_counter	equ		6eh			;2byte
Revolve_counter	equ		70h			;2byte
Xmove_counter	equ		72h			;2byte
Swing_counter	equ		74h			;2byte
Swing_flag		equ		76h			;2byte
Rank_number		equ		78h			;2byte
Check_rank		equ		7ah			;2byte
Scroll_2h		equ		7eh			;2byte
Driver_flag		equ		80h			;2byte
Flag_counter	equ		82h			;2byte
Flag_timer		equ		84h			;2byte
flag_speed		equ		86h			;2byte
OBJ_check_flag  equ     96h
;-----------------------------------------------------
kart_set1		equ		180h
kart_set		equ		1a0h
oamdat			equ		200h
msbdat			equ		400h
;-----------------------------------------------------
bankf      		sect    rel         ;(PBR=03)
;==================================================
;**************************************************
;			INITIAL ROUTINE
;**************************************************
;==================================================
DP_init			equ		$
				phb
				phk
				plb
;
				ldy		#OBJ_data1
				JSL		>Init_demokart
;
				mem8
				idx8
				sep		#00110000b
;
				JSR		PPU_INT_SET			;ppu&oam initial set.
				JSR		DRIVER_PPU
				JSR		Driver_tensou
;
				mem16
				idx16
				rep		#00110000b
;
				plb
				RTL
;===================================================
;***************************************************
;			MAINE ROUNTINE
;***************************************************
;===================================================
DP_main		equ		$
				phb
				phk
				plb
;
				JSR     KEY_CHECK
				JSR		Driver_SCROLL
;--------(UgLÕ`FbN)------
				lda		<Driver_flag
				beq		Result_Set
;
;------------(LOC)-----------
				JSR		Driver_set
				JSR		Rank_End
;
				lda		#300h
				sta		<sprite_count
				JSR		Kart_move
				JSL		>Set_demokart
				jmp		owari_point
;-----------(UgC)--------------
Result_Set		JSR		Result_set
				JSR		Result_end
;
				lda		#200h
				sta		<sprite_count
				JSR		Result_move
				JSL		>Set_demokart
;
owari_point		plb
				RTL
;==============================================
;**********************************************
;			NMI wari komi.			  
;**********************************************
;==============================================
DP_nmi			equ		$
				phb
				phk
				plb
;
				JSR		Name_tensou
				JSL		>DMA_demokart
;
				mem8
				sep		#00100000b	
				lda     <Scroll_2h
				sta		>Scroll_1H
				lda		<Scroll_2h+1
				sta		>Scroll_1H
				mem16
				rep		#00100000b
				plb
				rtl
;===========================================================
;**********************************************************
;					INITIAL SET ROUTINE
;**********************************************************
;===========================================================
;**************************************************
;					PPU&WORK INITIAL SET
;**************************************************
DRIVER_PPU		equ		$
;<<<<<<<<<<<< [y[WNA[ >>>>>>>>>>>>>>
				JSR		Zero_clear
				jmp		Set_PPU		
;
Zero_clear		mem8	
				idx8
				ldx		#0
				lda		#0
loop_GPZ		sta		<address,x
				inx
				cpx		#30h
				bne		loop_GPZ
				mem16
				rep		#00100000b
;
				lda     #1d05h
				sta     <name_address
				lda		#1a8h
				sta		<flag_speed
				lda		#0027h
				sta		<Xmove_counter
;<<<<<<<<<< ʂ̃LN^Zbg >>>>>>>>>>>>>
				ldx		#0
				lda		#2110h
loop_nuki1		sta		kart_set1,x
				inx
				inx
				cpx		#80h
				bne		loop_nuki1
				mem8
				sep		#00100000b
				rts
;<<<<<<<<<<<<<<<<<< PPU SET >>>>>>>>>>>>>>>>>>>>
Set_PPU			lda		#00001001b
				sta		Screen_size			;BG mode1 set.
;
				lda		#00010110b
				sta		Through_screen		;TM
;
				lda		#00010101b
				sta		Screen_bank+1
;
				lda		#00011100b
				sta		Screen_bank+2
;
				lda		#00100010b
				sta		Screen_segment
				lda		#00000000b
				sta     Screen_segment+1
;
				lda     #10000000b
				sta     Screen_step
;
				lda		#00000010b
				sta		Sprite_size
				rts
;********************************************************
;					TENSOU SET
;********************************************************
Driver_tensou	equ		$
;<<<<<<<<<<<<<<<<<< SC_3 >>>>>>>>>>>>>>>>>>>>>>>
				ldx		#18h
				jsr		Set_DMA
;
				ldx		#10h
				jsr		Set_DMA
;<<<<<<<<<<<<<<<<<<< SC_1 >>>>>>>>>>>>>>>>>>>>>>
				ldx		#04
				jsr     Set_DMA
;<<<<<<<<<<<<<<<<< SC_3.CGX >>>>>>>>>>>>>>>>>>>>
				ldx		#12h
				jsr     Set_DMA
;
				ldx		#14h
				jsr     Set_DMA
;<<<<<<<<<<<<<<<<<< SC_1.CGX >>>>>>>>>>>>>>>>>>>
				ldx		#16h
				jsr		Set_DMA
;<<<<<<<<< [Xʕ̏㑤Zbg >>>>>>>>>>
				lda		#86h
				sta     Screen_address
				lda     #1ch
				sta     Screen_address+1
;
				mem16
				rep		#00100000b
;
				ldx		#0
Set_vram		lda		Race_result,x
				cmp		#0ffffh
				beq		Set_low
				sta		Screen_write
				inx
				inx
				jmp		Set_vram
Set_low			mem8
				sep		#00100000b
;<<<<<<<< [Xʕ̉Zbg >>>>>>>>>>>
				lda		#0a3h
				sta     Screen_address
				lda     #1ch
				sta     Screen_address+1
;
				mem16
				rep		#00100000b
				ldx		#0
Set_vram1		lda		Race_result1,x
				cpx		#000ah
				beq		Set_round
				cmp		#0ffffh
				beq		Set_owari
Set_screen		sta		Screen_write
				inx
				inx
				jmp		Set_vram1
;------(EhZbg)------------
Set_round		;pha
				;lda		goal_flag			;^C`FbN
				;and		#2000h
				;beq		NO_goal_set
;-----(S[̃Eh)-----
				;pla							;
				;ora		map_pointer
				;jmp		Set_screen
;----(S[Ȃ̃Eh)-----
;NO_goal_set		pla
				ora		map_pointer
;				inc		a
				jmp     Set_screen			
Set_owari		mem8
				sep		#00100000b
;<<<<<<<<<<<<<< CԃZbg >>>>>>>>>>>>>>>>>
				lda		#0e2h
				sta     Screen_address
				lda     #1ch
				sta     Screen_address+1
;
				mem16
				rep		#00100000b
				ldx		#0
				lda		#349eh
Set_vram2		sta		Screen_write
				inx		
				cpx		#1ch
				bne		Set_vram2
;<<<<<<<<<<<<<<<< ̃Zbg >>>>>>>>>>>>>>>>>>>
				idx16
				rep		#00010000b
				ldx		#0
				lda		#00ffh
				sta		msbdat+10h
;
				ldy		#0
				ldx		#0
position_set	lda		Position_data,x
				cmp		#0ffffh
				beq		Set_character
				sta		oamdat+100h,y
				inx
				inx
				JSR		Y_iny
				jmp		position_set
;
Set_character	ldx		#0
				JSR		Flag_move
;<<<<<<<<<<<<<<<< CG_SET >>>>>>>>>>>>>>>>>>>>>>>
CG_set			mem8
				sep		#00100000b		
				lda		#0			
				sta		Color_address
;
      		 	ldx		#0
loop_col	 	lda		>7f4200h,x
			 	sta		Color_write
			 	inx
        	 	lda     >7f4200h,x
			 	sta     Color_write
			 	inx
			 	cpx		#200h
			 	bne		loop_col
;
			    idx8
			 	sep		#00010000b
				rts
;<<<<< ̃LN^[ZbgTu[` >>>>>>
Flag_move		equ		$
				mem16
				idx16
				ldy		#0
				lda		Flag_name,x
				tax
Flag_set		lda		!0,x
				cmp		#0ffffh
				beq		Flag_owari
				sta		oamdat+102h,y
				inx
				inx
				JSR		Y_iny
				jmp		Flag_set
Flag_owari		rts		
;------------------------------------------------
Race_result		DW		342eh,2110h,2110h,2110h
				DW		2110h,2110h,354eh,354fh
				DW		3560h,2110h,3561h,3562h,3563h
				DW		2110h,2110h,2110h,0ffffh

Race_result1	DW		3486h,3462h,348dh,3473h
				DW		2110h,3400h,2110h,2110h
				DW		2110h,355eh,355fh,3570h
				DW		2110h,3571h,3572h,3573h
				DW		2110h,2110h,2110h,0ffffh
;
Flag_name		DW		Flag_data_1,Flag_data_2,Flag_data_3
;
Flag_data_1		DW		2160h,2164h,2162h,2166h,0ffffh
;
Flag_data_2		DW		2168h,216ch,216ah,216eh,0ffffh
;
Flag_data_3		DW		2148h,214ch,214ah,214eh,0ffffh
;
Position_data	DW		9830h,0a830h,9840h,0a840h,0ffffh
;(obj data set)
OBJ_data1		DW		player_r0,0130h,00c0h,0c000h
				DW		player_r1,0130h,00c1h,0c000h
				DW		player_r2,0130h,00c0h,0c000h
				DW		player_r3,0130h,00c1h,0c000h
				DW		player_r4,0130h,00c0h,0c000h
				DW		player_r5,0130h,00c1h,0c000h
				DW		player_r6,0130h,00c0h,0c000h
				DW		player_r7,0130h,00c1h,0c000h
				DW		0				
;=============================================================
;************************************************************
;					MAINE ROUTINE
;************************************************************
;=============================================================
;*********************************************************
;					LOpOZbg
;*********************************************************
Driver_set		equ		$
;<<<<<<<<<<<<< J[gio[`FbN [`>>>>>>>>>>>
				mem16
				idx16
Set_data		lda		<Rank_counter
				cmp		#0010h
				bne		Set_rank		
no_setrank		rts
;<<<<<<<<<<<<<<<<< fBXv[^C}[ >>>>>>>>>>>>>>>>
Set_rank		JSR		Display_timer
				cmp		#0009h
				bne		no_setrank				;display?:no-->no_setrank
				stz		<Display_counter		;flag reset.
;<<<<<<<<<<<< u@t@[AhXZbg >>>>>>>>>>>>>>>>>
				JSR     Buffer_set
;<<<<<<<<<<<<<<<<< ʂZbg >>>>>>>>>>>>>>>>>>>>>>>>>>
				JSR     Nuki_set
;<<<<<<<<<<<<<<<< V_RAM AhXZbg >>>>>>>>>>>>>>>>>
				ldx		<Rank_counter
				JSR		V_ramset
				inc		<name_address
				inc		<name_address
;<<<<<<<<<<<<< Nio[Zbg >>>>>>>>>>>>>>>>>>>>
;----(now point)-----
				lda		point_rank,x
				tax
				lda		<driver_point,x
				sta		<Check_rank
;---(before point)---
				ldx     <Rank_counter
				dex
				dex
				bmi		Same_set
				lda		point_rank,x
				tax
				lda		<Check_rank
				cmp		<driver_point,x
				bne		Rank_up
;----(same rank)----
Same_set		ldx		<Rank_number
				ldy		#0
				lda		Rank_data,x
				jmp		Set_number
;----(rank down)----
Rank_up			ldx     <Rank_counter
				stx		<Rank_number
				ldy		#0
				lda		Rank_data,x
Set_number		sta		(<address),y
				JSR		Y_iny
				phy
;<<<<<<<<<<<<<<<<<<<< OZbg >>>>>>>>>>>>>>>>>>>>>>
				ldx     <Rank_counter
				lda		point_rank,x
				tax
				lda		<driver_number,x
				tax
;-----(_p)-----
				phx  
				JSR     Dakuten_name
;-----(Op)----
name_set		plx
				ply
				JSR     Name_set
;---(jZbg)---
loop_hasen		JSR     Hasen_set
				cpy		#0020h
				bne		loop_hasen
;<<<<<<<<<<<<<<<<< |CgZbg >>>>>>>>>>>>>>>>>>>>>
;---(ZZbg)------
				ldx     <Rank_counter
				lda		point_rank,x
				tax
				lda		<driver_point,x
				sta		Dividend					;4204h
				lda		#0ah
				sta		Divisor						;4206h
				nop
				nop
				nop
				nop
				nop
				nop
				nop
				nop
;---(̌fBXvCZbg)--------				
				lda		Quotient					;4214h
				asl		a
				tax
				lda		Point_data,x
				sta		(<address),y
;---(̌fBXvCZbg)------
				iny
				iny
				lda     Residue						;4216h
				asl		a
				tax
				lda     Point_data,x
				sta     (<address),y
;<<<<<<<<<<<< PAQvC[pJ[Zbg >>>>>>>>>>>>
				lda     <game_mode
				cmp		#04
				beq		Check_2con
;---(1player set)---
				ldx     <Rank_counter
				lda		point_rank,x
				cmp		#1000h
				bne		rank_2player				;1player?:no-->rank_2player
				jmp		Set_1p.color
;
Check_2con		ldx     <Rank_counter				;QRg[p
				lda		point_rank,x
				cmp		#1100h
				bne		rank_2player				;1player?:no-->rank_2player
;
Set_1p.color	ldx		#10h							;color change set.
				jsr		Player_color
				jmp     rank_set					
;----(2player set)----
rank_2player	lda		<game_mode
				bne		rank_set					;2player mode?:no-->rank_set
;
				ldx		<Rank_counter				;color change set.
				lda		point_rank,x
				cmp		#1100h
				bne		rank_set					;2player?:no-->rank_set
;
				ldx		#12h
				jsr		Player_color
				jmp		rank_set
;<<<<<<<<<<<<< J[pTu[` >>>>>>>>>>>>>
Player_color	equ		$
				ldy		#0							;up side color change.
loop_color1		lda		(<address1),y
				ora		Color_data,x
				sta		(<address1),y
				iny
				iny
				cpy		#0020h
				bne		loop_color1
;
				ldy		#0							;low side color change.
loop_color		lda		(<address),y
				ora		Color_data,x
				sta		(<address),y
				iny
				iny
				cpy		#002ch
				bne		loop_color
				rts
;- - - - -- - - - -- - - - - - - - - - - - - - - -
rank_set		JSR		Rank_set
				rts
;--------------------------------------------------------
Point_data		DW		2000h,2001h,2002h,2003h,2004h
				DW		2005h,2006h,2007h,2008h,2009h
;
Rank_data		DW		2001h,2002h,2003h,2004h
				DW		2005h,2006h,2007h,2008h
;
Address_data	DW		1105h,1145h,1185h,11c5h
				DW		1205h,1245h,1285h,12c5h
;
Kart_data		DW		MARIO,LUIZI,KUPPA,PEACH
				DW		KONG,NOKO,KINOP,YOSSY
;
Kart_data1		DW		MARIO1,LUIZI1,KUPPA1,PEACH1
				DW		KONG1,NOKO1,KINOP1,YOSSY1
;
RETIRE			DW		2087h,206fh,2061h,2060h,0ffffh
;
MARIO			DW		207eh,2087h,2064h,0ffffh
MARIO1          DW		0ffffh	
;
LUIZI			DW		2088h,2061h,209ch,206bh,0ffffh
LUIZI1			DW		2110h,2110h,2110h,202eh,0ffffh

;
KUPPA			DW		2067h,2097h,2079h,0ffffh
KUPPA1			DW		2110h,2110h,202fh,0ffffh
;
PEACH			DW		207ah,209ch,2070h,0ffffh
PEACH1			DW		202fh,0ffffh
;
KONG			DW		2073h,208dh,2066h,209ch,2069h,208dh
				DW		2067h,2013h,201bh,0ffffh
KONG1			DW		202eh,2110h,2110h,2110h,2110h,2110h
				DW		202eh,0ffffh
;
NOKO			DW		2078h,2069h,2078h,2069h,0ffffh
NOKO1			DW		0ffffh
;
KINOP			DW		2066h,2078h,207ah,2064h,0ffffh
KINOP1			DW		2110h,2110h,202fh,0ffffh
;
YOSSY			DW		2085h,2097h,206bh,209ch,0ffffh
YOSSY1			DW		0ffffh
;
Color_data		DW		0c00h,1000h,1800h,1400h
				DW		1400h,1400h,1400h,1400h
				DW		0400h,0800h
;
Kart_select     DW      player_r0,player_r1,player_r2,player_r3
				DW      player_r4,player_r5,player_r6,player_r7
;******************************************************
;				[XʗpAOZbg
;******************************************************
Result_set		equ		$
;<<<<<<<<<<<< tF[h͎󂯕tȂ >>>>>>>>>>>>>
				mem16
				idx16
				lda		fade_control			;fade in check.
				beq		Set_result
no_result		rts
;<<<<<<<<<<<<< J[gio[`FbN >>>>>>>>>>>>>>
Set_result		lda		<Rank_counter
				cmp		#0010h
				beq		no_result
;<<<<<<<<<<<<<<< fBXv[^C}[ >>>>>>>>>>>>>>
				JSR		Display_timer
				cmp		#0009h
				bne		no_result
				stz		<Display_counter
;<<<<<<<<<<<<<< u@t@[AhXZbg >>>>>>>>>>>
				JSR		Buffer_set
;<<<<<<<<<<<<<<<< ʂZbg >>>>>>>>>>>>>>>>>>>>>>>
				JSR		Nuki_set
;<<<<<<<<<<<<<<<< V_RAM AhXZbg >>>>>>>>>>>>>
				ldx		<Rank_counter
				JSR		V_ramset
				lda		<name_address
				clc
				adc		#0c00h
				sta		<name_address
;<<<<<<<<<<<<<<< Nio[Zbg >>>>>>>>>>>>>>
				lda		<Rank_counter
				tax
				ldy		#0
				lda		Rank_data,x
				sta		(<address),y
				JSR		Y_iny
				phy
;<<<<<<<<<<<<<<<<< OZbg >>>>>>>>>>>>>>>>>>>>>>
				ldx     <Rank_counter
				lda		rank_index,x
				tax
				lda		<driver_number,x
				tax
;-----(_p)-----
				phx  
				JSR		Dakuten_name
;-----(Op)----
name_set_1		plx
				ply
				JSR		Name_set
;-----(jZbg)-------
Hasen_set_1		JSR		Hasen_set
				cpy		#001ah
				bne		Hasen_set_1
				iny
				iny
;-----(^CZbg)------------
				ldx     <Rank_counter			;J[gZbg
				lda		rank_index,x			;NZbg
				tax
				lda		<driver_time+4,x		;^C`FbN
				cmp		#0ffffh
				beq		Retire_kart
;
				iny
				iny
				JSR		Set_timer
;
				lda		#2028h
				JSR     Set_timer
;
				lda		<driver_time+2,x		;bʑZbg
				and		#00f0h
				lsr		a
				lsr     a
				lsr     a
				lsr     a
				JSR     Set_timer
;
				lda		<driver_time+2,x		;bʑZbg
				and		#000fh
				JSR     Set_timer
;
				lda		#2029h					;R}Zbg
				JSR     Set_timer
;
				lda     <driver_time+1,x		;R}bʑZbg
				and		#00f0h
				lsr		a
				lsr     a
				lsr     a
				lsr     a
				JSR     Set_timer
;
				lda		<driver_time+1,x		;R}bʑZbg
				and		#000fh
				JSR     Set_timer
				jmp		Color_set
;
Set_timer		equ		$
				ora		#2000h
				sta		(<address),y			;Zbg
				iny
				iny
				rts
;<<<<<<<<<<<<<< ^CZbg >>>>>>>>>>>>>>>>>>>>
Retire_kart		ldx		#0
Retire_set		iny
				iny
				lda		RETIRE,x
				cmp		#0ffffh
				beq		Color_set
				sta		(<address),y
				inx
				inx
				jmp		Retire_set
;<<<<<<<<<<<<<<<<< J[Zbg >>>>>>>>>>>>>>>>>>>
Color_set		ldx		<Rank_counter
				JSR		Player_color
;<<<<<<<<<<<<<< JE^[Zbg >>>>>>>>>>>>>>>>>>
Counter_set		JSR     Rank_set
				rts
;******************************************************
;				Tu[`W
;******************************************************
Display_timer	equ		$
				inc		<Display_counter		;display flag set.
				lda		<Display_counter
				rts	
;
Buffer_set		equ		$
				lda		#0180h
				sta		<address1				;up side
				lda		#01a0h
				sta		<address				;low side
				rts
;
Nuki_set		equ		$
				ldy		#0
				lda		#2110h
loop_nuki		sta		(<address1),y			;buffer set.
				iny
				iny
				cpy		#0080h
				bne		loop_nuki
				rts
;
V_ramset		equ		$
				lda		Address_data,x
				sta		name_address			;v_ram address set.
				rts
;
Dakuten_name	equ		$
				ldy		#0004
				lda		Kart_data1,x
				tax
set_dakuon		lda		!0,x
				cmp		#0ffffh
				beq		name_owari
				sta		(<address1),y
				inx
				inx
				iny
				iny
				jmp		set_dakuon
name_owari		rts
;
Name_set		equ		$
				lda		Kart_data,x
				tax
set_name		lda		!0,x
				cmp		#0ffffh
				beq		name_owari
				sta		(<address),y
				inx
				inx
				iny
				iny
				jmp		set_name
;
Hasen_set		equ		$
				iny
				iny
				lda		#20a4h
				sta		(<address),y
				rts
;
Rank_set		equ		$
				inc     <Rank_counter
				inc		<Rank_counter
				rts
;********************************************************
;				ʗpJ[g[uZbg
;********************************************************
Result_move		equ		$
				mem16
				idx16
;<<<<<<<<<<<<<<<<<<< ]Zbg >>>>>>>>>>>>>>>>>>>
				lda		#0008h
				sta		<Revolve_counter
Revolve_loop1	;ldx     <Revolve_counter
;				lda     rank_index,x
;				tax
;				lda		<driver_time,x
;				cmp		#0ffffh
;				bne		revolve_count1				;revolve set?:no-->revolve_counter
;
				ldx     <Revolve_counter
				lda     rank_index,x
				tax
				lda     <driver_number,x
				JSR		Revolve_set
;<<<<<<<<<<<<<< Pt[WJ[gZbg >>>>>>>>>>
revolve_count1	ldx		<Revolve_counter				
				inx
				inx
				cpx		#0010h
				beq		stop_revolve2				;owatri?:yes-->stop_revolve1
				stx		<Revolve_counter
				jmp		Revolve_loop1
stop_revolve2	stz		<Revolve_counter
;-------(UZbg)-----------
				ldx		<Swing_counter
				lda     rank_index,x
				tax
				JSR		SWING_SET
;-------(ړZbg)------------
Set_move1		inc		<Xmove_counter		;J[g̊ԂJ邽߂̃JE^[
				lda		<Xmove_counter
				cmp		#0028h
				bne		Flag_move_set
				stz		<Xmove_counter
;
				ldx     <Move_counter			
				lda		rank_index,x
				tax
				JSR		MOVE_SET
;-------(̗hZbg)---------
Flag_move_set	inc		<Flag_timer			;̗hԊu^C}[ƃ`FbN
				lda		<Flag_timer
				cmp		#0005
				bne		Flag_speed_set
;
				stz		<Flag_timer			;̃LN^[Zbg
				ldx		<Flag_counter
				JSR     Flag_move
;
				ldx		<Flag_counter		;̎ރZbg
				inx	
				inx
				stx		<Flag_counter
				cpx		#0006
				bne		Flag_speed_set
				stz		<Flag_counter
;
Flag_speed_set	lda		#0001
				sta		<OBJ_check_flag 
				ldx		#0100h
				mem8
				sep		#00100000b
loop_flag		dec		oamdat,x
				lda		oamdat,x
				cmp		#0ffh
				bne		loop_flag_set
				JSR		OBJ_ERASE
loop_flag_set	JSR		X_inx
				cpx		#0110h
				bne		loop_flag
				mem16
				rep		#00100000b
				rts
;*********************************************************
;					|CgpJ[g[uZbg
;*********************************************************
Kart_move		equ		$
				mem16
				idx16
;<<<<<<<<<<<<<<<<<<< ]Zbg >>>>>>>>>>>>>>>>>>>
;Revolve_loop	ldx     <Revolve_counter
			;	lda     point_rank,x
			;	tax
			;	lda		<driver_point,x
			;	bne		revolve_counter				;revolve set?:no-->revolve_counter
;
			;	ldx     <Revolve_counter
			;	lda     point_rank,x
			;	tax
			;;	lda     <driver_number,x
			;	JSR		Revolve_set
;<<<<<<<<<<<<< Pt[WJ[gZbg >>>>>>>>>>>
;revolve_counter	ldx		<Revolve_counter				
;				inx
;				inx
;				cpx		#0010h
;				beq		stop_revolve1				;owatri?:yes-->stop_revolve1
;				stx		<Revolve_counter
;				jmp		Revolve_loop
;stop_revolve1	stz		<Revolve_counter
;----(UZbg)----
				ldx		<Swing_counter
				lda     point_rank,x
				tax
				JSR		SWING_SET
;-----(ړZbg)----
Set_move		inc		<Xmove_counter		;J[g̊ԂJ邽߂̃JE^[
				lda		<Xmove_counter
				cmp		#28h
				bne		Kart_owari
				stz		<Xmove_counter
;
				ldx     <Move_counter			
				lda		point_rank,x
				tax
				JSR		MOVE_SET
				rts
;**********************************************************
;					J[gpTu[`W
;**********************************************************
Revolve_set		equ		$
				idx16
				mem16
				tax
				lda     Kart_select,x
				tax
				lda		#0800h						;revolve speed set.		
				clc
				adc		<_poseQ,X
				sta		<_poseQ,X
				rts
;<<<<<<<<<<<<<<<<< spU >>>>>>>>>>>>>>>>>>>
SWING_SET		equ		$
				lda		<_situationYH,x
				cmp		#00c0h
				bne		Set_down
				inc		a
				jmp		Set_Yposition
Set_down		dec		a
Set_Yposition	sta		<_situationYH,x				
;<<<<<<<<<<<<<<< 2t[1J[gZbg >>>>>>>>>>>>>>
				inc		<Swing_counter
				inc		<Swing_counter
				lda		<Swing_counter
				cmp		#0010h
				bne		owari_swing
reset_swing		stz		<Swing_counter
owari_swing		rts
;- - - - - - - - - - - - - - - - - - - - - - -
MOVE_SET		equ		$
				lda     <driver_number,x
				tax	
				lda     Kart_select,x
				tax
;
				lda		#-100h				;sZbg
				sta		<_velocityX,x
;------(Pt[PJ[gZbg)------
				ldx     <Move_counter
				inx
				inx
				cpx		#0010h
				beq		Kart_reset				;owari?:yes-->Kart_reset
				stx		<Move_counter
				jmp		Kart_owari
Kart_reset		stz		<Move_counter
Kart_owari		rts
;******************************************************
;					XN[Zbg
;******************************************************
Driver_SCROLL	equ		$
				mem16
				idx16
				lda		<Scroll_2h			;scroll set.
				sec
				sbc		#01
				sta		<Scroll_2h
				rts
;******************************************************
;				LOAŏI`FbN
;******************************************************
Rank_End		equ		$
;<<<<<<<<<<<<<<<<<< {^`FbN >>>>>>>>>>>>>>>>
				mem16
				idx16						
;
				lda		<Rank_counter
				cmp		#0010h
				bne		owari_rankcheck
;
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				bne		Check_final_set
owari_rankcheck	rts
;<<<<<<<<<<<<<<<<< ŏIR[X`FbN >>>>>>>>>>>>>
Check_final_set	lda		map_pointer			
				cmp		#0005
				bne		Set_race
;<<<<<<<<<<<<<< lLXg Zbg >>>>>>>>>>>>>>>>>>>>
Set_final		lda		#0018h				;t@CiZbg
				jmp		Set_selecta
;
Set_race		lda     #0002h				;̃[XZbg
Set_selecta		sta     <game_selecta
;
				lda     #8f00h
				sta     <fade_control
;
				JSL		>BGM_fade_out
				rts
;********************************************************
;					ʁAŏI`FbN
;********************************************************
Result_end		equ		$
				mem16
				idx16
;
				lda		<Rank_counter
				cmp		#0010h
				bne		owari_result
;
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				bne		Set_point
owari_result	rts
;<<<<<<<<<<<<<< lLXg Zbg >>>>>>>>>>>>>>>>>>>>
Set_point;		lda		goal_flag			;^C`FbN
		;		and		#2000h
		;		beq		Set_race
;
				idx8
				mem8
				sep		#00110000b
				lda		#00010000b			;SC_2oN؂ւ
				sta     Screen_bank+2
				JSR     Zero_clear			;[y[WNA[
				mem16
				idx16
				rep		#00110000b
;
				lda		#0027h
				sta		<Xmove_counter
				lda		#1105h				;AhXZbg
				sta		<name_address
;
				lda		#0001				;LOZbgtO
				sta		<Driver_flag
;
				ldy		#OBJ_data1			;J[gIuWFăZbg
				JSL		>Init_demokart
				rts
;===============================================================
;***************************************************************
;						NMI	ROUTINE
;***************************************************************
;===============================================================
;******************************************************
;					TENSOU SET
;******************************************************
Name_tensou		equ		$
				lda		fade_control
				bne		owari_nmi
;<<<<<<<<<<<<<<<< _p VRAM set >>>>>>>>>>>>>>>>
Tensou_set		mem8     
				idx16
				sep		#00100000b
;---(AhXZbg)----
				lda     <name_address			
				sta     Screen_address
				lda     <name_address+1
				sta     Screen_address+1
;---(])-----
				mem16
				rep		#00100000b
				ldx		#0
loop_Z1			lda		kart_set1,x	
				sta		Screen_write
				inx
				inx
				cpx		#0020h
				bne		loop_Z1	
;<<<<<<<<<<<<<<<< OA VRAM set >>>>>>>>>>>>>>
;---(AhXZbg)-----
				lda		<name_address
				clc		
				adc		#20h
				sta		<name_address
;
				mem8
				sep		#00100000b
;---(address set)---------
				lda		<name_address
				sta     Screen_address
				lda     <name_address+1
				sta     Screen_address+1
;----(])-------
				mem16
				rep		#00100000b
				ldx		#0
loop_Z2			lda		kart_set,x	
				sta		Screen_write
				inx
				inx
				cpx		#002ch
				bne		loop_Z2	
;---(AhXAƂɂǂB----
				lda		<name_address
				sec		
				sbc		#20h
				sta		<name_address
owari_nmi		rts

				END
