;*********************************************************************
;	mario kart << OBJ Hit check >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/effect.def
;----------------------------------------------------------------------
		GLB	Hit_check	;(Hit_car)
		GLB	Hit_battle
		glb	Hit_GP_A,Hit_GP_B
		glb	Hit_TM_A,Hit_TM_B
		glb	Hit_VS
;----------------------------------------------------------------------
		EXT	Move_situation
;- - - - - - - - - - - - - -
		ext	sound_my_dokan
		ext	sound_enemy,sound_wood,sound_kamebana,sound_enemyspin
;----------------------------------------------------------------------
		COMN
;- - - - - - - - - - - - - -
angle		ds	2	; work
speed		ds	2
index_offset	ds	2
;- - - - - - - - - - - - - -
work		DS	2
winner_index	DS	2
lost_index	DS	2
;- - - - - - - - - - - - - -
distance_work	DS	2
player_work	DS	2
winner_speed	DS	2
lost_speed	DS	2
;----------------------------------------------------------------------
vx1		DS	2
vx2		DS	2	; 16
vy1		DS	2	; 18
vy2		DS	2	; 1a
;----------------------------------------------------------------------
double_hit	DS	2	; QxtO
;- - - - - - - - - - - - - -
		EXTEND
objdata	SECT	REL
		mem16
		idx16
STOP_TIME	EQU	8
;#####################################################################
;		SPRITE HIT CHECK
;#####################################################################
;*********************************************************************
;		ʏ̓`FbN	( GP )
;*********************************************************************
;- - - - - - - - - - - - - - 
Hit_GP_A	jsr	Hit_TM_A	; 
		jmp	Hit_check_A
;- - - - - - - - - - - - - - 
Hit_GP_B	jsr	Hit_TM_B	; 
		jmp	Hit_check_B
;*********************************************************************
;		urp`FbN	( VS )
;*********************************************************************
Hit_check
Hit_VS	
	;	jsr	brank_on
		jsr	Hit_TM_A
		jsr	Hit_TM_B
		jsr	Hit_check_A
		jsr	Hit_check_B
	;	jsr	brank_off
		rts
;*********************************************************************
;		^CA^bNp	( TM )
;*********************************************************************
Hit_TM_B	ldx	#player_r1
		ldy	#_distance_B
		lda	#40h
		bra	Hit_TM
; - - - - - - - - - - - - - - - - - - - - - - - -
Hit_TM_A	ldx	#player_r0
		ldy	#_distance_A
		lda	#0
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Hit_TM		sta	<index_offset
		stx	<player_work
		sty	<distance_work
		lda	!course_type	;΂ȂII
		beq	exit$
; - - - - - - - - - - - - - - - - - - - - - - - -
		ldx	#network_index
		bra	entry$
loop$		clc
		adc	<index_offset
		tay
		lda	(<distance_work),y
		sec
		sbc	#0e0h
		cmp	#040h			; 0e0h < dist < 120h
		bcs	skip$
; - - - - - - - - - - - - - - - - - - - - - - - -
		phx			; >>
		ldx	<player_work	; x = player index
		jsr	polehit_check	; y = enemy index
		plx			; <<
; - - - - - - - - - - - - - - - - - - - - - - - -
skip$		inx
		inx
entry$		lda	<0,x
		bne	loop$
exit$		rts
;*********************************************************************
;		ogp`FbN ( BT )
;*********************************************************************
Hit_battle	ldx	<A_forward	; start pointer = X
		bra	entry$
;- - - - - - - - - - - - - - - - - - - - - -
loop$		lda	<_status,x
		bit	#03000h		; ogp薳rbg
		bne	skip_2$
;- - - - - - - - - - - - - - - - - - - - - -
skip$		lda	!_status,y
		bit	#03000h		; ogp薳rbg
		beq	skip_1$	
		jsr	next_forward	; nj܂Ń[v
		bra	skip$
;- - - - - - - - - - - - - - - - - - - - - -
skip_1$		ora	<_status,x
		bmi	skip_11$
		jsr	entry_check_KT	; J[gm̂
		bra	skip_2$
skip_11$	jsr	entry_check_AT	; ACê
skip_2$		tyx
entry$		ldy	<_forward_A,X
		cpy	#A_root
		bne	loop$
		rts
;- - - - - - - - - - - - - - - - - - - - - -
next_forward	lda	!_forward_A,y
		cmp	#A_root
		bne	exit$
		pla			;<< del return value
exit$		tay
		rts

;************** GPp{[` ********************************
;----------------------------------------------------------------------
;		`ʂ͈̓̓T[`
;----------------------------------------------------------------------
Hit_check_A	ldx	<A_forward	; start pointer = X
		bra	entry$
;- - - - - - - - - - - - - - - - - - - - - -
loop$		lda	<_status,x	; item ?
		ora	!_status,y
		bmi	item$
		lda	!_distance_A,y
		bmi	next$
		cmp	!hit_distance	; `FbNsȂ
		bcc	next$
check$		jsr	entry_check_KT
next$		tyx
entry$		ldy	<_forward_A,x
		cpy	#A_root
		bne	loop$
end$		rts
item$		jsr	entry_check_AT
		bra	next$
;----------------------------------------------------------------------
;		aʂ͈̓̓T[`
;----------------------------------------------------------------------
Hit_check_B	LDX	<B_forward	; start pointer = X
		BRA	entry$
;- - - - - - - - - - - - - - - - - - - - - -
loop$		LDA	<_status,X	; item ?
		ORA	!_status,Y
		BMI	item$
		LDA	!_distance_B,Y
		BMI	next$
		CMP	!hit_distance	; `FbNsȂ
		BCC	next$
check$		JSR	entry_check_KT
next$		TYX
entry$		LDY	<_forward_B,X
		CPY	#B_root
		BNE	loop$
		RTS
item$		jsr	entry_check_AT
		bra	next$
;- - - - - - - - - - - - - - - - - - - -


;************** W͈̓`FbN ***************************************
;----------------------------------------------------------------------
;	WœĂ邩`FbN ( 킫Qp )
;----------------------------------------------------------------------
polehit_check	

		lda	!_situationXH,y		; structure
		sec
		sbc	<_situationXH,x		; player X position
		clc
		adc	#4
		cmp	#8
		bcs	exit$
; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		lda	!_situationYH,y		; structure
		sec
		sbc	<_situationYH,x		; player Y position
		clc
		adc	#4
		cmp	#8
		bcs	exit$
;----------------------------------------------------------------------
		lda	<_poo_status,x		; x = kart index
		bne	exit$
		lda	<_BGcheck_flag,x	; BG hit ?
		bne	exit$
		lda	<_situationZH,x		; Z check
		cmp	#4			; 荂
		bcs	exit$
		lda	!_situationZL+1,y
		sec
		sbc	!polehit_1
		cmp	!polehit_2
		bcs	exit$

		lda	!goal_kabe
		sta	>keycode_camera		; Jʏ탂[h

		jmp	Crash_pole		;QƃqbgI
						;Pʂ rts
exit$		rts
;----------------------------------------------------------------------
;	WœĂ邩`FbN ( J[g^ACep j
;----------------------------------------------------------------------
entry_check_KT	LDA	!_situationXH,Y		; your car
		SEC
		SBC	<_situationXH,X		; my car
		CLC
		ADC	#4
		CMP	#8
		BCS	next_hit	
;----------------------------------------------------------------------
		LDA	!_situationYH,Y		; your car
		SEC
		SBC	<_situationYH,X		; my car
		CLC
		ADC	#4
		CMP	#8
		BCS	next_hit
;----------------------------------------------------------------------
		lda	!_hit_timer,Y		; OBJ 蒆H
		ora	<_hit_timer,X
		sta	<double_hit		; / 0 or 1 /
		dec	a
		dec	a
		bpl	next_hit		; / -1,-2 /	
;----------------------------------------------------------------------
		LDA	<_BGcheck_flag,X	; BG 蒆
		ORA	!_BGcheck_flag,Y
		BNE	next_hit
;- - -
		lda	#2
		cmp	<event_index,x
		bcc	next_hit
		cmp	!event_index,y
		bcc	next_hit

		lda	<_flag,x		; Xs͓ȂI
		bpl	skip0$
		lda	<kart_status,x
		and	#ON_spin		; }CJ[ICXs
		bne	next_hit
		lda	<spin_counter,x		; }CJ[JXs
		cmp	#0d0H
		bcs	next_hit

skip0$		lda	!_flag,y
		bpl	skip1$
		lda	!kart_status,y
		and	#ON_spin		; }CJ[ICXs
		bne	next_hit
		lda	!spin_counter,y		; }CJ[JXs
		cmp	#0d0H
		bcs	next_hit
;- - - 
skip1$		lda	#4
		cmp	<_situationZH,x		; ' Z check '
		bcc	next_hit
		cmp	!_situationZH,y		; ' Z check '
		bcs	entry_hit

next_hit	rts
;
;
;
;----------------------------------------------------------------------
entry_check_AT	LDA	!_situationXH,Y		; your car
		SEC
		SBC	<_situationXH,X		; my car
		CLC
		ADC	#4
		CMP	#8
		BCS	exit$
;----------------------------------------------------------------------
		LDA	!_situationYH,Y		; your car
		SEC
		SBC	<_situationYH,X		; my car
		CLC
		ADC	#4
		CMP	#8
		BCS	exit$
;----------------------------------------------------------------------
		lda	!_hit_timer,Y		; OBJ 蒆H
		ora	<_hit_timer,X
		sta	<double_hit		; / 0 or 1 /
		dec	a
		dec	a
		bpl	exit$			; / -1,-2 /	
;----------------------------------------------------------------------
		LDA	<_BGcheck_flag,X	; BG 蒆
		ORA	!_BGcheck_flag,Y
		BNE	exit$
		lda	#0420h
		cmp	<_situationZL+1,x	; ' Z check '
		bcc	exit$
		cmp	!_situationZL+1,y	; ' Z check '
		bcs	entry_hit
exit$		RTS
;----------------------------------------------------------------------

;
;
;
;
;
;
;
;
;
;
;
;*********************************************************************
;	nai 菈 MAIN CONTROL
;*********************************************************************
entry_hit	PHX				;>>
		PHY				;  >>
;- - - - - - - - - - - - - - - - - - - - - - - -
		JSR	Set_flag
;---------------------------------------------- ; winner check -------
		LDA	<_HP,X
		CMP	!_HP,Y
		BCS	crash_1000
		TYA
		TXY
		TAX
crash_1000	STX	<winner_index		; X =  OBJ
		STY	<lost_index		; Y =  OBJ
;---------------------------------------------- ; item check -------
		LDA	<_HP,X			; winner  
		AND	#0C000H			; = fire or star ?
		BEQ	kart$			; G/ACe	
		JSR	crash_special
		BRA	exit$
kart$		JSR	kart_hit		; J[gm̓
;- - - - - - - - - - - - - - - - - - - - - - - -
exit$		PLY				;  <<
		PLX				;<<
		RTS				;		
;*********************************************************************
;	Փ˂ƂɗĂtO
;*********************************************************************
;
;------------------------fedcba9876543210------ ; set crash flag  ----
Set_flag	

		STX	<_crash_index,Y		; Փ˂ index
		STY	<_crash_index,X		;
		LDA	#8007H			; Փ OBJ ^C}
		STA	<_crash_timer,X		;
		STA	!_crash_timer,Y		;

;------------------------fedcba9876543210------ ; set bound flag -----

		LDA	#0001000000000000B	; Փ˂m点bit
		ORA	<_flag,X
		STA	<_flag,X
		LDA	#0001000000000000B
		ORA	!_flag,Y
		STA	!_flag,Y
;
		lda	#STOP_TIME		; `FbN s\
		sta	<_hit_timer,x
		sta	!_hit_timer,y

		RTS
;
;*********************************************************************
;		special
;*********************************************************************
crash_special	BMI	crash_win_star		; ͖GH
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	ACȅ ( ACȅ j
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
crash_win_item	JSR	erase_Xsprite		; ACe
		LDA	!_status,y
		BMI	item_double
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( ACeɕJ[g̃Xs )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	<_item_no,x		; ^Cv no
		tax
		jmp	(!item_spin,x)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( ƂACe )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
item_double	jsr	erase_Ysprite
		jsl	>sound_kamebana
		jmp	nomal_hit
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( G̏ )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
crash_win_star	LDA	!_HP,Y			; double star ?
		BMI	crash_double		; yes 
		ASL	A			; item ?
		BMI	crash_lost_item		; yes
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( GɕJ[g̃Xs )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
crash_spin
		lda	!_flag,y
		bmi	skip$

		jsl	>sound_enemyspin	; G GXs

skip$		lda	#effect_mycrash
		ora	<_effect_flag,x
		sta	<_effect_flag,x
		jsr	spin_hit
		jmp	star_crash
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( ACȅ )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
crash_lost_item	jsr	erase_Ysprite		; ACe
		jsl	>sound_kamebana
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( ƂG )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
crash_double	
		lda	#effect_mycrash
		ora	<_effect_flag,x
		sta	<_effect_flag,x
		jmp	nomal_hit	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	( ACeɕJ[g̃Xs )
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

item_spin	DW	fire$		; 0 oii
		DW	midori_kame$	; 2 ΃J
		DW	kame$		; 4 ԃJ
		DW	kame$		; 6 L[ ( ΃J j
		DW	banana$		; 8 oii^CvU
		DW	banana$		; A ~TC^CvU
		DW	fire$		; C oii
		DW	tamago$		; E uK
;--------------------------------------------------------------------
; oii^Cvn
;- - - - - - - - - - - - - - - - - - - - - - - - - -
banana$		ldx	<winner_index
		ldy	<_fire_register,x	; y = ˃J[g index
		ldx	<_status,y
		jmp	(!type_select$,x)
;- - - - - - - - - - - - - - - - - - - - - - - - - -
type_select$	DW	doku$		; mario	
		DW	doku$		; luige
		DW	tamago$		; koopa	
		DW	doku$		; peach	
		DW	fire$		; cong
		DW	tamago$		; kame
		DW	doku$		; kinopio
		DW	tamago$		; yossy
;- - - - - - - - - - - - - - - - - - - - - - - - - -
; ł̂ (G) 
;- - - - - - - - - - - - - - - - - - - - - - - - - -
doku$		ldx	<winner_index		;  index
		ldy	<lost_index		;  index
		lda	!_sunder_timer,y
		beq	skip_doku$
		cmp	#60h
		bcc	chibi$
;
		lda	#40h
		bra	skip_doku2$
;
skip_doku$	lda	#D_sunder_kinoko
skip_doku2$	sta	!_sunder_timer,y
		bra	skip_doku3$
skip_doku3$
		lda	!_flag,y		; GJ[gȂXLbv
		bmi	mykart$
		jsl	>sound_enemyspin
		bra	chibi$

mykart$		lda	#8000h			; Ȃ鉹
		cpy	#player_r0
		beq	sound_doku$		
		lsr	a		
sound_doku$	tsb	<sound_size

chibi$		tyx				;  index

		jmp	speed_down50
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; oii (}CJ[g/GJ[gj
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
fire$
		ldx	<winner_index		;  index
		ldy	<lost_index		;  index
		lda	!_flag,y
		bpl	fire_skip$	; RvȂXLbv
		lda	#3		; Rg[s\Z !
		sta	!_hit_timer,y
		bra	fire_skip2$
fire_skip$	jsl	>sound_enemyspin		
		jmp	tamago_skip2$		; GJ[g͂ނ̃Xs

fire_skip2$	

		lda	#BANANA_spin		; oiiXs
		ora	!kart_status,y
		sta	!kart_status,y
		lda	!_effect_flag,y		; XsgKI
		ora	#effect_spin+effect_spin_c
		sta	!_effect_flag,y

		lda	#0040h
		sta	<_velocityX,x
		sta	<_velocityY,x

		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; ܂(G) t@CAiG) / uK /
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
tamago$
		ldx	<winner_index		;  index
		ldy	<lost_index		;  index
		lda	!_flag,y
		bpl	tamago_skip$	; RvȂXLbv
		lda	#3		; Rg[s\Z !
		sta	!_hit_timer,y
		bra	tamago_skip2$
tamago_skip$	jsl	>sound_enemyspin
tamago_skip2$	
		jsr	spin_hit
		jsr	nomal_hit

		lda	#0040h
		sta	<_velocityX,x
		sta	<_velocityY,x
		tyx
		stz	<_velocityX,x
		stz	<_velocityY,x

		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - -
; ԃKn
;- - - - - - - - - - - - - - - - - - - - - - - - - -
kame$		ldx	<winner_index	;  index
		lda	!_flag,y
		bpl	skip$		; RvȂXLbv
		lda	#STOP_TIME+8	; Rg[s\𒷂
		sta	!_hit_timer,y
		bra	skip2$
skip$		jsl	>sound_enemy
skip2$		jsr	spin_hit
		jmp	nomal_hit
;- - - - - - - - - - - - - - - - - - - - - - - - - -
; ΃Kn
;- - - - - - - - - - - - - - - - - - - - - - - - - -
midori_kame$	ldx	<winner_index	;  index
		lda	!_flag,y
		bpl	mskip$		; RvȂXLbv
		lda	#STOP_TIME+8	; Rg[s\𒷂
		sta	!_hit_timer,y
		bra	mskip2$
mskip$		jsl	>sound_enemy
mskip2$		jsr	spin_hit
		jmp	hit_90


;*********************************************************************
;	P^Q
;*********************************************************************
speed_down50	lda	<_velocityX,x
		CMP	#1000000000000000B
		ROR	A
		sta	<_velocityX,x
		lda	<_velocityY,x
		CMP	#1000000000000000B
		ROR	A
		sta	<_velocityY,x
		rts
;*********************************************************************
;	90x ͂˂Ƃ΂
;*********************************************************************
hit_90		lda	!_velocityX,y		; xNg
		pha
		lda	!_velocityY,y
		pha

		lda	!frame_part
		bne	skip$
		lda	<_velocityX,x		; E 90 ͂I
		CMP	#1000000000000000B
		ROR	A
		sta	!_velocityY,y
		lda	<_velocityY,x
		EOR	#1111111111111111B
		INC	A
		CMP	#1000000000000000B
		ROR	A
		sta	!_velocityX,y
		bra	exit$

skip$		lda	<_velocityX,x		;  90 ͂ !
		EOR	#1111111111111111B
		INC	A
		CMP	#1000000000000000B
		ROR	A
		sta	!_velocityY,y
		lda	<_velocityY,x
		CMP	#1000000000000000B
		ROR	A
		sta	!_velocityX,y
		
exit$		pla				; ̃xNg
		sta	<_velocityY,x		; 炤
		pla
		sta	<_velocityX,x

		rts
;*********************************************************************
;		ITEM CRASH
;*********************************************************************
erase_Ysprite	LDX	<lost_index
		BRA	erase_skip
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
					; y = lost index
erase_Xsprite	lda	!_status,y
		bmi	skip$

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	Rs[^J[gȂ JUMP 
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	!_flag,y
		bmi	skip$		; Rs[^H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
					; x = item index
		lda	<_fire_register,x	; ACe{l
		tax
		lda	<_flag,x
		bmi	entry$ 		; GJ[go JUMP

		lda	!driver_priority,y
		ldx	#jump_15_16
		tay
		bne	jumpcheck$
		ldx	#jump_8_16
		bra	jumpcheck$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
entry$		lda	<rank_number,x	; ʃ`FbN
		lsr	a
		ldx	<_status,y	; J[gL
		adc	!lucky_table,x
		tax
jumpcheck$	SEP	#00100000B
		MEM8
		lda	<frame_counter
		and	#01fh
		cmp	!0,x
		REP	#00100000B
		MEM16
		bcs	skip$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
					; JUMP 
jump$		ldx	<lost_index
		lda	#04000h		; spin jump
	;;	lda	#00080h		; jump item
		sta	<special_trigger,x
		lda	#0		;  safe !
		sta	<_hit_timer,x
		pla			; << hit I
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
skip$		ldx	<winner_index
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
erase_skip	lda	#8000h
		sta	<_item_status,x
		lda	#100h
		sta	<_velocityZ,x
disp_ok		ldx	<winner_index
		ldy	<lost_index
		rts
;----------------------------------------------------------------------
lucky_table	DW	mario$
		DW	luige$
		DW	kuppa$	
		DW	peach$	
		DW	cong$
		DW	kame$
		DW	kinopio$
		DW	yossy$
;----------------------------------------------------------------------
mario$
luige$
peach$
yossy$
kame$
kinopio$	db	04h,04h,02h,02h,02h,02h,00h,00h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
cong$
kuppa$		db	02h,02h,02h,02h,02h,02h,00h,00h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
jump_15_16	db	1eh		; 15/16 ŃWv
jump_8_16	db	10h		;  8/16 ŃWv
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
;
;
;
;*********************************************************************
;		J[gXs
;*********************************************************************
;		Y <- lost index
;			fedcba9876543210
;----------------------------------------------------------------------
spin_hit	tyx
		lda	<frame_counter
		lsr	a
		lda	#spin_left
		bcc	skip0$
		lda	#spin_right
skip0$		ora	<kart_status,x
		sta	<kart_status,x
		lda	#2000H			; GXs
		bit	<_flag,x
		bpl	skip1$
		lda	#spin_power		; }CJ[Xs
skip1$		sta	<spin_counter,x
skip2$		lda	<_effect_flag,x		; XsgKI
		ora	#effect_spin+effect_spin_c
		sta	<_effect_flag,x
;- - - - - - - - - - - - - - - - - - - - - -
exit$		txy
		ldx	<winner_index
		rts
;*********************************************************************
;		`FbNpxNgvZ
;*********************************************************************
have_coin	equ	008h
have_big	equ	010h
;---------------------------------------------------------------------
set_doublespin	lda	#OIL_spin	; ICXsI
		ora	<kart_status,x
		sta	<kart_status,x
set_lostspin	lda	#OIL_spin
		ora	!kart_status,y
		sta	!kart_status,y
		rts
;---------------------------------------------------------------------
;	ʏ펞 J[gm `FbN
;---------------------------------------------------------------------
;- - - - - - - - - - - - - - - - - - - - - -
;	J[g
;- - - - - - - - - - - - - - - - - - - - - -
kart_hit	lda	<double_hit
		beq	skip0$
		jmp	special_hit
;- - - - - - - - - - - - - - - - - - - - - -
;	ɃRC𗎂Ƃ
;- - - - - - - - - - - - - - - - - - - - - -
skip0$
		lda	#effect_crash+effect_mycrash
		ora	!_effect_flag,y
		sta	!_effect_flag,y
		lda	#effect_crash+effect_mycrash
		ora	<_effect_flag,x
		sta	<_effect_flag,x
skip$
;- - - - - - - - - - - - - - - - - - - - - - - - 
;	GJ[g̃Rg[s\𒷂
;- - - - - - - - - - - - - - - - - - - - - - - - 
;
	;;	lda	!_flag,y
	;;	lda	#
	;;	sta	!hit_timer,x
;
;- - - - - - - - - - - - - - - - - - - - - -
;	J[g
;- - - - - - - - - - - - - - - - - - - - - -
		lda	<_HP,x
		sec
		sbc	!_HP,y
		beq	attack_kart		; S\
		dec	a
		beq	attack_1		; 1 R
		dec	a
		beq	attack_2		; 2 R
;- - - - - - - - - - - - - - - - - - - - - -
; ẍႤGƐڐG
;- - - - - - - - - - - - - - - - - - - - - -
level_check
		lda	!_HP,y
		and	#have_big	;  (j̓`rH
		bne	skip$
		lda	<_HP,x
		and	#have_big	; G () ̓fJH
		beq	skip$
		lda	!_flag,y
		bpl	out$		; ,Rs[^?
		tyx
		jmp	super_dossun
out$
		jsl	>sound_enemyspin	; G GXs
		jsr	spin_hit
		jmp	star_crash


skip$		lda	!_HP,y		; J[g̓RC H
		and	#have_coin
		bne	exit$
		jsr	set_lostspin	; ICXs
exit$		jmp	rate_2
;- - - - - - - - - - - - - - - - - - - - - - -
attack_1	lda	<_HP,x		; RCĂH
		and	#have_coin
		bne	exit$
		jsr	set_doublespin
exit$		jmp	rate_1
;- - - - - - - - - - - - - - - - - - - - - - -
attack_2	lda	<_HP,x		; RCĂH
		and	#have_coin
		bne	exit$
		jsr	set_doublespin
exit$		jmp	rate_2
;---------------------------------------------------------------------
;	NbpƃNbp̓	( hit rate 0 ) xNgւ
;	Jł̓
;---------------------------------------------------------------------
attack_kart	lda	<_HP,x		; RCĂH
		and	#have_coin
		bne	nomal_hit
		jsr	set_doublespin	; ICXs
;- - - - - - - - - - - - - - - - - - - - - -
nomal_hit
;- - - - - - - - - - - - - - - - - - - - - -
;xNg
;- - - - - - - - - - - - - - - - - - - - - -
		LDA	<_velocityX,X
		STA	<vx1			; winner
		LDA	!_velocityX,Y
		STA	<vx2			; lost
		LDA	<_velocityY,X
		STA	<vy1			; winner
		LDA	!_velocityY,Y
		STA	<vy2			; lost
		JSR	Nomal_mirror
;- - - - - - - - - - - - - - - - - - -
; pxɂ`FbN ( ݖh~ j
;- - - - - - - - - - - - - - - - - - -
		LDA	<vx1
		BPL	hit_100
		LDA	<vx2
		BPL	hit_900
		BRA	hit_200
hit_100		LDA	<vx2
		BMI	hit_900
hit_200		LDA	<vy1
		BPL	hit_300
		LDA	<vy2
		BPL	hit_900
		BRA	hit_400
hit_300		LDA	<vy2
		BMI	hit_900
;- - - - - - - - - - - - - - - - - - -
;xNg (␳o[Wj
;- - - - - - - - - - - - - - - - - - -
hit_400		JSR	Special_mirror		;
hit_900	
;- - - - - - - - - - - - - - - - - - -
;xNgXgA
;- - - - - - - - - - - - - - - - - - -
hit_exit	LDX	<winner_index
		LDY	<lost_index		
		LDA	<vx1
		STA	<_velocityX,X
		LDA	<vx2
		STA	!_velocityX,Y
		LDA	<vy1
		STA	<_velocityY,X
		LDA	<vy2
		STA	!_velocityY,Y
		RTS
;---------------------------------------------------------------------
;	Nbpƃ}I̓	( hit rate 1 )
;---------------------------------------------------------------------
rate_1		lda	<_vF,x
		sec
		sbc	!_vF,y
		bcs	power_hitter
;- - - -- - - - - - - - - - - - - - - - -
					; --> 
					;ʏ̂
lost_crash$	jmp	nomal_hit
;
;---------------------------------------------------------------------
;	NbpƃJ̓	( hit rate 2 )
;	GJ[gƂ̓
;---------------------------------------------------------------------
bound_angle	equ	0e00h
;- - - - - - - - - - - - - - - - - - - - -
star_crash
rate_2
;- - - - - - - - - - - - - - - - - - - - -
		lda	<_vF,x
		sec
		sbc	!_vF,y
		bcs	power_hitter
;- - - -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
					; --> 
					;J[g͎Ȃ
lost_crash$	
;- - - - - - - - - - - - - - - - - - - - - - - - -

		lda	<_vF,x	
		cmp	#0100h
		bcc	low_speed$
		lsr	a		; J[g̃Xs[h
		lsr	a		; ͂₢Ƃ
		sta	<speed
		lda	<_vFangle,x
		clc
		adc	#1000h
		sta	<angle
		tyx
		jmp	speed_vxvy

;- - - - - - - - - - - - - - - - - - - - 
low_speed$	tyx			; J[g̃Xs[h
		lda	<_vFangle,x	; Ƃ
		clc
		adc	#6000h
		sta	<angle
		lda	<_vF,x
		cmp	#0100h
		bcs	skip$
		lda	#0200h
skip$		lsr	a
		sta	<speed
		jmp	speed_vxvy	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
power_hitter				; --> 
;					;J[g
		lsr	a
		eor	#0ffffh
		sec
		adc	<_vF,x
		sta	<speed
		lda	<_vFangle,x		
		sta	<angle
		jsr	speed_vxvy
;
;- - - - - - - - - - - - - - - - - - - 
		lda	<_flag,x	; J[gƂ΂
		bmi	win1$
;- - - - - - - - - - - - - - - - - - - - - - - -
		lda	#-bound_angle	; J[g}CJ[̏ꍇ
		sta	<0
		lda	<_posH_A,x
		cpx	#player_r0
		beq	skip4$
		lda	<_posH_B,x
		bra	skip4$
;- - - - - - - - - - - - - - - - - - - - - - - -
win1$					; J[g}CJ[̏ꍇ

		lda	!_flag,y	; }IJ[H
		bmi	win_10$
		lda	#1800h
		bra	win_20$
win_10$		lda	#bound_angle
win_20$		sta	<0
		lda	!_posH_A,y
		cpx	#player_r0
		beq	skip4$
		lda	!_posH_B,y
;- - - - - - - - - - - - - - - - - - - - - - - -
skip4$		clc
		adc	#0080h
		asl	a
		lda	<0
		bcc	skip$
		eor	#0ffffh
		sec
;- - - - - - - - - - - - - - - - - - - - - - - -
skip$		adc	<_vFangle,x
		sta	<angle
		lda	<_vF,x
		adc	#0020h
		sta	<speed
		tyx
		jmp	speed_vxvy
;---------------------------------------------------------------------
;

; = = J[g ʃp^[ = =

	if	0
		SEP	#00100000B
		MEM8
		lda	#dsp_multiply
		sta	!DSP_data
		REP	#00100000B
		MEM16
		lda	<_velocityX,x
		sta	!DSP_data
		lda	#05fffh
		sta	!DSP_data
		lda	!DSP_data
		sta	<_velocityX,x
		SEP	#00100000B
		MEM8
		lda	#dsp_multiply
		sta	!DSP_data
		REP	#00100000B
		MEM16
		lda	<_velocityY,x
		sta	!DSP_data
		lda	#05fffh
		sta	!DSP_data
		lda	!DSP_data
		sta	<_velocityY,x
	endif
;
;
;
;
;
;
;-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-#-
;
;**********************************************************************
;	Xs[h vX,vY ɕϊ
;**********************************************************************
;angle		equ	0
;speed		equ	2
;----------------------------------------------------------------------
		glb	speed_vxvy_BK
;----------------------------------------------------------------------
speed_vxvy_BK	jsr	speed_vxvy
		rtl
;- - - - - - - - - - - - - - - - - - - - - -
speed_vxvy	SEP	#00100000B
		MEM8
		lda	#dsp_triangle
		sta	!DSP_data
		REP	#00100000B
		MEM16
		lda	<angle
		sta	!DSP_data		
		lda	<speed
		sta	!DSP_data
		LDA	>DSP_status
		BPL	$-4
		lda	!DSP_data
		sta	<_velocityX,x
		lda	!DSP_data
		EOR	#1111111111111111B
		INC	A
		sta	<_velocityY,x
		rts
;**********************************************************************
;	xNg˃[`
;**********************************************************************
;----------------------------------------------------------------------
;Qx̎̔˃[`
;----------------------------------------------------------------------
special_hit
		lda	<_vF,x
		ora	!_vF,y
		bne	skip$
;- - - - - - - - - - - - - - - - - - - - oƂxNgÔƂ
		lda	<_poseQ,x
goto$		sta	<angle
		lda	#0180h
		sta	<speed
		jmp	speed_vxvy
;- - - - - - - - - - - - - - - - - - - - xNgƂ
skip$		lda	<_vF,x
		cmp	!_vF,y
		bcs	skip2$
		lda	!_vF,y
skip2$		cmp	#00c0h
		lda	<_vFangle,x
		bcc	goto$
		rts
;- - - - - - - - - - - - - - - - - - - -

	if	0
;- - - - - - - - - - - - - - - - - - - - אڊpx`FbN
skip$		lda	!_vFangle,y
		sbc	<_vFangle,x
		BPL	$+6
		EOR	#1111111111111111B
		INC	A
		cmp	#02000h
		bcs	exit$
;- - - - - - - - - - - - - - - - - - - - אڊpx̂Ƃ
		tyx
		lda	<_vFangle,x
		adc	#02000h
		sta	<angle
		lda	<_vF,x
		sta	<speed
		jmp	speed_vxvy
;- - - - - - - - - - - - - - - - - - - -
exit$		rts
	endif
;----------------------------------------------------------------------
;xNgˁiʏj
;----------------------------------------------------------------------
Nomal_mirror	LDX	<vx2		; <- READ LOST
		LDY	<vx1		; <- READ WIN
		STY	<vx2		; <- WRITE LOST
		STX	<vx1		; <- WRITE WIN
		LDX	<vy2		; <- READ LOST
		LDY	<vy1		; <- READ WIN
		STY	<vy2		; <- WRITE LOST
		STX	<vy1		; <- WRITE WIN
		RTS
;----------------------------------------------------------------------
;xNgˁi␳j
;---------------------------------------------------------------------
Special_mirror	LDX	#0		; X̔
		JSR	set_vector
		LDX	#2		; Y̔
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
set_vector	LDA	<vx1,X
		BMI	m_XXX
;- - - - - - - - - - - - - - - - - - - - - - - - - - - i{ĵƂ
		LDA	<vx1,X		; x1 > x2 ?
		CMP	<vx2,X
		BCS	m_3200		; yes -> 3200
		SEC
		SBC	#0080H		; x1= x1-0080H
		STA	<vx1,X
		RTS
m_3200		LDA	<vx2,X		; x2= x2-0080H
		SEC
		SBC	#0080H
		STA	<vx2,X
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - i[ĵƂ
m_XXX		LDA	<vx1,X		; x1 < x2 ?
		CMP	<vx2,X
		BCC	m_5200		; yes -> 5200
		CLC
		ADC	#0080H		; x1= x1+0080H
		STA	<vx1,X
		RTS
m_5200		LDA	<vx2,X		; x2= x2+0080H
		CLC
		ADC	#0080H
		STA	<vx2,X
		RTS
;---------------------------------------------------------------------
;
;
;**********************************************************************
;	xNg
;**********************************************************************
;	x =  index
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Xs[h 000H  - 080H  Ȃ 	080H
;	Xs[h 080H  - 200H  Ȃ		nomal
;	Xs[h 200H  - 800H  Ȃ		
;- - - - - - - - - - - - - - - - - - - - - - - - - -
nomal_mirror	lda	<_velocityX,x
		jsr	!nomal_revers
		sta	<_velocityX,x
		lda	<_velocityY,x
		jsr	nomal_revers
		sta	<_velocityY,x
		rts
;- - - - - - - - - - - - - - - - - - - -
nomal_revers	EOR	#1111111111111111B
		INC	A
		bpl	skip_p$
		cmp	#-080h
		bcc	skip_m1$
		lda	#-080h
		rts
skip_m1$	cmp	#-0200h
		bcs	skip_p2$
		bcc	skip_m2$
;- - - - - - - - - - - - - - - - - - - -
skip_p$		cmp	#080h
		bcc	skip_p1$
		lda	#080h
		rts
skip_p1$	cmp	#0200h
		bcc	skip_p2$
skip_m2$	CMP	#1000000000000000B
		ROR	A
skip_p2$	rts
;**********************************************************************
;	Qx̎̔˃[`
;**********************************************************************
error_mirror	lda	<_vF,x
		bne	skip$
		SEP	#00100000B
		MEM8
		lda	#dsp_triangle
		sta	!DSP_data
		REP	#00100001B
		MEM16
		lda	<_poseQ,x
		sta	!DSP_data
		lda	#0100h
		sta	!DSP_data
		LDA	>DSP_status
		BPL	$-4
		lda	!DSP_data
		sta	<_velocityX,x
		lda	!DSP_data
		EOR	#1111111111111111B
		INC	A
		sta	<_velocityY,x
skip$		rts
;**********************************************************************
;	fobOp[^
;**********************************************************************
brank_on	SEP	#00100000B
		MEM8
		lda	#0ah
		sta	!PPU_control
		REP	#00100000B
		MEM16
		rts
brank_off	SEP	#00100000B
		MEM8
		lda	#0fh
		sta	!PPU_control
		REP	#00100000B
		MEM16
		rts
;------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;= = = = = = = ꏈ@}CJ[gɑ΂Ă QՓ = = = = = = =
;
;*********************************************************************
;		QՓ
;*********************************************************************
rebound_angle	equ	1000h
rebound_size	equ	06h
;----------------------------------------
pc_exit		rts
Crash_pole	lda	!_pole_status,y		; Q΂H
		bmi	pc_exit
		lda	<event_index,x		; H
		cmp	#08h			; 08/06 ̓yP
		beq	pc_exit
		cmp	#06h
		beq	pc_exit
;- - - - - - - - - - - - - - - - - - - - - - - - -
entry$		lda	<_muteki_timer,x
		beq	skip$
;- - - - - - - - - - - - - - -
;
		lda	<_poo_status,x		; [NgpH
		bne	skip0$
		sty	<_poo_status,x		; ԂƂ index
		lda	#8000h
		sta	!_pole_status,y
skip0$		jmp	speed_down50		; Xs[hP^Q
;
;- - - - - - - - - - - - - - -
skip$		lda	<_hit_timer,x		; 0,1
		dec	a
		dec	a
		bpl	exit$
		pha				; ( ->> )
		sty	<_crash_index,x		; Փ˂ index
		lda	#8007H	
		sta	<_crash_timer,x		; Փ obj ^C}
;- - - - - - - - - - - - - - - - - - - - - - - - -
		lda	#0001000000000000B
		ora	<_flag,x
		sta	<_flag,x		; Փ˂ flag
;- - - - - - - - - - - - - - - - - - - - - - - - -
		lda	#8			; STOP_TIME
		sta	<_hit_timer,x		; Փ˕s\ flag
	;;	lda	#4
	;;	sta	<_unable_control,x

		pla				; ( <<- )
		inc	a			; Aã`FbN
		beq	double$			; 		
;- - - - - - - - - - - - - - - - - - - - - - - - -
		txa
		ldx	!obj_type
		jmp	(!course_hit,x)
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - -
double$		lda	<_vF,x
		beq	stop$
		cmp	#0040h
		bcs	end$
		lda	<_velocityX,x	
		asl	a
		lda	<_velocityX,x
		lda	<_velocityY,x
		asl	a
		sta	<_velocityY,x
end$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - -
stop$		lda	#0100h			; 񂾂ʏo
		sta	<_velocityX,X
		sta	<_velocityY,X
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - -
course_hit	dw	ch_dokan	;΂
		dw	ch_dokan	;T[Lbg
		dw	ch_poo		;
		dw	ch_pack		;_[g
		dw	ch_dokan	;X
		dw	ch_puku		;C
		dw	ch_dosun	;Nbp
		dw	ch_dosun	;og
;- - - - - - - - - - - - - - - - - - - - - - - - -
;hbXɓ
;- - - - - - - - - - - - - - - - - - - - - - - - -
ch_dosun
		tax
		and	#0100h
		jsl	>sound_my_dokan

		lda	!_situationZL+1,y
		beq	exit_dosun

		cpx	#player_r0
		bne	skip$
		
		lda	!_velocityZ+40h,y
		bpl	exit_dosun
		bmi	super_dossun

skip$		lda	!_velocityZ,y
		bpl	exit_dosun
super_dossun

	;;;;	lda	#effect_crash+effect_mycrash
	;;;;	and	#(effect_mycrash^0ffffh)


		lda	<_effect_flag,x
		ora	#effect_dosun
		sta	<_effect_flag,x

		stz	<steering_angle,x	; nhOɂ
		stz	<_velocityX,x		; Xs[hOɂ
		stz	<_velocityY,x
		lda	#7000h
		sta	<_hit_timer,x
		lda	#2
		sta	<_dmindex,x

		rts

exit_dosun	lda	!map_number
		cmp	#5
		bne	exit$
		jsr	nomal_mirror
		txy			; y = kart index
		jsr	spin_hit
		rts
exit$	
		jsr	Out_spin
		jsr	nomal_mirror
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - -
;yǂɓ
;- - - - - - - - - - - - - - - - - - - - - - - - -
		ext	Spin_kabe
ch_dokan
;						;  check
		tax
		and	#0100h
		jsl	>sound_my_dokan

		jsr	Out_spin

		lda	!_posH_A,y
		cpx	#player_r0
		beq	skip$
		lda	!_posH_B,y
skip$
skip0$		clc
		adc	#0080h
		bpl	skip1$
		cmp	#-rebound_size
		bcs	nomal$
		lda	#rebound_angle
		bra	skip2$
skip1$		cmp	#rebound_size
		bcc	nomal$	
		lda	#-rebound_angle
skip2$		clc
		adc	<_vFangle,x
		sta	<angle
		lda	<_vF,x
		cmp	#100h
		bcc	skip3$
		lsr	a			; Xs[h
skip3$		sta	<speed
side$		jmp	speed_vxvy		; 
nomal$		jmp	nomal_mirror		; _CNgqbg

;- - - - - - - - - - - - - - - - - - - - - - - - -
;`v[ɓI
;- - - - - - - - - - - - - - - - - - - - - - - - -
ch_poo		tax

		jsr	Out_spin

		stz	<_velocityX,x
		stz	<_velocityY,x
		tya
		ora	#8000h
		sta	<_poo_status,x
;
		tyx
		lda	#8000h
		ora	<_pole_status,x
		sta	<_pole_status,x
;
		rts

;- - - - - - - - - - - - - - - - - - - - - - - - -
;pbN,vNvN,ɓI
;- - - - - - - - - - - - - - - - - - - - - - - - -
ch_puku
ch_pack		tax
;- - - - - - - - - - - - - - - - - - - -
		lda	!_posH_A,y	; Q̈ʒu`FbN
		cpx	#player_r0
		bne	skip$
		lda	!_posH_B,y
skip$		clc
		adc	#0080h
;- - - - - - - - - - - - - - - - - - - -
		bpl	skip_1$
		lda	#2000h		; EɂƂ΂.
		bra	skip_2$
skip_1$		lda	#-2000h		; ɂƂ΂.
skip_2$		clc
		adc	<_vFangle,x
		sta	<angle
		lda	<_vF,x
		cmp	#180h		; 180h
		bcs	skip_3$
		lda	#180h		; 180h
skip_3$		sta	<speed
		jsr	speed_vxvy
		lda	#OIL_spin
		ora	<kart_status,x
		sta	<kart_status,x
		rts

;- - - - - - - - - - - - - - - - - - - - - - - - - -
	if	0
		tax
		txy
		jsr	spin_hit
		stz	<_velocityX,x
		stz	<_velocityY,x
		ldy	#01000h		
		lda	<_vFangle,x
		jsl	>Move_situation
		rts
	endif
;- - - - - - - - - - - - - - - - - - - - - - - - - -

;--------------------------------------------------------------------
;	Xs
;--------------------------------------------------------------------
Out_spin	lda	<drift_index,x
		cmp	#0ch			; XsꏈI
		bne	exit$
		lda	<_velocityX,x		; Wً̋}Ҕ
		EOR	#1111111111111111B
		INC	A
		sta	<_velocityX,x
		lda	<_velocityY,x
		EOR	#1111111111111111B
		INC	A
		sta	<_velocityY,x
		jsl	>Spin_kabe
		lda	#0ffffh			; Փ˃Xs
		sta	<_spin_special,x
		lda	#(1000h^0ffffh)
		and	<_flag,x
		sta	<_flag,x		; Փ˂ flag
		stz	<_hit_timer,x		; Փ˕s\ flag
		pla
exit$		rts
;--------------------------------------------------------------------
		END
