;*********************************************************************
;
;	DECODE		7E bank
;
;*********************************************************************
		GLB	Decode_7E_X	; 7E bank
;----------------------------------------------------------------------
offset_X	equ	00h
;----------------------------------------------------------------------
data0	equ	04h
data1	equ	06h
data2	equ	08h
work0	equ	0ah
ashcnt	equ	0ch
decocnt	equ	0eh	;decode address counter.
ashcnt1	equ	10h	;to decode address counter.
data3	equ	12h
oppcnt	equ	14h	;data fealde counter.
oppck	equ	16h
;----------------------------------------------------------------------
;	prog
;		extend
;		mem16	
;		idx16	
;----------------------------------------------------------------------
	EXTEND
bank84		SECT	REL
		mem16
		idx16
;*********************************************************************
;
;	ROM (ISPK) -> RAM(7Ebank)
;
;*********************************************************************
;		mem16,idx16
;		Y(ROM address)
;		A(ROM bank)
;		X(address)
;----------------------------------------------------------------------
Decode_7E_X	STX	<decocnt	;	RAM address
		STY	<ashcnt1	;	ROM address
		PHB			; >	push data bank
		SEP	#00100000B
		MEM8
		PHA			;  >
		REP	#00100000B
		MEM16
		PLB			;  <	ROM bank
		JSR	entry_CODE
		PLB			; <	pull data bank
		RTL
;*********************************************************************
;		decode module
;*********************************************************************
entry_CODE					
			LDY	<decocnt
			STY	<offset_X	
			stz		<ashcnt
			stz		<data0
			stz		<data1
			stz		<data2
			stz		<data3
			stz		<oppcnt
			stz		<oppck
;*********************************************************************
CODE			idx16				;(DECODE DATA READ)
			mem8				;m8i16
			sep		#00100000b
			rep		#00010000b
;
			ldx		<ashcnt1		;to decode data read.
			lda		!0,x		
			inx					;counter inc.
			stx		<ashcnt1
;
			sta		<data0
			cmp		#0ffh			;END?:yes-->owari
			beq		owari
;
;
;------------------------------------------------------
;
;
CODE1		equ		$				;(HEDA CHECK)
			and		#11100000b		
			cmp		#11100000b		;2byte code?:no-->CODE_1.
			bne		CODE_1
;
;
;------------------------------		;(2byte code)
			lda		<data0			;heda set.
			asl		a
			asl     a
			asl     a
			and		#11100000b
			pha
;------------------------------
			mem16					;m16i16
			idx16
			rep		#00100000b
;
			ldx		<ashcnt1		;data counter set.
			lda		!0,x
			sta		<data3
			dex
			lda     !0,x
			sta		<data3+1
			inx
			inx    
			stx		<ashcnt1
			lda		<data3
			and		#03ffh
;
			mem8					;m8i16
			idx16
			sep		#00100000b
			jmp		set_routine
;-----------------------------------------------------
owari		REP	#30H	; mem16,idx16
		RTS
;------------------------------------------------------
CODE_1		equ		$				;(1byte code)
			pha					;heda set.
;
			mem16					;m16i16
			idx16
			rep		#00100000b
;
			lda		<data0			;data counter feald set.
			and		#001fh
			idx16
			mem8
			sep		#00100000b
;---------------------------------------------------------
set_routine	equ		$			;(DATA FEALD CHECK SET)
			tay				;data counter (y) set.
			iny
			sty		<oppcnt
			pla
			cmp		#0		;000?:yes-->nx10
			bpl		nx10
;
			jmp		ref		;100,101,110?;yes-->ref
;
nx10		cmp		#20h			;001?:yes-->ren11
			beq		ren11
;
			cmp		#40h		;010?:yes-->ren22
			beq		ren22
;
			cmp		#60h		;011?:yes-->ren122
			beq		ren122
;---------------------------------------------------------
;
;---------------------------------------------------------
			ldx		<ashcnt1		;(000)
NORM			lda		!0,x			;to decode data read
			ldx		<decocnt
			sta		>7e0000h,x		;decode data write.
			inx
			stx		<decocnt
			ldx		<ashcnt1
			inx
			stx		<ashcnt1
			dey
			bne		NORM
			jmp		CODE
;----------------------------------------------------------
;==========================================================
;
ren11		jmp		ren1
ren22		jmp		ren2
ren122      jmp     ren12
;
;==========================================================
;----------------------------------------------------------

;---------------------------------------------------------	
ref			cmp		#0c0h			;heda check(110,101,10)
			bcs		refshort1
			and		#20h
			sta		<oppck
;------------------------------
			idx16					;reverse bit position set
			mem16
			rep		#00100001b
;								(110,101)
			lda		!0,x		;data read.
			adc		<offset_X
			sta		<data0			;to decode referrence offset lowside set
			inx
			inx
			stx     <ashcnt1
;
;----------------------------------------------------------
ref_xx		equ		$
			mem8
			idx16
			sep		#00100000b
;----------------------------------------------------------
ref_1		equ		$				;reverse bit data read.
			ldy     <oppcnt
ref_944		ldx		<data0			;(100)
			lda		>7e0000h,x
			inx
			stx		<data0
			lda		<oppck
			beq		ref_2			;80h?:yes-->ref_2
;
			dex					;(101)
			lda		>7e0000h,x
			eor		#0ffh			;reverse bit data set.
			jmp		ref_911
;----------------------------------
ref_2		dex
			lda     >7e0000h,x		
ref_911		ldx		<decocnt			;reverse bit data write.
			sta		>7e0000h,x
			inx
			stx		<decocnt
;			ldy		<oppcnt
			dey
;			sty		<oppcnt
			bne		ref_944
			jmp		CODE
;----------------------------------------------------------
;==========================================================
;
refshort1   jmp     refshort11
;
;===========================================================
;----------------------------------------------------------
ren1		equ		$			;(001)
							;to decode data read.
			lda		!0,x
			inx
			stx		<ashcnt1
;
			ldx		<decocnt	;decode data write.
ren1_1		sta		>7e0000h,x
			inx
			dey
			bne		ren1_1
			stx     <decocnt
;
  			jmp		CODE
;---------------------------------------------------------
ren2		equ		$			;(010)2dataset.
							;to decode data read .
			lda		!0,x
			inx
			sta		<data0
			lda		!0,x		
			sta		<data1
    		inx
			stx		<ashcnt1
;-----------------------------
ren2_1		equ		$			;data write.
			ldx		<decocnt
			lda		<data0
			sta		>7e0000h,x	;decode data write.
			inx
			stx		<decocnt
			dey
			beq		ren2_2
			ldx		<decocnt
			lda		<data1
			sta		>7e0000h,x	;decode data write.
			inx
			stx		<decocnt
			dey
			bne		ren2_1
;----------------------------------------------------------
;==========================================================
;
ren2_2		jmp		CODE
refshort11	jmp		refshort
ref_xx1     jmp     ref_xx
;
;==========================================================
;-----------------------------------------------------------
ren12		equ		$				;(011)
			lda		!0,x	;to decode	data read.
			inx
			stx		<ashcnt1
;------------------------------
ren121		equ		$
			ldx		<decocnt
ren325		sta		>7e0000h,x		;decode data write.
			inc		a
			inx
			dey
			bne		ren325
			stx     <decocnt
			jmp		CODE
;-----------------------------------------------------------
refshort	equ		$				;(110)
			and		#20h
			sta		<oppck
;							;to decode data read.
			lda		!0,x
			inx
			stx		<ashcnt1
			sta		<data0
			stz		<data0+1
			stz		<data1
;
			idx16			;m16i16
			mem16
			rep		#00100000b
;
			lda		<decocnt	;reverse bit position set.
			sec
			sbc		<data0
			sta		<data0
			bra		ref_xx1
;-----------------------------------------------------------
			END
