Bscreen_offset	EQU	7000H
hx		EQU	20H	; obj data H offset ( = ceterH+hx )
;*********************************************************************
;	mario kart << sprite jugem >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/jugem.def

;----------------------------------------------------------------------
		GLB	Init_jugem,Set_jugem
		glb	c_comeback
		EXT	OAM_jugem
;----------------------------------------------------------------------
		COMN
work		DS	2
anim_addr	DS	4		; common work
work_jsr	DS	2
temp		DS	2
oyabun		DS	2
;---------------------------------------------------------------------
		EXTEND
objinit	SECT	REL
		mem16
		idx16
;*********************************************************************
;		CONTROL DATA
;*********************************************************************
;----------------------------------------------------------------------
;	X^[gVOi
;----------------------------------------------------------------------
c_start	
;- - - - - - - - - - - - - - - - - - - - - - - ʒu!
		dw	init_pos
		db	034h,0f0h,020h,02
;- - - - - - - - - - - - - - - - - - - - - - - Xs[h
		dw	init_vxvy
		dw	0,0,0080h,0004h,0100h,0100h
;- - - - - - - - - - - - - - - - - - - - - - - 
		dw	jugem_move
		dw	check_start,-040h
;- - - - - - - - - - - - - - - - - - - - - - - ҂
		dw	flag_wait
		dw	set_timer,40h
;- - - - - - - - - - - - - - - - - - - - - - - 
		dw	jugem_move
		dw	check_timer,clear_obj	
;----------------------------------------------------------------------
;	CG[tbO
;----------------------------------------------------------------------
c_yellow
;- - - - - - - - - - - - - - - - - - - - - - - ʒu!
		dw	vxvy_check
		dw	init_pos
		db	026H,0f0H,20H,06
;- - - - - - - - - - - - - - - - - - - - - - - Xs[h
		dw	init_vxvy
		dw	100h,01,1a0h,04,0080h,0080h
;- - - - - - - - - - - - - - - - - - - - - - - 
		dw	jugem_move
		dw	check_fall
		dw	jump_prog,c_yellow_off
;- - - - - - - - - - - - - - - - - - - - - - - 
check_fall	ldx	<oyabun
		lda	<event_index,x
		cmp	#0ch		; ΂I
		bne	exit$
		iny
		iny
		tyx
		jmp	(!0,x)
exit$		ldx	<register
		rts
;----------------------------------------------------------------------
;	CG[tbO
;----------------------------------------------------------------------
c_yellow_off	dw	vxvy_check
		dw	clear_obj
;---------------------------------------------------------------------
;	S[tbO
;---------------------------------------------------------------------
c_goal		dw	vxvy_check
		dw	init_pos
		db	026H,0f0H,20H,08
		dw	init_vxvy
		dw	00000,0002,0000,0004,0100h,0100h
		dw	jugem_move,jugem_loop
;----------------------------------------------------------------------
;	WQҋ@
;----------------------------------------------------------------------
c_sea_wait	dw	vxvy_check
		dw	init_pos
		db	071h,0f8h,20h,_code_fault
		dw	init_vxvy
		dw	0,0,0100h,0,0,0
		dw	jugem_move
		dw	check_Y,04000h
		dw	init_vxvy
		dw	0,0,0,0,0,0		; ҋ@I
		dw	jugem_move
		dw	jugem_loop
;----------------------------------------------------------------------
;	WQҋ@
;----------------------------------------------------------------------
c_sea_off	dw	init_vxvy
		dw	0,0,-0100h,0,0,0
		dw	jugem_move
		dw	check_erase,clear_obj
;----------------------------------------------------------------------
;	艺@	ON !
;----------------------------------------------------------------------
c_takeout	dw	check_map,obake$,fire$,water$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
fire$		dw	check_out,obake$,c_overout
;- - - - - - - - - - - - - - - - - - - - 
obake$		dw	vxvy_check
		dw	init_pos
		db	071h,0f8h,20h,_code_fault
		dw	init_vxvy
		dw	0,0,0300h,8,0,0300h
		dw	jump_prog,skip$			
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
water$		dw	check_out,water1$,c_overout
;- - - - - - - - - - - - - - - - - - - - 
water1$		dw	init_vxvy
		dw	0,0,0100h,0,0,0
;- - - - - - - - - - - - - - - - - - - - 
skip$		dw	jugem_move
		dw	check_Y,06000h
		dw	move_player,jugem_kiss
		dw	jugem_loop
;----------------------------------------------------------------------
;	Oグ	ON !
;----------------------------------------------------------------------
c_overout	dw	vxvy_check
		dw	init_pos
		db	071h,0f8h,20h,_code_fault
		dw	init_vxvy
		dw	0,0,0100h,0,0,0
		dw	jugem_move
		dw	check_Y,04800h
;- - - - - - - - - - - - - - - - - - - - 
		dw	move_player,jugem_kiss
		dw	jugem_loop
;----------------------------------------------------------------------
;	WQ߂I
;----------------------------------------------------------------------
c_comeback	dw	check_map,obake$,fire$,water$
obake$		dw	init_pos
		db	071h,0f8h,20h,_code_fault
fire$
water$		dw	jugem_kiss
		dw	jugem_ground
		dw	set_coin_flag
		dw	init_vxvy
		dw	00000,0000,-0100h,0000,0000,0000
		dw	jugem_move
		dw	check_erase,clear_obj
;----------------------------------------------------------------------
;	bv^C\
;----------------------------------------------------------------------
c_final		dw	vxvy_check
		dw	init_pos
		db	16H,0F8H,20H,12
		dw	jump_prog,rap_common

c_lap		dw	vxvy_check
		dw	init_pos
		db	16H,0F8H,20H,10
rap_common	dw	init_vxvy
		dw	0200h,0006,0240h,0008,0200H,0240H
		dw	set_timer,0a0h
		dw	jugem_move
		dw	check_timer,clear_obj	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

;
;
;
;
;
;*********************************************************************
;	WQ䃋[`
;*********************************************************************
;----------------------------------------------------------------------
;- - - - - - - - RCtOZbg - - - -
;----------------------------------------------------------------------
set_coin_flag
		ldx	<screen_register
		lda	#11
		sta	!coin_flag,x
		iny
		iny
		tyx
		jmp	(!0,x)
;----------------------------------------------------------------------
;	[`
;----------------------------------------------------------------------
clear_obj	ldx	<register		; WQ
		stz	<_CN_start,X		; next start = OK 
		stz	<_AN_number,X	; sprite clear
		stz	<_dispX,x		; WZbg
		stz	<_dispY,x		;
		stz	<_velocityX,x		; Xs[hZbg
		stz	<_velocityX,x
		stz	<_accelX,x
		stz	<_accelY,x
		stz	<_reverseX,x
		stz	<_reverseY,x
		lda	#8000h
		sta	<_end_flag,x
		sty	<_CN_pointer,x
		rts
;---------------------------------------------------------------------
;		WQ̏ʒu
;---------------------------------------------------------------------
init_pos	ldx	<register
		SEP	#00100000B
		MEM8
		lda	!2,y
		sta	<_dispX+1,x		; display H
		stz	<_dispX+0,x
		lda	!3,y
		sta	<_dispY+1,x		; display V
		stz	<_dispY+0,x
		lda	!4,y
		sta	<_attribute+1,x		; attribute
		lda	!5,y
		sta	<_AN_number,x	; anime SEQ number
		stz	<_end_flag,x
		REP	#00100001B
		MEM16
		tya
		adc	#6
		sta	<_CN_pointer,x	; next data 
		rts
;---------------------------------------------------------------------
;		WQ̏Xs[h
;---------------------------------------------------------------------

init_vxvy	ldx	<register
		lda	!2,y
		sta	<_velocityX,x
		lda	!4,y
		sta	<_accelX,x
		lda	!6,y
		sta	<_velocityY,x
		lda	!8,y
		sta	<_accelY,x
		lda	!10,y
		sta	<_reverseX,x
		lda	!12,y
		sta	<_reverseY,x
		tya
		clc
		adc	#14
		sta	<_CN_pointer,x	; next data 
		rts

;---------------------------------------------------------------------
;		WQʏ̓
;---------------------------------------------------------------------
jugem_move	ldx	<register
		jsr	move_main
		inx
		inx
		jsr	move_main
		iny
		iny
		tyx
		jmp	(!0,x)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
move_main	clc
		lda	<_accelX,x
		bpl	minus$
		adc	<_velocityX,x
		sta	<_velocityX,x	
		bpl	exit$
		EOR	#1111111111111111B
		INC	A
		cmp	!_reverseX,x		; accel reverse data
		bcs	skip$
		bcc	exit$
minus$		adc	<_velocityX,x
		sta	<_velocityX,x	
		bmi	exit$
		cmp	!_reverseX,x		; accel reverse data
		bcc	exit$
skip$		lda	<_accelX,x
		EOR	#1111111111111111B
		INC	A
		sta	<_accelX,x
exit$
		lda	<_velocityX,x
		clc
		adc	<_dispX,x
		sta	<_dispX,x
		rts
;---------------------------------------------------------------------
;		^C} Zbg
;---------------------------------------------------------------------
set_timer	ldx	<register
		lda	!2,y
		sta	<_timer,x
		jmp	next_process1
;---------------------------------------------------------------------
;		^C} `FbN
;---------------------------------------------------------------------
check_timer	ldx	<register
		lda	<_timer,x
		bne	exit$
		iny
		iny
		tyx
		jmp	(!0,x)
exit$		dec	a
		sta	<_timer,x
		rts
;---------------------------------------------------------------------
;		Xgbv
;---------------------------------------------------------------------
check_start	ldx	<register
		lda	<_velocityY,x
		bpl	exit$
		cmp	!2,y
		bcs	exit$
		jmp	next_process1
exit$		rts
;---------------------------------------------------------------------
;		Y W Xgbv
;---------------------------------------------------------------------
check_Y		ldx	<register
		lda	<_dispY,x
		bmi	exit$
		cmp	!2,y
		bcc	exit$
		jmp	next_process1
exit$		rts
;---------------------------------------------------------------------
;		ʒu Xgbv
;---------------------------------------------------------------------
check_erase	ldx	<register
		lda	<_dispY,x
		bpl	exit$
		cmp	#0f000h
		bcs	exit$
		jmp	next_process0
exit$		rts
;---------------------------------------------------------------------
;		tO܂ŃEFCg
;---------------------------------------------------------------------
flag_wait	ldx	<register
		lda	<_AN_mail,x
		bpl	exit$
		stz	<_AN_mail,x
		iny
		iny
		tyx
		jmp	(!0,x)
exit$		rts
;---------------------------------------------------------------------
;		Pf[^ZbgŎ̃vZX
;---------------------------------------------------------------------
next_process1	iny
		iny
next_process0	iny
		iny
		sty	<_CN_pointer,X	; next data
		rts
;----------------------------------------------------------------------
;	ʂ̃vO
;----------------------------------------------------------------------
jump_prog	ldx	!2,y
		txy
		jmp	(!0,x)
;----------------------------------------------------------------------
;	`FbNGA
;----------------------------------------------------------------------
check_out	ldx	<oyabun
		lda	<_flag,x	; ʊOH
		lsr	a
		bcc	skip$
		lda	<_BGcheck_status,x
		cmp	#22h		; OH
		beq	skip$
		iny
		iny
skip$		ldx	!2,y
		txy
		jmp	(!0,x)
;----------------------------------------------------------------------
;	`FbN}bv
;----------------------------------------------------------------------
ptn_map		dw	0	; ΂I
		dw	4	; T[Lbg
		dw	4	; 
		dw	4	; _[g
		dw	4	; X
		dw	4	; C
		dw	2	; Nbp
		dw	0	; C{[
;- - - - - - - - - - - - - - - - - - - - - - - - - - 
check_map	tya
		ldx	!map_type
		clc
		adc	!ptn_map,x
		tay
		ldx	!2,y
		txy
		jmp	(!0,x)
;----------------------------------------------------------------------
;	vC[𓮂
;----------------------------------------------------------------------
move_player	ldx	<oyabun
		lda	<_situationZL+1,x
		cmp	#0700h
		bcs	skip$
		adc	#0040h
		sta	<_situationZL+1,x
skip$		iny
		iny
		tyx
		jmp	(!0,x)

;----------------------------------------------------------------------
;	vC[nɂ肽WQ؂藣
;----------------------------------------------------------------------
jugem_ground	phy
		ldx	<register
		ldy	<_oyabun,x
		lda	!_situationZL+1,y
		bne	exit$
		ply
		jmp	next_process0
exit$		ply
		rts
;----------------------------------------------------------------------
;	vC[ɂЂăWQ𓮂
;----------------------------------------------------------------------
jugem_kiss	phy				; >>
		lda	#0
		SEP	#00100000B
		MEM8
		ldx	<register
		ldy	<_oyabun,x
		lda	!_situationZH,y		;B
		cmp	#18H
		bcs	kiss_exit
		lda	!_sunder_timer+0,y
		ora	!_sunder_timer+1,y
		beq	skip$
		lda	#08h			; `r̎I
		bra	set$
skip$		lda	!_status,y	
		tay
		lda	!add_offset,y	
		ldy	<oyabun
set$		cpy	#player_r0
		bne	kiss_Bscreen
;- - - - - - - - - - - - - - - - - - - - - - - - -
kiss_Ascreen	clc
		adc	!_posV_A,y
		adc	#0E2H
		bra	kiss_set
;- - - - - - - - - - - - - - - - - - - - - - - - -
kiss_Bscreen	clc
		adc	!_posV_B,y
		adc	#0E2H-70H		; kart Y
kiss_set	sta	<_dispY+1,x
kiss_next	lda	#71h			; kart X
		sta	<_dispX+1,x
kiss_exit	REP	#00100000B
		MEM16
		ply				; <<
		iny
		iny
		tyx
		jmp	(!0,x)
;- - - - - - - - - - - - - - - - - - - - - - - - -
add_offset	dw	0ffh,0feh,0fdh,0feh,0feh,002,0ffh,0
;----------f-----------------------------------------------------------
;	̖[v
;---------------------------------------------------------------------
jugem_loop	ldx	<register
		rts
;---------------------------------------------------------------------
;	WQ܂ő҂
;---------------------------------------------------------------------
vxvy_check	ldx	<register
		bit	<_end_flag,x	; /8000/
		bmi	next$
		stz	<_accelX,x
		stz	<_accelY,x
		stz	<_reverseX,x
		stz	<_reverseY,x
		lda	#-0200h		; 
		sta	<_velocityY,x
		jsr	move_main
		inx
		inx
		jsr	move_main
		dex
		dex
		lda	<_dispY,x	; xWƂĂ邩H
		bpl	exit$
		cmp	#0f000h
		bcs	exit$
next$		stz	<_end_flag,x	; /0/
		jmp	next_process0
exit$		rts
;---------------------------------------------------------------------
;
;
;
;
;
;
;*********************************************************************
;		control data
;*********************************************************************
_move_start	equ	2
_move_yellow	equ	6
_move_yellow_of	equ	10		
_move_goal	equ	8
;;;;;
_move_sea_wait	equ	4
_move_sea_off	equ	20
_move_takeout	equ	18
_move_comeback	equ	16
;;;;;
_move_overout	equ	22	; O߂
;;;;;
_move_lap	equ	12
_move_final	equ	14
;- - - - - - - - - - - - - - - - - - - - - - - -
jugem_CSEQ	DW	jugem_ASEQ		;00 (-> animetion pointer)
		DW	c_start			;02  X^[gVOi
		DW	c_sea_wait		;04
		DW	c_yellow		;06
		DW	c_goal			;08
		DW	c_yellow_off		;10
		DW	c_lap			;12
		DW	c_final			;14
		DW	c_comeback		;16
		DW	c_takeout		;18
		DW	c_sea_off		;20
		DW	c_overout		;22
;*********************************************************************
;		JUGEM MAIN
;*********************************************************************
prog_jugem	dw	control
		dw	animation
		dw	set_jugem
		dw	jugem_shadow
;--------------------------------------------------------------------
select_player	dw	player_r0,player_r1
select_jugem	dw	jugem_r0,jugem_r1
;--------------------------------------------------------------------
;		WQ\C[`
;--------------------------------------------------------------------
obj_start	ldy	#1
		sty	!round_process		; Eh ROGO
		tay
		lda	!demo_camera		
		trb	<camera_control		
		tya
		ldy	#_move_start
		and	#0
		jmp	init_am_clear
;- - - - - - - - - - - - - - - - - - - - -
Set_jugem				; A = DATA
		ldy	!jugem_flag,x	; jugem ON ?
		bmi	jugem_quit	; no
		ldy	!select_jugem,x	; jugem index 
		sty	<register	; 
		bit	!goal_jugem,x
		bmi	obj_goal
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ora	!_lap_stock,y
;					; tO bit `FbN
		cmp	#0		; gK͂邩H
		beq	skip_am	
		bit	#ON_goalin	; `FbJ[tO
		bne	obj_goal
		bit	#ON_start	; X^[g
		bne	obj_start
;- - - - - - - - - - - - - - - - - - - - - - - 		
		bit	#ON_comeback	; 艺 ON / WQ Ȃ
		bne	obj_comeback
		bit	#ON_overout
		bne	obj_overout
		bit	#ON_takeout	; Ђǂ
		bne	obj_takeout
		bit	#OFF_sea_wait	; ҋ@
		bne	obj_sea_off
		bit	#ON_sea_wait	; J[g肠ҋ@
		bne	obj_sea_wait
;- - - - - - - - - - - - - - - - - - - - - - - 
		bit	#ON_lap
		bne	obj_lap
		bit	#ON_final
		bne	obj_final
;- - - - - - - - - - - - - - - - - - - - - - - 
		bit	#ON_yellow	; ttO
		bne	obj_yellow

		stz	!official_flag,x
;- - - - - - - - - - - - - -
skip_am		lda	!_CN_start,y
		cmp	#c_yellow
		bne	notime_am
		ldx	<_oyabun,y
		lda	<_flag,x
		and	#400h
		bne	notime_am
		ldy	#_move_yellow_of
		bra	init_am
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
notime_am	ldy	#0
;- - - - - - - - - - - - - - - -
init_am		
		ldx	<register
		lda	<_oyabun,x
		sta	<oyabun
					; Y = jugem control index
		ldx	#prog_jugem	; X = program index
		jsr	(!0,x)		; Set 
		bcc	_set		;
		jsr	clear_jugem	; Clear
_set		rtl
;- - - - - - - - - - - - - - - - - - - - - - - 
jugem_quit	jsr	clear_jugem
		rtl
;----------------------------------------------------------------------
obj_goal	dec	!goal_jugem,x	; 8000 - FFFF
		ldy	#_move_goal
		bra	init_am
;- - - - - - - - - - - - - - - - - - - - -
obj_sea_wait	ldy	#_move_sea_wait
		bra	init_am
obj_takeout	ldy	#_move_takeout
		bra	init_am
obj_overout	ldy	#_move_overout
		bra	init_am
obj_comeback	ldy	#_move_comeback
		and	#(ON_lap+ON_final)
		bra	init_am_clear
obj_sea_off	ldy	#_move_sea_off
		and	#(ON_lap+ON_final+ON_yellow+OFF_yellow)
		bra	init_am_clear
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
init_am_clear	sta	!official_flag,x	; tO NA
		bra	init_am
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
obj_lap		
;- - - - - - - - - - - - - - - - - - - -
		jsr	check_double
		ldy	#_move_lap
		lda	#0
		bra	init_am_clear
;- - - - - - - - - - - - - - - - - - - - -
obj_final	jsr	check_double
		ldy	#_move_final
		lda	#0
		bra	init_am_clear
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
obj_yellow	bit	#OFF_yellow	; ttO
		bne	off_yellow_GO
		ldy	#_move_yellow
		jmp	init_am
off_yellow_GO	ldy	#_move_yellow_of
		and	#(ON_lap+ON_final)
		bra	init_am_clear
;- - - - - - - - - - - - - - - - - - - - -
check_double	sta	!_lap_stock,y	; tȌdȂ`FbN
		lda	!_CN_start,y	; ȂɂĂ pX
		bne	skip$
		lda	!_oyabun,y
		tay
		lda	!event_index,y
		cmp	#0ch
		beq	skip$
		ldy	<register
		lda	#0
		sta	!_lap_stock,y
		rts
;- - - - - - - - - - - - - - - - - - -
skip$		plx
		jmp	skip_am
;*********************************************************************
;		CONTROL PROGRAM
;*********************************************************************
;(control initial)
;----------------------------------------------------------------------
control		PHX				;>>
		LDX	<register
		LDA	<_CN_register,X
		STA	<anim_addr
		TYA
		BEQ	Main_AM
		LDA	(<anim_addr),Y		;
		CMP	<_CN_start,X
		BEQ	Main_AM
		STA	<_CN_start,X		; control initial
		STA	<_CN_pointer,X	; new pointer
;----------------------------------------------------------------------
;(control main)	
Main_AM		LDY	<_CN_pointer,X
		BNE	am_100
		PLX				;<<
		SEC				;(FLAG)		
		RTS
;
am_100		TYX
		JSR	(!0,X)
;----------------------------------------------------------------------
;(animation initial)
Main_Anime	LDA	(<anim_addr)
		STA	<anim_addr
		LDY	<_AN_number,X	; animetion SEQ number
		BNE	skip_AM
		STZ	<_AN_start,X		; obj erase
		PLX				;<<
		SEC				;(FLAG)
		RTS
skip_AM		LDA	(<anim_addr),Y
		CMP	<_AN_start,X		; newdata = entry ?
		BEQ	next_AM
		STA	<_AN_start,X		; entry address
		STA	<_AN_pointer,X	; pointer reset!
		STZ	<_AN_timer,X		; timer reset!
		LDA	(<anim_addr)
		STA	<_AN_register,X	;
next_AM		PLX				;<<
		INX
		INX
		JMP	(!0,X)
;======================================================================
;*********************************************************************
;		animation
;*********************************************************************
;(animation main)
animation	PHX				;>>
		LDX	<register
		LDY	<_AN_pointer,X	;W <- SEQ pointer
		DEC	<_AN_timer,X		;W	timer>0 ?
		BPL	skip_move		;	yes -> anime
;------------------------------------------------
		INY
		INY
		STY	<_AN_pointer,X	;W ( pointer inc )
;------------------------------------------------
		LDA	!0,Y			;W(B)
		BIT	#0080H			;W(B)
		BEQ	set_character		;
		DEC	<_AN_mail,X		;W
		LDA	!1,Y			;W
		TAY				;WW Y=new pointer
		STY	<_AN_pointer,X	;
		LDA	!0,Y			;W(B)
;------------------------------------------------
set_character	AND	#00FFH			;W
		STA	<_AN_timer,X		;W(B) frame timer
;------------------------------------------------
skip_move	LDA	!1,Y			;W(OBJ block number)
		AND	#00FFH			;W
		ASL	A			;W(CLC)
		ADC	<_AN_register,X	;W data register
		TAY				;WW
;
		LDA	!0,Y			;W read
		CLC
		ADC	<_AN_register,X	;W
;
		STA	<block_pointer		;W data pointer
;-------------------------------------------------------------------
		PLX				;<<
		INX
		INX
		JMP	(!0,X)
;======================================================================
;*********************************************************************
;		position
;*********************************************************************
set_jugem	PHX				;>>
		LDX	<register
		SEP	#00100001B
		MEM8
		LDA	<_dispY+1,X
		XBA	
		LDA	<_dispX+1,X
		SBC	#hx
		REP	#00100001B
		MEM16
		TAY
		LDA	<_attribute,X
		TAX
		LDA	#20H		; sprite pointer

		JSL	>OAM_jugem
;
		LDY	<register

		LDX	<_AN_number,Y
		CPX	#_code_lap

		BNE	oamset_exit			
		LDX	<_oyabun,Y
		LDA	#20H+0CH
		CLC
		ADC	<screen_oam
		TAY			; oam pointer
		SEP	#00100000B
		MEM8
		LDA	<_lap+1,X	; LAP
		BMI	set_lap
		LDA	#0a1H		;	0a1=LAP 0
		BRA	skip_lap
set_lap		AND	#07H
		ADC	#0a2H		;CLC	0a2=LAP 1
skip_lap	STA	!sprite_C,Y
		REP	#00100000B
		MEM16
;
oamset_exit	PLX				;<<
		INX
		INX
		JMP	(!0,X)
;*********************************************************************
;
;		JUGEM INITIAL
;
;*********************************************************************
Init_jugem	LDY	#jugem_CSEQ		; control SEQ address
		LDX	#jugem_r0
		LDA	#player_r0	; 1 P
		JSL	>mount_ju
		LDX	#jugem_r1
		LDA	#player_r1	; 2 P
;----------------------------------------------------------------------
mount_ju	STA	<_oyabun,X
		STY	<_CN_register,X	; DATA pointer
		lda	#2000h
		sta	<_attribute,X
		RTL
;*********************************************************************
;		clear routine
;*********************************************************************
clear_jugem	SEP	#00100000B
		MEM8
		LDA	#55H
		LDY	<screen_oam		; 220H offset
		STA	!sprite_E+2,Y
		STA	!sprite_E+3,Y
		STA	!sprite_E+1FH,Y
		REP	#00100000B
		MEM16
		RTS
;*********************************************************************
;		shadow routine
;*********************************************************************
SH		EQU	1F0H
shadow_V	EQU	5a00H
;----------------------------------------------------------------------
jugem_shadow	LDX	<register
		SEP	#00100000B
		MEM8
		LDY	#shadow_3		; shadow MIN
		LDA	<_dispY+1,X
		BMI	small_shadow
		LDY	#shadow_2		; shadow MID
		CMP	#20H
		BCC	small_shadow
		LDY	#shadow_1		; shadow MAX
small_shadow	LDA	<frame_counter
		LSR	A			; set carry
		LDA	<_dispX+1,X
		TYX
		LDY	<screen_register
		BEQ	Set_shadow1
;----------------------------------------------------------------------
Set_shadow2	BCC	clear_shadow		; SEC
		CLC
		ADC	!0,X			; 
		REP	#00100001B
		MEM16				; CLC
		AND	#00FFH
		ORA	#shadow_V+Bscreen_offset
		BRA	shadow_common
;---------------------------------------------------------------------
		mem8
Set_shadow1	BCS	clear_shadow		; CLC
		ADC	!0,X
		REP	#00100001B
		MEM16				; CLC
		AND	#00FFH
		ORA	#shadow_V
shadow_common	
		LDY	<screen_oam		; OAM pointer
		STA	!sprite_H+0+SH,Y	; position
		ADC	#0006H
		STA	!sprite_H+4+SH,Y	; position
		ADC	#0006H
		STA	!sprite_H+8+SH,Y	; position
;
		LDA	!1,X
		STA	!sprite_C+0+SH,Y	; character
		LDA	!3,X
		STA	!sprite_C+4+SH,Y	; character
		LDA	!5,X
		STA	!sprite_C+8+SH,Y	; character
		SEP	#00100000B
		MEM8
		LDA	#0
sub_shadow	STA	!sprite_E+( SH >> 4 ),Y
		REP	#00100001B
		MEM16				;(CLC)
		RTS
;----------------------------------------------------------------------
		mem8
clear_shadow	LDA	#055H
		LDY	<screen_oam		; OAM pointer
		BRA	sub_shadow
;--------------------------------------------------------------------
shadow_1	DB	0F2H	; H position offset
		DW	3AEBH
		DW	3AECH
		DW	7AEBH
shadow_2	DB	0F5H	; H position offset
		DW	3AEBH
		DW	7AEBH
		DW	0044H
shadow_3	DB	0F8H	; H position offset
		DW	3AEDH
		DW	0044H
		DW	0044H

;*********************************************************************
;		animation data
;*********************************************************************
_code_start	equ	2
_code_black	equ	4
_code_yellow	equ	6
_code_goal	equ	8
_code_lap	equ	10
_code_final	equ	12
_code_fault	equ	14
;- - - - - - - - - - - - - - - - - - - - - - - -

jugem_ASEQ	DW	JUGEM_entry		;0 (-> sprite pointer)
		DW	jugem_start-2		;2  X^[gVOi
		DW	jugem_black-2		;4  ubNtbO
		DW	jugem_yellow-2		;6  CG[tbO
		DW	jugem_goal-2		;8  `FbJ[tbO
		DW	jugem_lap-2		;10 ʏ탉bv
		DW	jugem_final-2		;12 t@Cibv
		DW	jugem_fault		;14 肳
;----------------------------------------------------------------------
jugem_start	DB	60H,00		; start timming ON
		DB	35H,00
		DB	35H,01
		DB	35H,02
st_loop		DB	40H,03		; jugem start
		DB	80H
		DW	st_loop
;
jugem_black	DB	10H,04
		DB	10H,05
		DB	80H
		DW	jugem_black
;
jugem_yellow	DB	10H,06
		DB	10H,07
		DB	80H
		DW	jugem_yellow
;
jugem_goal	DB	10H,09
		DB	10H,08
		DB	10H,10
		DB	10H,08
		DB	10H,10
		DB	10H,08
		DB	80H
		DW	jugem_goal
;
jugem_lap	DB	10H,11		;B
		DB	80H
		DW	jugem_lap
jugem_final	DB	10H,12		;C
		DB	80H
		DW	jugem_final
jugem_fault	DB	10H,13		;D
		DB	80H
		DW	jugem_fault

;----------------------------------------------------------------------

		include	jugem.dat

;----------------------------------------------------------------------

		END
