;*********************************************************************
;	mario kart << OAM set >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include		../DEF/effect.def
;----------------------------------------------------------------------
;	( 4 OAM SET )
		GLB	tetre8,tetre8_v
		GLB	tetre16,tetre16_v
;	( 2 OAM SET )
		GLB	double8,double8_v
		GLB	double16,double16_v
;	( 1 OAM SET )
		GLB	monon8,monon8_v,monon8_item
		GLB	monon16,monon16_v,monon16_item
		
;	( SPECIAL OAM SET )
		GLB	OAM_option	; calc flip H	<< NO SUB >>
					; max 8 oam
		GLB	OAM_jugem	; 		<< NO SUB >>
					; max 8 oam
		GLB	BD_sprite	;		<< NO SUB >>
					; max 128
;----------------------------------------------------------------------
		COMN
temp		DS	2	;(0)
pointer_1	DS	2	;(2)
pointer_C	DS	2	;(4)
pointer_H	DS	2	:(6)
pointer_V	DS	2	;(8)
expansion	DS	1	;(A)
obj_size	DS	2	;(B)
sub_flag	DS	2	;(D)
;----------------------------------------------------------------------
work		EQU	0		; common work
flip		EQU	4
;----------------------------------------------------------------------
		EXTEND
objprog	SECT	REL
		mem16
		idx16
;***********************************************************************
;		DATA EREA (bank0)
;***********************************************************************
expansion_bits	DB	01010101B	; 0000(0)
		DB	00010101B	; 0001(1)
		DB	01000101B	; 0010(2)
		DB	00000101B	; 0011(3)
		DB	01010001B	; 0100(4)
		DB	00010001B	; 0101(5)
		DB	01000001B	; 0110(6)
		DB	00000001B	; 0111(7)
		DB	01010100B	; 1000(8)
		DB	00010100B	; 1001(9)
		DB	01000100B	; 1010(a)
		DB	00000100B	; 1011(b)
		DB	01010000B	; 1100(c)
		DB	00010000B	; 1101(d)
		DB	01000000B	; 1110(e)
		DB	00000000B	; 1111(f)
;***********************************************************************
;	2x2 size OBJECT OAM SET MODULE
;***********************************************************************
double16_v	LDA	!6,X		; 16x16 size 2 block + offset
		CLC
		ADC	<position_V
		STA	<position_V
double16	LDA	#10101010B	; 16x16 size 2 block
		BRA	double_size
double8_v	LDA	!6,X		; 8x8 size 2 block + offset
		CLC
		ADC	<position_V
		STA	<position_V
double8		LDA	#00000000B	; 8x8 size 2 block
double_size	STA	<obj_size
;-----------------------------------------------------------------------
		LDA	!4,X			;W
		STA	<pointer_C		;W set character pointer
		LDY	!2,X			;W Y=position pointer
		BIT	<attribute		;W H flip check
		BVS	double_flip
		BPL	double_nomal
		INX				;  V flip
		INX
double_flip	LDY	!8,X			;W Y=position pointer
double_nomal
;-----------------------------------------------------------------------
		STZ	<temp			;W
		LDX	<sprite_count		;W X=OAM pointer
;(block 1)-------------
		LDA	<position_V		;W ***
		CLC
		ADC	!0,Y			:W	
		STA	<sprite_V+0,X		;W
		LDA	<position_H		;W ***
		CLC
		ADC	!2,Y			;W
		SEP	#00100000B
		MEM8
		STA	<sprite_H+0,X		;B <--- H store
		XBA
		LSR	A			;B
		ROL	<temp			;B
		REP	#00100001B
		MEM16
;(block 2)-------------
		LDA	<position_V		;W ***
		ADC	!4,Y			:W	
		STA	<sprite_V+4,X		;W
		LDA	<position_H		;W ***
		CLC
		ADC	!6,Y			;W
		SEP	#00100000B
		MEM8
		STA	<sprite_H+4,X		;B <--- H store
		XBA
		LSR	A			;B
		ROL	<temp			;B
		ASL	<temp			;B
		ASL	<temp			;B
		LDA	#0E0H
		STA	<sprite_V+8,X		;W
		STA	<sprite_V+12,X		;W
		REP	#00100001B
		MEM16
;--------------------------------------------------------------------
		LDY	<pointer_C		;W
		JMP	set_double_A
;***********************************************************************
;	4x4 size OBJECT OAM SET MODULE
;***********************************************************************
tetre16_v	LDA	!6,X		; 16x16 size 4 block + offset
		CLC
		ADC	<position_V
		STA	<position_V
tetre16		LDA	#10101010B	; 16x16 size 4 block
		BRA	set_size
tetre8_v	LDA	!6,X		; 8x8 size 4 block + offset
		CLC
		ADC	<position_V
		STA	<position_V
tetre8		LDA	#00000000B	; 8x8 size 4 block 
set_size	STA	<obj_size
;-----------------------------------------------------------------------
		LDA	!4,X			;W
		STA	<pointer_C		;W set character pointer
		LDY	!2,X			;W Y=position pointer
		BIT	<attribute
		BVS	tetre_flip
		BPL	tetre_nomal
		INX				;  V flip
		INX
tetre_flip	LDY	!8,X			;W Y=position pointer
tetre_nomal
;-----------------------------------------------------------------------
tetre_upper	LDX	<sprite_count		;W Y=OAM pointer
;(block 1)-------------
		STZ	<temp			;B clear sub work
		LDA	<position_V		;W ***
		CLC
		ADC	!0,Y			:W	
		STA	<sprite_V+0,X		;W
		LDA	<position_H		;W ***
		CLC
		ADC	!2,Y			;W
		SEP	#00100000B
		MEM8
		STA	<sprite_H+0,X		;B <--- H store
		XBA
		LSR	A			;B
		ROL	<temp			;B
		REP	#00100001B
		MEM16
;(block 2)-------------
		LDA	<position_V		;W ***
		ADC	!4,Y			:W	
		STA	<sprite_V+4,X		;W
		LDA	<position_H		;W ***
		CLC
		ADC	!6,Y			;W
		SEP	#00100000B
		MEM8
		STA	<sprite_H+4,X		;B <--- H store
		XBA
		LSR	A			;B
		ROL	<temp			;B
		REP	#00100001B
		MEM16
;(block 3)-------------
		LDA	<position_V		;W ***
		ADC	!8,Y			:W	
		STA	<sprite_V+8,X		;W
		LDA	<position_H		;W ***
		CLC
		ADC	!10,Y			;W
		SEP	#00100000B
		MEM8
		STA	<sprite_H+8,X		;B <--- H store
		XBA
		LSR	A			;B
		ROL	<temp			;B
		REP	#00100001B
		MEM16
;(block 4)-------------
		LDA	<position_V		;W ***
		ADC	!12,Y			:W	
		STA	<sprite_V+12,X		;W
		LDA	<position_H		;W ***
		CLC
		ADC	!14,Y			;W
		SEP	#00100000B
		MEM8
		STA	<sprite_H+12,X		;B <--- H store
		XBA
		LSR	A			;B
		ROL	<temp			;B
		REP	#00100001B
		MEM16
;(characetr)-------------
		LDY	<pointer_C		;
		LDA	!6,Y
		EOR	<attribute
		STA	<sprite_C+12,X
		LDA	!4,Y
		EOR	<attribute
		STA	<sprite_C+8,X
set_double_A	LDA	!2,Y
		EOR	<attribute
		STA	<sprite_C+4,X
		LDA	!0,Y
		EOR	<attribute
		STA	<sprite_C+0,X
;(set sub)-------------
		TXA
		ADC	#10H			;(CLC)
		STA	<sprite_count
		TXA
		LSR	A
		LSR	A
		LSR	A
		LSR	A				;(CLC)
		ADC	<screen_sub		;(CLC)
		TAX
		SEP	#00100000B
		MEM8
		LDY	<temp			;B
		LDA	!expansion_bits,Y	;B
		ORA	<obj_size		;B 16x16 size
		STA	<0,X			;B
		REP	#00100000B
		MEM16
		RTS
;***********************************************************************
;	1x1 size OBJECT OAM SET MODULE
;***********************************************************************
mono_8_pos	DW	0FFFCH,0FFF8H		; basic position
item_8_pos	DW	0FFFCH,0FFF7H		; basic position (-1)
mono_16_pos	DW	0FFF8H,0FFF0H		; basic position
item_16_pos	DW	0FFF8H,0FFEFH		; basic position (-1)
;-----------------------------------------------------------------------
monon16_item	LDA	#00000011B		;W(B)
		LDY	#item_16_pos
		BRA	entry_monon
monon16_v	LDA	!4,X
		CLC
		ADC	<position_V
		STA	<position_V
monon16		LDA	#00000011B		;W(B)
		LDY	#mono_16_pos
		BRA	entry_monon
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
monon8_item	LDA	#00000001B		;W(B)
		LDY	#item_8_pos
		BRA	entry_monon
monon8_v	LDA	!4,X
		CLC
		ADC	<position_V
		STA	<position_V
monon8		LDA	#00000001B		;W(B)
		LDY	#mono_8_pos	
;----------------------------------------------------------------------
entry_monon	STA	<obj_size		
		LDA	!2,X			;W A= character
		LDX	<sprite_count		;W
		EOR	<attribute		;W ***
		STA	<sprite_C,X		;W
;
		LDA	!0,Y			;W
		CLC
		ADC	<position_H		;W ***
		SEP	#00100000B
		MEM8
		STA	<sprite_H,X		;B
		XBA
		AND	#00000001B		;B
		EOR	<obj_size		;B
		STA	<obj_size		;B
		REP	#00100001B
		MEM16
		LDA	!2,Y			;W
		ADC	<position_V		;W
		SEP	#00100000B
		MEM8
		STA	<sprite_V,X		;B
		LDA	#0E0H			;B
		STA	<sprite_V+4,X		;B
		STA	<sprite_V+8,X		;B
		STA	<sprite_V+12,X		;B
		REP	#00100001B
		MEM16
		TXA				;WW A = sprite count
		ADC	#10H			;W
		STA	<sprite_count		;W next sprite count
		LSR	A
		LSR	A
		LSR	A
		LSR	A				;CLC
		ADC	<screen_sub
		TAY				;W
		LDA	<obj_size		;W(B)
		STA	!0FFFFH,Y		;W(B)
monon_exit	RTS
;*********************************************************************
;		OAMSET <<jugem version>>
;*********************************************************************
;		OAM 	max 8 	(0-7) 
;			size	1 or 0
;			sub	NO SET		
;=====================================================================
		mem16
		idx16
OAM_jugem	STX	<attr		; attribute
		STY	<pos_H		; low H high V
		CLC
		ADC	<screen_oam
		TAY			; sprite count
		LDA	<pos_H		;CLC
		ADC	<screen_obj_V
		STA	<pos_H
;
		LDX	<block_pointer
		LDA	!0,X
		AND	#00FFH
		DEC	A
		ASL	A		;CLC
		TAX
		LDA	<block_pointer
		ADC	>ADC_select,X
		PHA			;>>
;
		LDA	#0E0E0H
		JSR	(!CLR_select,X)		; OAM erea clear
		CLC
		JSR	(!SPEED_select,X) 	; OAM erea set

		TXA			; X = sprite count
		LSR	A
		LSR	A
		LSR	A
		LSR	A			;(CLC)
		ADC	<screen_sub
		TAX			; Y = sub count
		PLY			;<<
		LDA	!0,Y		; SUB DATA
		STA	<0,X		; SPRITE-E
		RTL

;*********************************************************************
;		OAMSET << smorke version >>
;*********************************************************************
;		OAM 	max 8 	(0-7) 
;			size	1 or 0
;			sub	NO SET		
;=====================================================================
		mem16
		idx16
OAM_option	
		PEA	BC_00_7E	;>> data bank 0F
		PLB			;<
;
		STX	<attr		; attribute
		STY	<pos_H		; low H high V
		LDA	<sprite_count
		TAY
		CLC
		ADC	#20H
		STA	<sprite_count
;
		LDX	<block_pointer
		LDA	!0,X
		AND	#00FFH
		DEC	A
		ASL	A		;CLC
		TAX
		LDA	<block_pointer
		ADC	>ADC_select,X	; <- subset pointer
		PHA			;>>
;
		LDA	#0E0E0H		; clear V 
		JSR	(!CLR_select,X)	; OAM erea clear
;
		BIT	<attr
		BVC	nomal_obj
		SEP	#00100001B
		MEM8
		LDA	<pos_H
		SBC	#10H-1		;SEC   (-1)-> flip INC
		STA	<pos_H
		LDA	#0FFH
		STA	<flip
		REP	#00100001B
		MEM16			;CLC
		BRA	flip_obj		
nomal_obj	CLC
		STZ	<flip
flip_obj	JSR	(!SET_select,X)	
;
		TXA			; Y = sprite count
		LSR	A
		LSR	A
		LSR	A
		LSR	A			;(CLC)
		ADC	<screen_sub
		TAX			; Y = sub count
		PLY			;<<
		LDA	!0,Y		; SUB DATA
		STA	<0,X		; SPRITE-E
;
		PLB			;< data bank 00
		RTS
;---------------------------------------------------------------------
ADC_select	DW	05,09,13,17
		DW	21,25,29,33
CLR_select	DW	clear_1,clear_2,clear_3,clear_4
		DW	clear_5,clear_6,clear_7,clear_8
SET_select	DW	set_1x,set_2x,set_3x,set_4x
		DW	set_5x,set_6x,set_7x,set_8x
SPEED_select	DW	speed_1x,speed_2x,speed_3x,speed_4x
		DW	speed_5x,speed_6x,speed_7x,speed_8x
;---------------------------------------------------------------------
set_7x		TYX				; X= oam pointer
		LDY	<block_pointer
		JMP	set_7
set_6x		TYX
		LDY	<block_pointer
		JMP	set_6
set_5x		TYX
		LDY	<block_pointer
		JMP	set_5
set_4x		TYX
		LDY	<block_pointer
		JMP	set_4
set_3x		TYX
		LDY	<block_pointer
		JMP	set_3
set_2x		TYX
		LDY	<block_pointer
		JMP	set_2
set_1x		TYX
		LDY	<block_pointer
		JMP	set_1
;---------------------------------------------------------------------
speed_7x	TYX
		LDY	<block_pointer
		JMP	speed_7
speed_6x	TYX
		LDY	<block_pointer
		JMP	speed_6
speed_5x	TYX
		LDY	<block_pointer
		JMP	speed_5
speed_4x	TYX
		LDY	<block_pointer
		JMP	speed_4
speed_3x	TYX
		LDY	<block_pointer
		JMP	speed_3
speed_2x	TYX
		LDY	<block_pointer
		JMP	speed_2
speed_1x	TYX
		LDY	<block_pointer
		JMP	speed_1
;---------------------------------------------------------------------
co	EQU	1
;---------------------------------------------------------------------
speed_8x	TYX
		LDY	<block_pointer
		LDA	!30+co,Y
		EOR	<attr
		STA	<sprite_C+28,X
		CLC
		LDA	!28+co,Y
		ADC	<pos_H
		STA	<sprite_H+28,X
speed_7		LDA	!26+co,Y
		EOR	<attr
		STA	<sprite_C+24,X
		CLC
		LDA	!24+co,Y
		ADC	<pos_H
		STA	<sprite_H+24,X
speed_6		LDA	!22+co,Y
		EOR	<attr
		STA	<sprite_C+20,X
		CLC
		LDA	!20+co,Y
		ADC	<pos_H
		STA	<sprite_H+20,X
speed_5		LDA	!18+co,Y
		EOR	<attr
		STA	<sprite_C+16,X
		CLC
		LDA	!16+co,Y
		ADC	<pos_H
		STA	<sprite_H+16,X
speed_4		LDA	!14+co,Y
		EOR	<attr
		STA	<sprite_C+12,X
		CLC
		LDA	!12+co,Y
		ADC	<pos_H
		STA	<sprite_H+12,X
speed_3		LDA	!10+co,Y
		EOR	<attr
		STA	<sprite_C+8,X
		CLC
		LDA	!8+co,Y
		ADC	<pos_H
		STA	<sprite_H+8,X
speed_2		LDA	!6+co,Y
		EOR	<attr
		STA	<sprite_C+4,X
		CLC
		LDA	!4+co,Y
		ADC	<pos_H
		STA	<sprite_H+4,X
speed_1		LDA	!2+co,Y
		EOR	<attr
		STA	<sprite_C+0,X
		CLC
		LDA	!0+co,Y
		ADC	<pos_H
		STA	<sprite_H+0,X
		RTS
;---------------------------------------------------------------------
set_8x		TYX
		LDY	<block_pointer
		LDA	!30+co,Y
		EOR	<attr
		STA	<sprite_C+28,X
		SEP	#00100000B
		MEM8
		LDA	!29+co,Y	;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!28+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+28,X
;
set_7		LDA	!26+co,Y
		EOR	<attr
		STA	<sprite_C+24,X
		SEP	#00100000B
		MEM8
		LDA	!25+co,Y		;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!24+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+24,X

set_6		LDA	!22+co,Y
		EOR	<attr
		STA	<sprite_C+20,X
		SEP	#00100000B
		MEM8
		LDA	!21+co,Y		;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!20+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+20,X

set_5		LDA	!18+co,Y
		EOR	<attr
		STA	<sprite_C+16,X
		SEP	#00100000B
		MEM8
		LDA	!17+co,Y		;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!16+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+16,X

set_4		LDA	!14+co,Y
		EOR	<attr
		STA	<sprite_C+12,X
		SEP	#00100000B
		MEM8
		LDA	!13+co,Y		;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!12+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+12,X

set_3		LDA	!10+co,Y
		EOR	<attr
		STA	<sprite_C+8,X
;
		SEP	#00100000B
		MEM8
		LDA	!9+co,Y			;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!8+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+8,X

set_2		LDA	!6+co,Y
		EOR	<attr
		STA	<sprite_C+4,X
		SEP	#00100000B
		MEM8
		LDA	!5+co,Y			;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!4+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+4,X

set_1		LDA	!2+co,Y
		EOR	<attr
		STA	<sprite_C+0,X
		SEP	#00100000B
		MEM8
		LDA	!1+co,Y			;CLC
		ADC	<pos_V
		XBA
		CLC
		LDA	!0+co,Y
		EOR	<flip
		ADC	<pos_H
		REP	#00100001B
		MEM16
		STA	<sprite_H+0,X
;
		RTS
;---------------------------------------------------------------------
clear_1		STA	!sprite_V+04,Y	
clear_2		STA	!sprite_V+08,Y
clear_3		STA	!sprite_V+12,Y
clear_4		STA	!sprite_V+16,Y	
clear_5		STA	!sprite_V+20,Y
clear_6		STA	!sprite_V+24,Y
clear_7		STA	!sprite_V+28,Y	
clear_8		RTS
;---------------------------------------------------------------------
;**********************************************************************
;	ׂXvCg̃Zbg	( NO SUB / NO SIZE )
;**********************************************************************
wk_position	EQU	0	;
wk_counter	EQU	2	;
wk_size		EQU	4	;naȋ傫
wk_4count	EQU	6
special_attr	EQU	8	; |[YĂ oNO
				; |[YĂȂ΁@oNP
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
						; Y=data pointer
BD_sprite	STA	<wk_position+0		; A=main position V,H

		lda	#3000h			; |[Ŷ߂̓
		bit	!pause_status		; 
		bmi	pause$
		ora	#0100h
pause$		sta	<special_attr

		SEP	#00100000B
		MEM8
		LDX	#0
		LDA	!0,Y			; counter read
		BPL	skip$
		LDX	#0AAAAH
		AND	#7FH
skip$		PHA			;>
		LSR	A
		LSR	A
		STA	<wk_4count	;SPʂ̃XvCg
		STX	<wk_size
		INY
		LDX	<sprite_count
		BRA	entry$		
loop$		LDA	#4
		JSR	Set_4_sprite
entry$		DEC	<wk_4count
		BPL	loop$
		PLA			;<
		AND	#03H		;PPʂ̃XvCg(܂)
		BEQ	exit$
		JSR	Set_4_sprite
exit$		REP	#00100000B
		MEM16
		STX	<sprite_count
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		mem8
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_4_sprite	STA	<wk_counter
		PHX				;>>
		REP	#00100001B
		MEM16
		TXA
		LSR	A
		LSR	A
		LSR	A
		LSR	A				;(CLC)
		CLC
		ADC	<screen_sub		;(CLC)
		TAX
		SEP	#00100000B
		MEM8
		LDA	<wk_size
		STA	<0,X
		PLX				;<<
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
loop$		LDA	!0,Y
		CLC
		ADC	<wk_position+0
		STA	<sprite_H,X
		LDA	!1,Y
		CLC
		ADC	<wk_position+1
		STA	<sprite_V,X
		REP	#00100001B
		MEM16
		LDA	!2,Y
		ORA	<special_attr
		STA	<sprite_C,X
		SEP	#00100000B
		MEM8
		INX
		INX
		INX
		INX	
		INY
		INY
		INY
		INY
		INY
		DEC	<wk_counter
		BNE	loop$
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		mem16
		idx16
;
;
;
;
;
;
;- - - - - - - - - - - - - - - - - - - - - -
	if	1
;*********************************************************************
;	}bv[hpn`lZbg[`
;*********************************************************************
		glb	mapsprite_set_B
		glb	mapsprite_set_A
;- - - - - - - - - - - - - - - - - - - -
map_zoom	dw	0040h,0000a0h
;- - - - - - - - - - - - - - - - - - - -
right_overA	lda	#0ff00h
		bra	over_setA
left_overA	lda	#0ffe0h
		bra	over_setA
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mapsprite_set_A
		phx
		ldx	<register
		lda	<_posV_A,x
		sta	<position_V
		lda	<_posH_A,x
		bpl	left_overA
		cmp	#0ff20h
		bcc	right_overA
		sbc	#00020h		;sec
over_setA	sta	<position_H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	]AhXZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	#0
		lda	<_sunder_timer,x
		beq	skip$
		iny
		iny
skip$		lda	<_poseQ,x		;LN^[̐Ίpx
		bpl	skip_1$
		and	#0111100000000000b
		eor	#0111100100000000b	; top bit 1
		xba
		lsr	a			;(SEC)
		bra	skip_2$
skip_1$		and	#7800h
		xba
		lsr	a			;(CLC)
skip_2$		ror	a			;(CLC)
		adc	!map_zoom,y		;( <- zoom patern )
		sta	<_ptn_A,x
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	Â]p^[n`lZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	<_trans_ptn_A,x		; read old patern
		jmp	common_set
;====================================================================
right_overB	lda	#0ff00h
		bra	over_setB
left_overB	lda	#0ffe0h
		bra	over_setB
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mapsprite_set_B	
		phx
		ldx	<register
		lda	<_posV_B,x
		sta	<position_V
		lda	<_posH_B,x
		bpl	left_overB
		cmp	#0ff20h
		bcc	right_overB
		sbc	#00020h		;sec
over_setB	sta	<position_H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	]AhXZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	#0
		lda	<_sunder_timer,x
		beq	skip$
		iny
		iny
skip$		lda	<_poseQ,x		;LN^[̐Ίpx
		bpl	skip_1$
		and	#0111100000000000b
		eor	#0111100100000000b	; top bit 1
		xba
		lsr	a			;(SEC)
		bra	skip_2$
skip_1$		and	#7800h
		xba
		lsr	a			;(CLC)
skip_2$		ror	a			;(CLC)
		adc	!map_zoom,y		;( <- zoom patern )
		sta	<_ptn_B,x
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	Â]p^[n`lZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	<_trans_ptn_B,x		; read old patern
common_set	tya
		lsr	a
		and	#04000h
		tsb	<attribute
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		stz	<temp		; flag !
		tya
		asl	a
		cmp	#00a0h*2
		bcc	skip$
		dec	<temp		; flag !
skip$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		tya
		ldy	#mapchar_2
		and	#001eh
		beq	map_oamset
		cmp	#001eh
		beq	map_oamset
		ldy	#mapchar_1
;-----------------------------------------------------------------------
;	}bvnai
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
map_oamset	lda	<_obake_timer,x
		beq	entry$
		lda	!frame_part		; S[XgȂ_
		beq	skip$
entry$		lda	<_flag,x
		and	#ON_goal
		beq	disp$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
skip$		ldx	<sprite_count		; I
		lda	#0f0f0h
		sta	<sprite_H+00,x
		sta	<sprite_H+04,x
		sta	<sprite_H+08,x
		sta	<sprite_H+12,x
		bra	next$
disp$
;- - - - - - - - - - - - - - - - - - - - - - - - - -
		SEP	#00100000B
		MEM8
		lda	<position_V
		xba
		lda	<position_H
		REP	#00100001B
		MEM16
		ldx	<sprite_count
		bit	<temp		; flag !
		bmi	sunder_map$
		bit	<attribute
		bvs	flip$
;- - - - - - - - - - - - - - - - - - - - -
nomal$
		sta	<sprite_H+0,x
		adc	#00010h
		sta	<sprite_H+4,x
		adc	#01000h
		sta	<sprite_H+12,x
		sec
		sbc	#00010h	
		sta	<sprite_H+8,x
		bra	character$
;- - - - - - - - - - - - - - - - - - - - - - - - -
flip$		sta	<sprite_H+4,x
		adc	#00010h			; clc
		sta	<sprite_H+0,x
		adc	#01000h			; clc
		sta	<sprite_H+8,x
		sec
		sbc	#00010h	
		sta	<sprite_H+12,x
;- - - - - - - - - - - - - - - - - - - - - - - - -
character$	
		lda	!0,y
		eor	<attribute
		sta	<sprite_C+0,x
		lda	!2,y
		eor	<attribute
		sta	<sprite_C+4,x
		lda	!4,y
		eor	<attribute
		sta	<sprite_C+8,x
		lda	!6,y
		eor	<attribute
		sta	<sprite_C+12,x
;- - - - - - - - - - - - - - - - - - - - - - - - -
next$		txa
		clc
		adc	#10h
		sta	<sprite_count
		plx
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
sunder_map$	adc	#0b08h			; `rI
		ldx	<sprite_count
		sta	<sprite_H+0,x
		lda	#0f0f0h
		sta	<sprite_H+4,x
		sta	<sprite_H+8,x
		sta	<sprite_H+12,x
		bra	character$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mapchar_1	dw	2000h,2002h,2020h,2022h
mapchar_2	dw	2000h,6000h,2020h,6020h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	endif
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		END
