;*********************************************************************
;	mario kart << goal ON screen >>
;					Programed by H.Yajima
;
;		ʕ\
;		fZNg
;		bv^C \
;
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/result.def
;----------------------------------------------------------------------
	glb	Erase_JUGEM,Erase_BGmeter
	glb	Set_raceOBJ
	ext	Init_katimake,Set_kati,Set_make
	ext	Init_gameover,Set_gameover,Set_over_char
	ext	Init_rankout,Set_rankout,Set_out_char1,Set_out_char2
	ext	Call_bank0
	ext	call_pause1,call_pause_VS,call_pause_GP
	ext	Call_BGM,Call_fanfare
	ext	Disp_player
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	ext	Init_goalslot
	ext	sound_select
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	Init_goalin,DMA_goalin
	GLB	Disp_result,DMA_result
	EXT	DMA_trans
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	RACE_RETRY,NEXT_RACE
	EXT	Retry_race,Next_race,Result_race
	EXT	Start_title
	ext	BGM_clear
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	EXT	Set_over_char
	EXT	Erase_objmeter
	EXT	Init_gameover,Set_gameover
	EXT	Stop_camera,Winner_camera,TV_camera	; goal in
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	EXT	clear_sub_Z
	EXT	param_screenA,param_screenB
	EXT	oamset_A,oamset_B
	EXT	Stop_trans
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	TMgoal_A,TMgoal_B
	GLB	TMwipe_A,TMwipe_B
	GLB	VSwin_A,VSwin_B,VSlost_A,VSlost_B
	GLB	goalset_A,goalset_B
	GLB	GPwipe_A,GPwipe_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	EXT	SPRITE_SET
	GLB	Stop_kartsound
	EXT	Allclear_item
;----------------------------------------------------------------------
		COMN
;----------------------------------------------------------------------
work		DS	2
counter		DS	2
;----------------------------------------------------------------------
sec_100		DS	1
sec_1		DS	1
min		DS	2
pos_offset	DS	2
buffer_offset	DS	2
;----------------------------------------------------------------------
		ORG	moji_value
moji_r0		DS	280H
moji_r1		DS	280H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
moji_register	EQU	00H	; moji DATA address
moji_bank	EQU	02H	; moji DATA bank
moji_vram	EQU	04H	; moji VRAM address
moji_address	EQU	06H	; moji BUFFER RAM  address
moji_pointer	EQU	08H	; moji count pointer
moji_spcount	EQU	0AH	; moji sprite count
moji_spchar	EQU	0CH	; moji character 
moji_position	EQU	0EH	; moji position
moji_wait	EQU	10H	; moji trans wait
moji_trans	EQU	12H	; moji trans flag
moji_flag	EQU	14H	; moji initial flag
moji_buffer	EQU	16H	;(1E0H)
moji_result	EQU	200H	;(80H)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
moji_character	equ	7fa000h
;----------------------------------------------------------------------
;goal_flag
_raceend	EQU	8000H
_lapstart	EQU	4000H
_raceclear	EQU	2000H	
_racefin	EQU	1000H	
_2pend		EQU	0400H
;----------------------------------------------------------------------
		EXTEND
objdata	SECT	REL
		mem16
		idx16
;#####################################################################
;		p[^
;#####################################################################
start_sprite	EQU	080H
next_sprite	EQU	100H
entry_sprite	EQU	start_sprite+200H
Ascreen_oam	EQU	000H
Bscreen_oam	EQU	220H
;- - - - - - - - - - - - - - - - - - - - - 
Ascreen_OAM	EQU	200H
Bscreen_OAM	EQU	Ascreen_OAM+220H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;#####################################################################
;		S[C
;#####################################################################
;*********************************************************************
;GPG		foS[C
;*********************************************************************
goalset_B
goalset_A
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldx	<screen_register
		lda	!goalstate,x
		asl	a
		ldy	!screen_player
		ldx	<rank_number,y	; 0,2,4,6,8,a,c,e ( W j
		jmp	(!rank_jump,x)	; ʂɂ镪
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rank_jump	dw	winer_demo	; rank 1
		dw	safe_demo	; rank 2
		dw	safe_demo	; rank 3
		dw	safe_demo	; rank 4
		dw	lost_demo	; rank 5
		dw	lost_demo	; rank 6
		dw	lost_demo	; rank 7
		dw	lost_demo	; rank 8
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
winer_demo	tax
		jmp	(!goal_win,x)
safe_demo	tax
		jmp	(!goal_safe,x)
lost_demo	tax
		jmp	(!goal_lost,x)
;--------------------------------------------------------------------
GPwipe_A
GPwipe_B	ldx	<screen_register
		JMP	Set_raceOBJ
;*********************************************************************
;TMG		^CA^bNS[C
;*********************************************************************
TMgoal_B
TMgoal_A
		LDX	<screen_register
		LDA	!goalstate,X
		ASL	A
		TAX
		BIT	!replay_flag
		BVS	replay$
		LDA	!best_flag
		BNE	skip$
		JMP	(!goal_time_nomal,X)
skip$		JMP	(!goal_time_win,X)
replay$		JMP	(!goal_time_replay,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
TMwipe_A
TMwipe_B	ldx	<screen_register
		lda	!goalstate,x
		asl	A
		tax
		jmp	(!wipe_process,x)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;*********************************************************************
;VSG		ur[hS[C
;*********************************************************************
VSwin_B
VSwin_A
	;;;;	jsr	Computer_kart
		jsr	Empty_kart
		jsr	Set_katiOBJ
;- - - - - - - - - - - - - - - - - - - - - - - - 
		ldx	<screen_register
		lda	!goalstate,x
		asl	a
		tax
		jmp	(!goal_VSwin,x)
;---------------------------------------------------------------------
VSlost_B
VSlost_A
		jsr	Erase_JUGEM

		ldx	!screen_player
		lda	<spin_counter,x
		cmp	#02c1h
		bcs	skip$
		jsr	Empty_kart
skip$ 
;- - - - - - - - - - - - - - - - - - - - - - - - -
		ldx	<screen_register
		lda	!goalstate,x
		asl	a
		tax
		jmp	(!goal_VSlost,x)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;*********************************************************************
;BTG		og	Q[NA
;*********************************************************************
		glb	BTwin_A,BTwin_B
		glb	BTlost_A,BTlost_B
;- - - - - - - - - - - - - - - - - - - - - -
BTwin_A
BTwin_B
		jsr	Empty_kart
		jsr	Set_katiOBJ
		ldx	<screen_register
		lda	!goalstate,x
		asl	a
		tax
		jmp	(!battle_win,x)
;- - - - - - - - - - - - - - - - - - - - - -
BTlost_A
BTlost_B
		ldx	!screen_player
		lda	<spin_counter,x
		cmp	#02c1h
		bcs	skip$
		jsr	Empty_kart
skip$		ldx	<screen_register
		lda	!goalstate,x
		asl	a
		tax
		jmp	(!battle_lost,x)
;---------------------------------------------------------------------
;
;
;
;
;#####################################################################
;		S[Cerdp
;#####################################################################
;
; 	 ****** VS/BATTLE ******
;*********************************************************************
;BT-MODE	u|[Yf		̃f
;VS-MODE	u|[Yf	
;*********************************************************************
goal_VSwin	DW	win_1VS,win_2VS,win_VSloop
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
battle_win	DW	win_1BT,win_2BT,win_BTloop
;---------------------------------------------------------------------
;		uS[C̃CjV	<< 1 frame >>
;---------------------------------------------------------------------
win_1BT		jsr	Set_kartBGM	; ̃}Ce[}
win_1VS	
		jsl	>Allclear_item	; ACeNA
		jsr	Big_window
		jsr	Stop_kartsound
		jsr	Set_raceOBJ
		jsr	Set_goalflag	; S[CZbg
		LDA	#60*3
		jmp	next_goal
;---------------------------------------------------------------------
;		J]u|[Y(^C}[ŏI)	<< TIMER >>
;---------------------------------------------------------------------
win_2VS
win_2BT	
;
		ldx	!screen_player
		lda	#4000h
		and	<kart_status,x
		sta	<kart_status,x
;
		JSR	Set_raceOBJ
		JSL	>Winner_camera	
		lda	#60
		jmp	wait_goal
;---------------------------------------------------------------------
;		[XĨL[҂		<< LOOP >>
;---------------------------------------------------------------------
win_VSloop	jsr	Erase_JUGEM
win_BTloop	jmp	Set_raceOBJ

;*********************************************************************
;BT-MODE	u|[Yf		s҂̃f
;VS-MODE	u|[Yf
;*********************************************************************
battle_lost	
goal_VSlost	dw	VSlost_1,VSlost_2,VSlost_3,VSlost_4
		dw	pause_mes1,pause_mes2,pause_exitVS
;---------------------------------------------------------------------
;		ur܂CjV	<< 1 frame >>
;---------------------------------------------------------------------
VSlost_1	JSR	Disable_pause	; |[Y֎~
;- - - - - - - - - - - - - - - - - - - - -
		lda	<game_status	; ++ ogH
		cmp	#06h		; ++	
		beq	skip$		; ++
		jsr	Stop_kartsound	; ++
skip$					; ++
;- - - - - - - - - - - - - - - - - - - - -
		JSR	Smorke_window
		JSR	Lost_pose
		JSR	Set_raceOBJ
		JSR	Set_lostcount
		LDA	#8
		JMP	next_goal
;---------------------------------------------------------------------
;		܂LN^[̓]EGCg	<< 8 frame >>
;---------------------------------------------------------------------
VSlost_2	ldx	<screen_register
		lda	!timestate,x
		jsl	>Init_katimake
		jsr	Set_raceOBJ
		lda	#60*2		;@ZNg܂ł̃^C}
		jmp	wait_goal
;---------------------------------------------------------------------
;		܂\		<< TIMER >>
;---------------------------------------------------------------------
VSlost_3	jsl	>Set_make
		jsr	Set_raceOBJ
		jmp	wait_goal
;---------------------------------------------------------------------
;		L[EFCg		<< WAIT LOOP >>
;---------------------------------------------------------------------
VSlost_4	jsl	>Set_make
		jsr	Stop_kartsound
		jsr	Set_raceOBJ
		jsr	Check_yeskey	; L[
		beq	exit$		; ̃Xe[g
		jsr	>sound_select
		jmp	next_goal
exit$		rts
;
;============== Q[ĨZNg ===============================
;---------------------------------------------------------------------
;		Q[ĨZNgʗpL]	<< 1 frame >>
;---------------------------------------------------------------------
pause_mes1	

		LDA	#0
		BIT	!static_work
		BPL	skip$
		LDA	#1
skip$		sta	!pause_cursor

		jsr	Erase_JUGEM
		jsr	Erase_raceOBJ
		jsr	call_pause1
		jmp	next_goal
;---------------------------------------------------------------------
;		Q[ĨZNg	<< WAIT LOOP >>
;---------------------------------------------------------------------
pause_mes2	jsr	Erase_raceOBJ
		jsr	call_pause_VS
		bcc	exit$
		jmp	next_goal
exit$		rts
;---------------------------------------------------------------------
;		̃Xe[g		<< EXIT >>
;---------------------------------------------------------------------
		ext	Display_VSnext
pause_exitTM
pause_exitVS	
		jsr	Erase_raceOBJ
		jmp	Display_VSnext
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

;	****** TIME ATTACK ******
;*********************************************************************
;		vC[ĥƂ
;*********************************************************************
goal_time_replay
		dw	replay_1
		dw	replay_2
		dw	pause_mes1,pause_mes2,pause_exitTM
;---------------------------------------------------------------------
;		 S[C̃CjV	<< 1 frame >>
;---------------------------------------------------------------------
replay_1	lda	#0AH
		jsl	>Call_fanfare
		lda	#0
		sta	>reclap_switch		; ^ĐI
		jsr	Stop_kartsound
		jsr	Set_raceOBJ
		JSR	Stop_camera
		lda	#60*4			; S[f\
		jmp	next_goal
;---------------------------------------------------------------------
;		J~ WAIT			<< TIMER >>
;---------------------------------------------------------------------
replay_2	JSR	Set_raceOBJ
		jmp	wait_goal
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -



;*********************************************************************
;		xXgbvłƂ(^CA^bNj
;*********************************************************************
goal_time_win
		DW	wait_mode
		DW	TMwin_1,win_2,TMwin_3,TMwin_4,TMwin_5
		DW	Best_disp,TM_check,TM_wait
		DW	pause_mes1,pause_mes2,pause_exitTM
;---------------------------------------------------------------------
;		 S[C̃CjV	<< 1 frame >>
;---------------------------------------------------------------------
TMwin_1		
		lda	#9
		jsl	>Call_fanfare
		jsr	Stop_kartsound
		jsr	Set_raceOBJ
		lda	#60*3			; short run
		jmp	next_goal
;---------------------------------------------------------------------
;		J]u|[Y(^C}[ŏI)	<< TIMER >>
;---------------------------------------------------------------------
;TMwin_2	
;---------------------------------------------------------------------
;		J~			<< TIMER >>
;---------------------------------------------------------------------
TMwin_3		JSR	Stop_camera	
		JSR	Set_raceOBJ
		LDA	#60*2		; bv^C\
		jmp	wait_goal
;---------------------------------------------------------------------
;		bv^C̃L]\	<< TIMER >>
;		( bv\ )
;---------------------------------------------------------------------
TMwin_4		jsr	set_color
		jmp	win_4
;---------------------------------------------------------------------
;		\̏IiIgKj	<< 1 frame >>
;---------------------------------------------------------------------
TMwin_5		jsr	set_color
		jmp	win_5
;---------------------------------------------------------------------
;		xXgbv̕\		<< 1 frame >>
;---------------------------------------------------------------------
Best_disp	jsr	set_color
		jsr	Disp_goalin
		inc	!goalmail	; [ (}bvJ[g
		jmp	next_goal	; j
;---------------------------------------------------------------------
;		^CA^bNĨL[҂	<< WAIT LOOP >>
;---------------------------------------------------------------------
TM_check	jsr	Disp_goalin
		jsr	Check_yeskey
		beq	exit$
		jsl	>sound_select
		lda	#10
		jmp	next_goal
exit$		rts
;---------------------------------------------------------------------
;		{^ << WAIT >>
;---------------------------------------------------------------------
TM_wait		jsr	Disp_goalin
		jmp	wait_goal
;---------------------------------------------------------------------
;		ȍ~ur̃|[YZNgʂƓ
;---------------------------------------------------------------------
;*********************************************************************
;		xXgbv\	
;*********************************************************************
		ext	Init_object
		ext	REC_test
;- - - - - - - - - - - - - - - - - - - - - - - - - 
wipe_process	dw	wipe_1,wipe_2,wipe_3
;---------------------------------------------------------------------
;		[܂ŃEFCg
;---------------------------------------------------------------------
wipe_1		lda	#09c00h
		sta	!best_Voffset

		lda	!goalmail
		bne	next$
		jmp	Set_raceOBJ
		ldx	#Stop_trans		;]Xgbv
		jsl	>Call_bank0
next$		jmp	next_goal
;---------------------------------------------------------------------
;		LN^[]
;---------------------------------------------------------------------
wipe_2		jsr	set_color
		lda	!goalmail
		dec	a
		cmp	#3
		bcs	exit$
		asl	a
		tax
		inc	!goalmail
		jmp	Set_best_char
exit$		jmp	next_goal
;---------------------------------------------------------------------
;		\[v
;---------------------------------------------------------------------
wipe_3		jsr	set_color
		ldx	#Init_object
		jsl	>Call_bank0
		lda	<sprite_count
		sec
		sbc	#objstart
		sta	<sprite_count
  
		lda	!backup_timer		; Z[u`FbN
		bne	exit$

entry$		lda	!best_Voffset
		cmp	#0f000h
		beq	skip$
		clc
		adc	#0300h
skip$		sta	!best_Voffset

		jsr	REC_test
		jsl	>Reform_sprite

exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -





;*********************************************************************
;		ʏ̃bv(^CA^bN)
;*********************************************************************
goal_time_nomal	
		DW	wait_mode
		DW	TMsafe_1,TMsafe_2,safe_3,TMsafe_4
		DW	Best_disp,TM_check,TM_wait
		DW	pause_mes1,pause_mes2,pause_exitTM
;---------------------------------------------------------------------
wait_mode

		lda	>keycode_camera
		bne	entry$
		stz	!goal_kabe


entry$		lda	!record_mode		; ^惂[h ON ?
		beq	skip$
		lda	#00010B			; ^rsno
		tsb	!replay_flag
		

skip$		jsr	Disable_mypause
		jsr	Disp_goalin		; initial
		jsr	Set_raceOBJ
		jmp	next_goal
;---------------------------------------------------------------------
;		J~			<< 1 frame >>
;---------------------------------------------------------------------
TMsafe_1	lda	#0AH
		jsl	>Call_fanfare
		jsr	Stop_kartsound	
		JSR	Set_raceOBJ
		JSR	Stop_camera
		lda	#60*4		; S[f\
		jmp	next_goal
;---------------------------------------------------------------------
;		S[f			<< TIMER >>
;---------------------------------------------------------------------
TMsafe_2	JSR	Set_raceOBJ
		LDA	#60*2		; bv^C̕\
		JMP	wait_goal
;---------------------------------------------------------------------
;		bv^C]\
;---------------------------------------------------------------------
;---------------------------------------------------------------------
;		bv^CIgK
;---------------------------------------------------------------------
TMsafe_4	jsr	set_color
		jmp	safe_4

;*********************************************************************
;		^CA^bNėp[`
;*********************************************************************
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	J[
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


set_color	lda	<frame_counter-1
		and	#0F00H
		clc
		adc	#70FFH
		ldx	#0a0h
		jsr	set_palet		; palet 5  02
		ldx	#0c0h			
		lda	#7ff0h
		jsr	set_palet		; palet 6  04 

		lda	#0ffffh
		sta	!color_trans_flag

		ldx	#0e0h
		lda	#027fh
set_palet	
		sta	>color_buffer+100h+2,x	; palet 7
		sta	>color_buffer+100h+4,x
		lda	#0
		sta	>color_buffer+100h+6,x

		rts

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	LN^[̓]
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
best_rom	dw	(MOJI_buffer&0ffffh)+0
		dw	(MOJI_buffer&0ffffh)+800h
		dw	(MOJI_buffer&0ffffh)+1000h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
best_vram_A	dw	0000h,0400h,0800h
best_vram_B	dw	5000h,6000h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_best_char	lda	#800H
		sta	!trans_count
		lda	!best_rom,x
		sta	!trans_address
		lda	#MOJI_buffer/65536
		sta	!trans_bank
		ldy	<screen_register
		lda	!best_vram_B,y	
		clc
		adc	!best_vram_A,x
		sta	!trans_vram
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -




;	******* GRAND PRIX ******
;*********************************************************************
;		PknrsS[(Tʈȉj
;*********************************************************************
goal_lost	DW	GPlost_1,lost_2,lost_3,lost_4
		DW	lost_overcheck
		DW	over_init,over_main,over_exit	; <<5>>
		DW	over_end
		DW	rankout_1,rankout_2,rankout_3	; <<9>>
		DW	rankout_4,rankout_5,rankout_6
		DW	rankout_7,rankout_8
		DW	rankout_step			; <<17>>
		DW	over_sp_1,over_sp_2		; <<18>>
		DW	over_sp_3,over_sp_4	
		DW	over_sp_step			; <<22>>
code_rankout	equ	9
code_step	equ	17
code_over_sp	equ	18
code_over_step	equ	22
;---------------------------------------------------------------------
;	PknrsS[̃CjV 		<< 1 frame >>
;---------------------------------------------------------------------
GPlost_1	JSR	GPclear_item
lost_1		
		JSR	Disable_mypause	; |[Y֎~
		JSR	Disable_yopause	;  ʂ|[Y֎~


		jsr	Stop_kartsound	; GWXgbv
		JSR	Rankout_window	; rbOEChE
		JSR	Fin_goalflag	; S[C
		JSR	Set_raceOBJ	; ʏ̂n`lZbg
	;;;	JSR	Disp_goalin	;  


skip$		LDA	#60*1+20
		JMP	next_goal
;---------------------------------------------------------------------
;		FZԑ҂			<< NN frame >>
;---------------------------------------------------------------------
lost_2		JSR	Set_raceOBJ
		JSR	Empty_kart	; J[g
		JMP	wait_goal
;---------------------------------------------------------------------
;		PknrsCjV	<< 1 frame >>
;---------------------------------------------------------------------
lost_3
		lda	!dark_map	; ΂/C{[ ̎
		bne	skip_X$

		ldx	<screen_register
		lda	#1084h
		sta	!nuki_color,x
		txa			; ΑFωĂ邩H
		eor	#2
		tax
		lda	!nuki_color,x
		cmp	#1084h
		beq	skip_X$
		lda	#0421h
		sta	!nuki_color,x

	;;	sta	>color_buffer
	;;	dec	!color_trans_flag

;- - - - - - - - - - - - - - - - - - - - - - -
skip_X$		JSR	Erase_raceOBJ	; ʏ̃J[gZbgI
		lda	!trans_count
		beq	skip$
		rts
skip$		JSL	>Init_lostdemo

		JSR	Down_player	; vC[P down
		LDA	#60*3
		JMP	next_goal
;---------------------------------------------------------------------
;		Pknrsf		<< NN frame >>
;---------------------------------------------------------------------
lost_4		JSR	Stop_camera		; J~
		JSR	Erase_raceOBJ
		JSL	>Main_lostdemo
		jsr	Quick_demo
		beq	exit$
		lda	#60*2
		jmp	next_goal
exit$		LDA	#60*2
		JMP	wait_goal
;---------------------------------------------------------------------
;		Q[I[o[`FbN		<< 1 frame >>
;---------------------------------------------------------------------
lost_overcheck

;- - - - - - - - - - - - - - - - - - - - - -
		jsr	Check_1up
;- - - - - - - - - - - - - - - - - - - - - -

		jsr	pause_2pcheck

	;;	jsr	Erase_BGmeter		; af[^
		jsr	Erase_JUGEM		; WQ
		jsr	Erase_raceOBJ
		jsr	Check_gameover
		bpl	exit$
		jmp	next_goal		; ----->GAME OVER
exit$		lda	#code_rankout		; ----->RANK OUT
		jmp	set_goal


;============== GP MODE GAMEOVER =====================================
;---------------------------------------------------------------------
;		Q[I[o[\CjV	<< 1 frame >>
;---------------------------------------------------------------------
over_init	jsr	Erase_raceOBJ

	;;	ldx	<screen_register
	;;	jsl	>Init_goalslot

		jsl	>Init_gameover		; I[o[Zbg
		ldx	<screen_register
		lda	!trans_count		; dȂEGCg
		beq	skip$
		rts
skip$		jsl	>Set_over_char		; I[o[L]
		lda	#60*5		
		jmp	next_goal
;---------------------------------------------------------------------
;		Q[I[o[\Zbg	<< TIMER >>
;---------------------------------------------------------------------
		ext	Player_slot
over_main	jsr	Erase_raceOBJ

	;;	ldx	<screen_register
	;;	ldy	<player_index,x
	;;	sty	<register
	;;	jsl	>Player_slot	

		jsl	>Set_gameover		; I[o[\
		jsl	>Reform_sprite
;
		jsr	wait_goal
		bcc	exit$
		jsr	Set_goalflag		; << 1 frame >>
exit$		rts

;---------------------------------------------------------------------
;		Q[I[o[\I		; << WAIT >>
;---------------------------------------------------------------------
		ext	Trigger_sound_1,Trigger_sound_2
over_exit
;- - - - - - - - - - - - - - - - - - - - - - - -
		ldx	<screen_register
		lda	!slot_flag,x
		and	#0fh
		cmp	#0ah
		bne	entry$
;- - - - - - 
		lda	#2
		sta	!player_count,x
		stz	!gameover_1lost,x
;- - - - - - 
		lda	#20h
		txy
		bne	s100$
		jsl	>Trigger_sound_1
		bra	s110$
s100$		jsl	>Trigger_sound_2
s110$
;- - - - - - 
		lda	#code_over_sp
		jsr	set_goal
		jmp	over_sp_1
;- - - - - - - - - - - - - - - - - - - - - - - -
entry$		jsr	Erase_raceOBJ
		jsl	>Set_gameover
		jsl	>Reform_sprite
		lda	!goal_flag		; S[܂ŃEGCg
		bpl	end$
;- - - - - - - - - - - - - - - - - - - - - - - -
		lda	<SEQ_register
		bne	skip$
;- - - - - - - - - - - - - - - - - - - - - - - -
		lda	!gameover_1lost+0	; ƂQ[I[o[ H
		and	!gameover_1lost+2
		bpl	end$
;- - - - - - - - - - - - - - - - - - - - - - - -
		jsr	Yeskey_check
		bne	over$
skip$		jsr	Check_yeskey		; GAMEOVER \łƂ߂
		beq	over_end
over$		jsr	RACE_RETRY		; << 1 frame >>
		jmp	next_goal
end$		rts
;- - - - - - - - - - - - - - - - - - - - - - - -
over_end	jsl	>Set_gameover
		jsl	>Reform_sprite
		rts

;============== GP MODE RANKOUT =====================================
;---------------------------------------------------------------------
;		NAEgpLN^]	<< 2 frame + X >>
;---------------------------------------------------------------------
test_data	dw 	0,6
rankout_1
		jsr	Erase_raceOBJ
		jsr	erase_set
						; J[g]Xgbv



		lda	!trans_count		; ]\񂳂Ă
		bne	wait$
		jsr	Set_out_char1
		jmp	next_goal
wait$		rts
;- - - - - - - - - - - - - - - -  - - - - -  
rankout_2
		jsr	Erase_raceOBJ
		jsr	erase_set
		lda	!trans_count		; ]\񂳂Ă
		bne	wait$
		jsr	Set_out_char2		; AEgL]
		jsr	Init_rankout		; AEgZbg
		lda	#0e0h			; NAEgf
		jmp	next_goal
wait$		rts
;---------------------------------------------------------------------
;		NAEgnai\		; << TIMER >>
;---------------------------------------------------------------------
rankout_3
		jsr	Erase_raceOBJ
		jsr	erase_set
		jsr	Set_rankout
		jsl	>Reform_sprite
		jmp	wait_goal
;---------------------------------------------------------------------
;		Q̎̃S[EFCg	; << 1 frame >>
;---------------------------------------------------------------------
rankout_4
		jsr	Set_goalflag	; S[Cl𑝂₷
		jsr	Erase_raceOBJ
		jsr	erase_set
		jsr	Set_rankout
		jsl	>Reform_sprite
		jmp	next_goal
exit$		rts
;---------------------------------------------------------------------
;		ILN^]		; << 1 frame / wait >>
;---------------------------------------------------------------------
rankout_5
		lda	!goal_flag	;
		bpl	rankout_step	; S[܂ŃEGCg
		bit	#2000h		; EBi[Ȃ exit
		beq	skip0$		; (IJ[\͏oȂ)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ldx	<screen_register	; EBi[Ƃ
		dec	!player_count,x		; vC[
		lda	#code_step		; 1 DOWN
		jsr	set_goal
		bra	rankout_step
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
					; ǂɃZNgJ[\
skip0$		and	#_2pend		;  H
		beq	skip$
		lda	#2
skip$		cmp	<screen_register
		beq	entry$		; ŌɃNAɂ
		tax			; Q[I[oȂ炾
		lda	!gameover_1lost,x
		bpl	rankout_stepX
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
entry$		stz	!pause_cursor	; IJ[\̃Zbg
		jsr	call_pause1
		jsr	Set_rankout
		jsl	>Reform_sprite
		jmp	next_goal
;---------------------------------------------------------------------
;(special)	ƂNAEgꍇI	<< wait >>
;---------------------------------------------------------------------
		ext	Disp_player
rankout_stepX	ldx	<screen_register
		jsr	Disp_player
		bra	common_step	
;---------------------------------------------------------------------
;(special)	EBi[鎞̃NAEgEGCg	<< wait >>
;---------------------------------------------------------------------
rankout_step	jsr	Erase_raceOBJ
common_step	jsr	erase_set
		jsr	Set_rankout
		jsl	>Reform_sprite
		rts
;---------------------------------------------------------------------
;		ILN^\		; << 1 frame >>
;---------------------------------------------------------------------
rankout_6	jsr	call_pause_GP
		bcc	exit$		; sec = L[ꂽI
		lda	#30
		jsr	next_goal
exit$		jsr	Set_rankout
		jsl	>Reform_sprite
		rts
;---------------------------------------------------------------------
;		ĨEGCg		; << WAIT >>
;---------------------------------------------------------------------
		ext	Display_GPnext
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
rankout_7
		jsr	Display_GPnext
		jsr	Set_rankout
		jsl	>Reform_sprite
		jsr	wait_goal
		bcc	wait$		
		lda	!pause_cursor
		asl	a
		tax
		jsr	(!retry_select,x)
wait$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
retry_select	dw	RACE_RETRY,start_title
;---------------------------------------------------------------------
rankout_8	jsr	Display_GPnext
		jsr	Set_rankout
		jsl	>Reform_sprite
		rts
;- - - - - - - - - - - - - - - - - - - - - -

;---------------------------------------------------------------------
;		Q[I[o[畜	; << 1 frame / wait >>
;---------------------------------------------------------------------
over_sp_1
		ldx	<screen_register

		lda	!goal_flag	;
		bpl	over_sp_step	; S[܂ŃEGCg
		bit	#2000h		; EBi[Ȃ exit
		beq	skip0$		; (IJ[\͏oȂ)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		ldx	<screen_register ; EBi[Ƃ
		lda	#code_over_step
		jsr	set_goal
		bra	over_sp_step
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
					; ǂɃZNgJ[\
skip0$		and	#_2pend		;  H
		beq	skip$
		lda	#2
skip$		cmp	<screen_register
		beq	entry$		; ŌɃNAɂ
		tax			; Q[I[oȂ炾
		lda	!gameover_1lost,x
		bpl	over_sp_stepX
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
entry$		stz	!pause_cursor	; IJ[\̃Zbg
		jsr	call_pause1
		jsl	>Reform_sprite
		jmp	next_goal
;---------------------------------------------------------------------
;(special)	ƂNAEgꍇI	<< wait >>
;---------------------------------------------------------------------
		ext	Disp_player
over_sp_stepX	ldx	<screen_register
		jsr	Disp_player
		jsl	>Reform_sprite
		jmp	erase_set
;---------------------------------------------------------------------
;(special)	EBi[鎞̃NAEgEGCg	<< wait >>
;---------------------------------------------------------------------
over_sp_step	jsr	Erase_raceOBJ
		jmp	erase_set
;---------------------------------------------------------------------
;		ILN^\		; << 1 frame >>
;---------------------------------------------------------------------
over_sp_2	jsr	call_pause_GP
		bcc	exit$		; sec = L[ꂽI
		lda	#30
		jmp	next_goal
exit$		rts
;---------------------------------------------------------------------
;		ĨEGCg		; << WAIT >>
;---------------------------------------------------------------------
		ext	Display_GPnext
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
over_sp_3	jsr	Display_GPnext
		jsl	>Reform_sprite
		jsr	wait_goal
		bcc	wait$		
		lda	!pause_cursor
		asl	a
		tax
		jsr	(!retry_select,x)
wait$		rts
;---------------------------------------------------------------------
over_sp_4	jsr	Display_GPnext
		jsl	>Reform_sprite
		rts
;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;---------------------------------------------------------------------
erase_set	ldy	<screen_register
		lda	#16EH
		ldx	!test_data,y
		sta	!_ptn_A+player_r0,x
		sta	!_ptn_A+player_r1,x
		sta	!_ptn_A+player_r2,x
		sta	!_ptn_A+player_r3,x
		sta	!_ptn_A+player_r4,x
		sta	!_ptn_A+player_r5,x
		sta	!_ptn_A+player_r6,x
		sta	!_ptn_A+player_r7,x
		rts
;*********************************************************************
;GP-MODE	u|[Yf(Pʁj
;*********************************************************************
goal_win	DW	GPwin_1,win_2,win_3,win_4,win_5,win_6
		DW	win_exit
;---------------------------------------------------------------------
;		uS[C̃CjV	<< 1 frame >>
;---------------------------------------------------------------------
GPwin_1		jsr	GPclear_item	; ACȅ
win_1		jsr	Disable_mypause	; |[Y֎~
		jsr	Stop_kartsound	; TEh֎~
		jsr	Big_window	; 傫EBhE
		jsr	Disp_goalin	; bv^C\CjV
		jsr	Set_raceOBJ
		jsr	Win_goalflag
skip$		lda	#60*7
		jmp	next_goal
;---------------------------------------------------------------------
;		J]u|[Y(^C}[ŏI)	<< TIMER >>
;---------------------------------------------------------------------
win_2		JSR	Set_raceOBJ
		JSL	>Winner_camera	; ]܂
		bcc	skip$		; IĂȂ skip
		jsr	Quick_demo	
		beq	skip$
		lda	#60
		jmp	next_goal
skip$		lda	#60
		jmp	wait_goal
;---------------------------------------------------------------------
;		J~			<< TIMER >>
;---------------------------------------------------------------------
win_3		JSR	Stop_camera
		JSR	Set_raceOBJ	; J~I
		LDA	#60*4		; bv^C\
		jmp	wait_goal
;---------------------------------------------------------------------
;		bv^C̃L]\	<< TIMER >>
;		( bv\ )
;---------------------------------------------------------------------
win_4		lda	#8000h
		sta	!goalin_winner
		jmp	Display_laptime	
;---------------------------------------------------------------------
;	win_5,win_6,win_exi  safe demo ɏ
;---------------------------------------------------------------------
;
;
;
;
;
;*********************************************************************
;		m[}S[
;*********************************************************************
goal_safe	DW	GPsafe_1,safe_2,safe_3,safe_4,safe_5
		DW	safe_exit
;---------------------------------------------------------------------
;	J~ / S[C̃CjV	<< 1 frame >>
;---------------------------------------------------------------------
GPsafe_1	JSR	GPclear_item
safe_1		JSR	Disable_mypause
		jsr	Stop_kartsound
		JSR	Win_goalflag
		JSR	Big_window
		JSR	Stop_camera
		JSR	Set_raceOBJ
		JSR	Disp_goalin		; initial
;- - - - - - - - - - - - - - - - - - - - - - - - - - 
;^C}[̒`FbN
		LDA	<screen_register
		EOR	#02H
		TAY
		LDA	#60*4			; short run
		LDX	<player_index,Y
		BMI	next_goal
		LDY	<rank_number,X		; 1ʁH
		BNE	next_goal
		BIT	!goal_flag
		BVS	next_goal
		LDA	#60*8			; long run
		BRA	next_goal
;---------------------------------------------------------------------
;		J~EGCg		<< TIMER >>
;---------------------------------------------------------------------
safe_2		JSR	Set_raceOBJ
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		jsr	Quick_demo
		bne	quick$		
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	!goal_flag		; lS[C
		AND	#0FH			; Ă wait
		BNE	exit$
		LDA	!goalin_winner		; 1Pbv\er
		BEQ	exit$			;  2P \
quick$		LDA	#60*4
		BRA	next_goal
;- - - - - - - - - - - - - - - - - - - - - - - - - 
exit$		LDA	#60*4			; bv^C̕\
		BRA	wait_goal
;---------------------------------------------------------------------
;		V[PX؂ւ
;---------------------------------------------------------------------
set_goal	ldx	<screen_register
		sta	!goalstate,X
		rts
;- - - - - - - - - - - - - - - - - - - - - - 
wait_goal	LDX	<screen_register
		DEC	!timestate,X
		BEQ	next_goal
		CLC
		RTS
next_goal	LDX	<screen_register
		STA	!timestate,X
		INC	!goalstate,X		;  state  jump
		SEC
		RTS
;---------------------------------------------------------------------
;		bv^C̃L]\	; << TIMER >>
;		( bv\ )
;---------------------------------------------------------------------
safe_3
Display_laptime	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		jsr	Lap_goalflag	; bv\Jn^C~OI

		JSR	Erase_raceOBJ
		JSR	Erase_BGmeter
		JSR	Erase_JUGEM
		JSR	Disp_goalin	; bv^C\ 
		JSR	Stop_camera
		ldx	#Stop_trans	; ]Xgbv
		jsl	>Call_bank0

		ldx	<screen_register	; |[Y֎~`FbN
		lda	!timestate,x
		cmp	#0a0h
		bcc	skip$
		jsr	Disable_yopause		;  ʂ|[Y֎~
		bra	wait_goal
skip$		jsr	pause_2pcheck		; |[Y֎~
		bra	wait_goal
;---------------------------------------------------------------------
;		Ug\̏CjV	<< 1 frame >>
;---------------------------------------------------------------------
safe_4
win_5
;- 
		jsr	pause_2pcheck		
		JSR	Set_goalflag	; bv\
		JSR	Erase_raceOBJ
		JSR	Disp_goalin	; bv^C\
		JMP	next_goal

;---------------------------------------------------------------------
;		Ug\̏		<< TIMER / KEY >>
;---------------------------------------------------------------------
; ( GP p )
safe_5
win_6
		JSR	Erase_raceOBJ	;
		JSR	Disp_goalin	; bv^C\
		lda	!goal_flag	; S[ĂȂ΃EGCg
		bpl	exit$		; 

skip$		JSR	NEXT_RACE
		JMP	next_goal
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
exit$		RTS
;---------------------------------------------------------------------
;		UgIÃ[X
;---------------------------------------------------------------------
safe_exit
win_exit	JSR	Disp_goalin	; bv^C\
		RTS
;---------------------------------------------------------------------

;
;#####################################################################
;COM	ėp[`
;#####################################################################
oamset_select	dw	oamset_A,oamset_B
goal_clear	dw	clear_screen_A,clear_screen_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ext	sound_1up
Check_1up
;- - - - - - - - - - - - - - - - - - - - - -
		ldx	!screen_player
		lda	<_1up_status,x	; [hNA
		beq	exit$
		stz	<_1up_status,x
		ldx	<screen_register
		inc	!player_count,x
		lda	<screen_register
		jsl	>sound_1up
exit$		rts
;
;- - - - - - - - - - - - - - - - - - - - - -
GPclear_item	lda	<SEQ_register
		beq	exit$
		jsl	>Allclear_item
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_kartBGM					; J[ge[}afl
		ldx	!screen_player		; nmɂ
		lda	<_status,x
		lsr	a
		adc	#0ch
		jsl	>Call_BGM
;;
		ldx	#player_r0		; e timer clear
		jsr	clear_timer
		ldx	#player_r1
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
clear_timer	stz	<_muteki_timer,x	; GI
	;;;	stz	<_sunder_timer,x	; `rI
		stz	<_obake_timer,x		; ΂I
		rts		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_katiOBJ	lda	#2			;nai̕\
		eor	<screen_register
		tax
		lda	!goalstate,x
		cmp	#2
		bcc	exit$
		JSL	>Set_kati
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_raceOBJ	LDX	<screen_register	;J[gʏ\
		JMP	(!oamset_select,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Erase_raceOBJ	LDX	<screen_register	;J[g\݂̂nee
		LDA	#20H			;(L)
		STA	!obj_count_A,X
		LDA	#1			; set flag
		STA	!erase_kart,X
		JMP	(!oamset_select,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Erase_BGmeter	LDX	<screen_register	;BG̃[^
		LDA	!goal_clear,X
		STA	!meter_address,X
		LDA	#07FH			; 7Fbank
		STA	!meter_bank,X
		RTS		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Erase_JUGEM	LDX	<screen_register	;WQ
		LDA	#8000H			; (erase jugem)
		STA	!jugem_flag,X
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Down_player	LDX	<screen_register	;vC[P_E
		LDA	!player_count,x
		DEC	A
		BNE	exit$
		ldy	!screen_player
		lda	!_1up_status,y
		bne	exit$
		DEC	!gameover_1lost,x
exit$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Rankout_window	LDA	#14h
		BRA	window_common
Smorke_window	LDA	#4			;afFZ
		BRA	window_common
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Black_window	LDA	#8
		BRA	window_common
Big_window	LDA	<SEQ_register
		CMP	#8			; TM,BTȂ΂nee
		BCS	window_off
		LDA	#2			;傫ȏʂnai
window_common	LDX	<screen_register
		STA	!window_index,X
window_off	RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
brake_speed	equ	0008h
Empty_kart	



		LDY	<screen_register	;Rg[s\
		LDX	<player_index,Y
		LDA	#60*10
		STA	<_unable_control,X
		LDA	<_flag,X
		AND	#(ON_comp^0FFFFH)
		ORA	#STOP_item		;ACegpsI
		STA	<_flag,X
;- - - - - - - - - - - - - - - - - - - - - - 
		stz	<_vF,x
xsp		lda	<_velocityX,x		;I
		bpl	skip$
		clc
		adc	#brake_speed
		bmi	set$
		bpl	clear$
skip$		sec
		sbc	#brake_speed
		bpl	set$
clear$		lda	#0
set$		sta	<_velocityX,x
;- - - - - - - - - - - - - - - - - - - - - - 
ysp		lda	<_velocityY,x	
		bpl	skip$
		clc
		adc	#brake_speed
		bmi	set$
		bpl	clear$
skip$		sec
		sbc	#brake_speed
		bpl	set$
clear$		lda	#0
set$		sta	<_velocityY,x
;- - - - - - - - - - - - - - - - - - - - - - 

		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Close_shutter	LDA	#2			;Vb^[
		BRA	shutter_common
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Open_shutter	LDA	#0AH			;Vb^[J
shutter_common	CLC
		ADC	<screen_register	
	;;	STA	!shutter_status
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Check_gameover	LDX	<screen_register	;Q[I[o[̃`FbN
		LDA	!gameover_1lost,x
skip$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Lost_pose	LDX	<screen_register	;܂|[YZbg
		LDY	<player_index,X

		lda	#4000h
		and	!kart_status,y
		sta	!kart_status,y

		LDX	<_sunder_timer,y
		BNE	exit$
		TYA
		CLC
		ADC	<screen_register
		TAX
		LDA	#8001H
		STA	<_kart_char_A,X
exit$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_lostcount	
		
		lda	#2			;̃J[gPǉ
		eor	<screen_register
		tax
		lda	<game_status
		cmp	#6
		bne	entry$
;- - - - - - - - - - - - - - - - - - - - - -
		inx			; og vXS
		inx
		inx
		inx
;- - - - - - - - - - - - - - - - - - - - - -
entry$		sed
		lda	!m_win_count,x
		cmp	#0099h
		bcs	skip$
		clc
		adc	#1
skip$		sta	!m_win_count,x
;- - - - - - - - - - - - - - - - - - - 
		clc
		lda	!m_win_count+0		; T`FbNZbg
		adc	!m_win_count+2
		adc	!m_win_count+4
		adc	!m_win_count+6
		sta	!win_sum
;- - - - - - - - - - - - - - - - - - - 
		cld
		rts

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Computer_kart	ldy	<screen_register	;Rv[h
						;ɃZbg
		ldx	<player_index,y
		lda	#ON_comp
		ora	<_flag,x
		sta	<_flag,x
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Fin_goalflag	LDA	#_racefin	;S[CTʈȉtO
		BRA	set_goalflag
Win_goalflag	LDA	#_raceclear	;NAnjtO
		BRA	set_goalflag
Lap_goalflag	
		jsr	Check_1up	; 1UP initial
	;;	JSR	Stop_kartsound	;bv\ȂGWJbg
		LDA	#_lapstart	;bv^C~OtO
		BRA	set_goalflag
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_goalflag
		INC	!goal_flag	;S[C̐l𑝂₷
		LDA	!goal_flag
		AND	#0FH
		CMP	#2
		BNE	exit_goalflag
		lda	<screen_register
		beq	skip$
		lda	#_2pend		; vC[QŏI
skip$		ora	#_raceend	; vC[S
set_goalflag	TSB	!goal_flag	; S[Ȃ
exit_goalflag	RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;Auto_goalflag	lda	#_autodemo	; I[gŎ̖ʂɐi
;		tsb	!goal_flag	; 	̂njɂ
;		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Stop_kartsound				; GWTEh̃Jbg
		ldy	<screen_register 
		ldx	<player_index,y
		lda	#STOP_engine
		ora	<_flag,x
		sta	<_flag,x
		lda	#0ffffh		; hbv[Jbg
		sta	!doppler_switch
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Check_yeskey	LDX	<screen_register	; B+START
		LDA	<button_trigger+0,X	; {^`FbN
		BRA	key_skip
Yeskey_check	LDA	<button_trigger+0
		ORA	<button_trigger+2
key_skip	AND	#ST_button+B_button
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Quick_demo	ldx	<screen_register	; START
		lda	!rom_checker
		beq	exit$
		lda	<button_trigger,x	; {^`FbN
		and	#ST_button
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Disable_yopause	lda	<screen_register
		eor	#2
		tax
		bra	disable_pause
;- - - - - - - - - - - - - - - - - - - - - - -
Disable_mypause	ldx	<screen_register
		lda	#STOP_pause
		ora	!result_status,x
		sta	!result_status,x
disable_pause	lda	#00C0H
		ora	!camera_control,x
		sta	!camera_control,x
		rts
;- - - - - - - - - - - - - - - - - - - - - - -
Disable_pause	LDA	#00C0H
		TSB	!camera_control+0
		TSB	!camera_control+2
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
pause_2pcheck	lda	<SEQ_register		; 1P [h͖I
		bne	exit$
		lda	<screen_register
		eor	#2
		tax
		lda	!player_count,x		;Q[I[o[Ȃ疳
		beq	exit$
		lda	!result_status,x
		bmi	exit$
		lda	#(00c0h^0ffffh)		; |[Y
		and	!camera_control+0,x
		sta	!camera_control+0,x
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


;*********************************************************************
;	rdp process
;*********************************************************************
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	̃}bvւގ̃CjV
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
NEXT_RACE	
;
		lda	#800h		; Qx`FbN
		and	!goal_flag
		bne	exit$
		lda	#800h
		tsb	!goal_flag
;
	;;;;	jsl	>BGM_clear	;ʉʂփWv
		ldx	#Next_race
		jsl	>Call_bank0
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;	}bvȂ
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
RACE_RETRY	jsl	>BGM_clear	
		ldx	<SEQ_register		; mode check
		jmp	(!SEQ_retry,x)
;- - - - - - - - - - - - - - - - - - - - - - - - 
SEQ_retry	dw	retry_GPW
		dw	retry_GPS,retry_GPS
		dw	retry_0,retry_0,retry_0
		dw	retry_BT
retry_data	dw	04h,04h,04h,0ch,0ch,0ch,0ch
;- - - - - - - - - - - - - - - - - - - - - - - - 
retry_GPW	lda	!player_count+0
		ora	!player_count+2
		beq	start_title		; goto gameover
result_skip	
;;;
		bra	retry_0		; -> ̂܂܂蒼
;;;		
		lda	!goal_flag
		and	#03000h
		beq	retry_0
;- - - - - - - - - - - - - - - - - - - - - - - - 
;	ʉʂɂĂȂ
;- - - - - - - - - - - - - - - - - - - - - - - - 
result_race
		ldx	#Result_race
		jsl	>Call_bank0
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
retry_GPS	jsr	Check_gameover
		bpl	result_skip
;- - - - - - - - - - - - - - - - - - - - - - - - 
;	^Cgɂǂ(GAME OVER)
;- - - - - - - - - - - - - - - - - - - - - - - - 
start_title	ldx	#Start_title
		jsl	>Call_bank0
		jsl	>BGM_clear
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
;	̂܂܂蒼
;- - - - - - - - - - - - - - - - - - - - - - - - 
retry_0		ldx	<SEQ_register
		LDA	retry_data,x
		STA	!race_init
		ldx	#Retry_race
		jsl	>Call_bank0
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
;	xog
;- - - - - - - - - - - - - - - - - - - - - - - - 
retry_BT	lda	#0ch
		sta	!race_init
		lda	#0eh		; og̃CjV
		sta	<game_selecta
		lda 	#08f00h
		sta	<fade_control
		lda	#0080h
		sta	!fade_speed
		lda	#0
		sta	!game_mode_stock	
		rts
;
;
;
;
;
;
;#####################################################################
;	PopVb^[
;#####################################################################
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Vb^[^C~O`FbN
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Vb^[Pt[CjV
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Vb^[
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Vb^[uLOł̃CjV
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Vb^[J
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;	Vb^[J̃f
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;#####################################################################
;		
;#####################################################################
;---------------------------------------------------------------------
;		Pknrsf
;---------------------------------------------------------------------
		EXT	Init_1lost,Main_1lost,Set_bomb_char
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Init_lostdemo	
		lda	#0ffffh
		sta	!doppler_switch
		LDX	#0
		PHB
		PHK
		PLB
		LDY	<screen_register
		LDX	<player_index,Y
		STX	<register
;- - - - - - - - -  - - - - - - - - - - - - - -
		jsr	Init_1lost
		ldx	<screen_register
		jsr	Set_bomb_char
		BRA	lost_common
;- - - - - - - - -  - - - - - - - - - - - - - -
Main_lostdemo	PHB
		PHK
		PLB
		LDY	<screen_register
		LDX	<player_index,Y
		STX	<register
lost_common	JSR	Main_1lost
		PLB
		RTL
;#####################################################################
;		S[C̕]CjV
;#####################################################################
;--------------------------------------------------------------------
Init_goalin	LDA	#0
		STA	>moji_r0+moji_trans
		STA	>moji_r0+moji_flag
;- - - - - - - - - - - - - - - - - - - - - - 
		STA	>moji_r1+moji_trans
		STA	>moji_r1+moji_flag
;- - - - - - - - - - - - - - - - - - - - - - 
		RTS
;--------------------------------------------------------------------
DMA_goalin	LDX	#moji_r1		; Bscreen giveup
		JSR	DMA_moji
		LDX	#moji_r0		; Ascreen giveup
		JSR	DMA_moji
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - 
DMA_moji	LDA	>7F0000H+moji_trans,X
		BEQ	exit$
		LDA	#0			; clear trans
		STA	>7F0000H+moji_trans,X
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		PHX				;>>
		LDA	>7F0000H+moji_vram,X
		TAY				; Y=VRAM address
		LDA	>7F0000H+moji_address,X
		TAX				; C=Abus address
		LDA	#002H+7FH*100H		; A=data count/bank
		JSL	>DMA_trans
		PLX				;<<
		TYA
		CLC
		ADC	#10H
		STA	>7F0000H+moji_vram,X
exit$		RTS
;----------------------------------------------------------------------

;#####################################################################
;		S[C
;#####################################################################
work_data	dw	moji_r0,moji_r1
lap_data	dw	lap_bufferA,lap_bufferB
;- - - - - - - - - - - - - - - - - - - - - - - - -
Disp_goalin	PHB
		PEA	BC_7F_7F
		PLB
		PLB
;- - - - - - - - - - - - - - - - - - - - - - - ; INDEX set
		LDX	<screen_register
		LDA	>work_data,X
		TAY
		LDA	>state_control
		BEQ	entry$
		LDA	!moji_flag,Y
		BNE	entry$
		LDA	#1		; initial flag
		STA	!moji_flag,Y
;- - - - - - - - - - - - - - - - - - - - - - - ; l Zbg
init$		
		PHY				;>>(moji_r0)
		TYA				; result
		CLC
		ADC	#moji_result		; databuffer
		TAY
		PHY				; >>
		LDA	>lap_data,X
		TAX				; X= lap register
		JSR	Disp_laptime
;- - - -
		PLA				; << result databuffer
		PLX				;<< (moji_r0)
		LDY	#moji_value/65536	;
		JSR	Init_moji
		BRA	exit$
;- - - - - - - - - - - - - - - - - - - - - - - ;@]Zbg
entry$		TYX


		LDA	<sprite_count
		pha
		JSR	Set_moji
		pla
		sta	<0
;- - - - - - - - - - - - - - - - - - - - - -
		lda	>best_flag	;xXgbv̓_
		and	#0fh
		beq	skip1$
		dec	a
		asl	a
		tax
		lda	>lap_pointer,x
		clc
		adc	<0
		tay
		jsr	Frash_time
;- - - - - - - - - - - - - - - - - - - - - -
skip1$		lda	>best_flag	;xXgR[h̓_Ł@
		bpl	skip2$
;
		lda	#rec_pointer
		clc
		adc	<0
		tay
		jsr	Frash_time
;- - - - - - - - - - - - - - - - - - - - - -
skip2$
		JSR	Reform_OAM
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
skip$





;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
exit$		PLB
		RTS
;--------------------------------------------------------------------
; xXgbv̓_
;- - - - - - - - - - - - 
rec_pointer	equ	4*(10+9*4+22))
lap_pointer	dw	4*(10+9*4)
		dw	4*(10+9*3)
		dw	4*(10+9*2)
		dw	4*(10+9*1)
		dw	4*10


;		Y = sprite count
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Frash_time	SEP	#00100000B
		MEM8
		TYX
		LDA	#2BH
		STA	<sprite_A+00H,X
		STA	<sprite_A+04H,X
		STA	<sprite_A+08H,X
		STA	<sprite_A+0CH,X
		STA	<sprite_A+10H,X
		STA	<sprite_A+14H,X
		STA	<sprite_A+18H,X
exit$		REP	#00100000B
		MEM16
		RTS		
;#####################################################################
;		R[hf[^obt@
;#####################################################################
;#####################################################################
;		bv^C \
;#####################################################################
;*********************************************************************
;		goal screen program
;*********************************************************************
time_sec	EQU	101H
time_min	EQU	104H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
_total		EQU	0
_round		EQU	20H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Lap_write	RTL

;*********************************************************************
;		goal screen program
;*********************************************************************
Disp_result	LDX	<screen_register
		BIT	!result_control,X
		BVS	entry$
		RTL
;--------------------------------------------------------------------
entry$		PHB
		PHK
		PLB
		LDA	!lap_offset,X
		STA	<buffer_offset
		LDX	<sprite_count
		LDY	#mes_result
		LDA	#pos_result
		JSR	Disp_message
		STX	<sprite_count
		LDX	#lap_data_A
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
loop$		LDA	!0,X
		BEQ	exit$
		CLC
		ADC	<buffer_offset
		TAY
		LDA	!2,X
		PHX
		JSR	Disp_lap		; lap screen
		PLA
		CLC
		ADC	#4
		TAX
		BRA	loop$
exit$		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		JSR	Reform_OAM
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		PLB
		RTL
;--------------------------------------------------------------------
lap_round	EQU	lap_bufferA+34H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
lap_offset	dw	00h,060h		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
lap_data_A	dw	lap_round+10h,2c00h
		dw	lap_round+10h,2000h
		dw	lap_round+0ch,1800h
		dw	lap_round+08h,1000h
		dw	lap_round+04h,0800h
		dw	lap_round+00h,0000h
		dw	0
;*********************************************************************
;		display result time
;*********************************************************************
;*********************************************************************
;		display result time
;*********************************************************************
;		X = sprite count
;		Y = buffer address
;- - - - - - - - - - - - - - - - - - - -  ( timeset main )
Disp_total	
Disp_lap	CLC
		ADC	<screen_obj_V
		STA	<pos_offset
		LDA	!0,Y
		STA	<sec_100	;1/100,sec address
		LDA	!2,Y
lap_entry	STA	<min		;min address
;- - - - - - - - - - - - - - - - - - - -  ( timeset main )
;
		LDX	<sprite_count
		LDA	#result_time
		CLC
		ADC	<pos_offset
		TAY
		LDA	<min
		JSR	Disp_digit	; min
		LDA	#result_time+18H
		CLC
		ADC	<pos_offset
		TAY
		LDA	<sec_1
		JSR	Disp_byte	; sec
		LDA	#result_time+30H
		CLC
		ADC	<pos_offset
		TAY
		LDA	<sec_100
		JSR	Disp_byte	; 1/100
		STX	<sprite_count
		RTS
;*********************************************************************
;		message data
;*********************************************************************
pos_result	EQU	1C10H
mes_result	DB	_r,_e,_s,_u,_l,_t,0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
result_time	EQU	2810H
;--------------------------------------------------------------------
;*********************************************************************
;		RESULT CHARACTER
;*********************************************************************
Alpha_buffer	EQU	7FE000H
alpha_data	DW	5c00H,6c00H		; VRAM select
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DMA_result	LDA	!result_test		; flag debug
		BEQ	skip$
		LDA	#8000H
		TSB	!result_control+0
		TSB	!result_control+2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
skip$		LDX	!frame_part		; flag check
		BIT	!result_control,X
		BPL	exit$
		BVS	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		LDA	#80H
		STA	!Screen_step
;
		LDA	!result_control-1,X
		AND	#0300H
		PHA
		ORA	 >alpha_data,X		; VRAM select
		STA	!Screen_address
;
		PLA
		ASL	A
		CLC
		ADC	#Alpha_buffer
		STA	!DMA_0+DMA_address+0
		LDA	#Alpha_buffer/65536
		STA	!DMA_0+DMA_address+2
		LDA	#200H			; data count
		STA	!DMA_0+DMA_count
		LDA	#1801H			; 2byte L,H
		STA	!DMA_0+DMA_control
;;
		SEP	#00100000B
		MEM8
		LDA	#1			;B
		STA	!DMA_burst		;B
		LDA	!result_control+0,X	
		INC	A
		STA	!result_control+0,X
		CMP	#4
		BNE	skip_1$
		LDA	!result_control+1,X
		ORA	#40H
		STA	!result_control+1,X
;;
skip_1$		REP	#00100000B
		MEM16
exit$		RTL
;*********************************************************************
;		RESULT DISPLAY ( message )
;*********************************************************************
;		A = display position
;		Y = data work
;		X = oam counter
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
temp	EQU	0
;----------------------------------------------------------------------
Disp_message	CLC
		ADC	<screen_obj_V
		STA	<temp
		BRA	entry$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
loop$		ORA	#2900H
		STA	<sprite_C,X
		LDA	<temp
		STA	<sprite_H,X
		CLC
		ADC	#8
		STA	<temp
		INY
		INX
		INX
		INX
		INX
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
entry$		LDA	!0,Y
		AND	#00FFH
		BNE	loop$
		RTS
;*********************************************************************
;		RESULT DISPLAY ( sprite )
;*********************************************************************
;		A = display position
;		Y = data work
;		X = oam counter
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
disp_loop	STA	<sprite_C,X
		LDA	!2,Y
		CLC
		ADC	<screen_obj_V
		STA	<sprite_H,X
		INY
		INY
		INY
		INY
		INX
		INX
		INX
		INX
Disp_sprite	LDA	!0,Y
		BNE	disp_loop
		RTS
;*********************************************************************
;		RESULT DISPLAY ( number )
;*********************************************************************
;		Y = display position
;		A = work 
;----------------------------------------------------------------------
Disp_word	PHA				;>>
		JSR	Disp_byte
		PLA				;<<
		XBA
Disp_byte	PHA				;>>
		JSR	Disp_digit
		PLA				;<<
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
		LSR	A			;W
Disp_digit	AND	#0FH
Disp_set	ORA	#_0
		STA	<sprite_C,X
		STY	<sprite_H,X
		TYA
		SEC
		SBC	#8			; position dec
		TAY
		INX
		INX
		INX
		INX
		RTS
;*********************************************************************
;		S[CbZ[WZbg
;*********************************************************************
;					DBR = 7FH
;		Y = data address	
;		X = lap address
;		
;----------------------------------------------------------------------

		ext	Save_laptime

Disp_laptime
		jsr	set_data
		jsr	Save_laptime
;- - - - - - - - - - - - - - - - - - - - ; open message
		LDA	#mes_lap
		JSR	Set_wordmessage
;- - - - - - - - - - - - - - - - - - - -
		SEP	#00100000B
		MEM8
		LDA	#5		; lap 1
		JSR	Set_laptime	
		LDA	#4		; lap 2
		JSR	Set_laptime
		LDA	#3		; lap 3	
		JSR	Set_laptime
		LDA	#2		; lap 4
		JSR	Set_laptime
		LDA	#1		; lap 5
		JSR	Set_laptime
;- - - - - - - - - - - - - - - - - - - -
		REP	#00100000B
		MEM16
		LDA	#mes_total
		JSR	Set_wordmessage
		SEP	#00100000B
		MEM8
		LDA	#0		; lap total
		JSR	Set_laptime
		LDA	#0FFH		; end code
		STA	!0,Y
		REP	#00100000B
		MEM16
		RTS
;-----------------------------------------------------------
;		word message		
;-----------------------------------------------------------
;					; Y = write address
		mem16
Set_wordmessage	
		PHX			;>>
		TAX			; X = read address
		LDA	>dbank_10000,X
		AND	#00FFH
		DEC	A		; A = data count-1
		INX
		MVN	#dbank_01,#dbank_7f
		PLX			;<<
		RTS
;-----------------------------------------------------------
;
;-----------------------------------------------------------
		mem8
Set_laptime	PHX			;>>
		XBA
		LDA	#0
		XBA
		TAX
		LDA	#0FDH
		STA	!0,Y
		LDA	>lappos,X
		STA	!1,Y		; data position
;
		LDA	>lapno0,X
		STA	!2,Y
		LDA	>lapno1,X
		STA	!3,Y
		LDA	>lapno2,X
		STA	!4,Y
		PLX			;<<
		LDA	#0FCH		; skip
		STA	!5,Y
;
		LDA	<_round+2,X	; 0
		CMP	#0AH
		BCC	s1$
		LDA	#9CH
s1$		STA	!6,Y

		LDA	#028H		; hun
		STA	!7,Y
;
		LDA	<_round+1,X		; 0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#0AH
		BCC	s2$
		LDA	#9CH
s2$		STA	!8,Y

		LDA	<_round+1,X		; 0
		AND	#0FH
		CMP	#0AH
		BCC	s3$
		LDA	#9CH
s3$		STA	!9,Y
;
		LDA	#029H		; byou
		STA	!10,Y
;
		LDA	<_round+0,X		; 0
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CMP	#0AH
		BCC	s4$
		LDA	#9CH
s4$		STA	!11,Y

		LDA	<_round+0,X		; 0
		AND	#0FH
		CMP	#0AH
		BCC	s5$
		LDA	#9CH
s5$		STA	!12,Y

;;
	;;	LDA	#0FCH		; skip	
	;;	STA	!13,Y
	;;	LDA	#000H		; LANK
	;;	STA	!14,Y
;;
		REP	#00100001B
		MEM16
		TYA
		ADC	#13
		TAY
		INX
		INX
		INX
		INX
		SEP	#00100000B
		MEM8
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
mes_lap
;{o[Wf[^
;	DB	011		; counter
;	DB	0FDH,083H	; code,position
;	DB	2dH,10H,11H,12H,14H,15H,16H,17H,2dH	
;po[Wf[^
;;	DB	011
	DB	010		; counter
	DB	0FDH,084H	; code,position
	DB	2dh,30h,31h,32h,33h,34h,35h,2dh,2dh

mes_total
	DB	14
	DB	0FDH,062H
	DB	09eH,09eH,09eH,09eH,09eH,09eH,09eH,09eH,09eH,09eH,09eH,09eH
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
lappos		DB	072H,52H,42H,32H,22H,12H
lapno0		DB	0A0H,0FCH,0FCH,0FCH,0FCH,0FCH
lapno1		DB	0A1H,9fH,9fH,9fH,9fH,9fH
lapno2		DB	0A2H,05H,04H,03H,02H,01H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		mem16
		idx16
;*********************************************************************
;		RESULT DISPLAY ( number )
;*********************************************************************
temporary	EQU	0
data_addr	EQU	2	;4byte
buffer_addr	EQU	6	;2byte	
;----------------------------------------------------------------------
;		X = moji value index
;		A = data address
;		Y = data bank
;----------------------------------------------------------------------
Init_moji	STA	!moji_register,X	; set data register
		TYA
		STA	!moji_bank,X		; set data bank
		STZ	!moji_pointer,X		; pointer reset
		STZ	!moji_spcount,X		; sprite count reset
		LDA	#5800H			; A screen VRAM
		LDY	<screen_register
		BEQ	skip$
		LDA	#6800H			; B screen VRAM
skip$		STA	!moji_vram,X		; set VRAM initial
		LDA	#2980H
		STA	!moji_spchar,X		; set character initial
		LDA	#5
		STA	!moji_wait,X		; wait timer set
		RTS
;----------------------------------------------------------------------
;
;		X = moji value index
;
;----------------------------------------------------------------------
Set_moji	LDA	!moji_wait,X
		BEQ	entry$
		DEC	!moji_wait,X
		BEQ	entry$
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
entry$		LDA	!moji_register,X
		STA	<data_addr+0		; address
		LDA	!moji_bank,X
		STA	<data_addr+2		; bank
		TXA
		CLC
		ADC	#moji_buffer
		STA	<buffer_addr+0		; address
;						; bank = 7F
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		LDY	!moji_pointer,X
		SEP	#00100000B
		MEM8
newdata$	LDA	[<data_addr],Y
		CMP	#0FBH			; address code
		BCC	skip1$
		INC	A		; FF?
		BEQ	mojiend$
		INC	A		; FE ? message format
		BEQ	onbord$
		INC	A		; FD ? lap format
		BEQ	laptime$
					; FC   skip moji
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
posskip$	LDA	#08H
		CLC
		ADC	!moji_position,X
		STA	!moji_position,X
		INY
		BRA	newdata$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
mojiend$	LDA	#2
		STA	!moji_flag,X
		JMP	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
; laptime message system
laptime$	INY
		PHX			;>>
		LDA	#0
		XBA
		LDA	[<data_addr],Y
		AND	#070H
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAX
		LDA	>lapbord,X
		BRA	common$
		
; onbord message system
onbord$		INY
		PHX			;>>	
;- - - 
		LDA	[<data_addr],Y
		AND	#070H
		LSR	A
		STA	<temporary
		LSR	A		; 8*1.5 process
		ADC	<temporary	; CLC
		ADC	#20H		; Y bord corner
common$		XBA
;- - -
		LDA	[<data_addr],Y
		ASL	A		; carry set
		LDA	[<data_addr],Y
		AND	#0FH
		ROL	A		; X offset
		ASL	A
		ASL	A		:CLC
		ADC	#40H		; X bord corner
;- - - 
		PLX			;<<
		REP	#00100001B
		MEM16
		ADC	<screen_obj_V
		STA	!moji_position,X
		INY
		SEP	#00100000B
		MEM8
		JMP	newdata$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
skip1$		REP	#00100000B
		MEM16
		AND	#00FFH
		PHA				;>>
		INY
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ADC	#moji_character		;CLC
		STA	!moji_address,X		;  ] AhX
		TYA
		STA	!moji_pointer,X		; pointer INC
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		LDY	!moji_spcount,X		;
		PLA				;<<
		CMP	#02EH			; tenten 
		BEQ	dakuten$
		CMP	#02FH			; tenten 
		BEQ	dakuten$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
nomal$		LDA	!moji_position,X	; position INC
		STA	(<buffer_addr),Y
		CLC
		ADC	#0008H
		BRA	pos$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
dakuten$	LDA	!moji_position,X
		SEC
		SBC	#0808H
		STA	(<buffer_addr),Y
		CLC
		ADC	#0808H
pos$		STA	!moji_position,X
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
		INY
		INY
		LDA	!moji_spchar,X		; character INC
		STA	(<buffer_addr),Y
		INC	A
		STA	!moji_spchar,X
		INY
		INY
		TYA
		STA	!moji_spcount,X		; sprite count INC
		DEC	!moji_trans,X		; trans ON
		BRA	skip$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
exit$		REP	#00100000B
		MEM16
		LDA	!moji_spcount,X		
		BRA	Ascreen$
;- - - - - - - - - - - - - - - - - - - - - - -  ;@OAM Zbg
skip$		LDA	!moji_spcount,X
		LDY	<screen_register	; Ascreen ?
		BEQ	Ascreen$
		SEC
		SBC	#4
		BEQ	over$
Ascreen$	PHA			;>>
		LDY	<sprite_count
		CLC
		ADC	<sprite_count
		STA	<sprite_count
		LDX	<buffer_addr
		PLA			;<<
		DEC	A
		PHB
		MVN	#dbank_7f,#dbank_00
		PLB
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
over$		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
tp		EQU	19H-4			; top V position
lapbord		DB	tp			; lap time
		DB	tp+10H			; lap 1
		DB	tp+10H+9		; lap 2
		DB	tp+10H+9+9		; lap 3
		DB	tp+10H+9+9+9		; lap 4
		DB	tp+10H+9+9+9+9		; lap 5
		DB	tp+10H+9+9+9+9+8	; total	
		DB	tp+10H+9+9+9+9+8+8	; total time
;*********************************************************************
;		Reform sprite count
;*********************************************************************
		GLB	Reform_sprite
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Reform_sprite	JSR	Reform_OAM
		RTL
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Reform_OAM	LDX	<sprite_count
		LDY	#0E080H
		BRA	entry$
loop$		STY	<sprite_H,X
		INX
		INX
		INX
		INX
entry$		TXA
		BIT	#0FH
		BNE	loop$
skip$		STA	<sprite_count	; sprite count set
		RTS
;----------------------------------------------------------------------
;
;
;
;
;
;####################################################################
;
;	bv^C
;
;####################################################################

;*********************************************************************
;	bv^C̃Z[u`FbN
;*********************************************************************





;*********************************************************************
;	bv^ČvZ
;*********************************************************************
set_data	
		phy				;   >>
		phx				; >>
		phx				; >>

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		clc
		lda	<screen_register
		beq	skip$
		lda	#01eh
skip$		adc	#laptime_buffer
		sta	<0
		lda	#laptime_buffer/65536
		sta	<2
		lda	#5
		sta	<4
		ldy	#0
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;g[^f[^̃Rs[
;- - - - - - - - - - - - -
loop$		iny
		lda	[<0],y		;
		sta	<_total+4,x	; g[^^Cib)
		iny
		iny
		iny
		lda	[<0],y
		cmp	#0ffffh		; +++ debug +++
		bne	debug$		; +++ debug +++
		lda	#0		; +++ debug +++
debug$		sta	<_total+6,x	; g[^^C (j
		iny
		iny
		inx
		inx
		inx
	   	inx
		dec	<4
		bne	loop$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;bvf[^̌vZ
;- - - - - - - - - - - - -
		plx

		SEP	#00100000B
		MEM8
		lda	>104h		; ()		; ^CI[o[
		cmp	#09h
		bne	entry_lap$
		lda	>102h		; (bj
		cmp	#59h
		bne	entry_lap$
		lda	>101h
		cmp	#99h		; (1/100)
		beq	time_over

entry_lap$	REP	#00100000B
		MEM16

		ldy	#5
loop2$		jsr	lap_calc		; P[Tbv
		inx
		inx
		inx
		inx
		dey
		bne	loop2$
;
		lda	<_total+0,x		; total lap
		sta	<_round+0,x
		lda	<_total+2,x
		sta	<_round+2,x
;
		plx				;   <<
		ply				; <<
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;bv^ČvZ
;- - - - - - - - - - - - - - 
lap_calc	SED
		LDA	<_total+4,X
		SEC
		SBC	<_total+0,X
		BCS	skip$
		LDA	#6000H
		SEC
		SBC	<_total+0,X
		CLC
		ADC	<_total+4,X
		CLC
skip$
set$		STA	<_round+0,X	; bZbg
		LDA	<_total+6,X
		SBC	<_total+2,X
		STA	<_round+2,X	; Zbg
		CLD
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;^CI[o[̂Ƃ ( I[bv 9'59"99 )
;- - - - - - - - - - - - - - 
time_over	REP	#00100000B
		MEM16
		ldy	#6
loop$		lda	#0AAAAh
		sta	<_round+0,x
		lda	#00AAh
		sta	<_round+2,x
		inx
		inx
		inx
		inx
		dey	
		bne	loop$	
		plx
		ply
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

back84	sect	rel

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	
;- - - - - - - - - - - - - - 













;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

		END
