;*********************************************************************
;	mario kart object Eh\
;			  /f\
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/round.def
;-------------------------------------------------------------------
		glb	Init_round,Main_round,DMA_round
		glb	Init_demoword,Main_demoword
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ext	param_screenA,param_screenB
		ext	Buffer_pause,Execute_VRAM,BD_sprite,Clear_RAM
		ext	set_pause_char
		ext	Clear_VRAM
;-------------------------------------------------------------------
	comn
work	ds	2
counter	ds	2
;-------------------------------------------------------------------
		EXTEND
objdata	SECT	REL
		mem16
		idx16

;*********************************************************************
;		Eh\ INITIAL
;*********************************************************************
Init_demoword	rts
Main_demoword	rts
;
;Init_round	stz	!pause_status
;		rts
;Main_round	rts
;DMA_round	rtl


		if	1

Init_round
;- - - - - - - - - - - - - - - - - - - - - - MODE CHECK
		stz	!pause_status
		lda	!ending_flag	; GfBO̓ZbgȂ
		bne	noset$
		lda	!o_demo_flag	; f̓ZbgȂI
		bne	noset$
		lda	<game_status	; GP MODE Ȃ΃Zbg!
		beq	entry$
noset$		rts
;- - - - - - - - - - - - - - - - - - - - - - RAM CLEAR
entry$		ldx	#buffer_clear
		jsl	>Clear_RAM
;- - - - - - - - - - - - - - - - - - - - - - VRAM CLEAR
		ldx	#vram_clear
		jsl	>Clear_VRAM
		ldx	#vram_clear2
		jsl	>Clear_VRAM
;- - - - - - - - - - - - - - - - - - - - - - ROUND CHECK
		lda	!map_pointer
		cmp	#4
		beq	skip$
;- - - - - - - - - - - - - - - - - - - - - - ʏ탉bv̎
		asl	a
		adc	#data_number_1a
		tay
		ldx	#round_buffer+00c0h
		jsr	Buffer_pause
		lda	!map_pointer
		asl	a
		adc	#data_number_1b
		tay
;- - - - - - - - - - - - - - - - - - - - - - 
		ldx	#round_buffer+02c0h
		jsr	Buffer_pause
		ldy	#data_round_a
		ldx	#round_buffer+0020h
		jsr	Buffer_pause
		ldy	#data_round_b
		ldx	#round_buffer+0220h
		jsr	Buffer_pause
		lda	#3062h
		bra	skip2$
;- - - - - - - - - - - - - - - - - - - - - - t@Cibv̎
skip$		ldy	#data_final_a
		ldx	#round_buffer+0020h
		jsr	Buffer_pause
		ldy	#data_final_b
		ldx	#round_buffer+0220h
		jsr	Buffer_pause
		lda	#3064h
;- - - - - - - - - - - - - - - - - - - - - - VRAM INITIAL
skip2$		sta	!round_work
;
;- - - - - - - - - - - - - - - - - - - - - - OAM INITIAL
		jsr	param_screenA
		ldx	<screen_register
		lda	!player_count,x
		beq	skip3$
		ldx	#260h
		stx	<sprite_count
		lda	!round_work
		ldy	#round_oam
		jsl	>BD_sprite
skip3$
		jsr	param_screenB
		ldx	<screen_register
		lda	!player_count,x
		beq	exit$
		ldx	#260h+220h
		stx	<sprite_count
		lda	!round_work
		clc
		adc	<screen_obj_V
		ldy	#round_oam
		jsl	>BD_sprite
;- - - - - - - - - - - - - - - - - - - - - - SUB CLEAR		
exit$		SEP	#00100000B
		MEM8
		lda	#055h
		sta	!sprite_buffer+206h
		sta	!sprite_buffer+206h+220h
		REP	#00100000B
		MEM16
;- - - - - - - - - - - - - - - - - - - - - -
		rts
;- - - - - - - - - - - - - - - - - - - - - -

;*********************************************************************

round_oam	db	4+80h		; big size
		dw	0000h,0800h
		db	0
		dw	0010h,0802h
		db	0
		dw	0020h,0804h
		db	0
		dw	0030h,0806h
		db	0

data_round_a	db	0ech,0edh,0eeh,0efh,0
data_round_b	db	0fch,0fdh,0feh,0ffh,0
data_final_a	db	0e7h,0e8h,0e9h,0eah,0ebh,0
data_final_b	db	0f7h,0f8h,0f9h,0fah,0fbh,0

data_number_1a	db	0cah,0
data_number_2a	db	0cch,0
data_number_3a	db	0ceh,0
data_number_4a	db	0d0h,0
data_number_1b	db	0cbh,0
data_number_2b	db	0cdh,0
data_number_3b	db	0cfh,0
data_number_4b	db	0d1h,0

buffer_clear	DW	0000H 		( 2 byte clear patern )
		DL	round_buffer	( RAM start address )
		DW	0400H		( RAM clear count )

vram_clear	dw	0000h
		dw	5000h
		dw	0200h
vram_clear2	dw	0000h
		dw	6000h
		dw	0200h

;--------------------------------------------------------------------

;*********************************************************************
;		Eh\ NMI
;*********************************************************************
dmaexit		plb
		rtl

DMA_round	PHB
		PHK
		PLB
		lda	!round_pointer
		bpl	dmaexit
		bit	#0020h
		beq	entry$
		stz	!round_pointer
		bra	dmaexit
;
entry$
		ldx	#81h		; oam pointer 20h skip
		stx	!Screen_step

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; ROM address ̌vZ
		bit	!round_pointer
		bvc	skip00$
		eor	#001fh
skip00$		and	#00ffh
		bit	#0010h
		beq	rom_open$
		and	#0ffefh
		bit	#0008h
		beq	rom_next$
;- - - - - - - - - - - - - - - - - - - 
		ora	#0100h
rom_next$	ora	#0008h
		bra	skip0$
;- - - - - - - - - - - - - - - - - - - 
rom_open$	bit	#0008h
		beq	skip0$
		and	#0007h
		ora	#0100h
skip0$		asl	a		; *2
		bit	!round_pointer
		bvc	skip1$
		clc
		adc	#00100h
skip1$		tax			; ROM index
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; VRAM address ̌vZ
		lda	!round_pointer
		and	#00ffh
		bit	!round_pointer
		bvc	skip2$
		eor	#001fh
skip2$		bit	#0010h
		beq	vram_open$
		and	#0ffefh
		bit	#00008h
		beq	vram_next$
		ora	#00100h
vram_next$	ora	#00008h
		bra	skip$
vram_open$	bit	#00008h
		beq	skip$
		and	#00007h
		ora	#00100h			; 0100 -
skip$		ora	#05000h			; 5000 -
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldy	!player_count+0
		beq	p2$	
		jsr	set_1		; 1P 
p2$		ldy	!player_count+2
		beq	p3$	
		clc
		adc	#01000h
		jsr	set_1		; 2P 
p3$
		inc	!round_pointer
		
exit$		plb
		rtl

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
set_1		phx
		pha
		jsr	setvram
		clc
		adc	#10h		; VRAM 10H +
		tay
		txa
		clc
		adc	#20h		; ROM 20H +
		tax
		tya
		jsr	setvram
		pla
		plx
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
setvram		pha				;  <<
		phx				;<<
		sta	!Screen_address+0
		ldy	#4
loop$		lda	>round_buffer,x
		sta	!Screen_write+0
		txa
		clc
		adc	#40h
		tax
		dey
		bne	loop$
		plx				;>>
		pla				;  >>
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -


;*********************************************************************
;		Eh\ MAIN
;*********************************************************************
Main_round
		lda	!round_process
		asl	a
		tax
		jmp	(!process$,x)
;----------------------------------------------------------------------
process$	dw	round_off	; Eh\Ȃ
		dw	round_open	; Eh\Jn
		dw	round_disp	; Eh\
		dw	sprite_erase	; \/Pē](1P)
		dw	round_close	; Pē](2P)
;----------------------------------------------------------------------
;		Eh\Ȃ
;----------------------------------------------------------------------
round_off	rts
;----------------------------------------------------------------------
;		EhL]Jn
;----------------------------------------------------------------------
round_open	bit	!o_demo_flag	; fȂ΃ZbgȂI
		bpl	skip$
		stz	!round_process
		rts
skip$		lda	#180
		sta	!round_timer
		inc	!round_process
		lda	#08000h			; ]Zbg
		sta	!round_pointer
		lda	#0AAh
		ldx	#6
		bra	disp_obj
;----------------------------------------------------------------------
;		 \EFCg			<< WAIT >>		
;----------------------------------------------------------------------
round_disp	dec	!round_timer
		bne	exit$
		lda	#0c000h			; Zbg
		sta	!round_pointer
		lda	#40h
		sta	!round_timer
		inc	!round_process
exit$		rts
;----------------------------------------------------------------------
;		\/Pē](1P)	<< 1 frame >>
;----------------------------------------------------------------------
sprite_erase
		dec	!round_timer
		bne	exit$
;
		lda	#08h
		sta	!GP_limitter
;
		inc	!round_process
		ldy	#0			; 1P
		jsr	trans_kemuri
		lda	#055h			; \
		ldx	#6
		jmp	disp_obj
exit$		rts
;----------------------------------------------------------------------
;		Pē](2P)		; << 1 frame >>
;----------------------------------------------------------------------
round_close
		stz	!round_process
		ldy	#2			; 2P
		bra	trans_kemuri	



;- - - - - -  UTILITY - - - - - -  - - - - -
;----------------------------------------------------------------------
						; \ nm^nee
disp_obj	SEP	#00100000B
		MEM8
		bit	<player_index+0+1	; 1P MODE
		bmi	skip$
		sta	!sprite_buffer+200h,x
skip$		bit	<player_index+2+1	; 2P MODE
		bmi	exit$
		sta	!sprite_buffer+420h,x
exit$		REP	#00100000B
		MEM16
		rts
;----------------------------------------------------------------------
						; Pē]
trans_kemuri	lda	!player_count,y
		beq	skip$
		ldx	#2			; PL]
		jsr	set_pause_char		
skip$		rts
;----------------------------------------------------------------------

	endif




;*********************************************************************
;		fbZ[W\ MAIN
;*********************************************************************
;---------------------------------------------------------------------
		glb	Set_replaymes
;---------------------------------------------------------------------
Set_replaymes			
		ldx	#5555h			; OFF
		lda	!replay_flag
		bpl	skip$
		lda	!player_r0+_flag	; S[H
		and	#ON_goal
		bne	skip$
		lda	!pause_status		; |[YH
		bmi	skip$
		lda	<frame_counter
		and	#020h
		beq	skip$
		ldx	#0			; ON
skip$		stx	!sprite_buffer+200h
		rts

;*********************************************************************
;		ėp@
;*********************************************************************
;	ZƂɐFς
;- - - - - - - - - - - - - - - - - - - - - - -
	if	0
		ldy	#0000h		; J[P
		ldx	#0000h		; J[Q
		lda	#5000h		; VRAM ADDRESS
		jsr	Test_clear
;- - - - - - - - - - - - - - - - - - - - - - -
Test_clear	phx			; >>
		ldx	#080h	
		stx	!Screen_step
		sta	!Screen_address
		lda	#20h
		sta	<counter
		pla			; <<
main_loop$	ldx	#8
loop$		sty	!Screen_write
		dex
		bne	loop$
		ldx	#8
loop2$		sta	!Screen_write
		dex
		bne	loop2$		
		dec	<counter
		bne	main_loop$		
		rts
;- - - - - - - - - - - - - - - - - - - - - - -
	endif
;- - - - - - - - - - - - - - - - - - - - - - -
		END
