;======================================================================
;*********************************************************************
;	mario kart << XYZ -> HV convert >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
;----------------------------------------------------------------------
	GLB	project,screen_A,screen_B
	GLB	project_Z,screen_AZ,screen_BZ
	GLB	dist_project,dist_screen
;----------------------------------------------------------------------
	GLB	setobj
	GLB	H_center,V_mycar,VH_mycar,mycar_distance,max_distance
	GLB	jumpset_A,jumpset_B
	GLB	disp_A_shadow,disp_B_shadow,disp_B_check
;----------------------------------------------------------------------
		COMN
work	DS	2
		EXTEND
objprog	SECT	REL
		mem16
		idx16
;***********************************************************************
;		3D vZ ( DISTANCE ) ̎Zo
;***********************************************************************
dist_project	txy
		ldx	<register
		SEP	#00100000B
		MEM8
		lda	#dsp_project
		sta	!DSP_data
		REP	#00100000B
		MEM16
		lda	<_situationXH,x
		asl	a
		asl	a
		sta	!DSP_data
		lda	<_situationYH,x
		asl	a
		asl	a
		sta	!DSP_data
		lda	#0
		sta	!DSP_data
		tyx
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - -
dist_screen	ldx	<register
		lda	<screen_register
		lsr	a
		lsr	a
		LDA	>DSP_status
		BPL	$-4
		lda	!DSP_data
		lda	>0
		lda	!DSP_data
		lda	>0
		lda	!DSP_data
		bcc	skip$
		sta	<_distance_B,x
		rts
skip$		sta	<_distance_A,x
		rts
;- - - - - - - - - - - - - - - - - - - - - - -


;***********************************************************************
;		world X,Y,Z position -> DSP 
;***********************************************************************
		EXTEND
objprog	SECT	REL
		mem16
		idx16
;-----------------------------------------------------------------------
;project_screen	STRUC	{project,[ ,]screen,[ ,]}
;project
;-----------------------------------------------------------------------
;		yʒu͂OiJ[gepj
;-----------------------------------------------------------------------
project		TXY
		LDX	<register		;W
		SEP	#00100000B
		MEM8
		LDA	#dsp_project		;B
		STA	!DSP_data		;B
		REP	#00100000B
		MEM16
		LDA	<_situationXL,X		;W
		STA	<work
		LDA	<_situationXH,X		;W
		ASL	<work
		ROL	A
		ASL	<work
		ROL	A
		STA	!DSP_data		;W
;
		LDA	<_situationYL,X		;W
		STA	<work
		LDA	<_situationYH,X		;W
		ASL	<work
		ROL	A
		ASL	<work
		ROL	A
		STA	!DSP_data		;W
;
		LDA	#0
		STA	!DSP_data		;W
		STZ	<attribute		;W
		TYX
		INX
		INX
		JMP	(!0,X)
;-----------------------------------------------------------------------
;		yʒuZo
;-----------------------------------------------------------------------
project_Z	TXY
		LDX	<register		;W
		SEP	#00100000B
		MEM8
		LDA	#dsp_project		;B
		STA	!DSP_data		;B
		REP	#00100000B
		MEM16
		LDA	<_situationXL,X		;W
		STA	<work
		LDA	<_situationXH,X		;W
		ASL	<work
		ROL	A
		ASL	<work
		ROL	A
		STA	!DSP_data		;W
;
		LDA	<_situationYL,X		;W
		STA	<work
		LDA	<_situationYH,X		;W
		ASL	<work
		ROL	A
		ASL	<work
		ROL	A
		STA	!DSP_data		;W
;
		LDA	<_situationZL+1,X	;W
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		CLC
		ADC	#1111111000000000B
		EOR	#1111111000000000B
		STA	!DSP_data		;W
;;
		STZ	<attribute		;W
;;
		TYX
		INX
		INX
		JMP	(!0,X)
;***********************************************************************
;		DSP -> screen H,V position ( VS upper )
;***********************************************************************
VH_mycar	EQU	06680H		; position H, position V
V_mycar		EQU	0FF66H		;
H_center	EQU	0FF80H		;
mycar_offset	EQU	0FF00H		;
;mycar_distance	EQU	0F8H		;
mycar_distance	EQU	108H		;
max_distance	EQU	0300H		;
;-----------------------------------------------------------------------
;	`	fBXvCZbg
;-----------------------------------------------------------------------
screen_AZ
screen_A	TXY
		BIT	<player_index+0
		BPL	A_nomal_mode
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;	obN~[[hʕ\
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
A_back_mode
		LDX	<register
		CLC
		LDA	>DSP_status
		BPL	$-4
		LDA	#H_center+80H		;
		ADC	!DSP_data		; <----- DSP
		EOR	#0FFFFH
		SEC
		SBC	#80H-1
		STA	<position_H		;
		STA	<_posH_A,X		; screen position (H)
		BRA	skip_Amode
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;	ʏ탂[hʕ\
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
A_nomal_mode	LDX	<register
A_entry		CLC
		LDA	>DSP_status
		BPL	$-4
		LDA	#H_center		;
		ADC	!DSP_data		; <----- DSP
		STA	<position_H		;
		STA	<_posH_A,X		; screen position (H)
;
skip_Amode	CLC
		LDA	#mycar_offset		;
		ADC	<camera_raster+0	;  center V
		ADC	!DSP_data		; <----- DSP
		STA	<position_V		;
		STA	<_shadow_A,X		; shadow position (V)
		STA	<_posV_A,X		; screen position (V)
;
		LDA	!DSP_data		; <----- DSP
		CMP	#max_distance		;
		STA	<size			;
		STA	<_distance_A,X		;
		BCS	screen_outA1	;(CLC)
;
		LDA	<position_V	;W 0FEE0 < Y < FFA0
		ADC	#00120H	
		CMP	#000C0H	
		BCS	screen_outA2	;(CLC)
		LDA	<position_H	; 0FEF0 < X < 0010
		ADC	#00110H
		CMP	#00120H		
		BCS	screen_outA2
;- - - - - - - - - - - - - -- - - - - - - - - - - - - - - - - - -
		LDA	!obj_count_A		; OAM SET ON
		CMP	!obj_limit
		BCS	screen_outA1
		INC	A
		STA	!obj_count_A
		TYX				;WW
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - -- - - - - - - - - - - - - - - - - - -
screen_outA1	
		LDA	#min_patern
		STA	<_ptn_A,X
screen_outA2	RTS

;***********************************************************************
;		VS project -> screen ( VS under )
;***********************************************************************
;-----------------------------------------------------------------------
;	a	fBXvCZbg
;-----------------------------------------------------------------------
screen_BZ
screen_B	TXY
		BIT	<player_index+2
		BPL	B_nomal_mode
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;	obN~[[hʕ\
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
B_back_mode
		LDX	<register		;
		LDA	<_shadow_B,X		;
		STA	<_shadow_BX,X		; backup frame 
		LDA	<_posH_B,X		;
		STA	<_posH_BX,X		; backup frame
		CLC
		LDA	>DSP_status
		BPL	$-4
		LDA	#H_center+80H		;
		ADC	!DSP_data		;
		EOR	#0FFFFH
		SEC
		SBC	#80H-1
		STA	<position_H		;
		STA	<_posH_B,X		; screen position (H)
		BRA	B_mode_skip
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;	ʏ탂[hʕ\
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
B_nomal_mode	LDX	<register		;
B_entry		LDA	<_shadow_B,X		;
		STA	<_shadow_BX,X		; backup frame 
		LDA	<_posH_B,X		;
		STA	<_posH_BX,X		; backup frame
		CLC
		LDA	>DSP_status
		BPL	$-4
		LDA	#H_center		;
		ADC	!DSP_data		;
		STA	<position_H		;
		STA	<_posH_B,X		; screen position (H)
;
B_mode_skip	CLC
		LDA	#mycar_offset
		ADC	<camera_raster+2
		ADC	!DSP_data		;
		STA	<position_V		;
		STA	<_shadow_B,X		; shadow position (V)
		STA	<_posV_B,X		; screen position (V)

		LDA	!DSP_data		;
		CMP	#max_distance		;
		STA	<size			;
		STA	<_distance_B,X		;
		BCS	screen_outB1
		TYX
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
screen_outB1	LDA	#min_patern
		STA	<_ptn_B,X
screen_outB2	RTS
;***********************************************************************
;		JUMP SHADOW
;***********************************************************************
jumpset_A	TXY
		LDX	<register
		LDA	<_situationZL+1,X	;W	Z position
		BEQ	jumpA_exit
		SEP	#00100000B
		MEM8
		LDA	#dsp_multiply		;B
		STA	!DSP_data		;B
		REP	#00100000B
		MEM16
		LDA	<_situationZL+1,X	;W	Z position
		STA	!DSP_data		;W
		LDA	<_distance_A,X		;W	distance
		ASL	A
		STA	!DSP_data		;W
		SEC
		LDA	<_posV_A,X		;W	V paos
		SBC	!DSP_data		;W
		STA	<position_V		;W	V pos
		STA	<_posV_A,X		;W	shadow V pos
jumpA_exit	TYX
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
jumpset_B	TXY
		LDX	<register
		LDA	<_situationZL+1,X	;W	Z position
		BEQ	jumpB_exit
		SEP	#00100000B
		MEM8
		LDA	#dsp_multiply		;B
		STA	!DSP_data		;B
		REP	#00100000B
		MEM16
		LDA	<_situationZL+1,X	;W	Z position
		STA	!DSP_data		;W
		LDA	<_distance_B,X		;W	distance
		ASL	A
		STA	!DSP_data		;W
		SEC
		LDA	<_posV_B,X		;W	V paos
		SBC	!DSP_data		;W
		STA	<position_V		;W	V pos
		STA	<_posV_B,X		;W	shadow V pos
jumpB_exit	TYX
		INX
		INX
		JMP	(!0,X)
;***********************************************************************
;		SCREEN CHECK
;***********************************************************************
		ext	index_bit

;- - - - - - - - - - - - - - - - - - - - - - -
disp_OFF_X	RTS
disp_A_shadow	TXY
		LDX	<register
;
		lda	<_obake_timer,x
		bne	disp_OFF_X

		lda	<event_index,x
		tax
		lda	!index_bit,x
		and	#1011100B		; 6,8
		bne	disp_OFF_X
;
		ldx	<register
		LDA	<_situationZL+1,X
		BEQ	disp_OFF_X

		LDA	<_distance_A,X
		CMP	#max_distance
		BCS	disp_OFF_X	;(CLC)
		STA	<size
		LDA	<_shadow_A,X
		STA	<position_V	;W 0FEE0 < Y < FFA0
		ADC	#00120H
		CMP	#000C0H
		BCS	disp_OFF_X	;(CLC)
		LDA	<_posH_A,X
		STA	<position_H	; 0FEF0 < X < 0010
		ADC	#00110H
		CMP	#00120H
		BCS	disp_OFF_X
		TYX
		INX
		INX
		JMP	(!0,X)
;---------------------------------------------------------------------
disp_B_check	TXY
		LDX	<register
		LDA	<_distance_B,X
		CMP	#max_distance
		BCS	disp_OFF	;(CLC)
		STA	<size
		LDA	<_posV_B,X
		STA	<position_V	; 0FF60 < Y < 0020
		ADC	#000A0H
		CMP	#000C0H		
		BCS	disp_OFF	;(CLC)
		LDA	<_posH_B,X
		STA	<position_H	; 0FEE0 < X < 0010
		ADC	#00110H
		CMP	#00120H		
		BCS	disp_OFF
		LDA	!obj_count_B
		CMP	!obj_limit
		BCS	disp_OFF_B
		INC	A
		STA	!obj_count_B
		TYX
		INX
		INX
		JMP	(!0,X)
;---------------------------------------------------------------------
disp_B_shadow	TXY
		LDX	<register
;
		lda	<_obake_timer,x
		bne	disp_OFF
;
		lda	<event_index,x
		tax
		lda	!index_bit,x
		and	#1011100B		; 6,8
		bne	disp_OFF
;
		ldx	<register
		LDA	<_situationZL+1,X
		BEQ	disp_OFF

		LDA	<_distance_B,X
		CMP	#max_distance
		BCS	disp_OFF	;(CLC)
		STA	<size
		LDA	<_shadow_BX,X
		STA	<position_V	; 0FF60 < Y < 0020
		ADC	#000A0H
		CMP	#000C0H		
		BCS	disp_OFF	;(CLC)
		LDA	<_posH_BX,X
		STA	<position_H	; 0FEE0 < X < 0010
		ADC	#00110H
		CMP	#00120H	
		BCS	disp_OFF
		TYX
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
disp_OFF	rts
disp_OFF_B	bit	<_status,x	; J[gH
		bmi	disp_OFF
		lda	#min_patern
		sta	<_ptn_B,X
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
;
;
;***********************************************************************
;	XvCg\̂ƃvO鎞
;***********************************************************************
;	dw	*setobj,*objset_program,*next_program
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
setobj		PHX
		LDY	2,X		; OAM set address
		TYX
		JSR	(!0,X)		; OAM set
		PLX
		INX			
		INX
		INX
		INX
		JMP	(!0,X)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
;
;***********************************************************************
;	}bvJ[gpp[`@
;***********************************************************************
		glb	map_screen_A
		glb	map_screen_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
map_screen_A	ldx	<register		;
		clc
		LDA	>DSP_status
		BPL	$-4
		lda	#H_center+10h		;
		adc	!DSP_data		;
		sta	<_posH_A,x		; screen position (H)
		clc
		lda	#mycar_offset-19h
		adc	<camera_raster+0
		adc	!DSP_data		;
		sta	<_posV_A,x		; screen position (V)
		lda	!DSP_data		;
		sta	<_distance_A,x		;
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
map_screen_B	ldx	<register
		clc
		LDA	>DSP_status
		BPL	$-4
		lda	#H_center+10h		;
		adc	!DSP_data		;
		sta	<_posH_B,x		; screen position (H)
		clc
		lda	#mycar_offset-19h
		adc	<camera_raster+2
		adc	!DSP_data		;
		sta	<_posV_B,x		; screen position (V)
		lda	!DSP_data		;
		sta	<_distance_B,x		;
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		END
