;*********************************************************************
;	mario kart << OBJ control system >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/effect.def
;----------------------------------------------------------------------
		GLB	Erase_sprite,Remove_object,Remove_item
		GLB	Connect_A,Connect_B,Connect_item
		GLB	Mount_A,Mount_B
		GLB	Init_object,Mount_object,Mount_pipe
		GLB	subst,subst_next,magna_shadowA,magna_shadowB
		GLB	magna,attre,ret
		GLB	trans_A,trans_B	
		GLB	trans_Amy,trans_Bmy	
;----------------------------------------------------------------------
		glb	check_mode_A,check_mode_B
;----------------------------------------------------------------------
		COMN
work		DS	2
temporary	DS	2
pointer		DS	2
ptn_work	DS	2
zoom_addr	DS	2
;----------------------------------------------------------------------
		EXTEND
objprog	SECT	REL
		mem16
		idx16
;*********************************************************************
;		OBJ control initial
;*********************************************************************
Init_object	LDY	#A_root			;W (reset pointer)
		STY	<A_backward		;W
		STY	<A_forward		;W
		LDY	#B_root			;W
		STY	<B_backward		;W
		STY	<B_forward		;W
		LDY	#pipe_A_root
		STY	<pipe_A_backward	;W
		STY	<pipe_A_forward		;W
		LDY	#pipe_B_root
		STY	<pipe_B_backward	;W
		STY	<pipe_B_forward		;W
;;
		LDY	#item_root
		STY	!_item_backward+item_root
		STY	!_item_forward+item_root
;;
		RTS
;*********************************************************************
;		OBJ mount
;*********************************************************************
Mount_B		BEQ	mount_B_exit
		PHY				;>>
		LDY	#B_root			
		STA	<_object_B,X
		JSR	Connect_B
		PLY				;<<
mount_B_exit	RTL
Mount_A		BEQ	mount_A_exit
		PHY				;>>
		LDY	#A_root
		STA	<_object_A,X
		JSR	Connect_A
		PLY				;<<
mount_A_exit	RTL
;-----------------------------------------------------------------------
Connect_B	PHY				;>>
		LDA	!_forward_B,Y		; read(for)
		STX	<_forward_B,Y		; write
		TAY
		LDA	!_backward_B,Y		; read(back)
		STX	<_backward_B,Y		; write
		STA	<_backward_B,X		; write(new)
		STY	<_forward_B,X		; write(new)
		PLY				;<<
		RTS
;-----------------------------------------------------------------------
Connect_A	PHY				;>>
		LDA	!_forward_A,Y		; read(for)
		STX	<_forward_A,Y		; write
		TAY
		LDA	!_backward_A,Y		; read(back)
		STX	<_backward_A,Y		; write
		STA	<_backward_A,X
		STY	<_forward_A,X
		PLY				;<<
		RTS
;-----------------------------------------------------------------------
Mount_object	LDY	<B_forward		;W
		LDA	!_forward_B,Y		;W
		STX	<_forward_B,Y		;W
		STY	<_backward_B,X		;W
		TAY				;WW
		STY	<_forward_B,X		;W
		STX	<_backward_B,Y		;W
		LDY	<A_forward
Mount_pipe					; Y <- root_foward
		LDA	!_forward_A,Y		;W
		STX	<_forward_A,Y		;W
		STY	<_backward_A,X		;W
		TAY				;WW
		STY	<_forward_A,X		;W
		STX	<_backward_A,Y		;W
		RTL
;*********************************************************************
;		CLEAR sprite system
;*********************************************************************
Remove_object	PHX
remove		LDA	(<_object_A,X)
		TAY
		LDA	!0,Y			;W
		STX	<0,Y			;W
		LDY	<_backward_A,X		;W
		STA	<_backward_A,X		;W
		LDA	<_forward_A,X		;W
		TAX				;WW
		STY	<_backward_A,X		;W
		STX	<_forward_A,Y		;W
		BRA	erase_skip
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;	JAoii߂̃[`
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Erase_sprite	PHX				;>>
		LDY	<_backward_A,X		; Ascreen erase
		LDA	<_forward_A,X		;
		TAX				;
		STY	<_backward_A,X		;
		STX	<_forward_A,Y		;
;
erase_skip	PLX				;<<
		LDA	<_status,X
		ASL	A
		PHX				;>>
		LDY	<_backward_B,X		; Bscreen erase
		LDA	<_forward_B,X		;
		TAX				;
		STY	<_backward_B,X		;
		STX	<_forward_B,Y		;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		PLX				;<<
		BCC	exit$
;- - - - - - - - - - - - - - - - - - - - - - - -
		STZ	<_status,X		; S[XgG[
		LDY	<_item_backward,X	; pointer erase
		LDA	<_item_forward,X	;
		TAX				;
		STY	<_item_backward,X	;
		STX	<_item_forward,Y	;		
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
exit$		RTL
;*********************************************************************
;		sub structure
;*********************************************************************
;subst		STRUCT	{subst,*object}
;-----------------------------------------------------------------------
subst		TXY				;WW
		LDX	2,Y			;W
		JMP	(!0,X)
;*********************************************************************
;		sub structure
;*********************************************************************
;subst		STRUCT	{subst,*object}
;-----------------------------------------------------------------------
subst_next	PHX
		TXY				;WW
		LDX	2,Y			;W
		JSR	(!0,X)
		PLX
		INX
		INX
		INX
		INX
		JMP	(!0,X)
;***********************************************************************
;		Chenge Attribute
;***********************************************************************
;attre		STRUC	{attre,[ ,]}
;flipH		STRUC	{flip_H,[ ,]}
;flipV		STRUC	{flip_V,[ ,]}
;-----------------------------------------------------------------------
attre		TXY				;WW
		LDX	<register		;W
		LDA	<_attribute,X		;W
		STA	<attribute		;W
		TYX				;WW
		INX
		INX
		JMP	(!0,X)
;***********************************************************************
;		Magnify
;***********************************************************************
;magna		STRUC	{magna,*size,*object[, ]}
;-----------------------------------------------------------------------
		MEM16
magna		STX	<temporary		;W
		LDA	2,X			;W
		STA	<pointer		;W
		LDY	#0			;W
		LDA	<size			;W
magna_find	CMP	(<pointer),Y		;W
		INY				;W
		INY				;W
		BCC	magna_find
		TYA				;WW SEC
		ADC	<temporary		;W
		TAY				;WW = 2,Y
		LDX	1,Y			;W
		JMP	(!0,X)
;***********************************************************************
;		Magnify
;***********************************************************************
		MEM16
magna_shadowB	LDY	<register
		LDA	!_trans_ptn_B,Y
		BRA	entry_shadow
magna_shadowA	LDY	<register
		LDA	!_trans_ptn_A,Y
;		+++++++++FEDCBA9876543210+++
entry_shadow	AND	#0000000111100000B
		LSR	A
		LSR	A
		LSR	A
		LSR	A		;(CLC)
		ADC	2,X
		TAY
		LDX	0,Y
		JMP	(!0,X)
;***********************************************************************
;		J[g̓]p[^Zbg
;***********************************************************************
;---------------------------------------------------------------------
;	Â]AhXɂĂn`lZbge[uWv
;---------------------------------------------------------------------
B_oamset	INX
		INX
A_oamset	LDA	<_trans_ptn_A,x	; n`lZbgpp^
		BPL	skip$
		TAY
		LDA	#04000H		; E]
		TSB	<attribute
		TYA
		AND	#07FFFH
skip$		CLC
		ADC	<temporary	; data address 
		TAY
		LDX	0,Y		;
		JMP	(!0,X)
;= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =

;
;---------------------------------------------------------------------
;		Uf[^
;---------------------------------------------------------------------
;; kubi_data						; 42 MAX 42H stop
		DW	0160H,0160H,0160H,0160H,0160H	; 38
		DW	8160H,8160H,8160H,8160H,8160H	; 2C
		DW	0160H,0160H,0160H,0160H		; 24
		DW	8160H,8160H,8160H,8160H		; 1C
kubi_data	DW	0160H,0160H,0160H		; 16
		DW	8160H,8160H,8160H		; 10
		DW	0160H,0160H			; C
		DW	8160H,8160H			; 8
		DW	0160H,0160H			; 4
		DW	8160H,8160H			; 0   (40H loss)
		DW	0160H,0160H			;     (42H loss)
;---------------------------------------------------------------------
;		ynnl f[^
;---------------------------------------------------------------------
zoom_param	DW	0000H,0020H
zoom_param_1	DW	0040H,0060H
zoom_param_2	DW	0080H,00A0H
		DW	00C0H,00E0H
		DW	0100H,0120H
		DW	0140H,0140H
		DW	0140H,0140H
		DW	0140H,0140H
		DW	0140H,0140H

;---------------------------------------------------------------------
;
;************** `	**********************************************
;
;---------------------------------------------------------------------
;	V]p^[̃f[^ ( vZJ[gp )
;---------------------------------------------------------------------
trans_A	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	2,X			;W 
		STA	<temporary		;W
		LDA	4,X			;W
		STA	<pointer		;W
;- - - - - - - - - - - - - - - - - - - - - - - ;(zoom check)--------
		LDY	#-2			;
		LDA	<size			;
zoom_loop$	INY				;
		INY				;
		CMP	(<pointer),Y		;
		BCC	zoom_loop$
;- - - - - - - - - - - - - - - - - - -
		ldx	<register
		lda	<_sunder_timer,x
		beq	skip$
		jsr	sunder_trans
skip$
;- - - - - - - - - - - - - - - - - - - - - - -  ;(poseQ setting) -----
		LDA	<_poseQ,X		; LN^[̐Ίpx
		SEC
		SBC	<A_pose_Q		; J̐Ίpx
		BPL	pose_skip0$
		AND	#0111100000000000B
		EOR	#0111100100000000B	; top bit 1
		XBA
		LSR	A			;(SEC)
		BRA	pose_skip1$
pose_skip0$	AND	#7800H
		XBA
		LSR	A			;(CLC)
pose_skip1$	ROR	A			;(CLC)
		ADC	!zoom_param,Y
;- - - - - - - - - - - - - -  - - - - - - - - - - - 
		BIT	#7FFFH
		BNE	set$
		JSR	ptn_check		; p^[
set$
		EOR	!ptn_flip+0		; obN~[
		STA	<_ptn_A,x
;- - - - - - - - - - - - - -  - - - - - - - - - -  
		JMP	A_oamset
;- - - - - - - - - - - - - - - - - - - - - - - -  
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;	GԂ̂ӂނ
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
ptn_check
ptn_enemy	lda	<_kart_pose+0,x
		bpl	exit$
		bit	#11100000b
		bne	exit$
		and	#00011000b
		lsr	a
		lsr	a
		tay	
		lda	!pose_data,y
		bit	<_kart_pose+0,x		; Eɂӂނ
		bvc	skip$
		ora	#8000h	
skip$		rts
exit$		lda	#0
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - -






;- - - - - - - - - - - - - -  - - - - - - - - - - - 
sunder_trans	bmi	chbi$
		cmp	#D_sunder_timer-D_sunder_nomal ; ( 80h )
		bcc	skip$
		cmp	#D_sunder_nomal			; ( 400h )
		bcs	skip$
chbi$		tya
		clc
		adc	#8		; +8
		tay
		rts
skip$		clc
		and	#008h
		beq	chbi$
		iny			; +4
		iny
		iny
		iny
exit$		rts
;- - - - - - - - - - - - - -  - - - - - - - - - - - 
;
;
;
;
;
;
chibi_size	
		DW	400H	; -	zoom size 0	;00
		DW	400H	; -37FH	zoom size 1	;02
		DW	400H	; -2FFH	zoom size 2	;04
		DW	400H	; -27FH	zoom size 3	;06
		DW	0E0H	; -1FFH	zoom size 4	;08
		DW	0C0H	; -1BFH	zoom size 5	;0A
		DW	0A0H	; -17FH	zoom size 6	;0C
		DW	080H	; -13FH	zoom size 7	;0E
		DW	050H	; -0FFH	zoom size 8	;10
		DW	020H	; -0BFH	zoom size 9	;12
		DW	0	; -07FH	zoom size A	;14
				; min distance	= 50H-60H
;
;
;
;
;---------------------------------------------------------------------
;	}CJ[gp][` ( ŒJ[gp )
;---------------------------------------------------------------------
trans_Amy
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		LDA	2,X			;W
		STA	<temporary		;W
		LDA	4,X			;W
		STA	<pointer		;W
;- - - - - - - - - - - - - - - - - - - - - - - ;(zoom check)--------
		LDY	#-2			;W
		LDA	<size			;W
tA_loop		INY				;W
		INY				;W
		CMP	(<pointer),Y		;W
		BCC	tA_loop
;- - - - - - - - - - - - - - - - - - - - - - -  ;(poseQ setting) -----
		LDX	<register	
		lda	<_sunder_timer,x
		beq	skipX$
		jsr	sunder_trans
skipX$
;- - - - - - - - - - - - - - - - - -
		lda	<_fall,x		; ΂
		beq	skip$
		lda	#2000h
		tsb	<attribute
;- - - - - - - - - - - - - - - - - -
skip$		LDA	<_poseQ,X		; LN^[̐Ίpx
		SEC
		SBC	<A_pose_Q		; J̐Ίpx
		BPL	AQ_100
		AND	#0111100000000000B
		EOR	#0111100100000000B	; top bit 1
		XBA
		LSR	A			;(SEC)
		BRA	AQ_110
AQ_100		AND	#7800H
		XBA
		LSR	A			;(CLC)
AQ_110		ROR	A			;(CLC)
AQ_zoom		ADC	!zoom_param,y
;- - - - - - - - - - - - - -  - - - - - - - - - - - 
		BIT	#7FFFH
		BNE	AQ_120
		JSR	A_special_patern	; p^[
;- - - - - - - - - - - - - -  - - - - - - - - - - - 
AQ_120		EOR	!ptn_flip+0		; obN~[
skip0$		sta	<_ptn_A,x
;- - - - - - - - - - - - - -  - - - - - - - - - - - 
		tay
		lda	<_kart_char_A,x		; p^[tO
		bpl	skip$
		jsr	Set_VLpose		; p^[Zbg
		sta	<_ptn_A,x
skip$
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		jmp	A_oamset
;- - - - - - - - - - - - - - - - - - - - - - - - - 
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;************* ]p^[ **************************************
;---------------------------------------------------------------------
;	u/knrs |[YAj[VTu[`
;---------------------------------------------------------------------
special_pose	dw	special_win
		dw	special_lost
		dw	special_cong
		dw	special_burn
;- - - - - - - - - - - - - - - - - - - - - -
Set_VLpose	sty	<ptn_work
		txy
		asl	a
		tax
		jmp	(!special_pose,x)
;- - - - - - - - - - - - - - - - - - - - - -
special_lost	lda	!spin_counter,y
		cmp	#300h			; ŏ]p[^
		bcc	skip$
		tyx
		lda	<ptn_work
		rts

skip$						;<< Xg|[Yf
;- - - - - - - - - - - - - - - - - - - - - -
		lda	!Vpose_counter,x	; counter read
		inc	!Vpose_counter,x	; data (+1)
		bit	#010000000b
		beq	lost$
		and	#001111000b
		lsr	a
		lsr	a	
		tax		
		lda	!lost_character,x
		bra	special_exit

lost$		lda	#0168h
		bra	special_exit
;- - - - - - - - - - - - - - - - - - - - - -
special_win	lda	!Vpose_counter,x	;   u|[Yf
		inc	a
		sta	!Vpose_counter,x
		and	#010000B
		beq	skip$
		lda	VL_data1,x
		bra	special_exit
skip$		lda	VL_data2,x
		bra	special_exit
;- - - - - - - - - - - - - - - - - - - - - -
lost_character	
		dw	0000h,0000h,0000h,0000h
		dw	0000h,0162h,0164h,0164h
		dw	0164h,0164h,0164h,0164h
		dw	0164h,0164h,0162h,0000h

VL_data1	dw	166H,168H
VL_data2	dw	1EH,00H
;- - - - - - - - - - - - - - - - - - - - - -
special_cong	lda	<ptn_work
		and	#07fffh
		cmp	#0001eh
		bne	special_restore
		lda	#0166h
		bra	special_exit
;- - - - - - - - - - - - - - - - - - - - - -
special_burn	lda	#16ah			;ԂL
		bra	special_exit
;- - - - - - - - - - - - - - - - - - - - - -
special_restore	lda	<ptn_work
special_exit	tyx
		rts
;---------------------------------------------------------------------
;	ȃLN^[|[ỸZbg
;---------------------------------------------------------------------
A_special_patern
		LDA	<_anime_timer,X		; U蒆H
		BNE	entry_kubi		; yes -> 

		LDA	<kart_status,X		; 
		BIT	#ON_kubifuri
		BEQ	AQ_skip

		AND	#(ON_kubifuri^0FFFFH)
		STA	<kart_status,X
		LDA	#040H-20-16		; U
		STA	<_unable_control,X
;------------------------------------------------------------------
entry_kubi	DEC	A
		STA	<_anime_timer,X
		AND	#0FFFEH
		TAY
		LDA	!kubi_data,Y
		BRA	AQ_exit
;------------------------------------------------------------------
AQ_skip		LDA	<_trans_ptn_A,X
		ASL	A
		BEQ	AQ_tr
		CMP	#160H*2
		BCC	AQ_clear
AQ_tr		LDA	<_kart_pose+0,X
		BPL	AQ_2200
		BIT	#11100000B
		BNE	AQ_2150
		AND	#00011000B
		LSR	A
		LSR	A
		TAY
		LDA	!pose_data,Y
		BIT	<_kart_pose+0,X
		BVC	AQ_2100
		ORA	#8000H
AQ_2100		INC	<_kart_pose+0,X		; timer inc
		BRA	AQ_exit			; side face
;------------------------------------------------------------------
pose_data	DW	162H,164H,164H,162H
;------------------------------------------------------------------
AQ_2150		INC	A			; timer inc
		STA	<_kart_pose+0,X
		BIT	#10000000B		
		BEQ	AQ_2200			; nomal face
AQ_clear	STZ	<_kart_pose+0,X		; reset	
;------------------------------------------------------------------
AQ_2200		cpx	<player_index+0
		bne	AQ_enemycar
		lda	<_situationZL+1,x
		bne	AQ_enemycar

;------------------------------------------------------------------
;	nh̒			
;------------------------------------------------------------------
handle_calc	clc
		lda	<_kart_handle,x
		beq	AQ_exit		; = 0 nhm[}
		bpl	skip$
		eor	#0ffffh
		inc	a
		sec			; ŏʂ flip
skip$		and	#000110b	; = 1fh		
		tay
		php
		lda	<_vF,x
		cmp	#0200h
		bcs	skip1$
		lda	!kata_data2,y
		bra	skip2$
skip1$		lda	!kata_data,y
skip2$		plp
		ror	a
		rts
AQ_enemycar	lda	#0
AQ_exit		rts
;------------------------------------------------------------------
;			1-------2,3------4,5-----6,7--
kata_data	dw	0160h*2,0160h*2,0160h*2,0002h*2
;			1-------2,3------4,5-----6,7--
kata_data2	dw	0160h*2,0160h*2,0160h*2,0160h*2
;------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;************** a	**********************************************
;
;---------------------------------------------------------------------
;		V]p^[̃f[^
;---------------------------------------------------------------------
trans_B		lda	2,X
		sta	<temporary
		lda	4,X			;W 
		sta	<pointer		;W
;- - - - - - - - - - - - - - - - - - - - - - - ;(zoom check)--------
		LDY	#-2			;W
		LDA	<size			;W
zoom_loop$	INY				;W
		INY				;W
		CMP	(<pointer),Y		;W
		BCC	zoom_loop$		;W
;- - - - - - - - - - - - - - - - - - - - - - -  ;(poseQ setting) -----
		LDX	<register		;W
		lda	<_sunder_timer,x
		beq	skip$
		jsr	sunder_trans
skip$
		LDA	<_poseQ,X		;LN^[̐Ίpx
		SEC
		SBC	<B_pose_Q		;J̐Ίpx
		BPL	pose_skip0$
		AND	#0111100000000000B
		EOR	#0111100100000000B	; top bit 1
		XBA
		LSR	A			;(SEC)
		BRA	pose_skip1$
pose_skip0$	AND	#7800H
		XBA
		LSR	A			;(CLC)
pose_skip1$	ROR	A			;(CLC)
		ADC	!zoom_param,Y
		BIT	#7FFFH
		BNE	set$
		JSR	ptn_check		; ӂނ`FbN
set$		EOR	!ptn_flip+2
		STA	<_ptn_B,X		;W
;- - - - - - - - - - - - - - - - - - - - 
		JMP	B_oamset

;---------------------------------------------------------------------
;		V]p^[̃f[^
;---------------------------------------------------------------------
trans_Bmy	lda	2,X
		sta	<temporary
		LDA	4,X			;W
		STA	<pointer		;W
;- - - - - - - - - - - - - - - - - - - - - - - ;(zoom check)--------
		LDY	#-2			;W
		LDA	<size			;W
magna_loop	INY				;W
		INY				;W
		CMP	(<pointer),Y		;W
		BCC	magna_loop
;- - - - - - - - - - - - - - - - - - - - - - -  ;(poseQ setting) -----
		LDX	<register		;W
		lda	<_sunder_timer,x
		beq	skipX$
		jsr	sunder_trans
skipX$
;- - - - - - - - - - - - - - - - - -
		lda	<_fall,x
		beq	skip$
		lda	#2000h
		tsb	<attribute
;- - - - - - - - - - - - - - - - - -
skip$
		LDA	<_poseQ,X		;LN^[̐Ίpx
		SEC
		SBC	<B_pose_Q		;J̐Ίpx
		BPL	BQ_100
		AND	#0111100000000000B
		EOR	#0111100100000000B	; top bit 1
		XBA
		LSR	A		;(SEC)
		BRA	BQ_110
BQ_100		AND	#7800H
		XBA
		LSR	A		;(CLC)
BQ_110		ROR	A		;(CLC)
		ADC	!zoom_param,Y
		BIT	#07FFFH
		BNE	BQ_120
		JSR	B_special_patern
BQ_120		EOR	!ptn_flip+2
		STA	<_ptn_B,X		;W
;- - - - - - - - - - - - - - - - - - - - 
		tay
		lda	<_kart_char_B,X
		bpl	skip$
		jsr	Set_VLpose
		sta	<_ptn_B,x
;- - - - - - - - - - - - - - - - - - - - 
skip$		JMP	B_oamset
;- - - - - - - - - - - - - - - - - - - - 
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;
;************* ]p^[ **************************************
;---------------------------------------------------------------------
;	ȃLN^[|[ỸZbg
;---------------------------------------------------------------------
B_special_patern
		LDA	<_anime_timer,X
		BNE	B_entry_kubi
		LDA	<kart_status,X
		BIT	#ON_kubifuri
		BEQ	BQ_skip
		AND	#(ON_kubifuri^0FFFFH)
		STA	<kart_status,X
		LDA	#040H-20-16
		STA	<_unable_control,X
;------------------------------------------------------------------
B_entry_kubi	DEC	A
		STA	<_anime_timer,X
		AND	#0FFFEH
		TAY
		LDA	!kubi_data,Y
		BRA	BQ_exit
;------------------------------------------------------------------
BQ_skip		LDA	<_trans_ptn_B,X
		ASL	A
		BEQ	BQ_tr
		CMP	#160H*2
		BCC	BQ_clear
BQ_tr		LDA	<_kart_pose+0,X
		BPL	BQ_2200
		BIT	#11100000B
		BNE	BQ_2150
		AND	#00011000B
		LSR	A
		LSR	A
		TAY
		LDA	!pose_data,Y
		BIT	<_kart_pose+0,X
		BVC	BQ_2100
		ORA	#8000H
BQ_2100		INC	<_kart_pose+0,X		; timer inc
		BRA	BQ_exit			; side face
;------------------------------------------------------------------
BQ_2150		INC	A			; timer inc
		STA	<_kart_pose+0,X
		BIT	#10000000B
		BEQ	BQ_2200			; nomal face
BQ_clear	STZ	<_kart_pose+0,X		; reset
;------------------------------------------------------------------
;|[Ỹ`FbN
;- - - - - - - - - - - - - - - -
BQ_2200		cpx	<player_index+2	
		bne	BQ_enemycar
		lda	<_situationZL+1,x
		bne	BQ_enemycar
		jmp	handle_calc		; nhvZ
BQ_enemycar	lda	#0
BQ_exit		rts
;***********************************************************************
;		return system
;***********************************************************************
ret		RTS
;***********************************************************************
;		OFFSET SET
;***********************************************************************
offsetobj	CLC
		LDA	2,X
		ADC	<position_V
		STA	<position_V
		TXY
		LDX	4,Y
		JMP	(!0,X)
;***********************************************************************
;		OFFSET SET
;***********************************************************************
Connect_item	LDA	!_item_forward,Y	; read(for)
		STX	<_item_forward,Y	; write
		TAY
		LDA	!_item_backward,Y	; read(back)
		STX	<_item_backward,Y	; write
		STA	<_item_backward,X	; write(new)
		STY	<_item_forward,X	; write(new)
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - -
Remove_item	LDY	<_item_backward,X	; Ascreen erase
		LDA	<_item_forward,X	;
		TAX				;
		STY	<_item_backward,X	;
		STX	<_item_forward,Y	;
		RTS
;***********************************************************************
;		ʃ[h`FbN
;***********************************************************************
check_mode_B	txy
		bit	<player_index+2
		bvs	mode_map
		ldx	<register
		lda	<_distance_B,x
		cmp	!mode_distance
		bcs	mode_erase_B
		lda	!obj_count_B
		cmp	!obj_limit	
		bcs	mode_erase_B
		ldx	!2,y
		jmp	(!0,x)
mode_erase_B	lda	#min_patern
		sta	<_ptn_B,x
		bra	mode_erase
;- - - - - - - - - - - - - - - - - - - -
check_mode_A	txy
		bit	<player_index+0
		bvs	mode_map
		ldx	<register
		lda	<_distance_A,x
		cmp	!mode_distance
		bcs	mode_erase_A
		lda	!obj_count_A
		cmp	!obj_limit		
		bcs	mode_erase_A
		ldx	!2,y
		jmp	(!0,x)
;- - - - - - - - - - - - - - - - - - - -
mode_erase_A	lda	#min_patern
		sta	<_ptn_A,x
mode_erase	lda	<frame_counter-1
		and	#0700h
		ora	#1000h
		cmp	<register
		bne	mode_ret
		ldx	!4,y		; erase
		jmp	(!0,x)
mode_ret	ldx	!6,y		; ret
		jmp	(!0,x)
mode_map	ldx	!8,y		; map screen
		jmp	(!0,x)
;- - - - - - - - - - - - - - - - - - - - -
		END
