;******************* TEST1.asm *************************
			extend
;-----------------------------------------------------
			include		../join/rp5c77
			include		../join/buffer.def
			include		../join/rp5a22
			include     ../join/work.def
			include		../join/label.def
			include		../join/object.def
;-----------------------------------------------------
			glb		TITL_init,TITL_main,TITL_nmi
			glb		Set_DMA,PPU_INT_SET
;
			ext		KEY_CHECK,Init_demokart,Set_demokart
			ext		DMA_demokart,Trigger_sound_1,Random
			ext		BGM_fade_out,Y_iny,X_inx
;----------------------------------------------------
oamdat				equ		200h		
msbdat				equ		400h
window_change		equ		180h
;-----------------------------------------------------
select_flag			equ		80h
window_open			equ		81h
addr				equ		83h
Game_select.flag	equ		85h
Counter_Comp		equ		86h	
Koura_speed			equ		88h
Banana_flag			equ		8ah
Clare_buffer		equ		60h
Flag_swing			equ		73h		;2byte
Swing_count			equ		75h		;2byte
button_TG			equ		6ah		;4byte
;
;
Personal_player		equ		8eh		;<-----fobN
Button_timer		equ		78h
;- - - - - - - - - - - - - - - - - - - - - - -
_demotimer			equ		40h		;2byet
_demoflag			equ		42h		;2byte
_swing_position		equ		44h		;2byte
;-----------------------------------------------------
bankf			sect	rel			;(PBR=03)
;**********************************************************
;			INITIAL ROUTINE
;**********************************************************
;==========================================================
;
TITL_init		EQU		$
				phb
				phk
				plb		
;
				ldy		#OBJ_data2
				JSL		>Init_demokart
;
				mem8
				idx8
				sep		#00110000b
;
				JSR		PPU_INT_SET
				JSR		TENSOU_SET
				JSR		PPU_title
;
				idx16
				mem16
				rep		#00110000b
				JSR		OBJ_ERASE
;
				lda		#3800h
				sta		<Personal_player		;<-----fobN
				stz		<Button_timer
				plb
				RTL
;===========================================================											
;***********************************************************
;				MAIN ROUTINE
;***********************************************************
;===========================================================
;(TITLE SET)
;
TITL_main		EQU		$	
				phb
				phk
				plb		
;
				JSL		>Random
				JSR		KEY_CHECK
;
				mem8
				idx8
				sep		#00110000b
;
				JSR     FLAG_CHECK
;
				lda		<select_flag
				and		#00000111b
				asl		a
				tax
				JMP		(!select_window,x)
;--------------------------------------------
Title_Set		JSR		TITLE_SCROLL
				mem16
				idx16
				rep		#00110000b
				lda		#200h
				sta		<sprite_count
				JSR		OBJ_DEMO
				JSL		>Set_demokart
				mem8
				idx8
				sep		#00110000b
				JMP     owari_M8
;--------------------------------------------
;(MODE SELECT SET)
MODE_0			equ		$
				JSR		WINDOW_SET
				JSR		GAME_SELECT
				JMP		owari_M8
;
MODE_4			equ		$
				JSR		WINDOW_SET
				JSR		ALL.END_CHECK
;
owari_M8		mem16
				idx16
				rep		#00110000b
;
;------------------(t@CifobNp)-------
;
				lda		#8020h
				sta		oamdat+0c0h
				lda     Personal_player
				sta		oamdat+0c2h
				lda		#9020h
				sta		oamdat+0c4h
				lda		world_number
				ora		#3a00h
				sta     oamdat+0c6h
;
				inc		<Button_timer
				lda		<Button_timer
				cmp		#000ch
				bne		sos1			
				stz		<Button_timer
;
				lda     4218h
				cmp		#06c0h
				beq		set_debug
				cmp		#00a0h
				beq		Personal_set
				cmp		#0060h
				bne		sos1
;
				inc		world_number
				lda		world_number
				cmp		#0004
				beq		reset_world
				jmp		sos
reset_world		stz		world_number
sos1			jmp     sos
;
Personal_set	inc		<Personal_player
				inc		<Personal_player
				lda     <Personal_player
				cmp		#3810h
				beq		reset_kart_set
				jmp		sos
reset_kart_set	and		#0ff00h
				sta		Personal_player
				jmp		sos		
;
set_debug		ldx		#0
loop_debug		lda		Test_rank_data,x
				sta		point_rank,x
				inx
				inx
				cpx		#0010h
				bne		loop_debug
;
				ldx		#1000h
				lda		Personal_player
				and		#00ffh
				sta		<driver_number,x
				ldx		#1100h
				lda		#0006h
				sta		<driver_number,x
				ldx		#1200h
  				lda		#000ch
				sta		<driver_number,x
				ldx		#1300h
			lda		#000ch
				sta		<driver_number,x
				ldx		#1400h
				lda		#000ch
				sta		<driver_number,x
				ldx		#1500h
				lda		#000ch
				sta		<driver_number,x
				ldx		#1600h
				lda		#000ch
				sta		<driver_number,x
				ldx		#1700h
				lda		#000ch
				sta		<driver_number,x
;
				lda		#0018h		
				sta		game_selecta		;K-select set.
				lda		#8f00h
				sta		fade_control		;fdadeout set.
;--------------------------------------
sos			plb
				RTL
;
Test_rank_data	DW		1000h,1200h,1300h,1400h
				DW		1500h,1600h,1700h,1100h
;*****************************************;
;				NMI wari komi.			  ;
;*****************************************;
TITL_nmi		equ		$
				phb
				phk
				plb		
;
				mem8
				idx8
				sep		#00110000b
;-------------------------------------------
;(SCLLOR SET)
;
				lda		<back_2h		;BG1 scroll set:low
				sta		>Scroll_1H
;
				lda		<back_2h+1		;BG1 scroll set:Hi
				sta		>Scroll_1H
;--------------------------------------------
				lda		#02
				sta		DMA_synchronic
;
				mem16
				idx16
				rep		#00110000b
;
				JSL		>DMA_demokart
				plb
				RTL
;
;========================================================
;********************************************************
;				CjV@[`
;********************************************************
;=========================================================
;
;**********************************************
;			LN^[@AXN[̓]
;**********************************************
TENSOU_SET		equ		$					
				idx8
				mem8
       		 	lda	 	#80h
       		 	sta    	>Screen_step
;/////////////// BG_1.2 LN^[] //////////////////
   		 	 	ldx		#00h
				jsr		Set_DMA				;character data.
;/////////////// BG1 XN[] ////////////////////////
   			 	ldx		#02h
				jsr     Set_DMA				;character data.
;/////////////// BG2 XN[] ////////////////////////
    		 	ldx		#04h
				jsr     Set_DMA				;character data.
;/////////////// OBJ LN^[] //////////////////////
				ldx		#06
				jsr     Set_DMA
;/////////////// BG3 XN[] ////////////////////////
    		 	lda		#00000000b				;Vram adrr low.
	   		 	sta	   	Screen_address
	   		 	lda		#00011100b				;Vram adrr hi.
	    	 	sta	    Screen_address+1
;
	 	     	idx16						;16bit mode.
	   	     	mem16
	   	     	rep     #00110000b
;
 	 		 	ldx		#0					;character data.
			 	lda		#1c00h
loop9		 	sta		>Screen_write
			 	inx
			 	inx
			 	cpx		#800h				;1000? :no-->lopp1.
			 	bne		loop9
;//////////////// BG_3 LN^[] //////////////////////
	 	 		ldx		#0					;character data.
			 	lda		#00ffh
loop911		 	sta		Screen_write
			 	inx
			 	inx
			 	cpx		#400h				;1000? :no-->lopp1.
			 	bne		loop911
 			 	idx8		       			 ;8bit mode.
			 	mem8
			 	sep		#00110000b
;//////////////// J[] ////////////////////////////////
CG_SET		 	equ		$				;(CG_DATA TENSOU)
			 	idx16		        		;8bit mode.
			 	mem8
			 	rep		#00010000b
;
			 	lda		#00000000b			
				sta		Color_address
;
       		 	ldx		#0
loop5		 	lda		>Title_col,x
			 	sta		Color_write
			 	inx
        	 	lda     >Title_col,x
			 	sta     Color_write
			 	inx
			 	cpx		#200h
			 	bne		loop5
; 
			    idx8
			 	sep		#00010000b
;///////////////// OAM SET /////////////////////////////////	
			 	ldx		#10h
				lda		#54h
				sta     >msbdat,x
				ldx		#08
				lda		#0aah
				sta		>msbdat,x
;
				idx16
			 	mem16
			 	rep		#00110000b
			 	ldx		#0
loop_850	 	lda		OAM,x		
			 	sta		oamdat+100h,x
			 	inx
			 	cmp		#0ffffh
			 	beq		msbset
			 	jmp		loop_850
;
msbset		 	sep		#00110000b
			 	mem8
			 	idx8
			 	rts
;/////////////////// DAM SET //////////////////////////////
Set_DMA			equ		$
				mem8
				lda		#01h			; low,high 2byte
				sta		DMA_0
; 
				lda		#18h			; 2118h
				sta		DMA_0+1
;
				lda		Abus_address,x	
				sta		DMA_0+2
;
				lda		Abus_address+1,x
				sta		DMA_0+3
;
				lda		#7fh
				sta		DMA_0+4
;
				lda		DMA_counter,x			
				sta		DMA_0+5			
				lda		DMA_counter+1,x
				sta		DMA_0+6
;
				lda		Vram_address,x	
				sta		Screen_address
				lda		Vram_address+1,x
				sta		Screen_address+1
				lda		#01h
				sta		DMA_burst
				rts
;-----------------------------------------------------
Abus_address	DW		00000h,02000h,02800h,0a000h
				DW		0c000h,0c800h,0d800h,0ea00h
				DW		03800h,04400h,0f8c0h,00000h
				DW		03800h,0c000h,00000h,04400h
				DW		03c00h,0a400h
;
DMA_counter		DW		2000h,0800h,1000h,2000h
				DW		0800h,0800h,0800h,0500h
				DW		0800h,1000h,0800h,2000h
				DW		0800h,3000h,2800h,0400h
				DW		0800h,1000h
;
Vram_address	DW		0000h,1000h,1400h,4000h
				DW		2400h,2800h,2c00h,3000h
				DW		1000h,0000h,0800h,2000h
				DW      1c00h,0000h,4000h,6000h
				DW		6400h,5800h
;
;**************************************************************
;					PPU &  WORK SET
;**************************************************************
PPU_title		equ		$					
;///////////// y[W@NA[@Zbg //////////////////
				ldx		#0
				lda		#0
loop_NSR		sta		<Clare_buffer,x
				inx
				cpx		#30h
				bne		loop_NSR
;////////// Game_select.flag ̃CjVZbg //////////////
				lda		game_level				
				beq		set_player				;NX`FbN
				lda		#02
				sta		<Game_select.flag		;100cc NX
;
set_player		lda		<game_mode
				bne		set_oneplayer			;vC[`FbN			
;-----------------(lpQ[Zbg)-----------------
				lda		<Game_select.flag
				ora		#01
				sta		<Game_select.flag		;lpQ[Zbg
;
				lda		<game_status
				beq		set_check				;Q[e`FbN
;
				cmp		#02
				beq		vs_set					
;
				lda     <Game_select.flag
				ora     #08
				sta     <Game_select.flag		;battle Zbg.
				jmp		set_check
;
vs_set			lda     <Game_select.flag
				ora     #04
				sta     <Game_select.flag		;VS Zbg.
				jmp     set_check
;-------------------(lpQ[Zbg)---------------------
set_oneplayer	lda     <game_status
				beq		set_check				;Q[e`FbN
				lda		<Game_select.flag
				ora		#10h
				sta		<Game_select.flag		;time attack Zbg
;//////////////// ƃLmR̕\ //////////////////////////////////
set_check		lda		<game_mode
				cmp		#02h
				bcs		Set_PPU					;1player?:yes-->Set_PPU
;
				lda		#01
				sta		<select_flag
				JSR     MOJI_SET				;NOKO set.
;
				stz		<select_flag			;reset flag.
;////////////////// PPU SET ///////////////////////////////////////////
Set_PPU			lda		#00000001b
				sta		Screen_size		;BG mode1 set.
;
				lda		#00010111b
				sta		Through_screen		;TM
;
				lda		#00100010b			;W12SEL
				sta		Window_control		
;
				lda		#00000011b
				sta		Through_window
;
				lda		#00010000b
				sta		Screen_bank
;
				lda		#00010101b
				sta		Screen_bank+1
;
				lda		#00011100b
				sta		Screen_bank+2
;
				lda		#0
				sta		Screen_segment
				lda		#00100010b
				sta		Screen_segment+1
;
				lda		#00000010b			;4000h
				sta		Sprite_size
;
				lda		#10000000b
				sta		Screen_step
;///////////////// H_DMA SET //////////////////////////////////
				lda		#01000001b			;2address set.
				sta		DMA_1
;
				lda		#00100110b			;to 2126h
				sta		DMA_1+1
;
				lda		#10000000b			;from 180h
				sta		DMA_1+2
;
				lda		#00000001b
				sta		DMA_1+3
;
				lda		#0
				sta		DMA_1+4
;
				lda		#0
				sta		DMA_1+5
				sta		DMA_1+6
				lda		#0fh
				sta		DMA_1+7
;////////////////// EChẼf[^[Zbg //////////////////
				ldx		#0	
loop_323		lda		MODE_WIN,x
				sta		window_change,x
				inx
				cpx		#0dh
				bne		loop_323			;19?:no-->loop_323
				rts
;---------------------------------------------------
MODE_WIN		DB			18h
				DW			NO_WINDOW       
				DB			60h
				DW          NO_WINDOW				
				DB			28h
				DW          NO_WINDOW				
				DB			70h
				DW          NO_WINDOW				
				DB			0
;-------------------------------------------------------------
;
WINDOW_SIZE		DW			NO_WINDOW,SIZE_0,SIZE_1,SIZE_2
				DW			SIZE_3,SIZE_4,SIZE_5,SIZE_6
				DW			SIZE_7,SIZE_8,SIZE_9,SIZE_a
				DW			SIZE_b
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
;------(J̃_[^[)------
NO_WINDOW		DB			01h,000h
SIZE_0			DB			7fh,081h
SIZE_1			DB			7ch,084h
SIZE_2			DB			78h,088h
SIZE_3			DB			74h,08ch
SIZE_4			DB			70h,090h
SIZE_5			DB			6ch,094h
SIZE_6			DB			68h,098h
SIZE_7			DB			60h,0a0h
SIZE_8			DB			58h,0a8h
SIZE_9			DB			50h,0b0h
SIZE_a			DB			48h,0b8h
SIZE_b			DB			40h,0bch
;---------------------------------------------------------------
;-------(cJ̃_[^[)------
WINDOW_SIZE1	DW			WINDOW_0,WINDOW_0,WINDOW_1
				DW			WINDOW_0,WINDOW_0,WINDOW_2
				DW			WINDOW_3
;
WINDOW_0		DB			00h,2ch,02h,2bh,04h,2ah,08h,28h
				DB			0ch,26h,10h,24h,14h,22h,18h,20h
				DB			1ch,1eh,20h,1ch,24h,1ah,28h,18h,28h,18h
;
WINDOW_1		DB			00h,34h,04h,32h,08h,30h,10h,2ch
				DB			14h,2ah,18h,28h,20h,24h,24h,22h
				DB			28h,20h,30h,1ch,34h,1ah,38h,18h,38h,18h
;
WINDOW_2		DB			00h,3bh,08h,37h,10h,33h,18h,2fh
				DB			20h,2bh,28h,27h,30h,23h,38h,1fh
				DB			40h,1bh,48h,17h,50h,13h,54h,12h,56h,10h
;
WINDOW_3		DB			00h,34h,04h,30h,08h,2ch,10h,24h
				DB			18h,20h,20h,1eh,28h,1ch,30h,1ah
				DB			38h,18h,3ch,16h,40h,14h,44h,12h,48h,10h
;---------------------------------------------------------------
select_window	DW			Title_Set,MODE_0,MODE_0,MODE_0			
				DW			MODE_0,MODE_4,MODE_4
;---------------------------------------------------------------
select_position	DW			 Select_0, Select_1
				DW			 Select_2,Select_3
;---------------------------------------------------------------
select_noko		DW			NOKO_1,NOKO_1,NOKO_2,NOKO_3,NOKO_4,NOKO_5
				DW			NOKO_5
;---------------------------------------------------------------
OAM_SET			DW			ONE_PLAY,ONE_PLAY
				DW			MARIO_GP,MARIO_GP1,KIDS_CLASS,All_Set
				DW			All_Set
;-----(kinoko data)-----
OAM				DW			08050h,0c9dh			;kinoko.
				DW			08848h,0c9dh			
				DW			09848h,0c9dh			
				DW			0a848h,0c9dh			
;-----(player data)-----
ONE_PLAY		DW			8060h,084ah	
				DW			8068h,0843h
				DW			8070h,0857h
				DW			8078h,0842h
				DW			7878h,082eh
				DW			8088h,0830h
				DW			8090h,083eh
				DW			8098h,084bh
				DW          7898h,082eh
;
TWO_PLAY		DW			9060h,0a4bh	
				DW			9068h,0a3fh
				DW			9070h,0a57h
				DW			9078h,0a42h
				DW			8878h,0a2eh
				DW			9088h,0a30h
				DW			9090h,0a3eh
				DW			9098h,0a4bh
				DW          8898h,0a2eh
				DW			0ffffh
;------(game data.2play)--------
MARIO_GP		DW			8060h,087eh	
				DW			8068h,0887h
				DW			8070h,0864h
				DW			8078h,0865h
				DW			8080h,089ch
				DW			8088h,0873h
				DW			8090h,0820h
				DW			8098h,0821h
;
VS_RACE			DW			9060h,0a22h	
				DW			9068h,0a23h
				DW			9070h,0a7eh
				DW			9078h,0a97h
				DW			9080h,0a70h
				DW			9088h,0a89h
				DW			9090h,0a9ch
				DW			9098h,0a6ch
;
BATTLE_GAME		DW			0a060h,0c79h	
				DW			09860h,0c2eh
				DW			0a068h,0c73h
				DW			0a070h,0c88h
				DW			0a078h,0c68h
				DW			09878h,0c2eh
				DW			0a080h,0c9ch
				DW			0a088h,0c80h
				DW			0ffffh
;------(game data.1play)--------
MARIO_GP1		DW			8060h,087eh	
				DW			8068h,0887h
				DW			8070h,0864h
				DW			8078h,0865h
				DW			8080h,089ch
				DW			8088h,0873h
				DW			8090h,0820h
				DW			8098h,0821h
;
TIME_ATTCK		DW			9060h,0a6fh	
				DW			9068h,0a61h
				DW			9070h,0a80h
				DW			9078h,0a60h
				DW			9080h,0a6fh
				DW			9088h,0a97h
				DW			9090h,0a67h
				DW			0ffffh
;-----(class data)-------
KIDS_CLASS		DW			8060h,0805h	
				DW			8068h,0800h
				DW			8070h,082ah
				DW			8080h,0840h
				DW			8088h,084ah
				DW			7888h,082eh
				DW			8090h,0891h
				DW			8098h,0839h
				DW			80a0h,0867h
				DW          80a8h,0886h
				DW			80b0h,086ch
;
ADULT_CLASS		DW			9060h,0a01h	
				DW			9068h,0a00h
				DW			9070h,0a00h
				DW			9078h,0a2ah
				DW			9088h,0a34h
				DW			9090h,0a43h
				DW			9098h,0a44h
				DW			90a0h,0a67h
				DW          90a8h,0a86h
				DW			90b0h,0a6ch
				DW			0ffffh

;			
OK_CHECK		DW			0a868h,0a39h
				DW			0a870h,0a59h
				DW			0a878h,0a42h
				DW			0a078h,0a2eh
				DW			0a888h,0a31h
				DW			0a890h,0a31h
				DW			0a898h,0a42h
				DW			0a098h,0a2eh
				DW			0a8a0h,0a3ch
				DW			0a8a8h,0a35h
				DW			0a8b0h,0a24h
;
				DW			0b870h,085eh
				DW			0b888h,085fh
				DW			0b878h,0a49h
				DW			0b880h,0a31h
				DW			0b898h,0a31h
				DW			0b8a0h,0a31h
				DW			0b8a8h,0a33h
All_Set			DW			0ffffh
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;************************************************
;				PPU&OAM.MSB ̃CjV@Zbg
;************************************************
PPU_INT_SET		equ		$
				mem8
				idx8
				STZ		!DMA_synchronic 	;B HDMA off 
				STZ		!DMA_burst		;B VDMA off
				LDA		#80H			;B	
				STA		!PPU_control		;B screen blanking
;---------------------------------------------- ; reset window -------
				STZ		!Through_window+0	;B
				STZ		!Through_window+1	;B
				STZ		!Window_control+0	;B
				STZ		!Window_control+1	;B
				STZ		!Window_control+2	;B
;---------------------------------------------- ; reset CG ------------
				STZ		!Color_control		;B
				STZ		!Color_brend		;B
				LDA		#0E0H			;B
				STA		!Color_bias		;B
;-----------------------------------------------; reset scroll --------
				LDX		#7			;B
clr_scrl		STZ		!Scroll_,X		;B
				STZ		!Scroll_,X		;B
				DEX				;B
				BPL		clr_scrl		;B
;--------------------------------------------------------------------
				STZ		!Screen_mosaic		;B mosaic off
				STZ		!PPU_option		;B nomal mode
				STZ		!Through_screen+1	;B through sub
;--------------------------------------------------------------------
;(OAM)
			 	idx16
 			 	mem16
			 	rep		#00110000b
			 	ldx		#0000h
loop_735	 	lda		#0e0f8h		 
			 	sta		oamdat,x
			 	inx
				inx
			 	cpx		#200h
			 	bne		loop_735
				mem8
				idx8
				sep		#00110000b
;
				ldx		#0
loop_750	 	lda		#0
			 	sta		msbdat,x
			 	inx
			 	cpx		#20h
			 	bne		loop_750
				rts
;======================================================================
;********************************************************************
;					C[`@Tu
;********************************************************************
;======================================================================
;******************************************************
;					XN[Zbg
;******************************************************
TITLE_SCROLL	equ		$
				mem16
				idx8
				rep		#00100000b
;
				inc		<back_2h
;
				idx8
				mem8
				sep		#00100000b
;
owari_605		rts
;********************************************************
;					EChẼZNg`FbN
;********************************************************
FLAG_CHECK		equ		$
				lda		<select_flag
				and		#00110000b
				bne		owari_405					;EChEZbg?:yes-->owari_405	
;--------------------------------------------
				lda		<button_TG+1
				ora		<button_TG+3
				and		#10010000b
				bne		mode_up						;mode_up?yes-->mode_up
;--------------------------------------------
				lda		<button_TG
				ora		<button_TG+2
				and		#01000000b	
				bne		mode_dwn					;mode_dw?yes-->mode_dwn
owari_405		rts
;/////////////////// MODE UP Zbg ////////////////////
mode_up			mem16
				idx16
				rep		#00110000b
				lda		#200h						;IuWF
				sta		<sprite_count
				JSR		OBJ_ERASE
				JSL		>Set_demokart
				lda		#002eh
				JSL		>Trigger_sound_1			;TEhZbg
				mem8
				idx8
				sep		#00110000b
;
				lda		<Game_select.flag			;ŏI`FbN.
				and		#10000000b
				bne		Reset_Select				
;
				lda		<select_flag
				inc		a							;[hAbvZbg
;
				cmp		#06
				beq		Kart_Selelct				;CfbNXZbg
				cmp		#07
				beq     Kart_Selelct
;
				cmp		#01							;ԍŏ̃EChE?:yes-->set_open
				beq		set_open					;EChEI[v̂݃Zbg
;/////// EChEN[YA[hAbṽtOZbg //////
set_close		lda		<select_flag
				ora		#60h						;windoe close bit set.		
				sta		<select_flag		
				jmp		owari_M1
;//////////// ŏI`FbNhh̎ ///////////////////
Reset_Select	lda		<Game_select.flag			;window close Player select
				and		#00111111b
				sta		<Game_select.flag
;
				lda		<select_flag				;EChȆ傫`FbN
				cmp		#06
				beq		Set_small_close		
;
				lda		#65h						;傫̃EChE
				sta		<select_flag
				jmp		owari_M1
;
Set_small_close	lda		#66h						;̃EChE
				sta     <select_flag
				jmp     owari_M1
;//////// EChEI[vƃ[hAbvtOZbg ///////
set_open		lda		<select_flag				;EChEI[vƃ[hAbvZbg.
				ora		#51h
				sta		<select_flag
owari_M1		rts
;//////////////// [h_EZbg /////////////////////////
mode_dwn		lda		<select_flag
				beq		owari_323					;^Cg?:yes-->owari_323
Set_Close		ora		#0a0h						;EChEN[Yƃ[h_E.
				sta		<select_flag
				mem16
				rep		#00100000b
				lda		#002eh
				JSL		>Trigger_sound_1
				mem8
				sep		#00100000b
owari_323		rts
;/////////////////// ŏItOZbg ///////////////////////
;
;--------(rCEZbg)--------
Kart_Selelct	lda		<Game_select.flag
				pha
				and		#00000010b
				bne		adlut_class					;100cc class?:yes-->adlut_class
				stz		game_level					;50cc class set.
				jmp		Player_Set
adlut_class		lda		#02
				sta		game_level					;100cc class set.
;------(lpZbg)--------
Player_Set		pla
				pha
				and		#00000001b
				beq		One_Player					;2player?:no-->One_Player
;
				stz		<game_mode					;2player set.
;-----(Q[IZbg)------
				pla		
				and		#00001100b
				beq		Mario_GP					;GP?:yes-->Mario_GP
;	
				cmp		#04
				beq		VS_mode						;VS_mode?:yes-->VS_mode
;
				lda		#06
				sta		<game_status				;battle set.
				jmp		End_Title
;
Mario_GP		stz     <game_status				;GP set.
				jmp		End_Title
;
VS_mode			lda		#02							;VS set.
				sta		<game_status
				jmp		End_Title
;-------(lpZbg)--------
One_Player		pla
				and		#00010000b
				bne		Time_Attack					;Time_Attack?:yes-->Time_Attack
;
				stz		<game_status				;GP set.
				jmp     Set_game_mode
;
Time_Attack		lda		#04
				sta		<game_status				;time attack set.
;
Set_game_mode	lda		<game_mode
				cmp		#04
				beq		under_display
;
				lda		#02
				jmp		Set_Game_mode
;
under_display	lda		#04
Set_Game_mode	sta		<game_mode
;---(J[gZNgp̃tOZbg)------
End_Title		mem16
				rep		#00100000b
				JSL		>BGM_fade_out
				mem8
				sep		#00100000b
				lda		#06		
				sta		game_selecta				;K-select set.
				lda		#8fh
				sta		fade_control+1				;fdadeout set.
				stz     race_init
				stz     race_init+1
				rts
;******************************************************
;				EBhE̊J߃f[^[Zbg
;******************************************************
WINDOW_SET		equ		$
				lda		<select_flag
				and		#00110000b
				cmp		#10h
				beq		wind_openset		;EChEI[vZbg?:yes-->wind_openset
;
				cmp		#20h
				beq		window_closeset		;EChEN[YZbg?:yes-->window_closeset
				rts
;/////////////// EChEIvZbg ////////////////
wind_openset	lda		<window_open		;EChȆ傫JE^[ZbgB
				cmp		#0ch
				beq		noset_window
				inc		a
				sta		<window_open
				asl		a
				tax
				jmp		set_window
;/////////////// EChENYZbg ////////////////
window_closeset	lda		<window_open		;EChȆ傫JE^[ZbgB
				beq		noset_window1
				dec		a
				sta		<window_open
				asl		a
				tax
;/////////////// J̃f[^[Zbg ////////////////
set_window		mem16
				rep		#00100000b
				lda		WINDOW_SIZE,x
;
				ldx		#0007
				sta		window_change,x	
				mem8
				sep		#00100000b
;/////////////// cJ̃f[^[Zbg /////////////////
				lda		<select_flag
				and		#00000111b
				asl		a
				tax
;
				mem16
				idx16
				rep		#00110000b
				lda		<window_open
				asl		a
				clc
				adc		WINDOW_SIZE1,x
				tax
				phx
;
				mem8
				sep		#00100000b
				lda		!0,x
				idx8
				sep		#00010000b
;
				ldx		#06
				sta		window_change,x
;------------------------------------------------
				idx16
				rep		#00010000b
				plx
				lda		!1,x
				idx8
				sep		#00010000b
;
				ldx		#0
				sta		window_change,x
				rts
;////////////// EChEZbg̒~ //////////////////
noset_window	lda		<select_flag
				and		#00000111b			;window set off.
				sta     <select_flag
				rts
;///////// EChEI[vƃ[hAbv_EZbg ///////
noset_window1	lda		<select_flag
				pha
				and		#00000111b
				beq		noset_window
				ora		#10h				;޳ݾ.
				sta		<select_flag
;
				pla
				and		#11000000b
				cmp		#40h				;[hAbv?:yes-->mode_upset
				beq		mode_upset
;//////////////////// [h_EZbg ////////////////////// 
				lda		<select_flag		
				dec		a					;[h_EZbg.
				and		#00010111b
				sta     <select_flag
;
				cmp		#10h	
				beq		NOKO_replace		;^CgʃZbg
;
				cmp		#12h				;lpQ[ZNg̃Wv
				beq		jump_tow_player
;
				cmp		#13h
				beq		Check_game
;
				cmp		#15h
				beq		end_back
				jmp     owari_205
;-------------------------------------------------
Check_game		lda		<Game_select.flag	;l`FbN
				and		#00000001b
				beq		owari_205			
				jmp		jump_tow_player
;
end_back		dec		<select_flag
				lda		<Game_select.flag	;l`FbN
				and		#00000001b
				beq		jump_tow_player
				dec		<select_flag			
;			
				
jump_tow_player	dec		<select_flag		;[h_EZbg.
				jmp     owari_205
;--------------------------------------------------
NOKO_replace	JSR		MOJI_SET		
				jmp		noset_window
;/////////////////// [hAbvZbg ////////////////////
mode_upset		lda		<select_flag		
				inc		a					;[hAbvZbg.
				and		#00010111b
				sta     <select_flag
;
				cmp		#12h				;lplp̃Q[ZNg
				beq		game_choose
;
				cmp		#13h
				beq		class_choose
				cmp		#14h		
				beq		class_choose			
;
				cmp		#16h
				beq		Reset_player
				cmp		#17h
				beq		Reset_player
				jmp		owari_205
;------------------------------------------
Reset_player	lda		#11h				;Player select mode set.
				sta		<select_flag
				jmp     owari_205
;-------------------------------------------
game_choose		lda		<Game_select.flag	;l`FbN
				and		#00000001b
				bne		owari_205			
				jmp		jump_class
;
class_choose	lda     <Game_select.flag	;l`FbN
				and		#00000001b
				beq		one_game_set		
;
				inc		<select_flag
				lda		<Game_select.flag	;lpQ[e`FbN
				and		#00001100b
				beq		owari_205			
				jmp		Small_window
;
one_game_set	lda		<Game_select.flag	;lpQ[e`FbN
				and		#00010000b
				beq		owari_205
;
Small_window	inc     <select_flag
jump_class		inc		<select_flag
;			
owari_205		lda		<select_flag
				JSR     MOJI_SET					;moji data set.
				rts
;***************************************************
;					IZbg
;***************************************************
GAME_SELECT		equ		$
				lda     <select_flag				;EChEI?:yes-->owari_309
				and		#11110000b
				bne		owari_309
;------------------------------------------------
				lda		<button_TG+1
				ora		<button_TG+3
				and		#00001100b
				beq		owari_309
;------------------------------------------------
				pha
				lda		<select_flag
				dec		a
				asl		a
				tax
				jmp		(!select_position,x)
owari_309		rts
;//////////////// vC[ZNg ///////////////////
Select_0		pla  								;{^`FbNB
				cmp		#04
				beq		down_0
				cmp		#08
				beq		up_0
				rts
;----------(lpZbg)----------
down_0			lda		<Game_select.flag
				and		#00000001b
				bne		owari_309
				inc		<Game_select.flag     		;2 Player set.
				jsr		noko_down
				rts
;----------(lpZbg)-----------
up_0			lda		<Game_select.flag
				and		#00000001b
				beq		owari_309			
				dec		<Game_select.flag			;1 Player set.
				jsr		noko_up
				rts
;/////////////// lp̃Q[ZNg ////////////////
Select_1		pla
				cmp		#04
				beq		down_2
				cmp		#08
				beq		up_2
				rts
;
down_2			lda		<Game_select.flag
				and		#00001100b
				cmp		#08
				beq		owari_309
				lda		<Game_select.flag
				clc
				adc		#04
				sta		<Game_select.flag
				jsr     noko_down
				rts
;
up_2			lda		<Game_select.flag
				and		#00001100b
				beq		owari_309
				lda		<Game_select.flag
				sec
				sbc		#04
				sta		<Game_select.flag
				jsr     noko_up
				rts
;/////////////// lp̃Q[ZNg /////////////////
Select_2		pla
				cmp		#04
				beq		down_3
				cmp		#08
				beq		up_3
				rts
;
down_3			lda		<Game_select.flag
				and		#00010000b
				bne		owari_914
				lda		<Game_select.flag
				clc
				adc		#10h
				sta		<Game_select.flag
				jsr     noko_down
				rts
;
up_3			lda		<Game_select.flag
				and		#00010000b
				beq		owari_914
				lda		<Game_select.flag
				sec
				sbc		#10h
				sta		<Game_select.flag
				jsr     noko_up
owari_914		rts

;////////////////// NXZNg ///////////////////////
Select_3		pla								;{^ZbgB
				cmp		#04
				beq		down_1
				cmp		#08
				beq		up_1
				rts
;-------------(lp)-------------
down_1			lda		<Game_select.flag		;adlut
				and		#00000010b			
				bne		owari_914
				lda		<Game_select.flag
				clc
				adc		#02
				sta		<Game_select.flag
				jsr     noko_down
				rts
;-------------(qp)-------------
up_1			lda		<Game_select.flag		;kids
				and		#00000010b
				beq		owari_914
				lda		<Game_select.flag
				sec
				sbc		#02
				sta     <Game_select.flag
				jsr     noko_up
				rts
;////////////// LmR̃|WVZbg ///////////////
noko_down		ldx		#01h
				lda		oamdat+100h,x
				clc
				adc		#10h
				sta		oamdat+100h,x
				jmp		Set_sound
;------------------------------------------------
noko_up			ldx		#01h
				lda		oamdat+100h,x
				sec
				sbc		#10h
				sta		oamdat+100h,x
;
Set_sound		mem16
				rep		#00100000b
				lda		#002ch
				JSL		>Trigger_sound_1
				mem8
				sep		#00100000b
				rts
;********************************************************
;					̃Zbg
;********************************************************
MOJI_SET		equ		$
				lda     <select_flag				;EChẼio[`FbN
				and     #00000111b
				pha
				asl		a
				tax
;-------------------------------------------------
				mem16
				idx16
				rep		#00110000b
				lda		#oamdat+110h				;3PUԒnɃZbg.
				sta		<addr
;--------------------------------------------------
				ldy		#0
				lda		#0e0f8h						;OAM̃NA[.
loop_535		sta		(<addr),y
				iny
				iny
				cpy		#00f0h
				bne		loop_535
;--------------------------------------------------
				ldy		#0							;f[^[ZNg.
				lda		OAM_SET,x
				tax
;
Set_Oam			lda		!0,x						;f[^[Zbg.
				inx
				inx
;
				cmp		#0ffffh
				beq		owari_316
				sta		(<addr),y
				iny
				iny
				jmp		Set_Oam
;
owari_316		mem8
				idx8
				sep		#00110000b
;////////////// LmȐꏊƕ̈ړZbg/////////
				ldx		#10h					;one NOKO display set.
				lda		#54h
				sta		msbdat,x
;
				pla
				asl		a
				tax
;-----------------------------------------------
				lda		<Game_select.flag
				pha
				jmp		(!select_noko,x)
;/////////////// vC[̃`FbN ///////////////////
NOKO_1			ldx		#0					;NOKO place set.
				lda		#50h
				sta		oamdat+100h,x
;
				ldx		#10h
				lda		#54h					;NOKO erase set.
				sta		msbdat,x
;
				pla
				and		#00000001b
				jmp		Set_Noko
;//////////////// lpQ[e /////////////////////
NOKO_2			ldx		#0
				lda		#50h
				sta		oamdat+100h,x
;		
				pla
				and		#00001100b
				lsr		a
				lsr		a
				jmp		Set_Noko		
;//////////////// lpQ[e /////////////////////
NOKO_3			ldx		#0						;NOKO place set.
				lda		#50h
				sta		oamdat+100h,x
;
				pla
				and		#00010000b
				lsr		a
				lsr		a
				lsr		a
				lsr		a
				jmp		Set_Noko
;///////////////// NX̃`FbN ///////////////////
NOKO_4			ldx		#0						;NOKO place set.
				lda		#48h
				sta		oamdat+100h,x
;
				ldy		#10h					;bZ[W̏ꏊړB
loop_938		lda		oamdat+100h,y
				sec
				sbc		#08
				sta		oamdat+100h,y 
				JSR		Y_iny
				cpy		#64h
				bne		loop_938
;
				pla
				and		#00000010b
				lsr		a
				jmp		Set_Noko
;///////////////////// ŏI ////////////////////////////
NOKO_5			pla
				jsr		ALL_DISPLAY				;All message set.
				lda		#03
;///////////////// LmR g|VVZbg //////////
Set_Noko		tax								;NOKO display.
				lda		nokoplace,x
				ldx		#01				
				sta		oamdat+100h,x
				rts
;---------------------------------------------
nokoplace		DB		80h,90h,0a0h,78h
;
;**********************************************************
;					ŏI`FbN̕Zbg
;**********************************************************
ALL_DISPLAY		equ		$
;//////////////// vC[̕Zbg ////////////////
				lda		<Game_select.flag			;vC[`FbN
				and		#0000001b
				asl		a
				tax
;-----------------------------------------------
				mem16
				idx16
				rep		#00110000b
				lda		Player_Cmp,x				;f[^[Zbg
				sta		<Counter_Comp
;-----------------------------------------------
				lda		Player_Check,x				;f[^[Zbg
				tax
;
				JSR		Oam_Set.data
;-----------------------------------------------
				mem8
				idx8
				JSR		SET_H.position
;-----------------------------------------------
				ldy		#01
loop_944		lda		(<addr),y
				cmp		#88h
				bcs		place_dwn
				sec
				sbc		#08h
				jmp		set_place	
;	
place_dwn		sec
				sbc		#18h
;
set_place		JSR		V_Set.data					;V_position set.
				cpy		<Counter_Comp
				bne		loop_944
;
				JSR		Cmp_set
;//////////////// lpQ[eZbg/////////////////////
				lda		<Game_select.flag
				and		#00000001b
				beq		Set_oneplay
;		
				lda     <Game_select.flag
				and		#00001100b
				lsr		a
				tax
;
				JSR		Set_address
;-----------------------------------------------
				mem16
				idx16
				lda		Content_Cmp,x
				sta		<Counter_Comp
;
				lda		Content_Check,x
				tax
;
				JSR     Oam_Set.data
;-----------------------------------------------
				mem8
				idx8
				JSR		SET_H.position
;-----------------------------------------------	
				ldy		#01
loop_633		lda		(<addr),y
				cmp		#90h
				bcs		set_place21
				clc
				adc		#08h
				jmp		set_place2
;
set_place21		cmp		#98h
				bcs		set_place22
				sec
				sbc		#08h
				jmp		set_place2
;
set_place22		sec
				sbc		#18h
;
set_place2		JSR     V_Set.data
				cpy		<Counter_Comp
				bne		loop_633
;
				JSR     Cmp_set
				JMP		Check_class
;//////////////// lpQ[eZbg/////////////////////
Set_oneplay		lda     <Game_select.flag
				and		#00010000b
				lsr		a
				lsr		a
				lsr		a
				tax
;
				JSR     Set_address
;-----------------------------------------------
				mem16
				idx16
				lda		Content1_Cmp,x
				sta		<Counter_Comp
;
				lda		Content1_Check,x
				tax
;
				JSR     Oam_Set.data
;-----------------------------------------------
				mem8
				idx8
				JSR		SET_H.position
;-----------------------------------------------	
				ldy		#01
loop_M1			lda		(<addr),y
				cmp		#90h
				bcs		set_place31
				clc
				adc		#08
				jmp		set_place3
;
set_place31		sec		
				sbc		#08h
;
set_place3		JSR     V_Set.data
				cpy		<Counter_Comp
				bne		loop_M1
				JSR     Cmp_set
;//////////////// NXZbg ///////////////////////////
Check_class		lda     <Game_select.flag			;NXZbg΂
				and		#00000001b					;ǂ̃`FbN
				beq		one_player_set
;
				lda     <Game_select.flag
				and		#00001100b
				bne		Set_OK_CHECK
				jmp		Set_Class
;
one_player_set	lda		<Game_select.flag
				and		#00010000b
				bne		Set_OK_CHECK
;-----------------------------------------------
Set_Class		lda		<Game_select.flag
				and		#0000010b
				tax
;
				JSR     Set_address			
;-----------------------------------------------
				mem16
				idx16
				lda		Class_Cmp,x
				sta		<Counter_Comp
;
				lda		Class_Check,x
				tax
;
				JSR     Oam_Set.data
;-----------------------------------------------
				mem8
				idx8
				JSR     SET_H.position
;-----------------------------------------------	
				ldy		#01
loop_520		lda		(<addr),y
				cmp		#90h
				bcs		set_place14
				clc
				adc		#18h
				jmp		set_place11
;
set_place14		clc
				adc		#08
;
set_place11		JSR     V_Set.data
				cpy		<Counter_Comp
				bne		loop_520
				JSR     Cmp_set
;/////////////// OKZbg ///////////////////////
Set_OK_CHECK	JSR     Set_address
;-------------(Zbg)-----------------
				mem16
				idx16
				ldx		#0
				ldy		#0
loop_L20		lda		OK_CHECK,x
				cmp		#0ffffh
				beq		owari_M5
				sta		(<addr),y
				iny
				iny
				inx
				inx
				jmp		loop_L20
owari_M5		mem8
				idx8
				sep		#00110000b
;---(LmRƂu|VV΂`FbN)----
				lda     <Game_select.flag
				and		#00000001b
				beq		one_player_set1
;
				lda     <Game_select.flag
				and		#00001100b
				beq		All_kinoko
				jmp		Two_kinoko
;
one_player_set1	lda		<Game_select.flag
				and		#00010000b
				beq		All_kinoko
;
Two_kinoko		ldx		#10h				;"NOKO" all display set.
				lda		#50h
				sta		msbdat,x
				jmp		Check_set_up
;
All_kinoko		ldx		#10h				;"NOKO" all display set.
				lda		#40h
				sta		msbdat,x
				jmp		owari_check
;-----------(u|VVAbvZbg)-----------
Check_set_up	mem16
				idx16
				rep		#00110000b
				ldx		#0
				ldy		#0
loop_L28		lda		OK_CHECK,x
				cmp		#0ffffh
				beq		owari_check
				sec
				sbc		#1000h
				sta		(<addr),y
				JSR		Y_iny		
				JSR		X_inx
				jmp		loop_L28
owari_check		mem8
				idx8
				sep		#00110000b
;////////////// LmRZbg //////////////////////
				ldx		#0				
				lda		#48h
loop_300		sta		oamdat+100h,x
				JSR		X_inx
				cpx		#10h
				bne		loop_300
				rts
;----------------------------------------------------------
;===========================================================
;				SUB SUB ROUTINE SET
;===========================================================
;-----------------------------------------------------------
Oam_Set.data	equ		$
				mem16
				idx16
				ldy		#0
loop_928		lda		!0,x
				sta		(<addr),y
				iny
				iny
				inx
				inx
				cpy		<Counter_Comp				
				bne		loop_928
				rts
;- - - - - - - - - - - - - - - - - - - - - - -
V_Set.data		equ		$
				idx8
				mem8
				sta		(<addr),y
				JSR		Y_iny
				rts
;- - - - - - - - - - - - - - - - - - - - - - - 
H_Set.data		equ		$
				mem8
				idx8
				ldy		#0
loop_930		lda		(<addr),y
				sec
				sbc		#08	
				sta		(<addr),y
				JSR     Y_iny
				cpy		<Counter_Comp
				bne		loop_930
				rts
;- - - - - - - - - - - - - - - - - - - - - - - 
Color_Set.data	equ		$
				ldy		#03
				lda		#08
loop_M7			sta		(<addr),y
				JSR     Y_iny
				cpy		<Counter_Comp
				bne		loop_M7
				rts
;- - - - - - - - - - - - - - - - - - - - - - -
SET_H.position	equ		$
				mem8
				idx8
				sep		#00110000b
;
				JSR     H_Set.data				;H_position set.
;
				lda		<Counter_Comp			;Data counter inc set.
				inc		<Counter_Comp
				rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
Cmp_set			equ		$
				mem8
				idx8
				lda		<Counter_Comp
				dec		a
				clc
				adc		#03
				sta		<Counter_Comp
				JSR     Color_Set.data
				rts
;- - - - - - - - - - - - - - - - - - - - - - - - - 
Set_address		equ		$
				mem16
				idx16
				rep		#00110000b
				lda		<addr
				sec
				sbc		#03
				clc
				adc		<Counter_Comp
				sta		<addr
				rts
;---------------------------------------------------
;(DATA)
Player_Check	DW		ONE_PLAY,TWO_PLAY				
Player_Cmp		DW		0024h,0024h
;
Class_Check		DW		KIDS_CLASS,ADULT_CLASS
Class_Cmp		DW		002ch,0028h
;
Content_Check	DW		MARIO_GP,VS_RACE,BATTLE_GAME
Content_Cmp		DW		0020h,0020h,0020h
;
Content1_Check	DW		MARIO_GP1,TIME_ATTCK
Content1_Cmp	DW		0020h,001ch
;
;**************************************************
;				ALL END CHECK
;**************************************************
ALL.END_CHECK	equ		$
				mem8
				idx8
				lda		<button_TG+1
				ora		<button_TG+3
				cmp		#02
				beq		Select_Yes
				cmp		#01
				beq		Select_No
owari_RX7		rts
;
;//////////////// ŏI`FbNh͂h////////////
Select_Yes		lda     <Game_select.flag
				and		#10000000b
				beq		owari_RX7				;aer you OK?:yes-->owari_RX7				
;
				lda     <Game_select.flag
				and		#01111111b
				sta		<Game_select.flag
;
				jsr		Set_offset				;"()"OAM address set.
				lda		#70h					;display set.
				sta		oamdat+100h,x
				JSR		X_inx
				lda		#088h
				sta		oamdat+100h,x
				jmp		Set_sound_1
;//////////////// ŏI`FbNhh////////////
Select_No		lda     <Game_select.flag
				and		#10000000b
				bne		owari_RX7				;aer you OK?:no-->owar_RX7
;
				lda		<Game_select.flag
				ora		#80h
				sta		<Game_select.flag					
;
				jsr		Set_offset				;"()"OAM address set.
				lda		#90h					;display set.
				sta		oamdat+100h,x
				JSR		X_inx
				lda		#0b0h
				sta		oamdat+100h,x
;
Set_sound_1		mem16
				rep		#00100000b
				lda		#002ch
				JSL		>Trigger_sound_1
				mem8
				sep		#00100000b
				rts
;--------------------------------------------------
Set_offset		equ		$						;"()"OAM address set.
				lda		<addr
				clc
				adc		#2ch
				tax
				rts
;**************************************************
;				^Cgfp
;**************************************************
OBJ_DEMO		equ		$
				mem16
				idx16
				lda     fade_control
				beq		Demo_start
				rts
Demo_start		jsr		Swing_kart
;- - - - - - - - - - - - - - - -  - - - 
;===========================================
;				}I
;===========================================
;-------(^C}[`FbNƃZbg)---------
MARIO_timer		ldx		#player_r0
				inc		<_demotimer,x			;^C}[Zbg
				lda		<_demotimer,x
				cmp		#0001					;ŏ̑s^C}[`FbN
				beq		MARIO_run_set
				cmp		#0120h
				beq		MARIO_erase				;ŏ̃C[X^C}[`FbN
				cmp		#380h
				beq		MARIO_run_2				;Qڂ̑s^C}[`FbN
				cmp		#398h
				beq		MARIO_revolve			;]^C}[`FbN
				cmp		#468h
				beq		MARIO_run_3				;]̑s^C}[`FbN
				cmp		#4c0h
				beq		MARIO_erase				;Qڂ̃C[X^C}[`FbN
				jmp		MARIO_set
;---------(tOZbg)-----------
MARIO_run_set	lda		#0001					;ŏ̑stOZbg
				sta		<_demoflag,x
				jmp		MARIO_set
MARIO_erase		lda		#0002					;ŏ̃C[XtOZbg
				sta		<_demoflag,x
				jmp     MARIO_set
MARIO_run_2		lda		#0004					;Qڂ̑stOZbg
				sta		<_demoflag,x
				jmp		MARIO_set
MARIO_revolve	lda		#0008					;]tOZbg
				sta		<_demoflag,x
				jmp     MARIO_set
MARIO_run_3		lda		#0010h					;]̑stOZbg
				sta		<_demoflag,x
;------------(tO`FbN)-----------
MARIO_set		lda		<_demoflag,x			
				and		#001fh
				cmp		#0001
				beq		run_mario_1
				cmp		#0002
				beq		erase_mario				
				cmp		#0004
				beq		run_mario_2
				cmp		#0008h
				beq		revolve_mario
				cmp		#0010h
				beq		run_mario_3
				jmp     LUIZI_timer
;-------------(Zbg)------------
run_mario_1		lda		#120h
				jsr		Run_set
				jmp		LUIZI_timer
;
run_mario_2		lda		#200h
				jsr		Run_set
				jmp     LUIZI_timer
;
run_mario_3		lda		#3800h
				sta		<_poseQ,x
				lda		#300h
				jsr     Run_set
				lda		#8000h
				sta		<_muteki_timer,x
				jmp     LUIZI_timer
;
revolve_mario	stz		<_velocityX,x
				jsr     Revolve_set
				jmp     LUIZI_timer	
erase_mario		ldy		#0
				jsr		erase_set
				stz		<_muteki_timer,x
				lda		#00c0h
				sta		<_swing_position,x
				sta		<_situationYH,x
;============================================
;				C[W
;============================================
;-------(^C}[`FbNƃZbg)---------
LUIZI_timer		ldx		#player_r1
				inc		<_demotimer,x			;^C}[Zbg
				lda		<_demotimer,x
				cmp		#0040h					;ŏ̑s^C}[`FbN
				beq		LUIZI_run_set
				cmp		#0160h
				beq		LUIZI_erase				;C[X^C}[`FbN
				cmp		#03c0h
				beq		LUIZI_run_set			;Qڂ̑s^C}[`FbN
				cmp		#4a0h
				beq		LUIZI_revolve			;]^C}[`FbN
				jmp		LUIZI_set
;--------(tOZbg)------------
LUIZI_run_set	lda		#0001					;stOZbg
				sta		<_demoflag,x
				jmp		LUIZI_set
LUIZI_revolve	lda		#0004					;]tOZbg
				sta		<_demoflag,x
				jmp		LUIZI_set
LUIZI_erase		lda		#0002h					;C[XtOZbg
				sta		<_demoflag,x
;-----------(tO`FbN)------------
LUIZI_set		lda		<_demoflag,x			
				and		#0007h
				cmp		#0001					
				beq		run_luizi
				cmp		#0002
				beq		erase_luizi				
				cmp		#0004
				beq		revolve_luizi
				jmp     KUPPA_timer
;-----------(Zbg)----------------
run_luizi		lda		#120h					
				jsr		Run_set
				jmp		KUPPA_timer
revolve_luizi	lda		#-130h
				jsr		Run_set
				jsr		Revolve_set	
				jmp     KUPPA_timer
erase_luizi		ldy		#02						
				jsr		erase_set
;===========================================
;				Nbp
;===========================================
;---------(^C}[`FbNƃZbg)---------
KUPPA_timer		ldx		#player_r2
				inc		<_demotimer,x
				lda		<_demotimer,x
				cmp		#0120h
				beq		KUPPA_run_set			;ŏ̑s^C}[`FbN
				cmp		#0145h
				beq		KUPPA_koura_set			;b̃Zbg^C}[`FbN
				cmp		#0146h
				beq		KUPPA_koura_run			;b̑s^C}[`FbN
				cmp		#16ch
				beq		KUPPA_koura_era			;b̏^C}[`FbN
				cmp		#230h
				beq		KUPPA_erase				;^C}[`FbN
				cmp		#3f0h
				beq		KUPPA_run_2				;Qڂ̑s^C}[`FbN
				cmp		#488h
				beq		KUPPA_revolve			;]^C}[`FbN
				jmp		KUPPA_set
;----------(tOZbg)----------------
KUPPA_run_set	lda		#0001					;stOZbg
				sta		<_demoflag,x
				jmp		KUPPA_set
KUPPA_run_2		lda		#0008					;Qڂ̑stOZbg
				sta		<_demoflag,x
				jmp		KUPPA_set
KUPPA_revolve	lda		#0004					;]tOZbg
				sta		<_demoflag,x
				jmp		KUPPA_set
KUPPA_koura_set	lda		#0010h
				sta		<_demoflag,x
				jmp     KUPPA_set
KUPPA_koura_run	lda		#0020h
				sta		<_demoflag,x
				jmp     KUPPA_set
KUPPA_koura_era	lda		#0040h
				sta     <_demoflag,x
				jmp     KUPPA_set
KUPPA_erase		lda		#0002h					;tOZbg
				sta		<_demoflag,x
;------------(tO`FbN)-----------
KUPPA_set		lda		<_demoflag,x
				and		#007fh
				cmp		#0001h
				beq		run_kuppa
				cmp		#0002
				beq		erase_kuppa
				cmp		#0004
				beq		revolve_kuppa
				cmp		#0008
				beq		run_kuppa_2
				cmp		#0010h
				beq		koura_kuppa
				cmp		#0020h
				beq		koura_run_kuppa
				cmp		#0040h
				beq		koura_run_era
				jmp		PEACH_timer
;------------(Zbg)-------------------
run_kuppa		lda		#140h
				jsr		Run_set
				jmp		PEACH_timer
run_kuppa_2		lda		#120h
				jsr     Run_set
				jmp     PEACH_timer
revolve_kuppa	lda		#-150h
				jsr		Run_set
				jsr		Revolve_set	
				jmp     PEACH_timer
koura_kuppa		lda		#0b028h
				sta		oamdat+84h
				jmp     PEACH_timer	
koura_run_kuppa	jsr		Koura_run
				jmp     PEACH_timer
koura_run_era	lda		#0f0e0h
				sta		oamdat+84h
				jmp     PEACH_timer
erase_kuppa		ldy		#04
				jsr		erase_set
;=============================================
;				s[`
;=============================================
;--------(^C}[Zbgƃ`FbN)-----------
PEACH_timer		ldx		#player_r3
				inc		<_demotimer,x
				lda		<_demotimer,x
				cmp		#0080h
				beq		PEACH_run_set			;ŏ̑s^C}[`FbN
				cmp		#01a0h
				beq		PEACH_erase				;^C}[`FbN
				cmp		#408h
				beq		PEACH_run_2				;Qڑs^C}[`FbN
				cmp		#478h
				beq		PEACH_revolve			;]^C}[`FbN
				jmp		PEACH_set
;----------(tOZbg)-----------
PEACH_run_set	lda		#0001					;ŏ̑stOZbg
				sta		<_demoflag,x
				jmp		PEACH_set				
PEACH_run_2		lda		#0008					;QڑstOZbg
				sta		<_demoflag,x
				jmp     PEACH_set
PEACH_revolve	lda		#0004					;]tOZbg
				sta		<_demoflag,x
				jmp     PEACH_set
PEACH_erase		lda		#0002h					;tOZbg
				sta		<_demoflag,x
;----------(tO`FbN)-----------
PEACH_set		lda		<_demoflag,x
				and		#000fh
				cmp		#0001h
				beq		run_peach
				cmp		#0002
				beq		erase_peach
				cmp		#0004
				beq		revolve_peach
				cmp		#0008
				beq		run_peach_2
				jmp		KONG_timer
;---------(Zbg)-----------
run_peach		lda		#120h
				jsr		Run_set
				jmp		KONG_timer
run_peach_2		lda		#120h
				jsr		Run_set
				jmp     KONG_timer
revolve_peach	lda		#-140h
				jsr		Run_set
				jsr		Revolve_set	
				jmp		KONG_timer
erase_peach		ldy		#06
				jsr		erase_set
				lda		#00c0h
				sta		<_swing_position,x
				sta		<_situationYH,x
;===========================================
;				RO
;===========================================
;-------(^C}[Zbgƃ`FbN)--------
KONG_timer		ldx		#player_r4
				inc		<_demotimer,x
				lda		<_demotimer,x
				cmp		#22ch
				beq		KONG_run_set				;ŏ̑s^C}[`FbN
				cmp		#350h
				beq		KONG_erase					;^C}[`FbN
				jmp		KONG_set
;-------(tOZbg)-----------
KONG_run_set	lda		#0001						;stOZbg
				sta		<_demoflag,x
				jmp		KONG_set
KONG_erase		lda		#0002h						;tOZbg
				sta		<_demoflag,x
;-------(tO`FbN)--------
KONG_set		lda		<_demoflag,x
				and		#000fh
				cmp		#0001h
				beq		run_kong
				cmp		#0002
				beq		erase_kong
				jmp		KAME_timer
;-------(Zbg)------------
run_kong		lda		#120h
				jsr		Run_set
				jmp		KAME_timer
erase_kong		ldy		#08
				jsr		erase_set
;========================================
;				J
;========================================
;-------(^C}[Zbgƃ`FbN)--------
KAME_timer		ldx		#player_r5
				inc		<_demotimer,x
				lda		<_demotimer,x
				cmp		#3d8h
				beq		KAME_run_set			;ŏ̑s^C}[`FbN
				cmp		#496h
				beq		KAME_revolve			;]^C}[`FbN
				jmp		KAME_set
;--------(tOZbg)------------
KAME_run_set	lda		#0001					;stOZbg
				sta		<_demoflag,x
				jmp		KAME_set
KAME_revolve	lda		#0004					;]tOZbg
				sta		<_demoflag,x
				jmp     KAME_set
KAME_erase		lda		#0002h
				sta		<_demoflag,x
;---------(tO`FbN)---------
KAME_set		lda		<_demoflag,x
				and		#0007h
				cmp		#0001h
				beq		run_kame
				cmp		#0002
				beq		erase_kame
				cmp		#0004
				beq		revolve_kame
				jmp		KINOPIO_timer
;------------(Zbg)-------------
run_kame		lda		#120h
				jsr		Run_set
				jmp		KINOPIO_timer
revolve_kame	lda		#-150h
				jsr		Run_set
				jsr		Revolve_set	
				jmp     KINOPIO_timer		
erase_kame		ldy		#0ah
				jsr		erase_set
;==========================================
;				LmsI
;==========================================
;-------(^C}[Zbgƃ`FbN)--------
KINOPIO_timer	ldx		#player_r6
				inc		<_demotimer,x
				lda		<_demotimer,x
				cmp		#00c0h
				beq		KINOPIO_run_set			;s^C}[`FbN
				cmp		#016ah
				beq		KINOPIO_revolve			;]()^C}[`FbN
				cmp		#0173h
				beq		KINOPIO_nostar			;](Ȃ)^C}[`FbN	
				cmp		#01f0h
				beq		KINOPIO_erase			;^C}[`FbN
				jmp		KINOPIO_set
;-------(tOZbg)----------
KINOPIO_run_set	lda		#0001					;stOZbg
				sta		<_demoflag,x
				jmp		KINOPIO_set
KINOPIO_revolve	lda		#0004					;]tOZbg
				sta		<_demoflag,x
				jmp		KINOPIO_set
KINOPIO_nostar	lda		#0008
				sta		<_demoflag,x
				jmp     KINOPIO_set
KINOPIO_erase	lda		#0002					;tOZbg
				sta		<_demoflag,x
;-------(tO`FbN)---------
KINOPIO_set		lda		<_demoflag,x
				and		#000fh
				cmp		#0001h
				beq		run_kinopio
				cmp		#0002
				beq		erase_kinopio
				cmp		#0004
				beq		revolve_kinopio
				cmp		#0008
				beq		nostar_kinopio
				jmp		YOSSY_timer
;--------(Zbg)-----------
run_kinopio		lda		#120h
				jsr		Run_set
				jmp		YOSSY_timer
revolve_kinopio	jsr		Revolve_set
				lda		#-170h
				jsr     Run_set
				lda		#0ad8fh
				jsr		Star_set
				jmp     YOSSY_timer
nostar_kinopio	jsr     Revolve_set
				lda     #0f0e0h
				sta		oamdat+88h
				jmp     YOSSY_timer
erase_kinopio	ldy		#0ch
				jsr		erase_set
;======================================
;				bV[
;======================================
;--------(^C}[Zbgƃ`FbN)-------
YOSSY_timer		ldx		#player_r7
				inc		<_demotimer,x
				lda		<_demotimer,x
				cmp		#0290h
				beq		YOSSY_run_set			;s^C}[`FbN
				cmp		#031eh
				beq		YOSSY_revolve			;]^C}[`FbN
				cmp		#03a0h
				beq		YOSSY_erase				;^C}[`FbN
				jmp		YOSSY_set
;---------(tOZbg)--------
YOSSY_run_set	lda		#0001					;stOZbg
				sta		<_demoflag,x
				jmp		YOSSY_set
YOSSY_revolve	lda		#0004					;]tOZbg
				sta		<_demoflag,x
				jmp		YOSSY_set
YOSSY_erase		lda		#0002h					;^C}[`FbN
				sta		<_demoflag,x
;--------(tO`FbN)--------
YOSSY_set		lda		<_demoflag,x
				and		#0007h
				cmp		#0001h
				beq		run_yossy
				cmp		#0004
				beq		revolve_yossy
				cmp		#0002
				beq		erase_yossy
				jmp		BANANA_timer
;--------(Zbg)------------
run_yossy		lda		#160h
				jsr		Run_set
				jmp		BANANA_timer
revolve_yossy	jsr		Revolve_set
				lda		#-220h
				jsr     Run_set
				jmp     BANANA_timer
erase_yossy		ldy		#0eh
				jsr		erase_set
;==============================================
;				oii
;============================================== 
BANANA_timer	lda		<Banana_flag
				beq		Timer_check
				jsr		Banana_move
;
Timer_check		ldx		#1000h				;oii^C}[`FbN
				lda		<_demotimer,x
				cmp		#300h
				beq		Banana_1
				cmp		#320h
				beq		Banana_erase
				cmp		#330h
				beq		Banana_2
				cmp		#39bh
				beq		Banana_erase
				cmp		#580h				;fI^C}[`FbN
				bne		demo_owari
				jsr		OBJ_ERASE			;CjVZbg
demo_owari		rts
; - - - - - - - - - - - - - - - - - - - - - -
;--------(oiiZbg)---------
Banana_1		lda		#0b0d0h
				jsr     Banana_set
				lda		#0001
				sta		<Banana_flag
				jmp		demo_owari
Banana_2		lda		#0b08eh
				jsr		Banana_set
				lda		#0001
				sta		<Banana_flag
				jmp     demo_owari
Banana_erase	lda     #0f0e0h
				jsr     Banana_set
				stz		<Banana_flag
				jmp     demo_owari
;- - - - - - - - - - - - - - - - - - - - - -
;------(sZbg)-----
Run_set			equ		$
				sta		<_velocityX,x
				rts
;------(UZbg)-----
Swing_kart		equ		$
				lda     <Swing_count
				tax	
				lda		Select_kart,x
				tax
				lda		<_situationYH,x
				cmp		<_swing_position,x
				bne		kart_down
				inc		a
				jmp		Kart_Yposition
kart_down		dec		a
Kart_Yposition	sta		<_situationYH,x				
;
				inc		<Swing_count
				inc		<Swing_count
				lda		<Swing_count
				cmp		#10h
				bne		owari_swing
				stz		<Swing_count
owari_swing		rts
;------(]Zbg)-----
Revolve_set		lda		#800h
				clc
				adc		<_poseQ,x
				sta		<_poseQ,x
				rts
;-----(oiiZbg)--------
Banana_set		equ		$
				sta		oamdat+80h
				lda		#3f00h
				sta		oamdat+82h
				rts
;
Banana_move		equ		$
				dec		oamdat+80h
				rts
;-----(Zbg)---------
Koura_run		equ		$
				lda		oamdat+84h
				clc
				adc		#0003
				sta		oamdat+84h
;
				lda		<Koura_speed
				inc		a
				cmp		#05h
				beq		Koura_revolve
				sta		<Koura_speed
				rts
;
Koura_revolve	stz		<Koura_speed
				lda		oamdat+86h
				cmp		#3f02h
				bne		koura_reset
;
				lda		#3f04h
				sta     oamdat+86h
				jmp		owari_koura
;
koura_reset		lda		#3f02h
				sta		oamdat+86h
owari_koura		rts
;--------(Zbg)-----------
Star_set		equ		$
				sta		oamdat+88h
;
				lda		oamdat+8ah
				cmp		#3f06h
				bne		v_set
				lda		#0bf06h
				sta		oamdat+8ah
				jmp		owari_star
v_set			lda		#3f06h
				sta     oamdat+8ah
owari_star		rts		
;- - - - - - - - - - - - - - - - - - - - - - - - - -
;------(ẴIuWFAEChEI[vƃCjVłɃZbg)------
OBJ_ERASE		equ		$
				mem16
				idx16
				ldy		#0
loop_erase		lda		Select_kart,y
				tax
				phy
				jsr		erase_set
				stz		<_demotimer,x
				stz		<_demoflag,x
				ply
				iny
				iny
				cpy		#0010h
				bne		loop_erase
;
				lda		#0f0e0h
				sta		oamdat+84h
				sta		oamdat+88h
				jsr		Banana_set
				lda		#3f02h
				sta		oamdat+86h
				lda		#3f06h
				sta		oamdat+8ah
;
				stz     <Koura_speed
				stz     <Banana_flag
				rts
;-------(1IuWFCjVԂɂB)------
erase_set		equ		$
				lda		Select_init,y
				tay
				stz		<_velocityX,x
				lda		!0,y
				sta		<_situationXH,x
				lda     !2,y
				sta     <_situationYH,x
				lda     !4,y
				sta		<_poseQ,x
				lda     !6,y
				sta		<_demokart_size,x
				lda     !8,y
				sta		<_swing_position,x
				rts
;- - - - - - - - - - - - - - - - - - - - - - -
;
Select_kart		DW		player_r0,player_r1,player_r2,player_r3
				DW		player_r4,player_r5,player_r6,player_r7
;
Select_init		DW		mario_set,luizi_set,kuppa_set,peach_set
				DW		kong_set,kame_set,kinopio_set,yossy_set
;-----------(CjVf[^[)--------
mario_set		DW		0fff0h,00b8h,03800h,0000h,00b8h
luizi_set		DW		0fff0h,00c0h,03800h,0000h,00c0h
kuppa_set		DW		0fff0h,00c0h,03800h,0000h,00c0h
peach_set		DW		0fff0h,00b8h,03800h,0000h,00b8h
kong_set		DW		0fff0h,00c0h,03800h,0000h,00c0h
kame_set		DW		0fff0h,00c0h,03800h,0000h,00c0h
kinopio_set		DW		0fff0h,00c0h,03800h,0000h,00c0h
yossy_set		DW		0fff0h,00c0h,03800h,0000h,00c0h
;
OBJ_data2       DW      player_r0,0fff0h,00c8h,03800h
				DW      player_r1,0fff0h,00c0h,03800h
				DW      player_r2,0fff0h,00a8h,03800h
				DW      player_r3,0fff0h,00c8h,03800h
				DW      player_r4,0fff0h,00c8h,03800h
				DW      player_r5,0fff0h,00c8h,03800h
				DW      player_r6,0fff0h,00c8h,03800h
				DW      player_r7,0fff0h,00c8h,03800h
				DW		0
				END
