;*******************window.asm*************************
;
			extend
;-----------------------------------------------------
			include		../../kimura/join/rp5c77
			include		../../kimura/join/buffer.def
			include		../../kimura/join/rp5a22
			include     ../join/work.def
;-----------------------------------------------------
			ext		Decode_7F_X
			glb		WINDOW_INIT,WINDOW_CONTROL
;
;-----------------------------------------------------
window_lank		equ		0f500h		;window data ram.
CLEAR_DATA		equ		0f524h		;clare data ram.
rom_data		equ		18000h		;decode data ram.
deco_rank		equ		0f580h		;number data ram.
window_up		equ		0f520h		;number change set.
window_dwn		equ		0f522h		;"
;-----------------------------------------------------
objdata		sect	rel			;(PBR=10)
;-----------------------------------------------------
WINDOW_INIT		equ		$
				pea		007fh				;7F_bank set.
				plb
;--------------------------------------------------
				stz		window_up
				stz		window_dwn
;--------------------------------------------------
				ldy		#rom_data&0ffffh	;(DECODE SET)
				lda		#rom_data/65536
;
				ldx		#deco_rank		
;
				JSL		>Decode_7F_X
				mem8
				idx8
				sep		#00110000b
;--------------------------------------------------
;											(PPU SET)
				lda		#10100000b		;WOBJSEL
				sta		>Window_control+2		
;
				lda		#00010000b		;CGSWSEL
				sta		>Color_control
;
				lda		#00110111b		;CGADDSUB
				sta		>Color_brend
;
				lda		#11100111b		;COLDATA
				sta		>Color_bias
;
				lda		#0				;WINDOW LOGIC
				sta		>Window_pile
				sta		>Window_pile+1
;-----------------------------------------------------
;											(H_DMA SET)
				lda		#01000100b		;4address set.
				sta		>DMA_7
;
				lda		#00100110b		;to 2126h
				sta		>DMA_7+1
;
				lda		#00000000b		;from 7ff500h
				sta		>DMA_7+2
;
				lda		#11110101b
				sta		>DMA_7+3
;
				lda		#01111111b
				sta		>DMA_7+4
;
				lda		#0
				sta		>DMA_7+5
				sta		>DMA_7+6
				lda		#7fh
				sta		>DMA_7+7
;---------------------------------------------------
				ldx		#0					;(CLARE DATA SET)
loop_325		lda		>CLEAR_DATA1,x
				sta		CLEAR_DATA,x		;to 7ff524h
				inx
				cpx		#04
				bne		loop_325			;04?:no-->loop_325
;--------------------------------------------------
				ldx		#0					;(WINDOW DATA SET)
loop_323		lda		>WINDAT,x
				sta		window_lank,x
				inx
				cpx		#19h
				bne		loop_323			;19?:no-->loop_323
;
				mem16						
				idx16
				rep		#00110000b
;
				plb							;pull bank
				rtl
;---------------------------------------------------

WINDAT			DB			24h
				DW          CLEAR_DATA				
				DB			2ch
				DW          CLEAR_DATA
				DB			14h
				DW          CLEAR_DATA
				DB			04h
				DW          CLEAR_DATA
;
				DB			2ch
				DW          CLEAR_DATA				
				DB			2ch
				DW          CLEAR_DATA
				DB			14h
				DW          CLEAR_DATA
				DB			04h
				DW          CLEAR_DATA
				DB			0
;--------------------------------------------
CLEAR_DATA1		byte		21h,20h,21h,20h
;
;======================================================
;******************************************************
;				NUMBER DISPLAY ROUTINE
;******************************************************
;======================================================
WINDOW_CONTROL	equ		$
				pea		007fh		;7F bank set.
				plb
;--------------------------------------------------
				mem8				
				idx16
				sep		#00100000b
;
				ldx		#1000h			;upside goal flag check.
				lda		<obj_flag,x
				and		#10h
				beq		low_display		;goal?:no-->low_display
				sta		window_up
;
;mode_setu		ora		<game_mode		;number display place set.
;				sta		window_up
;
low_display		equ		$
				ldx		#1100h			;downside goal flag check.
				lda		<obj_flag,x
				and		#10h
				beq		s_numberset		;goal?:no-->s_numberset
				sta		window_dwn
;
;mode_setd		ora		<game_mode
;				sta     window_dwn
;
;------------------------------------------------------------------
;
;(UPSIDES S_NUMBER SET)
;
s_numberset		equ		$
				lda		<game_mode
				cmp		#04
				beq		ds_numberset
				lda		window_up		;goal & display check.
				bne		bu_numberset	;goal?:yes-->bu_numberset
;
				ldx		#1000h			;rank check.
				lda     <rank_number,x
;
				idx8
				sep		#00010000b
;
				dec		a				;address(data) set.
;				asl		a
				tax
;
				mem16
				rep		#00100000b
				lda		>LANK_TABLE,x
;
				ldx		#07h
				sta		window_lank,x
;
				mem8
				sep		#00100000b		
;
				dex
				lda		#94h
				sta     window_lank,x
;-------------------------------
;										(DWNSIDE S_NUMBRE SET)
ds_numberset	lda		<game_mode
				cmp		#02
				beq		owari_M3
				lda		window_dwn		;downdide goal & display  check.
				bne		db_numberset	;goal?:yes-->db_numberset
;
				idx16				
				rep		#00010000b
;
				ldx		#1100h			;rank check.
				lda     <rank_number,x
;
				idx8
				sep		#00010000b
;
				dec		a				;address(data) set.
;				asl		a
				tax
;
				mem16
				rep		#00100000b
				lda		>LANK_TABLE,x
;
				ldx		#13h
				sta     window_lank,x
;
				mem8
				sep		#00100000b		
;
				dex
				lda		#94h
				sta     window_lank,x
;
owari_M3		mem16
				idx16
				rep		#00110000b
;
				plb						;0 bank set.
				rtl
;----------------------------------------
;
;----------------------------------------
;											(UPSIDE BIG_NUMBER SET)
bu_numberset	mem8
				idx16
				rep		#00010000b
;
				ldx		#1000h				;rank check.
				lda     <rank_number,x
;
				idx8
				sep		#00010000b
;
				dec		a					;address(data) set.		
				asl		a
;				asl		a
				tax
;
				mem16
				rep		#00100000b
				lda		>LANK_TABLE1,x
;
				ldx		#04
				sta		window_lank,x
;
				mem8
				sep		#00100000b
;				
				dex
				lda		#0ach
				sta     window_lank,x
				ldx		#0
				lda		#29h
				sta		window_lank,x
				ldx		#09
				lda		#01
				sta		window_lank,x
;--------------------------------
;											(UPSIDE1 BIG_NUMBER SET)
				idx16
				rep		#00010000b
;
				ldx		#1000h				;rank check.
				lda     <rank_number,x
;
				idx8
				sep		#00010000b
;
				dec		a					;address(data) set.
;				asl		a
				asl		a
				tax
;
				mem16
				rep		#00100000b
;
				inx
				inx
				lda     >LANK_TABLE1,x
				ldx		#07
				sta		window_lank,x			
;
				mem8
				sep		#00100000b
;
				dex		
				lda		#094h
				sta     window_lank,x
;
				jmp		ds_numberset
;-------------------------------------------------------
db_numberset	idx16						;(DOWNSIDE BIG_NUMBER)
				rep		#00010000b
;
				ldx		#1100h				;rank check.
				lda     <rank_number,x
;
				idx8
				sep		#00010000b
;
				dec		a					;address(data) set.
;				asl		a
				asl		a
				tax
;
				mem16
				rep		#00100000b
				lda		>LANK_TABLE1,x
;
				ldx		#10h				
				sta		window_lank,x
;
				mem8
				sep		#00100000b
;				
				dex
				lda		#0ach				;line data.
				sta     window_lank,x
;--------------------------------
				idx16						;(DOWNSIDE1 BIG_NUMBER)
				rep		#00010000b
;
				ldx		#1100h				;rank check.
				lda     <rank_number,x
;
				idx8
				sep		#00010000b
;
				dec		a					;address(data) set.
;				asl		a
				asl		a
				tax
;
				mem16
				rep		#00100000b
;
				inx
				inx
				lda     >LANK_TABLE1,x
				ldx		#13h
				sta		window_lank,x			
;
				mem8
				sep		#00100000b
;
				dex		
				lda		#094h				;line data set.
				sta     window_lank,x
;
				ldx		#0ch
				lda		#2fh
				sta		window_lank,x
;
				ldx		#15h
				lda		#01
				sta		window_lank,x
;
;
				plb							;0 bank set.
;
				mem16
				idx16
				rep		#00110000b
				rtl	
			
;===============================================
LANK_TABLE		DW	0f580h					;(SMALL NUMBER DATA)
				DW	0f5d0h
				DW	0f620h
				DW	0f670h
				DW	0f6c0h
				DW	0f710h
				DW	0f760h
				DW	0f7b0h
;===============================================
LANK_TABLE1		DW	0f800h					;(BIG NUMBER DATA)
				DW	0f8b0h
;
				DW	0f900h
				DW	0f9b0h
;
				DW	0fa00h
				DW  0fab0h
;
				DW	0fb00h
				DW	0fbb0h
;
				DW	0fc00h
				DW	0fcb0h
;
				DW	0fd00h
				DW	0fdb0h
;
				DW	0fe00h
				DW	0feb0h
;	
				DW	0ff00h
				DW	0ffb0h
;
				END
