;****************************************************************************
;*	Mario Kart							    *
;*			Driving control module				    *
;*							1992.07.13	    *
;****************************************************************************
		glb	Race_control,Ending_race
		glb	Calc_vector_velocity,Set_velocity
		glb	Battle_control,Lookup_accel_table
		glb	End_muteki_status,END_choropoo
;
		glb     Jump_status,Dont_move,Falling_water
		glb     Super_dash,Ultra_status,Spin_status
		glb     After_crash_accel,Dont_move,Super_dash_dash
		glb	End_super_dash
;----------------------------------------------------------------------------
		ext	Enemy_control_100,Enemy_control_200
		ext	Enemy_control_300,Start_title,Check_engine_status
		ext	Set_position,Count_down_sound,Trigger_sound_1
		ext	Calc_move_direction,Engine_power_control
		ext	Sin_data,Cos_data,Call_bgm,Check_trigger_SE
		ext	Calc_timer,Race_sound_init,Enemy_steering_control
		ext	Tire_effect,End_ultra_BGM,BGM_fade_out
		ext	Set_mark_point,Mykart_check,End_spin_crash
		ext	Event_control,Start_final_count,Init_record
		ext	Sound_control,Stop_subroutin,Mark_animation
		ext	Spin_jump,Spin_crash,Check_target_direction
;---------------------------------------------------------------------------
		include rp5a22
		include rp5c77
		include D77C25
		include work.def
		include buffer.def
		include ../join/object.def
;****************************************************************************
brake_button	equ	0100000000000000b
;----------------------------------------------------------------------------
force_x		equ	0000h
velo_x		equ	force_x
force_y		equ	0002h
velo_y		equ	force_y
;----------------------------------------------------------------------------
data_address	equ	0010h
				;pointer for loook up drive table
				;		dont brake !!!
;----------------------------------------------------------------------------
force_value	equ	0006h
tempolary	equ	0008h
steering_data	equ	000ah
gap_data	equ	000ch
angle_data	equ	0014h
resist_data	equ	016h
power_data	equ	0018h
address		equ	001ah		;need 4 byte area
;****************************************************************************
bank80		sect	rel
		mem16
		idx16
;--------------------------------------------------------------------------
Race_control
Battle_control
		ldx	<race_status
		jmp	(!Race_prosess,x)
Race_prosess
		word	Opening_demo_start,Skip_opening_demo
		word	Final_countdown
		word	Racing_status
		word	Quick_start;--------------------for debug
		word	Opening_demo_control
Quick_start
		jsr	!Skip_opening_demo
		lda	#0ffffh
		sta	!game_counter
		rts			
Opening_demo_start
		lda	#0ah
		sta	<race_status
		lda	#01h
		jsr     !Call_bgm
		rts
Skip_opening_demo
		jsr	!Enable_engine_sound
		bra	Start_signal
Demo_race
		rts
;----------------------------------------------------------------------------
Opening_demo_control
		ldx	<game_mode
		jmp	(!Opening_demo_address,x)
Opening_demo_address
		word	Demo_00,Demo_02,Demo_04
Demo_00
		jsr	!Set_demo_counter
		ldy	#0000h
		ldx	#1000h
		jsr	!Demo_subroutin
		bra	Next_demo
Demo_04
		jsr	!Set_demo_counter
Next_demo
		ldy	#0002h
		ldx	#1100h
		bra	Demo_subroutin
Demo_02
		jsr     !Set_demo_counter
		ldy	#0000h
		ldx	#1000h
Demo_subroutin
		lda	<obj_pos_yh,x
		asl	a
		asl	a
		cmp	!camera_y,y
		beq	Rotate_demo
		sec
		sbc	!camera_y,y
		beq	End_camera_move
		bmi	End_camera_move
		cmp	#0800h
		bcc	Not_over_300
		lda	#02100h
		sta	!demo_counter
Not_over_300
		lda	!demo_counter
		xba	
		and	#00ffh
Set_camera_pos		
		clc
		adc	!camera_y,y
		sta	!camera_y,y
		rts
End_camera_move
		lda	<obj_pos_yh,x
		asl	a
		asl	a
		sta	!camera_y,y
		bra	Enable_engine_sound
Rotate_demo
		lda	<obj_pos_yh,x
		asl	a
		asl	a
		sta	!camera_y,y
		lda	!Rotate_speed,y
		clc
		adc	!camera_direction,y
		sta     !camera_direction,y
		bne	Cont_rotate
Start_signal
		jsl	>Start_final_count
		lda	#0d0h
		sta	!signal_counter
;;;		lda	<game_status
;;;;		cmp	#04h				;time attack???
;;;;		bne	Not_time_attack
		stz	<frame_counter
		stz	<nmi_counter
;;;Not_time_attack
		jsl	>Init_record
		lda	#0004h
		sta	<race_status
		jsr	!Enable_camera
		ldx	<game_status
		lda	!Signal_data,x
		jmp	!Call_bgm			;start signal
Signal_data
		word	03h,02h,02h,02h		
;----------------------------------------------------------------------------
Enable_engine_sound
		lda	#0000000001000000b
		trb	!1000h+kart_flag
		trb	!1100h+kart_flag
Cont_rotate
		rts
;----------------------------------------------------------------------------
Final_countdown
		jsr	!Count_down_sound
		inc	!game_counter
		bne	Cont_count_down
End_final_count
		lda	#0006h
		sta	<race_status
;----------------------------------------------------------------------------
Enable_pause
		lda	#0000000011000000b
		ldx	<game_mode
		jmp	(!Start_pause,x)
Start_pause
		word	Mode_00_pause,Mode_02_pause,Mode_04_pause
Mode_00_pause
		trb	<camera_control+00h
Mode_04_pause
		trb	<camera_control+02h
		bra	Check_wheel_spin
Mode_02_pause
		trb	<camera_control+00h
;----------------------------------------------------------------------------
Check_wheel_spin
		ldx	#1000h
		ldy	#0000h
		jsr	!Check_wheel_spin_sub
		ldx	#1100h
		ldy	#0002h
Check_wheel_spin_sub
		lda	<kart_status,x
		bit	#01b
		beq	No_wheel_spin
		lda	!button_status,y
		bpl	Accel_off_spin
		lda	#04000h
		bra	Set_spin_engine	
Accel_off_spin
		lda	#03800h
Set_spin_engine
		sta	<engine_power,x
No_wheel_spin
		rts
;----------------------------------------------------------------------------
Enable_camera
		lda	#1100000000000000b
		ldx	<game_mode
		jmp	(!Start_camera,x)
;						;pause & display change OK
Start_camera
		word	Mode_00_camera,Mode_02_camera,Mode_04_camera
Mode_00_camera
		tsb	<camera_control+00h
Mode_04_camera
		tsb	<camera_control+02h
		rts
Mode_02_camera
		tsb	<camera_control+00h
Cont_count_down
		rts
;----------------------------------------------------------------------------
Set_demo_counter
		lda	!demo_counter
		bmi	Skip_count
		sec	
		sbc	#0040h
		cmp	#0300h
		bcs	Not_min_counter
		lda	#0300h
Not_min_counter
		sta	!demo_counter
Skip_count
		rts
;----------------------------------------------------------------------------
Rotate_speed
		word	00400h,-0400h
;----------------------------------------------------------------------------
Racing_status
		jsr	!Sound_control
		jsr	!Calc_timer
		jsr	!Check_mode
		jsr	!Mark_animation
Ending_race
		jsr	!Debug_001
		jsr	!Drive_control
		jsr	!Debug_002
Skip_control
		rts
;----------------------------------------------------------------------------
		mem16
Check_mode
		lda	!o_demo_flag
		beq	Not_demo_mode
		dec	!o_demo_counter
		bne	Cont_demo
		jsl	>BGM_fade_out
		jmp	!Start_title
Not_demo_mode
Cont_demo
		rts
;----------------------------------------------------------------------------
		mem16
Debug_001
		lda	!1f06h-01h
		bpl	Not_debug_mode
		mem8
		sep	#00100000b
		lda	#0ah
		sta	!2100h			;motion-control load chrck
		mem16
		rep	#00100000b
Not_debug_mode;
		rts
;----------------------------------------------------------------------------
Debug_002
		lda	!1f06h-01h
		bpl	Skip_debug
		mem8
		sep	#00100000b
		lda	#0fh
		sta	!2100h
		rep	#00100000b
Skip_debug
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Drive_control
		ldx	#1700h
Drive_loop_001
		lda	<kart_flag,x
		beq	Next_kart_100
		bmi	Mykart_drive
;----------------------------------------------------------------------------
Enemy_drive
		jsr	!Enemy_control_100
		bra	Next_kart_100
;----------------------------------------------------------------------------
Mykart_drive
		bit	#0100000000000000b
		bne	Mycar_uncontrol
		jsr	!Set_velocity
Mycar_uncontrol
		jsr     !Event_control
		jsr	!Set_direction
;----------------------------------------------------------------------------
Next_kart_100
		txa
		sec
		sbc	#0100h
		tax
		cmp	#1000h
		bcs	Drive_loop_001
;----------------------------------------------------------------------------
;Drive_control
		ldx	#1000h
		ldy	#0000h
		lda	!1000h+kart_flag
		beq	Control_1100h
		jsr	!Mykart_control
		jsr	!Check_engine_status
		jsr	!Tire_effect
Control_1100h
		ldx	#1100h
		ldy	#0002h
		lda     !1100h+kart_flag
		beq	Enemy_drive_control
		jsr     !Mykart_control
		jsr	!Check_engine_status
		lda	!g_kart_flag
		bne	Enemy_drive_control
		jsr	!Tire_effect
;----------------------------------------------------------------------------
Enemy_drive_control
		lda	!time_checker
		beq	OK_time_check
		stz	!time_checker
OK_time_check
		lda	<nmi_counter
		bit	#010b
		bne	Type_C
Type_A
		bit	#001b
		bne	Type_B
		ldx	#1200h
		bra	Loop_increce
Type_B
		ldx	#1600h
		bra	Loop_decrece
Type_C
		bit	#001b
		bne	Type_D
		ldx	#1300h
		bra	Loop_increce
Type_D
		ldx	#1700h
;----------------------------------------------------------------------------
Loop_decrece
		lda	!time_checker
		bne	Return_drive_control
		jsr	!Enemy_control_200
		txa
		sec
		sbc	#0200h
		cmp	#1300h
		bcc	End_drive_control
		tax
		bra	Loop_decrece
;----------------------------------------------------------------------------
Loop_increce
		lda	!time_checker
		bne	Return_drive_control
		jsr	!Enemy_control_200
		txa
		clc
		adc	#0200h
		cmp	#1800h
		bcs	End_drive_control
		tax
		bra	Loop_increce
;----------------------------------------------------------------------------
End_drive_control
		lda	!time_checker
		bne	Return_drive_control
		lda	<frame_counter
		and	#0000000000000111b
		ora	#0000000000010000b
		xba
		tax
		lda	<kart_flag,x
		beq	Return_drive_control
		bpl	Enemy_check
		jsr	!Mykart_check
		jsr	!Engine_power_control
		rts
Enemy_check
		jsr	!Enemy_control_300
Return_drive_control
		rts
;----------------------------------------------------------------------------
Enemy_kart
		jsr	!Enemy_control_200
		rts
;----------------------------------------------------------------------------
Control_comp
		jsr	!Check_target_direction
		and	#0ff00h
		pha
		sta	<point_direction,x
		jsr	!Enemy_steering_control		;a=point_direction
		pla
		sec
		sbc	<kart_direction,x
		bmi	Minus_comp_steering
		cmp	#0100h
		bcc	Stright_comp
		lda	#0000000100000000b
		bra	Set_steering_comp
Minus_comp_steering
		cmp	#-100h
		bcc	Left_comp
Stright_comp
		lda	#0000000000000000b
		bra	Set_steering_comp
Left_comp
		lda	#0000001000000000b
Set_steering_comp
		sta	<kart_control,x
		lda	<vector_velocity,x
		cmp	#200h
		bcs	Over_200_comp
		lda	#1000000000000000b
		bra	Set_accel_comp
Over_200_comp
		lda	#0100000000000000b
Set_accel_comp
		ora	<kart_control,x
		sta	<kart_control,x
Mykart_eint_exist
		rts
Skip_comp_check
		lda	<kart_control,x
Uncontrol_mykart
		rts
;----------------------------------------------------------------------------
Mykart_control
		lda	<kart_flag,x
		beq	Mykart_eint_exist
		bpl	Enemy_kart
		bit	#0100000000000000b
		bne	Uncontrol_mykart
		bit     #0000000000100000b
		beq	Control_player
		jsr	!Control_comp
		bra	Comp_steering
Control_player
Coin_effect
		lda	!player_coin,y
		and	#0ffh   
		cmp	#0ah
		bcc	Not_over_0ah
		lda	#0ah
Not_over_0ah
		asl	a
		asl	a
		asl	a
		clc
		adc	<max_velocity,x
		sta	<limmit_velocity,x
;
		lda	!button_trigger+01h,y
		and	#0011b			;right & left trigger!!!
		sta	<tempolary
		lda	!button_trigger+00h,y
		lsr	a
		lsr	a
		and	#0000000000001100b
		ora	!button_status+00h,y
		ora	<tempolary
		sta	<kart_control,x
Check_button
		bit	#0100000000000000b    ;A=kart control(button status)
		bne	Kart_braking_status
		bit	#0000000000110000b
		bne	Drift_button_on
		lda	<kart_status,x
		bit	#0000000000000010b	;dash & urtla status
		bne	Grip_level
		ldy	<resist_status,x
		lda	#40h
		sta	<steering_level,x
		lda	!Mu_level_data,y
Check_mu_level
		sta	<tempolary
		beq	Set_mu_effect
		ldy	!driver_number,x
		lda	!Mu_performanse_data,y
		clc
		adc	<tempolary
		bpl	Set_mu_effect
;Set_minimum
		lda	#0000h
		bra	Set_mu_effect
Comp_steering
		lda	#050h
		sta     <steering_level,x
		lda	#00h
		bra     Grip_mu
Grip_level
		lda	#40h
		sta	<steering_level,x
Grip_mu
		lda	#00h
		bra	Set_mu_effect
Kart_braking_status
Drift_button_on
		lda	#050h
		sta	<steering_level,x
		lda	#070h
Set_mu_effect
		sta	<mu_level,x
;----------------------------------------------------------------------------
Set_data_address
		lda	#player01_table
		cpx	#1000h
		beq	Play1_kart
Play2_kart
		lda	#player02_table
Play1_kart
		sta	<data_address
;----------------------------------------------------------------------------
		jsr	!Choropoo_effect
		jsr     !Drift_control
		jsr	!Calc_steering_angle
		jsr	!Calc_accelelation
		rts
;----------------------------------------------------------------------------
Choropoo_effect
		lda	<choropoo_flag,x		;Choropoo flag!!!
		bpl	Choropoo_off
		lda	<urtra_counter,x
		bne	End_choropoo
		lda	<kart_flag,x
		bit	#0000000000100000b
		bne	End_choropoo
		lda	<kart_control,x
		bit	#0011b
		beq	Not_left_right_trigger
		inc	<choropoo_counter,x
Not_left_right_trigger
		lda	<choropoo_counter,x
		and	#01111b
		cmp	#05h
		bcs	End_choropoo
		lda	<choropoo_timer,x
		cmp	#01*60			;timer 5 seconds
		bcs	Clear_choro_timer
		inc	a
		sta	<choropoo_timer,x
		rts
End_choropoo	
		lda	<choropoo_flag,x
END_choropoo
		and	#0111111111111111b
		sta	<choropoo_flag,x
		lda	#65h			;spin jump!!!
		jsl	>Check_trigger_SE				;y>>>break!!
Clear_choro_timer
		stz	<choropoo_timer,x
		stz	<choropoo_counter,x
Choropoo_off
		rts
;----------------------------------------------------------------------------
Mu_level_data
		word	020h                    ;road 01 (circuit&obake1)
		word	020h			;road 02 (obake2)
		word	020h			;road 03 (castle)
		word	030h			;     04 (grass)
		word	020h			;     05 (sand1)
		word	040h			;     06 (sand2)
		word	040h			;road 07 (dart)
		word	050h			;     04 (ice)
		word	020h			;	bridge
		word	060h			;gravle
		word	030h			;sand
		word	030h			;rock
		word	000h			;snow
		word	040h			;grass
		word	000h			;water
		word	060h			;mud
;----------------------------------------------------------------------------
Mu_performanse_data
		word	-00h,-00h,-00h,-00h,-00h,-10h,-10h,-00h
;----------------------------------------------------------------------------
		mem16
		idx16
Set_velocity
		mem8
		sep	#00100000b
		lda	#dsp_triangle
		sta	!DSP_data
		mem16
		rep	#00100000b
		lda	<move_direction,x
		sta	!DSP_data
		lda	<vector_velocity_l,x
		clc
		adc	<acceleration_l,x
		sta	<vector_velocity_l,x
		lda	<vector_velocity_h,x
		adc	<acceleration_h,x
		sta	<vector_velocity_h,x
		bpl	Vector_plus
		lda	#0000h
		sta	<vector_velocity_l,x
		sta	<vector_velocity_h,x
Vector_plus
		sta	!DSP_data
		lda	!DSP_status
		bpl	$-3
		lda	!DSP_data
		sta	<obj_velocity_x,x
		lda	!DSP_data
		eor	#0ffffh
		inc	a
		sta	<obj_velocity_y,x
		rts
;----------------------------------------------------------------------------
		mem8
		idx16
Calc_vector_velocity
		sep	#00100000b
		lda	#dsp_distance	;=28h(calc vector absolute)
		sta	!DSP_data
		mem16
		rep	#00100000b
		lda	<obj_velocity_x,x	;velocity x
		sta	!DSP_data		;vs
		lda	<obj_velocity_y,x	;velocity y
		sta	!DSP_data
		lda	#000h
		sta	!DSP_data		;velocity z=0
		lda     !DSP_status             ;DSP operation complete?
		bpl     $-3
		lda	!DSP_data
		sta	<vector_velocity_h,x
		rts
;----------------------------------------------------------------------------
Event_address
		word	Nomal_status,Jump_status
		word	Dont_move,Dont_move,Falling_water
		word	Dont_move,Dont_move,Dont_move
		word	Super_dash,Ultra_status,Spin_status
		word	After_crash_accel
;---------------------------------------------------------------------------
Calc_accelelation
		phx	
		lda	<move_status,x
		tax
		jmp	(!Event_address,x)
;----------------------------------------------------------------------------
After_crash_accel
		plx
		lda	<drift_index,x
		cmp	#016h
		bne	End_crash
		lda	<drift_angle,x
		beq	Shift_crash
		lda     #0ffffh
		sta     <acceleration_h,x
		lda	<drift_angle,x
		bpl	Plus_s_drift
		eor	#0ffffh
		inc	a
Plus_s_drift
		cmp	#04000h
		bcc	Not_over_4000h
		lda	#03f00h
Not_over_4000h
		xba
		lsr	a		;20h
		lsr	a		;10h
		and	#0000000000011110b
		tay
		lda	!After_crash_resist,y	
		sta	<acceleration_h,x
		rts
Shift_crash
		lda	#1ch
		sta	<drift_index,x
End_crash
		stz	<move_status,x
		rts
;----------------------------------------------------------------------------
After_crash_resist
		word	-04h,-08h,-10h,-018h,-24h,-38h,-40h,-55h
		rts
;----------------------------------------------------------------------------
Spin_status
		plx
		lda	#00-38h
		sta	<acceleration_h,x
		rts
;----------------------------------------------------------------------------
Dont_move
Not_use
		plx
		jsr	!Stop_subroutin
		rts
;----------------------------------------------------------------------------
Falling_water
		plx
		lda	<kart_control,x
		bpl	Accel_off_water
		lda	<vector_velocity,x
		cmp	#007ch
		bcs	Accel_off_water
		lda	#0001h
		sta	<acceleration_h,x
		rts
Accel_off_water
		lda	#0ffffh
		sta	<acceleration_h,x
		rts
;----------------------------------------------------------------------------
Drift_dash
		plx
		dec	<dash_counter,x
		beq	End_drift_dash
		lda	<limmit_velocity,x
		clc
		adc	#0c0h
		cmp	<vector_velocity,x
		bcs	D_dash_on
		sta	<vector_velocity,x
		bra	Dash_full
End_drift_dash
		lda	#1ch
		sta	<drift_index,x
		rts
D_dash_on
		lda	#0002h
		bra	Set_super_accel
;----------------------------------------------------------------------------
Super_dash
		plx
Super_dash_dash
		dec	<dash_counter,x
		beq	End_super_dash
Super_dash_on
		lda	#07e0h
		cmp     <vector_velocity,x
		bcs	Super_accel
		sta	<vector_velocity,x
Dash_full
		lda	#0000h
		bra	Set_super_accel
Super_accel
		lda	#00032h
Set_super_accel
		sta     <acceleration_h,x
		rts
End_super_dash
		lda	<kart_status,x
		and	#1111111100111111b
		sta	<kart_status,x
		stz	<move_status,x
		rts
;----------------------------------------------------------------------------
Ultra_status;
		plx
Ultra_status_dash
		lda	<kart_control,x
		bit	#brake_button		;A button brake
		bne	Ultra_brake
		bpl	Ultra_accel_off
		lda	<vector_velocity,x
		cmp	#0520h
		bcs	Ultra_brake
		cmp	#0300h
		bcc	Low_velocity_ultra
		lda	#002h
		bra	Set_ultra_accel
Low_velocity_ultra
		lda	#020h
		bra	Set_ultra_accel
Ultra_accel_off
		lda	#0fff8h
		bra	Set_ultra_accel
Ultra_brake
		lda	#0ffe0h
Set_ultra_accel
		sta	<acceleration_h,x
		rts
End_muteki_status
		lda	<event_index,x
		sta	<move_status,x
		jsr	!End_ultra_BGM
		lda	<kart_status,x
		and	#1111111111111100b
		sta	<kart_status,x
		rtl
;----------------------------------------------------------------------------
Remain_ultra
		lda	#012h
		sta	<move_status,x
		bra	Ultra_status_dash
;----------------------------------------------------------------------------
Jump_status
Spin_jump_accel
		plx
Kart_jumping
		lda	#00000h
		sta	<acceleration_h,x
		rts
		rts
;----------------------------------------------------------------------------
Spin_crash_accel
Drift_spin_accel
		plx
Emergency_brake
		lda	#0fff0h
		sta	<acceleration_h,x
		rts
;----------------------------------------------------------------------------
Banana_spin_accel
		plx
		lda	#0fff8h
		sta	<acceleration_h,x
		rts
;-----------------------------------------------------------------------------
Braking_data
Foot_brake_data
Resist_area_data 
		word	-004h,-00ah,-010h,-018h,-030h,-070h,-0a0h,-0c0h
Accel_and_brake_data
		word	-004h,-007h,-009h,-00ch,-01ch,-048h,-06eh,-0a0h
Engine_brake_data
		word	-004h,-006h,-008h,-00ah,-010h,-028h,-050h,-078h
Limmit_velocity_data
		word	-002h,-008h,-010h,-018h,-020h,-028h,-030h,-038h
;----------------------------------------------------------------------------
Nomal_status
		plx
		lda	<kart_status,x
		bit	#0000000000000010b
		bne	Remain_ultra
		lda	<kart_flag,x
		bit	#0000000010000000b
		bne	Emergency_brake
		bit	#1000000000000000b
		beq	Check_drift_accel
;Check_drift_effect
		lda	<kart_control,x
		bit	#0000000000110000b
		beq	Clear_d_dash_counter
		bit	#0000001100000000b
		beq	Clear_d_dash_counter
		lda	<d_dash_counter,x
		inc	a
		sta	<d_dash_counter,x
		cmp	#080h
		bcc	Not_enough_drift
		lda	<kart_status,x
		ora	#0000000001000000b
		sta	<kart_status,x
Not_enough_drift
		bra	Check_drift_accel
Clear_d_dash_counter
		stz	<d_dash_counter,x
Check_drift_accel	
		lda	<drift_index,x
		phx
		tax
		jmp	(!Accel_control_address,x)
;----------------------------------------------------------------------------
Accel_control_address
		word	Nomal_accel
		word	Drift_accel,Drift_accel
		word	Drift_accel,Drift_accel
		word	Banana_spin_accel,Banana_spin_accel
		word	Drift_spin_accel,Drift_spin_accel
		word	Drift_dash,Drift_dash
		word	After_crash_accel
		word	Spin_jump_accel
		word	Spin_crash_accel
		word	Corect_drift_accel
;----------------------------------------------------------------------------
Drift_accel
Nomal_accel
		plx
Accel_drift
		lda	<kart_control,x
		bit	#brake_button
		bne     Brake_button_on
Brake_button_off
		bpl	Engine_brake_status
;----------------------------------------------------------------------------
Accel_button_on
On_the_road
		lda     <resist_status,x
		clc
		adc	<data_address
		tay
		lda	!resist_address,y	;resist limmit velocity
		bmi	On_the_accel_area
On_the_resist_area
		sec
		sbc	<vector_velocity,x
		bcs	On_the_accel_area
;----------------------------------------------------------------------------
Resist_braking
		jsr     !Set_brake_sub
		lda	!Resist_area_data,y
		bra	Set_brake_data
Limmit_braking
		sec
		sbc	<limmit_velocity,x
		cmp	#200h
		bcc	Not_Over_200_limmit
		lda	#01ffh
Not_Over_200_limmit
		asl	a
		asl	a
		xba
		jsr	!Set_brake_sub_dash
		lda	!Limmit_velocity_data,y
		bra	Set_brake_data	
Brake_button_on
		bvs	Brake_button_status
Brake_and_accel
		jsr	!Set_brake_sub
		lda	!Accel_and_brake_data,y
		bra	Set_brake_data
Brake_button_status
		jsr     !Set_brake_sub
		lda	!Foot_brake_data,y
		bra	Set_brake_data
Engine_brake_status
		jsr	!Set_brake_sub
		lda	!Engine_brake_data,y
Set_brake_data
		sta	<acceleration_h,x
		rts
;----------------------------------------------------------------------------
Set_brake_sub
		lda	<vector_velocity+01h,x
Set_brake_sub_dash
		asl	a
		and	#0000000000001110b
		tay
		rts
;---------------------------------------------------------------------------
Corect_drift_accel
		plx
		bra	Grip_accel
On_the_accel_area
		lda	<thunder_timer,x
		beq	Nomal_size
		bpl	Nomal_thunder
		lda	<limmit_velocity,x
		sec
		sbc	#80h
		cmp	<vector_velocity,x
		bcc	Limmit_braking
		bra	Grip_accel
Nomal_thunder
		lda	<vector_velocity,x
		cmp	#02a0h
		bcs	Limmit_braking
Nomal_size
		lda	<choropoo_flag,x
		bpl	No_choropo
		lda	<vector_velocity,x
		cmp	#200h
		bcs	Limmit_braking
No_choropo
		lda	<vector_velocity_h,x
		cmp	<limmit_velocity,x
		bcs	Limmit_braking
Grip_accel
		mem8
		sep	#00100000b
		lda	#dsp_multiply
		sta	!DSP_data
		mem16
		rep	#00100000b
		lda	<vector_velocity,x
		cmp	#03ffh
		bcc	Under_velo_3ff
		lda	#0eh
		bra	Looup_v_effect
Under_velo_3ff
		sec
		sbc	#0300h
		bcs	Over_300h_ef
		lda	#00h
		bra	Looup_v_effect
Over_300h_ef
		lsr	a
		lsr	a
		lsr	a
		lsr	a
		and	#00eh
Looup_v_effect
		tay
		lda	!Velocity_effect,y
		sta	!DSP_data
;
		lda	<steering_angle,x
		sta	!DSP_data
		lda	!DSP_status
		bpl	$-3
		lda	!DSP_data
		clc
		adc	<steering_angle,x		
		sta	<steering_angle,x
;Not_full_steering
;----------------------------------------------------------------------------
		lda	<kart_status,x
		bit	#01h
		bne	Wheel_spin_accel
		jsr	!Lookup_accel_table
Set_accel_data
		stz	<acceleration_h,x
		sta	<acceleration_l+01h,x
		rts
;---Resist_braking
		jsr     !Set_brake_sub
		lda	!Resist_area_data,y
		jmp	!Set_brake_data
Wheel_spin_accel
		lda	#0c0h
		bra	Set_accel_data
;---------------------------------------------------------------------------
Lookup_accel_table
		lda	<vector_velocity_h,x
		cmp	#0400h
		bcc	Not_over_400
		lda	#03ffh
Not_over_400
		cmp	#0300h
		bcs	Over_300h
Over_300h
Not_over_200		
		asl	a
		asl	a
		asl	a
		and	#0fe00h
		xba
		clc
		adc	<data_address
		tay
		lda	!accel_address,y
		rts
;----------------------------------------------------------------------------
Velocity_effect
		word	0000h,-80h,-100h,-180h,-200h,-280h,-300h,-380h
;----------------------------------------------------------------------------
Calc_steering_angle
Mycar_steering
		lda	<kart_flag-01h,x
		bpl	Not_braking_steeering
		stz	<steering_angle,x
		rts
Not_braking_steeering
		lda	<steering_level,x
		clc
		adc	<data_address
		tay
		lda	<kart_status,x
		bit	#0000001000000000b
		beq	Not_spin_steering
		bit	#0000010000000000b
		bne	Not_spin_steering
		rts
Not_spin_steering
		lda	<kart_control,x
		bit	#0000001000000000b
		bne	Left_key_on
		bit	#0000000100000000b
		bne	Right_key_on
No_steering
		lda	<steering_angle,x
		bmi	Minus_no_key
		sec
		sbc	!slow_steering,y
		bcs	Set_steering_angle
		lda	#0000h
		bra	Set_steering_angle
Minus_no_key;----------------------------------------------------------------
		clc
		adc	!slow_steering,y
		bcc	Set_steering_angle
		lda	#0000h
		bra	Set_steering_angle
Left_key_on;-----------------------------------------------------------------
		lda	<steering_angle,x
		beq	Start_left
		bmi	Minus_left
Plus_left;-------------------------------------------------------------------
		sec
		sbc	!fast_steering,y
		bra	Set_steering_angle
Minus_left;------------------------------------------------------------------
		eor	#0ffffh
		inc	a
		cmp	!maximum_steering,y
		bcc	Not_over_left
		lda	!maximum_steering,y
		eor	#0ffffh
		inc	a
		bra     Set_steering_angle
Not_over_left
Start_left
		clc
		adc	!middle_steering,y
		eor	#0ffffh
		inc	a
		bra     Set_steering_angle
Right_key_on;----------------------------------------------------------------
		lda	<steering_angle,x
		bmi	Minus_right
Plus_right;------------------------------------------------------------------
		cmp	!maximum_steering,y
		bcc	Not_over_right
		lda	!maximum_steering,y
		bra	Set_steering_angle
Not_over_right
		clc
		adc	!middle_steering,y
		bra	Set_steering_angle
Minus_right;-----------------------------------------------------------------
		clc
		adc	!fast_steering,y
Set_steering_angle
		sta	<steering_angle,x
		rts
;----------------------------------------------------------------------------
Set_direction
		lda	<vector_velocity_h,x
		cmp	#0080h
		bcc	Low_steering
Shift_steering
		lda	!steering_angle,x
		cmp	#1000000000000000b
		ror	a
		cmp	#1000000000000000b
		ror	a
		cmp	#1000000000000000b
		ror	a
Set_kart_direction
		clc
		adc	<kart_direction,x
		sta	<kart_direction,x
		pha
		lda	<kart_flag,x
		bit	#0010000000000000b
		bne	Comp_countrol_direction
		pla
		pha
		clc
		adc	<drift_angle,x
		sta	<move_direction,x
		pla
  		sec
		sbc	<drift_pose,x
		sta	<body_direction,x
		rts
Comp_countrol_direction
		pla
		rts
;----------------------------------------------------------------------------
Low_steering						;A=vector_velocity
		ldy	<kart_status,x
		bmi	Shift_steering
		ldy	<event_index,x
		cpy	#08h
		bne	Not_in_the_water
		ldy	#010h				;special data!!!
		bra	Set_low_steering
Not_in_the_water
		stz	<steering_angle,x
		lsr	a
		lsr	a
		lsr	a
		and	#1111111111111110b
		tay
Set_low_steering
		lda	<kart_flag,x
		bit	#010000000000000b
		bne	Not_steering
		lda	<kart_control,x
		bit	#0000001000000000b
		bne	Left_steering
		bit	#0000000100000000b
		bne	Right_steering
Not_steering
		lda	#0000h
		bra	Set_kart_direction
Right_steering
		lda	!Low_steering_table,y
		bra	Set_kart_direction
Left_steering
		lda	!Low_steering_table,y
		eor	#0ffffh
		inc	a
		bra	Set_kart_direction
;----------------------------------------------------------------------------
after_crash_index	equ	0016h
level02_crash		equ	after_crash_index
spin_jump_index		equ	0018h
spin_crash_index	equ	001ah
;----------------------------------------------------------------------------
drift_start_velo	equ	0000h
drift_timer		equ	0002h
drift_limmit_01		equ	0004h
drift_limmit_02		equ	0006h
drift_velo_01		equ	0008h
drift_velo_02		equ	000ah
;----------------------------------------------------------------------------
Spin_R
		plx
		lda	<kart_status,x
		ora	#0000000000001000b
							;b3=spin smoke flag
		sta	<kart_status,x
		bit	#0010b
		bne	End_spinR
		lda	<vector_velocity,x
		cmp	#0180h
		bcs	Set_spinR
		jsr	!Set_spinR
		bcc	End_spinR
		rts		
Set_spinR
		lda	<drift_pose,x
		sec
		sbc	#0480h
		sta	<drift_pose,x
Cont_spinR
		rts
;----------------------------------------------------------------------------
Spin_L
		plx
		lda	<kart_status,x
		ora	#0000000000001000b
							;b3=spin smoke flag
		sta	<kart_status,x
		bit	#0010b
		bne	End_spinL
		lda	<vector_velocity,x
		cmp	#0180h
		bcs	Set_spinL
		jsr	!Set_spinL
		bcc	Cont_spinL
End_spinL
End_spinR
		lda	#01ch
		sta	<drift_index,x
		rts		
Set_spinL
		lda	<drift_pose,x
		clc
		adc	#0480h
		sta	<drift_pose,x
Cont_spinL
		rts
;----------------------------------------------------------------------------
Banana_R
		plx
		lda	<kart_status,x
		ora	#0000000000001000b
							;b3=spin smoke flag
		sta	<kart_status,x
		bit	#0010b
		bne	End_banana_spin
		lda	<drift_counter,x
		bne	Cont_banana_R
		lda	<vector_velocity,x
		cmp	#100h
		bcs	Set_banana_R
		stz	<vector_velocity,x
		jsr	!Set_spinR
		bcc	End_spinR
		rts		
Cont_banana_R
		dec	<drift_counter,x
Set_banana_R
		lda	<drift_pose,x
		sec
		sbc	#0a00h
		sta	<drift_pose,x
		rts
;----------------------------------------------------------------------------
Banana_L
		plx
		lda	<kart_status,x
		ora	#0000000000001000b
							;b3=spin smoke flag
		sta	<kart_status,x
		bit	#0010b
		bne	End_banana_spin
		lda	<drift_counter,x
		bne	Cont_banana_L
		lda	<vector_velocity,x
		cmp	#100h
		bcs	Set_banana_L
		stz	<vector_velocity,x
		jsr	!Set_banana_L
		bcc	Cont_banana_spin
End_banana_spin
		lda	#0000010000000000b
		ora	<kart_status,x
		sta	<kart_status,x
		lda	#01ch
		sta	<drift_index,x
		lda	#2ah
		jsl	>Check_trigger_SE
		rts		
Cont_banana_L
		dec	<drift_counter,x
Set_banana_L
		lda	<drift_pose,x
		clc
		adc	#00a00h
		sta	<drift_pose,x
Cont_banana_spin
		rts
;----------------------------------------------------------------------------
Low_steering_table		;v=00,10,20,30------80h
		word	00h,10h,020h,030h,038h,03ch,03eh,040h,080h
;----------------------------------------------------------------------------
After_crash
		plx
		lda	<kart_control,x
		bmi	Special_drift_accel_
		lda	<vector_velocity,x
		cmp	#0010h
		bcc	Clear_drift_angle
		rts
Special_drift_accel_
		lda	<vector_velocity,x
		cmp	#0c0h
		bcc	Clear_drift_angle
		lda	<drift_pose,x
		beq	Nomore_reset_pose
		bmi	Minus_reset_pose
		sec
		sbc	#0040h
		bcs	Cont_reset_pose
		bra	End_reset_pose
Minus_reset_pose
		clc
		adc	#0040h
		bcc	Cont_reset_pose
End_reset_pose
		lda	#0000h
Cont_reset_pose
		sta	<drift_pose,x
Nomore_reset_pose
		lda	<drift_angle,x
		beq	Clear_drift_pose
		bmi	Minus_reset_angle
		sec
		sbc	#0040h
		bcc	Clear_drift_angle
		bra	Cont_special_drift
Minus_reset_angle
		clc
		adc	#0040h
		bcs	Clear_drift_angle
Cont_special_drift
		sta	<drift_angle,x
		rts
Clear_drift_angle
		stz	<drift_angle,x
Clear_drift_pose
		lda	#01ch
		sta	<drift_index,x
		stz	<move_status,x
		rts
;----------------------------------------------------------------------------
Drift_control
		lda	<kart_status,x
		bit	#0000000000000001b
		bne	Wheel_spin_kart
		and	#1111111111010011b
						;clear drift &spin smoke
		sta	<kart_status,x
Wheel_spin_kart
		ldy	<mu_level,x
		phx
		lda	<drift_index,x
		tax
		jmp	(!Drift_address,x)
Drift_address
		word	Grip_status,Drift_status,Drift_status
		word	Drift_status,Drift_status
		word	Banana_R,Banana_L
		word	Spin_R,Spin_L
		word	Dash_R,Dash_L
		word	After_crash;-------------------16h
		word	Spin_jump
		word	Spin_crash
		word	Super_grip
;----------------------------------------------------------------------------
Dash_R
Dash_L
		plx
		cpy	#070h			;drift button on?
		beq	Drift_button_dash	
		rts
;----------------------------------------------------------------------------
Grip_status
		plx   
Drift_button_dash
		stz	<drift_counter,x
		lda	!game_level
		cmp	#04h
		bne	Not_150cc_drift
		lda	<vector_velocity,x
		clc
		adc	#120h
		bra	Check_drift_limmit
Not_150cc_drift
		lda	<vector_velocity,x
		cmp	#0100h
		bcc	Cont_grip
Check_drift_limmit
		sec
		sbc	<max_velocity,x
		bcs	Drift_start
		cmp	!Drift_data+drift_start_data,y
		bcc	Cont_grip
		lda	<steering_angle,x
		bpl	Plus_ST_check
		eor	#0ffffh
		inc	a
Plus_ST_check
		cmp	#300h
		bcc	Cont_grip
Drift_start	
		lda	#02h
		sta	<drift_index,x
		rts
Cont_grip
		jsr	!Correct_drift
		rts				
;----------------------------------------------------------------------------
Super_grip
		plx
		ldy	#00h
		jsr	!Correct_drift
		lda	<drift_angle,x
		beq	Correct_pose
		bmi	Minus_grip
		cmp	#4000h
		bcc	Not_over_def
Over_def
		lda	#16h
		sta	<drift_index,x
		sta	<move_status,x
		rts
Minus_grip
		cmp	#-4000h
		bcc	Over_def
Not_over_def
		rts
Correct_pose
		lda	<drift_angle,x
		bne	Cont_super_grip
;End_correct
		stz	<drift_index,x
Cont_super_grip
		rts
;----------------------------------------------------------------------------
Correct_drift
		lda	<drift_pose,x
		bmi	Minus_correct_pose
		sec
		sbc	!Drift_data+pose_speed,y
		bcc	Pose_zero_clear
		bra	Set_correct_pose
Minus_correct_pose
		clc
		adc	!Drift_data+pose_speed,y
		bcc	Set_correct_pose
Pose_zero_clear
		lda	#0000h
Set_correct_pose
		sta	<drift_pose,x
;
		lda	<drift_angle,x
		bmi	Minus_correct_angle
		sec
		sbc	!Drift_data+off_speed,y
		bcc	Angle_zero_clear
		bra	Set_correct_angle
Minus_correct_angle
		clc
		adc	!Drift_data+off_speed,y
		bcc	Set_correct_angle
Angle_zero_clear
		lda	<kart_status,x
		bit	#0000000001000000b		;drift dash OK?
		bne	Goto_drift_dash
		stz	<drift_index,x
		rts
Set_correct_angle
		sta	 <drift_angle,x
		rts
Goto_drift_dash
		and	#1111111110111111b
		sta	<kart_status,x
		lda	#12h
		sta	<drift_index,x
		lda	#030h
		sta	<dash_counter,x
		rts
;----------------------------------------------------------------------------
Drift_status	
		plx
		cpy	#0000h
		bne	Not_super_grip
		lda	#01ch
		sta	<drift_index,x
		rts
Not_super_grip
		lda	<vector_velocity,x
		cmp	#0100h
		bcs	Cont_drift
		lda     #01ch
		sta	<drift_index,x
		rts
Cont_drift
		lda	<kart_control,x
		bmi	Accel_on_drift
		bit	#0000000000110000b
		beq	Off_drift
		lda	<vector_velocity,x
		cmp	#01c0h
		bcc	Off_drift
		lda     <kart_control,x
Accel_on_drift
		bit	#0000001000000000b
		bne	Left_drift
		bit	#0000000100000000b
		bne	Right_drift
Off_drift
		jsr	!Decrece_counter
		jsr	!Correct_drift
		rts
Right_drift
		jsr	!Right_pose
		lda	<drift_angle,x
		bpl	Gyakuhan_R
		jsr	!Counter_increce_R
		sec
		sbc	!Drift_data+angle_speed,y
		bpl	Plus_drift
Minus_drift
		eor	#0ffffh
		inc	a
		cmp	!Drift_data+angle_limmit,y
		bcc	Not_over_minus_d
		lda	!Drift_data+angle_limmit,y
		eor	#0ffffh
		inc	a
		sta	<drift_angle,x
		rts
Gyakuhan_R
		jsr	!Counter_decrece_R
		sec
		sbc	!Drift_data+gyakuhan_speed,y
		bmi	Minus_drift
		bra	Plus_drift
Gyakuhan_L
		jsr     !Counter_decrece_L
		clc
		adc	!Drift_data+gyakuhan_speed,y
		bmi	Minus_drift
		bra     Plus_drift
Not_over_minus_d
		eor	#0ffffh
		inc	a
		sta	<drift_angle,x
		rts
Left_drift
		jsr	!Left_pose
		lda	<drift_angle,x
		bmi	Gyakuhan_L
		jsr	!Counter_increce_L
		clc
		adc	!Drift_data+angle_speed,y
		bmi	Minus_drift
Plus_drift
		cmp	!Drift_data+angle_limmit,y
		bcc	Not_over_plus_d
		lda	!Drift_data+angle_limmit,y
		sta	<drift_angle,x
		rts
Not_over_plus_d
		sta	<drift_angle,x
		rts
;----------------------------------------------------------------------------
Decrece_counter
		pha
		lda	!Drift_data+drift_count_data,y
		adc	#0e0h
		sta	<tempolary
		lda	<drift_counter,x
		bmi	Dec_minus
		bra	Dec_plus
Counter_decrece_R
		pha
		lda	<drift_counter,x
Dec_plus
		sec
		sbc	<tempolary
		sta	<drift_counter,x
		pla
		rts
Counter_decrece_L
		pha
		lda	<drift_counter,x
Dec_minus
		clc
		adc	<tempolary
		sta	<drift_counter,x
		pla
		rts
;----------------------------------------------------------------------------
Counter_increce_R
		pha
 		lda	<drift_counter,x
		clc
		adc	!Drift_data+drift_count_data,y
		sta	<drift_counter,x
		bmi	Not_start_spin
		cmp	#07a00h				;limmit time!!!
		bcc	Not_start_spin
		lda	#0eh
		sta	<drift_index,x			;Start spin!!!
Not_start_spin
		pla
		rts
;---------------------------------------------------------------------------
Counter_increce_L
		pha
 		lda	<drift_counter,x
		sec
		sbc	!Drift_data+drift_count_data,y
		sta	<drift_counter,x
		bpl	Not_start_spin
		cmp	#-07a00h			;limmit time!!!
		bcs	Not_start_spin
		lda	#10h
		sta	<drift_index,x			;Start spin!!!
		pla
		rts
;---------------------------------------------------------------------------
Left_pose
		lda	<drift_pose,x
		bmi	Pose_increce			;abs decrese
		jsr	!Check_smoke_slip
		cmp	!Drift_data+pose_limmit,y
		bcs	Pose_decrece
Pose_increce
		lda	<drift_pose,x
		clc
		adc	!Drift_data+pose_speed,y
		sta	<drift_pose,x
		rts
;---------------------------------------------------------------------------
Right_pose
		lda	<drift_pose,x
		bpl	Pose_decrece
		eor	#0ffffh
		inc	a
		jsr     !Check_smoke_slip
		cmp	!Drift_data+pose_limmit,y
		bcs	Pose_increce
Pose_decrece
		lda	<drift_pose,x
		sec
		sbc	!Drift_data+pose_speed,y
		sta	<drift_pose,x
		rts
;----------------------------------------------------------------------------
Check_smoke_slip					;A=|drift_pose|
		pha
		cmp	#01800h
		bcs	Over_18_drift
		cmp	#00c00h
		lda	<kart_status,x
		bcs	Over_0c_drift
;Under_0c
		and	#1111111111011011b
		bra	Set_kart_status
Over_18_drift
		lda	<kart_status,x
		ora	#0000000000100100b
		bra	Set_kart_status
Over_0c_drift
		and	#1111111111011111b
		ora	#0000000000000100b
Set_kart_status
		sta	<kart_status,x
		pla
		rts
;----------------------------------------------------------------------------
drift_start_data	equ	0000h
drift_count_data	equ	0002h
angle_limmit		equ	0004h
angle_speed		equ	0006h
off_speed		equ	0008h
gyakuhan_speed		equ	000ah
pose_speed		equ	000ch
pose_limmit		equ	000eh
;----------------------------------------------------------------------------
Drift_data
;Grip status
		word	-010h
		word	0100h
		word	0800h
;
		word	0080h
		word	00a0h
		word	00c0h
;	
		word	00e0h
		word	0800h
;Road Mu200%						(mu level=10h)
					;circuit,obake&castle
;
		word	-030h			;dirft_start_data
		word	0040h			;drift_count_data
		word	0900h			;angle_limmit
;
		word	0040h			;angle_speed
		word	0060h			;off
		word	0080h			;gyakuhan
;
		word	0120h			;pose_speed
		word	1100h			;pose_limmit
;Road Mu100%						(mu level=20h)
					;circuit,obake&castle
;
		word	-020h			;dirft_start_data
		word	0100h			;drift_count_data
		word	1800h			;angle_limmit
;
		word	0040h			;angle_speed
		word	0060h			;off
		word	0080h			;gyakuhan
;
		word	0120h			;pose_speed
		word	2100h			;pose_limmit
;
;Road Mu080%						(mu level=30h)
		word	-040h		;grass & sand
		word	0110h
		word	2000h
;
		word	0080h
		word	00c0h
		word	0100h
;
		word	0140h
		word	2100h
;Road Mu060%							40h
		word	-100h		;dart zone
		word	0120h		
		word	2800h
;
		word	00c0h
		word	0120h
		word	0100h
;
		word	0180h
		word	2100h
;Road Mu040%							50h
		word	-200h		;ice zone
		word	0140h
		word	3000h
;
		word	0100h
		word	0180h
		word	0200h
;
		word	0200h
		word	2900h
;Slip zone							60h
		word	-300h
		word	0200h
		word	2800h
;
		word	0240h
		word	0360h
		word	0480h
;
		word	0280h
		word	3100h
;drift button							70h
		word	-200h
		word	00e0h
		word	2000h
;
		word	0140h
		word	01e0h
		word	0280h
;
		word	0200h
		word	2900h
;----------------------------------------------------------------------------
		end
