;****************************************************************************
;*	Mario Kart							    *
;*			Main routin control module			    *
;*							1992.07.13          *
;****************************************************************************
		glb	Tire_effect
		glb	Color_effect,Check_engine_status
		glb	Set_mark_point,End_spin_crash
		glb	Event_control,Stop_subroutin
		glb 	Camera_spin,Spin_jump,Spin_crash,Spin_crash_sub
		glb	Fade_control,Engine_power_control
;----------------------------------------------------------------------------
		ext	Grip_control,Area_check,END_choropoo
		ext	Calc_target,Start_ultra_BGM,Check_drift_data
		ext	Initial_address,Check_trigger_SE
		ext     Trigger_sound_1,Trigger_sound_2
		ext	Check_crash_mykart,Check_crash_enemy
;----------------------------------------------------------------------------
		include	rp5a22
		include rp5c77
                include D77C25
		include work.def
		include buffer.def
		include ../join/object.def
;****************************************************************************
;		data
;****************************************************************************
;
tempolary	equ	000h
mark_x		equ	002h
mark_y		equ	004h
;
inkey_status	equ	010h		;fixed
trigger_status	equ	012h
;
old_pos_y	equ	0eh		;fixed---Area check(kart-bg)
new_pos_y	equ	0ch		;fixed		;
new_pos_x	equ	0ah		;fixed		;
;----------------------------------------------------------------------------
bank80		sect	rel
;----------------------------------------------------------------------------
		mem16
		idx16
Check_engine_status
		lda	<kart_status,x
		bit	#01h
		beq	Not_wheel_spin
		lda	<kart_control,x
		bmi	Accel_on_spin
		lda	#-0880h/8
		bra	Check_e_power
Accel_on_spin
		lda	#-0280h/8
Check_e_power
		ldy	!engine_power,x
		cpy	#2000h
		bcc	Clear_wheel_spin
		clc
		adc	<engine_power,x
		sta	<engine_power,x
		lda	<kart_status,x
		ora	#0000000000100000b
		sta	<kart_status,x
		rts
Clear_wheel_spin
		lda	<kart_status,x
		and	#1111111111011110b
		sta	<kart_status,x
Not_wheel_spin
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Engine_power_control
		lda	<perapera_flag,x		;perapera?
		beq	Nomal_status_power
		stz	<engine_power,x
		rts
Nomal_status_power
		lda	<kart_status,x
		bit	#01h
		beq	Check_control
		rts
Check_control
		lda	#0100000000000000b
		bit	<kart_control,x
		bne	Braking_sound
		bmi	Accel_on_sound
Braking_sound
;Accel_off_sound
		lda	!engine_brake
		bra	Calc_engine_power
Drift_status
		lda	!max_power
		sec	
		sbc	#01800h
		cmp	!engine_power,x
		bcs	Accel_sound
		lda	!engine_drift
		bra     Calc_engine_power
On_the_resist
		lda	<engine_power,x
		cmp	#01000h
		bcc	Increce_velocity
		lda	!engine_resist
		bra	Calc_engine_power
Accel_on_sound
		lda	<resist_status,x
		cmp	#14h			;n<=08h	accel area
						;n>=0ah resist area
		bcs	On_the_resist
		lda	<kart_status,x
		bit	#0000000000000100b	;slip sound?
		bne	Drift_status
Accel_sound
		lda	<engine_power,x
Increce_velocity
		cmp	#2000h
		bcs	High_velo_sound
		lda	!engine_accel_l
		bra     Calc_engine_power
High_velo_sound
		lda	engine_accel_h
Calc_engine_power
		clc
		adc	<engine_power,x
		bmi	Minus_engine
		cmp	#0100h
		bcs	Plus_engine
Minus_engine
		lda	#0100h
Plus_engine
		cmp	!max_power
		bcc	Set_engine_power
		lda	!max_power
Set_engine_power
		sta	<engine_power,x
		rts
;----------------------------------------------------------------------------
						;fade in(start)
						; fade control=00001h
						;fade out(start)
						; fade control=08f00h
		mem16
		idx16
Fade_control
		lda	<fade_control
		beq	No_change_fade
		bpl	Fade_in_status
;----------------------------------------------------------------------------
Fade_out_status
		sec
		sbc	!fade_speed
		cmp	#08000h
		bcs	Not_reach_min
		stz	<fade_control
;						;end blanking
		lda	#8000h
		bra	Set_PPU_control		;blanking!!!
Not_reach_min
		sta	<fade_control
		and	#0111111111111111b
		bra	Set_PPU_control
;----------------------------------------------------------------------------
Fade_in_status
		clc
		adc	!fade_speed
		cmp	#0f00h
		bcc	Not_reach_max
		stz	<fade_control
		lda	#0f00h
		bra	Set_PPU_control		;max blightness	
Not_reach_max
		sta	<fade_control
;----------------------------------------------------------------------------
Set_PPU_control
		sta	!fade_data+00h
No_change_fade
		mem8
		sep	#00100000b
		lda	!fade_data+01h
		sta	!PPU_control
		mem16
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
Event_control
		phx
		lda	<event_index,x
		tax
		jmp	(!Event_address,x)
;----------------------------------------------------------------------------
Event_address					;event index=
		word	Nomal_status				;00h
		word	Jump_status				;02h
		word	Falling_obake				;04h
		word	Falling_maguma				;06h
		word	Falling_water				;08h
		word	Out_of_bounds				;0ah
		word	Move_by_force				;0ch
		word	Kart_lift_down				;0eh
;----------------------------------------------------------------------------
Jump_status
		plx
		lda	<obj_velocity_z,x
		sec
		sbc	#001ah			;gravity data
		sta	<obj_velocity_z,x
		clc
		adc	<obj_pos_zh-01h,x
		bpl	Not_over_jump
		stz	<obj_pos_zh-01h,x
		stz	<obj_velocity_z,x
		lda	<kart_status,x
		and	#0111111111111111b	;Clear_jump_flag
		sta	<kart_status,x
		lda	<bg_data,x
		bmi	Randing_wall
		cmp	#5ch
		bcc	Not_randing_water
		lda	#4ch
		bra	Set_randing_sound
Not_randing_water
		cmp	#22h
		bne	Randing_grand
		lda     #4ch
		jsl     >Check_trigger_SE
		jmp	!Drop_water
Randing_grand
Randing_wall
		lda	#25h
Set_randing_sound
		jsl	>Check_trigger_SE
		stz	<event_index,x
		lda	<move_status,x
		cmp	#10h
		beq	Cont_dash
		stz	<move_status,x
Cont_dash
		rts
Not_over_jump
		sta	<obj_pos_zh-01h,x
		rts
;----------------------------------------------------------------------------
Falling_obake
		plx
		dec	<kart_counter,x
		bne	Cont_obake_fall	
;Goto_return					;end falling animation
		lda	#03000h
		sta	<obj_pos_zh-01,x
		lda	#0ch			;start MOVE BY FORCE!!!
		sta	<event_index,x
						;set jugem official
Cont_obake_fall
		rts
;----------------------------------------------------------------------------
Falling_maguma
Out_of_bounds
		plx
		lda	<kart_flag,x
		bit	#0010000000000000b
		beq	Player_cont_maguma
		lda	#007h
		sta	<obj_pos_zh,x
Player_cont_maguma
		lda	<obj_pos_zh,x
		bmi	Cont_maguma_fall
		cmp	#007h
		bcc	Cont_maguma_fall
		lda	#0ch
		sta	<event_index,x		;move by force
Cont_maguma_fall
Return_water_fall
		rts
;----------------------------------------------------------------------------
Falling_water
		plx
		lda	<kart_counter,x
		beq	End_move_under_water
		dec	<kart_counter,x
		cmp	#water_limmit_time
		bcs	Return_water_fall
Cant_move_water
		cmp	#water_limmit_time-water_warning_time
		bcs	Not_warning_water
		lda	<kart_flag,x
		ora	#0000000100000000b
		sta	<kart_flag,x		;set water warning bit
		lda	#0000010000000000b
		ora	<official_control,x
		sta	<official_control,x	;wait fishing jugem
Not_warning_water
		jsr	!Set_mark_point
Not_area_out_water
		lda	<bg_data,x
		cmp	#024h
		bne	Not_deep_water
End_move_under_water
		jsr	!Clear_water_warning
		jmp	!Drop_deep_water		;kart maguma fall!!!
Not_deep_water
		cmp	#022h
		beq	Continue_water	
		cmp	#080h
		bcs	Continue_water
		lda	<kart_status,x
		ora	#0000000000010000b
		sta	<kart_status,x			;splash!!!!
		lda	#0000001000000000b
		ora	<official_control,x
		sta	<official_control,x     ;clear wait fishing jugem
		jsr	!Clear_water_warning
Jumping_out
		lda	#100h
		sta	<vector_velocity,x
		lda	#03e00h
		jsr	!Calc_bord_jump
		lda	#021h
		jsr	!Check_trigger
		lda	#002h
		jmp	!Set_move_status
;----------------------------------------------------------------------------
Clear_water_warning
		lda	<kart_flag,x
		and	#1111111011111111b
		sta	<kart_flag,x
Continue_water
		rts
;----------------------------------------------------------------------------
Warning_on
Warning_off
Lift_up
Check_mykart
;----------------------------------------------------------------------------
Move_by_force
		plx
		jsr	!Correct_direction
;						;for player's 
Move_X
		lda	<obj_pos_xh,x
		cmp	<mark_pos_x,x
		beq	Move_Y
		bit	#8000h
		bmi	Inc_pos_x
		sec
		sbc	<mark_pos_x,x
		bcs	Dec_pos_x
		cmp	#0fffdh
		bcs	Reach_x
Inc_pos_x
		lda	<obj_pos_xh,x
		clc
		adc	#0002h
		sta	<obj_pos_xh,x
		rts		
Dec_pos_x
		cmp	#0003h
		bcc	Reach_x
		lda	<obj_pos_xh,x
		sec
		sbc	#0002h
		sta	<obj_pos_xh,x
		rts
Reach_x
		lda	<mark_pos_x,x
		sta	<obj_pos_xh,x
		rts
;----------------------------------------------------------------------------
Move_Y
		sta	<new_pos_x		;use AREA CHECK
		lda	<obj_pos_yh,x
		sta	<old_pos_y
		bmi	Inc_pos_y
		sec
		sbc	<mark_pos_y,x
		bcs	Dec_pos_y
		cmp	#0fffdh
		bcs	Reach_y
Inc_pos_y
		lda	<obj_pos_yh,x
		adc	#0002h
		bra	Cont_move_y
Dec_pos_y
		cmp	#0003h
		bcc	Reach_y
		lda	<obj_pos_yh,x
		sbc	#0002h
						;clc dont reach mark pos
Cont_move_y
		sta	<obj_pos_yh,x
		sta	<new_pos_y
;
		jsr	!Area_check
;
		rts
Reach_y
		lda	<mark_pos_y,x
		sta	<obj_pos_yh,x
		lda	<kart_flag,x
		bit	#0010000000000000b
		bne	Enemy_cont_force
		lda     #0000000001000000b
		ora	<official_control,x
		sta	<official_control,x	;lift down jugem
						;Change mark directioin
						;Kart lift down
Enemy_cont_force
		lda	#00eh
		sta	<event_index,x		;event lift down
		rts
;----------------------------------------------------------------------------
Kart_lift_down
		plx
		jsr	!Correct_direction
						;end approaching
		bcc	Cont_rotate
		lda	<obj_pos_zh-01h,x
		sec
		sbc	#0080h
		bcc	End_approaching
		sta	<obj_pos_zh-01,x
		rts
End_approaching
		stz	<obj_pos_zh-01h,x
		stz	<event_index,x
		stz	<move_status,x
Cont_rotate
		rts	
;----------------------------------------------------------------------------
Correct_direction
		lda	<kart_direction,x
		sec
		sbc	<mark_direction,x
		beq	Reach_direction
		bpl	Right_turn
;Left_turn
		cmp	#0fe00h
		bcs	Ajust_direction
		lda	<kart_direction,x
		clc
		adc	#0140h
		bra	Set_direction
Ajust_direction
		lda	<mark_direction,x
		bra	Set_direction
Right_turn
		cmp	#0200h
		bcc	Ajust_direction
		lda	<kart_direction,x
		sec
		sbc	#0140h
Set_direction
		sta	<kart_direction,x
		sta	<body_direction,x
		sta	<move_direction,x
		clc
Reach_direction
		rts		
;----------------------------------------------------------------------------
Set_mark_point
		lda	<kart_area,x
		and	#00ffh
		asl	a
		tay
		lda	!target_bufferX,y
		sta	<mark_pos_x,x
		lsr	a
		lsr	a
		lsr	a
		lsr	a
		sta	<tempolary
		lda	!target_bufferY,y
		sta	<mark_pos_y,x
		asl	a
		asl	a
		and	#0000111111000000b
		ora	<tempolary
		phx
		tax
		lda	>drive_direction-01h,x
		plx
		sta	<mark_direction,x
		rts
;----------------------------------------------------------------------------
Illegal_area
		word	Start_falling,Start_water,Start_maguma
		word	Start_out_of_bounds,Special_fall
Special_status
		word	Start_board_jump,Start_dart_jump
		word	Block01,Dash_mark
		word	Start_slip_mark,Coin_mark,Start_dart_jump,Black_hall
;----------------------------------------------------------------------------
Block01
Coin_mark
		plx
		rts
;----------------------------------------------------------------------------
Nomal_status
		plx
;
		lda	<game_status
		cmp	#06h
		bcc	Check_nomal_event
		lda	<bg_data,x
		cmp	#5ah
		bne	Check_nomal_event
		jmp	!Start_out_of_bounds_dash
Check_nomal_event
		lda     <kart_control,x
		bpl     Clear_d_dash_counter
		bit     #0000001100000000b
		beq     Clear_d_dash_counter
		bit     #0000000000110000b
		beq     Clear_d_dash_counter
		inc     <d_dash_counter,x
		bra	Check_crash_bit
Clear_d_dash_counter
		stz	<d_dash_counter,x
Check_crash_bit
		lda	<kart_flag,x
		bit	#0001000000000000b
		beq     Goto_check
		bit	#0010000000000000b
		beq	Mykart_crash
Enemy_crash
		jsr	!Check_crash_enemy
		bra	Goto_check
Mykart_crash
		jsr	!Check_crash_mykart
Goto_check
;
		jsr	!Check_trigger
;
		lda	<bg_data,x
		bmi	Wall_area
		cmp	#040h
		bcs	On_the_road
		cmp	#20h
		bcc	On_special_area
On_illegal_area
		and	#000fh
		pha
		lda	<kart_status,x
		and	#0100000000000000b
		sta	<kart_status,x
		lda	#1ch
		sta	<drift_index,x
		pla
		phx
		tax
		jmp	(!Illegal_area,x)
On_special_area
		and	#00fh
		phx
		tax
		jmp	(!Special_status,x)
On_the_road
		and	#0000000000011110b	;040h---052h
		sta	<resist_status,x
Wall_area
		rts
;----------------------------------------------------------------------------
Start_slip_mark
		plx
		lda	<kart_status,x
		bit	#0000000000000010b
		bne	Not_start_spin			;ultra status!!!
		ldy	<vector_velocity,x
		cpy	#0300h
		bcc	Not_start_spin
Oil_spin
		lda	<drift_pose,x
		bmi	Right_oil_spin
Left_oil_spin
		lda	#10h
		bra	Set_spin_data
Right_oil_spin
		lda	#0eh
		bra	Set_spin_data
;----------------------------------------------------------------------------
Banana_spin
		lda	#0300h
		cmp	<vector_velocity,x
		bcs	Nomal_banana
		sta	<vector_velocity,x
Nomal_banana
		stz	<move_status,x
		lda	#1*60			;spin 1second
		sta	<drift_counter,x
		lda	<drift_pose,x
		bmi     Right_banana_spin
Left_banana_spin
		lda	#0ch
		bra	Set_spin_data
Right_banana_spin
		lda	#0ah
Set_spin_data
		sta	<drift_index,x
		stz	<drift_angle,x
Not_start_spin
Clear_spin_start_bit
		lda	<kart_status,x
		and	#1110011111111111b
		sta	<kart_status,x
		rts
;----------------------------------------------------------------------------
Kinoko_dash
;dash grip
		lda	<special_trigger,x
		and	#0111111111111111b
		sta	<special_trigger,x
		stz	<drift_angle,x
		lda	#01ch
		sta	<drift_index,x		
		bra	Set_dash
Dash_mark
		plx
Set_dash
		ldy	!drift_index,x
		lda	!Check_drift_data,y
		bne	Skip_super_dash
		lda	#0020h
		sta	<dash_counter,x
Start_dash
		lda	#48h
		jsl	>Check_trigger_SE
		lda	<kart_status,x
		ora	#0000000010000000b
		sta	<kart_status,x
		lda	#0010h			;move status
		sta	<move_status,x
Skip_super_dash
		rts
;----------------------------------------------------------------------------
Check_trigger
		lda	<kart_status,x
		bit	#0000001000000000b
		bne	Spin_status
		bit	#0000100000000000b
		bne	Oil_spin
		bit	#0001000000000000b
		bne	Banana_spin
		lda	<special_trigger,x
		bmi	Kinoko_dash
		bit	#0010000000000000b
		beq	Not_start_ultra
;----------------------------------------------------------------------------
Ultra_star
		lda	<kart_status,x
		ora	#0000000000000010b
		sta	<kart_status,x
		lda	<special_trigger,x
		and	#1101111111111111b
		sta	<special_trigger,x	;read & reset	
		lda	#0012h
		sta	<move_status,x
		sta	!pause_wait
		jsr	!Start_ultra_BGM
		rts
;----------------------------------------------------------------------------
Spin_status
		lda	<kart_flag,x
		bpl	Not_main_control
		txa
		xba
		and	#0000000000000001b
		asl	a
		tay
		lda	!camera_control,y
		ora	#0010000000000000b
		sta	!camera_control,y
Not_main_control
		lda	#001ah
		sta	<drift_index,x
		lda	#014h			;>>>>>>move status
		sta	<move_status,x
Now_spining
		rts
;----------------------------------------------------------------------------
Not_start_ultra
		bit	#0000000000000001b
		beq	Not_start_dash
		stz	<special_trigger,x
		lda	#018h
		sta	<dash_counter,x
		bra	Start_dash
;----------------------------------------------------------------------------
Not_start_dash
		bit	#0100000000000000b
		bne	Start_spin_jump
		bit	#0000000010000000b
		bne	Enemy_jump
		lda	<kart_control,x
		bit	#0000000000000100b
		bne	R_jump
		bit	#0000000000001000b
		beq	Not_tiny_jump
L_jump
		bit	#0000000000010000b
		beq	Tiny_jump
		bra	Not_tiny_jump
;----------------------------------------------------------------------------
R_jump
		bit	#0000000000100000b
		beq	Tiny_jump
Not_tiny_jump	
		lda	<kart_flag,x
		and	#1111011111111111b
		sta	<kart_flag,x		;trigger status enable
		rts
;----------------------------------------------------------------------------
Enemy_jump
		lda     <special_trigger,x
		and	#1111111101111111b
		sta     <special_trigger,x
Enemy_tiny_jump
		lda	#0100h
		cmp	<vector_velocity,x
		bcc	Not_mini_velo_jump
		sta	<vector_velocity,x
Not_mini_velo_jump
		lda     #100h
		bra	Set_jump_velo
Tiny_jump
		ldy	!resist_status,x
		cpy	#14h
		bcc	Nomal_tiny_jump
		lda	<vector_velocity,x
		cmp	!Tiny_limmit_data-014h,y
		bcc	Nomal_tiny_jump
		sec
		sbc	#040h
		sta	<vector_velocity,x
Nomal_tiny_jump
		lda	#021h
		jsl	>Check_trigger_SE
		jsr	!Check_choropoo
Set_jump_velo
		sta     <obj_velocity_z,x	
		jmp	!Mimi_jump_status
;----------------------------------------------------------------------------
Tiny_limmit_data
;			Sand,Rock,Snow,Grass,Water,Mud
		word	250h,120h,1f0h,230h,240h,290h
;----------------------------------------------------------------------------
Start_water
		plx
		lda	<kart_flag,x
		bit	#0010000000000000b
		beq	Mykart_water
		jmp	!Enemy_tiny_jump
;----------------------------------------------------------------------------
Start_spin_jump
						;A=special trigger
		lda	#24h
		jsl	>Check_trigger_SE
;
		lda	<special_trigger,x
		and	#1011111111111111b
		sta	<special_trigger,x
		lda	#01e0h			;jump initial velocity
		sta	<obj_velocity_z,x
		lda	#0100h
		sta	<obj_pos_zl,x
		lda	#0018h			
		sta	<drift_index,x		;event index=02...jump status
		lda	<kart_control,x
		bit	#0000000100000000b
		bne	Right_spin_jump
		bit	#0000001000000000b
		bne	Left_spin_jump
		lda	<frame_counter-01h
		bmi	Left_spin_jump
Right_spin_jump
		lda	#1000000000000000b
		bra	Start_jump_status
Left_spin_jump
		lda	#1010000000000000b
						;set jump & spin flag
Start_jump_status
		ora	<kart_status,x
		sta     <kart_status,x
		lda	#0002h
		jmp	!Set_move_status
;----------------------------------------------------------------------------
Start_falling
		plx
Goto_fall
		lda	#27h
		jsl	>Check_trigger_SE
		jsr	!Stop_subroutin
		jsr     !Set_mark_point
		lda	#060			;wait 1 second
		sta	<kart_counter,x
		lda	#00001h
		sta	<obj_pos_zh-01,x
		lda	#04h			;move status
		bra     Dont_move_kart
;----------------------------------------------------------------------------
Special_fall
		plx
		lda	<kart_flag,x
		bmi	Goto_fall
		jmp	!Tiny_jump
;----------------------------------------------------------------------------
Mykart_water
Drop_water
		lda	<choropoo_flag,x
		bpl	Not_choropoo_fall
		jsr	!END_choropoo
		bra	Water_fall
Not_choropoo_fall
		lda	<vector_velocity,x
		cmp	#200h
		bcs	Not_fall_water
Water_fall
		lda	<kart_status,x
		and	#0100000000000010b	;remain ultra& mini bit
		sta	<kart_status,x
		stz	<obj_pos_zh,x
		stz	<obj_pos_zl,x
		stz	<obj_velocity_z,x
		jsr     !Stop_subroutin
		lda	#water_animation_time+water_limmit_time
		sta	<kart_counter,x		;sprash!!! animation
		lda	#008h
		bra	Dont_move_kart
Not_fall_water
		cmp	#400h
		bcc	Water_jump_low
		sec
		sbc	#2c0h
		bra	Set_water_velo
Water_jump_low
		sec
		sbc	#00a0h
Set_water_velo
		sta	<vector_velocity,x
		lda	<kart_status,x
		ora	#0000000000010000b
		sta	<kart_status,x
		lda	#0800h
		jsr	!Calc_bord_jump
		bra	Goto_jump
;---------------------------------------------------------------------------
water_animation_time 	equ	12h
water_warning_time 	equ	60*02
water_limmit_time 	equ	60*04
;---------------------------------------------------------------------------
Start_out_of_bounds
		plx
Start_out_of_bounds_dash
		jsr     !Set_mark_point
		jsr	!Stop_subroutin
		lda	#0000000000100000b
		ora	<official_control,x
		sta	<official_control,x
		lda	#0ah
Dont_move_kart
Set_move_status
		sta	<move_status,x
Set_item_close
		sta	<event_index,x
		lda	<kart_flag,x
		ora     #0000100000000000b
		sta	<kart_flag,x
		rts
;----------------------------------------------------------------------------
Start_maguma
		plx
		lda	#28h
		jsl	>Check_trigger_SE
Drop_deep_water
		jsr	!Stop_subroutin
		jsr     !Set_mark_point
		lda	<kart_flag,x
		bmi	Skip_mykart_maguma
		lda	#03000h
		sta	<obj_pos_zh-01,x
Skip_mykart_maguma
		lda	#0000000000010000b
		ora	<official_control,x
		sta	<official_control,x
		lda	#06h
		bra	Dont_move_kart
;----------------------------------------------------------------------------
Start_dart_jump
		plx
		lda     #023h
		jsl     >Check_trigger_SE
		lda	<vector_velocity,x
		pha
		lda	#0d00h
		jsr	!Calc_bord_jump
		pla
		sta	<vector_velocity,x
		bra	Goto_jump
;----------------------------------------------------------------------------
Start_board_jump
		plx
		lda	<move_status,x
		cmp	#10h
		bne	Not_super_dash_jump
		lda	#4eh
		bra	Set_jump_sound
Not_super_dash_jump
		lda	#021h
Set_jump_sound
		jsl	>Check_trigger_SE
Calc_board
		jsr	!Set_jump_bord
		lda	#0280h
		sta	<obj_pos_zl+01,x
Goto_jump
		lda	#002h
		bra     Set_move_status
;----------------------------------------------------------------------------
Black_hall
		plx
		lda	<vector_velocity,x
		cmp	#100h
		bcc	No_jump
		lda	#0080h			;jump initial velocity
		sta	<obj_velocity_z,x
		lda	#0100h
		sta	<obj_pos_zl,x
		lda	#1000000000000000b
		ora	<kart_status,x
		sta	<kart_status,x
		lda	#22h
		jsl     >Check_trigger_SE
Mimi_jump_status
		lda	#02h
		sta	<event_index,x
		lda	<kart_status,x
		ora	#1000000000000000b
		sta	<kart_status,x
		lda	<kart_flag,x
		ora	#0000100000000000b
		sta	<kart_flag,x
		rts
;----------------------------------------------------------------------------
Spin_jump				;drift index=14h
		plx
		lda	<kart_status,x
		bpl	Reach_grand
		bit	#0010000000000000b
		bne	Right_spin
Left_spin
		lda	<drift_pose,x
		sec
		sbc	#00800h
		sta	<drift_pose,x
		bcc	Over_spin
		rts
Right_spin
		lda	<drift_pose,x
  		clc
		adc	#00800h
		sta	<drift_pose,x
		bcc	Cont_spin
Over_spin
		lda	<obj_velocity_z,x
		bpl	Cont_spin	
		stz	<drift_pose,x
		lda	#1ch
		sta	<drift_index,x
		lda	<kart_status,x
		and	#0111111111111111b
		sta	<kart_status,x
Check_jump
No_jump
Cont_spin

		rts
;----------------------------------------------------------------------------
Reach_grand
		lda	#01ch
		sta	<drift_index,x
		rts
;----------------------------------------------------------------------------
Spin_crash					;drift index=16h
		plx
Spin_crash_sub
		lda	<spin_counter,x
		cmp	#1000h
		bcc	Not_max_spin
		lda	#1000h
Not_max_spin
		sta	<tempolary
		lda	<kart_status,x
		bit	#0000000100000000b
		beq	Left_kart_spin
;right spin
		lda	<tempolary
		adc	<drift_pose,x
		bra	Set_drift_pose
Left_kart_spin
		lda     <tempolary
		eor	#0ffffh
		inc	a
		adc	<drift_pose,x
Set_drift_pose
		sta	<drift_pose,x
		lda	<spin_counter,x
		cmp	#0100h
		bcc	Ajust_spin
		sec
		sbc	#0040h
		sta	<spin_counter,x
		rts
Ajust_spin
		lda	<drift_pose,x
		bmi	Minus_ajust
		sec
		sbc	#180h
		bcs	Cont_crash_spin
End_spin_crash
		stz	<move_status,x
		stz	<drift_pose,x
		stz	<drift_angle,x
		stz	<drift_index,x
		lda	<kart_status,x
		and	#0100000011111111b
		ora	#0000010000000000b	;set after spin flag
		sta	<kart_status,x
		lda	#2ah
		jsl	>Check_trigger_SE
		rts
Minus_ajust
		clc
		adc	#180h
		bcs	End_spin_crash
Cont_crash_spin
		sta	<drift_pose,x
		rts
;---------------------------------------------------------------------------
Stop_subroutin
		stz	<vector_velocity_l,x
		stz	<vector_velocity_h,x
		stz	<acceleration_l,x
		stz	<acceleration_h,x
		stz	<steering_angle,x
		stz	<drift_index,x
		stz	<drift_angle,x
		stz	<drift_pose,x
		stz	<engine_power,x
		rts
;----------------------------------------------------------------------------
Check_choropoo
		lda	<choropoo_flag,x
		bpl	Nomal_tiny
Choropoo_tiny
		inc	<choropoo_counter,x
		lda	#0070h
		rts
Nomal_tiny
		lda     #00e0h
		rts
;----------------------------------------------------------------------------
Camera_spin
		lda	!drift_index,y
		beq	End_camera_spin
		lda	!drift_pose,y
		sta	<camera_drift,x
		rts
End_camera_spin
		stz	<camera_drift,x
		lda	<camera_control,x
		and	#1100111111111111b
		sta	<camera_control,x		;camera spin end
		rts
;----------------------------------------------------------------------------
Set_jump_bord
		lda	!map_type
		cmp	#0ch			;koopa castle???
		bne	Check_minimum_jump
		lda	<kart_flag,x
		bmi	Check_mykert_castle
		lda	#3a0h
		bra	Check_castle_jump
Check_mykert_castle
		lda	#400h
Check_castle_jump
		cmp	<vector_velocity_h,x
		bcs	Check_minimum_jump
		sta	<vector_velocity_h,x	
Check_minimum_jump
		lda	#02e0h
		cmp	<vector_velocity_h,x
		bcc	Set_velocity_z
		sta	<vector_velocity_h,x
Set_velocity_z
		lda	#00e00h
;----------------------------------------------------------------------------
					;a=bord angle(1byte)
Calc_bord_jump
		pha
		mem8
		sep	#00100000b
		lda	#dsp_triangle
		sta	!DSP_data
		mem16
		rep	#00100000b
		pla
		sta	!DSP_data
		lda	<vector_velocity,x
		sta	!DSP_data
		lda	!DSP_status
		bpl	$-3
		lda	!DSP_data
		sta	<obj_velocity_z,x
		lda	<kart_status,x
		ora	#1000000000000000b
		sta	<kart_status,x
		lda	!DSP_data
		sta	<vector_velocity_h,x
		rts					
;----------------------------------------------------------------------------
		mem16
		idx16
Tire_effect
		lda	<tire_timer,x
		beq	Stop_tire
		bmi	Tire_2525
Nomal_tire;------------------------------------------------------------------
Tire_35a9
		dec	a
		beq	Next_2525
		sta	<tire_timer,x
		rts
Tire_2525
		inc	a
		beq	Next_35a9
		sta	<tire_timer,x
		rts
Next_35a9
		jsr	!Set_kart_timer
		sta	<tire_timer,x
		bra	Change_2525		
Next_2525
		jsr	!Set_kart_timer
		eor	#0ffffh
		inc	a
		sta	<tire_timer,x
		bra	Change_35a9
;----------------------------------------------------------------------------
Stop_tire
		jsr	!Set_kart_timer
		sta	<tire_timer,x
		rts
;----------------------------------------------------------------------------
Change_35a9
		lda	<driver_number+00h,x
		tay
		lda	!Tire_address,y
		phx
		tax
		lda	#35a9h
		sta	>color_buffer,x
		plx
		rts
;----------------------------------------------------------------------------
Change_2525
		lda	<driver_number+00h,x
		tay
		lda	!Tire_address,y
		phx
		tax
		lda	#2525h
		sta	>color_buffer,x
		plx
		rts
;----------------------------------------------------------------------------
Tire_address			
		word	093h*02h,0a3h*02h,083h*02h,0b3h*02h
		word	0b5h*02h,0a5h*02h,095h*02h,085h*02h
;----------------------------------------------------------------------------
Set_kart_timer
		lda	<vector_velocity,x		;v=0-7ffh
		cmp	#0800h
		bcc	Not_over_tire
		lda	#07ffh
Not_over_tire
		asl	a
		asl	a
		asl	a
		xba	
		and	#00003eh
		tay
		lda	!Tire_timer_data,y
		rts		
;----------------------------------------------------------------------------
Tire_timer_data
		word	0000h,000ch,000bh,000ah,0009h,0008h,0007h,0006h
		word	0005h,0004h,0003h,0003h,0003h,0002h,0002h,0002h
		word	0002h,0001h,0001h,0001h,0001h,0001h,0001h,0001h
		word	0001h,0001h,0001h,0001h,0001h,0001h,0001h,0001h
;----------------------------------------------------------------------------
bank84		sect	rel
;----------------------------------------------------------------------------
Color_effect
		lda	!over_timer
		bne	Return_color_effect
		ldx	!map_type
		cpx	#0ah
		beq	Sand_COL
Return_color_effect
		rtl
;----------------------------------------------------------------------------
Sand_COL
		phb
		phk
		plb
		mem8
		idx8
		sep	#00110000b
		ldx	#018h*02h
		lda	<frame_counter
		and	#00000111b
		cmp	#00000111b
		bne	Not_trans_sand
		lda	<frame_counter
		and	#01111000b
		lsr	a
		lsr	a
		lsr	a
		tay
		lda	!Sand_COL_sequence,y
		tay
Set_sand_loop
		lda	!Sand_COL_type,y
		phy
		tay
		lda	!Sand_COL_data+00h,y
		sta	>color_buffer+00h,x
		lda     !Sand_COL_data+01h,y
		sta     >color_buffer+01h,x
		ply
		inx
		inx
		iny
		cpx	#01dh*02h
		bne	Set_sand_loop	
Not_trans_sand
		rep	#00110000b
NO_COL
		plb
		rtl
;----------------------------------------------------------------------------
Sand_COL_sequence
		byte	00h,05h,0ah,0fh,0fh,14h,14h,14h
		byte	19h,19h,19h,19h,23h,28h,2dh,2dh
Sand_COL_type
		byte	00h,00h,00h,02h,04h
		byte	00h,00h,02h,04h,06h
		byte	00h,02h,04h,06h,06h
		byte	02h,04h,06h,06h,08h
		byte	04h,06h,06h,08h,08h
		byte	04h,06h,08h,08h,08h
		byte	0ah,04h,08h,08h,08h
		byte	02h,0ch,0eh,08h,08h
		byte	00h,02h,0ch,0eh,08h
		byte	00h,00h,02h,0ch,0eh
Sand_COL_data
		word	7eb2h
		word	7f56h
		word	7ffdh
		word	3a54h
		word	4296h
		word	7fb9h
		word	7ffbh
		word	7ffeh
		end
