;****************************************************************************
;*	Mario Kart							    *
;*			Enemy car cntrol module				    *
;*							1992.07.13          *
;****************************************************************************
		glb	Enemy_control_100
		glb	Enemy_control_200,Enemy_control_300
		glb	Check_target_direction,Enemy_steering_control
		glb	Initial_enemy,Init_enemy_perform	;bank1
;
		ext	Goal_data,Set_velocity
		ext	Calc_target,Calc_move_direction		;bank1
		ext	Check_kart_area,Lookup_accel_table
		ext	Tire_effect
		ext	Calc_vector_velocity
		ext	Clear_RAM_7F,Set_map_address		;bank1
;
		ext	Event_control				;bank0,
		ext	Falling_water,After_crash_accel,Spin_crash_sub
		ext	Super_dash_dash,End_super_dash,Ultra_status
		ext    	After_crash_accel,Jump_status,Dont_move,Spin_status
;----------------------------------------------------------------------------
		include	rp5a22
		include rp5c77
		include D77C25
		include work.def
		include buffer.def
		include	label.def
		include ../join/object.def
;----------------------------------------------------------------------------
counter		equ	0000h
m_counter	equ	0002h
n_counter	equ	0004h
basic_position	equ	0006h
area_address	equ	0008h	;(4byte)
target_address  equ	000ch	;(4byte)
;
tempolary	equ	0012h
mark_x		equ	0014h
mark_y		equ	0016h
direction_data	equ	0018h
;				I can't use cirtain  RAM area(00h-0fh)
;				bacause that area used in Direction calucu
my_priority	equ	0000h
my_index	equ	0002h
foward_priority equ	0004h
behind_priority equ	0006h
rank_data	equ	0008h
;----------------------------------------------------------------------------
data_address	equ	0010h
steering_addr	equ	0014h
velocity_addr	equ	0018h
control_flag	equ	0000h
;----------------------------------------------------------------------------
bank80		sect	rel
;;---------------------------------------------------------------------------
		mem16
		idx16
Enemy_control_100
		lda	<kart_flag,x
		beq	Skip_control
		jsr	!Event_control
		jsr	!Set_direction
		lda     <kart_flag,x
		bit     #0100000000000000b
		bne	Enemy_uncontrol
		jsr	!Set_velocity
Enemy_uncontrol
		lda	!over_flag
		bne	Skip_control
		jsr	!Tire_effect
Skip_control
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Enemy_control_200
		lda	<kart_flag,x
		beq	Skip_control
;						for each frame
		jsr	!Check_target_direction
		and	#0ff00h
		sta	<point_direction,x
;
		lda	#08000h
		sta	<kart_control,x
;
		phx
		lda	<move_status,x
		tax
		jmp	(!Enemy_control_address,x)
Enemy_control_address
		word	Nomal_enemy,Jump_status
		word	Dont_move,Dont_move,Falling_water
		word	Dont_move,Dont_move,Dont_move
		word	Super_dash,Ultra_status,Spin_status
		word    After_crash_accel
;---------------------------------------------------------------------------
		mem16
		idx16
Enemy_control_300
						;A=kart_flag
						;X=index
		phx
		jsr	!Check_drive_status
		plx
;						A=drive status data
		sta	<drive_status,x
		rts
;---------------------------------------------------------------------------
Check_drive_status
						;x=my index
		lda	!ending_flag
		beq	Check_chibi
		lda	#00h
		rts
Check_chibi
		lda	<driver_priority,x
		sta	<my_priority
		stx	<my_index
		lda	<thunder_timer,x
		bne	Chibi_kart
Check_goalin
		lda	<kart_flag,x
		bit	#00100000b
		beq	Check_ultra
;							;GOAL IN STATUS
Chibi_kart
		lda	#018h		;drive status=18(waiting)
		rts
;----------------------------------------------------------------------------
						;x=my index
Check_ultra
		ldy	!rank_number,x
		sty	<rank_data
		lda	<kart_status,x
		bit	#00000010b
		beq	Check_top_rank
;							;ULTRA STATUS!!!
		cpy	#00h
		beq	U_behind_check
		ldx	!rank_index-02h,y
		lda	<kart_flag,x		;fwoard player?
		bmi	Ultra_kattobi
Not_player_FW
U_behind_check
		cpy	#0eh
		beq	Ultra_kattobi
		ldx	!rank_index+02h,y
		lda	<kart_flag,x		;behind player?
		bpl	Ultra_kattobi
;Ultra waiting
		lda	#10h
		rts
Ultra_kattobi
		lda	#08h
		rts		
;----------------------------------------------------------------------------
						;x=my index
						;y=my rank
Check_top_rank
		cpy	#00h
		bne	Check_last_rank
;							;TOP RANK STATUS
		ldx	!rank_index+02h
		lda	<kart_flag,x
		bpl	Enemy_second
		jsr	!Check_waiting
		bcs	Top_waiting
Top_nomal
Last_nomal
		lda	#00h
		rts			
Enemy_second
		lda	<my_priority
		cmp	<driver_priority,x
		bcc	Top_waiting
;
		txy
		ldx	<my_index
		lda	<kart_lap,x
		and	#000111b
		beq	Top_kattobi
		stz	<rank_data
		jsr	!Calc_distance
		jsr	!Check_enemy_circle
		bcs	Top_nomal
;
		ldx	!rank_index+04h			;Third player?
		lda	<kart_flag,x
		bmi	Top_kattobi
		ldx	!rank_index+06h
		bpl	Top_nomal
Top_kattobi
		lda	#08h
		rts
Top_waiting
Last_waiting
		lda	#10h
		rts
;----------------------------------------------------------------------------
Check_last_rank
		cpy	#0eh
		bne	Check_behind_player
;							;LAST RANK STATUS
		ldx	!rank_index+0ch
		lda	<kart_flag,x
		bpl	Check_0ch_enemy
		jsr	!Check_kattobi
		bcc	Last_nomal
Last_kattobi
		lda	#08h
		rts
Check_0ch_enemy
						;x=foward enemy index
		lda	<driver_priority,x
		cmp	<my_priority
		bcc	Last_kattobi
		ldy	<my_index
		jsr	!Calc_distance
		jsr	!Check_enemy_circle
		bcc	Last_waiting
;Last_nomal
B_P_nomal
		lda	#00h
		rts
;----------------------------------------------------------------------------
Check_behind_player
		ldx	!rank_index+02h,y	;behind kart
		lda	<kart_flag,x
		bpl	Check_foward_player
							;BEHIND PLAYER
		phx
		ldx	!rank_index-02h,y
		lda	<drive_status,x
		cmp	#010h
		beq	Goto_wait
		lda	<driver_priority,x
		cmp	<my_priority
		bcs	Goto_wait
		plx
		jsr	!Check_waiting
		bcc	B_P_nomal	
		lda	<foward_priority
		cmp	<my_priority
		bcs	B_P_nomal
;B_P_waiting
F_P_waiting
B_E_waiting
		lda	#10h
		rts
Goto_wait
		plx
		lda	#10h
		rts
;----------------------------------------------------------------------------
Check_foward_player
		lda	<driver_priority,x
		sta	<behind_priority
		ldx	!rank_index-02h,y
		lda	<kart_flag,x
		bpl	Check_behind_enemy
;							;FOWARD PLAYER
		lda	<my_priority
		cmp	<behind_priority
		bcc	F_P_waiting
		jsr	!Check_kattobi
		bcc	F_P_nomal
;F_P_kattobi
		lda	#08h
		rts
F_P_nomal
		lda	#00h
		rts
;----------------------------------------------------------------------------
Check_behind_enemy
		lda	<driver_priority,x
		sta	<foward_priority
		lda	<my_priority
		cmp	<behind_priority
		bcs	Check_foward_enemy
							;GO BACK  ENEMY
		lda	#10h
		rts
Check_foward_enemy
		lda	<foward_priority
		cmp	<my_priority
		bcs	Nomal_statement
		
							;GO AHEAD ENEMY
		lda	#08h
		rts
Nomal_statement			
							;STATIC ENEMY
		ldy	<my_index
		jsr	!Calc_distance
		jsr	!Check_enemy_circle
		bcc	B_E_waiting
		lda	<drive_status,x		;foward kart's drive status
		rts
;---------------------------------------------------------------------------
Check_waiting
;						;x=behind player's index
		lda	<foward_distance,x
		ldy	<foward_index,x
		cpy	!my_index
		beq	Skip_calc_dist
		ldy	!my_index
		jsr	!Calc_distance
Skip_calc_dist
		cmp	#140h
		rts
						;c set=outside circle
						;c clear=inside circle 
;---------------------------------------------------------------------------
Check_kattobi
		lda	<behind_distance,x
		ldy	<behind_index,x
		cpy	!my_index
		beq	Skip_kattobi_dist
		jsr	!Calc_distance
Skip_kattobi_dist	
		cmp	#080h
		rts				
						;c set=outside circle
						;c clear=inside circle 
;---------------------------------------------------------------------------
						;A=kart-kart distance
Check_player_circle				;For kattobi chaeck
		pha
		lda	<kart_lap,x
		and	#0111b
		asl	a
		tay
		pla
		cmp	!Player_circle_data,y
		rts				;
						;c set  =outside circle
						;c clear=inside circle
Player_circle_data
		word	080h,060h,040h,0a0h,100h,060h,060h,080h
;---------------------------------------------------------------------------
						;A=kart-kart distance
						;x=index
						;rank_data=rank number,x
Check_enemy_circle
		pha
		lda	<kart_lap,x
		and	#0111b
		asl	a
		asl	a
		asl	a
		asl	a
		clc
		adc	<rank_data
		tay
		pla
		cmp	!Enemy_circle_data,y
						;c set  =outside circle
						;c clear=inside circle
		rts
Enemy_circle_data
		word	080h,080h,040h,040h,040h,040h,060h,080h	
		word	0a0h,0a0h,050h,050h,080h,0a0h,0c0h,0c0h
		word	0c0h,0c0h,060h,070h,080h,0c0h,0e0h,500h	
		word	0e0h,0e0h,060h,080h,0a0h,120h,500h,500h	
		word	100h,0a0h,080h,008h,080h,500h,500h,500h
;---------------------------------------------------------------------------
Calc_distance				;y=mark kart,s rank number
		mem8
		sep	#00100000b
		lda	#dsp_distance
		sta	!DSP_data
		mem16
		rep	#00100000b
		lda	#000h
		sta	!DSP_data
		lda	!obj_pos_xh,y
		sec
		sbc	<obj_pos_xh,x
		sta	!DSP_data
		lda	!obj_pos_yh,y
		sec
		sbc	<obj_pos_yh,x
		sta	!DSP_data
		lda	!DSP_status
		bpl	$-3
		lda	!DSP_data
		rts	
;---------------------------------------------------------------------------
Set_direction
		lda	<kart_status,x
		bit	#0000101000000000b
		bne	Enemy_spin
		lda	<body_direction,x
		sec
		sbc	<move_direction,x
		beq	Nomal_steering
		bmi	Minus_offset_nomal
		cmp	#00800h
		bcc	Reset_move_direction
		lda	<move_direction,x
		clc
		adc	#00600h
		bra	Offset_move_direction
Minus_offset_nomal
		cmp	#-0800h
		bcs	Reset_move_direction
		lda	<move_direction,x
		sec
		sbc	#00600h
		bra	Offset_move_direction
Reset_move_direction
		lda	<body_direction,x
Offset_move_direction
		sta	<move_direction,x
		rts
;----------------------------------------------------------------------------
Nomal_steering
		lda	<point_direction,x
Enemy_steering_control
		sec
		sbc	<move_direction,x
		bmi	Minus_nomal
		cmp	#00200h
		bcs	Turn_left
Reset_direction
		lda	<point_direction,x
		sta	<move_direction,x
		sta	<body_direction,x
		rts
Minus_nomal
		cmp	#-0200h
		bcs	Reset_direction
Turn_right
		jsr	!Calc_steering_angle
		eor	#0ffffh
		inc	a
		bra	Set_move_direc
Turn_left
		eor	#0ffffh
		inc	a
		jsr	!Calc_steering_angle
Set_move_direc
		clc
		adc	<move_direction,x
		sta	<move_direction,x
		sta	<body_direction,x
		rts
;----------------------------------------------------------------------------
Enemy_spin					;A=kart-status
		jsr	!Spin_crash_sub
		lda	<move_direction,x
		clc
		adc	<drift_pose,x
		sta	<body_direction,x
		rts
;----------------------------------------------------------------------------
Calc_steering_angle
		cmp	#00200h
		bcc	Not_over_steering
		lda	#001ffh
Not_over_steering
		asl	a
		asl	a
		asl	a
		xba
		and	#001110b
		sta	<tempolary
		lda	<drive_status,x
		asl	a
		clc
		adc	<tempolary
		tay
		lda	!Enemy_steering_table,y
		rts
;----------------------------------------------------------------------------
Super_dash
		plx
		lda	<vector_velocity,x
		cmp	#100h
		bcc	OK_dash
		lda	<kart_area,x
		and	#07fh
		asl	a
		tay
		lda	!target_status,y
		and	#0000000000000011b
		cmp	#0000000000000011b
		bne	End_dash
OK_dash
		jmp	!Super_dash_dash
End_dash
		jmp	!End_super_dash
;----------------------------------------------------------------------------
Nomal_enemy
		plx
;Nomal_size
		jsr	!Check_target_velocity
		sec
		sbc	<vector_velocity,x
		bcc	Reach_target_velo
		ldy	#enemy_table
		sty	<data_address
		jsr	!Lookup_accel_table
		stz	<acceleration_h+00h,x
		sta	<acceleration_l+01h,x
		rts
;----------------------------------------------------------------------------
Reach_target_velo
		eor	#0ffffh
		inc	a
		cmp	#200h
		bcc	Not_over_200h
		lda	#1ffh
Not_over_200h
		asl	a
		asl	a
		xba
		and	#00110b
		tay
		lda	!Enemy_brake_data,y
		sta	<acceleration_h+00h,x
		rts
;----------------------------------------------------------------------------
Enemy_brake_data
		word	-004h,-008h,-010h,-018h,-020h,-030h,-040h,-050h
;----------------------------------------------------------------------------
Check_target_velocity
		lda	<kart_area,x
		and	#07fh
		asl	a
		tay
		lda	!target_status,y
		and	#0000000000000011b		;
		asl	a
		clc
		adc	<drive_status,x
		tay
		lda	!Enemy_velocity_table,y
		ldy	!driver_priority,x
		beq	Zako_kart
		adc	!Rival_data,y
		rts
Zako_kart
		ldy	!rank_number,x
		adc	!Zako_data,y
		rts	
;----------------------------------------------------------------------------
Rival_data
		word	002h,004h,008h,010h
Zako_data
		word	000h,-02h,-04h,-08h,-0ch,-10h,-14h,-18h
;----------------------------------------------------------------------------
Check_target_direction
;;;		lda	<kart_status,x
;;;;		bmi	Eregal_area
							;jummping status
		lda	<kart_flag,x
		and	#0000000000000011b
		beq	Nomal_area
Eregal_area		
		lda	<kart_area,x
		and	#00ffh
		asl	a
		tay
		lda	!target_bufferY,y
		sec
		sbc	<obj_pos_yh,x
		pha
		lda	!target_bufferX,y
		ply
		sec
		sbc	<obj_pos_xh,x
		phx
		tax
		jsl	>Calc_target
		plx
		rts
Nomal_area
		phx
		lda	<obj_pos_xh,x
		lsr	a	
		lsr	a
		lsr	a
		lsr	a
		sta	<tempolary
		lda	<obj_pos_yh,x
		asl	a
		asl	a
		and	#0000111111000000b
		ora	<tempolary	
		tax
		lda	>drive_direction-01h,x
		plx
		rts
;-----------------------------------------------------------------------------
bank81		sect	rel
;-----------------------------------------------------------------------------
		mem16
		idx16
Initial_enemy

		mem16
		rep	#00100000b
;
		ldx	#offset area_buffer
		lda	#bank area_buffer
		ldy	#01000h
		jsl	>Clear_RAM_7F
Open_area_data
		lda	!map_number
		asl	a
		tax
		lda	!rom_checker
		bne	Open_SRAM
Open_ROM
		lda	!Area_address_ROM+00h,x
		sta	<area_address+00h
		lda	#bank Drive_data_address
		sta	<area_address+02h
		sta	<target_address+02h
		lda	!Target_address_ROM+00h,x
		sta	<target_address+00h
		bra     Open_main
Open_SRAM
		jsr	!Set_map_address
		lda	>Area_address_SRAM+00h,x
		sta	<area_address+00h
  		lda	>Area_address_SRAM+02h,x
		sta	<area_address+02h
		lda	>Target_address_SRAM+00h,x
		sta	<target_address+00h
		lda	>Target_address_SRAM+02h,x
		sta	<target_address+02h
Open_main
		ldy	#00h
		stz	!area_number
Open_area_loop
		lda	[<area_address],y
						;code data
		and	#00ffh
		cmp	#00ffh			;0ffh=end code
		beq	End_open_area
		tax
		iny
		lda	[<area_address],y		;y position(00-3fh)
		iny
		iny
		pha
		and	#00ffh
		sta	<basic_position
		pla
		and	#0ff00h
		lsr	a
		lsr	a
		tsb	<basic_position
		jsr	(!Code_subroutin,x)
		mem16
		rep	#00100000b
		inc	!area_number
		bra	Open_area_loop	
End_open_area
		ldy	#00h
		ldx	#00h
		lda	!area_number
		sta	<counter
Set_target_loop
		lda	[<target_address],y
						;target position X & Y
		pha
		and	#00ffh
		asl	a
		asl	a
		asl	a
		sta	!target_bufferX,x
		pla
		xba
		and	#00ffh
		asl	a
		asl	a
		asl	a
		sta	!target_bufferY,x
		iny
		iny
		lda	[<target_address],y
		and	#00ffh
						;tatget status
		sta	!target_status,x
		iny
		inx
		inx
		dec	<counter
		bne	Set_target_loop	
		lda	!target_bufferX+00h
		sta	!target_bufferX,x
		lda	!target_bufferY+00h
		sta	!target_bufferY,x		;omake 
;Open goal data
		lda	!map_number
		cmp	#014h
		bcs	Open_drive_data			;skip battle
		asl	a
		clc
		adc	!map_number
		asl	a
		tax
		lda	!Goal_data+00h,x
		sta	!goal_line
		lda	!Goal_data+02h,x	;index
		sta	<basic_position
		lda	!Goal_data+04h,x
		pha
		and	#00ffh
		sta	<m_counter
		pla	
		xba
		and	#00ffh
		sta	<n_counter
		ldx     <basic_position
Set_goal_loop2
		ldy	<m_counter
		mem8
		sep	#00100000b
Set_goal_loop1
		lda	>area_buffer,x
		ora	#10000000b		;goal box bit
		sta	>area_buffer,x
		inx
		dey
		bne	Set_goal_loop1
		mem16
		rep	#00100000b
		lda	<basic_position
		clc
		adc	#040h
		sta	<basic_position
		tax
		dec	<n_counter
		bne	Set_goal_loop2
;----------------------------------------------------------------------------
Open_drive_data
		mem16
		idx16
		lda	!area_number
		asl	a
		tax
Target_direc_loop
		lda	!target_bufferX,x
		sta	<mark_x
		lsr	a
		lsr	a
		lsr	a
		lsr	a
		sta	<tempolary
		sec
		sbc	!target_bufferY,x
		sta	<mark_y
		asl	a
		asl	a
		and	#1111111111000000b
		ora	<tempolary
		phx
		tax
		lda	>area_buffer,x
		and	#07fh
		asl	a
		tax
;
		lda	!target_bufferY,x
		sec
		sbc	<mark_y
		tay
		lda	!target_bufferX,x
		sec
		sbc	<mark_x
		tax
;
		jsl	>Calc_target		
;
		plx
		mem8
		sep	#00100000b
		xba
							;high target direc
		sta	!target_direction,x	
		mem16
		rep	#00100000b
		dex
		dex
		bpl	Target_direc_loop
;
		ldx	#0000h
Set_drive_loop
		mem16
		rep	#00100000b
		lda	>area_buffer,x
		and	#007fh
		cmp	#007fh
		beq	Next_drive
		asl	a
		tay
;
		jsr	!Set_direc_sub
		mem8
		sep	#00100000b
		xba
		sta	>drive_direction,x
;				direction from curent position to target n+00
Next_drive;				distance from curent position to target
		inx
		cpx	#01000h
		bne     Set_drive_loop
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
		mem16
		idx16
Set_direc_sub
		lda	!target_bufferX,y
		sta	<tempolary+00h
		lda	!target_bufferY,y
		sta     <tempolary+02h
		txa
		and	#0000111111000000b
		lsr	a
		lsr	a	
		clc
		adc	#0008h
		sec
		sbc	<tempolary+02h
		eor	#0ffffh
		inc	a
		sta	<tempolary+02h
		tay
		txa
		and	#0000000000111111b
		asl	a
		asl	a
		asl	a
		asl	a
		clc
		adc	#0008h
		sec
		sbc	<tempolary
		eor	#0ffffh
		inc	a
		sta	<tempolary+00h
		phx
		tax
		jsl	>Calc_target
		plx
		rts
;----------------------------------------------------------------------------
Code_subroutin
	word	Code_00,Code_02,Code_04,Code_06,Code_08,Code_0a,Code_0c
;----------------------------------------------------------------------------
Code_00
		mem8
		sep	#00100000b
;
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
		lda	[<area_address],y		;n-counter
		sta	<n_counter
		iny
Loop_000
		sep	#00100000b
		ldx	<basic_position
		lda	<m_counter
		sta	<counter
Loop_001
		lda	!area_number
		sta	>area_buffer,x	
		inx
		dec	<counter
		bne	Loop_001
;
		dec	<n_counter
		bne	Next_00
		rts
Next_00
		mem16
		rep	#00100000b
		lda	<basic_position
		clc
		adc	#040h
		sta	<basic_position
		bra	Loop_000
;----------------------------------------------------------------------------
Code_02
		mem8
		sep	#00100000b
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
Loop_020
		mem8
		sep	#00100000b
		ldx	<basic_position
		lda	<m_counter
		sta	<counter
Loop_021
		lda	!area_number
		sta	>area_buffer,x
		inx
		dec	<counter
		bne	Loop_021
;
		dec	<m_counter
		bne	Next_02
		rts
Next_02
		mem16
		rep	#00100000b
		lda	<basic_position
		clc
		adc	#040h
		sta	<basic_position
		bra	 Loop_020
;----------------------------------------------------------------------------
Code_04
		mem8
		sep	#00100000b
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
Loop_040
		mem8
		sep	#00100000b
		ldx	<basic_position
		lda	<m_counter
		sta	<counter
Loop_041
		lda	!area_number
		sta	>area_buffer,x
		dex
		dec	<counter
		bne	Loop_041
;
		dec	<m_counter
		bne	Next_04
		rts
Next_04
		mem16
		rep	#00100000b
		lda	<basic_position
		clc
		adc	#040h
		sta	<basic_position
		bra	 Loop_040
;----------------------------------------------------------------------------
Code_06
		mem8
		sep	#00100000b
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
Loop_060
		mem8
		sep	#00100000b
		ldx	<basic_position
		lda	<m_counter
		sta	<counter
Loop_061
		lda	!area_number
		sta	>area_buffer,x
		dex
		dec	<counter
		bne	Loop_061
;
		dec	<m_counter
		bne	Next_06
		rts
Next_06
		mem16
		rep	#00100000b
		lda	<basic_position
		sec
		sbc	#040h
		sta	<basic_position
		bra	 Loop_060
;----------------------------------------------------------------------------
Code_08
		mem8
		sep	#00100000b
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
Loop_080
		mem8
		sep	#00100000b
		ldx	<basic_position
		lda	<m_counter
		sta	<counter
Loop_081
		lda	!area_number
		sta	>area_buffer,x
		inx
		dec	<counter
		bne	Loop_081
;
		dec	<m_counter
		bne	Next_08
		rts
Next_08
		mem16
		rep	#00100000b
		lda	<basic_position
		sec
		sbc	#040h
		sta	<basic_position
		bra	 Loop_080
;----------------------------------------------------------------------------
Code_0a
		mem8
		sep	#00100000b
;
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
		lda	[<area_address],y		;n-counter
		sta	<n_counter
		iny
Loop_0a0
		sep	#00100000b
		ldx	<basic_position
		lda	<n_counter
		sta	<counter
Loop_0a1
		lda	!area_number
		sta	>area_buffer,x	
		txa
		clc
		adc	#040h
		tax
		dec	<counter
		bne	Loop_0a1
;
		dec	<n_counter
		bne	Next_0a
		rts
Next_0a
		mem16
		rep	#00100000b
		lda	<basic_position
		clc
		adc	#03fh
		sta	<basic_position
		bra	Loop_0a0
;----------------------------------------------------------------------------
Code_0c
		mem8
		sep	#00100000b
;
		lda	[<area_address],y		;m-counter
		sta	<m_counter
		iny
		lda	[<area_address],y		;n-counter
		sta	<n_counter
		iny
Loop_0c0
		sep	#00100000b
		ldx	<basic_position
		lda	<n_counter
		sta	<counter
Loop_0c1
		lda	!area_number
		sta	>area_buffer,x	
		txa
		clc
		adc	#040h
		tax
		dec	<counter
		bne	Loop_0c1
;
		dec	<n_counter
		bne	Next_0c
		rts
Next_0c
		mem16
		rep	#00100000b
		lda	<basic_position
		clc
		adc	#041h
		sta	<basic_position
		bra	Loop_0c0
;----------------------------------------------------------------------------
Init_enemy_perform
		ldx	!game_level
		ldy	!Enemy_performance,x
		ldx	#00h
Init_enemy_loop
		lda	!00h,y
		and	#0ffh
		asl	a
		asl	a
		asl	a
		asl	a
		sta	!enemy_table,x
		iny
		inx
		inx
		cpx	#080h
		bne	Init_enemy_loop
		rts
;----------------------------------------------------------------------------
Enemy_performance
		word	Level_50cc,Level_100cc,Level_150cc
Level_50cc
;accel
		byte	020h,060h,040h,080h,0c0h,0c0h,0e0h,0c0h
		byte	0b0h,0a0h,090h,080h,070h,060h,050h,040h
;velocity
		byte	01ch,020h,026h,02ah			;nomal
		byte	020h,02ch,038h,038h			;kattobi
		byte	010h,01eh,024h,026h			;wait
		byte	010h,016h,020h,024h			;slow
;steering
		byte	04h,06h,08h,00ah,00ch,00eh,010h,014h	;(nomal)
		byte	08h,0ah,0ch,00eh,010h,012h,014h,018h	;(kattobi)
		byte	02h,04h,06h,008h,00ah,00ch,00eh,012h	;(wait)
		byte	02h,03h,04h,006h,008h,00ah,00ch,010h	;(slow)
Level_100cc
;accel
		byte	020h,060h,040h,080h,0c0h,0c0h,0e0h,0c0h
		byte	0b0h,0a0h,090h,080h,070h,060h,050h,040h
;velocity
		byte	023h,028h,030h,033h
		byte	02bh,02fh,039h,041h
		byte	023h,026h,02bh,02dh
		byte	016h,01eh,024h,028h			
;steering
		byte	06h,08h,00ah,00ch,00eh,010h,014h,018h	;(nomal)
		byte	0ch,0eh,010h,012h,016h,01ch,020h,024h	;(kattobi)
		byte	04h,06h,008h,00ah,00ch,00eh,012h,016h	;(wait)
		byte	02h,04h,006h,008h,00ah,00ch,00eh,012h	;(slow)
Level_150cc
;accel
		byte	030h,080h,080h,0a0h,0e0h,0e0h,0ffh,0ffh
		byte	0d0h,0c0h,0a0h,090h,080h,080h,080h,080h
;velocity
		byte	026h,02eh,035h,037h
		byte	034h,03ch,03eh,042h
		byte	024h,02ch,034h,036h
		byte	016h,01eh,024h,028h			
;steering
		byte	09h,00bh,00dh,00fh,011h,015h,019h,1ch	;(nomal)
		byte	0dh,00fh,011h,013h,015h,019h,01dh,20h	;(kattobi)
		byte	05h,07h,009h,00bh,00dh,00fh,013h,017h	;(wait)
		byte	02h,04h,006h,008h,00ah,00ch,00eh,012h	;(slow)
;----------------------------------------------------------------------------
Area_address_ROM
	word	offset MAP00_area,offset MAP01_area 
	word	offset MAP02_area,offset MAP03_area,offset MAP04_area
	word	offset MAP05_area,offset MAP06_area
	word	offset MAP07_area,offset MAP08_area,offset MAP09_area
	word	offset MAP0A_area,offset MAP0B_area
	word	offset MAP0C_area,offset MAP0D_area,offset MAP0E_area
	word	offset MAP0F_area,offset MAP10_area,offset MAP11_area
	word	offset MAP12_area,offset MAP13_area,offset MAP14_area
	word	offset MAP15_area,offset MAP16_area
	word	offset MAP17_area
Target_address_ROM
	word	offset MAP00_target,offset MAP01_target 
	word	offset MAP02_target,offset MAP03_target,offset MAP04_target
	word	offset MAP05_target,offset MAP06_target
	word	offset MAP07_target,offset MAP08_target,offset MAP09_target
	word	offset MAP0A_target,offset MAP0B_target
	word	offset MAP0C_target,offset MAP0D_target,offset MAP0E_target
	word	offset MAP0F_target,offset MAP10_target,offset MAP11_target
	word	offset MAP12_target,offset MAP13_target,offset MAP14_target
	word	offset MAP15_target,offset MAP16_target
	word	offset MAP17_target
;----------------------------------------------------------------------------
editer		sect	rel
;----------------------------------------------------------------------------
Area_address_SRAM
		lword	MAP00_ARE,MAP01_ARE,MAP02_ARE,MAP03_ARE,MAP04_ARE
		lword	MAP05_ARE,MAP06_ARE,MAP07_ARE,MAP08_ARE,MAP09_ARE
		lword	MAP0A_ARE,MAP0B_ARE,MAP0C_ARE,MAP0D_ARE,MAP0E_ARE
		lword	MAP0F_ARE
		lword	MAP10_ARE,MAP11_ARE,MAP12_ARE,MAP13_ARE,MAP14_ARE
		lword	MAP15_ARE,MAP16_ARE,MAP17_ARE,MAP18_ARE
Target_address_SRAM
		lword	MAP00_TRG,MAP01_TRG,MAP02_TRG,MAP03_TRG,MAP04_TRG
		lword	MAP05_TRG,MAP06_TRG,MAP07_TRG,MAP08_TRG,MAP09_TRG
		lword	MAP0A_TRG,MAP0B_TRG,MAP0C_TRG,MAP0D_TRG,MAP0E_TRG
		lword	MAP0F_TRG
		lword	MAP10_TRG,MAP11_TRG,MAP12_TRG,MAP13_TRG,MAP14_TRG
		lword	MAP15_TRG,MAP16_TRG,MAP17_TRG,MAP18_ARE
		end
