;****************************************************************************
;*	Mario Kart							    *
;*			Main routin control module			    *
;*							1992.07.13          *
;****************************************************************************
		glb	Color_transport
		glb	Color_transport_l
		glb	Color_transport_s
;---------------------------------------------------------------------------
		ext	Initialize_process
		ext	Selection_process
		ext	Screen_control
		ext	Race_control,Race_checker
		ext	Set_HDMA_parameter,Ending_control
		ext	OBJ_transport,Set_trans_bufferA,Set_trans_bufferB
		ext	IRQ_subroutin
		ext	Camera_controlA,Camera_controlB
		ext	Set_OAM_screen1
		ext	Set_position
		ext	Official_control_A,Official_control_B
		ext	RAM_EDIT_A,RAM_EDIT_B
		ext	Color_effect
		ext	Mycar_controlA,Mycar_1controlB
		ext	Battle_control
		ext	Game_control,Fade_control
		ext	Sound_set,DMA_map,Sound_set_trigger
		ext	Demo_camera,Pause_main,Pause_nmi
;----------------------------------------------------------------------------
		ext     OBJ_setA,OBJ_setB
		ext	Battle_objsetA,Battle_objsetB
		ext     BG_transport,Battle_nmi
;----------------------------------------------------------------------------
		ext	Staff_roll_A,Staff_roll_B
;----------------------------------------------------------------------------
		ext	WINDOW_CONTROL
		ext	ED_main_1,ED_main_2,ED_main_3,Final_main
		ext	ED_nmi_1,ED_nmi_2,ED_nmi_3,TITL_nmi,Final_nmi
		ext	K_SL_nmi,W_SL_nmi,C_SL_nmi,DP_nmi,DP_main
		ext	K_SL_main,W_SL_main,C_SL_main,REC_main,TITL_main
		ext	COP_Entry,Ending2_main,Ending2_nmi
;----------------------------------------------------------------------------
		ext	Title_sub,Start_title
;----------------------------------------------------------------------------
		include	rp5a22
		include rp5c77
		include work.def
		include buffer.def
		include ../join/object.def
;****************************************************************************
;		data
;****************************************************************************
		prog
		mem8
		idx8
Reset_entry
		native
		sei
		rep	#00001001b
		xce 
		mem8
		idx8
		sep	#00110000b
		lda	#01fh
		xba
		lda	#0ffh		;stack pointa=1fffh
	 	tcs			;A resister>>>stack pointa
		lda	#01h
		sta	!420dh		;hyper ROM!!!
		jmp	>Reset_initialrize
;----------------------------------------------------------------------------
NMI_entry
		jsl	>NMI_prosses
		rti
;----------------------------------------------------------------------------
IRQ_entry
		jsl	>IRQ_prosses
		rti
;----------------------------------------------------------------------------
COP_entry
		jmp	>COP_Entry
;----------------------------------------------------------------------------
bank80		sect	rel		;
;----------------------------------------------------------------------------
		mem16
		idx16
NMI_prosses
		php
		rep	#00111000b
		phb				;push data dank resister
		phk
		plb				;push data dank resister
		pha
		phx
		phy
		lda	!NMI_status		;read resister!
		inc	<nmi_counter
   		jsr	!Fade_control
		lda	>game_index
		tax
		jsr	(!NMI_address,x) 	; fast prosses !!!  
		ply
		plx
		pla
		plb
		plp
Not_use
		rtl
;----------------------------------------------------------------------------
IRQ_prosses
		mem16
		idx16
		php
		rep	#00111000b
		phb
		phk
		plb
		pha
		phx
		phy
		mem8
		idx8
		sep	#00110000b
		ldx	<irq_index
		lda	!4211h			;IRQ read reset
		jsr	(!IRQ_subroutin,x)
		mem16
		idx16
		rep	#00110000b
		ply
		plx
		pla
		plb
		plp
		rtl
;----------------------------------------------------------------------------
Reset_initialrize
		phk
		plb
		mem8
		idx8
		
		stz	!NMI_control	;NMI disable
					;H,Vtimer disable
					;joystick disable
		stz	!DMA_burst
		stz	!DMA_syncro	;H_DMA chanel 
		lda	#10001111b
		sta	!PPU_control	;224 dot mode
					;not interless mode
					;not super inpose
					;blanking on
					;fade out max
		stz	!Out_expansive  ; 4016H
                sta     !Out_auxilary   ; 4201H
;		
		jsl	>Initialize_process
					;return m16x16
		mem16
		idx16
		rep	#00110000b
;----------------------------------------------------------------------------
Main_loop
		jsl	>Selection_process
		stz	<NMI_flag
Wait_NMI
		lda	<NMI_flag
		beq	Wait_NMI
		ldx	<game_index
		jsr	(!Process_address,x)
		bra	Main_loop
;----------------------------------------------------------------------------
Playing_process02				;race
		lda	!pause_status
		bmi	Pause_status
Race_nomal;------------------------------------------------------------------
		inc	<frame_counter
;
		jsl	>WINDOW_CONTROL
;
		jsr	!Set_position
;
		jsr	!Camera_controlB
					;position>>>camera param(DSP)
					;	    & scroll centerx,y
		jsl	>OBJ_setB
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
		jsr	!Official_B
;
		jsr	!Set_trans_bufferB
;					OBJ character data trans control
		jsr	!Camera_controlA
					;position>>>camera param(DSP)
					;           & scroll centerx,y
		jsr	!Set_trans_bufferA
;
		jsl	>OBJ_setA
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
		jsr	!Official_A
;
		jsr	!Race_control
					;calculate world position
					;for mycar & ememy car
		jsl     >Color_effect
Playing_process00
Playing_process1A
		rts
;----------------------------------------------------------------------------
Pause_status
					;A=pose_status
		bit	#0100000000000000b
		beq	Not_pause_trigger
;----------------------------------------------------------------------------
Pause_trigger
		jsr	!Camera_controlB
					;position>>>camera param(DSP)
					;	    & scroll centerx,y
;
		jsl	>OBJ_setB
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
		jsr	!Camera_controlA
					;position>>>camera param(DSP)
					;           & scroll centerx,y
		jsl	>OBJ_setA
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
Not_pause_trigger
		jsr	!Pause_main
		jsl	>RAM_EDIT_A
		jsl	>RAM_EDIT_B
		jsl	>WINDOW_CONTROL
		rts
;----------------------------------------------------------------------------
Playing_process04				;Title
		inc	<frame_counter
		lda	#040h
		sta	!fade_speed
		jsl	>TITL_main
		jsr	!Title_sub
		rts
;---------------------------------------------------------------------------
Playing_process06			;kart select
		inc	<frame_counter
		lda	#060h
		sta	!fade_speed
		jsl	>K_SL_main
		rts
;---------------------------------------------------------------------------
Playing_process08			;world select
		inc	<frame_counter
		jsl	>W_SL_main
		rts
;---------------------------------------------------------------------------
Playing_process0A			;Driver's point
		inc	<frame_counter
		jsl	>DP_main
		rts
;---------------------------------------------------------------------------
Playing_process1C			;Record
		inc	<frame_counter
		jsl	>Ending2_main
		rts
;---------------------------------------------------------------------------
Official_A
		lda	!1000h+official_control
		sta	!screenA_official
		jsr	!Official_control_A
		lda	!screenA_official
		sta	!1000h+official_control
		rts
Official_B
		lda	!1100h+official_control
		sta	!screenB_official
		jsr	!Official_control_A
		lda	!screenB_official
		sta	!1100h+official_control
		rts
;----------------------------------------------------------------------------
Playing_process0E
		lda	!pause_status
		bmi	Pause_status
Battle_nomal
		inc	<frame_counter
;
		jsl	>WINDOW_CONTROL
;
		jsr	!Set_position
;
		jsr	!Camera_controlB
					;position>>>camera param(DSP)
					;	    & scroll centerx,y
		jsr	!Battle_objsetB
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
		jsr     !Official_B
;
		jsr	!Set_trans_bufferB
;					OBJ character data trans control
		jsr	!Camera_controlA
					;position>>>camera param(DSP)
					;           & scroll centerx,y
		jsr	!Set_trans_bufferA
		jsr	!Battle_objsetA
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
;
		jsr     !Official_A
;
		jsr	!Battle_control
					;calculate world position
					;for mycar & ememy car
		rts
;----------------------------------------------------------------------------
Playing_process0C				;Ending 01

		inc	<frame_counter
		dec	!color_trans_flag
;
		jsl	>WINDOW_CONTROL
;
		jsr	!Set_position
;
		jsr	!Camera_controlB
					;position>>>camera param(DSP)
					;	    & scroll centerx,y
		jsl	>OBJ_setB
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
		jsl	>Staff_roll_B
;
		jsr	!Set_trans_bufferB
;					OBJ character data trans control
		jsr	!Camera_controlA
					;position>>>camera param(DSP)
					;           & scroll centerx,y
		jsr	!Set_trans_bufferA
;
		jsl	>OBJ_setA
					;calcurate 3D>>2D
					;obj priority check
					;set OAM buffer
		jsl     >Staff_roll_A
;
		jsr	!Ending_control
					;calculate world position
					;for mycar & ememy car
		jsl     >Color_effect
		rts
;----------------------------------------------------------------------------
Playing_process10				;Edit BG screen
		inc	<frame_counter
		jsl	>ED_main_1
		rts
;----------------------------------------------------------------------------
Playing_process12				;Edit drive data
		inc	<frame_counter
		jsl	>ED_main_2
		rts
;----------------------------------------------------------------------------
Playing_process14				;Edit drive data
		inc	<frame_counter
		jsl	>ED_main_3
		rts
;----------------------------------------------------------------------------
Playing_process16				;cource select
		inc	<frame_counter
;
		jsl	>WINDOW_CONTROL
;
		jsr	!Camera_controlB
					;position>>>camera param(DSP)
					;	    & scroll centerx,y
		jsr	!Camera_controlA
					;position>>>camera param(DSP)
					;           & scroll centerx,y
		jsl     >Color_effect
;
		jsl	>C_SL_main
		rts
;----------------------------------------------------------------------------
Playing_process18				;
		inc	<frame_counter
		jsl	>Final_main
		rts
;----------------------------------------------------------------------------
Process_address
	word	Playing_process00,Playing_process02,Playing_process04
	word	Playing_process06,Playing_process08,Playing_process0A
	word	Playing_process0C,Playing_process0E,Playing_process10
	word	Playing_process12,Playing_process14,Playing_process16
	word	Playing_process18,Playing_process1A,Playing_process1C
;----------------------------------------------------------------------------
NMI_package
		jsr	!Sound_set
NMI_package_sub
  		jsr	!Scan_controler
		jsr	!Game_control
		rts
;----------------------------------------------------------------------------
NMI_address
	word	NMI_process00,NMI_process02,NMI_process04,NMI_process06
	word	NMI_process08,NMI_process0A,NMI_process0C,NMI_process0E
	word	NMI_process10,NMI_process12,NMI_process14,NMI_process16
	word	NMI_process18,NMI_process1A,NMI_process1C
;----------------------------------------------------------------------------
NMI_process00
NMI_process1A
		lda	>NMI_flag
		bne	Prosses_over00
		dec	a
		sta	>NMI_flag
Prosses_over00
		rts
;----------------------------------------------------------------------------
NMI_process02					;race
		stz	!time_checker
		lda	>NMI_flag
		bne	Prosses_over01
		dec	a
		sta	>NMI_flag
		lda	!pause_status
		bpl	Non_pose_nmi
		jsr	!Pause_nmi
Non_pose_nmi
		lda	#0000000100000000b
		sta	!DMA_syncro		;low HDA syncro
						;high B0=hyper rom bit!!!
		jsr     !OBJ_transport
;
		jsr	!BG_transport
						;BG screen&character trans
;						;output m16x16
;
		jsr	!Race_checker
		jsl	>Set_HDMA_parameter
		jsr	!Screen_control		;HDMA & IRQ set control
						;
;
		jsr	!Demo_camera
		jsr	!NMI_package
		rts
;----------------------------------------------------------------------------
Prosses_over01  
		lda	#0ffffh
		sta	!over_flag
		lda	<race_status
		beq	Skip_NMI
		jsr     !OBJ_transport
		jsr	!Race_checker
		jsl	>Set_HDMA_parameter
		jsr     !Screen_control
		jsr     !Demo_camera
Skip_NMI
		rts
;----------------------------------------------------------------------------
NMI_process04					;Title
;						;onput m16x16
		lda	>NMI_flag
		bne	Prosses_over04
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl	>TITL_nmi
		jsr	!NMI_package
Prosses_over04						;output m16x16
		rts
;----------------------------------------------------------------------------
NMI_process06					;Kart select
		lda	>NMI_flag
		bne	Prosses_over06
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl	>K_SL_nmi
		jsr	!NMI_package
Prosses_over06						;output m16x16
		rts
;----------------------------------------------------------------------------
NMI_process08					;World select 
		lda	>NMI_flag
		bne	Prosses_over08
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl	>W_SL_nmi
		jsr	!NMI_package
Prosses_over08						;output m16x16
		rts
;----------------------------------------------------------------------------
NMI_process0A					;Driver's point
		lda	>NMI_flag
		bne	Prosses_over0A
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl     >DP_nmi
		jsr	!NMI_package
Prosses_over0A						;output m16x16
		rts
;----------------------------------------------------------------------------
NMI_process0C					;Ending 01
		stz	!time_checker
		lda	>NMI_flag
		bne	Prosses_over0C
		dec	a
		sta	>NMI_flag
		lda	#0000000100000000b
		sta	!DMA_syncro		;low HDA syncro
						;high B0=hyper rom bit!!!
		lda	!ending_status
		bne	On_initial
		lda	!trans_map
		bne	Now_transporting
		jsr     !OBJ_transport
		jsr	!BG_transport
						;BG screen&character trans
Now_transporting
		stz	<trans_counter
		jsl	>DMA_map
;
		jsr	!Screen_control		;HDMA & IRQ set control
						;
;
		jsl	>Set_HDMA_parameter
;
		jsr	!Demo_camera
		jsr	!NMI_package
On_initial
		rts
;----------------------------------------------------------------------------
Prosses_over0C  
		lda     !ending_status
		bne     On_initial
		lda	#0ffffh
		sta	!over_flag
		lda	<race_status
		beq	Skip_NMI_0C
		jsr     !OBJ_transport
		jsr     !Screen_control
		jsl	>Set_HDMA_parameter
		jsr     !Demo_camera
Skip_NMI_0C
		rts
;----------------------------------------------------------------------------
NMI_process1C					;Ending 02
		lda	>NMI_flag
		bne	Prosses_over1C
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl	>Ending2_nmi
		jsr	!NMI_package
Prosses_over1C						;output m16x16
		rts
;----------------------------------------------------------------------------
NMI_process0E					;battle
		lda	>NMI_flag
		bne	Prosses_over0E
		dec	a
		sta	>NMI_flag
		lda	!pause_status
		bpl	Non_pose_battle
		jsr	!Pause_nmi
Non_pose_battle
		jsr     !OBJ_transport
						;from color buffer 
						;   to CG RAM
		jsr	!Screen_control		;HDMA & IRQ set control
						;
		jsr	!Battle_nmi
						;BG screen&character trans
;						;output m16x16
		jsr	!Race_checker
		jsl	>Set_HDMA_parameter
		jsr	!NMI_package
		rts
Prosses_over0E
		lda	#0ffffh
		sta	!over_flag
		lda	<race_status
		beq	Skip_NMI_battle
		jsr     !OBJ_transport
		jsr     !Screen_control
		jsr	!Race_checker
		jsl	>Set_HDMA_parameter
		jsr     !Demo_camera
Skip_NMI_battle
		rts
		rts
;----------------------------------------------------------------------------
NMI_process10					;edit BG screen
		lda	>NMI_flag
		bne	Prosses_over10
		dec	a
		sta	>NMI_flag
						;output m16x16
		jsr	!Set_OAM_screen1
		jsl	>ED_nmi_1
		jsr	!NMI_package
Prosses_over10
		rts
;----------------------------------------------------------------------------
NMI_process12					;edit drive data
		lda	>NMI_flag
		bne	Prosses_over12
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl	>ED_nmi_2
		jsr	!NMI_package
Prosses_over12
		rts
;----------------------------------------------------------------------------
NMI_process14					;edit drive data
		lda	>NMI_flag
		bne	Prosses_over14
		dec	a
		sta	>NMI_flag
		jsr	!Set_OAM_screen1
		jsl	>ED_nmi_3
		jsr	!NMI_package_sub
Prosses_over14
		rts
;----------------------------------------------------------------------------
NMI_process16					;cource select prosses
		lda	>NMI_flag
		bne	Prosses_over16
		dec	a
		sta	>NMI_flag
		jsr     !OBJ_transport
		jsr	!Screen_control		;HDMA & IRQ set control
		jsl	>Set_HDMA_parameter
		jsl	>C_SL_nmi
		jsr	!NMI_package
		rts
Prosses_over16
		jsr	!Sound_set_trigger
		jsr     !Screen_control
		jsl     >C_SL_nmi
		rts
;----------------------------------------------------------------------------
NMI_process18					;official commendation
		lda	>NMI_flag
		bne	Prosses_over18
		dec	a
		sta	>NMI_flag
		jsr     !OBJ_transport
		jsr	!Set_OAM_screen1
		jsl	>Final_nmi
		jsr	!NMI_package
		rts
Prosses_over18
		jsl     >Final_nmi
		rts
;----------------------------------------------------------------------------
Color_transport_l
		jsr	!Color_transport
		rtl
Color_transport_s
		mem16
		rep	#00110000b
		lda	!color_trans_flag
		bne	Color_transport
		lda	!map_type
		cmp	#0ah
		bne	Trans_tire_color
							;sand map!!!
		lda	!over_flag			;time over?
		bne	Trans_tire_color
		lda	<frame_counter
		and	#0111b
		cmp	#0111b
		beq	Color_transport
Trans_tire_color
		lda	#2202h
		sta	!DMA_0+00h
						;b012=set data twice
						;high=set 2122h
		lda	#02ch
		sta	!DMA_0+05h
		lda	<frame_counter
		ror	a
		bcs	Tire_later
Tire_faster
		lda	#offset color_buffer+100h
		sta     !DMA_0+02h
		lda	#080h
		bra	Set_CGRAM
Tire_later
		lda	#offset color_buffer+140h
		sta     !DMA_0+02h
		lda	#0a0h
Set_CGRAM
		mem8
		sep	#00100000b
		sta	!Color_address
		bra	Set_trans_switch
Color_transport
		mem16
		rep     #00110000b
		stz	!color_trans_flag
		lda	#0200h
		sta	!DMA_0+05h		;trans 100h
		lda	#offset color_buffer
		sta	!DMA_0+02h		;address 0f00h
		lda	#2202h
		sta	!DMA_0+00h
						;b012=set data twice
						;high=set 2122h
		mem8
		sep	#00100000b
		stz	!Color_address		;color 000h-ffh
Set_trans_switch
		lda	#bank color_buffer	
		sta	!DMA_0+04h
		lda	#01h
		sta	!DMA_burst
		mem16
		rep	#00100000b
		rts
;----------------------------------------------------------------------------
Scan_controler
		mem16
		idx16
		ldx	#0000h
    		jsr	!Scan_subroutin
		ldx	#0002h
Scan_subroutin
		lda	!Button,x		;read 4218h
		sta	<button_status,x	;set button status
		pha
		eor	<button_stock,x
		and	<button_status,x
		sta	<button_trigger,x	;set button trigger
		ldy	!o_demo_flag
		beq	Cont_scan
		ldy	!ending_flag
		bne	Cont_scan
		ldy	!game_selecta
		bne	Cont_scan
		bit	#1001000000000000b	;B or Start button?
		beq	Cont_scan
		pla
		jmp	>Start_title
Cont_scan
		pla
		sta	<button_stock,x
		rts
;----------------------------------------------------------------------------
		org	0ffc0h
		byte	53h,55h,50h,45h,52h,20h		;SUPER
		byte	4dh,41h,52h,49h,4fh,20h		;MARIO
		byte	4bh,41h,52h,54h			;KART
		byte	20h,20h,20h,20h,20h
		byte	31h				;Map Mode
		byte	05h				;Cartrige Type
		byte	09h				;ROM size
		byte	01h				;RAM size
		byte	01h				;Maker code
		byte	01h				;   ;
		byte	00h				;Mask ROM Version
		byte	0ffh
		byte	0ffh
		byte	00h
		byte	00h
;----------------------------------------------------------------------------
		org	0ffeah
		word	NMI_entry
		org	0ffeeh
		word	IRQ_entry
		org	0fffch
		word	Reset_entry	
		org	0ffe4h
		word	COP_entry
		end
