;*********************************************************************
;	mario kart << OBJ MAIN >>
;					Programed by H.Yajima
;*********************************************************************
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	glb	Ending_objinit
;
	ext	SE_trigger_1,SE_trigger_2
	EXT	Enemy_fire_A,Enemy_fire_B,Enemy_fire_GP
	ext	Init_BTmode,Set_BTmode_A,Set_BTmode_B
	ext	Trigger_sound_1,Trigger_sound_2
	ext	SE_trigger_1,SE_trigger_2
	ext	Debug_replay
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	
	ext	Doppler_A,Doppler_B,Doppler_GP
	ext	Limit_time
	ext	Init_reclap
	ext	Main_round,DMA_round
	ext	Init_demoword,Main_demoword
	ext	Count_item
	ext	Init_question,DMA_question
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -	
	EXT	SPRITE_SET,Sprite_set,gameover
	EXT	Set_objmeter,Erase_objmeter,Clear_objmeter,Set_objmask
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	EXT	DMA_goalin,Init_goalin
	EXT	Set_over_char,Reform_sprite
	EXT	DMA_trans,Stop_trans
	GLB	Demo_camera,DMA_character,Clear_allOBJ
;----------------------------------------------------------------------
	GLB	Battle_objinit,Battle_objsetA,Battle_objsetB,Battle_nmi
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	Free_objinit
	GLB	OBJ_initial,OBJ_setA,OBJ_setB,BG_transport
	GLB	Clear_sprite,Clear_buffer,Init_work
	GLB	oamset_A,oamset_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	param_screenA,param_screenB,kart_Z
	GLB	sort_A_entry,clear_spbuff,clear_sub_Z
;----------------------------------------------------------------------	
	GLB	Call_bank0
	EXT	Call_bank1
;----------------------------------------------------------------------	
	EXT	First_debug,Main_debug,debug_FLAG	; debug
	EXT	Set_VRAMextra				; vram set
	EXT	debug_powON
	EXT	OBJmove					; item move
	EXT	Init_net,Main_net			; network
	EXT	DMA_result,Disp_result			; result
	EXT	Disp_goalin				; goalin
	EXT	Init_BGmove,Set_BGmove,DMA_BGmove	; BGmove
	EXT	Init_object,Scene			; sprite
	ext	Hit_check,Hit_battle			; hit
	EXT	Init_meter,DMA_meter			; meter
	EXT	Set_shadow,Init_shadow			; shadow
	EXT	Init_item,Main_item,DMA_item		; fire item
	EXT	Write_M7screen,Init_my_item,Set_my_item	; slot item
	EXT	BGcheck_kart				; BGcheck
	EXT	Init_jugem,Set_jugem			; jugem
	EXT	Set_watch_1p,Set_watch_2p,Set_watch_VS	; watch 
	EXT	Init_camera
	GLB	Official_control_A,Official_control_B
;----------------------------------------------------------------------
	EXT	CLEAR_RAM,Execute_VRAM
	EXT	CLEAR_SPRITE				;LIB
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	Decode_7E,Decode_7F,Decode_M7
	EXT	Decode_7E_X,Decode_7F_X,Decode_mode7	;ISPK
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	GLB	Pause_nmi,Pause_main
	GLB	RAM_EDIT_A,RAM_EDIT_B
	EXT	RAM_editer_A,RAM_editer_B		;PAUSE
	EXT	Set_DBnumber_B
;----------------------------------------------------------------------	
	glb	Set_objcountX
	glb	clear_spbuffX
	ext	Load_replay
;----------------------------------------------------------------------	
		EXTEND
objprog	SECT	REL
		mem16
		idx16
;######################################################################
;######		naiC[`				#######
;######################################################################
;
stop_prog	LDA	>2FFFFFH
		LDA	>2FFFFFH
		LDA	>2FFFFFH
		LDA	>2FFFFFH
		jmp	stop_prog
;
;- - - - - - - - - - - - - - - - - - - - - - - - 
Set_objcountX	ldx	#Set_objcount
		jsl	>Call_bank1
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
clear_spbuffX	ldx	#clear_spbuff
		jsl	>Call_bank1
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
;
;*********************************************************************
;	og[`
;*********************************************************************
Battle_objsetA	JSL	>OBJ_setA
		RTS
Battle_objsetB	JSL	>OBJ_setB
		RTS
;*********************************************************************
;	nai@mlh[`
;*********************************************************************
Battle_nmi
BG_transport	
		lda	!nmi_vector		; ܂񂪂
		beq	exit$

		lda	!nmi_overflow
		beq	skip$
loop$		dec	a		
		bne	loop$

skip$		jmp	(!nmi_vector)
exit$		rts

;*********************************************************************
;	
;*********************************************************************






;- - - - - - - - - - - - - - - - - - - - -
;
;
;
;#####################################################################
;
;		UTILITY	
;
;#####################################################################
;*********************************************************************
;		q`l̂cl`NA
;*********************************************************************
Clear_sprite	JSL	>CLEAR_SPRITE
		RTS
Clear_buffer	LDX	#clear_buffer
		JSL	>CLEAR_RAM		
		RTS
;---------------------------------------------------------------------
clear_buffer	DW	work_meter,work_pole,work_extra
		DW	work_kabe,0
;-------------------------------------- ; work clear ------------------
work_extra	dw	0
		dl	0f80h		; f80h - fffh
		dw	080h
work_meter	dw	0
		dl	0C00H		; C00H - D7FH
		dw	180H
work_pole	dw	0
		dl	1800H		; 1800H - 1EFFH
		dw	700H
work_kabe	dw	0		; 7F bank
		dl	kabe_buffer
		dw	100h
;----------------------------------------------------------------------
				; 1000H - 17FFH ( kart work )
				;  800H -  AFFH ( battle work )
				;  D80H -  DFFH ( changeBG work )
;*********************************************************************
;= = = = = = = LN^[][` = = = = = = = = = = = = = = = 
;*********************************************************************
DMA_character	LDA	!trans_count		:W
		BEQ	exit$
		STZ	!trans_count		;W
		STA	!DMA_0+DMA_count+0	;W
		SEP	#00100000B
		MEM8
		LDX	#1801H			;W	low,high 2byte
		STX	!DMA_0+DMA_control	;W
		LDX	!trans_address		;W
		STX	!DMA_0+DMA_address+0	;W
		LDA	!trans_bank		;B
		STA	!DMA_0+DMA_address+2	;B	bank
		LDA	#80H			;B
		STA	!Screen_step		;B	hi inc
		LDX	!trans_vram		;W
		STX	!Screen_address		;W
		LDA	#00000001B		;B
		STA	!DMA_burst		;B
		REP	#00100000B
		MEM16
exit$		RTS
;#####################################################################
;	fJ̃|WVZbg
;#####################################################################
Demo_camera	LDA	!camera_FG+0
		BEQ	skip$
		LDX	#0
		JSR	set$
skip$		LDA	!camera_FG+2
		BEQ	exit$
		LDX	#2
set$		LDA	!camera_dX,X
		STA	<camera_x,X		; x position
		LDA	!camera_dY,X
		STA	<camera_y,X		; y position
		LDA	!camera_dQ,X
		STA	<camera_direction,X	; pose Q
exit$		RTS
;######################################################################
;	wifXN[
;######################################################################
		GLB	Call_back_scroll
		EXT	Set_back_scroll
;- - - - - - - - - - - - - - - - - - - - - - - - - - 
Call_back_scroll
		PHB
		PHK
		PLB
		JSR	Set_back_scroll
		PLB
		RTL
;######################################################################
;	|[YR[(Oa`mj)
;######################################################################
		EXT	PAUSE_MAIN
		EXT	Frash_corsor
;----------------------------------------------------------------------
Pause_nmi	JMP	DMA_character
Pause_main	PEA	BC_00_01
		PLB
		JSL	>PAUSE_MAIN
		PLB
		RTS
;----------------------------------------------------------------------
RAM_EDIT_A
RAM_EDIT_B	LDA	#0			; BUG MAK !!
		RTL
;#####################################################################
;#####		UTILITY						######	
;#####################################################################
;*********************************************************************
;	s[ggK
;*********************************************************************
		GLB	Repeat_trigger
;====================================================================
Repeat_trigger	SEP	#00110000B
		MEM8
		IDX8
		LDX	#2
loop$		LDA	<button_status+1,X	;B
		AND	#00FH			;B ( up/down/left/right )
		LDY	!repeat_work,X		;B		
;- - - - - - - - - - - - -
		JSR	main_repeat
		STA	<0
		LDA	<button_trigger+1,X
		AND	#0F0H
		ORA	<0		
		STA	!trigger_repeat+1,X	;B
		LDA	<button_trigger+0,X
		STA	!trigger_repeat+0,X
		TYA				;BB
		STA	!repeat_work,X		;B
;- - - - - - - - - - - - -
		DEX
		DEX
		BPL	loop$
		REP	#00110000B
		MEM16
		IDX16
		LDA	!trigger_repeat+0
		ORA	!trigger_repeat+2
		STA	!trigger_common
		RTL
;====================================================================
		mem8
		idx8
main_repeat	STY	<0
		CLC				;(auto repeat)
		TAY				;
		BEQ	store$			;
		SEC				;
		LDY	<0
		BEQ	step$
		CPY	#18			;B
		BCC	step$			;
		LDY	#12			;
step$		INY				;B
store$		BCS	repeat$		;
		LDA	#0			;B
repeat$		RTS
		mem16
		idx16
;*********************************************************************
;	OoN[`R[
;*********************************************************************
Call_bank0	PHB
		PHK
		PLB
		STX	!nmi_work
		LDX	#nmi_work
		JSR	(!0,X)
		PLB
		RTL
;*********************************************************************
;	J[gvO[`R[
;*********************************************************************
		GLB	demokart_bank0
demokart_bank0	PHB
		PHK
		PLB
		JSR	(!0,X)			;
		PLB
		RTL
;*********************************************************************
;	kTu[`R[
;*********************************************************************
Decode_7E	JSL	>Decode_7E_X
		RTS
Decode_7F	LDX	#0
		JSL	>Decode_7F_X
		RTS
Decode_M7	JSL	>Decode_mode7
		RTS
;*********************************************************************
;	WQR[(Oa`mjj
;*********************************************************************
Official_control_B
Official_control_A
		PEA	BC_00_05		; bank change
		PLB
		ldx	<screen_register
		ldy	<player_index,x
		bmi	exit$
		JSL	>Set_jugem
exit$		PLB
		RTS

;$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$
;$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$
;$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$
;$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$
;$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$--$
;
;
;######################################################################
;######		nai mlhvZX				#######
;######################################################################
no_process	RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
battle_nmi	JSL	>DMA_question
rankout_nmi	BRA	rase_nmi
VSgoalin_nmi	
goalin_nmi	JSL	>DMA_goalin
		BRA	rase_nmi
edit_nmi	JSL	>Set_DBnumber_B
rase_nmi	JSL	>DMA_result		
		JSL	>DMA_BGmove
		JSL	>DMA_meter
		JSL	>Write_M7screen
		jsr	DMA_block
		jsr	DMA_item
		jsl	>DMA_round
		jmp	DMA_character
;
		ext	DMA_block


ending_nmi	jsl	>DMA_BGmove
		jsl	>DMA_meter
		rts


;######################################################################
;
OAMSET_A	
		PHB
		PHK
		PLB
		jsr	check_player
;--------------------------------------------------------------------
entry$		LDY	<A_forward		;W
		BRA	oam_A_100
oam_A_loop	STY	<register
		LDX	<_object_A,Y		;
		INX				;
		INX				;
		JSR	(!0,X)			;
		LDX	<register		;
		LDY	<_forward_A,X		;(next program address)
oam_A_100	CPY	#A_root			;(sprite end ?)
		BNE	oam_A_loop
;- - - - - - - - - - - - - - - - - - - - - - - - 
		JSR	Set_shadow
;- - - - - - - - - - - - - - - - - - - - - - - - 
	;;	lda	!over_timer
	;;	bne	exit$
		bit	<player_index+0
		bvs	exit$
		LDA	!course_type
		BNE	exit$
		LDY	<pipe_A_forward		;΂Jp
		BRA	entry$
loop$		STY	<register
		LDX	<_object_A,Y
		INX
		INX
		JSR	(!0,X)
		LDX	<register
		LDY	<_forward_A,X
entry$		CPY	#pipe_A_root
		BNE	loop$
;- - - - - - - - - - - - - - - - - - - - - - - - 
exit$		PLB
		RTL
;######################################################################


;- - - - - - - - - - - - - - - - - - - - - - - - 
VSSET_A		PHB
		PHK
		PLB
		jsr	check_player
;- - - - - - - - - - - - - - - - - - - - - - - - 
		ldx	#A_root
		stx	!kart_register
		ldx	#pipe_A_root
		stx	!pipe_register
;- - - - - - - - - - - - - - - - - - - - - - - - 
main$		ldx	!kart_register
		ldy	<_forward_A,x		; J[gnaiH
		cpy	#A_root
		bne	skip_0$
;- - - - - - - - - - - - - - - - - - - - - - - - 
pole_loop$	ldx	!pipe_register		
		ldy	<_forward_A,x		; QnaiH	
		cpy	#pipe_A_root
		bne	pole$
		beq	exit$			; ŏIII
;- - - - - - - - - - - - - - - - - - - - - - - - 
skip_0$		tya				; -> kart_reg
		ldx	!pipe_register
		ldy	<_forward_A,x		; QnaiH	
		cpy	#pipe_A_root
		beq	kart$
;- - - - - - - - - - - - - - - - - - - - - - - - 
check$		tax				; <- kart_reg
		lda	<_distance_A,x		; J[g
		cmp	!_distance_A,y		; Q
		bcc	pole$			; `FbN
;- - - - - - - - - - - - - - - - - - - - - - - - -
		txa
kart$		sta	!kart_register		; J[gn`lZbg
		tay
		bra	oamset$
pole$						; Qn`lZbg
		sty	!pipe_register
	;;	lda	!over_timer
	;;	bne	main$
;- - - - - - - - - - - - - - - - - - - - - - - - 
oamset$		sty	<register
		ldx	<_object_A,y
		inx
		inx
	;;	lda	!obj_count_A		; I[o[
	;;	cmp	!obj_limit		;
	;;	bcs	main$			;
		jsr	(!0,x)
		bra	main$
;- - - - - - - - - - - - - - - - - - - - - - - - 
exit$		
		JSR	Set_shadow

		PLB
		RTL
	;	rts
;- - - - - - - - - - - - - - - - - - - - - - - - 

;######################################################################
OAMSET_B	PHB
		PHK
		PLB

		jsr	check_player
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
oamset_B_entry	LDY	<B_forward		;
		BRA	oam_B_100
oam_B_loop	STY	<register		;
		LDX	<_object_B,Y		;
		INX				;
		INX				;
		JSR	(!0,X)			;
		LDX	<register		;
		LDY	<_forward_B,X		;(next program address)
oam_B_100	CPY	#B_root			;(sprite end ?)
		BNE	oam_B_loop
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		JSR	Set_shadow
;- - - - - - - - - - - - - - - - - - - - - - - - 
	;;	lda	!over_timer
	;;	bne	exit$

		bit	<player_index+2
		bvs	exit$
		LDA	!course_type
		BNE	exit$
		LDY	<pipe_B_forward		;΂Jp
		BRA	entry$
loop$		STY	<register
		LDX	<_object_A,Y
		INX
		INX
		JSR	(!0,X)
		LDX	<register
		LDY	<_forward_A,X
entry$		CPY	#pipe_B_root
		BNE	loop$
;- - - - - - - - - - - - - - - - - - - - - - - - 
exit$		PLB
		RTL
;######################################################################
;- - - - - - - - - - - - - - - - - - - - - - - - 
VSSET_B		PHB
		PHK
		PLB
;
		jsr	check_player
		ldx	#B_root
		stx	!kart_register
		ldx	#pipe_B_root
		stx	!pipe_register
;- - - - - - - - - - - - - - - - - - - - - - - - 
main$		ldx	!kart_register
		ldy	<_forward_B,x		; J[gnaiH
		cpy	#B_root
		bne	skip_0$
;- - - - - - - - - - - - - - - - - - - - - - - - 
pole_loop$	ldx	!pipe_register		
		ldy	<_forward_A,x		; QnaiH	
		cpy	#pipe_B_root
		bne	pole$
		beq	exit$			; ŏIII
;- - - - - - - - - - - - - - - - - - - - - - - - 
skip_0$		tya				; -> kart_reg
		ldx	!pipe_register
		ldy	<_forward_A,x		; QnaiH	
		cpy	#pipe_B_root
		beq	kart$
;- - - - - - - - - - - - - - - - - - - - - - - - 
check$		tax				; <- kart_reg
		lda	<_distance_B,x		; J[g
		cmp	!_distance_B,y		; Q
		bcc	pole$			; `FbN
;- - - - - - - - - - - - - - - - - - - - - - - - -
		txa
kart$		sta	!kart_register		; J[gn`lZbg
		tay
		sty	<register
		ldx	<_object_B,y
		inx
		inx
		jsr	(!0,x)
		bra	main$
		bra	oamset$
;- - - - - - - - - - - - - - - - - - - - - - - - 
pole$						; Qn`lZbg
		sty	!pipe_register
	;;	lda	!over_timer
	;;	bne	main$
;- - - - - - - - - - - - - - - - - - - - - - - - 
oamset$		sty	<register
		ldx	<_object_A,y
		inx
		inx
		jsr	(!0,x)
		bra	main$
;- - - - - - - - - - - - - - - - - - - - - - - - 
exit$		

		JSR	Set_shadow

		PLB
		RTL
;*********************************************************************
;		ЕQ[I[o[ɂȂ
;*********************************************************************
		ext	Erase_BGmeter,Erase_JUGEM
		ext	Set_gameover,Set_over_char
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
check_player	ldx	<screen_register
		lda	!erase_kart+0,x
		bpl	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	!gameover_status,x
		bmi	skip$
		ora	#8000h
		sta	!gameover_status,x
		jsl	>Set_over_char
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
skip$		lda	#20H			;(L)
		sta	!obj_count_A+0,x
		jsl	>Erase_objmeter
		ldx	#Erase_BGmeter
		jsl	>Call_bank1
		ldx	#Erase_JUGEM
		jsl	>Call_bank1
		jsl	>Set_gameover
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -





		EXTEND
objdata	SECT	REL
		mem16
		idx16
;######################################################################
;######		naiCvZX				#######
;######################################################################
;*********************************************************************
;	ʏ̂naiׂď
;*********************************************************************
;		backup <- old sprite count
;		new sprite count -> backup
;---------------------------------------------------------------------
;		X=0 Ascreen	X=2 Bscreen
;---------------------------------------------------------------------
		GLB	Clear_allOBJ
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
param_select	DW	param_screenA,param_screenB
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
Clear_allOBJ	JSR	(!param_select,X)	; A or B set
		JSR	Set_objcount
		JSR	clear_spbuff		; kart/dokan clear
		LDX	<screen_oam
;- - - - - - - - - - - - - - - - - - - - ; jugem clear
		LDA	#5555H
		STA	!sprite_E+2,X
		SEP	#00100000B
		MEM8
		STA	!sprite_E+1FH,X
		REP	#00100000B
		MEM16
;- - - - - - - - - - - - - - - - - - - -
		RTS
;*********************************************************************
;	gpn`lGÂu|WVNA
;*********************************************************************
;		backup <- old sprite count
;		new sprite count -> backup
;---------------------------------------------------------------------
clear_spbuff	LDX	<screen_register
		LDA	!backup_A,X
		SEC
		SBC	<sprite_count		;
		BMI	clear_exit
		BEQ	clear_exit
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		TAY				; Y = clear counter
		LDX	<sprite_count		; X = sprite count
		CLC
clear_loop	LDA	#0E0E0H			; Y = clear data
		STA	<sprite_H+0,X		; clear V position
		STA	<sprite_H+4,X		; clear V position
  		STA	<sprite_H+8,X		; clear V position
		STA	<sprite_H+12,X		; clear V position
		TXA
		ADC	#10H
		TAX
		DEY
		BNE	clear_loop
clear_exit	LDX	<screen_register
		LDA	<sprite_count
		STA	!backup_A,X
		RTS
;*********************************************************************
;	`^a@ʂ̃p[^
;*********************************************************************
side_A_data	dw	00000h		; ʃWX^
		dw	00200h		; n`l̃ItZbg
		dw	003e0h		; n`lTũItZbg
		dw	00000h		; IuWF Vpos ̃ItZbg
		dw	demoobj_work+0	; fp[N̉ʃItZbg
		dw	jugem_r0	; ʃWQ index
		dw	SE_trigger_1	; TEhgK

side_B_data	dw	00002h		; screen_register
		dw	00420h		; sprite count RAM offset
		dw	005deh		; sprite count SUB RAM offset
		dw	07000h		; Vposition A/B offset
		dw	demoobj_work+100h
		dw	jugem_r1
		dw	SE_trigger_2
;---------------------------------------------------------------------
param_screenA	LDY	#side_A_data
		BRA	param_common
param_screenB	LDY	#side_B_data		; 2
param_common	
		ldx	!0,Y
		stx	<screen_register	; <= SCREEN REGISTER
		stz	!obj_count_A,X		; <= COUNTER RESET
		lda	<player_index,x	
		sta	!screen_player		; <= NOW PLAYER
		ldx	!2,Y
		stx	<screen_oam		; <= OAM MAIN
		ldx	!4,Y
		stx	<screen_sub		; <= OAM SUB
		ldx	!6,Y
		stx	<screen_obj_V		; <= OAM V OFFSET
		lda	!8,y
		sta	!screen_coin		; <= COIN REGISTER
		lda	!10,y
		sta	!screen_jugem		; <= JUGEM 
		lda	!12,y			
		sta	!screen_sound		; <= SOUND TRIGGER
		rts
;
;***********************************************************************
;	 roqhsd@bntms ̃Zbg
;***********************************************************************
		GLB	Set_objcount
;- - - - - - - - - - - - - - - - - - - -
Set_democount	LDA	#0
		BRA	count_common
Set_objcount	LDA	#objstart
count_common	CLC
		ADC	<screen_oam
		STA	<sprite_count
					; rtaNAɑ
;***********************************************************************
;	 nairtãNA
;***********************************************************************
;		A = sprite count
;- - - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - - - -
clear_sub_Z	LDA	<sprite_count
		LSR	A
		LSR	A
		LSR	A
		LSR	A
		ADC	<screen_sub	; CLC
		TAX
		EOR	#0FFFFH
		SEC
		ADC	<screen_oam	;
		CLC
		ADC	#220H-4		; A= byte count
		STZ	<0,X		; clear data
		TXY			; X= clear inp
		INY			; Y= clear out
		PHB			;>>
		MVN	#dbank_00,#dbank_00
		PLB			;<<
		RTS
;#####################################################################
;######		Cn`lZbg				######
;#####################################################################
;*********************************************************************
;		[XpC n`l Zbgi`ʁj
;*********************************************************************
oamGP_A
oamVS_A
		lda	!course_type	; ΂Ȃ獬Zbg
		beq	skip$
		jsr	sort_A_pipe
		jsl	>VSSET_A	; Zbg
		rts
skip$
oamrace_A
oamset_A
oamBT_A
		jsl	>OAMSET_A	; Zbg
		rts
;*********************************************************************
;		GfBOp n`l Zbg
;*********************************************************************

end_oamset_A
		jsl	>OAMSET_A	; bank 0 Zbg
		rts

end_oamset_B
		jsl	>OAMSET_B
		rts


;*********************************************************************
;		[XpCn`lZbgiaʁj
;*********************************************************************
;BTlimit	db	0ah,0ah,0ah,09h,08h,07h,06h
;VSlimit	db	0ah,0ah,0ah,0ah,09h,08h,07h
			
VSlimit
BTlimit		db	1fh,1fh,1fh,1fh,1fh,1fh,1fh

;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
;og[hn`lZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
oamBT_B		jsr	Count_item
		SEP	#00110000B
		MEM8
		IDX8
		tay
		lda	!BTlimit,y
		sta	!obj_limit
		REP	#00110000B
		MEM16
		IDX16
		jsl	>OAMSET_B	; Zbg
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;fo[hn`lZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
oamGP_B		

;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		lda	!over_timer	; I[o[^C}
		beq	entry$
		dec	a
		sta	!over_timer
		stz	!over_flag
		bra	erase$
;- - - - - - - - - - - - - - - - - - - - -
entry$		lda	!GP_limitter
		ldx	!over_flag
		beq	skip$
		lda	#30
		sta	!over_timer
erase$		lda	#8
skip$		sta	!obj_limit
		bra	oamset_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 


oamrace1p_B	jsr	GP_limit
		bra	oamset_B
oamrace_B	jsr	GP_limit
		jsl	>OAMSET_B	; Zbg
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
GP_limit	ldx	#0ah
		bit	!_status+item_r0
		bpl	skip$
		dex
skip$		bit	!_status+item_r1
		bpl	skip_1$		
		dex
skip_1$		stx	!obj_limit
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;sl/ur [hn`lZbg
;- - - - - - - - - - - - - - - - - - - - - - - - - - - -
oamVS_B		jsr	Count_item
		SEP	#00110000B
		MEM8
		IDX8
		tay
		lda	!VSlimit,y
		sta	!obj_limit
		REP	#00110000B
		MEM16
		IDX16
oamset_B	lda	!course_type	; ΂Ȃ獬Zbg
		beq	skip$
		jsr	sort_B_pipe
		jsl	>VSSET_B	; Zbg
		rts
skip$		jsl	>OAMSET_B	; Zbg
		rts
;***********************************************************************
;		D揇ʂ̓ꂩ
;***********************************************************************
sort_A_map					;Pour}bv
loop$		LDY	<_forward_A,X		;W
		CPY	#A_root			;W
		BEQ	sort_A_exit
		LDA	<_posV_A,X		;W
		TYX				;WW
		CMP	<_posV_A,X		;W
		BCS	loop$
		bra	sort_A_common
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
sort_B_pipe	ldx	<pipe_B_forward
loop$		ldy	<_forward_A,X		;W
		cpy	#pipe_B_root
		beq	sort_A_exit
		lda	<_distance_B,X		;W
		tyx				;WW
		cmp	<_distance_B,X		;W
		bcs	loop$
		bra	sort_A_common
;- - - - - - - - - - - - - - - - - - - - - - - -
sort_A_pipe	ldy	#pipe_A_root
		ldx	<pipe_A_forward
		bra	sort_A_skip
;- - - - - - - - - - - - - - - - - - - - - - - -
sort_A_entry	ldy	#A_root			; ->
		ldx	<A_forward
		bit	<player_index+0
		bvs	sort_A_map
sort_A_skip	sty	<0			; <-
;- - - - - - - - - - - - - - - - - - - - - - - -
sort_A_loop	LDY	<_forward_A,X		;W
		CPY	<0
		BEQ	sort_A_exit
		LDA	<_distance_A,X		;W
		TYX				;WW
		CMP	<_distance_A,X		;W
		BCS	sort_A_loop
;- - - - - - - - - - - - - - - - - - - - - - - -
sort_A_common	LDY	<_forward_A,X		;W D<(C)
		LDA	<_backward_A,X		;W B<(C)
		TAX				;WW B
		STX	<_backward_A,Y		;W B>(D)
		LDA	<_forward_A,X		;W C<(B)
		STY	<_forward_A,X		;W D>(B)
		TAY				;W C
		STX	<_forward_A,Y		;W B>(C)
		LDA	<_backward_A,X		;W A
		STY	<_backward_A,X		;W C>(B)
		TAX				;WW A
		STX	<_backward_A,Y		;W A>(C)
		STY	<_forward_A,X		;W C>(A)
sort_A_exit	RTS
;-----------------------------------------------------------------------
sort_B_map	
loop$		LDY	<_forward_B,X		;W
		CPY	#B_root			;W
		BEQ	sort_B_exit
		LDA	<_posV_B,X		;W
		TYX				;WW
		CMP	<_posV_B,X		;W
		BCS	loop$
		bra	sort_B_common
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
sort_B_entry	ldx	<B_forward
		bit	<player_index+2
		bvs	sort_B_map
;- - - - - - - - - - - - - - - - - - - - - - - -
sort_B_loop	LDY	<_forward_B,X		;W
		CPY	#B_root			;W
		BEQ	sort_B_exit
		LDA	<_distance_B,X		;W
		TYX				;WW
		CMP	<_distance_B,X		;W
		BCS	sort_B_loop
;- - - - - - - - - - - - - - - - - - - - - - - -
sort_B_common	LDY	<_forward_B,X		;W D<(C)
		LDA	<_backward_B,X		;W B<(C)
		TAX				;WW B
		STX	<_backward_B,Y		;W B>(D)
		LDA	<_forward_B,X		;W C<(B)
		STY	<_forward_B,X		;W D>(B)
		TAY				;W C
		STX	<_forward_B,Y		;W B>(C)
		LDA	<_backward_B,X		;W A
		STY	<_backward_B,X		;W C>(B)
		TAX				;WW A
		STX	<_backward_B,Y		;W A>(C)
		STY	<_forward_B,X		;W C>(A)
sort_B_exit	RTS
;######################################################################
;######		naijV					#######
;######################################################################
;INITIAL - - - 
;*********************************************************************
;	naiCjVC[`
;*********************************************************************
		ext	init_select,init_ret
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Ending_objinit	PHB
		PHK
		PLB
		jsr	Set_SEQregister
;- - - - 
		ldx	#440h-2		; OAM buffer clear
loop$		lda	#0e0e0h
		sta	!200h,x
		dex
		dex
		bpl	loop$
		ldx	#20h-2
loop2$		stz	!400h,x
		stz	!620h,x
		dex
		dex
		bpl	loop2$
;- - - - 
		ldx	#200h-2		
clp$		stz	!1a00h,x	; <- GfBOpobt@
		dex
		dex
		bpl	clp$
;- - - - 
		ldx	#Init_object	; pointer
		jsl	>Call_bank0
		jsr	Scene		; object set initial
		ldx	#Init_shadow	; shadow set initial
		jsl	>Call_bank0

		lda	#0ffffh
		sta	!doppler_dist
;- - - - - - - - - - - - - - - - - - - - - - - -
		plb
		rtl
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Battle_objinit
Free_objinit
OBJ_initial	
;- - - - - - - - - - - - - - - - - - - - - - - - 
		PHB
		PHK
		PLB
		jsr	Set_SEQregister
		lda	<SEQ_register
		ldx	#initial_select	
		jsr	init_select
		plb
		rtl
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
initial_select	dw	init_GP		; 0
		dw	init_GP_1	; 2
		dw	init_GP_2	; 4
		dw	init_VS		; 6
		dw	init_TM_1	; 8
		dw	init_TM_2	; a
		dw	init_BT		; c
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
init_GP		dw	open_init,replay_clear
		dw	Set_overflag,common_init,init_ret
init_GP_1	dw	open_init,replay_clear
		dw	Init_mapmode,common_init,init_ret
init_GP_2	dw	open_init,replay_clear
		dw	Init_mapmode,common_init,init_ret
init_VS		dw	open_init,replay_clear
		dw	Clear_rank,common_init,init_ret
init_TM_1	dw	open_init,replay_init
		dw	Init_mapmode,common_init,init_ret
init_TM_2	dw	open_init,replay_clear
		dw	Init_mapmode,common_init,init_ret
init_BT		dw	open_init,replay_clear
		dw	Set_battlekart,Init_BTmode
		dw	Init_question
		dw	common_init,init_ret
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
;#####################################################################
;		UTILITY
;#####################################################################
;
;*********************************************************************
;		vC[h̃CjV
;*********************************************************************
replay_clear	stz	!replay_flag	; REPLAY s
		stz	!record_mode	; ^s I
;
		lda	#0		; ^\ ?
		sta	!record_mode
;
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - 
replay_init	

		lda	#1
		sta	!goal_kabe

;- - - - - - - - - - - - - - - - - - - - - - - - - 
;	 f[^A
;- - - - - - - - - - - - - - - - - - - - - - - - - 
	;	ldx	#8000h 
	;	ldy	#keycode_start+0600h
	;	lda	#600h-1
	;	phb
	;	mvn	#7fh,#keycode_start/65536
	;	plb
;- - - - - - - - - - - - - - - - - - - - - - - - - 
;	Đ[h
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		lda	#02h			; S[C bit clear
		trb	!replay_flag

		lda	!replay_flag
		and	#(4000h^0ffffh)		; Đ SEQ OFF
		bpl	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - 
;	Đ[h
;- - - - - - - - - - - - - - - - - - - - - - - - - 
		ora	#4001h
		sta	!replay_flag
		ldx	#2			; 2 = Đ[h
		stx	!record_mode
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - 
;	^惂[h
;- - - - - - - - - - - - - - - - - - - - - - - - - 
exit$		ora	#0001h			; OK bit  Zbg
		sta	!replay_flag
		ldx	#1			; 1 = ^[h
		stx	!record_mode
		rts



;*********************************************************************
;		V[PXWX^̃Zbg
;*********************************************************************
;Q[pWX^
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_SEQregister	SEP	#00110000B
		MEM8
		IDX8
		LDA	<game_mode
		ASL	A
		ASL	A
		ORA	<game_status
		LSR	A
		TAX
		LDA	!SEQ_data,X
		STA	<SEQ_register+0	;V[PXWX^̃Zbg
		STZ	<SEQ_register+1
		REP	#00110000B
		MEM16
		IDX16
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;		       =GP==VS==TM==BT==
SEQ_data	DB	00h,06h,00h,0ch		; 2p
		DB	02h,00h,08h,00h		; 1p up screen
		DB	04h,00h,0ah,00h		; 2p down screen
;*********************************************************************
;		[Nq`l̃NA
;*********************************************************************
open_init	
		lda	#0
		sta	>record_work+0	;(param)
		sta	>record_work+2
		ldx	#Clear_sprite	;(param)
		jsl	>Call_bank0
		ldx	#Clear_buffer	;(param)
		jsl	>Call_bank0
		jmp	Init_work	;(param)
;*********************************************************************
;		ʂ̃CjV
;*********************************************************************
common_init
;- - - - - - - - - - - - - - - - - - - - - - - -
		ldx	#Init_object	;(param)
		jsl	>Call_bank0
;- - - - - - - - - - - - - - - - - - - - - - - -
		jsr	Scene		;(param)
;- - - - - - - - - - - - - - - - - - - - - - - -
		ldx	#Init_item	;(param)
		jsl	>Call_bank0
;- - - - - - - - - - - - - - - - - - - - - - - -
		jsl	>Init_reclap	
		jsl	>Init_net	;(XXXXX)
		jsl	>Init_jugem	;(param)
		ldx	#Init_shadow	;(param)
		jsl	>Call_bank0
		jsr	Init_goalin	;(param)
		jsr	Init_camera	;(param)
		jsr	Init_meter	;(param,VRAM)
		jsr	Set_VRAMextra	;(VRAM)
		jsr	Init_demoword
;- - - - - - - - - - - - - - - - - - - - - - - -
		lda	#0
		sta	>kabe_SP
		lda	#0ffffh
		sta	!doppler_dist
;- - - - - - - - - - - - - - - - - - - - - - - -
		ldx	<game_mode
		lda	!SE_index_A,x
		sta	!screen_sound_A+0
		lda	!SE_index_B,x
		sta	!screen_sound_B+0
		SEP	#00100000B
		MEM8
		lda	#BANK	SE_trigger_1
		sta	!screen_sound_A+2
		sta	!screen_sound_B+2
		REP	#00100000B
		MEM16

		lda	#0ah
		sta	!GP_limitter
		ldx	<game_status
		lda	!md_select,x
		sta	!mode_distance

;- - - - - - - - - - - - - - - - - - - - - - - -	
		rts


;- - - - - - - - - - - - - - - - - - - - - -
SE_index_A	dw	SE_trigger_1	; 1P
		dw	SE_trigger_1	; 1P ONLY	
		dw	SE_trigger_2	; 2P ONLY
SE_index_B	dw	SE_trigger_2	; 2P
		dw	SE_trigger_1	; 1P ONLY
		dw	SE_trigger_2	; 2P ONLY
;- - - - - - - - - - - - - - - - - - - - - -
md_select	dw	200h
		dw	200h
		dw	200h
		dw	400h
;*********************************************************************
;		ogpJ[gZbg
;*********************************************************************
Set_battlekart	ldx	#rank_index
		lda	#1100h
		sta	<0,x
		lda	#1000h
		sta	<2,x
		stz	<4,x
		rts
;*********************************************************************
;		urpʂ̃CjV
;*********************************************************************
Clear_rank	rts
;*********************************************************************
;		}bv[hX^[g
;*********************************************************************
Init_mapmode	lda	#06
		sta	!camera_mode_stock
		rts
;*********************************************************************
;		Q[I[o[ǂ̃`GbN
;*********************************************************************
;Q[I[o[Ȃ΃tOĂ
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_overflag
		ldx	#2
loop$		lda	!player_count+0,x
		bne	skip$
		lda	#8000h
		sta	!erase_kart+0,x
skip$		dex
		dex
		bpl	loop$
		rts
;*********************************************************************
;	ZbgobNAbvp[^CjV
;*********************************************************************
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
kart_Z		DW	0	; D000H	kart Z position
limit_number	DW	1FH	; D002H limit obj count  
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		GLB	Init_powerON
;- - - - - - - - - - - - - - - - - - - - -
Init_powerON	ldx	#1f00h		; power ON work clear
		stz	<0,x
		txy
		iny
		lda	#02ch-2
		phb
		mvn	#00h,#00h
		plb
;- - - - - - - - - - - - - - - - - - - - -
		lda	#00e0h		; power ON work set
		sta	!hit_distance
;- - - - - - - - - - - - - - - - - - - - -
		JSL	>First_debug	
;- - - - - - - - - - - - - - - - - - - - -
		RTL
;*********************************************************************
;	naiRg[p[^CjV
;*********************************************************************
Init_work
		STZ	<screen_register	; 0 page
		STZ	<screen_oam
		STZ	<screen_sub
		STZ	<screen_obj_V
		STZ	!screenA_official
		STZ	!screenB_official
;- - - - - - - - - - - - - - - - - - - - - 
		LDX	<SEQ_register
		LDA	!gp_select,x
		STA	!oam_vector
		LDA	#no_process
		STA	!nmi_vector
;- - - - - - - - - - - - - - - - - - - - - 
		LDA	!limit_number
		STA	!obj_limit
		RTS
;- - - - - - - - - - - - - - - - - - - - - 
gp_select	dw	race_1p2p
		dw	race_1p
		dw	race_2p
		dw	VS_rase
		dw	time_1p
		dw	time_2p
		dw	battle_game
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

		EXTEND
objdata	SECT	REL
		mem16
		idx16
;######################################################################
;######		naiC					#######
;######################################################################
;MAIN - - - 
;*********************************************************************
;	naiZbgC[`
;*********************************************************************
start_sprite	EQU	080H
next_sprite	EQU	100H
entry_sprite	EQU	start_sprite+200H
Ascreen_oam	EQU	000H
Bscreen_oam	EQU	220H
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Ascreen_OAM	EQU	200H
Bscreen_OAM	EQU	Ascreen_OAM+220H
;---------------------------------------------------------------------
OBJ_setB	PHB
		PHK
		PLB
		jsr	Frame_param		; parameter set
		jsr	PPU_check		; debug
		lda	!ending_flag
		bpl	skip$
		jsr	ENDING_B
		bra	exit$
skip$		ldx	<SEQ_register
		jsr	(!setB_select,X)
exit$		plb
		rtl
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
OBJ_setA	PHB
		PHK
		PLB

		lda	!overflow_check
		beq	entry$		

loop$		dec	a
		bne	loop$

entry$		jsr	PPU_check		; debug
		lda	!ending_flag
		bpl	skip$
		jsr	ENDING_A
		bra	exit$
skip$		ldx	<SEQ_register
		jsr	(!setA_select,X)
		jsl	>Main_debug		; debug
exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		stz	!state_control		; state chenge
		ldx	!oam_vector
		jsr	state_check
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		PLB
		RTL
;---------------------------------------------------------------------
setB_select	dw	B_GP		; 0
		dw	B_GP_1		; 2
		dw	B_GP_2		; 4
		dw	B_VS		; 6
		dw	B_TM_1		; 8
		dw	B_TM_2		; a
		dw	B_BT		; c
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
setA_select	dw	A_GP		; 0
		dw	A_GP_1		; 2
		dw	A_GP_2		; 4
		dw	A_VS		; 6
		dw	A_TM_1		; 8
		dw	A_TM_2		; a
		dw	A_BT		; c
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;GfBO A screen
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ENDING_A
		LDA	#ending_nmi		; << NMIset >>
		STA	!nmi_vector
		lda	!ending_pattern
		and	#010b
		bne	nameset$

		JSR	param_screenA		; parameter

;- - - - - - - - - - - - - - - - - - - - - - - -
; GfBOp̃J[h
		JSL	>Ending_camera	
	;	jsl	>TV_camera		; su
	;	lda	#8000h
	;	sta	!camera_FG+0
	;	stz	!TV_wait+2
	;	stz	!TV_no+2
	;	stz	!camera_FG+2
;- - - - - - - - - - - - - - - - - - - - - - - -
;
		JSR	sort_A_entry		; SORT
		JSR	Set_objcount
		LDX	!oam_vector		; oam set
		JSR	end_oamset_A		; << Aset >>
		JSR	clear_spbuff		; clear V position
		LDX	!oam_vector
		JSR	(!_objhit,X)		; << Hitcheck >>

nameset$
		ldx	#BGcheck_kart
		jsl	>Call_bank0		; <<<<< CONTROL check >>>>>
		JSL	>Set_BGmove		; <<<<< BGmove >>>>>
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;GfBO B screen
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		ext	Ending_camera,TV_camera
ENDING_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	!ending_pattern
		and	#0fh
		tax
		lda	!ending_player,x
		sta	<camera_index+0
		sta	<camera_index+2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	!ending_pattern
		and	#010b
		beq	nameset$
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		JSR	param_screenB		; parameter
;
;- - - - - - - - - - - - - - - - - - - -
; GfBOp̃J[h
		JSL	>Ending_camera
	;	JSL	>TV_camera
	;	lda	#8000h
	;	sta	!camera_FG+2
	;	STZ	!TV_wait+0
	;	STZ	!TV_no+0
	;	stz	!camera_FG+0
;- - - - - - - - - - - - - - - - - - - -
;
	 	JSR	sort_B_entry		; SORT
		JSR	Set_objcount		; sprite count initial
		JSR	end_oamset_B		; OAM SET
		JMP	clear_spbuff		; clear V position
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
nameset$
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ending_player	dw	1400h	; C[W
		dw	1600h	; s[`
		dw	1500h	; bV[
		dw	1200h	; Nbp
		dw	1700h	; hL[RO
		dw	1100h	; J
		dw	1300h	; LmsI
		dw	1000h	; }I

;*********************************************************************
;	aXN[ZbgvZX
;*********************************************************************
		ext	Erase_sprite
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;^CA^bNPo
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
B_TM_1		jsl	>Debug_replay
;
;- - - - - - - - - - - - - - - - - - -
; S[XgG[`FbN[`
;- - - - - - - - - - - - - - - - - - -
		lda	!g_kart_flag		; S[XgJ[g͂邩H
		bpl	skip1000$		;
		ldx	#player_r1		;

		lda	!104h
		bne	skipXXX$
		lda	<frame_counter
		cmp	#4
		bcs	skipXXX$

		lda	!_posV_B+player_r0
		dec	a
		sta	!_posV_B+player_r1		

skipXXX$
		lda	!goal_flag
		and	#0fh
		cmp	#2
		beq	skip1000$

		lda	<_flag,x	
		and	#ON_goal		; S[C
		bne	skip1000$		; ܂H
		lda	!pause_entry		; |[YH
		bne	skip1000$
		lda	<_BGcheck_flag,x	; BG ɂH
		bmi	skip9999$
		lda	<event_index,x		; 肵H
		cmp	#4
		bcc	skip1000$

skip9999$	
		stz	<_flag,x		; S[XgG[
		jsl	>Erase_sprite		; S[XgG[
		stz	!g_kart_flag		; ek`f@
		stz	!ghost_flag		; q`l@

;- - - - - - - - - - - - - - - - - - - - - - - - -
;
skip1000$	lda	#5			;
		sta	!_obake_timer+player_r1	; 
		sta	!_obake_timer+player_r2 ;
;
;- - - - - - - - - - - - - - - - - - - - - 
	if	0
		lda	!rom_checker		; fobO
		beq	skip$
		SEP	#00100000B
		MEM8
		lda	!_lap+player_r0+1
		cmp	#7fh
		bne	skip0$
		lda	#83h
		sta	!_lap+player_r0+1
skip0$		lda	!_lap+player_r1+1
		cmp	#7fh
		bne	skip$
		lda	#83h
		sta	!_lap+player_r1+1
	endif
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
skip$		REP	#00100000B
		MEM16
		jsr	B_common
		jsr	Set_mapobj_sub		
		jmp	Check_backmirror
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;foPo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
B_GP_1
		jsr	B_common
		jsr	Set_mapobj_sub
		jmp	Check_backmirror
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;^CA^bNQo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
B_TM_2		
		jmp	B_common
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;og
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
B_BT		jsr	B_common
		jmp	Set_BTmode_B
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;ur
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
B_VS		
		jsr	B_common
		jmp	Set_objmeter
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;foQo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
B_GP_2		
		jsr	B_common
		jsr	Set_danger
		jmp	Set_objmeter		;
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;Ov
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
B_GP		
		jsr	B_common
		lda	!frame_part
		beq	exit$
		jmp	Set_objmeter		;
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
B_common
		jsr	Limit_time		; ^C~bg
		jsr	Main_demoword
		jsl	>Main_net		; objset network

		JSR	param_screenB		; parameter
		JSR	sort_B_entry
		JSR	Set_objcount		; sprite count initial
		LDX	!oam_vector		; oam set
		JSR	(!_Bset,X)		; << Bset >>
		JMP	clear_spbuff		; clear V position
;*********************************************************************
;	`XN[ZbgvZX
;*********************************************************************






;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;og
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_BT
		jsr	A_rasesub_1
		jsr	A_common
		jsr	Set_BTmode_A
		jsr	PPU_check		; debug
		jsr	A_rasesub_2
		rts
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;^CA^bNQo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_TM_2		jsr	A_rasesub_1
		jsr	Set_watch_2p
		jsr	A_common
		jsr	Set_mapobj_sub
		jsr	PPU_check		; debug
		jsr	A_rasesub_2
		jmp	Check_backmirror
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;^CA^bNPo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_TM_1		jsr	A_rasesub_1
		jsr	Set_watch_1p
		jsr	A_common
		jsr	PPU_check		; debug
		jsr	A_rasesub_2
		jmp	Set_objmeter
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;ur
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_VS		JSR	A_rasesub_1
		JSR	Set_watch_VS
		JSR	A_common
		JSR	PPU_check		; debug
		JSR	A_rasesub_2
		JSR	Set_objmeter
		jmp	Calc_rank
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;foQo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_GP_2
		JSR	Main_round
		JSR	A_rasesub_1
		JSR	Set_watch_2p
		JSR	A_common
		jsr	Set_mapobj_sub
		JSR	PPU_check		; debug
		JSR	A_rasesub_2
		JSR	Set_objmeter

		jsl	>Doppler_B		; 

		ldx	#Enemy_fire_B
		jsl	>Call_bank0

		JMP	Check_backmirror
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;foPo
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_GP_1		
		JSR	Main_round
		JSR	A_rasesub_1
		JSR	Set_watch_1p
		JSR	A_common
		JSR	PPU_check		; debug
		JSR	A_rasesub_2
		JSR	Set_objmeter
;
		jsl	>Doppler_A		; 
		jsr	Set_danger
;
		ldx	#Enemy_fire_A
		jsl	>Call_bank0

		RTS
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;Ov
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
watch_select	dw	Set_watch_1p,Set_watch_2p
;- - - - - - - - - - - - - - - - - - - -- - - - - 
A_GP		
		JSR	Main_round
		JSR	A_rasesub_1

		ldx	!frame_part
		jsr	(!watch_select,x)

		JSR	A_common
		JSR	PPU_check		; debug
		JSR	A_rasesub_2

		lda	!frame_part
		bne	skip$
		JSR	Set_objmeter		;



skip$		JSL	>Doppler_GP
		ldx	#Enemy_fire_GP
		jsl	>Call_bank0

		RTS
;--------------------------------------------------------------------
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;===== n`lZbgO =====
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_rasesub_1	
		ldx	#Main_item
		jsl	>Call_bank0
		rts
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;===== n`lZbg =====
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_common	LDX	!oam_vector
		LDA	!_nmi,X			; << NMIset >>
		STA	!nmi_vector
		JSR	param_screenA		; parameter
		JSR	sort_A_entry		;
		JSR	Set_objcount
		LDX	!oam_vector		; oam set
		JSR	(!_Aset,X)		; << Aset >>
		JSR	clear_spbuff		; clear V position
		LDX	!oam_vector
		JMP	(!_objhit,X)		; << Hitcheck >>
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
;===== n`lZbg =====
;- - - - - - - - - - - - - - - - - - - -- - - - - - - - - - - - -
A_rasesub_2	
		JSL	>Set_BGmove		; <<<<< BGmove >>>>>
		JSL	>Set_my_item		; <<<<< myitem set >>>>>
		ldx	#OBJmove		; <<<<< ITEMmove >>>>>
		jsl	>Call_bank0
		ldx	#BGcheck_kart
		jsl	>Call_bank0		; <<<<< CONTROL check >>>>>
		rts
;*********************************************************************
;		V[PX`FbN
;*********************************************************************
_Aset	EQU	0
_Bset	EQU	2
_objhit	EQU	4
_nmi	EQU	6
_state	EQU	8
_next	EQU	10
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
test_addr	DW	200h,420h
;---------------------------------------------------------------------
state_check	CLC
loop$		JSR	(!_state,X)
		INX
		INX
		INX
		INX
		BCC	loop$
next$		LDA	!_next-4,X
		STA	!oam_vector
next_state	RTS
;---------------------------------------------------------------------
check_end	PLA				;<< del return
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
check_raON	LDA	!debug_FLAG		; flag ON ?
		AND	#00001000B
		BEQ	next_state
		SEC
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
check_raOFF	LDA	!debug_FLAG		; flag OFF ?
		AND	#00001000B
		BNE	next_state
		SEC
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
check_battle1	lda	!battle_HP+0
		beq	goalin_TG
		bne	next_state
check_battle2	lda	!battle_HP+2
		beq	goalin_TG
		bne	next_state
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
check_goal2	LDA	!_flag+player_r1	; player 2 goalin check
		AND	#ON_goal
		BEQ	next_state
		BNE	goalin_TG
;- - - - - - - - - - - - - - - - - - - - - - -
check_goalVS	lda	!_flag+player_r0
		and	#ON_goal
		beq	next_state
		lda	!rank_index
		cmp	#player_r0
		beq	goalin_TG
		bne	next_state
;- - - - - - - - - - - - - - - - - - - - - - -
check_goal1	LDA	!_flag+player_r0	; player 1 goalin check
		AND	#ON_goal
		BEQ	next_state
goalin_TG	SEC
		INC	!state_control		; initial ON
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;*********************************************************************
;	J[h`FbN
;*********************************************************************
_1pmode		EQU	8000h
_mapmode	EQU	4000h	
_backmode	EQU	0000h
window_nomal	
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
Check_backmirror
		LDX	<screen_register
		LDA	<camera_mode,X
		CMP	#2
		BNE	skip$
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;obN~[[hɃZbg
		txa
		eor	#2
		tay
		ldx	<player_index,y
		lda	<_status,x
		cmp	#08
		bne	skip1$
;- - - - - - - - - - - - - - - - - - - - - - ROɌO
		txa
		clc
		adc	<screen_register
		tax
		lda	#8002h
		sta	<_kart_char_A,x
;- - - - - - - - - - - - - - - - - - - - - - 
skip1$		ldx	<screen_register
		lda	#_1pmode+_backmode	; = 08000h
		sta	!ptn_flip,X		; nai]
		bra	set$
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
;}bv[hɃZbg
skip$		STZ	!ptn_flip,X		; naim[}
		LDA	#_1pmode+_mapmode	; = 0c000h
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
set$		STA	<player_index,X
exit$		RTS
;*********************************************************************
;	}bvnaiTuZbg
;*********************************************************************
Set_mapobj_sub	ldx	<screen_register
		bit	<player_index,x
		bvc	exit$
		lda	!goalmail		;[
		bne	exit$			;ZbgȂI


	if	debug_mode
		lda	!debug_FLAG
		and	#00001000b
		bne	exit$
	endif

		ldy	<screen_oam
		lda	#0aaaah
		sta	!200h+(objstart/10h)+0,y
		sta	!200h+(objstart/10h)+2,y
		sta	!200h+(objstart/10h)+4,y
		sta	!200h+(objstart/10h)+6,y
exit$		rts
;*********************************************************************
;	urpNvZ
;*********************************************************************
Calc_rank	rts
		ldx	!rank_index+0
		lda	<_lap,x
		and	#00ffh
		bne	exit$
		inc	a			; = lda #1
		sta	<rank_number,x
		ldx	!rank_index+2
		inc	a			; = lda #2
		sta	<rank_number,x
exit$		rts
;*********************************************************************
;	t[p[^
;*********************************************************************
Frame_param	LDA	!debug_FLAG
		AND	#0100B
		BEQ	skip$
;- - - - - - - - - - - - - - - - - - - - - - - - 
;SCɃS[fobO
		LDA	<button_trigger+0
		ORA	<button_trigger+2
		AND	#L_button
		BEQ	skip$
		LDA	#8400H
		STA	10c0H
		STA	11c0H
		STA	12c0H
		STA	13c0H
		STA	14c0H
		STA	15c0H
		STA	16C0H
		STA	17c0H
;- - - - - - - - - - - - - - - - - - - - - - - - ; work set - - - - - 
skip$		LDA	<frame_counter		
		AND	#01H
		ASL	A
		STA	!frame_part		; 2frame part mode
;- - - - - - - - - - - - - - - - - - -- - - - - - -
		LDA	!frame_3_repeat
		INC	A
		INC	A
		CMP	#24
		BCC	frame_3_set
		LDA	#0
frame_3_set	STA	!frame_3_repeat		; 3frame part mode
		RTS
;**********************************************************************
;	fobOp[^[ nm^nee
;**********************************************************************
PPU_check	SEP	#00110000B
		MEM8
		IDX8
		BIT	!debug_FLAG
		BPL	exit$
		LDA	#08H
		STA	!PPU_control
		LDX	#10H		; 5*32 cycle
loop$		DEX			; 2 cycle
		BNE	loop$		; 3 cycle
		LDA	#0FH
		STA	!PPU_control
exit$		REP	#00110000B
		MEM16
		IDX16
		RTS
;----------------------------------------------------------------------
;######################################################################
;######		naiZbgV[PXf[^			#######
;######################################################################
		EXT	goalset_A,goalset_B
		EXT	GPwipe_A,GPwipe_B
		EXT	TMwipe_A,TMwipe_B
;*********************************************************************
;		Ov (1p-up)		2
;*********************************************************************
race_1p		dw	oamVS_A,oamrace1p_B,Hit_GP_A,rase_nmi
		dw	check_raON,ramedit_1p
		dw	check_goal1,result_1pGP	
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
result_1pGP	dw	goalset_A,GPwipe_B,Hit_GP_A,goalin_nmi
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ramedit_1p	dw	oamset_A,ramedit_oam,Hit_GP_A,edit_nmi
		dw	check_raOFF,race_1p
		dw	check_goal1,result_1pGP	
		dw	check_end
;= = = = fobOpq`lGfbg = = = = = = 
ramedit_oam	
		jsl	>RAM_editer_B	
		ldx	#Stop_trans
		jsl	>Call_bank0
		rts
;*********************************************************************
;		Ov (1p-down)		4
;*********************************************************************
race_2p		dw	oamVS_A,oamVS_B,Hit_GP_B,rase_nmi
		dw	check_goal2,result_2pGP	
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
result_2pGP	dw	GPwipe_A,goalset_B,Hit_GP_B,goalin_nmi
		dw	check_end
;*********************************************************************
;		2p Ov			0
;*********************************************************************
race_1p2p	dw	oamGP_A,oamGP_B,Hit_check,rase_nmi
		dw	check_raON,ramedit_W
		dw	check_goal1,result_A	; result state
		dw	check_goal2,result_B
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
result_A	dw	goalset_A,oamGP_B,Hit_check,goalin_nmi
		dw	check_goal2,result_AB
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
result_B	dw	oamGP_A,goalset_B,Hit_check,goalin_nmi
		dw	check_goal1,result_AB
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
result_AB	dw	goalset_A,goalset_B,Hit_check,goalin_nmi
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ramedit_W	dw	oamset_A,ramedit_oam,Hit_check,edit_nmi
		dw	check_raOFF,race_1p2p
		dw	check_goal1,result_A	; result state
		dw	check_goal2,result_B   
		dw	check_end
;*********************************************************************
;		ur[X			6
;*********************************************************************
		EXT	VSwin_A,VSwin_B,VSlost_A,VSlost_B
		GLB	VSresult_A,VSresult_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
VS_rase		dw	oamVS_A,oamVS_B,Hit_VS,rase_nmi
		dw	check_goalVS,VSresult_A	; result state
		dw	check_goal2,VSresult_B
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
VSresult_A	dw	VSwin_A,VSlost_B,Hit_out,VSgoalin_nmi
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
VSresult_B	dw	VSlost_A,VSwin_B,Hit_out,VSgoalin_nmi
		dw	check_end
;*********************************************************************
;		og				C
;*********************************************************************
		ext	BTwin_A,BTwin_B
		ext	BTlost_A,BTlost_B
		GLB	BTresult1,BTresult2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
battle_game	dw	oamBT_A,oamBT_B,Hit_battle,battle_nmi
		dw	check_battle1,BTresult1
		dw	check_battle2,BTresult2
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
BTresult1	dw	BTlost_A,BTwin_B,Hit_out,VSgoalin_nmi
		dw	check_end
BTresult2	dw	BTwin_A,BTlost_B,Hit_out,VSgoalin_nmi
		dw	check_end


Hit_out		rts
;*********************************************************************
;		^CA^bN (1p-up)		8
;*********************************************************************
		EXT	TMgoal_A,TMgoal_B
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
time_1p		dw	oamVS_A,oamVS_B,Hit_TM_A,rase_nmi
		dw	check_goal1,TMresult_A
		dw	check_raON,ramedit_TM
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
TMresult_A	dw	TMgoal_A,TMwipe_B,Hit_TM_A,VSgoalin_nmi
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
ramedit_TM	dw	oamVS_A,ramedit_oam,Hit_TM_A,edit_nmi
		dw	check_goal1,TMresult_A
		dw	check_raOFF,time_1p
		dw	check_end
;*********************************************************************
;		^CA^bN (1p-down)	A
;*********************************************************************
time_2p		dw	oamVS_A,oamVS_B,Hit_TM_B,rase_nmi
		dw	check_goal2,TMresult_B
		dw	check_end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
TMresult_B	dw	TMwipe_A,TMgoal_B,Hit_TM_B,VSgoalin_nmi
		dw	check_end
;----------------------------------------------------------------------
		ext	Hit_check
		ext	Hit_GP_A,Hit_GP_B
		ext	Hit_TM_A,Hit_TM_B
		ext	Hit_VS
;*********************************************************************
;		Cɂx
;*********************************************************************

Set_danger	lda	<screen_register
		tay
		eor	#2
		tax
		SEP	#00100000B
		MEM8
		lda	!danger_status+0	;obN~[JE^
		beq	exit$
		dec	a
		sta	!danger_status+0
		bne	exit$
		bit	<player_index+1,x	; [h`FbN
		bvs	exit$			; }bv[hȂpX
		lda	!danger_status+1	; ߋ
		bpl	exit$			; obN~[[h
		tyx				; Ȃexit
		lda	#20h
		ora	<camera_control,x
		sta	<camera_control,x
exit$		REP	#00100000B
		MEM16
		rts

;*********************************************************************
;
	ORG	0FFE6H
		word	stop_prog
	ORG	0FFF6H
		word	stop_prog
;
;- - - - - - - - - - - - - - - - - - - 
		END
