;####################################################################
;		map editer
;####################################################################
		INCLUDE	../../SFX/RP5C77
		INCLUDE	../../SFX/RP5A22
		INCLUDE	../../DSP/D77C25
		INCLUDE	../../../kimura/join/work.def
		INCLUDE	../../../kimura/join/buffer.def
		INCLUDE	../DEF/object.def
		include	../DEF/editer.def
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		EXT	Call_bank0,Call_bank1
		EXT	Set_map_number,Set_ROM_to_buffer
		EXT	Color_transport
		EXT	Execute_VRAM,CLEAR_SPRITE
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		GLB	map_init,map_main
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		EXT	Init_PPU
		EXT	OBJ_byte,OBJ_word,OBJ_message
		EXT	Init_mode7,ON_screen,Set_M7register
		EXT	Scroll_cursor
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
		EXT	Convert_m1m7
		EXT	Set_BG_item
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
cursor_UD	EQU	0
cursor_LR	EQU	1
cursor_BY	EQU	2
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

;*********************************************************************
;		WORK RAM
;*********************************************************************
backup_point	equ	085c800h
;- - - - - - - - - - - - - - - - - -
point_buffer	equ	1a00H
;
write_addr	equ	1c10h
write_char	equ	1c12h
now_addr	equ	1c14h
data_number	equ	1c16h
center_0	equ	1c18h
center_1	equ	1c1ah
center_2	equ	1c1ch
center_3	equ	1c1eh
;- - - - - - - - - - - - - - - - - - - - - - - - - - -

_point_flag	equ	0
_point_addr	equ	2
;
		EXTEND
editer		SECT	REL
		mem16
		idx16
;*********************************************************************
;		map initialize
;*********************************************************************

map_data	dw	16h,17h,14h,15h

map_init	jsr	Init_PPU
		jsr	DISABLE_NMI
;- - - - - - - - - - - - - - - - - - - - - - ݂̃}bvobt@Zbg

		lda	!world_number
		cmp	#4
		bne	skip$

		lda	!map_pointer
		and	#03h
		asl	a
		tay
		lda	!map_data,y		
		sta	!map_number
		bra	skip2$

skip$		ldx	#Set_map_number	
		jsl	>Call_bank1
skip2$



		ldx	#Set_ROM_to_buffer
		jsl	>Call_bank1
;- - - - - - - - - - - - - - - - - - - - - -
		jsl	>Set_BG_item
;- - - - - - - - - - - - - - - - - - - - - -
	;;	ldx	#MOJI_buffer
	;;	ldy	#0c000h		
	;;	lda	#00c10h
	;;	jsl	>Convert_m1m7
;
		ldx	#MOJI_buffer
		ldy	#0c400h		
		lda	#00c10h		; f10h
		jsl	>Convert_m1m7
;- - - - - - - - - - - - - - - - - - - - - - ݂̃}bvuq`lZbg
		ldx	#Color_transport
		jsl	>Call_bank0
		ldx	#mode7_char
		jsl	>Execute_VRAM
		ldx	#mode7_screen
		jsl	>Execute_VRAM
		ldx	#mode7_char2
		jsl	>Execute_VRAM
;- - - - - - - - - - - - - - - - - - - - - -GaB^[CjV
		jsr	Init_point
;
		stz	<process_no
		jsr	Init_PPU
		jsr	Init_mode7
		lda	#80h
		sta	!cy_offset
;- - - - - - - - - - - - -  - - - - - - - - -
		jsr	ENABLE_NMI
		jsr	ON_screen
		db	11H

		lda	#04e0h
		sta	!rotation_a
		sta	!rotation_d
		lda	#0208h
		sta	!rotation_x
		lda	#0250h
		sta	!rotation_y

		rts
;--------------------------------------------------------------------
mode7_char	db	80h		; high inc
		dw	0000h		; vram start
		dw	1900h		
		dl	7f4000h		; mode 7 character	
		dw	4000h		; data byte count
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mode7_char2	db	80h		; high inc
		dw	3400h		; vram start
		dw	1900h	
		dl	7fc400h		; mode 7 character
		dw	0400h		; data byte count
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
mode7_screen	db	00h		; low inc
		dw	0000h
		dw	1800h		
		dl	7f0000h		; mode 7 character	
		dw	4000h		; data byte count
;*********************************************************************
;		map initialize
;*********************************************************************
map_main	
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		jsl	>CLEAR_SPRITE		; nmi sprite clear
		jsr	NMI_point		; nmi
		jsr	Set_M7register		; nmi
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;;	jsr	test_rotate
		jsr	Check_reset
;- - - - - - - - - - - - - - - - - - - - - - - - - - +
		lda	<button_status+0	;DB  |
		and	#X_button		;DB  |
		beq	skip$			;DB  |
		jsr	SMORKE_PPU		;DB  |
;- - - - - - - - - - - - - - - - - - - - - - - - - - +
skip$		lda	#200h
		sta	<sprite_count
		lda	<process_no
		asl	a
		tax
		jsr	(!process_select,x)
	;	jsr	test_display
;- - - - - - - - - - - - - - - - - - - - - - - - - - +
		lda	<button_status+0	;DB  |
		and	#X_button		;DB  |
		beq	exit$			;DB  |
		jsr	ON_PPU			;DB  |
;- - - - - - - - - - - - - - - - - - - - - - - - - - +
exit$		rts
;--------------------------------------------------------------------
process_select	dw	point_edit
		dw	save_load

;####################################################################
;		]
;####################################################################
		EXT	Rotate_mode7
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
test_rotate

		bit	!button_status
		bvs	skip_1$
		bit	!repeat_trigger+0
		bpl	skip$

skip_1$		LDA	!1d12h
		AND	#0ff00h
		CLC
		ADC	#00100h
		STA	!1d12h

skip$
		LDA	#0100H
		LDY	!1d12h
		LDX	#rotation_a
		JSL	>Rotate_mode7
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
test_display	LDY	#7030H		; display world address x,y
		LDA	!1d12h
		JSR	OBJ_word
		LDY	#8030H
		LDA	!rotation_a
		jsr	OBJ_word
		LDY	#8830H
		LDA	!rotation_b
		jsr	OBJ_word
		LDY	#9030H
		LDA	!rotation_c
		jsr	OBJ_word
		LDY	#9830H
		LDA	!rotation_d
		jmp	OBJ_word
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

;####################################################################
;		|CgGfBg[h
;####################################################################
point_edit
;- - - - - - - - - - - - - - - - - - - - - - - - 
		lda	<button_trigger+0
		and	#SL_button
		beq	entry$
		inc	<process_no
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
entry$
;t[̃J[\ʒu
		LDX	#rotation_x	
		LDY	#scroll_bar_x
		JSR	Scroll_cursor
		LDX	#rotation_y
		LDY	#scroll_bar_y
		JSR	Scroll_cursor
;- - - - - - - - - - - - - - - - - - - - - - - - 
		jsr	Calc_now_number
		jsr	Calc_now_addr
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
	;	jsr	Set_point	; |CgWZbg
					; BepfobO[h
	;;;;	jsr	Set_center



		jsr	Zoom_screen	; BepfobO[h
		rts			; BepfobO[h
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;XvCg̕\
;- - - - - - - - - - - - - - - - - - - - - - 
		LDY	#8080H		; display pointer
		LDX	#mes_center_p
		JSR	OBJ_message
;- - - - - - - - - - - - - - - - - - - - - - 
		LDY	#2030H		; display world address x,y
		LDA	!rotation_x
		JSR	OBJ_word
		LDY	#2830H
		LDA	!rotation_y
		JSR	OBJ_word
;- - - - - - - - - - - - - - - - - - - - - - 
		LDY	#2050H		; display character address x,y
		LDA	!rotation_x
		LSR	A
		LSR	A
		LSR	A
		JSR	OBJ_byte
		LDY	#2850H
		LDA	!rotation_y
		LSR	A
		LSR	A
		LSR	A
		JSR	OBJ_byte
;- - - - - - - - - - - - - - - - - - - - - - -
		LDY	#3830H
		LDA	!data_number
		JSR	OBJ_byte
;- - - - - - - - - - - -
	;	LDA	!data_number
	;	ASL	A
	;	TAY
	;	LDX	!dn_message,Y
	;	LDY	#4020H		; display pointer
	;	JSR	OBJ_message
;- - - - - - - - - - - - - - - - - - - - - - -
	;;;;	LDY	#1070H		; display title
	;;;;	LDX	#mes_kart
	;;;;	JSR	OBJ_message
;;
		RTS
;---------------------------------------------------------------------
scroll_bar_x	DB	cursor_LR
		DB	8		; count
		DW	400H,0
scroll_bar_y	DB	cursor_UD
		DB	8		; count
		DW	400H,0
;---------------------------------------------------------------------
mes_center_p	DB	28H,_x,ed
mes_kart	DB	28H,_k,_a,_r,_t,ed
mes_save	DB	28H,_w,ed	; ra,_ii,_to,ed
mes_load	DB	28H,_r,ed	; ri,_ii,_to,ed
;- - - - - - - - - - - - - - - - - - - - - - - - 
;dn_message	dw	message_0
;		dw	message_1,message_1,message_1,message_1
;		dw	message_2,message_2,message_2,message_2
;- - - - - - - - - - - - - - - - - - - - - - - - 
;message_0	db	28h,_ko,_te,_ii,ed
;message_1	db	28h,_ho,_ii,_nn,_to,ed
;message_2	db	28h,_se,_nn,_ta,ed
;*********************************************************************
;		GaB^[Gh `FbN
;*********************************************************************



;*********************************************************************
;		GaB^[Gh `FbN
;*********************************************************************
Check_reset	LDA	<button_status+0	; RESET
		AND	#ST_button+SL_button
		CMP	#ST_button+SL_button
		BNE	exit$
		STZ	<edit_status
exit$		RTS
;*********************************************************************
;		݂̃f[^io[Zbg
;*********************************************************************
Calc_now_number
		ldx	!data_number
		lda	<button_trigger+0
		and	#X_button
		beq	exit$
		inx
		cpx	#8
		bcc	set$
		ldx	#0
set$		stx	!data_number		
exit$		rts
;*********************************************************************
;		݂̈ʒuZbg
;*********************************************************************
Calc_now_addr	lda	!rotation_x
		LSR	A
		LSR	A
		LSR	A
		sta	<0
		lda	!rotation_y
		and	#0fff8h
		ASL	A
		ASL	A
		ASL	A
		ASL	A
		ora	<0
		sta	!now_addr	 ; ݂̈ʒu
		rts
;*********************************************************************
;		Z^[̃Zbg
;*********************************************************************
Set_center
		lda	!write_addr
		bpl	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	<button_trigger+0
		and	#A_button
		beq	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		lda	!data_number
		beq	exit$
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		dec	a
		asl	a
		tay
		lda	!center_0,y
		bmi	set$
		cmp	!now_addr
		bne	exit$
;- - - - - - - - - - - - - - - - - - - 
erase$		tax
		lda	#8000h
		sta	!center_0,y
		jmp	Recover_map
;- - - - - - - - - - - - - - - - - - - 
set$		phy			; >>
		jsr	Same_check2
		ply			; <<
		bcs	exit$
		lda	!now_addr
		sta	!center_0,y
		sta	!write_addr
		lda	!center_char,y
		sta	!write_char
;- - - - - - - - - - - - - - - - - - - 
exit$		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
center_char	dw	0c1h,0c2h,0c3h,0c4h
;*********************************************************************
;		|Cg̃Zbg
;*********************************************************************
wc_select	db	0d0h,0d1h,0d2h,0d3h,0d4h
		db	0d5h,0d6h,0d7h,0d8h,0d9h
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_point
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		ldx	#point_buffer
		lda	<button_trigger+0
		and	#B_button+Y_button
		beq	exit$
		and	#Y_button
		bne	clear$
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		jsr	Same_check2		;H
		bcs	exit$			; yes.
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
		jsr	Free_check		;JĂH
		bcc	exit$			; no.
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
skip$		lda	!now_addr		;Wf[^Zbg
		sta	<_point_addr,x
		sta	!write_addr
		ldy	!data_number
		tya
		ora	#8000h
		sta	<_point_flag,x
		lda	!wc_select,y	; write character select
		and	#00ffh
		sta	!write_char
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
clear$		jsr	Same_check		;H
		bcs	erase$			; yes.
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - -
						;Wf[^NA
erase$		stz	<_point_flag,x		; flag OFF
		sty	!write_addr
		tyx
		SEP	#00100000B
		MEM8
		lda	>7f0000h,x
		sta	!write_char
		REP	#00100000B
		MEM16
exit$		rts
;*********************************************************************
;		Nm f[^obt@̃Zbg
;*********************************************************************
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
Init_point	phb
		lda	#8000h
		sta	!write_addr
;
		sta	!center_0
		sta	!center_1
		sta	!center_2
		sta	!center_3
;
		stz	!point_buffer
		ldx	#point_buffer	
		txy
		iny
		lda	#200h-2
		mvn	#00h,#00h		; 32 point check
		plb
		rts
;- - - - - - - - - - - - - - - - - - - - 
NMI_point	lda	!write_addr
		bmi	exit$
		stz	!Screen_step
		sta	!Screen_address
		lda	#8000h
		sta	!write_addr
		SEP	#00100000B
		MEM8
		lda	!write_char
		sta	!Screen_write
		REP	#00100000B
		MEM16
exit$		rts

;####################################################################
;		Z[uA[h
;####################################################################
save_load		
;- - - - - - - - - - - - - - - - - - - - - - 
		LDA	<button_trigger+0
		AND	#SL_button
		BEQ	entry$
		STZ	<process_no
		RTS
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
entry$		lda	<button_status+0
		bit	#L_button
		bne	save$
		bit	#R_button
		beq	exit$
;- - - - - - - - - - - - - - - - - - - - - - 
load$		JSR	Load_message
		lda	<button_trigger+0
		and	#B_button
		beq	exit$
		jsr	Set_loaddata
		RTS
;- - - - - - - - - - - - - - - - - - - - - - 
save$		JSR	Save_message
		lda	<button_trigger+0
		and	#B_button
		beq	exit$
		jsr	ON_message
		jsr	Set_savedata
exit$		RTS
;- - - - - - - - - - - - - - - - - - - - - - 
Load_message	LDX	#mes_load
		BRA	skip_1000
Save_message	LDX	 #mes_save
skip_1000	LDY	#8080H		; display pointer
		JMP	OBJ_message
ON_message	LDX	#mes_on
		LDY	#80A0H
		JMP	OBJ_message		
mes_on		DB	28h,_oo,_nn,ed
;- - - - - - - - - - - - - - - - - - - - - - 
;*********************************************************************
;		}bṽ|CgZbg
;*********************************************************************
; 1}bv 40h byte
;- - - - - - - - - - - - - - - - - -
set_mappoint	lda	!map_number
		xba
		lsr	a
		lsr	a
		clc
		adc	#backup_point&0ffffh
		sta	<0
;- - - - - - - - - - - - - - - - - -
		lda	#backup_point/65536
		sta	<2
;- - - - - - - - - - - - - - - - - -
		ldx	#point_buffer
		ldy	#0
		rts
;*********************************************************************
;		f[^̃obt@[h
;*********************************************************************
;		equ	0
flag_number	equ	4
char_number	equ	6
data_counter	equ	8
status_check	equ	10
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Set_loaddata
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; load initial
		jsr	Init_point	; buffer clear
;
		jsr	BRANKING_PPU
		jsr	DISABLE_NMI
		ldx	#mode7_screen
		jsl	>Execute_VRAM
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;|Cgf[^̏
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		jsr	set_mappoint
		SEP	#00100000B
		MEM8
		stz	!Screen_step
		REP	#00100000B
		MEM16
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - -
		ldy	#p1_start
		lda	#08001h		; point 1
		sta	<flag_number
		lda	#4		; data 8byte 
		jsr	VRAM_point
;- - - - - - - - - - - - - - - - - - - -
		ldy	#p2_start
		lda	#08002h		; point 2
		sta	<flag_number
		lda	#4		; data 8byte 
		jsr	VRAM_point
;- - - - - - - - - - - - - - - - - - - -
		ldy	#p3_start
		lda	#08003h		; point 3
		sta	<flag_number
		lda	#4		; data 8byte 
		jsr	VRAM_point
;- - - - - - - - - - - - - - - - - - - -
		ldy	#p4_start
		lda	#08004h		; point 4
		sta	<flag_number
		lda	#4		; data 8byte 
		jsr	VRAM_point
;- - - - - - - - - - - - - - - - - - - -
		ldy	#item_start
		lda	#08005h		; point 4
		sta	<flag_number
		lda	#8		; data 8byte 
		jsr	VRAM_point
;- - - - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
exit$		jsr	ENABLE_NMI
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
VRAM_point	sta	<data_counter
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
loop$	
;- - - - - - - - - - - - - - - - - - - - -
		lda	[<0],y
		beq	exit$
		sta	<status_check		; ʂQrbgۑ
		and	#03fffh			; ʂQrbg
		sta	!Screen_address+0
		sta	<_point_addr+0,x	; <- set buffer	
		iny
		iny
;- - - - - - - - - - - - - - - - - - - - -
		lda	<flag_number	
		cmp	#8005h
		bcc	skip$
;- - - - - - - - - - - - - - - - - - - - -
		bit	<status_check		; J^oii
		bpl	skip_1$
		inc	a			; oii	
		inc	a
		bra	skip$
skip_1$		bvc	skip$			; K
		inc	a			; cK
;- - - - - - - - - - - - - - - - - - - - -
skip$		sta	<_point_flag,x
;- - - - - - - - - - - - - - - - - - - - -
		SEP	#00100001B
		MEM8
		adc	#0d0h-1		; SEC
		sta	!Screen_write+0
		REP	#00100001B
		MEM16			
;- - - - - - - - - - - - - - - - - - - - -
		txa				;|C^ inc
		adc	#8		: CLC
		tax
		dec	<data_counter
		bne	loop$
;- - - - - - - - - - - - - - - - - - - - -
exit$		rts
;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
VRAM_center	SEP	#00010000B
		IDX8
		lda	[<0],y
		bmi	exit$
		sta	!center_0,x
		sta	!Screen_address
		ldy	!center_char,x
		sty	!Screen_write	
exit$		REP	#00010000B
		IDX16
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - 
;*********************************************************************
;		f[^̃obt@Z[u
;*********************************************************************
;	[NGA
;- - - - - - - - - - - - - - - - - -
;;;		equ	0		; buffer address
point_register	equ	4
p1_pointer	equ	6		;Q̃|C^
p2_pointer	equ	8
p3_pointer	equ	10
p4_pointer	equ	12
item_pointer	equ	14
status_bit	equ	16
;- - - - - - - - - - - - - - - - - -
;	Z[uGAgp
;- - - - - - - - - - - - - - - - - -
p1_start	equ	00h
p1_end		equ	08h
p2_start	equ	08h
p2_end		equ	10h
p3_start	equ	10h
p3_end		equ	18h
p4_start	equ	18h
p4_end		equ	20h
item_start	equ	20h
item_end	equ	30h
;- - - - - - - - - - - - - - - - - -
;	vO
;- - - - - - - - - - - - - - - - - -
Set_savedata	jsr	set_mappoint	; X <-	#point_buffer
;- - - - - - - - - - - - - - - - - -
		ldy	#40h-2		;P}bvSOf[^
		lda	#0		;NAf[^
clear_loop	sta	[<0],y
		dey
		dey
		bpl	clear_loop
;- - - - - - - - - - - - - - - - - -
		lda	#p1_start
		sta	<p1_pointer
		lda	#p2_start
		sta	<p2_pointer
		lda	#p3_start
		sta	<p3_pointer
		lda	#p4_start
		sta	<p4_pointer
		lda	#item_start
		sta	<item_pointer
;- - - - - - - - - - - - - - - - - -
;|Cgf[^̃Z[u
;- - - - - - - - - - - - - - - - - -
;- - - - - - - - - - - - - - - - - - - - - - - - - -
loop$		lda	<_point_flag,x
		bpl	skip$
		stx	<point_register
		and	#00ffh
		asl	a
		tax
		stz	<status_bit
		jsr	(!pointsave,x)
		ldx	<point_register
skip$		txa
		clc
		adc	#8
		tax
		cpx	#point_buffer+200h
		bne	loop$
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - -
pointsave	dw	p0_save
		dw	p1_save
		dw	p2_save
		dw	p3_save
		dw	p4_save
		dw	p5_save
		dw	p6_save
		dw	p7_save
;- - - - - - - - - - - - - - - - - -
p0_save		rts
;- - - - - - - - - - - - - - - - - -
p1_save		ldy	<p1_pointer
		cpy	#p1_end
		beq	save_exit
		jsr	save_point
		sty	<p1_pointer
		rts
;- - - - - - - - - - - - - - - - - -
p2_save		ldy	<p2_pointer
		cpy	#p2_end
		beq	save_exit
		jsr	save_point
		sty	<p2_pointer
		rts
;- - - - - - - - - - - - - - - - - -
p3_save		ldy	<p3_pointer
		cpy	#p3_end
		beq	save_exit
		jsr	save_point
		sty	<p3_pointer
		rts
;- - - - - - - - - - - - - - - - - -
p4_save		ldy	<p4_pointer
		cpy	#p4_end
		beq	save_exit
		jsr	save_point
		sty	<p4_pointer
		rts
;- - - - - - - - - - - - - - - - - -
p7_save		lda	#8000h			; oii
		bra	item_save
p6_save		lda	#4000h			; Jc
		bra	item_save
item_save	sta	<status_bit
p5_save						; J
		ldy	<item_pointer
		cpy	#item_end
		beq	save_exit
		jsr	save_point
		sty	<item_pointer
save_exit	rts
;- - - - - - - - - - - - - - - - - -
save_point	ldx	<point_register
		lda	<_point_addr,x
		ora	<status_bit		;]rbg
		sta	[<0],y
		iny
		iny
		rts
;- - - - - - - - - - - - - - - - - -

;#####################################################################
;		ėp[`
;#####################################################################
;*********************************************************************
;		WX^
;*********************************************************************
ENABLE_NMI	SEP	#00100000B
		MEM8				
		lda	#81h
		bra	set_nmiregister
;- - - - - - - - - - - - - - - - - - - - - - - -
DISABLE_NMI	SEP	#00100000B
		MEM8
		lda	#0
set_nmiregister	sta	!NMI_control
		REP	#00100000B
		MEM16
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
SMORKE_PPU	SEP	#00100000B
		MEM8
		lda	#0ah
		bra	set_ppuregister
ON_PPU		SEP	#00100000B
		MEM8
		lda	#0fh
		bra	set_ppuregister
BRANKING_PPU	SEP	#00100000B
		MEM8
		lda	#80h
set_ppuregister	sta	!PPU_control
		REP	#00100000B
		MEM16
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
;*********************************************************************
;		W̏dȂ`FbN
;*********************************************************************
;	output	sec....W
;		ix.....Ŵindex
;		iy.....݂̍W
;- - - - - - - - - - - - - - - - - - - - - - - - 
Same_check2	jsr	Same_check
		bcs	flag_on$
;- - - - - - - - - - - - - - - - - - - - - - - - 
		cpy	!center_0
		beq	flag_on$
		cpy	!center_1
		beq	flag_on$
		cpy	!center_2
		beq	flag_on$
		cpy	!center_3
		beq	flag_on$
		clc
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
flag_on$	sec
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - 
Same_check	ldx	#point_buffer
		ldy	!now_addr
loop$		lda	<_point_flag,x
		bpl	skip$
		tya
		cmp	<_point_addr,x
		beq	flag_on$
skip$		txa
		clc
		adc	#8
		tax
		cpx	#point_buffer+200h
		bne	loop$
flag_off$	
;- - - - - - - - - - - - - - - - - - - - -
		clc
		rts
flag_on$	sec
		rts
;*********************************************************************
;		JĂ郏[NT
;*********************************************************************
;	output	sec....󂫍W
;		ix.....󂫍Ŵindex
;- - - - - - - - - - - - - - - - - - - - - - - - 
Free_check	ldx	#point_buffer
loop$		lda	<_point_flag,x
		bpl	flag_on$
		txa
		clc
		adc	#8
		tax
		cpx	#point_buffer+200h
		bne	loop$
flag_off$	clc
		rts
flag_on$	sec
		rts
;*********************************************************************
;		}bvLɖ߂
;*********************************************************************
;	input	ix.....W	
;- - - - - - - - - - - - - - - - - - - - - - - - 
Recover_map	stx	!write_addr
		SEP	#00100000B
		MEM8
		lda	>7f0000h,x
		sta	!write_char
		REP	#00100000B
		MEM16
		rts
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;*********************************************************************
;		}bvLɖ߂
;*********************************************************************

Zoom_screen

		ldy	#0020h
		lda	<repeat_trigger
		and	#B_button
		beq	skip$
		tya
		bra	set$
skip$		lda	<repeat_trigger
		and	#Y_button
		beq	exit$
		tya
		EOR	#1111111111111111B
		INC	A
set$		adc	!rotation_a
		sta	!rotation_a
		sta	!rotation_d

exit$		rts

		END
