;******************* name.asm *************************
			extend
;-----------------------------------------------------
			include		../join/rp5c77
			include		../join/buffer.def
			include		../join/rp5a22
			include     ../join/work.def
			include		../join/label.def
;-----------------------------------------------------
			glb		W_SL_init,W_SL_main,W_SL_nmi
			glb		Back_up_set,Backup_Sam_Check
			glb		Back_up_clear,Set_4bit_mode1
;
			ext		Set_DMA,PPU_INT_SET
			ext		KEY_CHECK,Trigger_sound_1
			ext		BGM_fade_out,X_inx,Y_iny
			ext		Set_DMA,Rank_Check_sum
			ext		OBJ_ERASE_SET
;---------------------------------------------------
address			equ		60h			;3byte
Color_set		equ		63h			;2byte
move_counter	equ		65h			;2byte
waku_counter	equ		67h			;2byte
button_TG       equ     6ah         ;4byte
Old_world_number	equ		6eh
Back_address	equ		70h
;
Game_select.flag	equ		85h
erase_set_flag		equ		7bh
;----------------------------------------------------
msbdat			equ		400h
oamdat			equ		200h	
;----------------------------------------------------
back_up_address	equ		3067f2h
Back_up_Sum		equ		3067f0h
Kinoko_Cup		equ		3067f2h
Flower_Cup		equ		3067f3h
Star_Cup		equ		3067f4h
Special_Cup		equ		3067f5h
Back_up_zero	equ		306000h
;
Rank_cmp		equ		19fch
Sum_cmp			equ		19feh
;-----------------------------------------------------
bank85      		sect    rel         ;(PBR=85)
;========================================================
;********************************************************
;				INITIAL ROUTINE
;********************************************************
;========================================================
W_SL_init		equ		$
				phb
				phk
				plb
				mem8
				idx8
				sep		#00110000b
;
				JSL		>PPU_INT_SET			;ppu&oam initial set.
				JSR		WORLD_PPU
				JSR		WORLD_TENSOU
;
				mem16
				idx16
				rep		#00110000b
				plb
				RTL
;========================================================
;********************************************************
;				MAINE ROUNTINE
;********************************************************
;========================================================
W_SL_main		equ		$
				phb
				phk
				plb
;
				JSR     KEY_CHECK
				JSL		>WAKU_MOVE.SET
				JSL		>Cup_change.set
				JSL		>NEXT_SET
;
				plb
				RTL
;========================================================
;********************************************************
;				NMI wari komi.			  
;********************************************************
;========================================================
W_SL_nmi		equ		$
				phb
				phk
				plb
;<<<<<<<<<<<<<< J[C[XZbg >>>>>>>>>>>>>>>>>>
;
				ldy		#0
				lda     Old_world_number
				asl		a
				tax
				JSL		>MOJI_Set_1
;<<<<<<<<<<<<<<<<< J[Zbg >>>>>>>>>>>>>>>>>>>>>>>
				ldy		#0002
				lda     world_number
				asl		a
				tax
				JSL		>MOJI_Set_1
;
				plb
				rtl
;========================================================
;********************************************************
;				INITIAL ROUTINE
;********************************************************
;========================================================
WORLD_TENSOU   	equ		$
;<<<<<<<<<<<<<<< BG_1@bfw>>>>>>>>>>>>>>>>>>>>>>
				mem8
				idx8
				ldx		#24h
				JSR		Set_DMA
;<<<<<<<<<<<<<<< CjV] >>>>>>>>>>>>>>>>>>>>
				JSL		>WORLD_TENSOU_1
				rts
;***********************************************************
;					PPU&WORK INITIAL SET
;***********************************************************
WORLD_PPU		equ		$
;<<<<<<<<<<<<<<< [y[WNA[ >>>>>>>>>>>>>>>>>>
				mem8	
				idx8
;
				lda		world_number
				sta		<Old_world_number
;<<<<<<<<<<<<<<<<<< PPU SET >>>>>>>>>>>>>>>>>>>>>>>>>
				lda		#00000001b
				sta		Screen_size		;BG mode1 set.
;
				lda		#00010001b
				sta		Through_screen		;TM
;
				stz     Sprite_size
;
				lda		#00100100b
				sta		Screen_bank
;
				lda		#00000000b
				sta		Screen_segment
;
				lda     #10000000b
				sta     Screen_step
				rts
;==========================================================
bank84			sect		rel
;==========================================================
;***********************************************************
;					CjVZbg
;***********************************************************
WORLD_TENSOU_1	equ		$
				phb
				phk
				plb
;<<<<<<<<<<<<<<<<<<<<<< CG_SET >>>>>>>>>>>>>>>>>>>>>>>>>
			 	idx16		        		;8bit mode.
			 	rep		#00010000b
;
			 	lda		#00000000b			
				sta		Color_address
;
      		 	ldx		#0
loop_col	 	lda		>W_select_col,x
			 	sta		Color_write
			 	inx
        	 	lda     >W_select_col,x
			 	sta     Color_write
			 	inx
			 	cpx		#200h
			 	bne		loop_col
;<<<<<<<<<<<<<<<<<< SC_1 >>>>>>>>>>>>>>>>>>>>>>>>>
				mem16
       			idx16
				rep		#00110000b
;<<<<<<<<<<<<<< 4 BIT f[^[ɕϊ >>>>>>>>>>>>>>
				lda     #00000000b				;address set.
				sta     Screen_address
				ldx		#0
				JSR		Set_4bit_mode
;
;<<<<<< TO̎XyVǂ̃`FbN >>>>>
				lda		game_level
				bne		Check_adlut				;100ccNX?;yes-->Set_msb
				lda		world_number
				cmp		#0003
				bne		Moji_set
				stz		world_number
				stz		<Old_world_number
				jmp		Moji_set
;<< POO̎ăS[hł͂ȂXyVm >>>>>
Check_adlut		lda		world_number
				cmp		#0003
				bne		Moji_set
;-----(ẴS[hJbv`FbN)----
				lda		>Kinoko_Cup
				and		#0003h
				cmp		#0001
				bne		Reset_world
				lda		>Flower_Cup
				and		#0003h
				cmp		#0001
				bne		Reset_world
				lda		>Star_Cup
				and		#0003h
				cmp		#0001
				bne		Reset_world
				jmp		Moji_set
Reset_world		stz		world_number
				stz		<Old_world_number
;<<<<<<<<<<<<<<< f[^[Zbg >>>>>>>>>>>>>>>>>
Moji_set		ldx		#0
				lda		#2400h
				sta     Screen_address
;
loop_back		lda		>7fef00h,x
				clc
				adc		#01040h
back_set		sta     Screen_write
				inx
				inx
				cpx		#0800h
				bne		loop_back
;
				ldy		#0000
				ldx		#0000					;kinoko cup
				JSR		MOJI_Set
;
				ldy		#0000
				ldx		#0002					;kinoko cup
				JSR		MOJI_Set
;
				ldy		#0000
				ldx		#0004					;kinoko cup
				JSR		MOJI_Set
;------(XyṼ`FbNAZbg)----
				lda		game_level
				beq		WAKU_set				;TOccNX?;yes-->Set_msb
;
;-----(ẴS[hJbv`FbN)----
				lda		>Kinoko_Cup
				and		#0003h
				cmp		#0001
				bne		Stop_special
				lda		>Flower_Cup
				and		#0003h
				cmp		#0001
				bne		Stop_special
				lda		>Star_Cup
				and		#0003h
				cmp		#0001
				bne		Stop_special
;
				ldy		#0000
				jmp		Clare_special
Stop_special	ldy     #0004
Clare_special	ldx		#0006					;special cup
				JSR		MOJI_Set
;<<<<<<<<<<<<<<<<< Nf[^[Zbg >>>>>>>>>>>>>>>>
WAKU_set		ldy		#0000
				ldx		#0000
				mem16
				rep		#00100000b
loop_waku_0		lda		WAKU,x
				cmp		#0ffffh
				beq		Check_waku
				sta		oamdat,y
				JSR		Y_iny_set
				inx
				inx
				jmp		loop_waku_0
;
Check_waku		JSR		WAKU_change_set
;<<<<<<<<<<<<< gtB[f[^[Zbg >>>>>>>>>>>>>>>>
Trophy_setdata	lda		game_level
				bne		Set_special				;TOccNX?;yes-->Set_msb
;
				ldx		#0
				ldy		#00a0h
trophy_posi_set	lda		trophy_place,x				;gtB[|WVZbg.
				sta		oamdat,y
				inx
				inx
				JSR     Y_iny_set
				cpy		#00ach
				bne		trophy_posi_set
;
				ldx		#0
				ldy		#00a2h
Loop_50cc_cup	phx
				JSR		Check_Cup
				jsr		Trophy_set				;kinoko cup
				plx
				inx
				JSR     Y_iny_set
				cpx		#0003h
				bne		Loop_50cc_cup			
				jmp		color_set
;------(XyṼ`FbNAZbg)----
Set_special		ldy		#00a0h
				ldx		#0
trophy_posiset1	lda		trophy_place1,x				;gtB[|WVZbg.
				sta		oamdat,y
				inx
				inx
				JSR     Y_iny_set
				cpy		#00b0h
				bne		trophy_posiset1
;
				lda		game_level
				cmp		#0004
				beq		Set_150cc_trophy
;
				ldx		#0
				ldy		#00a2h
Loop_100cc_cup	phx
				JSR		Check_Cup1
				jsr		Trophy_set1				;kinoko cup
				plx
				inx
				JSR     Y_iny_set
				cpx		#0004h
				bne		Loop_100cc_cup	
				jmp     color_set		
;
Set_150cc_trophy
;
				ldx		#0
				ldy		#00a2h
Loop_150cc_cup	phx
				JSR		Check_Cup2
				jsr		Trophy_set2				;kinoko cup
				plx
				inx
				JSR     Y_iny_set
				cpx		#0004h
				bne		Loop_150cc_cup	
;<<<<<<<<<<<<<<<<< W@J[ >>>>>>>>>>>>>>>>
color_set		ldy     #0002
				lda     world_number
				asl		a
				tax
				JSR		MOJI_Set
;<<<<<<<<<<<<<<<<<< NXZbg >>>>>>>>>>>>>>>>>>>>>>> 
				lda		#2088h
				sta		oamdat+180h
				lda		#366ah
				sta     oamdat+182h
;
				lda		game_level
				tax
				ldy		#0
				lda		Class_select,x
				tax
loop_class		lda		!0,x
				inx
				inx
				sta		oamdat+186h,y
				JSR     Y_iny_set
				cmp		#0090h
				beq		no_inc
				inc		a
no_inc			sta		oamdat+186h,y
				JSR     Y_iny_set
				cpy		#0018h
				bne		loop_class
;

				ldy		#0			
				lda		#1870h
loop_class1		sta		oamdat+184h,y
				pha
				JSR     Y_iny_set
				clc
				adc		#0800h
				sta		oamdat+184h,y
				pla
				clc
				adc		#0008h
				JSR     Y_iny_set
				cpy		#0018h
				bne		loop_class1

;<<<<<<<<<<<<<<<<<<< MSB DATA SET >>>>>>>>>>>>>>>>>>>>>>
Set_msb			ldx		#0		
loop_msb		lda		#0aaaah
				sta		msbdat,x
				inx
				inx
				cpx		#0018h
				bne		loop_msb
loop_msb1		stz		msbdat,x
				inx
				inx
				cpx		#0020h
				bne		loop_msb1
				plb
				rtl
;==============================================================
;**************************************************************
;					f[^[
;**************************************************************
;==============================================================
WAKU_select		DW		3646h,344ah,3448h
;
trophy_place	DW		4640h,6640h,8640h			;50cc
trophy_place1   DW      3e40h,5640h,6e40h,8e40h		;100cc
;					----- 3 --- 2 --- 1 --- 0 ----
trophy_color1	DW		3a44h,3c44h,3844h,0e44h		;50cc
trophy_color	DW		3a4ch,3c4ch,384ch,0e4dh		;100cc
trophy_color2	DW		3a4eh,3c4eh,384eh,0e4eh		;150cc		
;
Color_data_set	DW		0000h,1400h,0c00h
;
;- - - - - - - - - - - - - -- - - - -- - - - -- - - -- - -
Address_data	DW		252ah,25aah,262ah
Address_data1	DW		250ah,256ah,25cah,264ah
;
Cup_select		DW		KINOKO_CUP,FLAWER_CUP,STAR_CUP
				DW		SPECIAL_CUP
;
KINOKO_CUP		DW		1400h,1401h,1402h,1403h,1404h,1405h
				DW		1406h,1407h,1408h
				DW		1409h,0ffffh
;
FLAWER_CUP		DW		140ah,140eh,140fh,1420h,1421h,1404h
				DW		1405h,1406h,1407h,1408h
				DW		1409h,0ffffh
;
STAR_CUP		DW		140ah,140bh,140ch,140dh,1404h
				DW		1405h,1406h,1407h,1408h
				DW		1409h,0ffffh
;
SPECIAL_CUP		DW		142eh,142fh,1440h,1441h,1442h
				DW		1443h,1404h,1405h,1406h
				DW		1407h,1408h,1409h,0ffffh
;
Class_select	DW		Class_50,Class_100,Class_150
Class_50		DW		0090h,3712h,3708h
;
Class_100		DW		370ah,3708h,3708h
;
Class_150		DW		370ah,3712h,3708h
;- - - - - - - - - - - - - - - - - - - - - - -
WAKU			DW		2728h,2738h,2748h,2758h,2768h
				DW		2778h,2788h,2798h,27a8h,27b8h
				DW		27c8h
;
				DW		3728h,37c8h,4728h,47c8h,5728h
				DW		57c8h,6728h,67c8h,7728h,77c8h
				DW		8728h,87c8h,9728h,97c8h
;
				DW		0a728h,0a738h,0a748h,0a758h
				DW		0a768h,0a778h,0a788h,0a798h
				DW		0a7a8h,0a7b8h,0a7c8h,0ffffh
;============================================================
;************************************************************
;					Tu[`W
;************************************************************
;============================================================
;<<<<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>>
MOJI_Set		equ		$
				mem16
				idx16
				lda		Color_data_set,y
				sta		Color_set
				phx
;------(NXʕAhXZbg)------
				lda		game_level
				beq		Set_norm					;TOccNX?;yes-->Set_msb
;
				lda		Address_data1,x
				jmp		Set_v_address
;
Set_norm		lda     Address_data,x
Set_v_address	sta     Screen_address
;-----(̏㑤Zbg)---------
				lda		Cup_select,x
				tax
loop_moji_set	lda		!0,x
				cmp		#0ffffh
				beq		Set_under_moji
				sec
				sbc		Color_set
				sta     Screen_write
				inx
				inx
				jmp		loop_moji_set
;------(NXʕAhXZbg)------
Set_under_moji	plx
				lda		game_level
				beq		Set_norm1					;TOccNX?;yes-->Set_msb
;
				lda		Address_data1,x
				jmp		Set_v_address1
;
Set_norm1		lda     Address_data,x
Set_v_address1	clc
				adc		#0020h
				sta     Screen_address
;------(̉Zbg)---------
				lda		Cup_select,x
				tax
loop_moji_set1	lda		!0,x
				cmp		#0ffffh
				beq		owari_moji_set
				cmp		#00e5h
				beq		nuki_set
				clc
				adc		#0010h	
				sec		
				sbc		Color_set	
nuki_set		sta     Screen_write
				inx
				inx
				jmp		loop_moji_set1
owari_moji_set	rts
;
MOJI_Set_1		equ		$
				phb
				phk
				plb
				JSR		MOJI_Set
				plb
				rtl
;<<<<<<<<<<<<< gtB[Zbg̃Tu[` >>>>>>>>>>
				mem16
				idx16
;		
Trophy_set		lda		trophy_color,x
				sta		oamdat,y				;J[ƃLN^[Zbg
				rts
;
Trophy_set1		lda		trophy_color1,x
				sta     oamdat,y
				rts
;
Trophy_set2		lda		trophy_color2,x
				sta     oamdat,y
				rts
;<<<<<<<<<<<<<<< N Zbg[` >>>>>>>>>>>>>>>>
WAKU_change_set	equ		$
				lda		world_number
				cmp		#03
				beq		special_cup					;world number 3?:yes-->special_cup
;
Set_waku_data	lda		world_number
				asl		a
				tax
				lda		WAKU_select,x
				ldx		#0000
loop_waku_1		sta		oamdat+2,x
				inx
				inx
				inx
				inx
				cpx		#0090h
				bne		loop_waku_1
				jmp		owari_change_set
;-------(XyVZbg)-------------
special_cup		ldy		#0000
				ldx		#04							;waku change set.
				stx		<waku_counter
;
loop_special	ldx		<waku_counter
				lda		WAKU_select,x
				sta		oamdat+2,y
				dec		<waku_counter
				dec		<waku_counter
				lda		<waku_counter
				bmi		Reset_counter
Set_next_data	JSR     Y_iny_set
				cpy		#0090h
				beq		owari_change_set
				jmp		loop_special
Reset_counter	lda		#0004
				sta		<waku_counter
				jmp		Set_next_data
owari_change_set
				rts
;
Y_iny_set		iny
				iny
				iny
				iny
				rts
;<<<<<<<<<<<<< S[hϊ[` >>>>>>>>>>>>>>
Set_4bit_mode	equ		$
										;hi2bit set.
loop_4bit3		ldy		#0						;(zero set).
loop_4bt1		lda		>W_select_chr,x
				sta		Screen_write
				inx
				inx
				iny
				cpy		#08
				bne		loop_4bt1
;------------------------------------------------ 

				ldy		#0						;low2bit set.
loop_4bit2		lda		#0
				sta		Screen_write
				iny
				cpy		#08
				bne		loop_4bit2
				cpx		#0600h
				bne		loop_4bit3
				rts
;
Set_4bit_mode1	equ		$
				phb
				phk
				plb
				JSR		Set_4bit_mode
				plb
				rtl
;==========================================================
;**********************************************************
;				MAIN ROURATINE
;**********************************************************
;==========================================================
;*****************************************************
;					[h񂽂
;*****************************************************
Cup_change.set	equ		$
				phb
				phk
				plb
				mem16
				idx16
				lda		<button_TG
				ora		<button_TG+2
				and		#2c00h
				cmp		#0400h
				beq		cup_inc
				cmp		#0800h
				beq		cup_dec
				cmp		#2000h
				beq     cup_inc
				jmp		owari_change
;<<<<<<<<<<<< [h`FW@Zbg >>>>>>>>>>>>
cup_inc			
;----------(NX`FbN)---------
				lda		game_level
				beq		Set_50cc
;-----(POOẴS[hJbv`FbN)----
				lda		>Kinoko_Cup
				and		#0003h
				cmp		#0001
				bne		Set_50cc
				lda		>Flower_Cup
				and		#0003h
				cmp		#0001
				bne		Set_50cc
				lda		>Star_Cup
				and		#0003h
				cmp		#0001
				bne		Set_50cc
;--(POO[h`FWZbg)--
				lda     world_number
				sta		<Old_world_number
				inc		a
				cmp		#04
				beq		reset_world
				sta     world_number
				jmp		SE_set
;--(5O[h`FWZbg)--
Set_50cc		lda     world_number
				sta		<Old_world_number
				inc		a
				cmp		#03
				beq		reset_world
				sta     world_number
				jmp     SE_set
;------(I[h[hio[Zbg)----
cup_dec			lda		world_number
				sta		<Old_world_number
				beq		under_world
				dec		a
				sta		world_number
SE_set			lda		#002ch
				JSL		>Trigger_sound_1
;<<<<<<<<<<<<<<< N@Zbg >>>>>>>>>>>>>>>>>>>>
change_waku		JSR		WAKU_change_set
owari_change	plb
				rtl				
;<<<<<<<<<<<<<<< {^@[v >>>>>>>>>>>>>>>>>>>
reset_world		stz		world_number
				jmp     SE_set
;
under_world		lda		game_level
				bne		World_3
;
World_2			lda		#0002
				sta     world_number
				jmp     SE_set
;
World_3			lda		>Kinoko_Cup
				and		#0003h
				cmp		#0001
				bne		World_2
				lda		>Flower_Cup
				and		#0003h
				cmp		#0001
				bne		World_2
				lda		>Star_Cup
				and		#0003h
				cmp		#0001
				bne		World_2
;
				lda		#0003
				sta		world_number
				jmp     SE_set	
;*******************************************************
;					̂߂Zbg
;*******************************************************
NEXT_SET		equ		$
				phb
				phk
				plb
				mem16
				idx16
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				beq		owari_check
;<<<<<<<<<<<<<<< @Zbg >>>>>>>>>>>>>>>>>>>>>
				stz     race_init
;
				lda		#002eh
				JSL		>Trigger_sound_1
;
				lda     #02					;race mode set.
				sta     <game_selecta
;
				JSL		>BGM_fade_out
;
				lda     #8f00h
				sta     <fade_control		;fade set.
owari_check		plb
				rtl
;
;*******************************************************
;					N]Zbg
;*******************************************************
WAKU_MOVE.SET	equ		$
				phb
				phk
				plb
				mem16	
				idx16
				inc		<move_counter
				lda		<move_counter
				cmp		#0002
				bne		owari_waku1				;counter 2?:no-->owari_waku1
;<<<<<<<<<<<<<<<<< ]`FbN >>>>>>>>>>>>>>>>>>
				stz		<move_counter
;
				ldx		#0
loop_waku		lda		oamdat,x
				cmp		#27c8h
				beq		down_move
;
				cmp		#0a728h
				beq		up_move
;
				and		#0ff00h
				cmp		#2700h
				beq		right_move
;
				cmp		#0a700h
				beq		left_move
;
				lda		oamdat,x
				and		#00ffh
				cmp		#0028h
				beq		up_move
;
				cmp		#000c8h
				beq		down_move
				jmp		next_set
;<<<<<<<<<<<<<<<< EZbg >>>>>>>>>>>>>>>>>>>>
right_move			lda     oamdat,x
				clc
				adc		#0001
				cmp		#27c8h
				beq		set_down		
				sta		oamdat,x
				jmp		next_set
;<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>				
down_move		lda		oamdat,x
				clc
				adc		#0100h
				cmp		#0a7c8h
				bcs		set_left		
				sta		oamdat,x
				jmp		next_set
loop_waku1		jmp		loop_waku
owari_waku1		jmp		owari_waku
;<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>>
left_move		lda		oamdat,x
				sec
				sbc		#0001h
				cmp		#0a728h
				bcc		set_up		
				sta		oamdat,x
				jmp		next_set
;<<<<<<<<<<<<<<<<< Zbg >>>>>>>>>>>>>>>>>>>
up_move		lda		oamdat,x
				sec
				sbc		#0100h
				cmp		#02728h
				bcc		set_right		
				sta		oamdat,x
;----------------------------------------------
next_set		inx
				inx
				inx
				inx
				cpx		#0090h
				bne		loop_waku1
owari_waku		plb	
				rtl
;----------------------------------------------
				mem16 
set_down		lda		#027c8h
				sta		oamdat,x
				jmp		next_set
;
set_left		lda		#0a7c8h
				sta		oamdat,x
				jmp		next_set
;
set_up			lda		#0a728h
				sta		oamdat,x
				jmp		next_set
;
set_right		lda		#02728h
				sta		oamdat,x
				jmp		next_set
;*******************************************************
;				obNAbvZbg
;*******************************************************	
;
;***************************************************
;				e|Dp
;***************************************************
;<<<<<<<<<<<<<<<< obNAbvZbg >>>>>>>>>>>>>>>>>>
Back_up_set		equ		$
				phb
				phk
				plb
;-------([hio[Zbg)-----------
				lda		world_number
				tax
				phx
;----------(NX`FbN)---------------
				lda		game_level
				beq		kids_back_up
				cmp		#0004
				beq		Special_back_up
;------(POOobNAbvZbg)-----
				plx
				phx
				JSR		Set_Rank_Check
				sta		Rank_cmp
;
				plx
				JSR		Set_back_up
				jmp    	Owari_back_up_set
;--------(TOobNAbvZbg)-----
kids_back_up	plx
				phx
				JSR     Set_Rank_Check
				asl		a
				asl		a
				sta		Rank_cmp
				plx
				JSR     Set_back_up
				jmp     Owari_back_up_set
;--------(15OobNAbvZbg)-----
Special_back_up	plx
				phx
				JSR		Set_Rank_Check
				asl		a
				asl		a
				asl		a
				asl		a
				sta		Rank_cmp
;
				plx
				JSR     Set_back_up
Owari_back_up_set
				plb
				rtl
;
;
Set_Rank_Check
				JSL		>Rank_Check_sum
				txa
				lsr		a
				tax
				mem8
				sep		#00100000b
				lda		Select_cup,x
				rts
;
Set_back_up		equ		$
				cmp		#0
				beq		SUM_set
				lda		game_level
				lsr		a
				tay
				lda		>back_up_address,x
				and		Select_check,y
				beq		Rank_back_up
;
				cmp		Rank_cmp
				bcc		owari_Set_back_up
;
Rank_back_up	lda     >back_up_address,x
				and		Select_rank,y
				ora		Rank_cmp
				sta		>back_up_address,x		
;
SUM_set			mem16
				rep		#00100000b	
				lda		#0
				sta		>Back_up_Sum
				ldx		#0
loop_Sum		lda		>back_up_address,x
				clc
				adc		>Back_up_Sum
				sta		>Back_up_Sum
				inx
				inx
				cpx		#0004
				bne		loop_Sum
owari_Set_back_up
				mem16
				rep		#00110000b
				rts
;
Select_check	DB		0ch,03h,030h
Select_rank		DB		33h,3ch,00fh
;
;***************************************************
;				|Dp
;***************************************************									
;<<<<<<<<<<< TOgtB[Zbg >>>>>>>>>>>
Check_Cup		equ		$
				mem16
				lda		>back_up_address,x
				and		#00ffh
				mem8
				sep		#00100000b
				and		#0ch
				lsr		a
				jmp		Set_rank_trophy
;<<<<<<<<<< POOgtB[Zbg >>>>>>>>>>
Check_Cup1		equ		$
				mem16
				lda		>back_up_address,x
				and		#00ffh
				mem8
				sep		#00100000b
				and		#03h
				asl		a
				jmp     Set_rank_trophy
;<<<<<<<<<< P5OgtB[Zbg >>>>>>>>>>
Check_Cup2		equ		$
				mem16
				lda		>back_up_address,x
				and		#00ffh
				mem8
				sep		#00100000b
				and		#30h
				lsr		a
				lsr		a
				lsr		a
Set_rank_trophy	mem16
				rep		#00100000b
				tax
				lda		Kind_Cup,x
				tax
				rts
;****************************************************
;				|Dp
;****************************************************
;<<<<<<<<<<<<<<<<< T@`FbN >>>>>>>>>>>>>>>>>
Backup_Sam_Check
				phb
				phk
				plb
;
				stz		Sum_cmp
;------(T@`FbN)---------
				ldx		#0
loop_sum_check	lda		Sum_cmp
				clc
				adc		>back_up_address,x
				sta		Sum_cmp
				inx
				inx
				cpx		#0004
				bne		loop_sum_check
				cmp		>Back_up_Sum
				beq		owari_sum_check
;------([NA[)-----------
				ldx		#0
				lda		#0
loop_sum_zero	sta		>Back_up_Sum,x
				inx
				inx
				cpx		#0006
				bne		loop_sum_zero
owari_sum_check	plb
				rtl
;
;<<<<<<<<< obNAbvI[NA[ >>>>>>>>>>
Back_up_clear	equ		$
				phb
				phk
				plb
;----------(\̃`FbN)--------
				lda		<erase_set_flag
				bne		Set_erase_check
;----(C[X\̃{^`FbN)------
				lda     button_status
				ora     button_status+2
				cmp     #40b0h
				bne     nothing_button_1
;
				JSL		>OBJ_ERASE_SET			;title-e.asmɂ܂
;-----------(C[X\)---------
				inc		<erase_set_flag
				ldx		#0
Loop_Earse		lda		Erase_moji_data,x
				sta		oamdat+1b8h,x
				inx
				inx
				cpx		#0044h
				bne		Loop_Earse
nothing_button_1
				jmp     nothing_button
;-----(xCm`FbN{^)-----
Set_erase_check	lda		<button_TG
				ora		<button_TG+2
				and		#0300h
				cmp		#0100h
				beq		NO_set
				cmp		#0200h
				beq		YES_set
				lda		<button_TG
				ora		<button_TG+2
				and		#9000h
				bne		Set_decide
				jmp		nothing_button
;-----(mtOZbg)-------
NO_set			lda		<erase_set_flag
				dec		a
				beq		nothing_button
				sta		<erase_set_flag
				lda		#70b8h
				sta		oamdat+1f8h
				lda		#002ch
				JSL		>Trigger_sound_1
				jmp     nothing_button
;-----(xtOZbg)-------
YES_set			lda		<erase_set_flag
				inc		a
				cmp		#0003
				beq		nothing_button
				sta		<erase_set_flag
				lda		#7098h
				sta     oamdat+1f8h
				lda		#002ch
				JSL		>Trigger_sound_1
				jmp     nothing_button
;----(C[XC[XłȂ̃`FbN)----
Set_decide		lda		<erase_set_flag
				cmp		#0002
				bne		erase_check_moji
;
				JSR		Check_150cc
;------(obNAbv)------
				ldx		#0
				lda		#0
loop_sum_zero_1	sta		>Back_up_zero,x
				inx
				inx
				cpx		#0800h
				bne		loop_sum_zero_1
;
				lda		#0029h
				JSL		>Trigger_sound_1
erase_check_moji
				JSR		moji_erase_set
;
nothing_button	plb
				rtl
;
;------()---------------
moji_erase_set	lda		#0e080h
				ldx		#0
loop_moji_erase	sta		oamdat+1b8h,x
				inx
				inx
				cpx		#0044h
				bne		loop_moji_erase
				stz		<erase_set_flag

;
Check_150cc
;----(TOɖ߂)-----------
				mem8
				sep		#00100000b
				lda		<Game_select.flag	
				and		#06
				cmp		#04
				bne		No_set_50cc
				lda		<Game_select.flag
				and		#0f9h
				sta		<Game_select.flag
No_set_50cc		mem16
				rep		#00100000b
				rts

Erase_moji_data	DW		7028h,3872h,692ah,382eh,7030h,389ch
				DW		7038h,386fh
				DW		7040h,385ch
				DW		7050h,3838h,7058h,383bh	
				DW		7060h,384eh,7068h,383ch
				DW		7070h,3835h,7078h,3824h
;
				DW		70a0h,3849h,70a8h,3831h
				DW		70c0h,3831h,70c8h,3831h
				DW		70d0h,3833h,70b8h,3ae5h
;
Kind_Cup		DW		0006h,0004h,0002h,0000h
	
Select_cup		DB		01h,02h,03h,00h,00h,00h,00h,00h
				END

