
/* ============================================	*/
/*	Character Convert			*/
/* ============================================	*/

#include	<stdio.h>
#include	<ctype.h>
#include	<string.h>

unsigned char	inchar[0x10000];
unsigned char	outchar[0x10000];

main(argc,argv)
int	argc;
char	*argv[];
{

	char	inname[512];
	char	outname[512];
	FILE	*fpIN,*fpOUT;
	int	filesize;


	if ( argc < 4 ){
		fprintf (stderr,"********************************************\n");
		fprintf (stderr,"****                                    ****\n");
		fprintf (stderr,"****------------------------------------****\n");
		fprintf (stderr,"****      4bit CGX file Convert         ****\n");
		fprintf (stderr,"****------------------------------------****\n");
		fprintf (stderr,"****  Usage: cmp Fin Fout charcount     ****\n");
		fprintf (stderr,"****                                    ****\n");
		fprintf (stderr,"****         Fin       = input file     ****\n");
		fprintf (stderr,"****         Fout      = output file    ****\n");
		fprintf (stderr,"****         charcount = totalbyte/32   ****\n");
		fprintf (stderr,"****                                    ****\n");
		fprintf (stderr,"****                                    ****\n");
		fprintf (stderr,"****                        1994/7/14	****\n");
		fprintf (stderr,"****                                    ****\n");
		fprintf (stderr,"****             Programed by H.Yajima  ****\n");
		fprintf (stderr,"****                                    ****\n");
		fprintf (stderr,"********************************************\n");
		exit(1);
	}

	strcpy	(inname,argv[1]);
	strcpy	(outname,argv[2]);

	if ( (fpIN = fopen(inname,"rb")) == NULL ){
		fprintf (stderr,"Can't open %s file\n",inname);
		exit(1);
	}
	filesize = atoi(argv[3])*32;
	printf ("filesize	(%0x)\n",filesize);
	if ( (filesize%32) != 0 ){
		printf (" 4bitchar size error \n" );
	}
	fread(inchar, sizeof(char), filesize, fpIN);
	fclose(fpIN);

	convert	(inchar,outchar,filesize);


	if ( (fpOUT = fopen(outname,"wb")) == NULL ){
		fprintf (stderr,"Can't open %s file\n",outname);
		exit(1);
	}
	fwrite(outchar, sizeof(char), filesize, fpOUT);
	fclose(fpOUT);

}

/*------------------------------------------*/

convert(inchar,outchar,filesize)
unsigned char	*inchar;
unsigned char	*outchar;
int	filesize;
{
	int	i;	/* input pointer  */
	int	j;	/* output pointer */

	j = 0;

	for(i=0;i<filesize/32;i++){
		outchar[j++] = inchar[i*32+0];
		outchar[j++] = inchar[i*32+2];
		outchar[j++] = inchar[i*32+4];
		outchar[j++] = inchar[i*32+6];
		outchar[j++] = inchar[i*32+8];
		outchar[j++] = inchar[i*32+10];
		outchar[j++] = inchar[i*32+12];
		outchar[j++] = inchar[i*32+14];
	}
	for(i=0;i<filesize/32;i++){
		outchar[j++] = inchar[i*32+1];
		outchar[j++] = inchar[i*32+3];
		outchar[j++] = inchar[i*32+5];
		outchar[j++] = inchar[i*32+7];
		outchar[j++] = inchar[i*32+9];
		outchar[j++] = inchar[i*32+11];
		outchar[j++] = inchar[i*32+13];
		outchar[j++] = inchar[i*32+15];
	}
	for(i=0;i<filesize/32;i++){
		outchar[j++] = inchar[i*32+16];
		outchar[j++] = inchar[i*32+18];
		outchar[j++] = inchar[i*32+20];
		outchar[j++] = inchar[i*32+22];
		outchar[j++] = inchar[i*32+24];
		outchar[j++] = inchar[i*32+26];
		outchar[j++] = inchar[i*32+28];
		outchar[j++] = inchar[i*32+30];		
	}
	for(i=0;i<filesize/32;i++){
		outchar[j++] = inchar[i*32+17];
		outchar[j++] = inchar[i*32+19];
		outchar[j++] = inchar[i*32+21];
		outchar[j++] = inchar[i*32+23];
		outchar[j++] = inchar[i*32+25];
		outchar[j++] = inchar[i*32+27];
		outchar[j++] = inchar[i*32+29];
		outchar[j++] = inchar[i*32+31];
	}


	printf ("datatotal	(%0x)\n",j);

}

/*------------------------------------------*/
/*------------------------------------------*/
/*------------------------------------------*/
/*------------------------------------------*/
/*------------------------------------------*/
/*------------------------------------------*/


