/*-
 * Copyright (c) 1993, Trusted Information Systems, Incorporated
 * All rights reserved.
 *
 * Redistribution and use are governed by the terms detailed in the
 * license document ("LICENSE") included with the toolkit.
 */
/*	RcsId: "$Header: firewall.h,v 1.4 94/11/01 11:54:22 mjr rel $"	*/

/*
 *	Author: Marcus J. Ranum, Trusted Information Systems, Inc.
 */

/*

	firewall.h

	This file contains most of the configurable options for the
	toolkit. (A very few are contained in Makefiles for given
	applications)

	Before attempting to install any part of the software, you
	should go through this file and adjust it as necessary.

*/
#ifndef	_INCL_FWALL_H


/*
Release level of this version of the fwtk.
This string will be compiled into config.c and will appear
in all binaries generated by the core toolkit components.
*/
#define	FWTK_VERSION		"TIS Internet Firewall Toolkit V1.3"
#define	FWTK_VERSION_MINOR	"V1.3"



/*
The firewall toolkit uses a single master configuration
and permissions file. Edit this as necessary for your
system.
*/
#ifndef	PERMFILE
#define	PERMFILE	"\\netperm.tab"
#endif



/*
Choose a system logging level for the firewall
toolkit. All components of the toolkit will use
this value for logging entries.
*/
#ifndef	LLEV
#define	LLEV	LOG_NOTICE
#endif


/* Choose a system logging facility for the firewall toolkit.  */
#ifndef	LFAC
#define	LFAC	LOG_DAEMON
#endif


/*
Pick one of these two ways of declaring malloc(). This
should match your system's definition. See malloc(3).
*/
/* extern	char	*malloc(); */
extern	void	*malloc();


/*
some systems have struct direct(s) for reading directories,
while others have struct dirent(s). they're close enough as
makes no difference. make sure that whichever your machine uses
is defined below.
*/
/* #define DIRECT_STRUCT   struct dirent */


/*
Define one or the other of the below for locking.
LOCK_FLOCK enables flock() style locking, LOCK_LOCKF
enables lockf() style locking.
The locking primitives are implemented in lib/lock.c
*/
/* #define	LOCK_FLOCK */
#define	LOCK_LOCKF



/*
Define one or the other of the below to choose your
method for interrupt driven out of band signalling on
a socket. Most BSD systems will use F_SETOWN. hp/ux
and others may use SIOCSPGRP.
This primitive is implemented in lib/urg.c
*/
#define	USE_F_SETOWN
/* #define	USE_SIOCSPGRP */



/*
Setsid() is used in the daemon() routine for
smapd. If your system has setsid() from POSIX
leave HAVE_SETSID defined, otherwise you may need to
add system dependent code to disassociate from the
terminal to lib/daemon.c
*/
#define		HAVE_SETSID


/*
Some machines use random() some machines use rand().
pick which one you use. Or if you want to use a different
PRNG, replace the one in lib/rand.c
*/
#define	USE_RANDOM
/* #define	USE_RAND */



/*
If doing chroot and you want to use the version of syslog(3)
that does UDP rather than UNIX domain sockets, comment the
following in. Sources for this version of syslog() are in
lib/syslog.c  -- They will not work properly on ULTRIX and
other systems that do not have a reasonably up-to-date
4.3-based syslogd.

This version of the syslog() code is subtly different from
the BSD net-2 version in that it also will try to see if
there is a name mapping for "loghost" and will use it, 
if there is. If not, it will hardwire to the loopback
address, 127.0.0.1

The reason this version is included with the toolkit is
because some versions of syslog fail across chroot [specifically,
Sun's] when /dev/log is no longer 'reachable'. Commenting
this out and using your vendor-supplied syslog() routine
will not impair the functionality of the firewall.
*/
/*
#define	USE_UDPSYSLOG
*/


/*
If using the UDPsyslog routines, there is an option to have
it dynamically lookup the "loghost" as where to send its
log messages. The default is to use 127.0.0.1
*/
/* #define LOOKUP_LOGHOST */



/*
If this is defined, smapd will attempt some basic scanning of
From: and To: addresses to search for pipe marks and other
symbols that might indicate someone is trying to trigger a
sendmail hole.
*/
#define	SMAPD_SCANBADADDR



/*
----------------End Configuration Section----------------
*/

/* record used for permissions file entry */
typedef	struct	cfgrec	{
	int	flags;		/* see below */
	int	ln;		/* line# in config file */
	char	*op;		/* facility name */
	int	argc;		/* number of arguments */
	char	**argv;		/* vector */
	struct	cfgrec	*next;
} Cfg;
Cfg	*cfg_read();
Cfg	*cfg_get();
#define	PERM_ALLOW	01
#define	PERM_DENY	02


#define	_INCL_FWALL_H
#endif

