;-------------------------------------------------------------------;
;                                                                   ;
;                    STARFOX II - THE SEQUEL                        ;
;                                                                   ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;                                                                   ;
; FILE:         KPATHDAT.ASM                                        ;
; AUTHOR:       Yasuhiro Kawaguchi                                  ;
; DESCRIPTION:  Path Data                                           ;
; DATE CREATED: 22-3-93                                             ;
;                                                                   ;
;-------------------------------------------------------------------;
;***** EXTERN *****
	incpub	kpathdat

;********************** Path Data Library **************************
;Temporary Path Data
;Friend Base Path Data
;Enemy Zaco Path Data
;Enemy Boss Path Data
;Item Path Data
;Ring Path Data
;Building Path Data

;*********************************************************************
;*								*
;*		TEMPORARY PATH LIBRARY				*
;*								*
;*********************************************************************
;--------------------------------------------------------------------
	start_path	ktest
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
;;;	p_pollen	on
	p_end
;---------------------------------------------------------------------
	start_path	ktestlvsnd
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
	P_SOUND		p2_ering
.LOOP
	P_GOTO		.LOOP
;---------------------------------------------------------------------
	start_path	ktestlvsnd2
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
	P_SOUND		p2_enemy_fly1
.LOOP
	P_GOTO		.LOOP
;---------------------------------------------------------------------
	start_path	ktestlvsnd3
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
	P_SOUND		p2_enemy_fly3
.LOOP
	P_GOTO		.LOOP
;---------------------------------------------------------------------
	start_path	ktestlvsnd4
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
;;;	P_SOUND		p2_laputa
.LOOP
	P_GOTO		.LOOP
;---------------------------------------------------------------------
	start_path	ktestsndpos
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
.LOOP
	P_SOUNDEFTPOS	en_jump1_L

	P_WAIT		30
	P_GOTO		.LOOP
	p_end
;---------------------------------------------------------------------
	start_path	ktestsnddist
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
.LOOP
	P_SOUNDEFTDIST	en_explode_s	;en_missileshoot_s
	P_WAIT		20
	P_GOTO		.LOOP
	p_end
;---------------------------------------------------------------------
	start_path	ktestsnddistpos
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
.LOOP
	P_SOUNDEFTDISTPOS	en_laser_sL	;en_missileshoot_s
	P_WAIT		20
	P_GOTO		.LOOP
	p_end
;---------------------------------------------------------------------
	start_path	ktestsndnearpos
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
.LOOP
	P_SOUNDEFTNEARPOS	en_laser_sL
	P_WAIT		20
	P_GOTO		.LOOP
	p_end
;---------------------------------------------------------------------
	start_path	ktestsndvis
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
.LOOP
	P_SOUNDEFTVIS	en_laser_sL
	P_WAIT		20
	P_GOTO		.LOOP
	p_end
;---------------------------------------------------------------------
	start_path	ktestsnddirect
	p_set		hp,100		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_RADAROBJ	ra_enemy
.LOOP
	P_SOUNDEFTDIRECT	en_laser_sL,nearL
	P_WAIT		20
	P_GOTO		.LOOP
	p_end

;---------------------------------------------------------------------
	start_path	khp
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_end
;---------------------------------------------------------------------
	start_path	kcolloff
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_collisions	off		;collisions off
	p_end
;---------------------------------------------------------------------
	start_path	kmuteki
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_invincible	on		;muteki (on/off)
	p_end
;---------------------------------------------------------------------
	start_path	k3Dmove

	p_setvel	7		;enemy velocity
	p_alwaysgenvecs	on		;vel to 3D vector
	p_end
;---------------------------------------------------------------------
	start_path	kshadowon
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_shadow	on		;shadow on
	p_end
;---------------------------------------------------------------------
	start_path	kshadowoff
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	P_shadow	off		;shadow off
	p_end
;---------------------------------------------------------------------
	start_path	krotx
	p_set	hp,10
	p_set	ap,0
	p_trigger	.rot,always
	p_end
.rot
	p_add	rotx,4
	p_return
;---------------------------------------------------------------------
	start_path	kroty
	p_set	hp,10
	p_set	ap,0
	P_shadow	off		;shadow off
	p_trigger	.rot,always
	p_end
.rot
	p_add	roty,4
	p_return
;---------------------------------------------------------------------
	start_path	krotz
	p_set	hp,10
	p_set	ap,0
	p_trigger	.rot,always
	p_end
.rot
	p_add	rotz,32	;4
	p_return
;---------------------------------------------------------------------
	start_path	krotxy
	p_set	hp,10
	p_set	ap,0
	p_trigger	.rot,always
	p_end
.rot
	p_add	rotx,4
	p_add	roty,4
	p_return

;---------------------------------------------------------------------
	start_path	krotxyz
	p_set	hp,10
	p_set	ap,0
	p_trigger	.rot,always
	p_end
.rot
	p_add	rotx,4
	p_add	roty,4
	p_add	rotz,4
	p_return

;---------------------------------------------------------------------
	start_path	kalways
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_trigger	.always,Always	;jmp every flaME
	p_end
.Always
	p_end
;---------------------------------------------------------------------
	start_path	kthrough
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point

	p_trigger	.through,whenthrough
	p_end

.through	p_withinradius	30,.playerthrough	;radius check
	p_return

.playerthrough
	p_return
;---------------------------------------------------------------------
	start_path	kwhenhit
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_trigger	.hit,whenhit
	p_end
.hit
	p_return
;---------------------------------------------------------------------
	start_path	ksprite
	p_collisions	off
	p_set		hp,50		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_sprite	0,0		;[color,size]
	p_end
;---------------------------------------------------------------------
	start_path	kindexjmp
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point

	p_set	pbyte1,0		;[0,1,2,...]
	p_index	pword1,.jumptable,pbyte1
	p_gosub	pword1
	p_end

.jumptable
	dw	.Adr_one&WM
	dw	.Adr_two&WM
	dw	.Adr_three&WM

.Adr_one
	p_return
.Adr_two
	p_return
.Adr_three
	p_return
;---------------------------------------------------------------------
	start_path	kbecome
	p_set		hp,10		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point

	p_export	gword1,pword1	;gword1 ,<-- pword1(mother)

	p_spawn		0,-100,128,0,0,0,nullshape,kbecome_sub,10,10
	p_become
	p_import	pword1,gword1	;pword1(child)<--- gword1
	p_unbecome
	p_end

	start_path	kbecome_sub
	p_end
;--------------------------------------------------------------------
	start_path	kexplain
	p_set	hp,10
	p_set	ap,0
	P_shadow	off		;shadow off

;	p_import	shape,kx_expshape
;	p_import	pword1,kx_exppath
	p_gosub		pword1
	p_end
;----------------------------------------
	start_path	kexp1
	P_TRIGGER	.add_tx,Always
	P_IGOTO		.pass
.add_tx
	P_ADD		tx,5
	P_RETURN
.pass
	start_path	kexp7
	start_path	kexp8
	start_path	kexp9
	start_path	kexp10
	p_set	worldz,600
	p_igoto		expset

	start_path	kexp2
	p_set	worldy,50
	p_set	worldz,300
	p_igoto		expset

	start_path	kexp3
	p_set	worldy,100
	p_set	worldz,500
	p_setanim	0
	p_igoto		expset

	start_path	kexp4
	p_set	worldy,70
	p_set	worldz,800
	p_igoto		expset

	start_path	kexp5
	p_set	worldz,100
	p_sprite	0,0		;[color,size]
	p_igoto		expset

	start_path	kexp6
	p_set	worldz,500
;	p_spawn	0,0,0,0,0,16,kurage_1_1,e_nocol_s_off,100,0,1
	p_igoto		expset

expset
.loop
	p_add	roty,4
	P_GOTO	.loop

;*************************************************************************
;*************************************************************************
;*************************************************************************
;========================================================================
	ifeq	1
	start_path	sprite_0
	p_sprite	0
	p_IGOTO		set
	start_path	sprite_1
	p_sprite	0,32
	p_igoto		set
	start_path	sprite_2
	p_sprite	0,64
set
	p_shadow	off
	p_collisions	off
	p_spawn		000,10,000,0,0,0,s_8,shadow_0,10,10
	p_end

;-------------- Child Path Data ------------------------------------
	start_path	shadow_0
	p_collisions	off
	p_end
	endc
;========================================================================
	ifeq	0
	start_path	sprite_0
	p_sprite	0
	p_collisions	off
	p_spawn		000,10,000,0,0,0,s_8,shadow_0,10,10
	p_end

	start_path	sprite_1
	p_collisions	off
	p_sprite	0,32
	p_spawn		000,15,000,0,0,0,s_8,shadow_0,10,10
	p_end

	start_path	sprite_2
	p_collisions	off
	p_sprite	0,64
	p_spawn		000,20,000,0,0,0,s_8,shadow_0,10,10
	p_end

;-------------- Child Path Data ---------------
	start_path	shadow_0
	p_shadow	off
	p_collisions	off
	p_end


	endc
;*********************************************************************
;*								*
;*			Friend Base Path Data 			*
;*								*
;*********************************************************************
	start_path	kbase0

	p_set		hp,100
	p_set		ap,0

;	p_spawn		000,040*2,000,0,0,0,daruma_0,daruhako0,50,0,1
;	p_spawn		000,060*2,000,0,0,0,daruma_1,daruhako1,50,0,2
;	p_spawn		000,080*2,000,0,0,0,daruma_0,daruhako0,50,0,3
;	p_spawn		000,095*2,000,0,0,0,daruma_0,daruhako0,50,0,4
;	p_spawn		000,115*2,000,0,0,0,daruma_1,daruhako0,50,0,5
;
	p_collisions	off
	p_end

;-------------- Child Path Data ---------------
	start_path	daruhako0
	start_path	daruhako1

	p_collisions	off
	p_end

;*********************************************************************
;*								*
;*			Enemy Zaco Path Data			*
;*								*
;*********************************************************************
;---------------------------------------------------------------------
;*			Zaco 5 Path Data			*
;---------------------------------------------------------------------
	start_path	kpzaco_5
	p_set		hp,50		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_setvel	30		;enemy velocity
	p_alwaysgenvecs	on		;vel to 3D vector

;;	P_WEAPON	laser2		;weapon kind

;;;;;	P_GOSUB		randomplayer	;player select
	p_player	1
.loop
	p_faceplayer			;turn player
	P_DISTLESS	2000,.dontswap
	P_SWAPPLAYER
.dontswap
	P_DO	15
	P_FACEPLAYER
	P_SET	rotx,0
	P_NEXT

	P_ADD		worldy,-50
	P_FIRE		ATPLAYER,CANHIT
	P_ADD		worldy,50
	P_GOTO	.loop

;---------------------------------------------------------------------
;*			Robot Path Data				*
;---------------------------------------------------------------------
	start_path	krobo_0

	p_set		hp,50		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_setvel	7		;enemy velocity
	p_alwaysgenvecs	on		;vel to 3D vector
;;;	P_WEAPON	laser2		;weapon kind
	P_shadow	on
;;;;;	P_GOSUB		randomplayer	;player select
	p_player	1
	p_trigger	.fire,32	;enemy fire

.loop
	P_DISTLESS	500,.DoNothing	;if player distance <500

	P_DISTLESS	2000,.dontswap	;if player distance <2000
	P_SWAPPLAYER

.dontswap

;**** Player Search ****
	P_DO	15
	P_FACEPLAYER
	P_SET	rotx,0
	P_NEXT

.DoNothing
	P_GOTO	.loop

;**** Laser Fire *****
.fire
	P_ADD		worldy,-50
	P_FIRE		ATPLAYER,CANHIT
	P_ADD		worldy,50
	p_return
;---------------------------------------------------------------------
;*			Gun Shot				*
;---------------------------------------------------------------------
	start_path	kgunshot_0

	p_set		hp,50		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_zero		pbyte1		;path pointer
	p_setvel	7		;enemy velocity
	p_alwaysgenvecs	on		;vel to 3D vector
;;	P_WEAPON	laser2		;weapon kind
	P_shadow	on		;shadow on/off
;;	P_GOSUB		randomplayer	;player select

.MainLoop
	P_DISTLESS	300,.LaserShot	;if player distance <300
	P_DISTLESS	2000,.dontswap	;if player distance <2000

;;;;;	P_SWAPPLAYER

;**** Player Search ****
.dontswap
;;;	p_set	shape,gun_walk
	p_setvel	7		;enemy velocity
	P_DO	15
	P_FACEPLAYER
	P_SET	rotx,0
	P_NEXT

	P_WAIT	20

;;;	p_set	shape,gun_walk
	p_setvel	0		;enemy velocity
	P_WAIT	5

	P_GOTO	.MainLoop

;***** Player Look ********
.PLayerLook
	p_setvel	2		;enemy velocity

;;;	p_set	shape,gun_look

	P_DO	15
	P_FACEPLAYER
	P_SET	rotx,0
	P_NEXT
	p_goto	.MainLoop

;**** Laser Shot *****
.LaserShot
.Loop_LaserShot

;;;	p_set	shape,gun_pose
	p_setanim	0

	p_do		17
	p_addanim	1,18
	p_next

	p_wait	8

;;;	p_set	shape,gun_shot
	p_setanim	0

	p_do		8
	p_addanim	1,8
	p_next
	p_gosub	.fire

	p_do		8
	p_addanim	1,8
	p_next
	p_gosub	.fire

	p_wait	20

	p_goto	.MainLoop


	ifeq	1
	p_index	pword1,.shottable,pbyte1
	p_gosub	pword1

	p_do		16
	p_addanim	1,16
	p_next
	P_GOTO	.Loop_LaserShot

.gun_look
	p_setvel	3		;enemy velocity
	p_set	pbyte1,1
;	p_set	shape,gun_look
	p_setanim	0
	P_return
.gun_pose
	p_set	pbyte1,2
;	p_set	shape,gun_pose
	p_setanim	0
	p_return
.gun_shot
;;	p_set	shape,gun_shot
	p_setanim	0
	p_return
	endc

;**** Laser Fire *****
.fire
	P_ADD		worldy,20
	P_FIRE		ATPLAYER,CANHIT
	P_ADD		worldy,-20
	p_return

	ifeq	1
.shottable
	dw	.gun_look&WM
	dw	.gun_pose&WM
	dw	.gun_shot&WM
	endc
;---------------------------------------------------------------------
;*			Batta Path Data				*
;---------------------------------------------------------------------
	start_path	kbatta_0

	p_set		hp,50		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
	p_setvel	7		;enemy velocity
	p_alwaysgenvecs	on		;vel to 3D vector
;;	P_WEAPON	laser2		;weapon kind
	P_shadow	on
	P_set		pbyte1,-32

;;;;;	P_GOSUB		randomplayer	;player select
	p_player	1
	p_trigger	.fire,32	;enemy fire

.loop
	P_DISTLESS	500,.Mov	;if player distance <500

	P_DISTLESS	2000,.dontswap	;if player distance <2000
	P_SWAPPLAYER
.dontswap

;**** Player Search ****
	P_DO	15
	P_FACEPLAYER
	P_SET	rotx,0
	P_NEXT
.mov
	P_ADD	worldy,pbyte1
	p_add	pbyte1,4
	P_ifnotsame	pbyte1,36,.DoNothing
	P_set	pbyte1,-32
.DoNothing
	P_GOTO	.loop

;**** Laser Fire *****
.fire
	P_ADD		worldy,-50
	P_FIRE		ATPLAYER,CANHIT
	P_ADD		worldy,50
	p_return

;---------------------------------------------------------------------
;*
;---------------------------------------------------------------------


;*********************************************************************
;*								*
;*			Enemy Boss Path Data			*
;*								*
;*********************************************************************
;========================= Duncing Insector ==========================
	start_path	dancing
	p_set		hp,100
	p_set		ap,0
	ifeq	1
	p_spawn		000,00,-48,0,72*0,0,boss_h_1,reg1,50,0,1
	p_spawn		028,30,040,0,72*1,0,boss_h_1,reg2,50,0,2
	p_spawn		-48,30,-16,0,72*2,0,boss_h_1,reg3,50,0,3
	p_spawn		048,30,-16,0,72*3,0,boss_h_1,reg4,50,0,4
	p_spawn		000,30,-48,0,72*4,0,boss_h_1,reg5,50,0,5
	
	p_spawn		0,5,0,0,0,0,boss_h_2,head1,50,0,6
	endc
	p_end

;--------------------------------------------------------------------
	start_path	reg1
	p_inc		pbyte1
	start_path	reg2
	p_inc		pbyte1
	start_path	reg3
	p_inc		pbyte1
	start_path	reg4
	p_inc		pbyte1
	start_path	reg5

	p_collisions	off
	p_trigger	.walk,Always
	p_end


.walk
	p_index		animframe,.regtable,pbyte1
	p_inc		pbyte1
	p_ifnotsame	pbyte1,10,.notsame

	p_zero		pbyte1
.notsame
	p_return

.regtable
	db	1+128,2+128,3+128,4+128,5+128
	db	6+128,5+128,4+128,3+128,2+128

;--------------------------------------------------------------------
	start_path	head1

	p_collisions	off
	p_end

;*********************************************************************
;*								*
;*			Recover HP Path Data 			*
;*								*
;*********************************************************************
	start_path	KBOXrecover
	start_path	test_whensteppedon
	p_set		hp,50		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point

	p_start65816
	s_clr_alsflag	x,notslope	;Slope
	p_end65816

;dono saka ni nokkateiruka wo check (saka niwa sorezore number ga aru)

	p_set	slopenum,1		;slope Noumber set
.Check_stepon
	P_trigger	.JmpStepOn,whensteppedon
	p_end

.JmpStepOn
	p_force		.StepOn
	p_return
;-------------------------------------
;*	If Step On		*
;-------------------------------------
.StepOn
	p_trigger	.StepOn,off

	p_ifplayer	2,.player2
.player1
	p_import	pbyte1,player1_hpadd
	p_add		pbyte1,1
	p_export	player1_hpadd,pbyte1	;plaer 1 HP recover
	p_igoto		.wait
.player2
	p_import	pbyte1,player2_hpadd
	p_add		pbyte1,1
	p_export	player2_hpadd,pbyte1	;plaer 2 HP recover

.wait	p_loop		10,.wait
	p_goto		.Check_stepon	
;*********************************************************************
;*								*
;*			Building Path Data 			*
;*								*
;*********************************************************************
	start_path	kbuild

	p_set		hp,10
	p_set		ap,0
	p_collisions	off
	p_end
;---------------------------------------------------------------------
	start_path	kisu_0

	p_set		hp,10
	p_set		ap,2
	p_collisions	off
;	p_spawn	-40*2,0,040*2,0,0,0,isu_0,kisu_sub0,10,10,1
;	p_spawn	040*2,0,040*2,0,0,0,isu_1,kisu_sub0,10,10,2
;	p_spawn	-40*2,0,-40*2,0,0,0,isu_2,kisu_sub0,10,10,3
;	p_spawn	040*2,0,-40*2,0,0,0,isu_3,kisu_sub0,10,10,4
;
	p_end
	p_end


	start_path	kisu_sub0
	p_set		hp,10
	p_set		ap,0
	p_collisions	off
	p_end



;*********************************************************************
;*								*
;*			Ring Path Data	 			*
;*								*
;*********************************************************************
	start_path	ktest1
	start_path	ktest2
	start_path	ktest3
	start_path	ktest4
	start_path	ktest5
	start_path	ktest6

	p_set		hp,10
	p_set		ap,2

	p_collisions	off

;	p_debris	training

	p_trigger	.Through_check,Always
	p_end
;---------------------------------------------------------------
.Through_check
	p_player	1
	P_WITHINRADIUS	80,.SkipPl1
	p_player	2
	P_WITHINRADIUS	80,.SkipPl2
	p_return

.SkipPl1
	p_force		.Through_player1
	p_return

.SkipPl2
	p_force		.Through_player2
	p_return
;------------------ Through Ring -------------------
.Through_player1
	p_trigger	.Through_check,off

;*** HP ADD ***
	p_import	pbyte1,player1_hpadd
	p_add		pbyte1,1
	p_export	player1_hpadd,pbyte1

	p_score		100
;	P_SOUNDEFT	CatchMedal	;$10
	p_set	coltab,id_0_c

;	p_particles
;	p_gosub		.rot
;	p_trigger	.Through_check,Always
	p_end

.Through_player2
	p_trigger	.Through_check,off

;*** HP ADD ***
	p_import	pbyte1,player2_hpadd
	p_add		pbyte1,1
	p_export	player2_hpadd,pbyte1

	p_score		100
;	P_SOUNDEFECT	CatchMedal	;$10
	p_set	coltab,id_1_c

	p_particles

;	p_gosub		.rot

;	p_trigger	.Through_check,Always
	p_end


.rot	
	p_do		16
	p_add		roty,32
	p_next

	p_return
;*************************************************************
;*			KRING				*
;*************************************************************
	start_path	kring
	p_set		hp,10
	p_set		ap,10
	p_collisions	off	;collision OFF

	p_trigger	.Through_check,whenthrough
	p_end
;-----------------------------------------------------
;*		Ring Through Check		*
;-----------------------------------------------------
.Through_check
	p_player	1
	P_WITHINRADIUS	80,.SkipPl1
	p_player	2
	P_WITHINRADIUS	80,.SkipPl2
	p_return

.SkipPl1
	p_force		.Through_player1
	p_return

.SkipPl2
	p_force		.Through_player2
	p_return
;-----------------------------------------------------
;*		Player1		[Ring Through]	*
;-----------------------------------------------------
.Through_player1
	p_trigger	.Through_check,off

;---- HP Restore ----
	p_import	pbyte1,player1_hpadd
	p_add		pbyte1,1
	p_export	player1_hpadd,pbyte1

;---- score ---
;	p_import	pword1,kplayer1score
;	p_add		pword1,100
;	p_export	kplayer1score,pword1

	p_score		100
;--- sound set ---
;	P_SOUNDEFFECT	CatchMedal	;$1b

;--- color ID change ---
	p_set	coltab,id_0_c

	p_gosub		.rot
	p_trigger	.Through_check,Always
	p_end

;-----------------------------------------------------
;*		Player2		[Ring Through]	*
;-----------------------------------------------------
.Through_player2
	p_trigger	.Through_check,off

;---- HP Restore -----
	p_import	pbyte1,player2_hpadd
	p_add		pbyte1,1
	p_export	player2_hpadd,pbyte1
;---- score ---
;	p_import	pword1,kplayer2score
;	p_add		pword1,100
;	p_export	kplayer2score,pword1

	p_score		100
;--- sound set ---
;	P_SOUNDEFFECT	CatchMedal	;$1b

;--- color ID change ---
	p_set	coltab,id_1_c

	p_gosub		.rot

	p_trigger	.Through_check,whenthrough
	p_end
;-----------------------------------------------------
;*	Ring Rotation sub routine		*
;-----------------------------------------------------
.rot	
	p_do		16
	p_add		roty,32
	p_next

	p_return

;*************************************************************
;*			KRING2				*
;*************************************************************
	start_path	kring2
	p_set	hp,50
	p_set	ap,0
	p_invincible	on
;;;	p_spawn		0,0,0,0,0,0,training,kring_sub,4,2,link	

	p_trigger	.Through_check,whenthrough
	p_end

;--------------------------------------------------------------------
.Through_Check

	p_player	1
	p_withinradius	30,.P1Hitjump

	p_player	2
	p_withinradius	30,.P2Hitjump
	p_return
.P1Hitjump
	p_force		.P1Hit
	p_return
.P2Hitjump
	p_force		.P2Hit
	p_return


.P1Hit
	p_trigger	.Through_check,off

	p_import	pbyte2,kbyte1
	p_inc		pbyte2
	p_export	kbyte1,pbyte2
	

	p_shapedead	.dontdo1
	p_becomeshape
	p_set	coltab,id_0_c
	p_set	pbyte1,1
	p_unbecome
.dontdo1
	p_wait		30

	p_trigger	.Through_check,whenthrough
	p_end
.P2Hit
	p_trigger	.through_check,off

	p_import	pbyte2,kbyte2
	p_inc		pbyte2
	p_export	kbyte2,pbyte2

	p_shapedead	.dontdo2
	p_becomeshape
	p_set	coltab,id_1_c
	p_set	pbyte1,1
	p_unbecome
.dontdo2
	p_wait		30

	p_trigger	.Through_check,whenthrough
	p_end


;-------------------------------------------------------------------
;kitem
 	start_path	kring_sub
	p_invincible	on	
	p_collisions	off   

.loop
	p_ifsame	pbyte1,1,.rot
	p_goto		.loop


.rot
		p_do	10	
		p_add	roty,16
		p_next

		P_zero	pbyte1

		p_goto		.loop

;============================= KRING 3 ===============================
	start_path	kring3

	start_path	kring4

	start_path	kring5

	p_set		hp,10
	p_set		ap,2

	p_collisions	off

	p_trigger	.through_check,whenthrough
.mov
	p_do		25
	p_add		worldy,-16
	p_next

	p_wait		10

	p_do		25
	p_add		worldy,16
	p_next

	P_goto		.mov
;---------------------------------------------------------------
.Through_check
	p_player	1
	P_WITHINRADIUS	50,.SkipPl1
	p_player	2
	P_WITHINRADIUS	50,.SkipPl2
	p_return


.SkipPl1
	p_force		.Through_player1
	p_return

.SkipPl2
	p_force		.Through_player2
	p_return
;------------------ Through Ring -------------------
.Through_player1
	p_trigger	.Through_check,off

;---- HP Restore --------------------------------------------------------
	p_start65816

	phb
	db7e
	s_set_objtobeplayer1	x	;player1 pointer

	lda	al_hp,x
	clc
	adc	#04
	cmp	#41
	bpl	.P1Hp_over
	sta	al_hp,x
	
;	km_plheapptr	1,x
;	setflag		KHITFLASH,#$80,x	;Flag:Copy CGX data to Maio RAM
.P1Hp_over
	plb
	p_end65816
;------------------------------------------------------------------------

	p_import	pbyte2,kbyte1
	p_inc		pbyte2
	p_export	kbyte1,pbyte2

	p_score		100
;	P_SOUNDEFFECT	CatchMedal	;$10
	p_set	coltab,id_0_c

	p_gosub		.rot
	p_trigger	.Through_check,whenthrough
	p_end

.Through_player2
	p_trigger	.Through_check,off
;---- HP Restore --------------------------------------------------------
	p_start65816

	phb
	db7e
	s_set_objtobeplayer2	x	;player2 pointer

	lda	al_hp,x
	clc
	adc	#04
	cmp	#41
	bpl	.P2Hp_over
	sta	al_hp,x
	
;	km_plheapptr	2,x
;	setflag		KHITFLASH,#$80,x	;Flag:Copy CGX data to Maio RAM
.P2Hp_over
	plb
	p_end65816
;------------------------------------------------------------------------
	p_import	pbyte2,kbyte2
	p_inc		pbyte2
	p_export	kbyte2,pbyte2

	p_score		100
;	P_SOUNDEFFECT	CatchMedal	;$10
	p_set	coltab,id_1_c
	p_gosub		.rot

	p_trigger	.Through_check,whenthrough
	p_end


.rot	
	p_do		16
	p_add		roty,32
	p_next

	p_return
;*********************************************************************
;*			ITEM PATH Data				*
;*								*
;*********************************************************************

	start_path	kg_coin_0
;Initial
	p_set		hp,80		;enemy Hit Point
	p_set		ap,0		;enemy Attack Point
;	p_collisions	off
	P_shadow	off	;shadow

	p_trigger	.hit,whenhit
	p_spawn		000,0,000,0,0,0,s_4,shadow_1,10,10

	P_END
	P_END

.hit	p_force		.forcejmp_hit
	p_return

.forcejmp_hit
	p_do	32
	p_add	roty,16
	p_next
	p_end
;-------------- Child Path Data ---------------
	start_path	shadow_1
;;;;	p_shadow	on
	p_collisions	off
	p_end

