;-------------------------------------------------------------------;
;                                                                   ;
;                    STARFOX II - THE SEQUEL                        ;
;                                                                   ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -;
;                                                                   ;
; FILE:         MMTBL.ASM                                           ;
; AUTHOR:       YASUHIRO KAWAGUCHI                                  ;
; DESCRIPTION:  Mario Chip tono Parallel Program                    ;
; DATE CREATED: 09-9-94                                             ;
;                                                                   ;
;-------------------------------------------------------------------;
	INCPUB	mmtbl

;*********************************************************************
;*								*
;*		Mario Progame Paralell Start			*
;*								*
;*********************************************************************
mm_startmario_l
	shorta
	longi
;---------------------------------------------
* 	Mario Program Start		*
;---------------------------------------------
.callmario
	nastyon		;ROM & RAM Nasty ON
	lda	#MMakePlanet>>16
	sta.l	mcodebank
 	a16
	lda	#MMakePlanet&WM
	sta.l	mr15	; GO!
	km_clrmismapstflag	noirqsyori	;[1 frame syori Enable]
	a8
;---------------------------------------------
;*	WAIT Mario Draw			*
;---------------------------------------------
;* Mario Wait *
	km_waitmario
	nastyoff	;ROM & RAM Nasty OFF
	rtl

;*********************************************************************
;*								*
;*		Game Frame Routine Start  [Running On RAM]	*
;*								*
;*********************************************************************
mm_GameFrameRAMRoutine_l
	shorta
	longi
	km_bitcheckmismapstflag	gmframesyori
	beq	.end
;-----------------------------------------------------
;* Enemy Appear *
	jsr	mm_StepUpEnemyAppear
;	jsr	mm_GuardEnemyAppear
	jsr	mm_SOSEnemyAppear
	jsr	mm_sosenemycollision
;-----------------------------------------------------
.end
	rtl

;*********************************************************************
;*								*
;*		One Frame Routine Start  [Running On RAM]	*
;*								*
;*********************************************************************
mm_OneFrameRAMRoutine_l
	shorta
	longi
	jsr	mm_sosenemymove
	rtl

;*********************************************************************
;*								*
;*		Paralell Routine Start  [Running On RAM]	*
;*								*
;*********************************************************************
Parallel_mismap_l
	shorta
	longi
	storenasty
	nastyon		;ROM & RAM Nasty ON
	ai16
	km_bitcheckflag	kw_Gameflag,(kgf_keydisable!kgf_test!kgf_freeze)
	bne	.end
	km_bitcheckflag	kw_missionflag,kmif_parallel
	beq	.end
	km_bitcheckflag	kw_missionflag,kmif_enemymove
	beq	.end
;-----------------------------------------------------
	a8
	phb
	lda	#$7e
	pha
	plb
;* Enemy Appear *
	jsr	mm_StepUpEnemyAppear
	jsr	mm_SOSEnemyAppear
;* Enemy Move *
	jsr	mm_sosenemymove
;* Enemy Collision Check *
	jsr	mm_sosenemycollision

	plb
;-----------------------------------------------------
.end
	a8
	restorenasty
	rtl
;*********************************************************************
;*		Enemy Stack Up					*
;* Input  :Yreg <<< Enemy List Pointer				*
;* OutPut :Acc  <<< Stack Number					*
;*********************************************************************
mm_setenstack
	phx
	php
	a8
	longi
;* search stack buffer *
	km_hib0
	ifne	debuginfo
	lda	#16
	sta	kz_x1
	endc

	ldx	kx_stackbaseptr
.loop_search
	lda	kx_stackbuffer,x
	beq	.found_emptybox

	ifne	debuginfo
	dec	kz_x1
	km_beq	mm_blink3
	endc
	a16
	txa
	inc	a
	and	#$f
	tax
	a8
	bra	.loop_search

.found_emptybox
	inc	a
	sta	kx_stackbuffer,x
	txa	;Acc <<< Xreg
	sta	kx_stackbaseptr
	plp
	plx
	rts
;*********************************************************************
;*								*
;*		Step Up Enemy Appear				*
;* Data Bank :7e							*
;*********************************************************************
mm_StepUpEnemyAppear
	php
;* Step Up Enemy Appear Check *
	a16
	ldx	kx_planetlistptr
.loop
	km_loblda.w	mmx_pstepup,x
	asl	a
	txy
	tax
	jsr	(.stepuptbl,x)
.nextplanet
	lda.w	mmx_planetnext,x
	tax
	cpx	kx_corneriaptr	;check suru planet = corneria 
	bne	.loop
.end
	plp
	rts
;-------------------------------------------------------------------------
.stepuptbl
	dw	stepup_nothing&WM
	dw	stepup_init&WM
	dw	stepup_wait&WM
	dw	stepup_born&WM
	dw	stepup_appeardemo&WM
	dw	stepup_move&WM
	dw	stepup_attackplanet&WM
	dw	stepup_enterdemo&WM
	dw	stepup_enterdemo2&WM
	dw	stepup_enterplanet&WM
	dw	stepup_dokuro&WM
	dw	stepup_battleplayer&WM
;=====================================================================
;*								*
;*		Step Up Enemy Sub Sequence			*
;*								*
;=====================================================================
stepup_nothing
	longa
	tyx
	rts
;-------------------------------------------------
stepup_init
	longa
	tyx
;* step up no stock ga nakereba *
	lda	kx_stepupstock
	beq	.skip_init	;StepUp no zaico nashi
;* enemy total no kazu >= 8 (8 piki ijyou deteireba)*
	km_cmpcheck	kx_enemytotal,mm_enemymax	;(kalcs.inc)
	bpl	.skip_init
;** Step Up Initial *
	phx
	ldx	kdifficulty
	lda.l	.stupappeartmtbl,x
	plx
	km_loba
	sta.w	mmx_stupwaittm,x
	inc.w	mmx_pstepup,x

;* step up no stock wo 1tu herasu (1994/12/25 :henkou) *
;;;	dec	kx_stepupstock

.skip_init
	rts

.stupappeartmtbl
	db	stup_appeartmEasy	
	db	stup_appeartmNormal
	db	stup_appeartmHard	
;-------------------------------------------------
stepup_wait
	longa
	longi
	tyx
	jsr	stepupwait
	rts
;-------------------------------------------------
stepup_born
	longa
	tyx
	jsr	bornstepup
	inc.w	mmx_pstepup,x
;* zaico wo herasu !! *
	dec	kx_stepupstock
	rts
;-------------------------------------------------
stepup_appeardemo
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx
	jsr	stepupwait
	bcc	.wait

	lda.w	mmx_stupenlistptr,x
	tay
	lda	#0
	sta.w	mmx_enanmpatt,y
	sta.w	mmx_enanmtm,y
	lda	#enstrat_searchplanet
	sta.w	mmx_enstratptr,y
	km_clrflag16.w	mmx_enflags,(enfl_demo!enfl_nocollision),y
	jsr	calc_enangvelxy
.wait
	rts
;-------------------------------------------------
stepup_move
	longa
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx
	lda.w	mmx_stupenlistptr,x
	tay
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	stup_battleplayer_sub

	km_bitcheckflag.w	mmx_enflags,enfl_arrive,y
	bne	..attackplanet
	rts
;---------- Attack Planet ------------
..attackplanet
	km_bitcheckmistotalflag	explain1
	beq	.normal
.explain
	lda	#3*8
	bra	.skip
.normal
	lda	#10*8
.skip
	sta.w	mmx_stupwaittm,x

	lda	#stup_attackplanet
	sta.w	mmx_pstepup,x
;* stratage pointer *
	lda	#enstrat_aroundplanet
	sta.w	mmx_enstratptr,y
	rts

stup_battleplayer_sub
	lda	#0
	sta.w	mmx_enanmpatt,y
	sta.w	mmx_enanmtm,y

	lda.w	mmx_pstepup,x
	sta.w	mmx_pstepup_bak,x
	lda.w	mmx_enstratptr,y
	sta.w	mmx_enstratptr_bak,y

	lda	#enstrat_nothing	;battleplayer
	sta.w	mmx_enstratptr,y
	lda	#stup_battleplayer
	sta.w	mmx_pstepup,x
	rts
;-------------------------------------------------
stepup_attackplanet
	longa
; Xreg :Enemy  List Pointer
; Yreg :Planet List Pointer 
	longa
	tyx
	lda.w	mmx_stupenlistptr,x
	tay
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	stup_battleplayer_sub

	jsr	stepupwait
	bcc	.wait_end3
	lda	#enstrat_enterplanet	;nothing
	sta.w	mmx_enstratptr,y
	km_setflag16.w	mmx_enflags,(enfl_nocollision!enfl_StupEnterAnm),y	;!enfl_demo

;;;	lda	#0
;;;	sta.w	mmx_work1,y
;;;	lda	#8-1
;;;	sta.w	mmx_stupwaittm,x
.wait_end3
	rts
;-------------------------------------------------
stepup_enterdemo
	tyx
	lda.w	mmx_stupenlistptr,x
	tay
	km_bitcheckflag16.w	mmx_enflags,enfl_StupEnterAnm,y
;;;;	jsr	stepupwait
	bne	.wait_end4
	lda	#6-1
	sta.w	mmx_stupwaittm,x
	lda	#stup_enterdemo2
	sta.w	mmx_pstepup,x
	lda	#cd_objanime_sosplanein
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y
	km_setflag16.w	mmx_enflags,enfl_demo,y
	km_setflag16	kw_mmsoundflag,mmsndf_stupin
.wait_end4
	rts
;-------------------------------------------------
stepup_enterdemo2
	tyx
	jsr	stepupwait
	bcc	.wait_end
.wait_end
	rts
;-------------------------------------------------
stepup_enterplanet
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx
	km_clrflag16.w	mmx_planetflag,mmpnf_neutral,x
	km_setval.w	mmx_pstepup,stup_dokuro,x
	km_setval.w	mmx_dokuroanm,1,x

;* planet skill *
	jsl	ksetplanetskill_l

	phx
	km_loblda.w	mmx_stage,x
	asl	a
	tax
	lda.L	sosbittbl,x
	ora	mmx_planet_stepup
	sta	mmx_planet_stepup
	plx

;* guard enemy trigger *
	km_setflag16.w	mmx_planetflag,mmpnf_guardappear,x
	km_setval.w	mmx_pguard,guard_init,x

;* StepUpEnemy disappear *
	a16
	lda.w	mmx_stupenlistptr,x
	tay
	jsl	mm_freeenemylistptr_l
	rts

;-------------------------------------------------
stepup_dokuro
	tyx
	rts
;-------------------------------------------------
stepup_battleplayer
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx
	lda.w	mmx_stupenlistptr,x
	tay
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	..battleplayer_skip

	lda.w	mmx_pstepup_bak,x
	sta.w	mmx_pstepup,x
	lda.w	mmx_enstratptr_bak,y
	sta.w	mmx_enstratptr,y

..battleplayer_skip
	rts

;=====================================================================
;*		Step Up Enemy List Initial Set			*
;* moshi StepUp enemy ga APPEAR shitara				*
;* Init :Xreg :Appear Planet Popinter				*
;*      :Yreg :Enemy Popinter					*
;=====================================================================
bornstepup
	longa
	longi
	PHP
	phx
;* enemy dest planet list pointer *
	stx	mmx_enemydestptr

;* Enemy List Poinrter Get *
;Yreg <--- Enemy List Pinter
	jsr	mm_getenemylistptr

;* Enemy Appear Demo Initial *
	tya
	sta.w	mmx_stupenlistptr,x
	lda	#17-1
	sta.w	mmx_stupwaittm,x
;* flag *
	km_setflag16.w	mmx_enflags,(enfl_stepup!enfl_demo!enfl_nocollision),y
	km_setflag16	kw_mmsoundflag,mmsndf_stupappear
;* dest *
	lda	mmx_enemydestptr
	sta.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest
;---------------------
;* source postion *
	km_bitcheckmistotalflag	explain1
	beq	.normal
.explain
	a8
	lda.w	mmx_planetcx,x
	cmp	#$80
	bcs	.hoseileft_demo
.hoseiRight_demo
	clc
	adc	#$20
	bra	.SetXpos_demo
.hoseileft_demo
	sec
	sbc	#$20
.SetXpos_demo
	sta.w	mmx_enposx+1,y

	lda.w	mmx_planetcy,x
	sta.w	mmx_enposy+1,y
	a16
	lda	#256*8		;(kgamelist.inc)
	sta.w	mmx_envel,y	;velocity
	bra	.skip_source
;----------------------
.normal
	km_loblda.w	mmx_stage,x
	asl	a
	tax
	lda.L	sosbittbl,x
	ora	mmx_message_stepup
	sta	mmx_message_stepup

;* source * <<<<
;;;	lda	kw_RandomPtr
	jsl	KGetRandomPtr_l
	and	#3
	asl	a
	tax
	lda.l	StepupAppearPoTbl,x
	sta.w	mmx_enposx+1,y		;postion X
	lda.l	StepupAppearPoTbl+1,x
	sta.w	mmx_enposy+1,y		;postion Y

	a16
	lda	#stup_speed1	;(kgamelist.inc)
	sta.w	mmx_envel,y	;velocity
.skip_source
;---------------------
;* velocity (x,y) *
	jsr	calc_enangvelxy
;* battle stage *
	a8
	lda	#stg_sos2
	sta.w	mmx_enstage,y
;* skill *
	jsr	setstupenemyskill
;* stack *
	jsr	mm_setenstack
	sta.w	mmx_enstackptr,y
;* Enemy Type *
	lda	#entyp_stepup1
	sta.w	mmx_entype,y	;sos type
;* Character No *
	lda	#0
	sta.w	mmx_enanmptr,y
;;;	lda	#obj_stepup		;lda.l	mm_enemychart+6,x
;;;	sta.w	mmx_enchrbase,y		;character Base No

;* Sprite Animation *
	lda	#cd_objanime_stepup
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y

;* stratage pointer *
	lda	#enstrat_stepupappear
	sta.w	mmx_enstratptr,y

;* collision *
	lda	#stup_collision
	sta.w	mmx_encoll,y		;collision
	plx
	PLP
	rts


StepUpSkillOffset
	db	stupoff_easy
	db	stupoff_normal
	db	stupoff_hard

StepupAppearPoTbl
	db	stepup_posx1
	db	stepup_posy1
	db	stepup_posx2
	db	stepup_posy2
	db	stepup_posx3
	db	stepup_posy3
	db	stepup_posx1
	db	stepup_posy1

	IFEQ	1
EnStUpListTable
	dw	128
	db	stg_sos2
	db	cd_objanime_stepup
	db	enstrat_stepupappear
EnSOSListTable
	dw	128
	db	stg_sos2
	db	cd_objanime_stepup
	db	enstrat_stepupappear
	ENDC


;=====================================================================
;*		Step Up Wait					*
;=====================================================================
stepupwait
	longa
	longi
	lda	#1
	jsl	kspeedupA_l
	sta	kz_x1
	lda.w	mmx_stupwaittm,x
	sec
	sbc	kz_x1
	sta.w	mmx_stupwaittm,x
	beq	.finish_wait
	bpl	.wait_end
.finish_wait
	inc.w	mmx_pstepup,x
	sec
	rts
.wait_end
	clc
	rts




;*********************************************************************
;*								*
;*		Guard Enemy Appear				*
;* Data Bank :7e							*
;*********************************************************************
mm_GuardEnemyAppear
	php
;* Step Up Enemy Appear Check *
	a16
	ldx	kx_planetlistptr
.loop
	km_loblda.w	mmx_pguard,x
	asl	a
	txy
	tax
	jsr	(.guardtbl,x)
.nextplanet
	lda.w	mmx_planetnext,x
	tax
	cpx	kx_corneriaptr	;check suru planet = corneria 
	bne	.loop
.end
	plp
	rts
;-------------------------------------------------------------------------
.guardtbl
	dw	guardseq_nothing&WM
	dw	guardseq_init&WM
	dw	guardseq_wait&WM
	dw	guardseq_born&WM
	dw	guardseq_appeardemo&WM
	dw	guardseq_ready&WM
	dw	guardseq_fire&WM
	dw	guardseq_disappear&WM

;=====================================================================
;*								*
;*		Guard Enemy Sub Sequence			*
;*								*
;=====================================================================
guardseq_nothing
	longa
	tyx
	rts
;---------------------------------------------------------------------
guardseq_init
	longa
	tyx
;* enemy total no kazu >= 8 (8 piki ijyou deteireba) *
	km_cmpcheck	kx_enemytotal,mm_enemymax	;(kalcs.inc)
	bpl	.end
	km_bitcheckflag.w	mmx_planetflag,(mmpnf_neutral!mmpnf_freeze),x
	bne	.end
	lda	#8*5*1
	sta.w	mmx_guardwaittm,y
	km_setval.w	mmx_pguard,guard_wait,x
	km_setflag16.w	mmx_planetflag,mmpnf_guardappear,x
.end
	rts
;---------------------------------------------------------------------
guardseq_wait
	longa
	tyx
	jsr	guardwait
	rts
;---------------------------------------------------------------------
guardseq_born
	longa
	tyx
	jsr	mm_initguardlist
	inc.w	mmx_pguard,x
	rts
;---------------------------------------------------------------------
guardseq_appeardemo
	longa
	tyx
	jsr	guardwait
	bcc	.wait_skip

	lda.w	mmx_guardenlistptr,x
	tay
	lda	#enstrat_nothing
	sta.w	mmx_enstratptr,y	;stratage pointter
	lda	#8*5*1
	sta.w	mmx_guardwaittm,y
.wait_skip
	rts
;---------------------------------------------------------------------
guardseq_ready
	longa
	tyx
	jsr	guardwait
	bcc	.wait_skip

	lda	#idx_wipebeam_open
	sta	wipestruct

	inc.w	mmx_pguard,x
	km_setval	kwork+28,3*60
	km_setmismapsyori	beem
	lda	#5*1
	sta.w	mmx_guardwaittm,y
.wait_skip
	rts
;---------------------------------------------------------------------
guardseq_fire
	longa
	tyx
	jsr	guardwait
	bcc	.wait_skip
	inc.w	mmx_pguard,x
.wait_skip
	rts
;---------------------------------------------------------------------
guardseq_disappear
	longa
	tyx
	lda.w	mmx_guardenlistptr,x
	tay
	jsl	mm_freeenemylistptr_l

	km_setval.w	mmx_pguard,guard_nothing,x
	lda	#0
	sta	wipestruct
	rts
;---------------------------------------------------------------------

;=====================================================================
;*		Guard Enemy List Initial Set			*
;* moshi Guard enemy ga APPEAR shitara				*
;* Init :Xreg :Appear Planet Popinter				*
;*      :Yreg :Enemy Popinter					*
;=====================================================================
mm_initguardlist
	php
	PHX
	ai16
;* get enemy list memory *
;Yreg <--- Enemy List Pinter
	jsr	mm_getenemylistptr
;* Enemy Appear Demo Initial *
	tya
	sta.w		mmx_guardenlistptr,x	;Enemy List Pointer
	lda	#10-1
	sta.w	mmx_guardwaittm,x
;* source * <<<<
	txa
	sta.w	mmx_ensourplanetptr,y
	km_lobswaplda.w	mmx_planetcx,x
	sta	kz_x1
	km_lobswaplda.w	mmx_planetcy,x
	sta	kz_y1

	lda	kz_x1
	sta.w	mmx_enposx,y		;postion X
	lda	kz_y1
	sta.w	mmx_enposy,y		;postion Y
;* flag *
	km_setflag16.w	mmx_enflags,(enfl_nocollision!enfl_demo),y
	km_setflag16	kw_mmsoundflag,mmsndf_sosappear
;* dest *
	lda	mmx_enemydestptr
	sta.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest

;* velocity *
	lda	#sos_appearspeed
	sta.w	mmx_envel,y	;velocity
	jsr	calc_enangvelxy

;* battle stage *
	a8
	lda	#stg_sos1
	sta.w	mmx_enstage,y

;* skill *
	PHY		;>>> PUSH Y
	a16
	lda.w	mmx_ensourplanetptr,y
	tax
	lda	#0
	PLY		;<<< PULL Y
	sta.w	mmx_enskill,y
;* stack *
	jsr	mm_setenstack
	sta.w	mmx_enstackptr,y


	lda	#8
	sta.w	mmx_entype,y	;guard type
	asl	a
	tax
	lda.l	sosbittbl,x
	sta	mmx_sosappear

;* Sprite Animation *
	a16
	lda	#cd_objanime_sos1
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y
	a8
;* Enemy Stratage *
	lda	#enstrat_sosappear
	sta.w	mmx_enstratptr,y	;stratage pointter

;* collision *
	lda	#sos_collision
	sta.w	mmx_encoll,y		;collision
;* muteki Timer *
	lda	#3
	sta.w	mmx_eninvtm,y
;--------------------------------------------------------------------
.end
	PLX
	plp
	
	rts
;=====================================================================
;*			Guard Appear Wait			*
;* Xreg:Planet Pointer						*
;=====================================================================
guardwait
	longa
	longi
	lda	#1
	jsl	kspeedupA_l
	sta	kz_x1
	lda.w	mmx_guardwaittm,x
	sec
	sbc	kz_x1
	sta.w	mmx_guardwaittm,x
	beq	.finish_wait
	bpl	.wait_end
.finish_wait
	inc.w	mmx_pguard,x
	sec
	rts
.wait_end
	clc
	rts

;*********************************************************************
;*								*
;*		SOS Enemy Appear				*
;* Data Bank :7e							*
;*********************************************************************
mm_SOSEnemyAppear
	shorta
	longi
	php
;* Step Up Enemy Appear Check *
	a16
	ldx	kx_planetlistptr
.loop
	cpx	kx_corneriaptr
	km_beq	.end
	km_loblda.w	mmx_psos,x
	asl	a
	txy
	tax
	jsr	(.sostbl,x)
.nextplanet
	lda.w	mmx_planetnext,x
	tax
	bra	.loop
.end
	plp
	rts
;----------------------------------------------------------------------
.sostbl
	dw	sosseq_nothing&WM
	dw	sosseq_init_time&WM
	dw	sosseq_wait&WM
	dw	sosseq_born&WM
	dw	sosseq_appeardemo&WM
	dw	sosseq_move&WM
	dw	sosseq_battleplayer&WM
	dw	sosseq_attackcorneria&WM
	dw	sosseq_explodedemo&WM
	dw	sosseq_disappear&WM


;=====================================================================
;*								*
;*		SOS Enemy Sub Sequence				*
;*								*
;* Xreg :Planet List Pointer 					*
;* Yreg :Enemy  List Pointer						*
;=====================================================================
sosseq_nothing
	longa
	tyx
	rts
;----------------------------------------------------------------------
sosseq_init_time
	longa
	tyx
;* step up no stock ga nakereba *
	lda	kx_clrenemytotal
	beq	.skip_init		;Game Clear ni nattar !!
;* enemy total no kazu >= 8 (8 piki ijyou deteireba)*
	km_cmpcheck	kx_enemytotal,mm_enemymax	;(kalcs.inc)
	bpl	.skip_init
	km_bitcheckflag.w	mmx_planetflag,(mmpnf_neutral!mmpnf_sosappear!mmpnf_freeze),x
	bne	.skip_init
;***** Initial *******
	longa
	km_bitcheckflag	kx_demoflag,demof_sosappear
	beq	..normal
..explain
	lda	#sos_demoappeartm
	sta.w	mmx_soswaittm,x
	km_clrflag16	kx_demoflag,demof_sosappear
	bra	..skip1
..normal
	txy		;>>>> PUSH X
	ldx	kdifficulty
	lda.l	SOSAppeartmBase,x
	clc
	adc.w	mmx_stage,y	;Mission Stage Number
	km_loba
	asl	a
	tax
	lda.l	SOSappeartmtbl,x
	sta.w	mmx_soswaittm,y
	tyx		;<<<< PULL X
..skip1
	km_setflag16.w	mmx_planetflag,mmpnf_sosappear,x
	inc.w	mmx_psos,x
.skip_init
	rts
;-------------------------------------------------
sosseq_wait
	longa
	tyx
	km_bitcheckflag.w	mmx_planetflag,mmpnf_freeze,x
	bne	..skip_wait

	jsr	soswait

;;;;	km_bitcheckflag.w	mmx_planetflag,mmpnf_neutral,x
;;;;	beq	..skip_wait
;;;;	km_clrflag16.w	mmx_planetflag,mmpnf_sosappear,x
;;;;	lda	#sos_inittime
;;;;	sta.w	mmx_psos,x

..skip_wait
	rts
;-------------------------------------------------
sosseq_born
	longa
	tyx
	jsr	mm_initsoslist
	inc.w	mmx_psos,x
	rts
;-------------------------------------------------
sosseq_appeardemo
	longa
	tyx
	jsr	soswait
	bcc	.wait_end2

	lda.w	mmx_sosenlistptr,x
	tay
;* Explain Demo Start Trigger *
	km_bitcheckmistotalflag	explain1
	beq	..skip2
	km_setval	kx_demonumber,demo_explainstart	;[explain start ON]
	km_setflag16	kw_mismapfreezeflag,kfz_syorifreeze	;[stratage off]
..skip2
;* SOS Move Parameters Set *
	jsr	InitSOSmoveParams
.wait_end2
	rts
;-------------------------------------------------
sosseq_move
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx
	lda.w	mmx_sosenlistptr,x
	tay
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	battleplayer_sub

	km_bitcheckflag.w	mmx_enflags,enfl_attackcorneria,y
	bne	..attackcorneria_sub

	rts

..attackcorneria_sub
	km_loblda.w	mmx_entype,y	;sos type
	lsr	a
	asl	a
	sta	kz_x1
	cmp	#ENTYP_missile1
	beq	.missile
.normal
	km_setflag16	mmx_message_sos,mesosfl_attackcorneria	;[for yajima's]
	bra	.skip1
.missile
	km_setflag16	mmx_message_sos,mesosfl_missileattack	;[for yajima's]
	km_setflag16.w	mmx_enflags,enfl_nocollision,y
.skip1
	phy		;>>>> push Y
	txy		;>>>> push X
	ldx	kz_x1
	lda.l	attacktmtbl,x
	sta.w	mmx_soswaittm,y
	lda.l	attackpointbl,x
	sta.w	mmx_sosattackpo,y
	lda.l	enemystrattbl,x
	tyx		;<<<< pull X
	ply		;<<<< pull Y
	a8
	sta.w	mmx_enstratptr,y

	a16
	km_setval.w	mmx_sosattacktm,15,x	;ikirari damage
	lda	#sos_attackcorneria
	sta.w	mmx_psos,x
;* Corneria Damage *
	jsr	DecCorneriaHP
	rts

battleplayer_sub
	lda	#0
	sta.w	mmx_enanmpatt,y
	sta.w	mmx_enanmtm,y

	lda.w	mmx_psos,x
	sta.w	mmx_psos_bak,x
	lda.w	mmx_enstratptr,y
	sta.w	mmx_enstratptr_bak,y

	lda	#enstrat_nothing	;battleplayer
	sta.w	mmx_enstratptr,y
	lda	#sos_battleplayer
	sta.w	mmx_psos,x
	rts
;-------------------------------------------------
sosseq_battleplayer
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx
	lda.w	mmx_sosenlistptr,x
	tay
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	..battleplayer_skip
	lda.w	mmx_psos_bak,x
	sta.w	mmx_psos,x
	lda.w	mmx_enstratptr_bak,y
	sta.w	mmx_enstratptr,y

..battleplayer_skip
	rts
;-------------------------------------------------
sosseq_attackcorneria
; Xreg :Enemy  List Pointer
; Yreg :Planet List Pointer 
	longa
	tyx
	lda.w	mmx_sosenlistptr,x
	tay
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	battleplayer_sub

	jsr	soswait
	bcs	Self_destruction
	jsr	DecCorneriaHP
	rts

Self_destruction
	longa
	longi
	lda.w	mmx_sosenlistptr,x
	tay
	lda	#cd_objanime_sosbomb
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y
	lda	#enstrat_nothing
	sta.w	mmx_enstratptr,y
	km_setflag16.w	mmx_enflags,(enfl_nocollision!enfl_demo),y

	lda	#6-1
	sta.w	mmx_soswaittm,x
	lda	#sos_explodedemo
	sta.w	mmx_psos,x
	rts
;-------------------------------------------------
sosseq_explodedemo
	tyx
	jsr	soswait
	bcc	.wait_end4
.wait_end4
	rts
;-------------------------------------------------
sosseq_disappear
; Xreg :Planet List Pointer 
; Yreg :Enemy  List Pointer
	longa
	tyx

	lda.w	mmx_sosenlistptr,x
	tay
	jsl	mm_freeenemylistptr_l
	km_clrflag16.w	mmx_planetflag,mmpnf_sosappear,x
	lda	#sos_inittime
	sta.w	mmx_psos,x
	rts

;=====================================================================
;*								*
;*		SOS Enemy Self Destruction			*
;* Xreg :Planet Pointer						*
;=====================================================================
Self_destruction_l
	longa
	longi
	jsr	Self_destruction	
	rtl
;=====================================================================
;*		SOS Move Parameters Initial			*
;* Yreg :Enemy Pointer						*
;=====================================================================
	longa
	longi
InitSOSmoveParams
;* enemy velocity *
	phx
	ldx	kdifficulty
	lda.l	SOSspeedBase,x
	clc
	adc.w	mmx_entype,y	;sos type
	km_loba
	tax
	lda.l	enemyspeedtbl,x
	km_loba
	sta.w	mmx_envel,y	;sosvel
	plx
;* enemy animation *
	lda	#0
	sta.w	mmx_enanmpatt,y
	sta.w	mmx_enanmtm,y

;*** enemy stratage ***
	lda.w	mmx_entype,y		;sos type
	cmp	#entyp_guard
	bne	..search_planet

	lda	#enstrat_searchplayer
	sta.w	mmx_enstratptr,y
	km_setflag16.w	mmx_enflags,enfl_searchenemy,y
	bra	..set_flags
..search_planet
	lda	#enstrat_searchplanet
	sta.w	mmx_enstratptr,y

;*** enemy flags ***
..set_flags
	km_clrflag16.w	mmx_enflags,(enfl_demo!enfl_nocollision),y
	jsr	calc_enangvelxy
	rts
;=====================================================================
;*		Corneria HP Decriment				*
;* Xreg:Planet Pointer						*
;* 16 frame oki ni 1 kai
;=====================================================================
DecCorneriaHP
	longa
	longi
	lda	#1
	jsl	kspeedupA_l
	sta	kz_x1

	lda.w	mmx_sosattacktm,x
	clc
	adc	kz_x1
	sta.w	mmx_sosattacktm,x
	cmp	#$10
	bmi	.skip
	and	#$f
	sta.w	mmx_sosattacktm,x
	km_setflag16	kw_mmsoundflag,mmsndf_corneriaexplode

	lda	kx_CorneriaHP
	sec
	sbc.w	mmx_sosattackpo,x
	sta	kx_CorneriaHP
	bpl	.skip
	stz	kx_CorneriaHP

	km_setmissionsyori	gameover
	km_setmismapsyori	missiongameover
.skip
	lda	#100
	sec
	sbc	kx_CorneriaHP
	sta	kx_CorneriaDamage
	rts
;=====================================================================
;*			SOS Wait				*
;* Xreg:Planet Pointer						*
;=====================================================================
soswait
	longa
	longi
	lda	#1
	jsl	kspeedupA_l
	sta	kz_x1
	lda.w	mmx_soswaittm,x
	sec
	sbc	kz_x1
	sta.w	mmx_soswaittm,x
	beq	.finish_wait
	bpl	.wait_end
.finish_wait
	inc.w	mmx_psos,x
	sec
	rts
.wait_end
	clc
	rts
;=====================================================================
;*		SOS Enemy List Initial Set			*
;* moshi SOS enemy ga APPEAR shitara					*
;* Init :Xreg :Appear Planet Popinter				*
;*      :Yreg :Enemy Popinter					*
;=====================================================================
mm_initsoslist
	php
	PHX
	ai16
;* enemy dest planet list pointer *
	km_setvar	mmx_enemydestptr,kx_corneriaptr

;* get enemy list memory *
;Yreg <--- Enemy List Pinter
	jsr	mm_getenemylistptr
;* Enemy Appear Demo Initial *
	tya
	sta.w		mmx_sosenlistptr,x	;Enemy List Pointer
	lda	#10-1
	sta.w	mmx_soswaittm,x
;* source * <<<<
	txa
	sta.w	mmx_ensourplanetptr,y
	km_lobswaplda.w	mmx_planetcx,x
	sta	kz_x1
	km_lobswaplda.w	mmx_planetcy,x
	sta	kz_y1

	lda	kz_x1
	sta.w	mmx_enposx,y		;postion X
	lda	kz_y1
	sta.w	mmx_enposy,y		;postion Y
;* flag *
	km_setflag16.w	mmx_enflags,(enfl_nocollision!enfl_demo),y
	km_setflag16	kw_mmsoundflag,mmsndf_sosappear
;* dest *
	lda	mmx_enemydestptr
	sta.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest

;* velocity *
	lda	#sos_appearspeed
	sta.w	mmx_envel,y	;velocity
	jsr	calc_enangvelxy

;* battle stage *
	a8
	lda	#stg_sos1
	sta.w	mmx_enstage,y

;* skill *
	shorta
	jsr	sosenemyskill
;* stack *
	jsr	mm_setenstack
	sta.w	mmx_enstackptr,y
;* sos enemy type *
	lda.w	mmx_enskill,y
	tax
	lda.l	sostypetbl,x
	sta.w	mmx_entype,y	;sos type
	asl	a
	tax
	lda.l	sosbittbl,x
	sta	mmx_sosappear
;* Sprite Animation *
	a16
	lda	#cd_objanime_sos1
	sta.w	mmx_enanmpatt,y
	lda	#0
	sta.w	mmx_enanmtm,y
	a8
;* Enemy Stratage *
	lda	#enstrat_sosappear
	sta.w	mmx_enstratptr,y	;stratage pointter

;* collision *
	lda	#sos_collision
	sta.w	mmx_encoll,y		;collision

;* muteki Timer *
	lda	#3
	sta.w	mmx_eninvtm,y
;--------------------------------------------------------------------
.end
	PLX
	plp
	rts


;=====================================================================
;*			Get Enemy List Pointer			*
;* Yreg :Enemy List Pointer						*
;=====================================================================
mm_getenemylistptr_l
	jsr	mm_getenemylistptr
	rtl

mm_getenemylistptr
	php
	ai16
	PHX
	ldx	#0
	l_add.w	kx_enlistptr,kx_enfreeptr,mm_blink1
	txy
	PLX
	inc	kx_enemytotal
	plp
	rts

;=====================================================================
;*		Free Enemy List Pointer				*
;* Yreg :Enemy List Pointer						*
;=====================================================================
mm_freeenemylistptr_l
	php
	a16
	longi
	phx
	tyx
	km_clrflag16.w	mmx_enflags,enfl_all,x
	phx
	lda.w	mmx_enstackptr,x
	tax
	lda	#0
	sta.w	kx_stackbuffer,x
	sta.w	eenemyNumber_0,x
	plx
	l_rem.w	kx_enlistptr,kx_enfreeptr

	dec	kx_enemytotal
	plx
	plp
	rtl

;=====================================================================
;*								*
;* 			SOS Enemy Skill Set			*
;* a8i16								*
;* Xreg :Planet List Pointer						*
;* Yreg :Enemy List Pointer						*
;=====================================================================
setstupenemyskill
	shorta
	longi

	ldx	step_rnd_offset
	lda	kdifficulty
	dec	a
	beq	.normal
	a16
	txa
	clc
	adc	#hard_step_rand-norm_step_rand
	tax
	a8
.normal
	NASTYOFF
	lda.l	norm_step_rand,x	;(eguchi's plaent random table)
	pha
	NASTYON
	pla
	sta.w	mmx_enskill,y

	lda	step_rnd_offset
	inc	a
	and	#31
	sta	step_rnd_offset

	rts
;=====================================================================
;*								*
;* 			SOS Enemy Skill Set			*
;* a8i16								*
;* Xreg :Planet List Pointer						*
;* Yreg :Enemy List Pointer						*
;=====================================================================
sosenemyskill
	a16
	longi

	PHY		;>>> PUSH Y
	lda.w	mmx_ensourplanetptr,y
	tax				;Planet List Pointer
	km_bitcheckflag16.w	mmx_planetflag,mmpnf_missilebase,x
	bne	.missilebase
.normal
;	ldx	#12
;	jsl	KGetRandomValue_l

	a8
	NASTYOFF
	ldx	sos_rnd_offset
	lda.l	sos_random,x	;(eguchi's plaent random table)
	sta	kz_x1		;(0~11)
	NASTYON

	lda	sos_rnd_offset
	inc	a
	and	#127
	sta	sos_rnd_offset

	ldx	kdifficulty
	lda.l	sosskilloffset,x
	clc
	adc	kz_x1
	bra	.setenemyskill
.missilebase
	longa
	lda	kdifficulty
	asl	a
	tax
	lda.l	missiletable,x
	clc
	adc	miss_rnd_offset
	tax

	a8
	lda	miss_rnd_offset
	inc	a
	and	#127
	sta	miss_rnd_offset

	NASTYOFF
	lda.l	easy_miss_rand,x
	pha
	NASTYON
	pla

	ifeq	1
	ldx	#4
	jsl	KGetRandomValue_l
;	ldx	miss_rnd_offset
;	lda.l	miss_random,x
	km_loba
	sta	kz_x1
	ldx	kdifficulty
	lda.l	MissileSkillOffset,x
	endc
.setenemyskill
	PLY		;<<< PULL Y
	sta.w	mmx_enskill,y
	rts

missiletable
	dw	easy_miss_rand-easy_miss_rand
	dw	norm_miss_rand-easy_miss_rand
	dw	hard_miss_rand-easy_miss_rand

;=====================================================================
;*			Set Planet Skill Level			*
;* Input  :Xreg :Planet List Pointer					*
;* Memo   :Yreg Keep							*
;*        :a16i16							*
;=====================================================================
ksetplanetskill_l
	phy		;>>> PUSH Y
	PHP
	a8
;* planet skill *
	TXY		;>>> Push Planet Pointer
	ldx	pl_rnd_offset
	ROMNASTYOFF
	lda.l	planet_random,x	;(eguchi's plaent random table)
	sta	kz_x1		;(number = 0~7)
	ROMNASTYON
	TYX		;<<< Pull Planet Pointer

	lda.w	mmx_stagecnt,x
	sta	kz_tpa

	lda	pl_rnd_offset
	inc	a
	and	#127
	sta	pl_rnd_offset	;(next random pointer)

;* toriaezu flag clear *
	km_clrflag16.w	mmx_planetflag,mmpnf_missilebase,x

	ldy	kdifficulty
	cpy	#dif_hard
	beq	.hard
.easy_normal
	lda	kz_tpa
	beq	.skill_a
	dec	a
	beq	.skill_b
	bra	.skill_c
.hard
	lda	kz_tpa
	beq	.skill_b
	dec	a
	beq	.skill_c
	bra	.skill_d
.skill_a
	lda	kz_x1
	and	#%11
	bra	.setskill
.skill_b
	lda	kz_x1
	and	#%11
	clc
	adc	#4
	bra	.setskill
.skill_c
	lda	kz_x1
	and	#%111
	clc
	adc	#5
	bra	.setskill
.skill_d
	lda	kz_x1
	and	#%11
	clc
	adc	#9

	IFEQ	1		;(1994/12/21)
	ldx	kdifficulty
	lda.l	planetskilloff,x
	km_loba
	tax
; Input  :Xreg :warukazu
	jsl	KGetRandomValue_l	;(irq.asm)
; OutPut : Acc
; easy   : 0~3
; normal : 0~7
; hard   : 0~12
	a8
	plx		;<<< PULL X
	ENDC

.setskill
	sta.w	mmx_planetskill,x
	cmp	#3
	beq	.missilebase
	cmp	#7
	beq	.missilebase
	cmp	#11
	bne	.notmissilebase
.missilebase
	km_setflag16.w	mmx_planetflag,mmpnf_missilebase,x
.notmissilebase
;* Stage Level Up *
	inc.w	mmx_stagecnt,x

;* Planet Stack Pointer * 
	jsr	mm_setenstack
	sta.w	mmx_plstackptr,x
	PLP
	ply		;<<< PULL Y
	rtl


;*********************************************************************
;*								*
;*			Enemy Move				*
;*								*
;*********************************************************************
mm_sosenemymove
	a16
	longi

	ldy	kx_enlistptr
	km_beq	.end
.loop
;----------------------------------------------------------------------
;* Enemy Move *
	km_ldasla.w	mmx_enstratptr,y
	tax
	jsr	(.enemymovetbl,x)
;----------------------------------------------------------------------
.nextenemycheck
	longa
	longi
	lda.w	mmx_ennext,y
	beq	.end
	tay
	brl	.loop
;----------------------------------------------------------------------
.end
	a8
	rts
.enemymovetbl
	dw	enmv_nothing&WM
	dw	enmv_stepupappear&WM
	dw	enmv_sosappear&WM
	dw	enmv_searchplanet&WM
	dw	enmv_aroundplanet&WM
	dw	enmv_battleplayer&WM
	dw	enmv_searchplayer&WM
	dw	enmv_searchrandom&WM
	dw	enmv_enterplanet&WM

;=====================================================================
;*			Not Move				*
;=====================================================================
enmv_nothing
enmv_stepupappear
enmv_searchrandom
	longa
	longi
	rts

;=====================================================================
;*			Enter Planet	(Step Up Enemy)		*
;=====================================================================
enmv_enterplanet
	longa
	longi
;	lda.w	mmx_work1,y
;	clc
;	adc	#$80
;	sta.w	mmx_work1,y

	lda.w	mmx_enangY,y
	clc
;	adc.w	mmx_work1,y
	adc	#$0c00
	sta.w	mmx_enangY,y
	jsr	enmv_easysearch
	bcc	.end
	km_clrflag16.w	mmx_enflags,enfl_StupEnterAnm,y
.end
	rts
;---------------------------------------------------------------------
enmv_easysearch
	longa
	longi
	a8
	PHX
	ldx	#0
	lda.w	mmx_enposx+1,y
	cmp.w	mmx_endestx,y
	a16
	bne	.skip1
	inx
	bra	.checky
.skip1
	bpl	.rightX
.leftx
	lda.w	mmx_enposx,y
	clc
	adc	#$0060
	bra	.setx
.rightx
	lda.w	mmx_enposx,y
	sec
	sbc	#$0060
.setx
	sta.w	mmx_enposx,y
.checky
	a8
	lda.w	mmx_enposy+1,y
	cmp.w	mmx_endesty,y
	a16
	bne	.skip2
	inx
	cpx	#2
	bne	.end
	bra	.finish
.skip2
	bpl	.righty
.lefty
	lda.w	mmx_enposy,y
	clc
	adc	#$0060
	bra	.sety
.righty
	lda.w	mmx_enposy,y
	sec
	sbc	#$0060
.sety
	sta.w	mmx_enposy,y
.end
	clc
	PLX
	rts
.finish
	sec
	plx
	rts
;=====================================================================
;*			Move Planet Search			*
;* Temp Work  : 							*
;=====================================================================
enmv_sosappear
enmv_searchplanet
	longa
	longi
;* enemy velocity calc *
	lda.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest
;;;;	jsr	calc_enangvelxy
	jsr	en_speedupmode
	brl	Setenemypostion
;=====================================================================
;*		 Move Around Planet			*
;=====================================================================
enmv_aroundplanet
	longa
	longi
	lda	#$200
	clc
	adc.w	mmx_enangY,y
	and	#$fe00
	sta.w	mmx_enangY,y

enmv_around_sub
	lda	#sos_aroundspeed
	sta.w	mmx_envel,y
	jsr	calc_envelxy24
	lda.w	mmx_envelx,y
	sta	mmx_spx_int-1
	lda.w	mmx_envely,y
	sta	mmx_spy_int-1
	brl	Setenemypostion

;=====================================================================
;*			Move Battle Player			*
;=====================================================================
enmv_battleplayer
	longa
	longi

;	km_bitcheckflag.w	mmx_enflags,enfl_hachinoji,y
;	bne	.skip1

	lda.w	mmx_enangY,y
	clc
	adc	#$200
	and	#$fe00
	sta.w	mmx_enangY,y
	bra	enmv_around_sub

;	bra	.skip2
;.skip1
;	lda.w	mmx_enangY,y
;	sec
;	sbc	#$200
;	and	#$fe00
;	sta.w	mmx_enangY,y
;.skip2
;	bne	.skip3
;	km_eorflag.w	mmx_enflags,enfl_hachinoji,y
;.skip3
;	bra	enmv_around_sub

	IFEQ	1
	km_loblda.w	mmx_enangY+1,y
	tax
	lda.l	ramsintab,x
	sta	kz_tpx
	lda.l	ramcostab,x
	sta	kz_tpy

	a8
	lda	kz_tpx
	sta	kz_x1
	lda	#16
	sta	kz_x2
	km_cpumults8us8_X
	a16
	sta	mmx_spx
	rts
	ENDC
;=====================================================================
;*			Player Search				*
;* Temp Work  : 							*
;=====================================================================
enmv_searchplayer
	longa
	longi

	jsr	calc_enangvelxy
	jsr	en_speedupmode
	brl	Setenemypostion
;=====================================================================
;*			Enemy Postion Main Set			*
;* Init :velocity (mmx_spx_dec,mmx_spx_int)				*
;=====================================================================
	longa
	longi
Setenemypostion
	lda	mmx_spx_dec
	clc
	adc.w	mmx_enposx_l,y
	sta.w	mmx_enposx_l,y
	a8
	lda	mmx_spx_int
	adc.w	mmx_enposx_l+2,y
	sta.w	mmx_enposx_l+2,y

	a16
	lda	mmx_spy_dec
	clc
	adc.w	mmx_enposy_l,y
	sta.w	mmx_enposy_l,y
	a8
	lda	mmx_spy_int
	adc.w	mmx_enposy_l+2,y
	sta.w	mmx_enposy_l+2,y
	a16
	rts

;=====================================================================
;*		Calculation Enmy Velocity			*
;* Yreg :Enemy List Pointer						*
;=====================================================================
calc_enangvelxy_l
	jsr	calc_enangvelxy
	rtl
;---------------------------------------------------
calc_enangvelxy
;* calc angle *
;* entry:
;*	x1 : source postion x	16bit
;*	y1 : source postion y	16bit
;*	x2 : dest postion x	16bit
;*	y2 : dest postion y	16bit
;* exit:
;*	A  :Angle	:16 bit (0~$ffff)

	longa
	longi
	km_hibswaplda.w	mmx_enposx,y
	sta	kz_x1
	km_hibswaplda.w	mmx_enposy,y
	sta	kz_y1
	km_loblda.w	mmx_endestx,y
	sta	kz_x2
	km_loblda.w	mmx_endesty,y
	sta	kz_y2
	jsl	calobjangle_l
	sta.w	mmx_enangY,y	;16 bit


;---------------------------------------------------------------------
;*								*
;*		Calculate Enemy Velocity (X,Y)	[24 bit]	*
;* ( jsr conv_velxy )						*
;* kz_x1 :enemy vel   (16 bit :(h) integer,(l) decimal		*
;* kz_y1 :enemy angle (16 bit :(h) dummy,(l) integer			*
;*								*
;* Used Work :kz_x1,kz_y1,kz_x2,kz_y2,kz_tpx,kz_texpt		*
;---------------------------------------------------------------------
calc_envelxy24
	longa
	longi
	lda.w	mmx_envel,y
	km_nega
	sta	kz_x1
	lda.w	mmx_enangY+1,y
	sta	kz_y1

	jsr	conv_velxy

	lda	tpx
	sta.w	mmx_envelx_l,y
	lda	kz_textpt
	sta.w	mmx_envely_l,y

	a8
	lda	tpx+2
	sta.w	mmx_envelx_l+2,y
	lda	kz_textpt+2
	sta.w	mmx_envely_l+2,y
	a16
	rts
;---------------------------------------------------------------------
;*		Calculate Velocity (X,Y)			*
;* Input	:kz_x1	  :vel   (16 bit)				*
;*	:kz_y1	  :angle (16 bit)				*
;* OutPut	:kz_tpx	  :vel (x) :24 bit				*
;*	:kz_textpt:vel (y) :24 bit				*
;* Temp Work :kz_x2,kz_y2						*
;---------------------------------------------------------------------
conv_velxy
	phx
	phy
	i8
	lda	kz_y1
	clc
	adc	#$40
	tax
	km_sexvar.l	ramcostab,x
	sta	kz_x2
	km_sexvar.l	ramsintab,x
	sta	kz_y2
	i16
	ldy	kz_x2
	lda	kz_x1
	km_nega
	jsl	ML_s16s16_l
	sta	kz_tpx+2
	sty	kz_tpx

	ldy	kz_y2
	lda	kz_x1
	jsl	ML_s16s16_l
	sta	kz_textpt+2
	sty	kz_textpt
	asl	kz_tpx
	rol	kz_tpx+2
	asl	kz_textpt
	rol	kz_textpt+2

	ply
	plx
	rts
;---------------------------------------------------------------------
;*								*
;*		Calculate Enemy Velocity (X,Y)	[16 bit]	*
;* Used Work :kz_x1,kz_y1,kz_x2,kz_y2,kz_tpx,kz_texpt		*
;*								*
;---------------------------------------------------------------------
	IFEQ	0
calc_envelxy16
	longa
	longi
;* calc velx,vely *
;* entry:
;*	A  : Y angle	8bit
;*	x1 : dummy = 0	8bit
;*	y1 : velocity	8bit
;* exit:
;*	x2 : velocity x vector 16bit
;*	y2 : velocity y vector 16bit

	A8
	lda.w	mmx_envel,y
	sta	kz_y1
	stz	kz_x1
	lda.w	mmx_enangY+1,y
	jsl	rotate_8yx_l
	A16
	lda	kz_x2
	sta.w	mmx_envelx,y
	lda	kz_y2
	sta.w	mmx_envely,y
	rts
	ENDC
;----------------------------------------------------------------------------
;* Calculate Object Angle *
;* db = $7e
;* a16 i16
;* In   :source = (x1,y1),dest = (x2,y2)
;* Exit :Acc = Angle (16 bit) :0 to 359 degrees is $0000 to $ffff
;----------------------------------------------------------------------------
calobjangle_l
	php
	a16
	longi
;* zahyou set *
	km_substavarvar	x1,x2
	km_substavarvar	y1,y2

;* area check  (amari kyori ga chikasugiru to angle ga motomerarenai!!)*
;* dakra kyori ga chikasugiru tokino angle wa motomenai *
	IFEQ	1
	lda	x1
	bpl	.plasX1
	nega
.plasX1
	cmp	#16
	bpl	.calc_angle

	lda	y1
	bpl	.plasY1
	nega
.plasY1
	cmp	#16
	bmi	.chikasugi
	ENDC
;---------------------------------
;* angle wo motome ru *
.calc_angle
	jsl	arctan16_l
;---------------------------------
.chikasugi
	plp
	rtl


;=====================================================================
;*			Speed UP CHECK				*
;* OutPut :								*
;* Tmp Work :kz_textpt (4 byte)					*
;=====================================================================
en_speedupmode
	longa
	longi
;* vel X *
	km_sexvar.w	mmx_envelx_l+2,y
	sta	kz_textpt+2
	lda.w	mmx_envelx_l,y
	sta	kz_textpt+0

	jsl	kspeedup3_l		;*8 or &16
;;;;	jsl	kstepupspeed_l		;*8
;;;;	jsl	demospeed_l		;*16
	jsl	gamespeed_l		;/8
;;;	jsl	asteroidspeed_l		;/8

	km_setvar	mmx_spx_dec,kz_textpt+0
	a8
	km_setvar	mmx_spx_int,kz_textpt+2
	a16	
;* vel Y *
	longa
	longi
	km_sexvar.w	mmx_envely_l+2,y
	sta	kz_textpt+2
	lda.w	mmx_envely_l,y
	sta	kz_textpt+0

	jsl	kspeedup3_l		;*8 or *16
;;;;	jsl	kstepupspeed_l		;*8
;;;;	jsl	demospeed_l		;*16
	jsl	gamespeed_l		;/8
;;;	jsl	asteroidspeed_l		;/8

	km_setvar	mmx_spy_dec,kz_textpt+0
	a8
	km_setvar	mmx_spy_int,kz_textpt+2
	a16	
	rts
	
;=====================================================================
;*			Speed UP				*
;* Init	:Acc							*
;*	:mmw_speedup = *8					*
;* OutPut	:Acc							*
;=====================================================================
kspeedupA_l
	longa
	longi
	pha
	km_bitcheckmismapstflag	speedup
	beq	kspeedupA_end
	pla
	asl	a	;*8
	asl	a
	asl	a
	rtl
;------------------------------------------------------------------------
kspeedupA_end
	pla
	rtl

;=====================================================================
;*			Speed Down				*
;* Init	:kz_textpt (32 bit) 					*
;* OutPut	:kz_textpt (24 bit)					*
;=====================================================================
gamespeed_l
	longa
	longi
	km_bitcheckmissionflag	parallel
	bne	kspeedup_end
kspeeddown8
;/8
	lsr	kz_textpt+2
	ror	kz_textpt+0
kspeeddown4
;/4
	lsr	kz_textpt+2
	ror	kz_textpt+0
kspeeddown2
;/2
	lsr	kz_textpt+2
	ror	kz_textpt+0
	rtl
;------------------------------------------------------------------------
asteroidspeed_l
	longa
	longi
	km_bitcheckflag16.w	mmx_enflags,enfl_asteroid,y
	beq	kspeedup_end
	bra	kspeeddown8
;------------------------------------------------------------------------
kspeedup3_l
	longa
	longi
	km_bitcheckmismapstflag	speedup
	bne	kspeedup_sub
	km_bitcheckmismapstflag	replay
	beq	kspeedup_end
kspeedup_end
	rtl
;=====================================================================
;*			Speed Up				*
;* Init	:kz_textpt (32 bit) 					*
;* OutPut	:kz_textpt (32 bit)					*
;=====================================================================
kreplayspeedup_sub
kspeedup16_l
;*16
 	asl	kz_textpt
	rol	kz_textpt+2
kspeedup_sub
kspeedup8_l
;*8
	asl	kz_textpt
	rol	kz_textpt+2
kspeedup4_l
;*4
	asl	kz_textpt
	rol	kz_textpt+2
kspeedup2_l
;*2
	asl	kz_textpt
	rol	kz_textpt+2
	rtl

;kstepupspeed_l
;	longa
;	longi
;	km_bitcheckflag16.w	mmx_enflags,enfl_stepup,y
;	bne	kspeedup_sub
;	bra	kspeedup_end

;*********************************************************************
;*								*
;*		Enemy Collision Check				*
;* data bank :7e							*
;* Return :a8							*
;*********************************************************************
mm_sosenemycollision
	a16
	longi
;* flag clear *
	km_clrmismapflag	attackcorneria

	ldy	kx_enlistptr
	km_beq	.end	;No Enemy
.loop
;* attack corneria check *
	km_memchecka16
	km_bitcheckflag.w	mmx_enflags,enfl_attackcorneria,y
	beq	.notarrive
	km_bitcheckflag.w	mmx_enflags,enfl_encountplayer,y
	bne	.notarrive
	km_setmismapflag	attackcorneria
.notarrive

;* collision check *
	km_bitcheckflag.w	mmx_enflags,enfl_nocollision,y
	km_bne	.nextenemycheck
;----------------------------------------------------------------------
;*****************************************************
;*	 Player to Enemy tono collision check	*
;* SearchPLayer					*
;*****************************************************
	LONGA
;* Moshi demo tyuu dattara player tono atari nashi *
;;;	km_bitcheckmismapstflag	replay
;;;	bne	.nextenemycheck

;***** Search Player Area IN Check ********
	km_clrflag16.w	mmx_enflags,enfl_SearchAreaIn,y
	km_bitcheckmismapflag	playernocoll
	km_bne	.Skip_PlayerHitCheck

	km_bitcheckflag.w	mmx_enflags,(enfl_stepup!enfl_defence2),y
	bne	.PlayerColl_ON

	lda	#sos_plsearchcoll
	sta	kz_z2
	jsr	CollEnemytoPlayer
	bcc	.PlayerColl_ON
	km_setflag16.w	mmx_enflags,enfl_SearchAreaIn,y

;* enmey ga muteki no jyoutai dattara player tono atari naishi *
.PlayerColl_ON
	a8
	lda.w	mmx_eninvtm,y
	beq	.collisioncheck_player
	dec	a
	sta.w	mmx_eninvtm,y
	bra	.Skip_PlayerHitCheck

;*****************************************************
;*	Player tono Collision Check 		*
;*****************************************************
.collisioncheck_player
	a16
	km_loblda.w	mmx_encoll,y
	sta	kz_z2
	jsr	CollEnemytoPlayer
	bcc	.Skip_PlayerHitCheck
.ENCOUNTPlayer
	sty	kx_SOSEnemyptr	;enemy pointer keep
	km_setflag16.w	mmx_enflags,(enfl_encountplayer!enfl_nocollision),y
	km_setflag16	kw_mismapflag,(kmimpf_battleplayer!kmimpf_playernocoll!kmimpf_enemy)
	km_setflag16	kw_mismapfreezeflag,(kfz_playerfreeze!kfz_enemyfreeze)	;[stratage off]
	km_setmismapsyori	missionstart

	km_clrmismapflag	asteroid   ;[MISSION MAP FLAG]

	km_bitcheckflag16.w	mmx_enflags,enfl_asteroid,y
	beq	.skip
	km_setmismapflag	asteroid   ;[MISSION MAP FLAG]
.skip
	a8
	lda	kz_x2
	sta	mmx_wipeposx	;wipe postion CX
	lda	kz_y2
	sta	mmx_wipeposy	;wipe postion CY

	lda.w	mmx_enstage,y
	sta	kgamemapptr	;sos1/sos2/sos3

	lda.w	mmx_enskill,y
	sta	currentlevel	;skill (step)
	lda.w	mmx_enstackptr,y
	sta	kstacknumber
	brl	.nextenemycheck
;*************************************
;*	Calc Enemy Dest	*
;*************************************
.Skip_PlayerHitCheck
	a16
	km_bitcheckflag16.w	mmx_enflags,enfl_searchenemy,y
	beq	.search_skip
	km_bitcheckflag16.w	mmx_enflags,enfl_SearchAreaIn,y
	beq	.search_planet
.search_player
	jsr	mm_playerdest
	km_setval.w	mmx_envel,sos_searchplayer,y
	bra	.search_skip

.search_planet
	lda.w	mmx_endestplanetptr,y
	tax
	km_setval.w	mmx_envel,sos_zacosp1_easy,y
	jsr	mm_enemydest
.search_skip
;----------------------------------------------------------------------
.Check_CorneriaArrive
;*** SOS Enemy ga Corneria ni Touchaku shitaka Check ***
;*** Step UP Enemy ga Planet ni Touchaku shitaka Check ***
	km_memchecka16
	km_loblda.w	mmx_endestx,y
	sta	kz_x1
	km_loblda.w	mmx_endesty,y	
	sta	kz_y1
	km_hibswaplda.w	mmx_enposx,y
	sta	kz_x2
	km_hibswaplda.w	mmx_enposy,y
	sta	kz_y2
	km_setval	kz_z2,8
	km_jsr	en_collcheck_sub	;sec :Hit
	bcc	.BG_Check
.ArriveEnemy
	km_memchecka16
	km_bitcheck.w	mmx_enflags,enfl_stepup,y
	beq	.sos
;-----------------------------------
;* Step UP Enemy ga Neutral no Planet ni Touchaku *
.stepup
	LONGA
	km_setflag16.w	mmx_enflags,enfl_arrive,y
	brl	.nextenemycheck
;-----------------------------------
;* SOS Enemy ga Corneria ni Touchaku *
.sos
	LONGA
	km_setflag16.w	mmx_enflags,(enfl_arrive!enfl_attackcorneria),y
	brl	.nextenemycheck
;----------------------------------------------------------------------
;* Defence Line Check (BG Check) *
.BG_Check
	LONGA
;* always asteroid check flag clear *
	km_clrflag16.w	mmx_enflags,enfl_asteroid,y

	km_loblda.w	mmx_enposx+1,y
	sta	kz_x1
	km_loblda.w	mmx_enposy+1,y
	sta	kz_y1
	km_convVRAMSCRaddr_256	kz_x1,kz_y1
	PHX
	tax
	km_loblda.l	BGCheckBuffer,x
	PLX
.Asteroid_Check
	cmp	#$70
	bcs	.NoHitBG
	cmp	#$6a
	bcc	.Defence_Check
	km_setflag16.w	mmx_enflags,enfl_asteroid,y
.Defence_Check
	cmp	#$67
	bcs	.NoHitBG
	cmp	#$60
	bcs	.Defence2
;	cmp	#$50
;	bcs	.Defence1
	bra	.NoHitBG
;.Defence1
;	km_bitcheckflag.w	mmx_enflags,enfl_stepup,y
;	bne	.NoHitBG
;	km_bitcheckflag.w	mmx_enflags,enfl_defence1,y
;	bne	.NoHitBG
;	km_setflag16.w	mmx_message_sos,mesosfl_defence1
;	km_setflag16.w	mmx_enflags,enfl_defence1,y
;	bra	.NoHitBG

;******* Saisyuu Bouei Line ********
.Defence2
	km_bitcheckflag.w	mmx_enflags,(enfl_stepup!enfl_defence2),y
	bne	.NoHitBG

	km_setflag16.w	mmx_message_sos,mesosfl_defence2
	km_setflag16.w	mmx_enflags,enfl_defence2,y
.NoHitBG
;----------------------------------------------------------------------
.nextenemycheck
	a16
	lda.w	mmx_ennext,y
	beq	.end
	tay
	brl	.loop
;----------------------------------------------------------------------
.end
	a8
	rts

;=====================================================================
;*								*
;*		Enemy to Player tono Collision Check		*
;* Init :kz_x2 :collision Area					*
;=====================================================================
CollEnemytoPlayer
	longa
	longi
	km_loblda.w	mmx_arwingposx+1
	sta	kz_x1
	km_loblda.w	mmx_arwingposy+1
	sta	kz_y1
;* enemy postion *
;( sudeni maede set shiteiru params dakedo plannet arrive no tokini hituyou !!)
	lda.w	mmx_enposx,y
	km_hibswapa
	sta	kz_x2
	lda.w	mmx_enposy,y
	km_hibswapa
	sta	kz_y2
	km_jsr	en_collcheck_sub
	rts

;=====================================================================
;*								*
;*			Enmey Dest Postion Set	(Mother Planet)	*
;* Yreg :Enemy Pointer						*
;=====================================================================
mm_enemydest
	php
	a8
	lda.w	mmx_planetcx,x
	sta.w	mmx_endestx,y
	lda.w	mmx_planetcy,x
	sta.w	mmx_endesty,y
	plp
	rts

;=====================================================================
;*								*
;*			Enmey Dest Postion Set	(Player)	*
;* Yreg :Enemy Pointer						*
;=====================================================================

	longa
	longi
mm_playerdest
	a8
	lda.w	mmx_arwingposx+1
	sta.w	mmx_endestx,y
	lda.w	mmx_arwingposy+1
	sta.w	mmx_endesty,y
	a16
	rts


	IFEQ	1
	bne	.planet
	lda.w	mmx_arwingposx+1
	sta.w	mmx_endestx,y
	lda.w	mmx_arwingposy+1
	sta.w	mmx_endesty,y
	bra	.end
.planet
	phx
	a16
	km_loba
	asl	a
	tax
	a8
	lda.l	mm_destpostbl,x
	sta.w	mmx_endestx,y
	lda.l	mm_destpostbl+1,x
	sta.w	mmx_endesty,y
	plx
	ENDC
.end

;=====================================================================
;*								*
;*			Collision Check Sub Routine		*
;* InPut : (kz_x1,kz_y1),(kz_x2,kz_y2), z2 = collision		*
;* OutPut								*
;*	sec = Hit						*
;* 	clc = No Hit						*
;=====================================================================
en_collcheck_sub
	longa
	longi
;* X collision check *
	lda	kz_x2
	clc
	adc	kz_z2
	cmp	kz_x1
	bmi	.nohit
	lda	kz_x2
	sec
	sbc	kz_z2
	cmp	kz_x1
	bpl	.nohit
;* Y collision check *
	lda	kz_y2
	clc
	adc	kz_z2
	cmp	kz_y1
	bmi	.nohit
	lda	kz_y2
	sec
	sbc	kz_z2
	cmp	kz_y1
	bpl	.nohit
.hit
	sec
	rts
.nohit
	clc
	rts

;*********************************************************************
;*********************************************************************
mm_blink1
	a8
	kbug1
	bra	skip_mm_blink
mm_blink2
	a8
	kbug2
	bra	skip_mm_blink
mm_blink3
	a8
	kbug3
skip_mm_blink
	blink	3

;*********************************************************************
;*********************************************************************

;*		Not Using Area			*

;*********************************************************************
;*********************************************************************
;******************************************************************
;******************************************************************
;******************************************************************
	IFEQ	1
;=====================================================================
;*		Calculate Random Planet Pointer			* 
;* Input :a16i16							*
;* OutPut = Xreg :Planet Pointer (If X = -1 then No Enemy Appear)	*
;=====================================================================
checkendcnt	=	kz_tpx
planetkazu	=	kz_x1
planetnumber	=	kz_x2
;-----------------------------------
CalcRandomPlanetPtr
	longa
	longi

	lda	kx_missionplanetkazu
	sta	planetkazu
	sta	CheckEndCnt

;**** Get Saisyo no Planet kouhoti Number (Random Pointer / planet no kazu) ****
;OutPut:(kamari) = Planet (Saisyo no kouhoti) Number Get
	lda	kw_randomptr
	clc
	adc	kw_randomptr2
	sta	kw_randomptr2
	km_cpudivu16u8_work	planetkazu
	km_setvar	planetnumber,kamari
;**** SOS Enemy no syutugen basyo Search ****
.Search_start
	ldx	kx_planetlistptr
.loop
	dec	a
	bmi	.GetPointer
	pha
	lda.w	mmx_planetnext,x
	tax
	pla
	bra	.loop
.getpointer
	km_bitcheckflag.w	mmx_planetflag,mmpnf_complete,x
	bne	.NextPlanet
	km_bitcheckflag.w	mmx_planetflag,mmpnf_neutral,x
	beq	.FoundAppearPlanet
.NextPlanet
	dec	CheckEndCnt
	beq	.CantAppear

	km_addstaval	planetnumber,1
	cmp	kx_missionplanetkazu
	bne	.Search_start
	lda	#0
	sta	planetnumber
	beq	.Search_start
;* Syutugen Dekinai *
.CantAppear
	ldx	#-1
.FoundAppearPlanet
	rts
	ENDC
;==========================================================================
;==========================================================================
;==========================================================================
	IFEQ	1
	ldx	mmw_planetdataptr
.LOOP
;--- PLANET DRAW ---
	lda.l	planetdata+0,x
	sta.l	m_xc		;Center X
	lda.l	planetdata+2,x
	sta.l	m_yc		;Center Y

	lda.l	planetdata+4,x
	sta.l	m_radius	;Hankei
	bra	.planet

	ifeq	1
	km_bitcheckmissionflag	planet
	beq	.planet
;------------
.shadow
	lda	#shadow_spr
	sta.l	msprite

	lda.l	planetdata+8,x
	sta.l	m_rotx
	lda	#0
	sta.l	m_roty
	lda.l	planetdata+10,x
	sta.l	m_rotz
	bra	.callmario
	endc
;------------
.planet
	lda.l	planetdata+6,x
	sta.l	msprite

	lda.l	mmx_planetangx
	sta.l	m_rotx
	lda.l	mmx_planetangy
	sta.l	m_roty
	lda.l	mmx_planetangz
	sta.l	m_rotz

;* planet next pointer *
	lda	mmw_planetdataptr		;dono planet wo draw suruka no pointer
	clc
	adc	#planetdatalen			;planet data length
	sta	mmw_planetdataptr
	cmp	#planetdatalen*mm_planetnumber	;planet data length * planet number
	bne	.next
	km_setval	mmw_planetdataptr,0
	ENDC


	ifeq	1
;* ROM Nasty ON *
	nastyon
* Mario Program Start *
	lda	#MMakePlanet>>16
	sta.l	mcodebank
	a16
	lda	#MMakePlanet&WM
	sta.l	mr15	; GO!
	a8
;* Mario Wait *
	km_waitmario
	endc

;*********************************************************************
;*								*
;*		Step Up Enemy Appear				*
;* Data Bank :7e							*
;*********************************************************************
	IFEQ	1
neutralcnt	equ	kz_x1
;-------------------------------------------------
mm_StepUpEnemyAppear
	shorta
	longi
	php
	lda	kx_stepupstock
	bne	.skip			;StepUp no zaico nashi

;* Enemy Stock = 0 *
	lda	kx_neutralplanetkazu
	clc
	adc	kx_clearplanetkazu
	cmp	kx_missionplanetkazu
	bne	.jmp_end

;* Mission Map CLear *
	km_setmismapflag	missionallclear
	km_setmismapsyori	missionallclear
.jmp_end
	brl	.end
;* step up enemy appear Wait *
.skip
	lda	kx_stepupappeartm	;Appear Wait
	beq	.WaitEnd
	dec	a
	sta	kx_stepupappeartm
	brl	.end
;--------------------------------------------------------------------
.WaitEnd
	shorta
	lda	kx_stepupdemoptr
	beq	.normal_check
	cmp	#stupdm_demoend
	km_beq	.SetParams
	cmp	#stupdm_initial
	km_beq	.initial
	brl	.end
;--------------------------------------------------------------------
.initial
	km_setmismapstflag	stepupdemo	
	km_setval	kx_stepupdemoptr,stupdm_open
	brl	.end
;--------------------------------------------------------------------
.normal_check
;* enemy total no kazu >= 8 *
	shorta
	km_cmpcheck	kx_enemytotal,mm_enemymax	;(kalcs.inc)
	km_bpl	.end

;* Neutral no  hoshi no kazu wo Check *
	shorta
	lda	kx_neutralplanetkazu
	km_beq	.end
	dec	a
	beq	.neutral1	;neutral no kazu = 1
	bra	.check_stupkazu	;neutral no kazu >= 2

;* clear planet no kazu = planet no kazu-1 ka CHECK *
.neutral1
	shorta
	lda	kx_missionplanetkazu
	dec	a
	cmp	kx_clearplanetkazu
	km_bne	.end

;* neutral no kazu > stepup no kazu *
.check_stupkazu
	shorta
	lda	kx_neutralplanetkazu
	cmp	kx_stepuptotal
	km_beq	.end	;neutral no kazu = stepup no kazu
	km_bmi	.end	;neutral no kazu < stepup no kazu

;* neutral planet search *
.search_neutral
	a16
	ldx	kx_planetlistptr
.loop
	cpx	kx_corneriaptr
	km_beq	.end

	km_bitcheckflag.w	mmx_planetflag,mmpnf_neutral,x
	bne	.found_neutral
.nextplanet
	lda.w	mmx_planetnext,x
	tax
	bne	.loop
	brl	.end

;**** Sono Mokuteki no Planet ni sudeni StepUp Enemy ga mukatte iruka CHECK ****
;Xreg :Planet List Pointer
;Yreg :Enemy  List Pointer
.found_neutral
	longa
	ldy	kx_enlistptr
.loop2
	km_bitcheckflag.w	mmx_enflags,enfl_stepup,y
	beq	.nextenlist
.stepupenemy
	txa
	cmp.w	mmx_endestplanetptr,y
	beq	.nextplanet

.nextenlist
	lda.w	mmx_ennext,y
	beq	.search_end
	tay
	bne	.loop2
.search_end	;mokuteki Planet ni mukatteiru SteuUp Enemy nashi
	stx	kx_stepupdestptr

;* Mission Map ka Game tyuu ka Check *
	a8
	km_bitcheckmismapflag	missionstart
	km_bne	.SetParams

	km_setval	kx_stepupdemoptr,stupdm_initial
	km_setval	kx_stepupappeartm,5*8
	brl	.end
;-------------------------------------------------------------
;*		Enemy no Params Set			*
;-------------------------------------------------------------
.SetParams
;* step up no stock wo 1tu hrasu *
	a8
	dec	kx_stepupstock
	dec	kx_neutralplanetkazu
	inc	kx_stepuptotal
	
	a16
	km_setval	kx_stepupdemoptr,0
	km_clrmismapstflag	stepupdemo	

;* Enemy List Poinrter Get *
;OutPut :Yreg
	jsr	mm_getenemylistptr
;* flag *
	km_setflag16.w	mmx_enflags,enfl_stepup,y
	km_clrflag16.w	mmx_enflags,enfl_extra,y

;* source *
	km_setval.w	mmx_enposx,(stepup_posx1<<8),y
	km_setval.w	mmx_enposy,(stepup_posy1<<8),y

;* dest *
	lda	kx_stepupdestptr
	sta.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest

;* velocity *
	lda	#-15
	sta.w	mmx_envel,y	;velocity
	jsr	calc_enangvelxy

;* battle stage *
	a8
	lda	#stg_sos1
	sta.w	mmx_enstage,y

;* skill *
	a8
	lda	kw_RandomPtr
	and	#7
	sta.w	mmx_enskill,y

;* stratage pointer *
	a8
	lda	#0
	sta.w	mmx_enstratptr,y

;* collision *
	lda	#10
	sta.w	mmx_encoll,y		;collision

;* Character No *
	PHX
	ldx	#0
	a8
	lda	#0
	sta.w	mmx_enanmptr,y

	lda.l	mm_enemychart+6,x
	sta.w	mmx_enchrbase,y		;character Base No

	a16
	lda.l	mm_enemychart+8,x
	sta.w	mmx_enanmpatt,y		;animtion pattern pointer
	tax

	a8
	lda.l	mm_sprenpattdata+0,x
	sta.w	mmx_enanmmaxptr,y	;anime pattern max pointer

	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;sprite anim chr No 

	lda.l	mm_sprenpattdata+2,x
	sta.w	mmx_enanmtm,y		;Animation change Timer
	PLX

;--------------------------------------------------------------------
.end
	plp
	rts

;======================================================================
;======================================================================
;======================================================================

;neutral find check
	ldy	kx_planetlistptr
.checkloop
	km_bitcheckflag.w	mmx_planetflag,mmpnf_neutral,y
	beq	.nextplanet
.foundnetralplanet
.nextplanet
	a16
	lda.w	mmx_planetnext,y
	beq	.checkend
	tay
	a8
	bra	.checkloop
.checkend
	ENDC
;*********************************************************************
;*		SOS Enemy Appear Routine			*
;* Data Bank :7e							*
;* Yreg :Enemy List Pointer						*
;*********************************************************************
;---------------------------
	IFEQ	1
mm_sosenemyappear
	php
	a16
	longi
;* total no kazu check *
	lda	kx_enemytotal
	cmp	#1	;mm_enemymax
	km_bpl	.end

;* time check *
	km_bitcheckmismapstflag	hourpast
	km_beq	.end
	km_clrmismapstflag	hourpast

	lda	kx_TOTALTIME
	cmp	#1
	beq	.appearenemy
	km_andcmpval	$3f
	bne	.end
.appearenemy
	jsr	mm_initsoslist
.end
	plp
	rts
	ENDC
;**************************************************************************
	IFEQ	1
;---------------------------------------------
;*	Enemy Chart			*
;---------------------------------------------
;===========================================================================
;	dw	CX,CY			;0,2
;	dw	vel,charaNo		;4,6
;	dw	AnmPtr,DestNo		;8,10
;	dw	level			;12
;===========================================================================
obj_gesso	equ	$80
obj_gohst	equ	$84
obj_oni	equ	$88
obj_carbi	equ	$8c
obj_stepup	equ	$a0
obj_sos	equ	$aa
obj_enap1	equ	$0c
obj_enap2	equ	$0e
;--------------------------------------------------------------------------
	IFEQ	1
mm_enemychart
	dw	1,obj_sos,enstrat_nothing,enanm_nothing
mm_enemychartEND
	dw	1,obj_sos,enstrat_nothing,enanm_nothing
	dw	2*8,obj_sos,enstrat_stepupappear,enanm_turn
	dw	0,obj_sos,enstrat_searchplanet,enanm_nothing
	km_datalen	mm_enemychart
	ENDC

;=====================================================================
;*								*
;*			Enemy Anime Pattern			*
;*								*
;=====================================================================
mm_sprenpattdata
;------------------------------
;*  Enemy Pattern Data (Gesso)*
;------------------------------
mm_sprgesso
	km_datacnt	b,mm_sprgesso
      	db	$0,40,$2,40,$0,40,$2,40
      	db	$0,40,$2,40,$0,40,$2,40
	db	$0,08,$2,08,$0,08,$2,08
mm_sprgessoEND
	km_datalen	mm_sprgesso
;--------------------------------
;*  Enemy Pattern Data (Ghost 1)*
;--------------------------------
mm_sprghost1
	km_datacnt	b,mm_sprghost1
      	db	$0,40,$2,40,$0,40,$2,40
      	db	$0,40,$2,40,$0,40,$2,40
      	db	$0,40,$2,40,$0,40,$2,40
	db	$0,04,$2,04,$0,04,$2,04
	db	$0,04,$2,04,$0,04,$2,04
mm_sprghost1END
	km_datalen	mm_sprghost1
;--------------------------------
;*  Enemy Pattern Data (Ghost 2)*
;--------------------------------
mm_sprghost2
	km_datacnt	b,mm_sprghost2
      	db	$0,40,$2,40,$0,40,$2,40
	db	$0,40,$2,40,$0,40,$2,40
	db	$0,10,$2,10,$0,10,$2,10
mm_sprghost2END
	km_datalen	mm_sprghost2


;**** Sono Mokuteki no Planet ni sudeni StepUp Enemy ga mukatte iruka CHECK ****
;Xreg :Planet List Pointer
;Yreg :Enemy  List Pointer
	longa
	ldy	kx_enlistptr
.loop2
	km_bitcheckflag.w	mmx_enflags,enfl_stepup,y
	beq	.nextenlist
.stepupenemy
	txa
	cmp.w	mmx_endestplanetptr,y
	beq	.nextplanet

.nextenlist
	lda.w	mmx_ennext,y
	beq	.search_end
	tay
	bne	.loop2
.search_end	;mokuteki Planet ni mukatteiru SteuUp Enemy nashi
	stx	kx_stepupdestptr
;-------------------------------------------------------------
;*		Enemy no Params Set			*
;-------------------------------------------------------------
.SetParams
;* step up no stock wo 1tu hrasu *
	a8
	dec	kx_stepupstock
	dec	kx_neutralplanetkazu
	inc	kx_stepuptotal
	a16
;* Enemy List Poinrter Get *
;OutPut :Yreg
	jsr	mm_getenemylistptr
;* flag *
	km_setflag16.w	mmx_enflags,enfl_stepup,y
	km_clrflag16.w	mmx_enflags,enfl_extra,y

;* Wait Time *
	km_setval.w	mmx_enappearwaittm,30*16,y

;* source *
	km_setval.w	mmx_enposx,(stepup_posx1<<8),y
	km_setval.w	mmx_enposy,(stepup_posy1<<8),y

;* dest *
	lda	kx_stepupdestptr
	sta.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest

;* velocity *
	lda	#-32
	sta.w	mmx_envel,y	;velocity
	jsr	calc_enangvelxy

	a8
;* battle stage *
	lda	#stg_sos1
	sta.w	mmx_enstage,y

;* skill *
	lda	kw_RandomPtr
	and	#7
	sta.w	mmx_enskill,y

;* stratage pointer *
	lda	#0
	sta.w	mmx_enstratptr,y

;* collision *
	lda	#10
	sta.w	mmx_encoll,y		;collision

;* Character No *
	lda	#0
	sta.w	mmx_enanmptr,y

	lda.l	#obj_sos		;mm_enemychart+6,x
	sta.w	mmx_enchrbase,y		;character Base No

	a16
	PHX
	ldx	#(mm_sprgesso-mm_sprenpattdata)&WM
	lda.l	mm_enemychart+6,x
	sta.w	mmx_enanmpatt,y		;animtion pattern pointer
	tax
	a8
	lda.l	mm_sprenpattdata+0,x
	sta.w	mmx_enanmmaxptr,y	;anime pattern max pointer

	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;sprite anim chr No 

	lda.l	mm_sprenpattdata+2,x
	sta.w	mmx_enanmtm,y		;Animation change Timer
	PLX

;--------------------------------------------------------------------
.end
	plp
	rts

;neutral find check
	ldy	kx_planetlistptr
.checkloop
	km_bitcheckflag.w	mmx_planetflag,mmpnf_neutral,y
	beq	.nextplanet
.foundnetralplanet
.nextplanet
	a16
	lda.w	mmx_planetnext,y
	beq	.checkend
	tay
	a8
	bra	.checkloop
.checkend
;==========================================================================
	a16
	PHX
	lda	#(mm_sprgesso-mm_sprenpattdata)&WM
	lda.l	mm_enemychart+6,x
	sta.w	mmx_enanmpatt,y		;animtion pattern pointer
	tax
	a8
	lda.l	mm_sprenpattdata+0,x
	sta.w	mmx_enanmmaxptr,y	;anime pattern max pointer

	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;sprite anim chr No 

	lda.l	mm_sprenpattdata+2,x
	sta.w	mmx_enanmtm,y		;Animation change Timer
	PLX
	ENDC



	IFEQ	1
;************ Enemy no idou **************
.SetEnemyPostion
	km_memchecka16
;* enemy velocity calc *
	lda.w	mmx_endestplanetptr,y
	tax
	jsr	mm_enemydest
	jsr	calc_enangvelxy
;* enemy postion set *
	jsr	en_speedupmode

	lda	mm_spx
	clc
	adc.w	mmx_enposx,y
	sta.w	mmx_enposx,y

	lda	mm_spy
	clc
	adc.w	mmx_enposy,y
	sta.w	mmx_enposy,y

	ENDC

	IFEQ	1
	tyx
;* X,Y reg = planet pointer *

	lda	#1
	jsl	kspeedupA_l
	sta	kz_x1
	lda.w	mmx_soswaittm,x
	sec
	sbc	kz_x1
	sta.w	mmx_soswaittm,x
	beq	.next_demo
	bpl	.demo_end
.next_demo
;* X reg = chart pointer  *
;* Y reg = planet pointer *
	km_addstaval.w	mmx_soschartptr,mm_enemychartlen,y
	tax
	lda.l	mm_enemychart+0,x
	sta.w	mmx_soswaittm,y
	bne	.demo_set
	
	lda.w	mmx_psos,y
	inc	a
	sta.w	mmx_psos,y
.demo_set
	phy
;* Y reg = enemy pointer *
	lda.w	mmx_sosenlistptr,y	;Enemy List Pointer
	tay
	lda.l	mm_enemychart+2,x
	sta.w	mmx_enchrbase,y		;character Base No
	lda.l	mm_enemychart+4,x
	sta.w	mmx_enstratptr,y
	ply
.demo_end
;* Y reg = planet pointer *
	rts
	ENDC
	IFEQ	1
;* Character No *
	PHX
;;;	ldx	#mm_enemychartlen
	a8
	lda	#0
	sta.w	mmx_enanmptr,y

;	lda.l	mm_enemychart+6,x
;	sta.w	mmx_enchrbase,y		;character Base No

	a16
;;;;	lda.l	mm_enemychart+8,x
;;;;	lda	#(mm_sprgesso-mm_sprenpattdata)&WM
;;;;	sta.w	mmx_enanmpatt,y		;animtion pattern pointer
	tax
	a8
	lda.l	mm_sprenpattdata+0,x
	sta.w	mmx_enanmmaxptr,y	;anime pattern max pointer

	lda.l	mm_sprenpattdata+1,x
	clc
	adc.w	mmx_enchrbase,y
	sta.w	mmx_enchranm,y		;sprite anim chr No 

;;;;	lda.l	mm_sprenpattdata+2,x
;;;;	sta.w	mmx_enanmtm,y		;Animation change Timer
	PLX

;* Next Chart Pointer *
	a16
	lda	kx_enemychartptr
	clc
	adc	#(mm_enemychartEND-mm_enemychart)&WM
	cmp	#(mm_enemychartFinish-mm_enemychart)&WM
	bne	.skip1
	lda	#0
.skip1
	sta	kx_enemychartptr

	ENDC

	incfile	soslist.asm
