;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: raster.asm				*
;* 	Description	: H-V scroll raster			*
;*			; raster demo				*
;*			; Hoffset calculation			*	
;*	Date		: 1994.7.15				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;
;
;
;
;---------------------------------------------------------------------
	INCPUB  raster
;---------------------------------------------------------------------
;
;
;
;
;*******************************************************************
;	work
;*******************************************************************

;;		equ	Xaddr		; 4byte
scrollH		equ	Xwork0		; 2
loop_counter		equ	Xwork1		; 2
data_amp		equ	Xwork2		; 2
data_freq		equ	Xwork3		; 2
add_freq		equ	Xwork4		; 2
work_mult		equ	Xwork5		; 2
;;		---	Xwork6		; ( library )
;;		---	Xwork7		; ( library )
stock1		equ	Xwork8		;
horizon_work		equ	Xwork9		;
;;		---	Xwork10		;

;-------------------------------------------------------------------

Voffset_total	equ	raster_work+0	; 4byte
Voffset_add		equ	raster_work+4	; 4byte
Vzoomtotal		equ	Voffset_total
Vzoomadd		equ	Voffset_add

;-------------------------------------------------------------------

Vzoomcenter		equ	Xwork0

RasterData		equ	ramsintab

;-------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;*******************************************************************
;	raster only macros
;*******************************************************************

MVzoomadd	macro
	clc
	lda	Vzoomtotal+0	; DDA zoom
	adc	Vzoomadd+0
	sta	Vzoomtotal+0
	lda	Vzoomadd+2
	adc	Vzoomtotal+2
	sta	Vzoomtotal+2
	endm

;---------------------------------------------------------------------
;;
;;
;;
;;
;;
;;
;;
;;
;*******************************************************************
;	input program
;*******************************************************************
	longi
        	shorta
;===================================================================
raster_l	Mbank7f
	storenasty		
	nastyon			; MARIO START
	ai16

	jsl	MessageTrigger
	jsr	raster_main

  	a8
  	restorenasty		; MARIO STOP	
	Mbankrtl
;===================================================================
;
;   
;
;
;
;-------------------------------------------------------------------
	longa
;********************************************************************
;			****************************************
; game syori bunki		****************************************
;			****************************************
;********************************************************************
raster_main
;-------------------------------------------------------------------
	lda.l	kw_GameSyori
	and	#00ffh
	asl	a
	tax
             	jmp	(.mainprocess,x)
;====================================================================
.mainprocess	
	dwcode	exitraster	; .rts
	dwcode	exitraster	;.explain
	dwcode	gameraster	;.main
	dwcode	exitraster	;.pause
	dwcode	exitraster	;.gameover
	dwcode	exitraster	;.training
	dwcode	exitraster	;.title
	dwcode	exitraster	;.mismap
	dwcode	exitraster	;.typesel
	dwcode	exitraster	;.swapbg
	dwcode	exitraster	;.pldown
	dwcode	exitraster	;.clear
	dwcode	exitraster	; etc
	dwcode	exitraster	; etc
	dwcode	exitraster	; etc
 
;====================================================================
exitraster	rts
;====================================================================
;
;
;
;
;
;-------------------------------------------------------------------
;
;
;
;
;
;
;********************************************************************
;	clear ram library
;********************************************************************
;
; A = clear data
; Y = clear RAM index
; X = counter
;
; DBR = clear RAM bank
;
;--------------------------------------------------------------------

LfillRAM	sta.w	0,y
	iny
	iny
	dex
	bne	LfillRAM
	rts

;--------------------------------------------------------------------
;
;
;
;
;
;********************************************************************
;			****************************************
; 1p-game raster		****************************************
;			****************************************
;********************************************************************

gameraster


;-------------------------------------------------------------
	ifeq	AFdebugsea
	lda.l	player1_horizon
	elseif
	Mdebugkeymove	debug_work+10,4,cont1,up,down,A
	lda.l	debug_work+10
	endc
;-------------------------------------------------------------
	sta	horizon_work


;-------------------------------------------------------------------
; game V raster scroll 	( special raster (1p) )
;-------------------------------------------------------------------

	lda	raster_Vswitch
	asl	a
	tax
	jsr	(.Vraster,x)

 
;-------------------------------------------------------------------
; game H raster scroll	( nomal raster )
;-------------------------------------------------------------------

	lda.l	KGameMapPtr
	and	#0fh		; security
	asl	a
	tax
	jmp	(.Hraster,x)

;-------------------------------------------------------------------
; H table
;-------------------------------------------------------------------

.Hraster
	dwcode	no_raster	; 0
	dwcode	no_raster	; 1
	dwcode	fire_raster	; 2	FIRE	RASTER ON
	dwcode	hell_raster	; 3	HELL	RASTER ON
	dwcode	ucyu_raster	; 4	UCYU	RASTER ON
	dwcode	sea_raster	; 5	SEA	RASTER ON
	dwcode	no_raster	; 6
	dwcode	no_raster	; 7
	dwcode	no_raster	; 8
	dwcode	no_raster	; 9
	dwcode	no_raster	; 10
	dwcode	no_raster	; 11
	dwcode	no_raster	; 12
	dwcode	no_raster	; 13
	dwcode	no_raster	; 14
	dwcode	no_raster	; 15

;-------------------------------------------------------------------
; V table
;-------------------------------------------------------------------

.Vraster	dwcode	no_V		; 0
	dwcode	map1_bossVzoom	; 1
	dwcode	seaVzoom	; 2

;-------------------------------------------------------------------
no_V	rts
;-------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;********************************************************************
;			****************************************
; ucyu stage raster		****************************************
;			****************************************
;********************************************************************

ucyu_raster	jsr	set_rasterparam
	db	10h,0feh,0f0h
	jmp	sin_raster

;********************************************************************
;			****************************************
; fire stage raster		****************************************
;			****************************************
;********************************************************************

fire_raster	jsr	set_rasterparam
	db	0,0,0
;;;;;;	db	04h,0ffh,0e0h
	jmp	sin_raster

;********************************************************************
;			****************************************
; hell stage raster		****************************************
;			****************************************
;********************************************************************

hell_raster	jmp	sin_raster

;********************************************************************
;			****************************************
; sea stage raster		****************************************
;			****************************************
;********************************************************************

rasterchange1	equ	0f0h
rasterchange2	equ	280h
displayline		equ	192

;--------------------------------------------------------------------

Msearaster1		macro
		jsr	set_rasterparam
		db	000h,000h,000h
	;;;;	db	020h,0feh,002h
		jsr	many_raster1
		endm

;---------------------------------------------------------------------

Msearaster2		macro
		jsr	set_rasterparam
		db	0c8h,04ch,002h
		jsr	many_raster2
		endm

;---------------------------------------------------------------------

Msearaster3		macro
		jsr	set_rasterparam
		db	008h,011h,008h
		jsr	many_raster3
		endm

;---------------------------------------------------------------------
sea_raster	

	lda	#2		
	sta	raster_Vswitch

	lda.l	kz_tempaddrl	; buffer address pointer
	tay

	lda	#rasterchange1
	sec
	sbc	horizon_work
	beq	sea_entry
	bmi	sea_entry

;--------------------------------------------
; sky mode process
;--------------------------------------------
;
; A = display line count
;
;--------------------------------------------

sky_entry	

	cmp	#displayline
	bcc	.skip
	lda	#displayline
.skip	sta	loop_counter
	sta	stock1

	Msearaster1

	lda	#displayline
	sec
	sbc	stock1
	beq	sea_exit
	sta	loop_counter

	Msearaster2

	rts

;--------------------------------------------
; sea mode process
;--------------------------------------------

sea_entry	stz	stock1
	lda	horizon_work
	sec
	sbc	#rasterchange2
	bcs	.exit

	Mnegative

	cmp	#displayline
	beq	sea_exit
	bcc	.skip
	lda	#displayline

.skip	sta	loop_counter
	sta	stock1

	Msearaster2

.exit	lda	#displayline
	sec
	sbc	stock1
	beq	sea_exit
	bmi	sea_exit
	sta	loop_counter

	Msearaster3

;--------------------------------------------
sea_exit	rts
;--------------------------------------------
;
;
;
;
;
;
;
;===================================================================
;===================================================================
;===================================================================
;===================================================================
;===================================================================
;===================================================================
;===================================================================
;===================================================================
;===================================================================
;
;
;
;
;
;
;
;
;*********************************************************************
;		*************************************************
; SEA VzoomRaster	*************************************************
;		*************************************************
;*********************************************************************


seaVraster1		equ	0a0h	; line 1
seaVraster2		equ	160h	; line 2
seaVraster3		equ	220h	; line 3
seaVstopscroll	equ	270h	; scroll stop line
;;;;; displayline	equ	192

;--------------------------------------------------------------------

seaVzoom
	ldx	#displayline
	lda.l	kz_address
	tay			; Y = Vscroll raster pointer 

	lda	horizon_work	; <<<< raster scroll >>>>

	cmp	#seaVraster1
	bcc	.nomal
	cmp	#seaVraster2	
	bcc	.demo1
	cmp	#seaVraster3
	bcc	.demo2

;---------------------------------------------------------------------

.nomal				; nomal V scroll
				; Y = Vraster pointer
	ldx	#displayline	; X = loop counter
	jsr	LfillRAM
	jmp	voffsetON

;---------------------------------------------------------------

.demo1	jsr	seaVdemo1
	jmp	voffsetOFF	; demo --> Voffset OFF

.demo2	jsr	seaVdemo2
	jmp	voffsetOFF	; demo --> Voffset OFF

;---------------------------------------------------------------------
;	Voffset flag draw
;---------------------------------------------------------------------

voffsetOFF	lda	voffsetflag
	ora	#voffsetflag_p1off
	sta	voffsetflag
	rts

voffsetON	lda	voffsetflag
	and	#voffsetflag_p1off^0ffffh	
	sta	voffsetflag
	rts

;---------------------------------------------------------------------
;	((((( sea -> sky scroll demo )))))
;---------------------------------------------------------------------

seaVdemo2
	ldx	#050h		; <<<<< sky >>>>>
	lda	#seaVraster1
	jsr	LfillRAM
	ldx	#070h		; <<<<< sea >>>>>
	lda	#seaVstopscroll
	jsr	linestop

	lda.l	kz_address
	clc
	adc	#4fh*2		;;;;
	tay

	lda	#seaVraster3
	stz	Vzoomtotal+0
	stz	Vzoomtotal+2
	sta	Vzoomtotal+1

;-------------------------------------

	lda	#seaVraster3
	sec
	sbc	horizon_work
	and	#0fffeh	
	tax
	lda.l	TanData,x
	Mnegative
	asl	a
	sta	Vzoomadd+0
	bpl	.ss1
	lda	#0ffffh
	bra	.sss
.ss1	lda	#0
.sss	sta	Vzoomadd+2

;-------------------------------------

	ldx	#50h		; move scroll counter

.loop2	lda	Vzoomtotal+1
	cmp	#1f0h
	bcc	.exit
	sta.w	0,y
	dey
	dey

	MVzoomadd

	dex
	bne	.loop2
	bra	.exit

;-------------------------------------
.over
.exit
	txa
	Mnegative
	clc
	adc	#50h+seaVraster1
	sta	horizon_work
	rts

;---------------------------------------------------------------------
;	((((( sky -> sea scroll demo )))))
;---------------------------------------------------------------------

seaVdemo1

;---------------------------------------
; stop scroll

	ldx	#050h
	lda	#seaVraster1
	jsr	LfillRAM

	lda	#seaVraster1
	stz	Vzoomtotal+0
	stz	Vzoomtotal+2
	sta	Vzoomtotal+1

;---------------------------------------

	lda	#seaVraster1	
	sec
	sbc	horizon_work	; 0a0h - 15fh
	Mnegative
	and	#0fffeh
	tax
	lda.l	TanData,x
	asl	a
	sta	Vzoomadd+0
	stz	Vzoomadd+2

;-------------------------------------


	ldx	#70h		; move scroll counter

;-----------------------------------------------------

.loop2	lda	Vzoomtotal+1
	cmp	#120h
	bcs	.over
	sta.w	0,y
	iny
	iny

	MVzoomadd

	dex
	bne	.loop2
	bra	.exit

;-----------------------------------------------------

.over	

;	lda	#240h
;	cpx	#40h
;	bcc	.sp
;	lda	#200h
;.sp	
	lda	#300h
	jsr	linestop

.exit	lda	#seaVraster1
	sta	horizon_work
	rts

;*********************************************************************
;	line scroll wo kotei no line ni suru
;*********************************************************************
;
; A = line stop scroll
; Y = pointer 
; X = counter
;
;---------------------------------------------------------------------
linestop
.loop	sta.w	0,y
	iny
	iny
	dec	a
	dex
	bne	.loop
	rts

;---------------------------------------------------------------------
;
;
;
;
;
;
;
;
;
;
;
;
;
;*********************************************************************
;		*************************************************
; VzoomRaster	*************************************************
;		*************************************************
;*********************************************************************

map1_bossVzoom

	stz	Vzoomtotal+0
	stz	Vzoomtotal+2
	lda.l	player1_horizon
	sta	Vzoomtotal+1

	ldx	#0
	lda	raster_Vadd
	Mnegative
	sta	Vzoomadd+0
	bpl	.skip
	dex
.skip	stx	Vzoomadd+2

;-------------------------------------------------------

	lda	raster_Vcenter	; Vzoom start scroll
	sec
	sbc.l	player1_horizon
	bmi	.exit		; error exit
	cmp	#190h
	bcs	.exit		; error exit

	sta	Vzoomcenter
	asl	a
	adc.l	kz_address
	tay			; Y = pointer address
	phy

	lda	#192
	sec
	sbc	Vzoomcenter
	tax			; X = total bytecount

	lda.l	player1_horizon
.loop	sta.w	0,y
	iny
	iny
	dex
	bne	.loop

;-------------------------------------------------------
	ply
	dey
	dey
	ldx	Vzoomcenter

.loop2
	lda	Vzoomtotal+1
	pha
	clc
	adc	Vzoomcenter
	bpl	.go
	pla
	lda	Vzoomcenter
	Mnegative
	bra	.go2
.go	pla
.go2	sta.w	0,y
	dey
	dey

	MVzoomadd

	dec	Vzoomcenter
	bne	.loop2

;-------------------------------------------------------

.exit	rts

;=====================================================================
;
;
;
;
;*********************************************************************
;		*************************************************
; raster parameter	*************************************************
;		*************************************************
;*********************************************************************

set_rasterparam
	plx
	lda.w	1,x
	and	#00ffh
	sta	raster_amp
	lda.w	2,x
	and	#00ffh
	sta	raster_freq
	lda.w	3,x
	and	#00ffh
	sta	raster_speed
	inx
	inx
	inx
	phx
	rts	

;*********************************************************************
;		*************************************************
; NO raster		*************************************************
;		*************************************************
;*********************************************************************
no_raster
;----------------------------------------------------------------------
	lda	#0
	sta	raster_counter
	sta	raster_freq
	sta	raster_amp
	sta	raster_speed
;----------------------------------------------------------------------
;
;
;
;
;
;
;
;----------------------------------------------------------------------
	lda.l	p1_camrotzbuf	; player 1 rolling parameter
	and	#0ff00h
	bne	VoffsetEntry
;----------------------------------------------------------------------
	ldx	#192
	lda.l	kz_tempaddrl	; buffer address pointer
	tay
	lda.l	player1hscroll	; H scroll 
.loop	sta.w	0,y
	iny
	iny
	dex
	bne	.loop
	rts
;---------------------------------------------------------------------
VoffsetEntry
	jsr	V_hosei
;- - - - - - - - - - - - - - - - - - - - -
	lda.l	player1hscroll
	sta	scrollH
;- - - - - - - - - - - - - - - - - - - - -

	lda.l	kz_tempaddrl	; buffer address pointer
	tay
	ldx	#192		; raster line

.loop	lda	scrollH		; Set H scroll
	clc
	adc	Voffset_total+1	;
	sta.w	0,y
	iny
	iny

	MVzoomadd

	dex
	bne	.loop

;- - - - - - - - - - - - - - - - - -
.exit	rts
;---------------------------------------------------------------------

	
;*********************************************************************
;		*************************************************
; sin raster many	*************************************************
;		*************************************************
;*********************************************************************

many_raster3	ldx	#4
	bra	many_raster
many_raster2	ldx	#2
	bra	many_raster
many_raster1	ldx	#0
;- - - - - - - - - - - - - - - - - -
many_raster	phx			; >>
	stz	Voffset_total+0
	stz	Voffset_total+2
	stz	Voffset_add+0
	stz	Voffset_add+2
	lda	raster_counter,x
	tax
	asl	a
	sta	add_freq
;- - - - - - - - - - - - - - - - - -
	lda	raster_freq
	and	#00ffh
	sta	data_freq	; <----- FREQ
	lda	raster_amp
	sta	data_amp	; <----- AMP
;- - - - - - - - - - - - - - - - - -
	jsr	SetRasterdata
;- - - - - - - - - - - - - - - - - -
	clc
	plx			; <<
	lda	raster_speed	; <----- SPEED
	adc	raster_counter,x
	and	#00ffh
	sta	raster_counter,x
;- - - - - - - - - - - - - - - - - -
	rts




;*********************************************************************
;		*************************************************
; sin wave raster	*************************************************
;		*************************************************
;*********************************************************************

sin_raster

	lda	raster_freq
	ora	raster_amp
	ora	raster_speed
	bne	.entry

	jmp	no_raster

;- - - - - - - - - - - - - - - - - - - - - -
.entry
	
;- - - - - - - - - - - - - - - - - - - - - -
	jsr	V_hosei
;- - - - - - - - - - - - - - - - - - - - - -


	lda	#192		; raster line counter
	sta	loop_counter

;- - - - - - - - - - - - - - - - - -
	ldx	raster_counter
	txa
	asl	a
	sta	add_freq
;- - - - - - - - - - - - - - - - - -
	lda	raster_freq
	and	#00ffh
	sta	data_freq	; <----- FREQ
	lda	raster_amp
	sta	data_amp	; <----- AMP
;- - - - - - - - - - - - - - - - - -
	lda.l	kz_tempaddrl	; buffer address pointer
	tay
	jsr	SetRasterdata
;- - - - - - - - - - - - - - - - - -
	clc
	lda	raster_speed	; <----- SPEED
	adc	raster_counter
	and	#00ffh
	sta	raster_counter
;- - - - - - - - - - - - - - - - - -
	rts


;*********************************************************************
;		 ************************************************
; sin raster mainloop ************************************************
;		 ************************************************
;*********************************************************************
;
; x ... NOW sintable index
;
;;
;; loop_counter	;
;;
;; add_freq		; sintable add
;; data_freq		; sintable pointer
;;
;;
;; scrollH		; now bg scroll
;; work_mult 	: 
;; Voffset_total	; ( V-offset )
;; Voffset_add	; ( V-offset )
;;
;;
;=====================================================================

SetRasterdata

	lda.l	player1hscroll
	sta	scrollH
;-------------------------------------------
.loop
	a8
	lda.l	RasterData,x
	sta	work_mult+1
	bpl	.skip11
	eor	#0ffh
	inc	a
.skip11	sta.l	4202h	
	lda	data_amp
	sta.l	4203h
	nop			; 2 cycle
	a16			; 3 cycle
	lda	#00ffh		; 3 cycle
	and.l	4217h
	bit	work_mult+0
	bpl	.skip12
	eor	#0ffffh
	inc	a
.skip12
	clc
	adc	scrollH	; Set H parameter
	clc
	adc	Voffset_total+1
	sta.w	0,y
	iny
	iny

	lda	add_freq	; F parameter  add
	clc
	adc	data_freq
	and	#01ffh
	sta	add_freq
	lsr	a
	tax

	MVzoomadd

	dec	loop_counter
	bne	.loop
	rts

;*********************************************************************
;		*************************************************
; mode2 Vbank hosei	*************************************************
;		*************************************************
;*********************************************************************


V_hosei
	ldy	#70h		; center of screen

;-----------------------------------------

	lda.l	p1_camrotzbuf	; player 1 rolling parameter
	cmp	#0
	bpl	.skip1
	cmp	#0f900h
	bcs	.skip2
	lda	#0f900h
	bra	.skip2
.skip1	cmp	#00700h
	bcc	.skip2
	lda	#00700h
.skip2
;-----------------------------------------
	ldx	#7
	cmp	#0
	Mdiv
;- - - - - - - - - - - - - - - - - - - - - -
	Masr1
	Masr1
	Masr1
	sta	Voffset_add+0
;- - - - - - - - - - - - - - - - - - - - - -

	jsl	MLS16S16

	sty	Voffset_total+0
	sta	Voffset_total+2

	ldx	#0
	lda	Voffset_add+0
	eor	#0ffffh
	inc	a
	sta	Voffset_add+0
	bpl	.skip
	dex
.skip	stx	Voffset_add+2

	rts

;=====================================================================
;
;
;
;
;
;
;
;
;
;
;
;
;
;=====================================================================
;=====================================================================
;============= Library Program =======================================
;============= Library Program =======================================
;=====================================================================
;=====================================================================


;*********************************************************************
;		*************************************************
; TAN TABLE 		*************************************************
;		*************************************************
;*********************************************************************

dwss 	macro
	dw	\1-255
	endm

TanData

	dw	0
	dw	4
	dw	8
	dw	12
	dw	16
	dw	20
	dw	25
	dw	29
	dw	33
	dw	37
	dw	42
	dw	46
	dw	50
	dw	55
	dw	59
	dw	64
	dw	68
	dw	73
	dw	77
	dw	82
	dw	86
	dw	91
	dw	96
	dw	101
	dw	106
	dw	110
	dw	115
	dw	121
	dw	126
	dw	131
	dw	136
	dw	142
	dw	147
	dw	153
	dw	159
	dw	165
	dw	171
	dw	177
	dw	183
	dw	189
	dw	196
	dw	203
	dw	210
	dw	217
	dw	224
	dw	232
	dw	239
	dw	247
	dw	255
	dw	264
	dw	273
	dw	282
	dw	291
	dw	301
	dw	311
	dw	322
	dw	333
	dw	345
	dw	357
	dw	369
	dw	383
	dw	397
	dw	411
	dw	427
	dw	443
	dw	460
	dw	478
	dw	498
	dw	519
	dw	541
	dw	565
	dw	590
	dw	618
	dw	647
	dw	680
	dw	715
	dw	754
	dw	796
	dw	843
	dw	896
	dw	955
	dw	1022
	dw	1097
	dw	1185
	dw	1286
	dw	1406
	dw	1550
	dw	1725
	dw	1944
	dw	2225
	dw	2599
	dw	3122
	dw	3905
	dw	5210
	dw	7819
	dw	15643
	dw	15643
	dw	15643
	dw	15643


;*********************************************************************
;		*************************************************
; MULTIPLY		*************************************************
;		*************************************************
;*********************************************************************
;
; MULTIPLY signed 16bit * signed 16bit
;
; Usage: sBA*sYY=sBAYY ;mW:xW
;
;	jsl	ML_s16s16_l
;
;--------------------------------------------------------------------

product		equ	Xwork6	; library memory
multiplier		equ	Xwork7	; library memory

;--------------------------------------------------------------------
ML_s16s16_l
MLS16S16
	Mbank0
	PHX		
	JSR	Xml_s16s16
	PLX
	Mbankrtl

;- - - - - - - - - - - - - - - - - - - - - - - - - - -
Xml_s16s16	TYX			  	    	;W
	BPL	Multiply_s16u16
	TAY				;W
	BPL	s16s16_skip
	EOR	#0ffffh			;W
	INC	A			;W
	TAY				;W
	TXA				;W
	EOR	#0ffffh			;W
	INC	A			;W
	BRA	Multiply_s16u16
s16s16_skip	TXA				;W
	BRA	Multiply_s16u16	    	;mW:xW
;-----------------------------------------------------------------------
						;sBA*uYY=sBAYY
Multiply_s16u16 
	CMP	#8000h			;W
	BCC	Multiply_u16u16	
	EOR	#0ffffh			;W
	INC	A			;W
	JSR	Multiply_u16u16
	EOR	#0ffffh			;W
	TAX				;W
	TYA				;W
	EOR	#0ffffh			;W
	TAY				;W
	INY				;W
	BNE	s16u16_skip		;W
	INX				;W
s16u16_skip	TXA				;W
	RTS
;-----------------------------------------------------------------------
Multiply_u16u16 
	STY	multiplier		;W
	SEP	#00110000B
	STA	XMultiplicand		;B
	STY	XMultiplier		;B
	REP	#00100001B
	XBA
	TAX				;B
	LDY	multiplier+1		;B
	LDA	XProduct		;W
	STY	XMultiplier		;B
	STA	product			;W
	XBA
	AND	#00ffh			;W
	ADC	XProduct		;W
	LDY	multiplier+0		;B
	STX	XMultiplicand		;B
	STY	XMultiplier		;B
	NOP
	LDY	multiplier+1		;B
	ADC	XProduct		;W
	STY	XMultiplier		;B
	STA	product+1		;W
	AND	#0ff00h			;W
	ADC	#0			;W
	XBA
	REP	#00010001B
	LDY	product			;W
	ADC	XProduct		;W
	RTS				;mW:xW

;====================================================================
;====================================================================
; END END END END END END END END END END END END END END END END 
;====================================================================
;====================================================================

