;*********************************************************************
;		eXgvO	(Zbg[`j
;			programed by H.Yajima
;*********************************************************************
		include	Xmacro.def
		include Pmacro.def
		include	RP5A22X
		include	RP5C77X
;---------------------------------------------------------------------
		include	register.alc
;---------------------------------------------------------------------
		glb	RESET
		ext	Entry_RESET
		ext	Entry_COP,Entry_BRK,Entry_NMI,Entry_IRQ
;---------------------------------------------------------------------
bank0	sect	rel
		extend
		mem16
		idx16
;*********************************************************************
;		̑̊荞
;*********************************************************************
Emulate_NMI
Emulate_IRQ	rti
Emulate_BRK
NOT_USE	
		lda.l	05fffffh	;( NO MOUNT AREA ACSESS )
		lda.l	05fffffh
		jmp.l	NOT_USE

;*********************************************************************
;		d qdrds
;*********************************************************************
; PBR PC     DBR SP   D	   C(B,A) X	Y    P(NVMXDIZC)E
; 00  (FFFC) 00	 01** 0000 00**	  00**	00**   **1101** 1
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
		mem8
		idx8
RESET		clc
		xce			; set native mode
		sei			; IRQ disable
		stz	NMI_control	; NMI disable
		stz	DMA_syncro	; H DMA off
		stz	DMA_burst	; V DMA off
		lda	#80h		; screen branking
		sta	PPU_control	; = 2100h
		stz	Out_expansive	; = 4016h
		lda	#0ffh		
		sta	Out_auxilary	; = 4201h

;- - - - - - - - - - - - - - - - - - - - - - -
		a16xW				; 0bank [NtZbg
		MresetClear	0,0e0h
		MresetClear	100h,1f00h
;- - - - - - - - - - - - - - - - - - - - - - -
		ldx	#02h			; dnmcheck
.loop		lda	power_on_work,x
		cmp	power_on_data,x
		bne	Power_on_reset
		dex
		dex
		bpl	.loop
		bra	Hard_reset
;- - - - - - - - - - - - - - - - - - - - - - -
Power_on_reset	
		MresetClear	0e0h,020h
;- - - - - - - - - - - - - - - - - - - - - - - 
		lda	power_on_data+0	; Set Password
		sta	power_on_work+0
		lda	power_on_data+2
		sta	power_on_work+2
;- - - - - - - - - - - - - - - - - - - - - - -
Hard_reset	
;- - - - - - - - - - - - - - - - - - - - - - -
		lda	#1fffh			; set stack
		tcs
;- - - - - - - - - - - - - - - - - - - - - - - - - -
		Mmvn	vector_data,chip_BRK,4*4
;- - - - - - - - - - - - - - - - - - - - - - - - - -
		MclearRAM	7e2000h,0e000h,0	; RAM clear
		MclearRAM	7f8000h,08000h,0	; RAM clear
		MclearRAM	700000h,08000h,00000h	; Mario RAM clear
		MclearRAM	708000h,08000h,00000h	; Mario RAM clear
;- - - - - - - - - - - - - - - - - - - - - - -
		jmp.l	Entry_RESET
;***********************************************************************
vector_data	jmp.l	Entry_BRK
		jmp.l	Entry_COP
		jmp.l	Entry_NMI
		jmp.l	Entry_IRQ
;***********************************************************************
power_on_data	dw	1234h,5678h
;***********************************************************************
;		ZbgxNg
;***********************************************************************
	ORG	0FFE0H
;------------------------------------------ ; native mode ------------
	dw	0000h,0000h
	dw	NOT_USE		; ffe4
	dw	chip_COP	; ffe6
	dw	chip_BRK	; ffe8
	dw	chip_NMI	; NMI entry
	dw	NOT_USE		; ff
	dw	chip_IRQ	; IRQ entry
;------------------------------------------ ; emulation mode ---------
	dw	0000h,0000h	
	dw	Emulate_BRK	; fff4
	dw	Emulate_BRK	; fff6
	dw	Emulate_BRK	; fff8
	dw	Emulate_NMI	; not use
	dw	RESET		; program entry
	dw	Emulate_IRQ	; not use 
;---------------------------------------------------------------------
		END
