;ͻ
; FILE:                CURDAT.ASM                           
; AUTHOR:              Takumi Kawagoe   Nintendo.co.ltd  EDA
; DESCRIPTION:         SPRITE DATA OF CURSOR                
; DATE CREATED:        3-9-93                               
;ͼ

;	INCPUBLICS	display.ext

	SHORTA
	LONGI

cb1tab	macro
	dw	\1
	dw	\2!\3<<4!((\4&1)<<8)!((\5&1)<<9)!(\6<<12)
	endm
cursprtable

	dw	.F&WM	;0
	dw	.L&WM	;1
	dw	.R&WM	;2
	dw	.U&WM	;3
	dw	.D&WM	;4
	dw	.UL&WM	;5
	dw	.UR&WM	;6
	dw	.DL&WM	;7
	dw	.DR&WM	;8
	dw	.NULL&WM	;9
	dw	.LOCKED&WM	;10


;cursor ROMPOINTER & shift data
;		POINTER,SHIFT(L),SHIFT(U),FLIP(LR),FLIP(UD)


.F
	cb1tab	EcursorF&WM,0,0,0,0,0eh
	cb1tab	EcursorF1&WM,0,0,0,0,0eh
	cb1tab	EcursorF&WM,0,0,0,0,0eh
	cb1tab	EcursorF1&WM,0,0,0,0,0eh
	cb1tab	EcursorF&WM,0,0,0,0,0eh
	cb1tab	EcursorF1&WM,0,0,0,0,0eh

.L
	cb1tab	EcursorL0&WM,0,0,0,0,0eh
	cb1tab	EcursorL1&WM,0,0,0,0,0eh
	cb1tab	EcursorL2&WM,0,0,0,0,0eh
	cb1tab	EcursorL1&WM,4,0,0,0,0eh
	cb1tab	EcursorL0&WM,8,0,0,0,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.R
	cb1tab	EcursorL0&WM,0,0,1,0,0eh
	cb1tab	EcursorL1&WM,0,0,1,0,0eh
	cb1tab	EcursorL2&WM,0,0,1,0,0eh
	cb1tab	EcursorL1&WM,4,0,1,0,0eh
	cb1tab	EcursorL0&WM,8,0,1,0,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.U
	cb1tab	EcursorU0&WM,0,0,0,0,0eh
	cb1tab	EcursorU1&WM,0,0,0,0,0eh
	cb1tab	EcursorU2&WM,0,0,0,0,0eh
	cb1tab	EcursorU1&WM,0,4,0,0,0eh
	cb1tab	EcursorU0&WM,0,8,0,0,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.D
	cb1tab	EcursorU0&WM,0,0,0,1,0eh
	cb1tab	EcursorU1&WM,0,0,0,1,0eh
	cb1tab	EcursorU2&WM,0,0,0,1,0eh
	cb1tab	EcursorU1&WM,0,4,0,1,0eh
	cb1tab	EcursorU0&WM,0,8,0,1,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.UL
	cb1tab	EcursorLU0&WM,0,0,0,0,0eh
	cb1tab	EcursorLU1&WM,0,0,0,0,0eh
	cb1tab	EcursorLU2&WM,0,0,0,0,0eh
	cb1tab	EcursorLU1&WM,3,3,0,0,0eh
	cb1tab	EcursorLU0&WM,6,6,0,0,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.UR
	cb1tab	EcursorLU0&WM,0,0,1,0,0eh
	cb1tab	EcursorLU1&WM,0,0,1,0,0eh
	cb1tab	EcursorLU2&WM,0,0,1,0,0eh
	cb1tab	EcursorLU1&WM,3,3,1,0,0eh
	cb1tab	EcursorLU0&WM,6,6,1,0,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.DL
	cb1tab	EcursorLU0&WM,0,0,0,1,0eh
	cb1tab	EcursorLU1&WM,0,0,0,1,0eh
	cb1tab	EcursorLU2&WM,0,0,0,1,0eh
	cb1tab	EcursorLU1&WM,3,3,0,1,0eh
	cb1tab	EcursorLU0&WM,6,6,0,1,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh

.DR
	cb1tab	EcursorLU0&WM,0,0,1,1,0eh
	cb1tab	EcursorLU1&WM,0,0,1,1,0eh
	cb1tab	EcursorLU2&WM,0,0,1,1,0eh
	cb1tab	EcursorLU1&WM,3,3,1,1,0eh
	cb1tab	EcursorLU0&WM,6,6,1,1,0eh
	cb1tab	EcNULL&WM,0,0,0,0,0eh



.NULL
	cb1tab	EcNULL&WM,0,0,0,0,0
	cb1tab	EcNULL&WM,0,0,0,0,0
	cb1tab	EcNULL&WM,0,0,0,0,0
	cb1tab	EcNULL&WM,0,0,0,0,0
	cb1tab	EcNULL&WM,0,0,0,0,0
	cb1tab	EcNULL&WM,0,0,0,0,0


.locked
	cb1tab	EcurLOCKED0&WM,0,0,0,0,2	; dummy
	cb1tab	EcurLOCKED0&WM,0,0,0,0,2
	cb1tab	EcurLOCKED1&WM,0,0,0,0,2
	cb1tab	EcurLOCKED2&WM,0,0,0,0,2
	cb1tab	EcurLOCKED3&WM,0,0,0,0,14
	cb1tab	EcurLOCKED3&WM,0,0,0,0,14
	cb1tab	EcurLOCKED3&WM,0,0,0,0,14


EcNULL
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3

EcursorF
	dw	%0000001111000000	;0
	dw	%0000110110110000	;1
	dw	%0011000000001100	;2
	dw	%0011000000001100	;3
	dw	%0100000000000010	;0
	dw	%0100000000000010	;1
	dw	%1000000000000001	;2
	dw	%1100000110000011	;3

	dw	%1100000110000011	;0
	dw	%1000000000000001	;1
	dw	%0100000000000010	;2
	dw	%0100000000000010	;3
	dw	%0011000000001100	;0
	dw	%0011000000001100	;1
	dw	%0000110110110000	;2
	dw	%0000001111000000	;3

EcursorF1

	dw	%0000001111000000	;0
	dw	%0000110000110000	;1
	dw	%0001000000001000	;2
	dw	%0010000000000100	;3
	dw	%0100000000000010	;0
	dw	%0100000000000010	;1
	dw	%1000000000000001	;2
	dw	%1000000000000001	;3

	dw	%1000000000000001	;0
	dw	%1000000000000001	;1
	dw	%0100000000000010	;2
	dw	%0100000000000010	;3
	dw	%0010000000000100	;0
	dw	%0001000000001000	;1
	dw	%0000110000110000	;2
	dw	%0000001111000000	;3



;	dw	%0011111001111100	;0
;	dw	%0100000000000010	;1
;	dw	%0100000000000010	;2
;	dw	%0100000000000010	;3
;	dw	%1000000000000001	;4
;	dw	%1000000000000001	;5
;	dw	%1000000000000001	;6
;	dw	%0000000000000000	;7
;
;	dw	%0000000000000000	;8
;	dw	%1000000000000001	;9
;	dw	%1000000000000001	;0
;	dw	%1000000000000001	;1
;	dw	%0100000000000010	;2
;	dw	%0100000000000010	;3
;	dw	%0100000000000010	;4
;	dw	%0011111001111100	;5

EcursorL0
	dw	%0000000000000000	;0
	dw	%0000000000000011	;1
	dw	%0000000000000101	;2
	dw	%0000000000001001	;3
	dw	%0000000000010001	;4
	dw	%0000000000100001	;5
	dw	%0000000001000001	;6
	dw	%0000000010000001	;7
	dw	%0000000010000001	;8
	dw	%0000000001000001	;9
	dw	%0000000000100001	;0
	dw	%0000000000010001	;1
	dw	%0000000000001001	;2
	dw	%0000000000000101	;3
	dw	%0000000000000011	;4
	dw	%0000000000000000	;5

EcursorL1
	dw	%0000000000000000	;0
	dw	%0000000000110011	;1
	dw	%0000000001010101	;2
	dw	%0000000010011001	;3
	dw	%0000000100010001	;4
	dw	%0000001000010001	;5
	dw	%0000010000010001	;6
	dw	%0000100000010001	;7
	dw	%0000100000010001	;8
	dw	%0000010000010001	;9
	dw	%0000001000010001	;0
	dw	%0000000100010001	;1
	dw	%0000000010011001	;2
	dw	%0000000001010101	;3
	dw	%0000000000110011	;4
	dw	%0000000000000000	;5
EcursorL2
	dw	%0000000000000000	;0
	dw	%0000001100110011	;1
	dw	%0000010101010101	;2
	dw	%0000100110011001	;3
	dw	%0001000100010001	;4
	dw	%0010000100010001	;5
	dw	%0100000100010001	;6
	dw	%1000000100010001	;7
	dw	%1000000100010001	;8
	dw	%0100000100010001	;9
	dw	%0010000100010001	;0
	dw	%0001000100010001	;1
	dw	%0000100110011001	;2
	dw	%0000010101010101	;3
	dw	%0000001100110011	;4
	dw	%0000000000000000	;5

EcursorLU0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3
	dw	%0000000000000000	;4
	dw	%0000000000000000	;5
	dw	%0000001111111111	;6
	dw	%0000001000000010	;7
	dw	%0000001000000100	;8
	dw	%0000001000001000	;9
	dw	%0000001000010000	;0
	dw	%0000001000100000	;1
	dw	%0000001001000000	;2
	dw	%0000001010000000	;3
	dw	%0000001100000000	;4
	dw	%0000001000000000	;5
EcursorLU1
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0001111111111000	;3
	dw	%0001000000010000	;4
	dw	%0001000000100000	;5
	dw	%0001000001111111	;6
	dw	%0001000010000010	;7
	dw	%0001000100000100	;8
	dw	%0001001000001000	;9
	dw	%0001011000010000	;0
	dw	%0001101000100000	;1
	dw	%0001001001000000	;2
	dw	%0000001010000000	;3
	dw	%0000001100000000	;4
	dw	%0000001000000000	;5
EcursorLU2
	dw	%1111111111000000	;0
	dw	%1000000010000000	;1
	dw	%1000000100000000	;2
	dw	%1000001111111000	;3
	dw	%1000010000010000	;4
	dw	%1000100000100000	;5
	dw	%1001000001111111	;6
	dw	%1011000010000010	;7
	dw	%1101000100000100	;8
	dw	%1001001000001000	;9
	dw	%0001011000010000	;0
	dw	%0001101000100000	;1
	dw	%0001001001000000	;2
	dw	%0000001010000000	;3
	dw	%0000001100000000	;4
	dw	%0000001000000000	;5
EcursorU0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3
	dw	%0000000000000000	;4
	dw	%0000000000000000	;5
	dw	%0000000000000000	;6
	dw	%0000000000000000	;7
	dw	%0000000110000000	;8
	dw	%0000001001000000	;9
	dw	%0000010000100000	;0
	dw	%0000100000010000	;1
	dw	%0001000000001000	;2
	dw	%0010000000000100	;3
	dw	%0100000000000010	;4
	dw	%0111111111111110	;5
EcursorU1
	dw	%0000000000000000	;0
	dw	%0000000000000000	;1
	dw	%0000000000000000	;2
	dw	%0000000000000000	;3
	dw	%0000000110000000	;4
	dw	%0000001001000000	;5
	dw	%0000010000100000	;6
	dw	%0000100000010000	;7
	dw	%0001000000001000	;8
	dw	%0010000000000100	;9
	dw	%0100000000000010	;0
	dw	%0111111111111110	;1
	dw	%0001000000001000	;2
	dw	%0010000000000100	;3
	dw	%0100000000000010	;4
	dw	%0111111111111110	;5
EcursorU2
	dw	%0000000110000000	;0
	dw	%0000001001000000	;1
	dw	%0000010000100000	;2
	dw	%0000100000010000	;3
	dw	%0001000000001000	;4
	dw	%0010000000000100	;5
	dw	%0100000000000010	;6
	dw	%0111111111111110	;7
	dw	%0001000000001000	;8
	dw	%0010000000000100	;9
	dw	%0100000000000010	;0
	dw	%0111111111111110	;1
	dw	%0001000000001000	;2
	dw	%0010000000000100	;3
	dw	%0100000000000010	;4
	dw	%0111111111111110	;5

AWMETERtab	dw	.d1&WM,.d2&WM,.d3&WM
	dw	.d1&WM,.d4&WM,.d5&WM

	dw	.AM1&WM	;6
	dw	.AM2&WM	;7
	dw	.AM3&WM	;8
	dw	.AM4&WM	;9
	dw	.AM5&WM	;10
	dw	.RB1&WM	;11
	dw	.RB2&WM	;12
	dw	.RB3&WM	;13

.d1	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000000000000	;5
	dw	%000000011000	;6
	dw	%000011111111	;7
	dw	%000010000001	;8
	dw	%000000000000	;9
	dw	%000000000000	;a
	;dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.d2	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000010000001	;5
	dw	%000011000011	;6
	dw	%000011111111	;7
	dw	%000000011000	;8
	dw	%000000011000	;9
	dw	%000000000000	;a
	dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.d3	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000010000001	;4
	dw	%000011000011	;5
	dw	%000011011011	;6
	dw	%000011111111	;7
	dw	%000000011000	;8
	dw	%000000011000	;9
	dw	%000000011000	;a
	;dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.d4
	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000000011000	;5
	dw	%000000011000	;6
	dw	%000011111111	;7
	dw	%000011000011	;8
	dw	%000010000001	;9
	dw	%000010000001	;a
	dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.d5
	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000011000	;4
	dw	%000000011000	;5
	dw	%000000011000	;6
	dw	%000011111111	;7
	dw	%000011011011	;8
	dw	%000011000011	;9
	dw	%000010000001	;a
	dw	%000010000001	;b
	dw	%000000000000	;c
	dw	%000000000000	;d
	dw	%000000000000	;e
	dw	%000000000000	;f


;AMMETERtab	dw	.d1&WM,.d2&WM,.d3&WM,.d4&WM,.d5&WM
.AM1
.AM2
.AM3
.AM4
.AM5
	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000001000010	;5
	dw	%000001000010	;6
	dw	%000001011010	;7
	dw	%000011111111	;8
	dw	%000011011011	;9
	dw	%000011000011	;a
	dw	%000001000010	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

	IFEQ	1
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
.AM2	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000000000000	;5
	dw	%000001000010	;6
	dw	%000001011010	;7
	dw	%000011111111	;8
	dw	%000011011011	;9
	dw	%000001000010	;a
	;dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.AM3	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000000000000	;5
	dw	%000000000000	;6
	dw	%000001011010	;7
	dw	%000011111111	;8
	dw	%000001011010	;9
	;dw	%000000000000	;a
	;dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.AM4	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000000000000	;5
	dw	%000001000010	;6
	dw	%000011011011	;7
	dw	%000011111111	;8
	dw	%000001011010	;9
	dw	%000001000010	;a
	;dw	%000000000000	;b
	;dw	%000000000000	;c
	;dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f

.AM5	dw	%000000000000	;0
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4
	dw	%000001000010	;5
	dw	%000011000011	;6
	dw	%000011011011	;7
	dw	%000011111111	;8
	dw	%000001011010	;9
	dw	%000001000010	;a
	dw	%000001000010	;b
	dw	%000000000000	;c
	dw	%000000000000	;d
	;dw	%000000000000	;e
	;dw	%000000000000	;f
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

	ENDC


;RBMETERtab	dw	.d1&WM,.d2&WM,.d3&WM

.RB1
	dw	%000000000000	;0
	dw	%000000000000	;5
	dw	%000001011010	;6
	dw	%000001111110	;7
	dw	%000001011010	;8
	dw	%000001000010	;9
	dw	%000001000010	;a
	dw	%000001000010	;b
	dw	%000000000000	;c
	dw	%000000000000	;d
	dw	%000000000000	;e
	dw	%000000000000	;f
	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	;dw	%000000000000	;4

.RB2
	dw	%000000000000	;0
	dw	%000001000000	;5
	dw	%000001011010	;6
	dw	%000001111110	;7
	dw	%000001011010	;8
	dw	%000001000010	;9
	dw	%000001000010	;a
	dw	%000000000010	;b
	dw	%000000000000	;c
	dw	%000000000000	;d
	dw	%000000000000	;e
	dw	%000000000000	;f

	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	;dw	%000000000000	;4

.RB3
	dw	%000000000000	;0
	dw	%000000000010	;5
	dw	%000001011010	;6
	dw	%000001111110	;7
	dw	%000001011010	;8
	dw	%000001000010	;9
	dw	%000001000010	;a
	dw	%000001000000	;b
	dw	%000000000000	;c
	dw	%000000000000	;d
	dw	%000000000000	;e
	dw	%000000000000	;f

	dw	%000000000000	;1
	dw	%000000000000	;2
	dw	%000000000000	;3
	dw	%000000000000	;4


EcurLOCKED0


	dw	%0000000000000000	;0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;0
	dw	%0000011111100000	;0
	dw	%0000100000010000	;0
	dw	%0000100000010000	;0
	dw	%0000100000010000	;0
	dw	%0000100000010000	;0
	dw	%0000100000010000	;0
	dw	%0000100000010000	;0
	dw	%0000011111100000	;0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;0


EcurLOCKED1

	dw	%0000000000000000	;0
	dw	%0000000000000000	;0
	dw	%0000001111000000	;0
	dw	%0000010000100000	;0
	dw	%0000100000010000	;0
	dw	%0001000000001000	;0
	dw	%0010000000000100	;0
	dw	%0010000000000100	;0

	dw	%0010000000000100	;0
	dw	%0010000000000100	;0
	dw	%0001000000001000	;0
	dw	%0000100000010000	;0
	dw	%0000010000100000	;0
	dw	%0000001111000000	;0
	dw	%0000000000000000	;0
	dw	%0000000000000000	;0



EcurLOCKED2

	dw	%0000001111000000	;0
	dw	%0111100110011110	;0
	dw	%1100000000000011	;0
	dw	%1000000000000001	;0
	dw	%1000001111000001	;0
	dw	%1000010000100001	;0
	dw	%1000100000010001	;0
	dw	%1000100000010001	;0

	dw	%1000100000010001	;0
	dw	%1000100000010001	;0
	dw	%1000010000100001	;0
	dw	%1000001111000001	;0
	dw	%1000000000000001	;0
	dw	%1100000000000011	;0
	dw	%0111100110011110	;0
	dw	%0000001111000000	;0

EcurLOCKED3
	dw	%0000001111000000	;0
	dw	%0111101111011110	;0
	dw	%1100000110000011	;0
	dw	%1000000000000001	;0
	dw	%1000000000000001	;0
	dw	%1000000110000001	;0
	dw	%1000000110000001	;0
	dw	%1000000110000001	;0

	dw	%1000000110000001	;0
	dw	%1000000110000001	;0
	dw	%1000000110000001	;0
	dw	%1000000000000001	;0
	dw	%1000000000000001	;0
	dw	%1100000110000011	;0
	dw	%0111101111011110	;0
	dw	%0000001111000000	;0





	IFEQ	1
EcurLOCKED2
	dw	%0000011111110000	;0
	dw	%0000010000001000	;0
	dw	%0000001111100100	;0
	dw	%0000000110010010	;0
	dw	%0000000000001001	;0
	dw	%1100000000000101	;0
	dw	%1010000000000101	;0
	dw	%1011000000001101	;0

	dw	%1011000000001101	;0
	dw	%1010000000000101	;0
	dw	%1010000000000011	;0
	dw	%1001000000000000	;0
	dw	%0100100110000000	;0
	dw	%0010011111000000	;0
	dw	%0001000000100000	;0
	dw	%0000111111100000	;0

EcurLOCKED3

	dw	%0000111111100000	;0
	dw	%0001000000100000	;0
	dw	%0010011111000000	;0
	dw	%0100100000000000	;0
	dw	%1001000000000000	;0
	dw	%1010000000000011	;0
	dw	%1010000000000101	;0
	dw	%1010000110000101	;0

	dw	%0000000110000101	;0
	dw	%0000000000000101	;0
	dw	%0000000000000101	;0
	dw	%0000000000001001	;0
	dw	%0000000000010010	;0
	dw	%0000001111100100	;0
	dw	%0000010000001000	;0
	dw	%0000011111110000	;0
	ENDC

	end


