;**************************************************************************
;;
;;	OBJ ANIMATION DATA (d3-3.OBX)
;;
;**************************************************************************
;;
;;
;;
;;
;;
;;
;;
;---------------------------------------------------------------------
	INCPUB	chartdat
;---------------------------------------------------------------------
;
;
;
;
;
;*********************************************************************
;
; map animation program end
;
;*********************************************************************
MAend	macro
	db	81h
	endm

;---------------------------------------------------------------------




;*********************************************************************
;	map animation obj macros
;*********************************************************************

;---------------------------------------------------------------------

oamdata_pri0		equ	00h
oamdata_pri1		equ	10h
oamdata_pri2		equ	20h
oamdata_pri3		equ	30h

oamdata_attr0	equ	0
oamdata_attr1	equ	2
oamdata_attr2	equ	4
oamdata_attr3	equ	6
oamdata_attr4	equ	8
oamdata_attr5	equ	10
oamdata_attr6	equ	12
oamdata_attr7	equ	14

oamdata_hvflip	equ	0c0h
oamdata_hflip	equ	40h
oamdata_vflip	equ	80h
oamdata_nflip	equ	00h

;---------------------------------------------------------------------
mapanime_liststart	macro
mapanime_number = 0
	endm

;---------------------------------------------------------------------
mapanime_list	macro	[addr]
	dw	{addr}-ROMobjchart
cd_{addr}	equ	mapanime_number
mapanime_number = mapanime_number+1
	endm

;---------------------------------------------------------------------
mapanime_listend	macro
	printf	"list %xmapanime_number   "
	endm
;---------------------------------------------------------------------

mapobj_oamdata	macro	[h,v,fp,pno,ano,char]
	db	{h},{v}
	db	{char}&0ffh
	db	oamdata_pri{pno}+oamdata_attr{ano}+oamdata_{fp}flip+{char}/256
	endm

;---------------------------------------------------------------------
ROMobjchart
;**************************************************************************
;;
;;	OBJ ANIMATION DATA (d3-3.OBX)
;;
;**************************************************************************
;;
;;
;;
;;
;;
;;
;;
;**************************************************************************
;	macros
; 	kurukuru loop (MUTEKI ATTR)
;**************************************************************************

;-----------------------------------------------------------
; kurukuru frash
;-----------------------------------------------------------
Mmapobjbig	macro	[count]
	db	{count}
	endm

;-----------------------------------------------------------
; kurukuru frash
;-----------------------------------------------------------
Mmapobjsmall macro	[count]
	db	{count}+80h
	endm

;-----------------------------------------------------------
; kurukuru frash
;-----------------------------------------------------------
Msetmapdemo	macro	[ofs]
	db	81h	; frash
	dw	{ofs}
	endm

;-----------------------------------------------------------
; kurukuru normal
;-----------------------------------------------------------
Msetmapchar	macro	[ofs]
	db	80h	; normal
	dw	{ofs}
	endm

;-----------------------------------------------------------
; map obj jmp
;-----------------------------------------------------------
Mmapobjjmp	macro	[label]
nowaddr	=	*
	db	82h
	dw	{label}-nowaddr
	endm
;-----------------------------------------------------------
; map obj jmp
;-----------------------------------------------------------
Mmapobj16	macro
	db	83h
	endm

;==========================================================================



;**************************************************************************
;;	MAP SPRITE ANIMATION SEQ TABLE
;**************************************************************************

seqtable_d3_3
	mapanime_liststart
	mapanime_list	objtable_d3_3		;(0) =	obj address
	mapanime_list	objanime_dmmy_2		;(1) <<<<< stepup >>>>>
	mapanime_list	objanime_sos1		;(2) sos 1 start demo 
	mapanime_list	objanime_sos2		;(3) sos 2 start demo
	mapanime_list	objanime_dmmy_4		;(4) boss ship sprite
	mapanime_list	objanime_bigcursor	;(5)
	mapanime_list	objanime_smallcursor	;(6)
	mapanime_list	objanime_sosbomb	;(7)
	mapanime_list	objanime_faceopen	;(8) 
	mapanime_list	objanime_faceclose	;(9)
	mapanime_list	objanime_faceopen2	;(10)
	mapanime_list	objanime_faceclose2	;(11)
	mapanime_list	objanime_yajirushi_up	;(12)
	mapanime_list	objanime_yajirushi_dw	;(13)
	mapanime_list	objanime_dmmy_3		;(14)
	mapanime_list	objanime_crash		;(15)
	mapanime_list	objanime_dmmy_1		;(16) <<<<< stepup >>>>>
	mapanime_list	objanime_meteor		;(17)
	mapanime_list	objanime_enemyplanetstart ;(18)
	mapanime_list	objanime_enemyplanet	;(19)
	mapanime_list	objanime_nextmark	;(20)
	mapanime_list	objanime_sosplanein	;(21)
	mapanime_list	objanime_bossappear	;(22)
	mapanime_list	objanime_bossopen	;(23)
	mapanime_list	objanime_battleship	;(24) :senkan normal
	mapanime_list	objanime_battleship_dap	;(25) :senkan hatsya
	mapanime_list	objanime_battleship_app	;(26) :senkan syutugen
	mapanime_list	objanime_finalboss_dap	;(27) :final boss
	mapanime_list	objanime_explode_zaco	;(28) :bakuhatu zaco enemy
	mapanime_list	objanime_explode_planet	;(29) :bakuhatu planet
	mapanime_list	objanime_explode_bship	;(30) :bakuhatu battle ship
	
;**************************************************************************
;;	MAP SPRITE ANIMATION OBJ TABLE
;**************************************************************************

objtable_d3_3

	mapanime_liststart

	mapanime_list	oam_clear		; clear object

	mapanime_list	oam_crash0		; crash animation
	mapanime_list	oam_crash1
	mapanime_list	oam_crash2
	mapanime_list	oam_crash3
	mapanime_list	oam_crash4
	mapanime_list	oam_crash5
	mapanime_list	oam_crash6

	mapanime_list	oam_yajirushi_dw0	; yajirushi anime !
	mapanime_list	oam_yajirushi_dw1
	mapanime_list	oam_yajirushi_dw2
	mapanime_list	oam_yajirushi_up0
	mapanime_list	oam_yajirushi_up1
	mapanime_list	oam_yajirushi_up2

	mapanime_list	umare_0			; sos umareru !
	mapanime_list	umare_1
	mapanime_list	umare_2

	mapanime_list	obj_d3_d_0		; sos umareru !
	mapanime_list	obj_d3_d_1
	mapanime_list	obj_d3_d_2
	mapanime_list	obj_d3_d_3
	mapanime_list	obj_d3_d_4
	mapanime_list	obj_d3_d_5
	mapanime_list	obj_d3_d_6

	mapanime_list	oam_big1		; big cursor
	mapanime_list	oam_big2
	mapanime_list	oam_big3

	mapanime_list	oam_small1		; small cursor
	mapanime_list	oam_small2
	mapanime_list	oam_small3
	mapanime_list	oam_small4

	mapanime_list	oam_bossship1		; mappause - ship
	mapanime_list	oam_bossship2		; mappause - ship
	mapanime_list	oam_bossship3		; mappause - ship
	mapanime_list	oam_bossship4		; mappause - ship
	mapanime_list	oam_battleship1
	mapanime_list	oam_battleship2
	mapanime_list	oam_battleship3
	mapanime_list	oam_battleship4

	mapanime_list	obj_d3_5_0
	mapanime_list	obj_d3_5_1
	mapanime_list	obj_d3_5_2
	mapanime_list	obj_d3_5_3
	mapanime_list	obj_d3_5_4
	mapanime_list	obj_d3_5_5
	mapanime_list	obj_d3_5_6
	mapanime_list	obj_d3_5_7

	mapanime_list	obj_d3_6_0
	mapanime_list	obj_d3_6_1
	mapanime_list	obj_d3_6_2
	mapanime_list	obj_d3_6_3
	mapanime_list	obj_d3_6_4
	mapanime_list	obj_d3_6_5
	mapanime_list	obj_d3_6_6
	mapanime_list	obj_d3_6_7
	mapanime_list	obj_d3_6_8
	mapanime_list	obj_d3_6_9
	mapanime_list	obj_d3_6_10
	mapanime_list	obj_d3_6_11

	mapanime_list	obj_d3_7_0
	mapanime_list	obj_d3_7_1
	mapanime_list	obj_d3_7_2
	mapanime_list	obj_d3_7_3
	mapanime_list	obj_d3_7_4
	mapanime_list	obj_d3_7_5
	mapanime_list	obj_d3_7_6
	mapanime_list	obj_d3_7_7
	mapanime_list	obj_d3_7_8
	mapanime_list	obj_d3_7_9

	mapanime_list	oam_faceopen0		; faceopen animation
	mapanime_list	oam_faceopen1
	mapanime_list	oam_faceopen2
	mapanime_list	oam_faceopen3
	mapanime_list	oam_faceopen4
	mapanime_list	oam_faceopen5

	mapanime_list	frashkaiten_0		; frash kaiten patern
	mapanime_list	frashkaiten_1	
	mapanime_list	frashkaiten_2
	mapanime_list	frashkaiten_3
	mapanime_list	frashkaiten_4
	mapanime_list	frashkaiten_5
	mapanime_list	frashkaiten_6
	mapanime_list	frashkaiten_7
	mapanime_list	kaiten_0		; kaiten patern
	mapanime_list	kaiten_1
	mapanime_list	kaiten_2
	mapanime_list	kaiten_3
	mapanime_list	kaiten_4
	mapanime_list	kaiten_5
	mapanime_list	kaiten_6
	mapanime_list	kaiten_7

	mapanime_list	oam_meteor1
	mapanime_list	oam_meteor2
	mapanime_list	oam_meteor3
	mapanime_list	oam_meteor4

	mapanime_list	obj_d3_11_0
	mapanime_list	obj_d3_11_1
	mapanime_list	obj_d3_11_2
	mapanime_list	obj_d3_11_3
	mapanime_list	obj_d3_11_4
	mapanime_list	obj_d3_11_5
	mapanime_list	obj_d3_11_6
	mapanime_list	obj_d3_11_7
	mapanime_list	obj_d3_11_8
	mapanime_list	obj_d3_11_9
	mapanime_list	obj_d3_11_10
	mapanime_list	obj_d3_11_11
	mapanime_list	obj_d3_11_12
	mapanime_list	obj_d3_11_13
	mapanime_list	obj_d3_11_16
	mapanime_list	obj_d3_11_17
	mapanime_list	obj_d3_11_18
	mapanime_list	obj_d3_11_19
	mapanime_list	obj_d3_11_20
	mapanime_list	obj_d3_11_21
	mapanime_list	obj_d3_11_22
	mapanime_list	obj_d3_11_23
	mapanime_list	obj_d3_11_24

	mapanime_list	obj_nextmark
	
	mapanime_list	obj_e3_2_0
	mapanime_list	obj_e3_2_1
	mapanime_list	obj_e3_2_2
	mapanime_list	obj_e3_2_3
	mapanime_list	obj_e3_2_4
	mapanime_list	obj_e3_2_5
	mapanime_list	obj_e3_2_6
	mapanime_list	obj_e3_2_7
	mapanime_list	obj_e3_2_8
	mapanime_list	obj_e3_2_9
	mapanime_list	obj_e3_2_10
	mapanime_list	obj_e3_2_11
	mapanime_list	obj_e3_2_12
	mapanime_list	obj_e3_2_13
	mapanime_list	obj_e3_2_14

	mapanime_list	obj_e3_3_0
	mapanime_list	obj_e3_3_1
	mapanime_list	obj_e3_3_2
	mapanime_list	obj_e3_3_3
	mapanime_list	obj_e3_3_4
	mapanime_list	obj_e3_3_5
	mapanime_list	obj_e3_3_6
	mapanime_list	obj_e3_3_7
	mapanime_list	obj_e3_3_8
	mapanime_list	obj_e3_3_9
	mapanime_list	obj_e3_3_10
	mapanime_list	obj_e3_3_11
	mapanime_list	obj_e3_3_12
	mapanime_list	obj_e3_3_13
	mapanime_list	obj_e3_3_14
	mapanime_list	obj_e3_3_15
	mapanime_list	obj_e3_3_16
	mapanime_list	obj_e3_3_17
	mapanime_list	obj_e3_3_18
	mapanime_list	obj_e3_3_19
	mapanime_list	obj_e3_3_20

	mapanime_list	obj_e3_4_0
	mapanime_list	obj_e3_4_1
	mapanime_list	obj_e3_4_2
	mapanime_list	obj_e3_4_3
	mapanime_list	obj_e3_4_4
	mapanime_list	obj_e3_4_5
	mapanime_list	obj_e3_4_6
	mapanime_list	obj_e3_4_7
	mapanime_list	obj_e3_4_8
	mapanime_list	obj_e3_4_9
	mapanime_list	obj_e3_4_10
	mapanime_list	obj_e3_4_11
	mapanime_list	obj_e3_4_12
	mapanime_list	obj_e3_4_13
	mapanime_list	obj_e3_4_14
	mapanime_list	obj_e3_4_15
	mapanime_list	obj_e3_4_16
	mapanime_list	obj_e3_4_17

	mapanime_listend



;**************************************************************************
;	animation dmmy
;**************************************************************************
objanime_dmmy_1
objanime_dmmy_2
objanime_dmmy_3
objanime_dmmy_4
	db	1,cd_oam_clear
	MAend

;**************************************************************************
;	objanime nextmark
;**************************************************************************

objanime_nextmark
	db	008,cd_obj_nextmark
	db	008,cd_oam_clear
	MAend

;---------------------------------------------------------------------------
obj_nextmark
	db	81h
	db	-4,-4,056h,030h

;**************************************************************************
;	mapanime sos BomB
;**************************************************************************

objanime_sosbomb	;(45)
;	db	004h,cd_kaiten_4
;	db	004h,cd_frashkaiten_4
;	db	004h,cd_kaiten_4
;	db	004h,cd_frashkaiten_4

	db	004h,cd_obj_d3_d_0 
	db	004h,cd_obj_d3_d_1 
	db	004h,cd_obj_d3_d_2 
	db	004h,cd_obj_d3_d_3
	db	004h,cd_obj_d3_d_4
	db	004h,cd_obj_d3_d_5
	db	004h,cd_obj_d3_d_6
	db	001h,cd_oam_clear
	MAend

;**************************************************************************
;	sptepup arrived at
;**************************************************************************
objanime_bossopen

	db	003h,cd_oam_bossship1
	db	003h,cd_oam_bossship3
	db	003h,cd_oam_bossship1
	db	003h,cd_oam_bossship3

	db	003h,cd_oam_bossship1
	db	003h,cd_oam_bossship3
	db	003h,cd_oam_bossship1
	db	003h,cd_oam_bossship3
	db	003h,cd_oam_bossship1

	db	002h,cd_oam_bossship3
	db	002h,cd_oam_bossship1
	db	002h,cd_oam_bossship3
	db	002h,cd_oam_bossship1
	db	002h,cd_oam_bossship3
	db	002h,cd_oam_bossship1
	db	002h,cd_oam_bossship3
	db	002h,cd_oam_bossship1
	db	002h,cd_oam_bossship3

	db	1,cd_oam_clear
	MAend

;--------------------------------------------------------------------------

objanime_bossappear
	db	20,cd_oam_bossship1	;20
	db	20,cd_oam_bossship2	;22
	db	20,cd_oam_bossship3	;23
	db	20,cd_oam_bossship4	;24
	MAend
;--------------------------------------------------------------------------
objanime_battleship
	db	20,cd_oam_battleship1	;20
	db	20,cd_oam_battleship2	;22
	db	20,cd_oam_battleship3	;23
	db	20,cd_oam_battleship4	;24
	MAend
;--------------------------------------------------------------------------
objanime_battleship_dap	;(32)
	db	4,cd_obj_d3_5_0
	db	4,cd_obj_d3_5_1
	db	4,cd_obj_d3_5_2
	db	4,cd_obj_d3_5_3
	db	4,cd_obj_d3_5_4
	db	4,cd_obj_d3_5_5
	db	4,cd_obj_d3_5_6
	db	4,cd_obj_d3_5_7
	MAend
;--------------------------------------------------------------------------
objanime_battleship_app	;(48 frame)
	db	4,cd_obj_d3_6_0
	db	4,cd_obj_d3_6_1
	db	4,cd_obj_d3_6_2
	db	4,cd_obj_d3_6_3
	db	4,cd_obj_d3_6_4
	db	4,cd_obj_d3_6_5
	db	4,cd_obj_d3_6_6
	db	4,cd_obj_d3_6_7
	db	4,cd_obj_d3_6_8
	db	4,cd_obj_d3_6_9
	db	4,cd_obj_d3_6_10
	db	4,cd_obj_d3_6_11
	MAend
;--------------------------------------------------------------------------
objanime_finalboss_dap	;(72 frame)
	db	020h,cd_obj_d3_7_0
	db	4+4,cd_obj_d3_7_1
	db	004h,cd_obj_d3_7_2
	db	004h,cd_obj_d3_7_3 
	db	004h,cd_obj_d3_7_4
	db	004h,cd_obj_d3_7_5
	db	004h,cd_obj_d3_7_6
	db	004h,cd_obj_d3_7_7
	db	004h,cd_obj_d3_7_8
	db	004h,cd_obj_d3_7_9
	MAend
;--------------------------------------------------------------------------

;**************************************************************************
;	start the sos enemy (1)
;**************************************************************************

objanime_sosplanein
;	db	004h,cd_kaiten_0
;	db	004h,cd_kaiten_1
;	db	004h,cd_kaiten_2
;	db	004h,cd_kaiten_3
;	db	004h,cd_kaiten_4
;	db	004h,cd_kaiten_5
;	db	004h,cd_kaiten_6
;	db	004h,cd_kaiten_7
;	db	004h,cd_kaiten_0

;	db	002h*8,cd_frashkaiten_1
;	db	002h*8,cd_frashkaiten_2
;	db	002h*8,cd_frashkaiten_3
;	db	002h*8,cd_frashkaiten_4
;	db	002h*8,cd_frashkaiten_5
;	db	002h*8,cd_frashkaiten_6
;	db	002h*8,cd_frashkaiten_7
;	db	002h*8,cd_frashkaiten_0
;	db	002h*8,cd_frashkaiten_1
;	db	002h*8,cd_frashkaiten_2
;	db	002h*8,cd_frashkaiten_3
;	db	002h*8,cd_frashkaiten_4
;	db	002h*8,cd_frashkaiten_5
;	db	002h*8,cd_frashkaiten_6
;	db	002h*8,cd_frashkaiten_7
;	db	002h*8,cd_frashkaiten_0

	db	004h,cd_umare_2
	db	004h,cd_umare_1
	db	004h,cd_umare_0
	MAend


;**************************************************************************
;	start the sos enemy (1)
;**************************************************************************

objanime_sos1 ;(80)
objanime_sos2 ;(80)

	db	004h,cd_umare_0
	db	004h,cd_umare_1
	db	004h,cd_umare_2
	db	002h,cd_frashkaiten_0
	db	002h,cd_frashkaiten_1
	db	002h,cd_frashkaiten_2
	db	002h,cd_frashkaiten_3
	db	002h,cd_frashkaiten_4
	db	002h,cd_frashkaiten_5
	db	002h,cd_frashkaiten_6
	db	002h,cd_frashkaiten_7
	db	002h,cd_frashkaiten_0
	db	002h,cd_frashkaiten_1
	db	002h,cd_frashkaiten_2
	db	002h,cd_frashkaiten_3
	db	002h,cd_frashkaiten_4
	db	002h,cd_frashkaiten_5
	db	002h,cd_frashkaiten_6
	db	002h,cd_frashkaiten_7
	db	004h,cd_kaiten_0
	db	004h,cd_kaiten_1
	db	004h,cd_kaiten_2
	db	004h,cd_kaiten_3
	db	004h,cd_kaiten_4
	db	004h,cd_kaiten_5
	db	004h,cd_kaiten_6
	db	004h,cd_kaiten_7
	db	004h,cd_kaiten_0
	MAend

;--------------------------------------------------------------------

;**************************************************************************
;	animation data
;**************************************************************************

objanime_bigcursor
	db	04,cd_oam_big1
	db	04,cd_oam_big2
	db	04,cd_oam_big3
	db	04,cd_oam_big2
	MAend

objanime_smallcursor
	db	04,cd_oam_small1
	db	04,cd_oam_small2
	db	04,cd_oam_small3
	db	04,cd_oam_small4
	MAend


objanime_meteor
	db	$10,cd_oam_meteor1
	db	$10,cd_oam_meteor2
	db	$10,cd_oam_meteor3
	db	$10,cd_oam_meteor4
	MAend

;**************************************************************************
;	enemy planet objdata
;**************************************************************************

;-----------------------------------------------------
objanime_enemyplanetstart
	db	002h,cd_oam_clear
	db	004h,cd_obj_d3_11_16 
	db	004h,cd_obj_d3_11_17 
	db	004h,cd_obj_d3_11_18 
	db	004h,cd_obj_d3_11_19 
	db	004h,cd_obj_d3_11_20 
	db	004h,cd_obj_d3_11_21 
	db	004h,cd_obj_d3_11_22 
	db	002h,cd_obj_d3_11_23 
	db	002h,cd_obj_d3_11_24
	MAend
;-----------------------------------------------------
objanime_enemyplanet
	db	002h,cd_obj_d3_11_0 
	db	002h,cd_obj_d3_11_1 
	db	002h,cd_obj_d3_11_2 
	db	002h,cd_obj_d3_11_3 
	db	002h,cd_obj_d3_11_4 
	db	002h,cd_obj_d3_11_5 
	db	002h,cd_obj_d3_11_6 
	db	002h,cd_obj_d3_11_7 
	db	002h,cd_obj_d3_11_8 
	db	002h,cd_obj_d3_11_9 
	db	002h,cd_obj_d3_11_10 
	db	002h,cd_obj_d3_11_11 
	db	002h,cd_obj_d3_11_4 
	db	002h,cd_obj_d3_11_5 
	db	002h,cd_obj_d3_11_6 
	db	002h,cd_obj_d3_11_7 
	MAend


;**************************************************************************
;*		Explode Pattern	(Zaco,Battleship,Planet)	*
;**************************************************************************
;-----------------------------------------------------
objanime_explode_zaco	;(62)
	db	002h,cd_obj_e3_2_0 
	db	002h,cd_obj_e3_2_1 
	db	002h,cd_obj_e3_2_2 
	db	002h,cd_obj_e3_2_3 
	db	002h,cd_obj_e3_2_4 
	db	002h,cd_obj_e3_2_5 
	db	002h,cd_obj_e3_2_6 
	db	002h,cd_obj_e3_2_1 
	db	002h,cd_obj_e3_2_2 
	db	002h,cd_obj_e3_2_3 
	db	002h,cd_obj_e3_2_4 
	db	002h,cd_obj_e3_2_5 
	db	002h,cd_obj_e3_2_7 
	db	008h,cd_oam_clear
	db	004h,cd_obj_e3_2_8 
	db	004h,cd_obj_e3_2_9 
	db	004h,cd_obj_e3_2_10 
	db	004h,cd_obj_e3_2_11 
	db	004h,cd_obj_e3_2_12 
	db	004h,cd_obj_e3_2_13 
	db	004h,cd_obj_e3_2_14 
	MAend
;-----------------------------------------------------
objanime_explode_planet	;(73)
	db	002h,cd_obj_e3_3_0 
	db	002h,cd_obj_e3_3_1 
	db	002h,cd_obj_e3_3_2 
	db	002h,cd_obj_e3_3_3 
	db	002h,cd_obj_e3_3_4 
	db	002h,cd_obj_e3_3_5 
	db	002h,cd_obj_e3_3_6 
	db	002h,cd_obj_e3_3_1 
	db	002h,cd_obj_e3_3_2 
	db	002h,cd_obj_e3_3_3 
	db	002h,cd_obj_e3_3_4 
	db	002h,cd_obj_e3_3_5 
	db	002h,cd_obj_e3_3_7 
	db	008h,cd_oam_clear
	db	003h,cd_obj_e3_3_8 
	db	003h,cd_obj_e3_3_9 
	db	003h,cd_obj_e3_3_10 
	db	003h,cd_obj_e3_3_11 
	db	003h,cd_obj_e3_3_12 
	db	003h,cd_obj_e3_3_13 
	db	003h,cd_obj_e3_3_14 
	db	003h,cd_obj_e3_3_15 
	db	003h,cd_obj_e3_3_16 
	db	003h,cd_obj_e3_3_17 
	db	003h,cd_obj_e3_3_18 
	db	003h,cd_obj_e3_3_19 
	db	003h,cd_obj_e3_3_20 
	MAend
;-----------------------------------------------------
objanime_explode_bship	;(64)
	db	002h,cd_obj_e3_4_0 
	db	002h,cd_obj_e3_4_1 
	db	002h,cd_obj_e3_4_2 
	db	002h,cd_obj_e3_4_3 
	db	002h,cd_obj_e3_4_4 
	db	002h,cd_obj_e3_4_5 
	db	002h,cd_obj_e3_4_6 
	db	002h,cd_obj_e3_4_1 
	db	002h,cd_obj_e3_4_2 
	db	002h,cd_obj_e3_4_3 
	db	002h,cd_obj_e3_4_4 
	db	002h,cd_obj_e3_4_5 
	db	002h,cd_obj_e3_4_7 
	db	008h,cd_oam_clear
	db	003h,cd_obj_e3_4_8 
	db	003h,cd_obj_e3_4_9 
	db	003h,cd_obj_e3_4_10 
	db	003h,cd_obj_e3_4_11 
	db	003h,cd_obj_e3_4_12 
	db	003h,cd_obj_e3_4_13 
	db	003h,cd_obj_e3_4_14 
	db	003h,cd_obj_e3_4_15 
	db	003h,cd_obj_e3_4_16 
	db	003h,cd_obj_e3_4_17 
	MAend
;-----------------------------------------------------




;-----------------------------------------------------
dbxx1	macro	
	db	\1
	db	\2
	db	\3
	db	\4&011101111b
	endm

obj_d3_11_0
	db	1
	dbxx1	0f0h,0f0h,0eah,039h

obj_d3_11_1
	db	1
	dbxx1	000h,0f0h,0eah,079h

obj_d3_11_2
	db	1
	dbxx1	000h,000h,0eah,0f9h

obj_d3_11_3
	db	1
	dbxx1	0f0h,000h,0eah,0b9h

obj_d3_11_4
	db	1
	dbxx1	0f0h,0f0h,0ech,039h

obj_d3_11_5
	db	1
	dbxx1	000h,0f0h,0ech,079h

obj_d3_11_6
	db	1
	dbxx1	000h,000h,0ech,0f9h

obj_d3_11_7
	db	1
	dbxx1	0f0h,000h,0ech,0b9h

obj_d3_11_8
	db	1
	dbxx1	0f0h,0f0h,0eeh,039h

obj_d3_11_9
	db	1
	dbxx1	000h,0f0h,0eeh,079h

obj_d3_11_10
	db	1
	dbxx1	000h,000h,0eeh,0f9h

obj_d3_11_11
	db	1
	dbxx1	0f0h,000h,0eeh,0b9h

obj_d3_11_12
	db	4
	dbxx1	000h,000h,04eh,031h
	dbxx1	0f0h,000h,04ch,031h
	dbxx1	000h,0f0h,02eh,031h
	dbxx1	0f0h,0f0h,02ch,031h

obj_d3_11_13
	db	2
	dbxx1	0f8h,010h,082h,030h
	dbxx1	0f8h,0f8h,0c0h,031h

obj_d3_11_16
	db	1
	dbxx1	0f8h,0f8h,068h,032h

obj_d3_11_17
	db	1
	dbxx1	0f8h,0f8h,06ah,032h

obj_d3_11_18
	db	1
	dbxx1	0f8h,0f8h,06ch,032h

obj_d3_11_19
	db	1
	dbxx1	0f8h,0f8h,06eh,032h

obj_d3_11_20
	db	4
	dbxx1	0feh,0feh,084h,0fah
	dbxx1	0f2h,0feh,084h,0bah
	dbxx1	0feh,0f2h,084h,07ah
	dbxx1	0f2h,0f2h,084h,03ah

obj_d3_11_21
	db	4
	dbxx1	000h,000h,084h,0fah
	dbxx1	0f0h,000h,084h,0bah
	dbxx1	000h,0f0h,084h,07ah
	dbxx1	0f0h,0f0h,084h,03ah

obj_d3_11_22
	db	4
	dbxx1	0f0h,000h,088h,0bah
	dbxx1	000h,000h,088h,0fah
	dbxx1	000h,0f0h,088h,07ah
	dbxx1	0f0h,0f0h,088h,03ah

obj_d3_11_23
	db	4
	dbxx1	0f0h,000h,00ch,0bbh
	dbxx1	000h,000h,00ch,0fbh
	dbxx1	000h,0f0h,00ch,07bh
	dbxx1	0f0h,0f0h,00ch,03bh

obj_d3_11_24
	db	4
	dbxx1	0f0h,000h,0ech,0b9h
	dbxx1	000h,000h,0ech,0f9h
	dbxx1	000h,0f0h,0ech,079h
	dbxx1	0f0h,0f0h,0ech,039h


;**************************************************************************
;	animation data
;**************************************************************************
;
;
;
;
;
;
;
;--------------------------------------------------------------------------
oam_big1	db	84h
	mapobj_oamdata	-16,-16,n,2,0,$55
	mapobj_oamdata	008,-16,h,2,0,$55
	mapobj_oamdata	-16,008,v,2,0,$55
	mapobj_oamdata	008,008,hv,2,0,$55
oam_big2	db	84h
	mapobj_oamdata	-15,-15,n,2,1,$55
	mapobj_oamdata	007,-15,h,2,1,$55
	mapobj_oamdata	-15,007,v,2,1,$55
	mapobj_oamdata	007,007,hv,2,1,$55
oam_big3	db	84h
	mapobj_oamdata	-14,-14,n,2,0,$55
	mapobj_oamdata	006,-14,h,2,0,$55
	mapobj_oamdata	-14,006,v,2,0,$55
	mapobj_oamdata	006,006,hv,2,0,$55

;--------------------------------------------------------------------------
oam_small1
	db	01
	mapobj_oamdata	-8,-8,n,2,0,$48
oam_small2
	db	01
	mapobj_oamdata	-8,-8,n,2,1,$48
oam_small3
	db	01
	mapobj_oamdata	-8,-8,n,2,0,$4a
oam_small4
	db	01
	mapobj_oamdata	-8,-8,n,2,1,$4a
;--------------------------------------------------------------------------
;--------------------------------------------------------------------------
oam_meteor1	db	05h
	mapobj_oamdata	-14,-08,n,2,0,$14a

	mapobj_oamdata	-16,-16,n,2,0,$12c
	mapobj_oamdata	000,-16,n,2,0,$12e
	mapobj_oamdata	-16,000,n,2,0,$14c
	mapobj_oamdata	000,000,n,2,0,$14e

oam_meteor2	db	05h
	mapobj_oamdata	-2,-08,n,2,0,$14a

	mapobj_oamdata	-16,-16,n,2,0,$12c
	mapobj_oamdata	000,-16,n,2,0,$12e
	mapobj_oamdata	-16,000,n,2,0,$14c
	mapobj_oamdata	000,000,n,2,0,$14e

oam_meteor3	db	05h
	mapobj_oamdata	-14,-08,v,2,0,$14a

	mapobj_oamdata	-16,-16,n,2,0,$12c
	mapobj_oamdata	000,-16,n,2,0,$12e
	mapobj_oamdata	-16,000,n,2,0,$14c
	mapobj_oamdata	000,000,n,2,0,$14e

oam_meteor4	db	05h
	mapobj_oamdata	-2,-08,v,2,0,$14a

	mapobj_oamdata	-16,-16,n,2,0,$12c
	mapobj_oamdata	000,-16,n,2,0,$12e
	mapobj_oamdata	-16,000,n,2,0,$14c
	mapobj_oamdata	000,000,n,2,0,$14e

;**************************************************************************
;	face open/close
;**************************************************************************

objanime_yajirushi_dw
	db	04,cd_oam_yajirushi_dw0
	db	04,cd_oam_yajirushi_dw1
	db	08,cd_oam_yajirushi_dw2
	MAend
objanime_yajirushi_up
	db	04,cd_oam_yajirushi_up0
	db	04,cd_oam_yajirushi_up1
	db	08,cd_oam_yajirushi_up2
	MAend



;-----------------------------------------------------------
oam_yajirushi_dw0
	db	4
	mapobj_oamdata	-16,-16-20,n,2,3,146h
	Mmapobjjmp	aaaa

;-----------------------------------------------------------
oam_yajirushi_dw1
	db	4
	mapobj_oamdata	-16,-16-22,n,2,3,146h
	mapobj_oamdata	000,-16-22,h,2,3,146h
	mapobj_oamdata	-16,000-22,n,2,3,148h
	mapobj_oamdata	000,000-22,h,2,3,148h
;-----------------------------------------------------------
oam_yajirushi_dw2
	db	4
	mapobj_oamdata	-16,-16-24,n,2,3,146h
	mapobj_oamdata	000,-16-24,h,2,3,146h
	mapobj_oamdata	-16,000-24,n,2,3,148h
	mapobj_oamdata	000,000-24,h,2,3,148h
;-----------------------------------------------------------
oam_yajirushi_up0
	db	4
	mapobj_oamdata	-16,-16+20,v,2,3,148h
	mapobj_oamdata	000,-16+20,hv,2,3,148h
	mapobj_oamdata	-16,000+20,v,2,3,146h
	mapobj_oamdata	000,000+20,hv,2,3,146h
;-----------------------------------------------------------
oam_yajirushi_up1
	db	4
	mapobj_oamdata	-16,-16+22,v,2,3,148h
	mapobj_oamdata	000,-16+22,hv,2,3,148h
	mapobj_oamdata	-16,000+22,v,2,3,146h
	mapobj_oamdata	000,000+22,hv,2,3,146h
;-----------------------------------------------------------
oam_yajirushi_up2
	db	4
	mapobj_oamdata	-16,-16+24,v,2,3,148h
	mapobj_oamdata	000,-16+24,hv,2,3,148h
	mapobj_oamdata	-16,000+24,v,2,3,146h
	mapobj_oamdata	000,000+24,hv,2,3,146h
;-----------------------------------------------------------
aaaa	mapobj_oamdata	000,-16-20,h,2,3,146h
	mapobj_oamdata	-16,000-20,n,2,3,148h
	mapobj_oamdata	000,000-20,h,2,3,148h

;-----------------------------------------------------------



;**************************************************************************
;	crash object
;**************************************************************************

objanime_crash
	db	8,cd_oam_crash0
	db	8,cd_oam_crash1
	db	8,cd_oam_crash2
	db	8,cd_oam_crash3
	db	8,cd_oam_crash4
	db	8,cd_oam_crash5
	db	8,cd_oam_crash6
	MAend

;-----------------------------------------------------------
crash_pos0	equ	0f0f0h	
crash_pos1	equ	0f404h
crash_pos2	equ	000f8h

crash_ptn0	equ	2868h	;(0)
crash_ptn1	equ	286ah	;(1)
crash_ptn2	equ	286ch	;(2)
crash_ptn3	equ 	2a6eh	;(3)
crash_ptn4	equ 	2e6eh	;(4)
crash_ptn5	equ	2e4eh	;(5)
;-----------------------------------------------------------


oam_crash0
	db	3
	dw	crash_pos0,crash_ptn0
	dw	crash_pos1,crash_ptn5
	dw	crash_pos2,crash_ptn3

oam_crash1
	db	2
	dw	crash_pos0,crash_ptn1
	dw	crash_pos2,crash_ptn4

oam_crash2
	db	3
	dw	crash_pos0,crash_ptn2
	dw	crash_pos1,crash_ptn0
	dw	crash_pos2,crash_ptn5

oam_crash3
	db	2
	dw	crash_pos0,crash_ptn3
	dw	crash_pos1,crash_ptn1

oam_crash4
	db	3
	dw	crash_pos0,crash_ptn4
	dw	crash_pos1,crash_ptn2
	dw	crash_pos2,crash_ptn0

oam_crash5
	db	3
	dw	crash_pos0,crash_ptn5
	dw	crash_pos1,crash_ptn3
	dw	crash_pos2,crash_ptn1

oam_crash6
	db	2
	dw	crash_pos1,crash_ptn4
	dw	crash_pos2,crash_ptn2






;**************************************************************************
;	face open/close
;**************************************************************************

objanime_faceopen2
	db	03,cd_oam_faceopen5
	db	03,cd_oam_faceopen4
	db	03,cd_oam_faceopen3
	db	03,cd_oam_faceopen2
	db	03,cd_oam_faceopen1
	db	03,cd_oam_faceopen1
	db	01,cd_oam_clear
	MAend

objanime_faceopen
	db	01,cd_oam_clear
	db	04,cd_oam_faceopen5
	db	04,cd_oam_faceopen4
	db	03,cd_oam_faceopen3
	db	03,cd_oam_faceopen2
	db	03,cd_oam_faceopen1
	db	08,cd_oam_faceopen1
	db	01,cd_oam_clear
	MAend

objanime_faceclose
	db	10,cd_oam_clear
objanime_faceclose2
	db	12,cd_oam_clear
	db	03,cd_oam_faceopen1
	db	03,cd_oam_faceopen1
	db	03,cd_oam_faceopen2
	db	03,cd_oam_faceopen3
	db	03,cd_oam_faceopen4
	db	03,cd_oam_faceopen5
	db	01,cd_oam_clear
	MAend


;--------------------------------------------------------------------------
oam_clear	
	db	0

;--------------------------------------------------------------------------
oam_faceopen0
	db	6
	mapobj_oamdata	-16,-24,n,2,0,140h
	mapobj_oamdata	000,-24,h,2,0,140h
	mapobj_oamdata	-16,-08,n,2,0,142h
	mapobj_oamdata	000,-08,h,2,0,142h
	mapobj_oamdata	-16,008,n,2,0,144h
	mapobj_oamdata	000,008,h,2,0,144h

;--------------------------------------------------------------------------
oam_faceopen1
	db	4
	mapobj_oamdata	-16,-16,n,2,0,140h
	mapobj_oamdata	000,-16,h,2,0,140h
	mapobj_oamdata	-16,000,n,2,0,144h
	mapobj_oamdata	000,000,h,2,0,144h

;--------------------------------------------------------------------------
oam_faceopen2
	db	4
	mapobj_oamdata	-16,-12,v,2,0,144h
	mapobj_oamdata	000,-12,hv,2,0,144h
	mapobj_oamdata	-16,-00,n,2,0,144h
	mapobj_oamdata	000,-00,h,2,0,144h

;--------------------------------------------------------------------------
oam_faceopen3
	db	88h
	mapobj_oamdata	-16,-08,v,2,0,154h
	mapobj_oamdata	-08,-08,v,2,0,155h
	mapobj_oamdata	000,-08,hv,2,0,155h
	mapobj_oamdata	008,-08,hv,2,0,154h
	mapobj_oamdata	-16,000,n,2,0,154h
	mapobj_oamdata	-08,000,n,2,0,155h
	mapobj_oamdata	000,000,h,2,0,155h
	mapobj_oamdata	008,000,h,2,0,154h

;--------------------------------------------------------------------------
oam_faceopen4
	db	84h
	mapobj_oamdata	-16,-04,n,2,0,44h
	mapobj_oamdata	-08,-04,n,2,0,44h
	mapobj_oamdata	000,-04,n,2,0,44h
	mapobj_oamdata	008,-04,n,2,0,44h

;--------------------------------------------------------------------------
oam_faceopen5
	db	82h
	mapobj_oamdata	-08,-04,n,2,0,54h
	mapobj_oamdata	-00,-04,h,2,0,54h

;--------------------------------------------------------------------------

;**************************************************************************
;		OBJ data
;**************************************************************************
bossship_common
	Mmapobj16
	db	004h,20h
	db	004h,60h
	db	006h,20h
	db	006h,60h

oam_bossship1
	Mmapobjbig	5
	db	0f6h,0f8h,00ah,000h+20h
 	Mmapobjjmp	bossship_common
oam_bossship2
	Mmapobjbig	5
	db	0fah,0f8h,00ah,040h+20h
	Mmapobjjmp	bossship_common
oam_bossship3
	Mmapobjbig	5
	db	0f6h,0f8h,00ah,080h+20h
	Mmapobjjmp	bossship_common
oam_bossship4
	Mmapobjbig	5
	db	0fah,0f8h,00ah,0c0h+20h
	Mmapobjjmp	bossship_common
;---------------------------------------------------------------
battleship_common
	Mmapobj16
	SprChrDataW	$100,colpal0,pri2,noflip,0
	SprChrDataW	$102,colpal0,pri2,noflip,0
	SprChrDataW	$104,colpal0,pri2,noflip,0
	SprChrDataW	$106,colpal0,pri2,noflip,0

oam_battleship1
	Mmapobjbig	5
	SpriteDataW	-8,-8,$008,colpal0,pri2,noflip,0
	Mmapobjjmp	battleship_common
oam_battleship2
	Mmapobjbig	5
	SpriteDataW	-8,-8,$008,colpal0,pri2,xflip,0
	Mmapobjjmp	battleship_common
oam_battleship3
	Mmapobjbig	5
	SpriteDataW	-8,-8,$008,colpal0,pri2,yflip,0
	Mmapobjjmp	battleship_common
oam_battleship4
	Mmapobjbig	5
	SpriteDataW	-8,-8,$008,colpal0,pri2,xyflip,0
	Mmapobjjmp	battleship_common

;---------------------------------------------------------------
obj_d3_5_0
	Mmapobjbig	1
	db	0f8h,0f8h,040h,036h
obj_d3_5_1
	Mmapobjbig	2
	db	0f8h,0f8h,040h,036h
	db	0f8h,0f8h,06ch,03eh
obj_d3_5_2
	Mmapobjbig	2
	db	0f8h,0f8h,040h,036h
	db	0f8h,0f8h,06eh,03eh
obj_d3_5_3
	Mmapobjbig	5
	db	0f8h,0f8h,040h,038h
	db	0feh,0feh,084h,0feh
	db	0feh,0f2h,084h,07eh
	db	0f2h,0feh,084h,0beh
	db	0f2h,0f2h,084h,03eh
obj_d3_5_4
	Mmapobjbig	1
	db	0f8h,0f8h,06ch,038h
obj_d3_5_5
	Mmapobjbig	1
	db	0f8h,0f8h,06ah,038h
obj_d3_5_6
	Mmapobjbig	1
	db	0f8h,0f8h,068h,038h
obj_d3_5_7
	Mmapobjbig	1
	db	0f8h,0f8h,068h,038h
;---------------------------------------------------------------
obj_d3_6_0
	Mmapobjbig	1
	db	0f8h,0f8h,068h,038h

obj_d3_6_1
	Mmapobjbig	1
	db	0f8h,0f8h,06ah,038h

obj_d3_6_2
	Mmapobjbig	1
	db	0f8h,0f8h,06ch,038h

obj_d3_6_3
	Mmapobjbig	1
	db	0f8h,0f8h,06eh,038h

obj_d3_6_4
	Mmapobjbig	5
	db	0f8h,0f8h,06ah,078h
	db	0f2h,0feh,084h,0b8h
	db	0f2h,0f2h,084h,038h
	db	0feh,0feh,084h,0f8h
	db	0feh,0f2h,084h,078h

obj_d3_6_5
	Mmapobjbig	5
	db	0f8h,0f8h,06ch,038h
	db	0f0h,000h,084h,0bah
	db	0f0h,0f0h,084h,03ah
	db	000h,000h,084h,0fah
	db	000h,0f0h,084h,07ah

obj_d3_6_6
	Mmapobjbig	5
	db	0f8h,0f8h,06eh,03ch
	db	000h,0f0h,088h,07ch
	db	000h,000h,088h,0fch
	db	0f0h,000h,088h,0bch
	db	0f0h,0f0h,088h,03ch

obj_d3_6_7
	Mmapobjbig	16
	db	000h,000h,006h,035h
	db	0f0h,000h,004h,035h
	db	000h,0f0h,002h,035h
	db	0f0h,0f0h,000h,035h
	db	000h,010h,08eh,0feh
	db	0f0h,010h,08eh,0beh
	db	010h,000h,08ah,0feh
	db	000h,000h,08ch,07eh
	db	0e0h,000h,08ah,0beh
	db	0f0h,000h,08ch,03eh
	db	010h,0f0h,08ah,07eh
	db	000h,0e0h,08eh,07eh
	db	000h,0f0h,08ch,07eh
	db	0f0h,0e0h,08eh,03eh
	db	0e0h,0f0h,08ah,03eh
	db	0f0h,0f0h,08ch,03eh

obj_d3_6_8
	Mmapobjbig	8
	db	000h,000h,006h,035h
	db	0f0h,000h,004h,035h
	db	000h,0f0h,002h,035h
	db	0f0h,0f0h,000h,035h
	db	000h,0f0h,088h,07eh
	db	000h,000h,088h,0feh
	db	0f0h,000h,088h,0beh
	db	0f0h,0f0h,088h,03eh

obj_d3_6_9
	Mmapobjbig	8
	db	000h,000h,006h,035h
	db	0f0h,000h,004h,035h
	db	000h,0f0h,002h,035h
	db	0f0h,0f0h,000h,035h
	db	0f0h,000h,084h,0beh
	db	000h,000h,084h,0feh
	db	000h,0f0h,084h,07eh
	db	0f0h,0f0h,084h,03eh

obj_d3_6_10
	Mmapobjbig	8
	db	000h,000h,006h,035h
	db	0f0h,000h,004h,035h
	db	000h,0f0h,002h,035h
	db	0f0h,0f0h,000h,035h
	db	0f2h,0feh,084h,0beh
	db	0feh,0feh,084h,0feh
	db	0feh,0f2h,084h,07eh
	db	0f2h,0f2h,084h,03eh

obj_d3_6_11
	Mmapobjbig	4
	db	000h,000h,006h,031h
	db	0f0h,000h,004h,031h
	db	000h,0f0h,002h,031h
	db	0f0h,0f0h,000h,031h
;--------------------------------------------------------------------------

obj_d3_7_0
	Mmapobjbig	4
	db	000h,000h,006h,070h
	db	000h,0f0h,004h,070h
	db	0f0h,000h,006h,030h
	db	0f0h,0f0h,004h,030h

obj_d3_7_1
	Mmapobjbig	8
	db	000h,000h,006h,070h
	db	000h,0f0h,004h,070h
	db	0f0h,000h,006h,030h
	db	0f0h,0f0h,004h,030h
	db	000h,000h,084h,0fah
	db	0f0h,000h,084h,0bah
	db	000h,0f0h,084h,07ah
	db	0f0h,0f0h,084h,03ah

obj_d3_7_2
	Mmapobjbig	8
	db	0f0h,0f0h,004h,030h
	db	0f0h,000h,006h,030h
	db	000h,000h,006h,070h
	db	000h,0f0h,004h,070h
	db	000h,0f0h,088h,07ah
	db	000h,000h,088h,0fah
	db	0f0h,000h,088h,0bah
	db	0f0h,0f0h,088h,03ah

obj_d3_7_3
	Mmapobjbig	8
	db	0f0h,0f0h,004h,038h
	db	0f0h,000h,006h,038h
	db	000h,000h,006h,078h
	db	000h,0f0h,004h,078h
	db	0f0h,0f0h,088h,038h
	db	0f0h,000h,088h,0b8h
	db	000h,000h,088h,0f8h
	db	000h,0f0h,088h,078h

obj_d3_7_4
	Mmapobjbig	4
	db	0f0h,000h,084h,0b8h
	db	000h,000h,084h,0f8h
	db	000h,0f0h,084h,078h
	db	0f0h,0f0h,084h,038h

obj_d3_7_5
	Mmapobjbig	4
	db	0f2h,0feh,084h,0b8h
	db	0feh,0feh,084h,0f8h
	db	0feh,0f2h,084h,078h
	db	0f2h,0f2h,084h,038h

obj_d3_7_6
	Mmapobjbig	1
	db	0f8h,0f8h,06eh,038h

obj_d3_7_7
	Mmapobjbig	1
	db	0f8h,0f8h,06ch,038h

obj_d3_7_8
	Mmapobjbig	1
	db	0f8h,0f8h,06ah,038h

obj_d3_7_9
	Mmapobjbig	1
	db	0f8h,0f8h,068h,038h
;**************************************************************************
;	OBJ data
; 	umareru animation
;**************************************************************************

umare_0	db	1
	db	0f8h,0f8h,068h,024h

umare_1	db	1
	db	0f8h,0f8h,06ah,024h

umare_2	db	1
	db	0f8h,0f8h,06ch,024h

;**************************************************************************
;;
;;	STEPUP	KUN no OBJ blockdata
;;	SOS 	KUN
;;	SHIP	KUN
;;	GUARD	KUN
;;
;**************************************************************************
dbax	macro
	db	(-(\1+10h))&0ffh
	db	\2
	db	\3
	db	(\4)+40h
	endm

;===========================================================

frashkaiten_0
	db	1
	Msetmapdemo	0
;------------------------------------------------------------
frashkaiten_1
	db	1
	Msetmapdemo	2
;------------------------------------------------------------
frashkaiten_2
	db	1
	Msetmapdemo	4
;------------------------------------------------------------
frashkaiten_3
	db	1
	Msetmapdemo	6
;------------------------------------------------------------
frashkaiten_4
	db	1
	Msetmapdemo	8
;------------------------------------------------------------
frashkaiten_5
	db	1
	Msetmapdemo	6+4000h
;------------------------------------------------------------
frashkaiten_6
	db	1
	Msetmapdemo	4+4000h
;------------------------------------------------------------
frashkaiten_7
	db	1
	Msetmapdemo	2+4000h
;------------------------------------------------------------
kaiten_0
	db	1
	Msetmapchar	0
;------------------------------------------------------------
kaiten_1
	db	1
	Msetmapchar	2
;------------------------------------------------------------
kaiten_2
	db	1
	Msetmapchar	4
;------------------------------------------------------------
kaiten_3
	db	1
	Msetmapchar	6
;------------------------------------------------------------
kaiten_4
	db	1
	Msetmapchar	8
;------------------------------------------------------------
kaiten_5
	db	1
	Msetmapchar	6+4000h
;------------------------------------------------------------
kaiten_6
	db	1
	Msetmapchar	4+4000h
;------------------------------------------------------------
kaiten_7
	db	1
	Msetmapchar	2+4000h
;------------------------------------------------------------

;**************************************************************************
;	BAKUHATSU ANIMATION DATA
;**************************************************************************

obj_d3_d_0	;(1)
	db	1
	db	0f8h,0f8h,020h,029h

obj_d3_d_1	;(4)
	db	4
	db	0fch,0f4h,020h,029h
	db	0fch,0fch,020h,029h
	db	0f4h,0fch,020h,029h
	db	0f4h,0f4h,020h,029h

obj_d3_d_2	;(4)
	db	4
	db	0f0h,000h,00ah,0e9h
	db	000h,000h,008h,0e9h
	db	000h,0f0h,00ah,029h
	db	0f0h,0f0h,008h,029h

obj_d3_d_3	;(8)
	db	8
	db	0ffh,0f1h,00ah,02bh
	db	0ffh,0ffh,008h,0ebh
	db	0f1h,0ffh,00ah,0ebh
	db	0f1h,0f1h,008h,02bh
	db	0f0h,000h,00eh,0e3h
	db	000h,000h,00ch,0e3h
	db	000h,0f0h,00eh,023h
	db	0f0h,0f0h,00ch,023h

obj_d3_d_4	;(8)
	db	8
	db	0f0h,000h,00ch,0a3h
	db	0f0h,0f0h,00eh,063h
	db	000h,0f0h,00ch,063h
	db	000h,000h,00eh,0a3h
	db	0f1h,0ffh,008h,0adh
	db	0f1h,0f1h,00ah,06dh
	db	0ffh,0f1h,008h,06dh
	db	0ffh,0ffh,00ah,0adh

obj_d3_d_5	;(4)
	db	4
	db	0feh,0f2h,00eh,021h
	db	0f2h,0f2h,00ch,021h
	db	0feh,0feh,00ch,0e1h
	db	0f2h,0feh,00eh,0e1h

obj_d3_d_6	;(4)
	db	4
	db	0f0h,000h,022h,0a1h
	db	000h,000h,022h,0e1h
	db	000h,0f0h,022h,061h
	db	0f0h,0f0h,022h,021h

;---------------------------------------------------------------------
;* Zaco Enemy , Battle Ship , Planet Common Anime Data		*
;---------------------------------------------------------------------
obj_e3_2_0
obj_e3_3_0
obj_e3_4_0
	Mmapobjbig	1
	db	0f5h,0f4h,068h,038h

obj_e3_2_1
obj_e3_3_1
obj_e3_4_1
	Mmapobjbig	1
	db	0f5h,0f4h,06ah,038h

obj_e3_2_2
obj_e3_3_2
obj_e3_4_2
	Mmapobjbig	2
	db	0fch,0f6h,068h,038h
	db	0f5h,0f4h,06ah,036h

obj_e3_2_3
obj_e3_3_3
obj_e3_4_3
	Mmapobjbig	1
	db	0fch,0f6h,06ah,038h

obj_e3_2_4
obj_e3_3_4
obj_e3_4_4
	Mmapobjbig	2
	db	0f7h,0fbh,068h,038h
	db	0fch,0f6h,06ah,036h

obj_e3_2_5
obj_e3_3_5
obj_e3_4_5
	Mmapobjbig	1
	db	0f7h,0fch,06ah,038h

obj_e3_2_6
obj_e3_3_6
obj_e3_4_6
	Mmapobjbig	2
	db	0f5h,0f4h,068h,038h
	db	0f7h,0fch,06ah,036h

obj_e3_2_7
obj_e3_3_7
obj_e3_4_7
	Mmapobjbig	1
	db	0f7h,0fch,06ah,036h

obj_e3_2_8
obj_e3_3_8
obj_e3_4_8
	Mmapobjbig	1
	db	0f8h,0f8h,068h,038h

obj_e3_2_9
obj_e3_3_9
obj_e3_4_9
	Mmapobjbig	1
	db	0f8h,0f8h,06ah,038h

obj_e3_2_10
obj_e3_3_10
obj_e3_4_10
	Mmapobjbig	1
	db	0f8h,0f8h,06ch,038h

obj_e3_2_11
obj_e3_4_11
	Mmapobjbig	1
	db	0f8h,0f8h,008h,037h

;---------------------------------------------------------------------
;( Zaco Enemy )
obj_e3_2_12
	Mmapobjbig	1
	db	0f8h,0f8h,00ah,037h

obj_e3_2_13
	Mmapobjbig	1
	db	0f8h,0f8h,00ch,037h

obj_e3_2_14
	Mmapobjbig	1
	db	0f8h,0f8h,00eh,037h
;---------------------------------------------------------------------
;( Planet )
obj_e3_3_11
	Mmapobjbig	1
	db	0f8h,0f8h,06eh,038h

obj_e3_3_12
	Mmapobjbig	4
	db	0f2h,0feh,084h,0b8h
	db	0feh,0feh,084h,0f8h
	db	0feh,0f2h,084h,078h
	db	0f2h,0f2h,084h,038h

obj_e3_3_13
	Mmapobjbig	4
	db	0f0h,000h,084h,0b8h
	db	000h,000h,084h,0f8h
	db	000h,0f0h,084h,078h
	db	0f0h,0f0h,084h,038h

obj_e3_3_14
	Mmapobjbig	4
	db	0f0h,000h,088h,0b8h
	db	000h,000h,088h,0f8h
	db	000h,0f0h,088h,078h
	db	0f0h,0f0h,088h,038h

obj_e3_3_15
	Mmapobjbig	4
	db	0f8h,0fch,06eh,038h
	db	0feh,0f8h,06eh,038h
	db	0f2h,0f8h,06eh,038h
	db	0f8h,0f4h,06eh,038h

obj_e3_3_16
	Mmapobjbig	4
	db	0f8h,0fch,06ch,038h
	db	002h,0f8h,06ch,038h
	db	0eeh,0f8h,06ch,038h
	db	0f8h,0f4h,06ch,038h

obj_e3_3_17
	Mmapobjbig	7
	db	005h,0f8h,06ch,038h
	db	0ebh,0f8h,06ch,038h
	db	008h,0f8h,06ah,038h
	db	0e8h,0f8h,06ah,038h
	db	0ffh,0f8h,06ah,038h
	db	0f1h,0f8h,06ah,038h
	db	0f8h,0f8h,06ah,038h

obj_e3_3_18
	Mmapobjbig	7
	db	006h,0f8h,06ah,038h
	db	00bh,0f8h,068h,038h
	db	0eah,0f8h,06ah,038h
	db	0e5h,0f8h,068h,038h
	db	002h,0f8h,086h,038h
	db	0eeh,0f8h,086h,038h
	db	0f8h,0f8h,068h,038h

obj_e3_3_19
	Mmapobjbig	7
	db	0f8h,0f8h,068h,03ah
	db	0e7h,0f8h,06ah,03ah
	db	009h,0f8h,06ah,03ah
	db	00dh,0f8h,068h,03ah
	db	0e3h,0f8h,068h,03ah
	db	004h,0f8h,068h,03ah
	db	0ech,0f8h,068h,03ah

obj_e3_3_20
	Mmapobjbig	2
	db	00ch,0f8h,068h,03ah
	db	0e4h,0f8h,068h,03ah
;---------------------------------------------------------------------
;( Battle Ship)
obj_e3_4_12
	Mmapobjbig	4
	db	0f7h,0fah,008h,037h
	db	0fch,0f8h,06ch,038h
	db	0f9h,0f6h,008h,037h
	db	0f0h,0f8h,06ah,038h

obj_e3_4_13
	Mmapobjbig	4
	db	0f7h,0fdh,00ah,037h
	db	0f0h,0f7h,06ch,038h
	db	000h,0f9h,008h,037h
	db	0f9h,0f3h,00ah,037h

obj_e3_4_14
	Mmapobjbig	4
	db	0f7h,0fdh,00ch,037h
	db	0f0h,0f8h,008h,037h
	db	000h,0f8h,00ah,037h
	db	0f9h,0f3h,00ch,037h

obj_e3_4_15
	Mmapobjbig	4
	db	0f7h,0fch,00eh,037h
	db	0f2h,0f8h,00ah,037h
	db	0feh,0f8h,00ch,037h
	db	0f9h,0f4h,00eh,037h

obj_e3_4_16
	Mmapobjbig	2
	db	0fah,0f8h,00ch,077h
	db	0f6h,0f8h,00eh,077h

obj_e3_4_17
	Mmapobjbig	1
	db	0f8h,0f8h,00eh,037h

;==========================================================================
; END END END END END END END END END END END END END END END END END END  
;==========================================================================
