;*********************************************************************
;*								*
;*	------------------------				*
;*		STARFOX2 					*
;*	------------------------				*
;*								*
;*	File 		: mrain.mc				*
;* 	Description	: 2d rain progaram test			*
;*	Date		: 1994.11.29				*
;*	Author		: H.Yajima				*
;*								*
;*********************************************************************
;;
;;
;;
;;
;*********************************************************************
;	parameter
;*********************************************************************

SWrain = 0
raincount	equ	50

;*********************************************************************
;	-----------------
;	 raindraw macros
;	-----------------
;*********************************************************************


Mraindraw	macro

	plot
	dec	r1
	inc	r2
	plot
	dec	r1
	dec	r1
	inc	r2

	plot
	dec	r1
	inc	r2
	plot
	dec	r1
	dec	r1
	inc	r2

	plot
	dec	r1
	inc	r2
	plot
	dec	r1
	dec	r1
	inc	r2
	
	plot
	dec	r1
	inc	r2
	plot
	dec	r1
	dec	r1
	inc	r2

	endm



;*********************************************************************
;	-----------------
;	 raindraw main progarm
;	-----------------
;*********************************************************************

m_testrain

;=====================================================================

	ifeq	SWrain

	Mstop

	elseif

;=====================================================================

	mcache 

	iwt	r10,#m_rainbuffer&WM	; set ram pointer

;--------------------------------------------------------------
; initialize check
;--------------------------------------------------------------

	Mlda	m_rainflag
	moves	r0,r0
	beq	m_testrain_init
	nop

;--------------------------------------------------------------
; main program
;--------------------------------------------------------------

	iwt	r7,#0b0h	; MAX (Y) 
	iwt	r6,#010h	; MIN (Y)
	iwt	r5,#0d0h	; MAX (X)
	iwt	r4,#010h	; MIN (X)

	Msetcolor	0eh		; set color

	iwt	r12,#raincount
	moves	r13,r15

;--------------------------------------------------------------

	ldb	[r10]
	sub	#4		; X = X-4
	cmp	r5		; CMP MAX
	bcs	.limit
	nop
	cmp	r4		; CMP MIN
	bcs	.skip
	nop
.limit	move	r0,r5		; <=== set max !
.skip	stb	[r10]		
	inc	r10		; RAMaddr++
	move	r1,r0		; r1 = Xposition

;--------------------------------------------------------------

	ldb	[r10]
	add	#8		; Y = X+4
	cmp	r7		; CMP MAX
	bcs	.limit2
	nop
	cmp	r6		; CMP MIN
	bcs	.skip2
	nop
.limit2	move	r0,r6		; <=== set min !
.skip2	stb	[r10]
	inc	r10		; RAMaddr++
	move	r2,r0		; r2 = Yposition

;--------------------------------------------------------------

	Mraindraw

;--------------------------------------------------------------

	loop
	nop

;--------------------------------------------------------------

	Mstop

;=====================================================================

	endc





;*********************************************************************
;	-----------------
;	 rain initialize
;	-----------------
;*********************************************************************
;
; r10 = RAM pointer
;
;---------------------------------------------------------------------

m_testrain_init

	with	r8
	sub	r8

	Mjsr	Lrandom_parameter	; random initialize

	iwt	r12,#raincount		; 128 loop
	move	r13,r15			
;---------------------------------------

	Mjsr	Lrandom_prog
	from	r8
	lob
	stb	[r10]
	inc	r10

	Mjsr	Lrandom_prog
	from	r8
	lob
	stb	[r10]
	inc	r10

;---------------------------------------
	loop
	nop

	Minc	m_rainflag

	Mstop

;====================================================================
;;
;;
;;
;;
;;
;;
;;
;;
;;
;;====================================================================
;;====================================================================
;;	rain test program
;;====================================================================
;;====================================================================

